#============================================================= -*-perl-*-
#
# BackupPC::CGI::RestoreInfo package
#
# DESCRIPTION
#
#   This module implements the RestoreInfo action for the CGI interface.
#
# AUTHOR
#   Craig Barratt  <cbarratt@users.sourceforge.net>
#
# COPYRIGHT
#   Copyright (C) 2003-2020  Craig Barratt
#
#   This program is free software: you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#========================================================================
#
# Version 4.4.0, released 20 Jun 2020.
#
# See http://backuppc.sourceforge.net.
#
#========================================================================

package BackupPC::CGI::RestoreInfoJSON;

use strict;
use BackupPC::CGI::Lib qw(:all);
use Encode qw/decode_utf8/;
use JSON::XS;

sub ErrorJSON {
    my ( $msg ) = @_;
    my %err;
    $err{-1} = $msg;
    print "Content-type: application/json; charset=utf-8\n\n";
    print encode_json(\%err);
    exit();
}


sub action
{
    my $Privileged = CheckPermission($In{host});
    my $host       = $1 if ( $In{host} =~ /(.*)/ );
    my $num        = $In{num};
    my $i;

    if ( !$Privileged ) {
        ErrorJSON("You can't view restores info of this host");
    }
    #
    # Find the requested restore
    #
    my @Restores = $bpc->RestoreInfoRead($host);
    my @result;
    for ( $i = 0 ; $i < @Restores ; $i++ ) {
        %RestoreReq = ();
        do "$TopDir/pc/$host/RestoreInfo.$Restores[$i]{num}"
            if ( -f "$TopDir/pc/$host/RestoreInfo.$Restores[$i]{num}" );
        # The num key exists in both restore & request info, rename request num key as backup
        if (exists $RestoreReq{num}) {
            $RestoreReq{backup} = $RestoreReq{num};
            delete $RestoreReq{num};
        }
        my %info = (%{$Restores[$i]}, %RestoreReq);
	my @fileListStr;
	foreach my $path (@{$info{fileList}}) {
		push @fileListStr, decode_utf8($path);
	}
	$info{fileList} = \@fileListStr;
	foreach my $key (keys %info) {
            unless ( ref($info{$key}) ) {
                $info{$key} = decode_utf8($info{$key});
            }
	}

        push @result, \%info;
    }
    print "Content-type: application/json; charset=utf-8\n\n";
    print encode_json(\@result);
}

1;
