#!/usr/bin/perl
#============================================================= -*-perl-*-w
#
# ee-backuppc-api: API interface for BackupPC.
#
# Based on Craig Barratt BackupPC_Admin file from upstream backuppc sources:
#
# COPYRIGHT
#   Copyright (C) 2001-2020  Craig Barratt
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#========================================================================

use strict;
no utf8;

use CGI;
use CGI::Carp qw(fatalsToBrowser);
use lib "/usr/share/backuppc/lib";

use BackupPC::Lib;
use BackupPC::CGI::Lib qw(:all);

BackupPC::CGI::Lib::NewRequest;

my %ActionDispatch = (
    "stats"                => "Stats",
    "browsejson"           => "BrowseJSON",
    "RestoreFileJSON"      => "RestoreFileJSON",
    "RestoreJSON"          => "RestoreJSON",
    "RestoreInfoJSON"      => "RestoreInfoJSON",
    "HostStatusJSON"       => "HostStatusJSON",
);

#
# Set default actions, then call sub handler
#
if ( !defined($ActionDispatch{$In{action}}) ) {
    $In{action} = 'stats';
}
my $action = $ActionDispatch{$In{action}};

#
# For some reason under mod_perl, the use lib above is unreliable,
# and sometimes the module below cannot be found.  Explicitly push
# the directory onto INC if it is missing.  This is an ugly hack;
# need to figure out what's really going on...
#
my $installDir = '/usr/share/backuppc/lib';
push(@INC, $installDir) if ( !grep($_ eq $installDir, @INC) );

#
# Load the relevant action script and run it
#
require "BackupPC/CGI/$action.pm"
  if ( !defined($BackupPC::CGI::{"${action}::"}) );
$BackupPC::CGI::{"${action}::"}{action}();
