# Extensions for CLI authentic2-manage.

This package provide a collection of subcommands for the `authentic2-manage`:

- `sp-options-policy` : create a service prodiders options policy
- `add-service-provider` : add a service prodider
- `sync-ldap-user` : synchronize one LDAP user specified by username (as done by the upstream `sync-ldap-users` for all users)

This package also provide a BASH completion solution for the `authentic2-manage` command.

> **Note:** Some of this repository features have been [proposed](https://dev.entrouvert.org/issues/61635)
> upstream but rejected as core features.

## Example usage

Create SP options policy named "allow-all":

```bash
authentic2-manage sp-options-policy \
 --name allow-all \
 --enabled \
 --signed-authn-requests \
 --default-nameid-format email \
 --accepted-nameid-formats email,persistent,transient,uuid
```

To create a new SP using the freshly created SP options policy:

```bash
authentic2-manage add-service-provider \
 --name "ldap.demo.easter-eggs.com" --slug "ldap" \
 --URL https://ldap.demo.easter-eggs.com/mellon/metadata \
 --attribute uid:uid \
 --attribute mail:django_user_email \
 --enable-following-sp-options-policy \
 --ou default \
 --sp-options-policy allow-all
```

Synchronize the LDAP user `foo.bar`:

```bash
authentic2-manage sync-ldap-user foo.bar
```
