# Authentic2 SUPANN

## Locally build (using Docker)

You also could manually build a specific release using the following command:

```bash
docker run --rm -it -v "$(pwd):/src" -w /src -e DEBFULLNAME -e DEBEMAIL -e GPG_KEY debian:11 ./build.sh --install-build-deps
```

Release built files will be store in the `dist` directory.

You also could use the `docker-builds.sh` script to build it for all supported Debian releases. In this cas, all built files will be store in the `dists` directory.

### Packages signing

By default, built packages are not signed but you could provided information to allow their signature :

- be sure to define `DEBFULLNAME` and `DEBEMAIL` environment variables
- run the `docker run` command (or `docker-builds.sh` script) in a context where the `GPG_KEY` environment variable is set as follow :

```bash
GPG_KEY=$( gpg --armor --export-secret-key $DEBEMAIL|base64|tr -d '\n' )
```

**Important :** This solution only work with GPG key **without password** defined. If you have to use a GPG key with a password, you have to remove it before by running the following command :

```
gpg --edit-key $DEBEMAIL
> passwd
> quit
```

Be sure to restore your password after building the Debian packages.

**Note :** both `build.sh` and `docker-builds.sh` scripts accept a `--gpg-key` parameter, but it will only works if the GPG key is available in the running context, so probably not in a docker container or not if script is run with `sudo`.
