import { dirname, join } from 'path';

import type { StorybookConfig } from '@storybook/react-webpack5';

export default {
	stories: ['../src/**/*.stories.tsx', '../src/**/stories.tsx'],

	addons: [
		getAbsolutePath('@storybook/addon-essentials'),
		getAbsolutePath('storybook-dark-mode'),
		'./webpackAddon',
		getAbsolutePath('@storybook/addon-styling-webpack'),
	],

	framework: {
		name: getAbsolutePath('@storybook/react-webpack5'),
		options: {},
	},

	typescript: {
		reactDocgen: 'react-docgen',
	},

	docs: {},
} satisfies StorybookConfig;

function getAbsolutePath(value: string): any {
	return dirname(require.resolve(join(value, 'package.json')));
}
