import type { IRoom, Serialized } from '@rocket.chat/core-typings';
import { Box } from '@rocket.chat/fuselage';
import { GenericModal } from '@rocket.chat/ui-client';
import { useTranslation } from 'react-i18next';

import ChannelDesertionTable from '../../../../ChannelDesertionTable';

type FirstStepProps = {
	onClose: () => void;
	onCancel: () => void;
	onConfirm: () => void;
	onToggleAllRooms: () => void;
	onChangeRoomSelection: (room: Serialized<IRoom>) => void;
	rooms?: (Serialized<IRoom> & { isLastOwner?: boolean })[];
	eligibleRoomsLength: number | undefined;
	selectedRooms: { [key: string]: Serialized<IRoom> };
};

const FirstStep = ({
	onClose,
	onCancel,
	onConfirm,
	rooms,
	onToggleAllRooms,
	onChangeRoomSelection,
	selectedRooms,
	eligibleRoomsLength,
	...props
}: FirstStepProps) => {
	const { t } = useTranslation();

	return (
		<GenericModal
			variant='warning'
			icon='warning'
			title={t('Converting_team_to_channel')}
			cancelText={t('Cancel')}
			confirmText={t('Continue')}
			onClose={onClose}
			onCancel={onCancel}
			onConfirm={onConfirm}
			{...props}
		>
			<Box mbe={24} fontScale='p2'>
				{t('Select_the_teams_channels_you_would_like_to_delete')}
			</Box>

			<Box mbe={24} fontScale='p2'>
				{t('Notice_that_public_channels_will_be_public_and_visible_to_everyone')}
			</Box>

			<ChannelDesertionTable
				lastOwnerWarning={undefined}
				onToggleAllRooms={onToggleAllRooms}
				rooms={rooms}
				onChangeRoomSelection={onChangeRoomSelection}
				selectedRooms={selectedRooms}
				eligibleRoomsLength={eligibleRoomsLength}
			/>
		</GenericModal>
	);
};

export default FirstStep;
