# 6.2.11

`2023-07-26  ·  1 🐛  ·  1 🔍  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.3`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.39.1`

### 🐛 Bug fixes


- Performance issue when using api to create users ([#29914](https://github.com/RocketChat/Rocket.Chat/pull/29914) by [@KevLehman](https://github.com/KevLehman))

<details>
<summary>🔍 Minor changes</summary>


- Release 6.2.11 ([#29915](https://github.com/RocketChat/Rocket.Chat/pull/29915) by [@rocketchat-github-ci](https://github.com/rocketchat-github-ci))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@KevLehman](https://github.com/KevLehman)
- [@rocketchat-github-ci](https://github.com/rocketchat-github-ci)

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)
- [@rodrigok](https://github.com/rodrigok)

# 6.2.5

`2023-06-07  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.3`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.39.1`

### 🐛 Bug fixes


- Seat counter including apps ([#29489](https://github.com/RocketChat/Rocket.Chat/pull/29489))

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 6.2.4

`2023-06-07  ·  2 🐛  ·  2 🔍  ·  5 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.3`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.39.1`

### 🐛 Bug fixes


- Imported messages are not displayed ([#29485](https://github.com/RocketChat/Rocket.Chat/pull/29485))

  - Fix issue with imported messages not being displayed in the room.
   - Fix importer agent being added as a member of every imported room.

- message deletion fails if has files attached on filesystem storage ([#29313](https://github.com/RocketChat/Rocket.Chat/pull/29313))

<details>
<summary>🔍 Minor changes</summary>


- Fix Omnichannel Webhooks tests ([#29344](https://github.com/RocketChat/Rocket.Chat/pull/29344))

- use local httpbin container on github CI's ([#29067](https://github.com/RocketChat/Rocket.Chat/pull/29067))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@debdutdeb](https://github.com/debdutdeb)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 6.2.3

`2023-06-05  ·  1 🎉  ·  9 🐛  ·  9 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.3`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.39.1`

### 🎉 New features


- Add support to use `TRANSPORTER` env var for monolith deployments ([#29373](https://github.com/RocketChat/Rocket.Chat/pull/29373))

### 🐛 Bug fixes


- `queuedForUser` endpoint not filtering by status ([#29189](https://github.com/RocketChat/Rocket.Chat/pull/29189))

- Embedded layout stops working after navigation occurs ([#29147](https://github.com/RocketChat/Rocket.Chat/pull/29147))

- File upload in Safari, IOS devices ([#27121](https://github.com/RocketChat/Rocket.Chat/pull/27121))

- fix wrong %s translations  ([#29395](https://github.com/RocketChat/Rocket.Chat/pull/29395))

- getActiveLocalUserCount query ([#29349](https://github.com/RocketChat/Rocket.Chat/pull/29349))

- Import progress page stuck at 0% ([#29421](https://github.com/RocketChat/Rocket.Chat/pull/29421))

  - Fix incorrect percentage calc;
   - Fix import progress page stuck at 0%.

- Importer crashes when sending the "active status" e-mail notification to users ([#29401](https://github.com/RocketChat/Rocket.Chat/pull/29401))

  - Fix `getImportProgress` endpoint returning incorrect count info (`total: 0, completed: 0`);
   - Fix server crash when sending the "active status" e-mail notification to users on import.

- OTR session closing after 10 seconds without warning ([#29245](https://github.com/RocketChat/Rocket.Chat/pull/29245))

  The `Notifications` streamer is sending two events when there's a license applied to the workspace and it's not using Microservices. I'm avoiding this by simply ignoring the second event in OTRRoom.

  There is still an issue where there's 2 system messages being fired after accepting, but that's not a really big concern since it doesn't break anything.

- unable to create user if Accounts_ManuallyApproveNewUsers is enabled ([#29293](https://github.com/RocketChat/Rocket.Chat/pull/29293))

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@debdutdeb](https://github.com/debdutdeb)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@jessicaschelly](https://github.com/jessicaschelly)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 6.2.2

`2023-05-19  ·  1 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.3`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.39.1`

### 🐛 Bug fixes


- Livechat `CSP` whitelist validation ([#29278](https://github.com/RocketChat/Rocket.Chat/pull/29278))

  This PR fixes the Livechat CSP validation, which was incorrectly blocking access to the widget for all non whitelisted domains.

### 👩‍💻👨‍💻 Core Team 🤓

- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@ggazzo](https://github.com/ggazzo)

# 6.2.1

`2023-05-17  ·  1 🔍  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.3`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.39.1`

<details>
<summary>🔍 Minor changes</summary>


- Bump apps engine and vm2 ([#29262](https://github.com/RocketChat/Rocket.Chat/pull/29262))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)

# 6.2.0

`2023-05-15  ·  9 🎉  ·  2 🚀  ·  80 🐛  ·  290 🔍  ·  56 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.3`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.39.0`

### 🎉 New features


- add GA4 support ([#28830](https://github.com/RocketChat/Rocket.Chat/pull/28830) by [@avelino](https://github.com/avelino))

- auto link custom domain ([#28501](https://github.com/RocketChat/Rocket.Chat/pull/28501))

  **Changes:**
  
  - Auto Link Custom Domain new setting under Message group  path: `/admin/settings/Message`
  
  - New translation keys for English
  
  - Adding types to message-parser `Options`
  
  - New hook `useAutoLinkDomains` to get the setting and return an array of domains

  **Current:** 
  ![image](https://user-images.githubusercontent.com/20212776/226985466-79e5c016-bf2e-490b-a906-39d525926b6c.png)

  **Desirable:**
  Output when the setting has the value: `local,intranet`

  New setting: 
  ![image](https://user-images.githubusercontent.com/20212776/226985802-5ebca48d-7cfd-41a8-a1e1-60f81e02efdd.png)


  ![image](https://user-images.githubusercontent.com/20212776/226985522-bcd218a5-0e76-4304-955f-88ba83394b77.png)

- Custom roles and Public&Private apps stats ([#27781](https://github.com/RocketChat/Rocket.Chat/pull/27781))

- Make the marketplace search bar placeholder dynamic ([#28394](https://github.com/RocketChat/Rocket.Chat/pull/28394))

  ## Jira task: [AECO-24](https://rocketchat.atlassian.net/browse/AECO-24?atlOrigin=eyJpIjoiOTM2ZjkzZmY4YTNkNGI1Mzk1NzQwMjNmYzI0YmRlZTgiLCJwIjoiaiJ9)
  Now the placeholder of the marketplace search bar will change based on which page of marketplace the user is browsing.
  Demo gif:
  ![marketplace-search-placeholder](https://user-images.githubusercontent.com/43561537/224767282-c4aa0aca-0e35-4fb9-bf7d-7435982c4cfe.gif)

- Message Forwarding ([#26662](https://github.com/RocketChat/Rocket.Chat/pull/26662))

  Implement the ability to forward messages to another channel, thread, or discussion. This is a high demand capability that is currently missing in Rocket.Chat. It can significantly improve the user's experience and her/his productivity. The scope of this project will be limited to the web application (not for mobile apps).

  Special thanks to @nishant23122000 that helped us with this during GSOC 2022

  <img src='https://user-images.githubusercontent.com/27704687/196773367-a996e0a5-5b48-4e61-bf94-efb4e19ebf88.gif' />

- moderation dashboard ([#28962](https://github.com/RocketChat/Rocket.Chat/pull/28962))

  Release PR for the `feat/moderation-dashboard` implementing the Beta version of the Moderation Console. For more details & some previews on Moderation Console, read here -> https://github.com/RocketChat/Rocket.Chat/pull/27961#issue-1573852076

- New timeout setting for Omnichannel Webhooks ([#28219](https://github.com/RocketChat/Rocket.Chat/pull/28219) by [@cauefcr](https://github.com/cauefcr))

  Costumers were complaining about duplicated data from the Omnichannel webhooks, so I added a new setting that controls the timeouts for the webhooks, in the omnichannel->webhooks panel, the default values are 5s for http timeout, and 4x that for the retry timeout, or 20s.

- Registered Loom oEmbed ([#28339](https://github.com/RocketChat/Rocket.Chat/pull/28339) by [@Nabhag8848](https://github.com/Nabhag8848))

  - Registered Loom OEmbed, Now Loom video links will show the embedded representation of URL shared like youtube and will have the better user experience for the teams using loom.

  ![LoomEmbedAfter](https://user-images.githubusercontent.com/65061890/223952938-db37f6b2-d79a-4d48-9e33-cb97901eb1e2.gif)

- VideoConference Guest mode and Conference Router ([#28186](https://github.com/RocketChat/Rocket.Chat/pull/28186))

  Jira Issue: [VC-79]

### 🚀 Improvements


- Adding input type=password to AWS secrets fields ([#28159](https://github.com/RocketChat/Rocket.Chat/pull/28159))

  Some fields that store secrets for AWS were exposing sensitive data because they didn't have the input type as `password`. 

  The change includes adding the password type and also changing the autocomplete value from `<PasswordInput />` component to add the value `new-password` to avoid the browser autocompleting with the existing password. (This does not prevent the browser to show the hint to add the password)

- Galician onboarding translation ([#27908](https://github.com/RocketChat/Rocket.Chat/pull/27908) by [@Thiagof99](https://github.com/Thiagof99))

  I've translated the entire onboarding page and forms to galician language. Here's an example of how the forms look now:
  ![image](https://user-images.githubusercontent.com/38543057/215829675-23457185-bfc9-485e-8b71-59ba1f746d01.png)

### 🐛 Bug fixes


- #28762 - fix missing command in /help ([#28777](https://github.com/RocketChat/Rocket.Chat/pull/28777) by [@adarshlilha](https://github.com/adarshlilha))

  When using `/help` command in any room the rocket.cat bot lists all keyboard shortcuts for the operations that can be done in rocket chat but for one command(marking all messages as read) shortcut is not being renderered

  **before fix screenshot:**
  <img width="653" alt="Screenshot 2023-04-03 at 23 49 21" src="https://user-images.githubusercontent.com/112387862/229480617-570d422c-6e94-4306-9733-4247f6dc9be1.png">

  **post fix screenshot:**
  <img width="653" alt="Screenshot 2023-04-03 at 23 49 21" src="https://user-images.githubusercontent.com/13575704/229593700-38c85b52-3bc2-4ae0-ba99-76bf7f0229db.png">

- `ComposerPopupPreview` trespassing the composer limit ([#28896](https://github.com/RocketChat/Rocket.Chat/pull/28896))

  #### before
  ![image](https://user-images.githubusercontent.com/27704687/231615879-3bc84fe4-02be-4bf9-aef6-0545289afac8.png)

  ![image](https://user-images.githubusercontent.com/27704687/231615897-81fac89f-3195-49a2-9cf6-2dd8ba70b61a.png)


  #### after
  ![image](https://user-images.githubusercontent.com/27704687/231615860-e3eaf0d5-b826-4d41-bd3a-b681c5e9c07d.png)

  ![image](https://user-images.githubusercontent.com/27704687/231615925-9c9732e9-3f2c-4245-aa97-90d3ee29eb86.png)

- `emoji` property in messages not being respected ([#28416](https://github.com/RocketChat/Rocket.Chat/pull/28416))

  There's a property on the message object called `emoji` which allow the sender (bot, app, API, integration, etc) to replace the user avatar with an emoji. Since we rewrote the messages to React, this was not being supported.
  ![image](https://user-images.githubusercontent.com/40830821/225034166-d195399a-e1ac-498b-91f1-a21d94a31dfc.png)

- `UI_Use_Real_Name` not being respected in quotes and RoomForeword ([#28613](https://github.com/RocketChat/Rocket.Chat/pull/28613))

  Updated pertinent places and made it so user `name` is always sent with message (empty if non-existant).

  Before:
  ![image](https://user-images.githubusercontent.com/40830821/227630948-af83b87a-5878-4383-9680-5d431f4e4fc5.png)
  ![image](https://user-images.githubusercontent.com/40830821/227630986-a7fa0039-7570-491d-b062-d546c5ba51bb.png)

  After:
  ![image](https://user-images.githubusercontent.com/40830821/227631233-11ef56a9-95e1-45f6-80a6-c76484ada7ca.png)
  ![image](https://user-images.githubusercontent.com/40830821/227631288-bc307c77-98bf-4c37-80b2-c032bddf85d2.png)

- Add function to get installation source ([#28806](https://github.com/RocketChat/Rocket.Chat/pull/28806))

  There have been reports of problems regarding the missing information of `installationSource` in apps. The only scenario where this information could be missing is if migrations failed to run properly when upgrading to 6.0. We haven't been able to identify the root cause yet, so we decided to provide a workaround in the meanwhile

- App crashing when switching to Hindi (hi-In) language ([#28285](https://github.com/RocketChat/Rocket.Chat/pull/28285) by [@bhardwajdisha](https://github.com/bhardwajdisha))

- app status inconsistencies when running multiple instances in a cluster ([#29180](https://github.com/RocketChat/Rocket.Chat/pull/29180))

  App status inconsistencies between multiple instances in a cluster boil down to the fact that the Apps-Engine is currently responsible for orchestrating when these events are triggered and is overly verbose in doing so.

  Upon analysis, the framework itself _should not_ have the concept of "other instances"   - this is a deployment detail of the host system, and as such should be controlled by the host. The correct solution for this problem is to review this notification system, potentially removing it from the framework and leaving the responsibility solely for Rocket.Chat.

  However, this is hindering the current app management experience for workspaces, so this PR cuts the control of some notifications that come from the framework (the more problematic ones) and moves the control over to RC in a short and practical way.

  This is done by turning the methods of the most problematic events in the `AppActivationBridge` into no-ops, and instead triggering the `AppServerNotifier` directly in the api endpoints that are applicable.

  It is _not_ the most correct solution to the problem, but due to time constraints and urgency this will be applied first so we can move with the correct solution in a future point.

- application crashing when clicking on files button ([#28878](https://github.com/RocketChat/Rocket.Chat/pull/28878) by [@jayesh-jain252](https://github.com/jayesh-jain252))

  The application crashed when a user clicked on the files option when there were multiple files in the room.

  After:
  ![image](https://user-images.githubusercontent.com/79307894/231410669-971dbde8-2885-472c-8e18-602d0f5765c4.png)

- Apps.engine resource consumption ([#28514](https://github.com/RocketChat/Rocket.Chat/pull/28514))

  Added some validations to avoid doing unnecessary updates and also avoid loop that causes high server usage

- Avoid `useEffect` loop ([#28699](https://github.com/RocketChat/Rocket.Chat/pull/28699))

  A bug in `useUserBanners` hooks will generate a infinite loop whenever a new user banner (e.g. new version announcement) is available. This PR fixes it.

- Avoid throw error on `settings.watch` at startup ([#28649](https://github.com/RocketChat/Rocket.Chat/pull/28649))

- Bring unseen app requests badge back and minor refactors ([#28348](https://github.com/RocketChat/Rocket.Chat/pull/28348))

  Brought back the unseen app requests badge that disappeared due to a development oversight and fixed some typos and style issues.

- change default text color in homepage custom content block ([#28685](https://github.com/RocketChat/Rocket.Chat/pull/28685))

  - The default text (if there is no content or the admin just adds text without style) color in the homepage custom content block was blue (due to `color="info"`), but should actually be black

  Before:

  <img width="613" alt="Screen Shot 2023-03-29 at 12 14 47" src="https://user-images.githubusercontent.com/48109548/228594931-379f4df6-89f1-411d-9226-76ad9abe1c02.png">


  After:

  <img width="605" alt="Screen Shot 2023-03-29 at 12 47 55" src="https://user-images.githubusercontent.com/48109548/228594967-6a2ceb9f-6422-4b85-8021-653ae9a3e4f6.png">

- Changing the app's error verification ([#28450](https://github.com/RocketChat/Rocket.Chat/pull/28450))

- check if custom field is required to apply rule ([#28428](https://github.com/RocketChat/Rocket.Chat/pull/28428) by [@filipemarins](https://github.com/filipemarins))

  Fix save button is not enabled until non-required custom fields are not filled under room information.

- composer slashcommands duplication  ([#29086](https://github.com/RocketChat/Rocket.Chat/pull/29086))

- Confirm password flow fixed and refactored ([#28453](https://github.com/RocketChat/Rocket.Chat/pull/28453) by [@XshubhamX](https://github.com/XshubhamX))

- convert OVERWRITE_SETTING type MULTISELECT to array ([#29208](https://github.com/RocketChat/Rocket.Chat/pull/29208))

- Delete accounts modal asks for a username instead of the password ([#28883](https://github.com/RocketChat/Rocket.Chat/pull/28883))

  Jira task: [WM-2](https://rocketchat.atlassian.net/browse/WM-2?atlOrigin=eyJpIjoiYWQ2MjJjZTk3MGRlNDY3ZTljM2EzYjNhMmNkYTM0NmEiLCJwIjoiaiJ9)
  Fixed a misuse of the password.bcrypt data. This info shouldn't be exposed to the front-end. Not only that, but it also wasn't available to the front-end causing a bug in which the user would be prompted for their username when deleting their account even if they had a password. Also changed the text of the account deletion confirmation modal so that it better uses the spacing of the Generic Modal.
  Demo gif:
  ![account_deletion_modal](https://user-images.githubusercontent.com/43561537/231599373-b0cbec80-753f-422f-b4f9-0317ac8f92d9.gif)

- Display Avatar Preference not hiding avatars on messages ([#27072](https://github.com/RocketChat/Rocket.Chat/pull/27072))

- Emoji don't work after text in contiunous ([#28216](https://github.com/RocketChat/Rocket.Chat/pull/28216) by [@Bankar-Swapnil](https://github.com/Bankar-Swapnil))

- Engagement dashboard crash on Users tab ([#28131](https://github.com/RocketChat/Rocket.Chat/pull/28131))

- Error logging in with TOTP on "reset password" workflow ([#28938](https://github.com/RocketChat/Rocket.Chat/pull/28938))

  - Remove TOTP check on login via "Reset Password" link.

- Error message is displayed in case no file is found in custom sound section. ([#28302](https://github.com/RocketChat/Rocket.Chat/pull/28302) by [@bhardwajdisha](https://github.com/bhardwajdisha))

- Export as PDF button is disabled when chat is closed by the visitor ([#28305](https://github.com/RocketChat/Rocket.Chat/pull/28305) by [@filipemarins](https://github.com/filipemarins))

  Fix the `export as PDF` button is disabled when chat is closed by the visitor;

- Fixed business hours route redirect ([#28344](https://github.com/RocketChat/Rocket.Chat/pull/28344))

  This PR fixes the user being redirected to a blank page after editing the business hours.

- Fixed no role assign to manual registered users despite of Default Roles for Users settings ([#28293](https://github.com/RocketChat/Rocket.Chat/pull/28293) by [@bhardwajdisha](https://github.com/bhardwajdisha))

- Fixing the user status change by app ([#28965](https://github.com/RocketChat/Rocket.Chat/pull/28965))

- Fuselage's icon font reloads too often ([#28673](https://github.com/RocketChat/Rocket.Chat/pull/28673))

- Gallery opening other image after closing ([#27957](https://github.com/RocketChat/Rocket.Chat/pull/27957))

  How to reproduce:
  1   - Upload MANY images to a channel (they have to be images and the bigger and more images the easier to reproduce)
  2   - Click on one of the images
  3   - Try to close the glalery as QUICK as possible

  If done correctly, another image will open after closing the gallery. You could also try opening different images or throttling the network thru the devtools in order to help reproduce it.

  I also took some time to make part of the code more readable.

- Generic Table Search ([#28401](https://github.com/RocketChat/Rocket.Chat/pull/28401))

  When the user changes the page and tries to search for a room that is not currently visible on the page it’s not returning any results. This is also reproducible in the Users table 

  **Current Behavior:**
  It returns the list filtering by the name
  ![task_table](https://user-images.githubusercontent.com/20212776/224804926-d8bffe6e-419f-444f-bdfa-ede01073527d.gif)


  **Previous Behavior:**
  Not found   - It was not finding the room because it’s filtering only in the current page
  ![search-pagination-rooms](https://user-images.githubusercontent.com/20212776/224803475-e991b354-df3d-42fe-8564-b041ca5edc89.gif)

- Google Cloud Storage not working ([#29244](https://github.com/RocketChat/Rocket.Chat/pull/29244))

- Hide System Messages for room requires refresh ([#28584](https://github.com/RocketChat/Rocket.Chat/pull/28584))

  Adittionaly fixed a bug in the Edit Channel contextual bar where the `hide system messages` option wasn't updating on removing the last item.

- Horizontal scroll in main room if text is too long ([#28434](https://github.com/RocketChat/Rocket.Chat/pull/28434))

  Removed inline styles from elements and substituted `p` tag for `div`

  For a quick explanation, the `p` tag adds the multiple line breaks by default when copying text. We should revise in the parser how we deal with paragraphs and text blocks.

- Invalid JSON in Custom Translations setting crashes the UI ([#28600](https://github.com/RocketChat/Rocket.Chat/pull/28600))

  - Check if JSON code settings (with `type: code` and `code: application/json`) are valid before saving, or throw an error otherwise;
  
  - Dismiss custom settings when the custom translations JSON provided is invalid (instead of throwing an error and crashing the UI);
  
  - Fix the Custom Translations setting desciption so that the example is shown as a code snippet.

- Leader Bar presence status alignment ([#28793](https://github.com/RocketChat/Rocket.Chat/pull/28793))

- Livechat MessageList not auto scrolling on new message ([#28547](https://github.com/RocketChat/Rocket.Chat/pull/28547))

- Livechat notifications not working correctly ([#28741](https://github.com/RocketChat/Rocket.Chat/pull/28741))

- Livechat Triggers not working ([#29073](https://github.com/RocketChat/Rocket.Chat/pull/29073))

- marketplace doc link wrong redirect ([#28466](https://github.com/RocketChat/Rocket.Chat/pull/28466))

  Fixed a problem in which the FlowRouter was breaking external links passed to the SidebarItem component.
  Example of wrong behavior (after clicking on the marketplace Documentation option):
  ![image](https://user-images.githubusercontent.com/43561537/225930699-0f3f6667-97e7-4973-9dc8-b8ee251c5557.png)

  Demo gif (after fix):
  ![marketplace-documentation-link](https://user-images.githubusercontent.com/43561537/225936722-bf329a81-426e-46c0-ad46-ba2c87d82a74.gif)

- marketplace requested  glitch ([#28445](https://github.com/RocketChat/Rocket.Chat/pull/28445))

- message-parser links ([#28735](https://github.com/RocketChat/Rocket.Chat/pull/28735))

  When sending URLs with certain characters, the hyperlink gets cut off.

  For example:

  https://www.nimblepcm.com/(W(601))/Main?ScreenId=GI000027

  URL gets cut off after "(601"

  That doesn't happen with all URLs.

- MessageBoxReplies attachments preview ([#28579](https://github.com/RocketChat/Rocket.Chat/pull/28579))

  The `MessageBoxReplies` component was not displaying the attachments previews in the correct way, it was using the `DefaultAttachment` instead.

  To accomplish the expected behavior I had to do the following **changes**:
  
  - Edit the `MessageBoxReplies` to add a `collapsed` prop to the attachments to always start as collapsed
  
  - Add a new prop to the `MessageCollapsible` component to control the preview attachments in `MessageBoxReplies` to always start as collapsed
  
  - Edit the Attachment components to read the `collapsed` value and send it thought 
  
  - Edited the `ShareMessageModal` to display the correct attachment and its previews
  
  - Edited the `useCollapse` hook prop as optional because was not making sense to put it as mandatory since it was getting the value from the user preferences as default and for the `MessageCollapsible` work in a dynamic way

  **Current Behavior:**
  ![image](https://user-images.githubusercontent.com/20212776/227235491-b04c82fd-fe74-4699-aae8-02429934c1b5.png)

  ![image](https://user-images.githubusercontent.com/20212776/227235326-18976ab0-3fd1-44a2-8635-e2a81e839f3b.png)


  **Expected Behavior**
  ![image](https://user-images.githubusercontent.com/20212776/227236374-b13957d6-c428-4f46-81f9-890409273837.png)

  ![image](https://user-images.githubusercontent.com/20212776/227235906-e59fb77e-2518-44fd-9a0d-00b1014d8724.png)

- Messages jumping after reaction ([#28770](https://github.com/RocketChat/Rocket.Chat/pull/28770))

- Migration error when removing 'snipetted' index ([#29215](https://github.com/RocketChat/Rocket.Chat/pull/29215))

- migration to fix apps in invalid state ([#29210](https://github.com/RocketChat/Rocket.Chat/pull/29210))

  Due to a conflict between 5.4.x and 6.0, if the upgrade of a workspace is done using a Rolling upgrade strategy, it is likely that apps will be left in an invalid (potentially unusable) state.

  We can solve apps left in this state by adding another migration.

- missing margins in message composer icons ([#28430](https://github.com/RocketChat/Rocket.Chat/pull/28430))

  - Add missing ` .rcx-button-group__item` prop in message box components for horizontal margin

  Before: 
  <img width="542" alt="Screen Shot 2023-03-15 at 10 20 08" src="https://user-images.githubusercontent.com/48109548/225325793-6f688065-a1ed-4696-ac8b-99faddcd33c3.png">

  After:
  <img width="565" alt="Screen Shot 2023-03-15 at 10 18 27" src="https://user-images.githubusercontent.com/48109548/225325820-8749ff9c-ee3a-4a80-bed4-0c21449e431e.png">

- New marketplace uxdqa ([#28390](https://github.com/RocketChat/Rocket.Chat/pull/28390))

  Fix all ux problems found by design on the new marketplace.

  ## Jira tasks (All the details of issues solved in this PR can be found on these tasks):
  [AECO-18](https://rocketchat.atlassian.net/browse/AECO-18?atlOrigin=eyJpIjoiYzQ2NDYwZTAxM2E5NGEwMmE0NGYyMWM3ZTVhYTY2M2MiLCJwIjoiaiJ9): Enabled apps counter has wrong spacing   - M: #28391
  [AECO-21](https://rocketchat.atlassian.net/browse/AECO-21?atlOrigin=eyJpIjoiYjZiMGY1ZjU4OTkwNGI4NWJlMDA2OTMxMmIwMTZiODQiLCJwIjoiaiJ9): Disabled state of request button showing the text "request" instead of "requested"
  [AECO-22](https://rocketchat.atlassian.net/browse/AECO-22?atlOrigin=eyJpIjoiNWQ0N2M3ZTZmNDExNDM3NWE5Zjc5NTZkM2NhNzFjNGIiLCJwIjoiaiJ9): Upsell modal has wrong spacing between its title and its image   - M: #28391
  [AECO-23](https://rocketchat.atlassian.net/browse/AECO-23?atlOrigin=eyJpIjoiM2NhOTIzNzFiODUyNGUxYzk2ZDg4MjhjNzk2YzI1MWMiLCJwIjoiaiJ9): Request tab visible inside of private apps page   - M: #28392
  [AECO-25](https://rocketchat.atlassian.net/browse/AECO-25?atlOrigin=eyJpIjoiNjY1YWM3Njc3OGM1NDc4MzgyMGJlNzE2YWMxNjVjODMiLCJwIjoiaiJ9): Wrong title on enabled apps counter when inside of the private apps page   - M: #28391
  [AECO-48](https://rocketchat.atlassian.net/browse/AECO-48?atlOrigin=eyJpIjoiNDBiY2Q2Y2Y2NDQ5NGQ4MGI3ZTFiNjU4MzgzMjI0ZTgiLCJwIjoiaiJ9): UXDQA app listing   - M: #28500 
  [AECO-49](https://rocketchat.atlassian.net/browse/AECO-49?atlOrigin=eyJpIjoiMjdlNDI1YTcwNjA4NDRkZGI3YTU5NTU3ZmZmZDk1ZWMiLCJwIjoiaiJ9): UXDQA app detail   - M: #28499

- No feedback given in case of wrong password input in modal confirm password  ([#28276](https://github.com/RocketChat/Rocket.Chat/pull/28276) by [@bhardwajdisha](https://github.com/bhardwajdisha))

- Normal and multiline messages adding extra spaces upon copying/pasting ([#28187](https://github.com/RocketChat/Rocket.Chat/pull/28187) by [@Educg550](https://github.com/Educg550))

- null email for SSO User on Profile Page ([#22438](https://github.com/RocketChat/Rocket.Chat/pull/22438) by [@Shailesh351](https://github.com/Shailesh351))

- Offline register option ([#28467](https://github.com/RocketChat/Rocket.Chat/pull/28467))

- Prevent blank space on live chat form validations ([#28243](https://github.com/RocketChat/Rocket.Chat/pull/28243) by [@filipemarins](https://github.com/filipemarins))

- quote line break ([#28798](https://github.com/RocketChat/Rocket.Chat/pull/28798))

  Big messages are being rendered correctly on the chat but when quoted, the UI stops wrapping them correctly.
  The change was made on `fuselage`, this PR only updates its version.

  fuselage PR: https://github.com/RocketChat/fuselage/pull/1018

  **Before:**
  ![image-20230320-134526](https://user-images.githubusercontent.com/20212776/229609390-7ee77c8e-c45d-41db-ad91-d65fbfd85087.png)


  **Now:** 
  ![image](https://user-images.githubusercontent.com/20212776/229609092-9b42476c-ce6b-4612-843e-b89dbb8614ea.png)

- Quotes chain off by one error in quote chain limit settings ([#28281](https://github.com/RocketChat/Rocket.Chat/pull/28281) by [@jayesh-jain252](https://github.com/jayesh-jain252))

  Fixed off by one error in Quote Chain Limit. Now if a user sets Message_QuoteChainLimit (default is 2) the number of quotes chained matches the setting.
  Changes are made in apps/meteor/app/oembed/server/jumpToMessage.ts file

  With Message_QuoteChainLimit=2
  Before:
  ![quote_limit2_before](https://user-images.githubusercontent.com/79307894/222970577-5d2b2dc9-c191-4758-acea-909786d974ac.PNG)

  After:
  ![quote_limit2_after](https://user-images.githubusercontent.com/79307894/222970247-fa0bcfcf-e7f3-4102-b7b3-820fb43677c1.PNG)

- redirect not authorized and room not found errors ([#29150](https://github.com/RocketChat/Rocket.Chat/pull/29150))

  Redirect Meteor.Error to RoomNotFoundError to show the correct page

  Before:
  <img width="1346" alt="Screen Shot 2023-05-04 at 14 35 22" src="https://user-images.githubusercontent.com/48109548/236284301-a660005e-b509-41b1-b489-1e990aa1b1d0.png">


  After:
  <img width="1341" alt="Screen Shot 2023-05-04 at 14 36 45" src="https://user-images.githubusercontent.com/48109548/236284363-8dc42552-d455-4f91-bcb7-7b927f8a92df.png">

- remove link appearing in quotes preview ([#28443](https://github.com/RocketChat/Rocket.Chat/pull/28443) by [@jayesh-jain252](https://github.com/jayesh-jain252))

  When a user chained quotes for more than 2 times, there was a link appearing in the quotes preview

  Before:

  ![Rocket Chat](https://user-images.githubusercontent.com/79307894/225587932-16dd5366-13c2-411f-b5e3-89a5fcccfd24.gif)

  After:

  ![Rocket Chat After](https://user-images.githubusercontent.com/79307894/225588988-7fd85682-7155-47cf-8853-52d7ef884345.gif)

- Resolve Reset Password feature not sending email for emails containing capital letters ([#28778](https://github.com/RocketChat/Rocket.Chat/pull/28778) by [@Pranshu1902](https://github.com/Pranshu1902))

- Responsiveness of New Integration ([#27645](https://github.com/RocketChat/Rocket.Chat/pull/27645) by [@adijr9487](https://github.com/adijr9487))

  Improved the responsiveness by adding maxWidth property.
  ![image](https://user-images.githubusercontent.com/56039219/209580942-87a4b889-069d-4521-9380-056f5a39f146.png)

- Restriction setting not being applied to the old UFS route ([#28363](https://github.com/RocketChat/Rocket.Chat/pull/28363))

- Revert breaking change to groups.list API: 404 vs. empty list ([#27587](https://github.com/RocketChat/Rocket.Chat/pull/27587) by [@nmagedman](https://github.com/nmagedman))

  API calls that request a list of groups which meet some criteria should return an empty list when appropriate, rather than   404.  This was the pre-v5.0.0 behavior.

- Routing fixed for private apps in marketplace section ([#28418](https://github.com/RocketChat/Rocket.Chat/pull/28418) by [@ayush3160](https://github.com/ayush3160))

  This pull request fixes the irregular behavior of routing in the Private Apps section of the Marketplace. The issue was caused by the passing of three parameters (id of app, marketplaceVersion, and tab) to the route when opening an app's details. In the case of private apps, the marketplaceVersion was returning undefined, which caused the version to take on the value of the tab when redirecting. To resolve this issue, I have updated the code to pass the version of the app when the marketplaceVersion returns undefined. This fix ensures that the routes behave as expected in the Private Apps section of the Marketplace.

  https://user-images.githubusercontent.com/89914602/225092278-48854c4e-9135-4f6a-ae3e-6f99250dfa45.mp4

- Show all users on rooms members list ([#28413](https://github.com/RocketChat/Rocket.Chat/pull/28413))

  <img width="465" alt="image" src="https://user-images.githubusercontent.com/58601732/225011806-9062bde0-687d-4b1b-9e4e-8db30a48f992.png">

- Single omni closed room can't be deleted when the user doesn't have the permission to 'remove all closed omni rooms' ([#28877](https://github.com/RocketChat/Rocket.Chat/pull/28877))

- Small UI bugs ([#28893](https://github.com/RocketChat/Rocket.Chat/pull/28893))

  It fixes an insidious bug affecting the focus of the message composer whenever the user start typing. It also reverts some refactored code that affected desktop app users (e.g. cut/copy/paste not working).

- SMTP warnings on user form ([#28832](https://github.com/RocketChat/Rocket.Chat/pull/28832))

  Check for SMTP config on server side and then show warning on client side

- sound notification for queued chats with manual routing ([#28411](https://github.com/RocketChat/Rocket.Chat/pull/28411) by [@filipemarins](https://github.com/filipemarins))

  Don't play notification sound for disabled agents and also respect the `poolMaxIncoming` setting to play or not the notification;
  Refactor queue manager to ts.

- team channel reload error message ([#28667](https://github.com/RocketChat/Rocket.Chat/pull/28667))

- Thread list not scrolling to bottom when sending a message. ([#28346](https://github.com/RocketChat/Rocket.Chat/pull/28346))

- Thread message preview ([#28454](https://github.com/RocketChat/Rocket.Chat/pull/28454))

  The thread preview message was not displaying emojis and when the parent message was a quoted message it was not displaying the correct message.

  To fix the issues I did:

  
  - Emoji Issue:  I used the `<GazzodownText /> ` component to call `<PreviewMarkup />` conditionally when passed the prop `preview`. The  `<GazzodownText /> ` component it's necessary because it has the `MarkupInteractionContext.Provider` that has the context necessary to display the emoji and other elements
  
  - Empty parent message: Since the parent message it's a quote, the initial string from a quote message it's a link that references the original message followed by `\n` break line. I added a validation to check if it's a quoteAttachment message, if it is I remove the first markdown token responsible by the link

  **Before:**
  ![image](https://user-images.githubusercontent.com/20212776/225731429-98e2b5e2-9aff-4f17-9178-da9ff3257c2f.png)

  **After:**
  ![image](https://user-images.githubusercontent.com/20212776/225725000-9c4e9d3b-f8d0-4dec-9091-1ffa091406d0.png)

- Thread message preview to ignore hide_FlexTab preference ([#28470](https://github.com/RocketChat/Rocket.Chat/pull/28470))

  Added `role='link'` so that hide_flextab preference is ignored on this DOM node.

- ui crash if no app requests found ([#29107](https://github.com/RocketChat/Rocket.Chat/pull/29107))

- Unauthorized Toast Message when accessing a channel's team that user are not a member ([#28670](https://github.com/RocketChat/Rocket.Chat/pull/28670))

  Complementary it replaces `useEndpointData` in favor of `useQuery`

- Unnecessary useQuery refetch ([#28451](https://github.com/RocketChat/Rocket.Chat/pull/28451))

  Sometimes when the user focuses on the window that is running the Rocket.Chat some queries are triggered again without a reason, to prevent this to happen I added a option to `useQuery` hook, `refetchOnWindowFocus: false`

  **Queries impacted:**
  
  - useThreadMainMessageQuery.ts   - called when has to get the thread main message, for e.g in thread preview reply
  
  - useHasLicenseModule.ts   - called when the client starts to show/hide certain areas that are restricted by licenses, this don't change very often

- use raw image url ([#28861](https://github.com/RocketChat/Rocket.Chat/pull/28861) by [@avelino](https://github.com/avelino))

- videoconf stream ([#28455](https://github.com/RocketChat/Rocket.Chat/pull/28455))

- Whatsapp quotes not working due to livechat url change ([#29153](https://github.com/RocketChat/Rocket.Chat/pull/29153))

- When clicking on display option their checked status does not changes ([#27881](https://github.com/RocketChat/Rocket.Chat/pull/27881) by [@AdityaSingh-02](https://github.com/AdityaSingh-02))

- word break in rcx-message-body ([#28904](https://github.com/RocketChat/Rocket.Chat/pull/28904))

  Changes made on the fuselage repo: https://github.com/RocketChat/fuselage/pull/1028
  The CSS added into `rcx-message-body` `word-break: break-all;` was breaking a word in the middle in the messages.

  To change this behavior and break the entire word I changed to `word-break: break-word;`


  **Previous**
  ![image](https://user-images.githubusercontent.com/20212776/231753930-53ac7ab0-8e87-4014-9085-c0c3fc40f0b7.png)


  **NOW**
  ![image](https://user-images.githubusercontent.com/20212776/231754080-b87c4c5d-2565-43b3-ab4f-8382f6bdd2ae.png)

- Wrong error message when trying to create new team with existing team name ([#28270](https://github.com/RocketChat/Rocket.Chat/pull/28270) by [@Bankar-Swapnil](https://github.com/Bankar-Swapnil))

<details>
<summary>🔍 Minor changes</summary>


- /help notifying the shortcuts in multiple messages ([#28765](https://github.com/RocketChat/Rocket.Chat/pull/28765) by [@chinma-yyy](https://github.com/chinma-yyy))

- `AutoComplete` Sanitization ([#28666](https://github.com/RocketChat/Rocket.Chat/pull/28666))

  Fuselage Dependency: [#1014](https://github.com/RocketChat/fuselage/pull/1014)

- `enter-room` callback hook ([#28704](https://github.com/RocketChat/Rocket.Chat/pull/28704))

- `Imports` model removal ([#28459](https://github.com/RocketChat/Rocket.Chat/pull/28459))

- `InstancesModal` to ts ([#28474](https://github.com/RocketChat/Rocket.Chat/pull/28474))

- `livechat rooms` - 1 ([#28497](https://github.com/RocketChat/Rocket.Chat/pull/28497))

- `LivechatDepartmentAgents` removal ([#28472](https://github.com/RocketChat/Rocket.Chat/pull/28472))

- `LivechatDepartments` - 1/2 ([#28664](https://github.com/RocketChat/Rocket.Chat/pull/28664))

- `LivechatRooms` 2 ([#28504](https://github.com/RocketChat/Rocket.Chat/pull/28504))

- `LivechatRooms` removal - 3 ([#28506](https://github.com/RocketChat/Rocket.Chat/pull/28506))

- `LivechatTag` model to raw ([#28706](https://github.com/RocketChat/Rocket.Chat/pull/28706))

- `meteor/session` usage (1/N) ([#28565](https://github.com/RocketChat/Rocket.Chat/pull/28565))

  It restricts and replaces the usage of the `meteor/session` package on client modules.

- `openRoom` dilluted into components ([#28794](https://github.com/RocketChat/Rocket.Chat/pull/28794))

  Opening a room, from client-side, was an asynchronous process that was performed imperatively by a function called `opemRoom`. Its major issue was violating the principle of single responsibility by querying both the REST API as well the local cached collection and performing side-effects, like redirecting and handling errors. This PR moves `openRoom` core logic to a React Query function, which was only possible by decoupling a bunch of stuff in `RoomCoordinator`.

- `readMessage` events ([#28709](https://github.com/RocketChat/Rocket.Chat/pull/28709))

- `RegisterUsername` ([#28362](https://github.com/RocketChat/Rocket.Chat/pull/28362))

  <img width="643" alt="Screen Shot 2023-03-10 at 18 26 01" src="https://user-images.githubusercontent.com/27704687/224431376-d1495b75-08ca-4fb1-808b-4eb38ea66388.png">

- `RoomInfo` to typescript ([#28250](https://github.com/RocketChat/Rocket.Chat/pull/28250))

- `Rooms` model 2X ([#28715](https://github.com/RocketChat/Rocket.Chat/pull/28715))

- `Rooms` model 3/4 ([#28736](https://github.com/RocketChat/Rocket.Chat/pull/28736))

- `Rooms` model 4/4 ([#28742](https://github.com/RocketChat/Rocket.Chat/pull/28742))

- `roomSearch` Template ([#28691](https://github.com/RocketChat/Rocket.Chat/pull/28691))

  Jira Issue: [DSA-99]

  #### before
  <img width="595" alt="Screen Shot 2023-03-30 at 17 42 13" src="https://user-images.githubusercontent.com/27704687/228959436-6ca2314f-5511-459e-8f8f-15bb91faa6ef.png">

  #### after
  <img width="596" alt="Screen Shot 2023-03-30 at 17 34 18" src="https://user-images.githubusercontent.com/27704687/228957916-b146b406-6ebd-4c76-9722-e1c6c9606252.png">

- `Service Configuration` async on server ([#28813](https://github.com/RocketChat/Rocket.Chat/pull/28813))

- `Subscriptions` - 3 ([#28538](https://github.com/RocketChat/Rocket.Chat/pull/28538))

- `Subscriptions` model - 2x ([#28535](https://github.com/RocketChat/Rocket.Chat/pull/28535))

- `Subscriptions` model 6/6 ([#28675](https://github.com/RocketChat/Rocket.Chat/pull/28675))

- `utils` to ts ([#28818](https://github.com/RocketChat/Rocket.Chat/pull/28818))

- Add "no-floating-promises" eslint rule - Part 1 ([#28463](https://github.com/RocketChat/Rocket.Chat/pull/28463))

- Add "no-floating-promises" eslint rule - Part 2 ([#28464](https://github.com/RocketChat/Rocket.Chat/pull/28464))

- Add "no-floating-promises" eslint rule - Part 3 ([#28435](https://github.com/RocketChat/Rocket.Chat/pull/28435))

- Add “no-misused-promises” eslint rule ([#28433](https://github.com/RocketChat/Rocket.Chat/pull/28433))

- Add `rid` to scope of `create-invite-links` permission check ([#28241](https://github.com/RocketChat/Rocket.Chat/pull/28241) by [@LucianoPierdona](https://github.com/LucianoPierdona))

  This PR fixes a bug where users with the `owner` role can't create invites because the button isn't being displayed for him, to solve this issue the `rid` was added to the scope of the check.

- Add missing await to online function ([#28602](https://github.com/RocketChat/Rocket.Chat/pull/28602))

- Add types for `Meteor.userAsync` ([#28597](https://github.com/RocketChat/Rocket.Chat/pull/28597))

- adjust sidebarPalette font colors ([#28886](https://github.com/RocketChat/Rocket.Chat/pull/28886))

  - due to changes made [here](https://github.com/RocketChat/fuselage/pull/1024) it's necessary to adjust the font-color tokens from sidebarPalette

- Allow RoomCoordinator.roomFind to be async ([#28566](https://github.com/RocketChat/Rocket.Chat/pull/28566))

- Apps modal adjustments and Typescript rewrite ([#28785](https://github.com/RocketChat/Rocket.Chat/pull/28785))

  Move markdown parser for apps `ModalBlock` from `apps/meteor` to `fuselage-ui-kit` package and rewrite some files related to Typescript.

- Bump apps engine dependency ([#28587](https://github.com/RocketChat/Rocket.Chat/pull/28587) by [@albuquerquefabio](https://github.com/albuquerquefabio))

- bump apps-engine version to 1.38.1 ([#28885](https://github.com/RocketChat/Rocket.Chat/pull/28885))

- Bump apps-engine version to 1.38.2 ([#29009](https://github.com/RocketChat/Rocket.Chat/pull/29009))

- Bump supercharge/mongodb-github-action from 1.7.0 to 1.9.0 ([#28003](https://github.com/RocketChat/Rocket.Chat/pull/28003) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump TypeScript version ([#28697](https://github.com/RocketChat/Rocket.Chat/pull/28697))

- canAccessRoomId to async ([#28540](https://github.com/RocketChat/Rocket.Chat/pull/28540))

- Change price filters for Enterprise apps ([#27553](https://github.com/RocketChat/Rocket.Chat/pull/27553))

  * Currently, Enterprise apps are classified as “Free apps”. Now, they have been moved to a new “Enterprise” category in the _Apps_ page of the Marketplace.
  
  * Created a new "Enterprise" pricing filter in the _Apps_ page.
  
  * Removed the "Free" tag next to the _install_ button for enterprise apps, on the _App Info_ page.

  ![New-version](https://user-images.githubusercontent.com/84182706/208493531-11fc0153-2c94-4fab-baac-e359ba89ed72.gif)

- Change Restore Section Settings button text ([#28894](https://github.com/RocketChat/Rocket.Chat/pull/28894))

  Jira task: [WM-10](https://rocketchat.atlassian.net/browse/WM-10?atlOrigin=eyJpIjoiYTdhOWYxMmVhZTJjNDc0ZjgxOWYxYTUxYTc0MDY0N2QiLCJwIjoiaiJ9)
  Changed the text of the restore section settings button from "Reset Section to Default" to "Restore Defaults".

  Demo image after:
  ![image](https://user-images.githubusercontent.com/43561537/231573999-44f3afe8-4ac8-431e-acd8-a385e1a55c59.png)

- Changed settings registry's callbacks to work with async functions ([#28784](https://github.com/RocketChat/Rocket.Chat/pull/28784))

- checkUsernameAvailability to async ([#28557](https://github.com/RocketChat/Rocket.Chat/pull/28557))

- Chore: Change the PR title check to use conventional commits ([#28358](https://github.com/RocketChat/Rocket.Chat/pull/28358))

- Chore: remove unused prop in register workspace modal ([#28317](https://github.com/RocketChat/Rocket.Chat/pull/28317))

- Chore: Remove/replace some Meteor packages ([#28189](https://github.com/RocketChat/Rocket.Chat/pull/28189))

- Chore: Unused/dead code removal ([#28155](https://github.com/RocketChat/Rocket.Chat/pull/28155))

- ci: add branch config back to checkout action ([#28802](https://github.com/RocketChat/Rocket.Chat/pull/28802))

- ci: fix flaky tests ([#28718](https://github.com/RocketChat/Rocket.Chat/pull/28718))

- ci: new label to check stale condition ([#28858](https://github.com/RocketChat/Rocket.Chat/pull/28858))

  I suggest adding the label `stat: stat: waiting response` to trigger the `Stale Questions` github action  

  Sometimes, contributors do not provide full reporting ( `stat: need more info` ) or do not answer maintainers questions to understand certain possible issues

- ci: revert Variable Setup changes ([#28754](https://github.com/RocketChat/Rocket.Chat/pull/28754))

  Due to a change in Variable Setup action, external contributors PR fails because the branch reference is not found, revert will make to use the default branch as reference

- ci: test qase report ([#28569](https://github.com/RocketChat/Rocket.Chat/pull/28569))

- ci: trigger repository_dispatch event on release ([#29191](https://github.com/RocketChat/Rocket.Chat/pull/29191))

- ci(docker): Push Docker tag for commit hash ([#28578](https://github.com/RocketChat/Rocket.Chat/pull/28578))

- convert addUserToRoom to async ([#28479](https://github.com/RocketChat/Rocket.Chat/pull/28479))

- Convert api.js to ts ([#28534](https://github.com/RocketChat/Rocket.Chat/pull/28534))

  This PR converts the API main file from JS to TS.
  Jira: ARCH-167

- convert apps api to ts ([#28815](https://github.com/RocketChat/Rocket.Chat/pull/28815))

  ARCH-182

- convert Audit model to async ([#28790](https://github.com/RocketChat/Rocket.Chat/pull/28790))

- Convert channels endpoints to TS ([#28469](https://github.com/RocketChat/Rocket.Chat/pull/28469))

  This PR converts all the (missing) `channels.`  endpoints to Typescript.
  Jira: ARCH-165

- Convert chat endpoints to TS ([#28417](https://github.com/RocketChat/Rocket.Chat/pull/28417))

  This PR converts all the `chat.` endpoint to Typescript.
  Jira: ARCH-163

- convert getRoomRoles to async ([#28485](https://github.com/RocketChat/Rocket.Chat/pull/28485))

- Convert groups endpoints to typescript ([#28432](https://github.com/RocketChat/Rocket.Chat/pull/28432))

  This PR converts all the `groups.` endpoint to Typescript.
  Jira: ARCH-164

- Convert meteor call to callAsync ([#28575](https://github.com/RocketChat/Rocket.Chat/pull/28575))

  Jira:
  ARCH-639
  ARCH-640
  ARCH-641
  ARCH-642
  ARCH-643
  ARCH-644
  ARCH-645
  ARCH-646
  ARCH-647
  ARCH-648

- Convert meteor call to callAsync (2/N) ([#28588](https://github.com/RocketChat/Rocket.Chat/pull/28588))

  Jira:
  ARCH-615
  ARCH-616
  ARCH-617
  ARCH-618
  ARCH-619
  ARCH-620
  ARCH-621
  ARCH-622
  ARCH-623
  ARCH-624
  ARCH-625
  ARCH-626
  ARCH-627
  ARCH-628
  ARCH-629
  ARCH-630
  ARCH-631
  ARCH-633
  ARCH-634
  ARCH-635
  ARCH-636
  ARCH-637

- convert omnichannel callbacks to ts ([#28564](https://github.com/RocketChat/Rocket.Chat/pull/28564))

- Convert our Upload Code to TS ([#28711](https://github.com/RocketChat/Rocket.Chat/pull/28711))

- Convert rooms endpoints to TS ([#28448](https://github.com/RocketChat/Rocket.Chat/pull/28448))

  This PR converts all the (missing) `rooms.` endpoints to Typescript.
  Jira: ARCH-166

- convert sendmessage to async ([#28580](https://github.com/RocketChat/Rocket.Chat/pull/28580))

- Convert small files to typescript ([#28835](https://github.com/RocketChat/Rocket.Chat/pull/28835))

- create EditOauthApp endpoints ([#26810](https://github.com/RocketChat/Rocket.Chat/pull/26810))

- createRoom.ts, createDirectRoom.ts and cleanRoomHistory.ts ([#28492](https://github.com/RocketChat/Rocket.Chat/pull/28492))

- ddp streamer typings ([#28437](https://github.com/RocketChat/Rocket.Chat/pull/28437))

- Dead code and spurious exports ([#28654](https://github.com/RocketChat/Rocket.Chat/pull/28654))

- Delete unused `.../surfaces/SurfaceContext.tsx` ([#28690](https://github.com/RocketChat/Rocket.Chat/pull/28690))

- deleteRoom to async ([#28786](https://github.com/RocketChat/Rocket.Chat/pull/28786))

- Ditch `Meteor.user` in favor of `Meteor.userAsync` - 1x ([#28601](https://github.com/RocketChat/Rocket.Chat/pull/28601))

- Don't use meteor collections on migrations ([#28563](https://github.com/RocketChat/Rocket.Chat/pull/28563))

- Easy replacements of Meteor.call to Meteor.callAsync ([#28595](https://github.com/RocketChat/Rocket.Chat/pull/28595))

- Embed error boundary into `AppRoot` ([#28393](https://github.com/RocketChat/Rocket.Chat/pull/28393))

- Feature parity for EE models ([#28614](https://github.com/RocketChat/Rocket.Chat/pull/28614))

- federation Promise.await 1/N ([#28591](https://github.com/RocketChat/Rocket.Chat/pull/28591))

- federation promise.await methods 2/N ([#28593](https://github.com/RocketChat/Rocket.Chat/pull/28593))

- Federation refactor towards services + file names improvement + E2E tests fixes ([#28326](https://github.com/RocketChat/Rocket.Chat/pull/28326))

  This PR is the one that groups the other 4 PRs related to refactoring federation moving from the regular "app" folder to the new services implementation, it also refactors some files and folders to more meaningful and finally it fix some E2E tests.

  https://github.com/RocketChat/Rocket.Chat/pull/28263
  https://github.com/RocketChat/Rocket.Chat/pull/28267
  https://github.com/RocketChat/Rocket.Chat/pull/28295
  https://github.com/RocketChat/Rocket.Chat/pull/28158

- File attachment input border cut fix ([#28359](https://github.com/RocketChat/Rocket.Chat/pull/28359))

  Remove the `overflow: hidden` property in the file attachment modal that was cutting the horizontal focus border in the input. Easier to see the issue using the dark theme.

  Before:
  ![image](https://user-images.githubusercontent.com/48109548/224320435-94fb04b1-c800-47f7-8229-636c1115129b.png)

  After:
  <img width="580" alt="Screen Shot 2023-03-10 at 09 57 38" src="https://user-images.githubusercontent.com/48109548/224321919-c9f3902a-36e1-427c-b4f7-fb204d0a8654.png">

- fix ha scripts ([#28913](https://github.com/RocketChat/Rocket.Chat/pull/28913))

- Fork minor Meteor packages ([#28337](https://github.com/RocketChat/Rocket.Chat/pull/28337))

  It forks Meteor packages that are lightweight in terms of dependencies for portability.

- getMongoInfo.js, versio-check and missing meteor methods ([#28529](https://github.com/RocketChat/Rocket.Chat/pull/28529))

- hasPermission to async - first part ([#28533](https://github.com/RocketChat/Rocket.Chat/pull/28533))

- how can i help? link broken ([#28943](https://github.com/RocketChat/Rocket.Chat/pull/28943) by [@Dhruwang](https://github.com/Dhruwang))

- i18n: fix sentence in 2fa email modal text ([#28683](https://github.com/RocketChat/Rocket.Chat/pull/28683))

  From:
  "Verify_your_email_`for`_the_code_we_sent": "Verify your email `for` the code we sent",

  To:
  "Verify_your_email_`with`_the_code_we_sent": "Verify your email `with` the code we sent",

- i18n: German translation ([#28871](https://github.com/RocketChat/Rocket.Chat/pull/28871))

  Improving German translation as german Contributor Issue requested

- i18n: Language update from LingoHub 🤖 on 2023-03-10Z ([#28365](https://github.com/RocketChat/Rocket.Chat/pull/28365))

- i18n: Language update from LingoHub 🤖 on 2023-04-13Z ([#28908](https://github.com/RocketChat/Rocket.Chat/pull/28908))

- ignore `.eslintcache` ([#28475](https://github.com/RocketChat/Rocket.Chat/pull/28475))

- improve change stream error handler ([#29195](https://github.com/RocketChat/Rocket.Chat/pull/29195))

- Improve sidebar search list hook ([#28328](https://github.com/RocketChat/Rocket.Chat/pull/28328))

- improve tests for livechat/config api ([#28658](https://github.com/RocketChat/Rocket.Chat/pull/28658))

- Isolate last Promise.await calls on accounts’ code ([#28817](https://github.com/RocketChat/Rocket.Chat/pull/28817))

- Isolate Promise.await of updateOrCreateUserFromExternalService ([#28811](https://github.com/RocketChat/Rocket.Chat/pull/28811))

- Limit 10 usernames on reactions tooltip ([#28141](https://github.com/RocketChat/Rocket.Chat/pull/28141))

- Low hanging fruits (1/N) ([#28555](https://github.com/RocketChat/Rocket.Chat/pull/28555))

- Low hanging fruits (2/2) ([#28556](https://github.com/RocketChat/Rocket.Chat/pull/28556))

- Make `onLicense` support async callbacks ([#28791](https://github.com/RocketChat/Rocket.Chat/pull/28791))

- make `roomcoordinator.roomName` async ([#28609](https://github.com/RocketChat/Rocket.Chat/pull/28609))

- make callbacks accept async ([#28486](https://github.com/RocketChat/Rocket.Chat/pull/28486))

- Make CI fail if checks fail ([#28552](https://github.com/RocketChat/Rocket.Chat/pull/28552))

- Meteor 2.11 ([#28716](https://github.com/RocketChat/Rocket.Chat/pull/28716))

- Meteor.user to Meteor.userAsync 1 ([#28629](https://github.com/RocketChat/Rocket.Chat/pull/28629))

- Migrate SMS to Service ([#28123](https://github.com/RocketChat/Rocket.Chat/pull/28123))

  - Moves everything related to SMS on Omnichannel to a service (Integrations)
  
  - Service left with broad name as it will contain more "integrations" (webhooks, for example)
  
  - Removed /app/sms folder
  
  - Moved some files to typescript

- Miscelaneous ([#28732](https://github.com/RocketChat/Rocket.Chat/pull/28732))

- Modal form wrapper ([#27778](https://github.com/RocketChat/Rocket.Chat/pull/27778))

- Models feature parity ([#28456](https://github.com/RocketChat/Rocket.Chat/pull/28456))

- move `Subscriptions` 1x ([#28531](https://github.com/RocketChat/Rocket.Chat/pull/28531))

- Move banner orchestration to `BannerRegion` effects ([#28414](https://github.com/RocketChat/Rocket.Chat/pull/28414))

  It removes the necessity of keeping trackers dodging the setup wizard process.

- Move callbacks to ts - 2 ([#28771](https://github.com/RocketChat/Rocket.Chat/pull/28771))

- Move callbacks to ts 1X ([#28710](https://github.com/RocketChat/Rocket.Chat/pull/28710))

- Move email verification warning to `UserProvider` ([#28703](https://github.com/RocketChat/Rocket.Chat/pull/28703))

- Move fileupload implementation to async ([#28769](https://github.com/RocketChat/Rocket.Chat/pull/28769))

- Move from `meteor/http` to `meteor/fetch` - 2x ([#28799](https://github.com/RocketChat/Rocket.Chat/pull/28799))

- move from canAccessRoom to canAccessRoomAsync ([#28477](https://github.com/RocketChat/Rocket.Chat/pull/28477))

- move from canDeleteMessage to canDeleteMessageAsync ([#28480](https://github.com/RocketChat/Rocket.Chat/pull/28480))

- move hasAllPermission to hasAllPermissionAsync ([#28674](https://github.com/RocketChat/Rocket.Chat/pull/28674))

- move hasPermission to async ([#28512](https://github.com/RocketChat/Rocket.Chat/pull/28512))

- move subscriptions 4x ([#28548](https://github.com/RocketChat/Rocket.Chat/pull/28548))

- Move UFS out of meteor packages ([#28672](https://github.com/RocketChat/Rocket.Chat/pull/28672))

- New inquiry functional test ([#28559](https://github.com/RocketChat/Rocket.Chat/pull/28559) by [@cauefcr](https://github.com/cauefcr))

  This PR tests if inquiries change to taken after they're taken, as well as test most fields of inquiries.getOne

- Omnichannel analytics conversion to typescript ([#27940](https://github.com/RocketChat/Rocket.Chat/pull/27940) by [@FabioCavaleti](https://github.com/FabioCavaleti))

  In this PR I converted the omnichannel analytics files to typescript

- Patch dependencies ([#29024](https://github.com/RocketChat/Rocket.Chat/pull/29024))

- Prettier version ([#28857](https://github.com/RocketChat/Rocket.Chat/pull/28857))

  It upgrades and equalizes Prettier versions across packages.

- Promise.await removal  ([#28481](https://github.com/RocketChat/Rocket.Chat/pull/28481))

- Promise.await removal - ReadReceipt ([#28661](https://github.com/RocketChat/Rocket.Chat/pull/28661))

- promise.await removal 8/N ([#28560](https://github.com/RocketChat/Rocket.Chat/pull/28560))

- Reconditioning of `/app/ui-*` modules ([#28620](https://github.com/RocketChat/Rocket.Chat/pull/28620))

- Refactoring Not Found pages ([#26715](https://github.com/RocketChat/Rocket.Chat/pull/26715))

  Create `NotFoundState` component to use on `NotFoundPage` and `RoomNotFound`

- Refine `IUser[settings]` ([#28403](https://github.com/RocketChat/Rocket.Chat/pull/28403))

  It makes it optional.

- regression:  push gateway response as JSON ([#28899](https://github.com/RocketChat/Rocket.Chat/pull/28899))

- regression: `fetch` call in `getWorkspaceAccessTokenWithScope` ([#28866](https://github.com/RocketChat/Rocket.Chat/pull/28866))

- regression: `fetch` JSON response doesn't have a `data` property ([#28952](https://github.com/RocketChat/Rocket.Chat/pull/28952))

- regression: `fetch` response ([#29032](https://github.com/RocketChat/Rocket.Chat/pull/29032))

- regression: `ToolboxDropdown` being used as `IconButton` child ([#29035](https://github.com/RocketChat/Rocket.Chat/pull/29035))

- regression: add missing await for RocketChatFile ([#28807](https://github.com/RocketChat/Rocket.Chat/pull/28807))

- regression: await `getUserInfo` promise on login ([#28655](https://github.com/RocketChat/Rocket.Chat/pull/28655))

- regression: custom emojis are not visible ([#29084](https://github.com/RocketChat/Rocket.Chat/pull/29084))

- regression: Delete Message Modal not closing on error in deleting a message ([#29184](https://github.com/RocketChat/Rocket.Chat/pull/29184))

  This PR fixes the delete message modal on Moderation Console not closing, if an error occurs while deleting the message

- regression: Delete room modal not closing ([#28554](https://github.com/RocketChat/Rocket.Chat/pull/28554))

- regression: Emoji fill prop ([#28992](https://github.com/RocketChat/Rocket.Chat/pull/28992))

  ### Before
  ![image](https://user-images.githubusercontent.com/58601732/233422115-35b08b46-0790-4318-bb20-d9b92dfa7598.png)

  ### After
  <img width="714" alt="image" src="https://user-images.githubusercontent.com/58601732/233422248-01a8eee5-e103-4322-b29c-cf47ee985661.png">

- regression: Error inserting read-receipts with the new Messages model ([#28671](https://github.com/RocketChat/Rocket.Chat/pull/28671))

  - Fix the following error when inserting read receipts:
  ```
  @rocket.chat/meteor:dsv: I20230328-16:36:11.569(-3)? [2023-03-28T19:36:10.798Z] ERROR: Argument "docs" must be an array of documents
  @rocket.chat/meteor:dsv: I20230328-16:36:11.569(-3)?     err: {
  @rocket.chat/meteor:dsv: I20230328-16:36:11.569(-3)?       "type": "MongoInvalidArgumentError",
  @rocket.chat/meteor:dsv: I20230328-16:36:11.569(-3)?       "message": "Argument \"docs\" must be an array of documents",
  @rocket.chat/meteor:dsv: I20230328-16:36:11.570(-3)?       "stack":
  @rocket.chat/meteor:dsv: I20230328-16:36:11.570(-3)?           MongoInvalidArgumentError: Argument "docs" must be an array of documents
  @rocket.chat/meteor:dsv: I20230328-16:36:11.570(-3)?               at new InsertManyOperation (/home/matheus/.meteor/packages/npm-mongo/.4.12.1.1u9ugqv.zpd9++os+web.browser+web.browser.legacy+web.cordova/npm/node_modules/mongodb/lib/operations/insert.js:68:19)
  @rocket.chat/meteor:dsv: I20230328-16:36:11.570(-3)?               at Collection.insertMany (/home/matheus/.meteor/packages/npm-mongo/.4.12.1.1u9ugqv.zpd9++os+web.browser+web.browser.legacy+web.cordova/npm/node_modules/mongodb/lib/collection.js:154:78)
  @rocket.chat/meteor:dsv: I20230328-16:36:11.570(-3)?               at Proxy.insertMany (server/models/raw/BaseRaw.ts:231:19)
  @rocket.chat/meteor:dsv: I20230328-16:36:11.570(-3)?               at ee/server/lib/message-read-receipt/ReadReceipt.js:108:24
  @rocket.chat/meteor:dsv: I20230328-16:36:11.570(-3)?               at /home/matheus/.meteor/packages/promise/.0.12.2.bqfx3w.89spp++os+web.browser+web.browser.legacy+web.cordova/npm/node_modules/meteor-promise/fiber_pool.js:43:40
  @rocket.chat/meteor:dsv: I20230328-16:36:11.570(-3)?     }
  ```

- regression: Escape regex for moderation dashboard filters ([#29214](https://github.com/RocketChat/Rocket.Chat/pull/29214))

- regression: fix apps-engine persistence methods ([#28688](https://github.com/RocketChat/Rocket.Chat/pull/28688))

  Change methods to adapt new models.

- regression: fix CI ([#28537](https://github.com/RocketChat/Rocket.Chat/pull/28537))

- regression: Fix monitor validation logic for rooms & departments ([#29213](https://github.com/RocketChat/Rocket.Chat/pull/29213))

- regression: fix notifyDesktopUser ([#28659](https://github.com/RocketChat/Rocket.Chat/pull/28659))

- regression: Fix UserCard height to avoid position glitch ([#29151](https://github.com/RocketChat/Rocket.Chat/pull/29151))

  The user card has different dimensions when it is loading and when it has loaded the contents. Due to this change in dimensions, it sometimes changes the position of the userCard. So, making the user card as fixed size so this doesn't happen.

- regression: Fixed department fowarding not accounting for empty array ([#29026](https://github.com/RocketChat/Rocket.Chat/pull/29026))

- regression: Fixed livechat notifications displaying [object Promise] on title ([#29021](https://github.com/RocketChat/Rocket.Chat/pull/29021))

- regression: invalid callback callAsync ([#28766](https://github.com/RocketChat/Rocket.Chat/pull/28766))

- regression: ldap sync not working ([#28583](https://github.com/RocketChat/Rocket.Chat/pull/28583))

- regression: Livechat rooms not opening ([#28957](https://github.com/RocketChat/Rocket.Chat/pull/28957))

  This PR changes the way `room-info` tab is opened in livechat room to avoid race conditions from preventing the rooms from opening

- regression: Message auditing panel not working ([#28980](https://github.com/RocketChat/Rocket.Chat/pull/28980))

  Introduced in #28772

- regression: Missing display prop on `ComposerBoxPopupPreview` ([#29010](https://github.com/RocketChat/Rocket.Chat/pull/29010))

- regression: Model `upsert` doesn't exist anymore ([#29144](https://github.com/RocketChat/Rocket.Chat/pull/29144))

- regression: name search not working in moderation console ([#29209](https://github.com/RocketChat/Rocket.Chat/pull/29209))

  - Added back the search by-name feature
  
  - Fixed an incorrect Mongo filter key

- regression: Opening DM through UserCard takes too long. ([#29190](https://github.com/RocketChat/Rocket.Chat/pull/29190))

- regression: Quote message not working for omnichannel visitors ([#29212](https://github.com/RocketChat/Rocket.Chat/pull/29212))

- regression: Reactivity Issue when agent takes a chat ([#28966](https://github.com/RocketChat/Rocket.Chat/pull/28966))

- regression: remove callbacks from `Meteor.callAsync` ([#28809](https://github.com/RocketChat/Rocket.Chat/pull/28809))

- regression: Remove unused autocomplete Blaze Template ([#29047](https://github.com/RocketChat/Rocket.Chat/pull/29047))

- regression: removed css for unread and upload indicators ([#28645](https://github.com/RocketChat/Rocket.Chat/pull/28645))

  I had to revert a css deletion to rollback the styles form Upload and Unread indicators

  **Current (problem):** 
  ![image](https://user-images.githubusercontent.com/20212776/228034906-57f9a818-e071-4102-9410-b9e03afbb777.png)

  **Expected: (current changes)**
  ![image](https://user-images.githubusercontent.com/20212776/228035090-1ef28ce8-2ab1-46a0-aeff-b9aa76c79e5f.png)
  ![image](https://user-images.githubusercontent.com/20212776/228035150-fc259b37-83c5-458c-8e4f-8a6a822af641.png)

- regression: Render `Markup` for all UiKit surfaces ([#28922](https://github.com/RocketChat/Rocket.Chat/pull/28922))

- regression: Reply in DM not working with hide_FlexTab ([#29227](https://github.com/RocketChat/Rocket.Chat/pull/29227))

- regression: Room avatar upload not working ([#29185](https://github.com/RocketChat/Rocket.Chat/pull/29185))

- regression: Room crashes ([#29006](https://github.com/RocketChat/Rocket.Chat/pull/29006))

- regression: Room Not Found bg color ([#28668](https://github.com/RocketChat/Rocket.Chat/pull/28668))

  ### Before
  ![image](https://user-images.githubusercontent.com/58601732/228342784-a2dc3a3f-32b4-4ded-a984-2ddb967f3e1c.png)

  ### After
  ![image](https://user-images.githubusercontent.com/58601732/228342875-0cd1773c-b33b-410f-b8b4-852aa360f6b4.png)

- regression: SlackBridge settings UI crashing ([#29050](https://github.com/RocketChat/Rocket.Chat/pull/29050))

- regression: smtp connection error ([#28942](https://github.com/RocketChat/Rocket.Chat/pull/28942))

- regression: submitting text in the LDAP User Search modal reloads the page ([#29137](https://github.com/RocketChat/Rocket.Chat/pull/29137))

  - Fix page reload when submitting text on the "LDAP User Search" modal.

- regression: Thread Preview breaking room ([#28605](https://github.com/RocketChat/Rocket.Chat/pull/28605))

  This regression was caused by this PR: https://github.com/RocketChat/Rocket.Chat/pull/28454 

  Webhooks/integrations sometimes send an empty array to the messages object, because of that was necessary to double check if the array in not empty.

- regression: user creation is failing ([#28998](https://github.com/RocketChat/Rocket.Chat/pull/28998))

- regression(e2e): Missing private key blocks sending message in encrypted rooms ([#28831](https://github.com/RocketChat/Rocket.Chat/pull/28831))

  A field was incorrectly defined as `private` while used as `public` in a JavaScript module.

- regression(file-upload:s3): Fix missing store import ([#28781](https://github.com/RocketChat/Rocket.Chat/pull/28781))

- Remove `Apps persistence` model ([#28510](https://github.com/RocketChat/Rocket.Chat/pull/28510))

- Remove `apps` & `app logs` models ([#28509](https://github.com/RocketChat/Rocket.Chat/pull/28509))

- Remove `canned responses` model ([#28686](https://github.com/RocketChat/Rocket.Chat/pull/28686))

- Remove `CodeMirror` blaze template and visual fixes ([#28734](https://github.com/RocketChat/Rocket.Chat/pull/28734))

  #### before
  <img width="520" alt="Screen Shot 2023-03-31 at 13 39 34" src="https://user-images.githubusercontent.com/27704687/229179650-0103646d-8109-4897-ab98-e201d943262a.png">

  #### after
  <img width="520" alt="Screen Shot 2023-03-31 at 13 38 00" src="https://user-images.githubusercontent.com/27704687/229179410-a968e207-61b3-477d-9ab6-f07d5e5ab39e.png">

- Remove `FederationRoomEvents` model ([#28488](https://github.com/RocketChat/Rocket.Chat/pull/28488))

- Remove `ImportData` meteor model ([#28458](https://github.com/RocketChat/Rocket.Chat/pull/28458))

- Remove `LivechatInquiry` model ([#28487](https://github.com/RocketChat/Rocket.Chat/pull/28487))

- Remove `logging` and `gravatar` packages ([#28834](https://github.com/RocketChat/Rocket.Chat/pull/28834))

- Remove `Meteor.call` from `getRoomByNameOrIdWithOptionToJoin` ([#28610](https://github.com/RocketChat/Rocket.Chat/pull/28610))

- Remove `Meteor.call` from server calls ([#28774](https://github.com/RocketChat/Rocket.Chat/pull/28774))

- Remove `Meteor.call` in favor of `Meteor.callAsync` - 1 ([#28576](https://github.com/RocketChat/Rocket.Chat/pull/28576))

- Remove `Promise.await` calls from importer classes ([#28404](https://github.com/RocketChat/Rocket.Chat/pull/28404))

- remove `Promise.await` calls from irc bridge ([#28406](https://github.com/RocketChat/Rocket.Chat/pull/28406))

- Remove `Promise.await` calls from Slack Adapter ([#28408](https://github.com/RocketChat/Rocket.Chat/pull/28408))

- remove `Promise.await` calls from twitter Oauth implementation ([#28407](https://github.com/RocketChat/Rocket.Chat/pull/28407))

- Remove `Units` and `UnitMonitors` models ([#28708](https://github.com/RocketChat/Rocket.Chat/pull/28708))

- Remove all API helpers from the API prototype ([#28498](https://github.com/RocketChat/Rocket.Chat/pull/28498))

  This PR removes all the API helpers from the API prototype and converts it to regular functions instead.
  Jira: ARCH-934

- Remove all occurrences ([#28647](https://github.com/RocketChat/Rocket.Chat/pull/28647))

  ARCH-180

- Remove dangling `direct` field on minimongo collections ([#28833](https://github.com/RocketChat/Rocket.Chat/pull/28833))

- Remove easy to remove promise.awaits ([#28606](https://github.com/RocketChat/Rocket.Chat/pull/28606))

- Remove fibers from `linkedin-oauth` ([#28779](https://github.com/RocketChat/Rocket.Chat/pull/28779))

- Remove fibers from `rocketchat-version` package ([#28776](https://github.com/RocketChat/Rocket.Chat/pull/28776))

- Remove fibers from Users Model ([#28797](https://github.com/RocketChat/Rocket.Chat/pull/28797))

  ARCH-932

- Remove fibers from users models 8 ([#28728](https://github.com/RocketChat/Rocket.Chat/pull/28728))

- remove hasRole to hasRoleAsync ([#28648](https://github.com/RocketChat/Rocket.Chat/pull/28648))

- Remove invalid `aria-description` from list menus ([#28471](https://github.com/RocketChat/Rocket.Chat/pull/28471))

- Remove more promise awaits ([#28796](https://github.com/RocketChat/Rocket.Chat/pull/28796))

- Remove more promise awaits ([#28733](https://github.com/RocketChat/Rocket.Chat/pull/28733))

- Remove old css ([#28140](https://github.com/RocketChat/Rocket.Chat/pull/28140))

- Remove optional return of room coordinator ([#28592](https://github.com/RocketChat/Rocket.Chat/pull/28592))

- Remove promise await ([#28399](https://github.com/RocketChat/Rocket.Chat/pull/28399))

- remove Promise.await ([#28539](https://github.com/RocketChat/Rocket.Chat/pull/28539))

- remove Promise.await ([#28483](https://github.com/RocketChat/Rocket.Chat/pull/28483))

- Remove Promise.await - apps/meteor/app/api/server/api.js ([#28476](https://github.com/RocketChat/Rocket.Chat/pull/28476))

- Remove promise.await 7/N ([#28651](https://github.com/RocketChat/Rocket.Chat/pull/28651))

- Remove promise.await 8/N - Dashboard ([#28652](https://github.com/RocketChat/Rocket.Chat/pull/28652))

- Remove promise.await from apps ([#28612](https://github.com/RocketChat/Rocket.Chat/pull/28612))

  Jira:
  ARCH-382
  ARCH-383
  ARCH-384
  ARCH-385

- Remove promise.await from csv importer ([#28810](https://github.com/RocketChat/Rocket.Chat/pull/28810))

- Remove Promise.await from importer-pendind-file.js ([#28812](https://github.com/RocketChat/Rocket.Chat/pull/28812))

- remove Promise.await from LDAP files ([#28527](https://github.com/RocketChat/Rocket.Chat/pull/28527))

- remove Promise.await from oauth manager ([#28530](https://github.com/RocketChat/Rocket.Chat/pull/28530))

- Remove Promise.await from teams-mention feature ([#28532](https://github.com/RocketChat/Rocket.Chat/pull/28532))

- Remove promise.await N/N ([#28643](https://github.com/RocketChat/Rocket.Chat/pull/28643))

- Remove remaining EE meteor models ([#28713](https://github.com/RocketChat/Rocket.Chat/pull/28713))

- remove some Meteor.bindEnvironment ([#28822](https://github.com/RocketChat/Rocket.Chat/pull/28822))

  ARCH-948

- Remove unnecessary Tokens collection and Fibers usage ([#28803](https://github.com/RocketChat/Rocket.Chat/pull/28803))

- Remove unused meteor packages ([#28821](https://github.com/RocketChat/Rocket.Chat/pull/28821))

- Remove Users from fibers 10 ([#28737](https://github.com/RocketChat/Rocket.Chat/pull/28737))

- remove Users from fibers 11 ([#28740](https://github.com/RocketChat/Rocket.Chat/pull/28740))

- remove Users from fibers 12 ([#28767](https://github.com/RocketChat/Rocket.Chat/pull/28767))

- remove Users from fibers 13 ([#28772](https://github.com/RocketChat/Rocket.Chat/pull/28772))

- remove Users from fibers 14 ([#28780](https://github.com/RocketChat/Rocket.Chat/pull/28780))

- remove Users from fibers 15 ([#28789](https://github.com/RocketChat/Rocket.Chat/pull/28789))

- Remove Users from fibers 3N ([#28669](https://github.com/RocketChat/Rocket.Chat/pull/28669))

- Remove Users from fibers 4 ([#28680](https://github.com/RocketChat/Rocket.Chat/pull/28680))

- Remove Users from fibers 5 ([#28687](https://github.com/RocketChat/Rocket.Chat/pull/28687))

- Remove Users from fibers 6 ([#28689](https://github.com/RocketChat/Rocket.Chat/pull/28689))

- Remove Users from fibers 7 ([#28702](https://github.com/RocketChat/Rocket.Chat/pull/28702))

- remove Users from fibers 9 ([#28731](https://github.com/RocketChat/Rocket.Chat/pull/28731))

- Remove Users from fibers use inside 2FA feature ([#28641](https://github.com/RocketChat/Rocket.Chat/pull/28641))

  Part of ARCH-932

- Remove Users Model from fibers 2N ([#28660](https://github.com/RocketChat/Rocket.Chat/pull/28660))

- Remove wrapAsync and convert to TS ([#28823](https://github.com/RocketChat/Rocket.Chat/pull/28823))

- Replace `_.isObject` with `isObject` ([#28376](https://github.com/RocketChat/Rocket.Chat/pull/28376))

  It introduces another function to lower our dependency on underscore.js.

- Replace `useForm` in favor of `react-hook-form` on CreateDiscussion ([#28249](https://github.com/RocketChat/Rocket.Chat/pull/28249))

- Restore removed function for counting on LivechatDepartmentAgents ([#28577](https://github.com/RocketChat/Rocket.Chat/pull/28577))

- revert: removal of `Meteor.bindEnvironment` on `DDPRateLimiter.addRule` ([#28874](https://github.com/RocketChat/Rocket.Chat/pull/28874))

- Room Model 3/N ([#28599](https://github.com/RocketChat/Rocket.Chat/pull/28599))

- Room Model 4/N ([#28618](https://github.com/RocketChat/Rocket.Chat/pull/28618))

- Room Models 2/N ([#28598](https://github.com/RocketChat/Rocket.Chat/pull/28598))

- Rooms model 1/2 ([#28694](https://github.com/RocketChat/Rocket.Chat/pull/28694))

- Rooms Model 5/N  ([#28619](https://github.com/RocketChat/Rocket.Chat/pull/28619))

- rooms model remove findOneByIdOrName to async ([#28596](https://github.com/RocketChat/Rocket.Chat/pull/28596))

- saveUserIdentity.ts, saveUser.js, relinquishRoomOwnerships.ts and deleteMessage.ts ([#28493](https://github.com/RocketChat/Rocket.Chat/pull/28493))

- Subscriptions model - 5 ([#28550](https://github.com/RocketChat/Rocket.Chat/pull/28550))

- Theme changes on clicking Label ([#28397](https://github.com/RocketChat/Rocket.Chat/pull/28397) by [@AdityaSingh-02](https://github.com/AdityaSingh-02))

  As we know Rocket.chat v6.0.0 came with Different themes , where we could simply switch between dark and light mode, but the issue was that When we were wishing to change theme we could only do that by clicking the radio button, but i have made few changes in file where we can also change theme by clicking the label



  https://user-images.githubusercontent.com/94185167/224779377-822bb01c-83d0-4714-b54b-ef4239c96fbf.mp4

- Types of Meteor methods (1/N) ([#28420](https://github.com/RocketChat/Rocket.Chat/pull/28420))

- Types of Meteor methods (10/10) ([#28541](https://github.com/RocketChat/Rocket.Chat/pull/28541))

- Types of Meteor methods (2/N) ([#28424](https://github.com/RocketChat/Rocket.Chat/pull/28424))

- Types of Meteor methods (3/N) ([#28431](https://github.com/RocketChat/Rocket.Chat/pull/28431))

- Types of Meteor methods (4/N) ([#28452](https://github.com/RocketChat/Rocket.Chat/pull/28452))

- Types of Meteor methods (5/N)  ([#28461](https://github.com/RocketChat/Rocket.Chat/pull/28461))

- Types of Meteor methods (6/N) ([#28478](https://github.com/RocketChat/Rocket.Chat/pull/28478))

- Types of Meteor methods (7/N) ([#28482](https://github.com/RocketChat/Rocket.Chat/pull/28482))

- Types of Meteor methods (8/N) ([#28511](https://github.com/RocketChat/Rocket.Chat/pull/28511))

- Types of Meteor methods (9/N) ([#28528](https://github.com/RocketChat/Rocket.Chat/pull/28528))

- Update `codeql` to v2 ([#28692](https://github.com/RocketChat/Rocket.Chat/pull/28692))

- Update `vm2` ([#29025](https://github.com/RocketChat/Rocket.Chat/pull/29025))

- update Apps-Engine to latest ([#29229](https://github.com/RocketChat/Rocket.Chat/pull/29229))

  Apps-Engine v1.39.0

- Update Apps-Engine to latest ([#28646](https://github.com/RocketChat/Rocket.Chat/pull/28646))

  Update the Apps-Engine version to v1.38.0

- Update CODEOWNERS ([#28525](https://github.com/RocketChat/Rocket.Chat/pull/28525))

- update documentation ([#28719](https://github.com/RocketChat/Rocket.Chat/pull/28719) by [@SANTHOSH-MAMIDISETTI](https://github.com/SANTHOSH-MAMIDISETTI))

- Update fuselage packages ([#29157](https://github.com/RocketChat/Rocket.Chat/pull/29157))

- Update issue_template.md ([#28753](https://github.com/RocketChat/Rocket.Chat/pull/28753) by [@adityakode](https://github.com/adityakode))

- Update meteor types ([#28884](https://github.com/RocketChat/Rocket.Chat/pull/28884))

- Update Pull Request Template  ([#28373](https://github.com/RocketChat/Rocket.Chat/pull/28373) by [@chinma-yyy](https://github.com/chinma-yyy))

- Upgrade `caniuse-lite` ([#28377](https://github.com/RocketChat/Rocket.Chat/pull/28377))

  It upgrades the `caniuse-lite` database for Browserslist.

- Upgrade `vm2` ([#28860](https://github.com/RocketChat/Rocket.Chat/pull/28860))

  It patches `vm2`.

- Use `fetch` instead of `meteor/http` ([#28682](https://github.com/RocketChat/Rocket.Chat/pull/28682))

- Use Messages Raw model (1/N) ([#28503](https://github.com/RocketChat/Rocket.Chat/pull/28503))

- Use Messages Raw model (10/10) ([#28695](https://github.com/RocketChat/Rocket.Chat/pull/28695))

- Use Messages Raw model (2/N) ([#28505](https://github.com/RocketChat/Rocket.Chat/pull/28505))

- Use Messages Raw model (3/N) ([#28549](https://github.com/RocketChat/Rocket.Chat/pull/28549))

- Use Messages Raw model (4/N) ([#28558](https://github.com/RocketChat/Rocket.Chat/pull/28558))

- Use Messages Raw model (5/N) ([#28590](https://github.com/RocketChat/Rocket.Chat/pull/28590))

- Use Messages Raw model (6/N) ([#28644](https://github.com/RocketChat/Rocket.Chat/pull/28644))

- Use Messages Raw model (7/N) ([#28653](https://github.com/RocketChat/Rocket.Chat/pull/28653))

- Use Messages Raw model (8/N) ([#28678](https://github.com/RocketChat/Rocket.Chat/pull/28678))

- Use Messages Raw model (9/N) ([#28693](https://github.com/RocketChat/Rocket.Chat/pull/28693))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@AdityaSingh-02](https://github.com/AdityaSingh-02)
- [@Bankar-Swapnil](https://github.com/Bankar-Swapnil)
- [@Dhruwang](https://github.com/Dhruwang)
- [@Educg550](https://github.com/Educg550)
- [@FabioCavaleti](https://github.com/FabioCavaleti)
- [@LucianoPierdona](https://github.com/LucianoPierdona)
- [@Nabhag8848](https://github.com/Nabhag8848)
- [@Pranshu1902](https://github.com/Pranshu1902)
- [@SANTHOSH-MAMIDISETTI](https://github.com/SANTHOSH-MAMIDISETTI)
- [@Shailesh351](https://github.com/Shailesh351)
- [@Thiagof99](https://github.com/Thiagof99)
- [@XshubhamX](https://github.com/XshubhamX)
- [@adarshlilha](https://github.com/adarshlilha)
- [@adijr9487](https://github.com/adijr9487)
- [@adityakode](https://github.com/adityakode)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@avelino](https://github.com/avelino)
- [@ayush3160](https://github.com/ayush3160)
- [@bhardwajdisha](https://github.com/bhardwajdisha)
- [@cauefcr](https://github.com/cauefcr)
- [@chinma-yyy](https://github.com/chinma-yyy)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@filipemarins](https://github.com/filipemarins)
- [@jayesh-jain252](https://github.com/jayesh-jain252)
- [@nmagedman](https://github.com/nmagedman)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@Dnouv](https://github.com/Dnouv)
- [@KevLehman](https://github.com/KevLehman)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@casalsgh](https://github.com/casalsgh)
- [@csuadev](https://github.com/csuadev)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@gabriellsh](https://github.com/gabriellsh)
- [@gbrfilipe](https://github.com/gbrfilipe)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@hugocostadev](https://github.com/hugocostadev)
- [@jeanfbrito](https://github.com/jeanfbrito)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tapiarafael](https://github.com/tapiarafael)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@totoi690](https://github.com/totoi690)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 6.1.7

`2023-05-12  ·  2 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.38.3`

### 🐛 Bug fixes


- app status inconsistencies when running multiple instances in a cluster ([#29220](https://github.com/RocketChat/Rocket.Chat/pull/29220))

  App status inconsistencies between multiple instances in a cluster boil down to the fact that the Apps-Engine is currently responsible for orchestrating when these events are triggered and is overly verbose in doing so.

  Upon analysis, the framework itself _should not_ have the concept of "other instances"   - this is a deployment detail of the host system, and as such should be controlled by the host. The correct solution for this problem is to review this notification system, potentially removing it from the framework and leaving the responsibility solely for Rocket.Chat.

  However, this is hindering the current app management experience for workspaces, so this PR cuts the control of some notifications that come from the framework (the more problematic ones) and moves the control over to RC in a short and practical way.

  This is done by turning the methods of the most problematic events in the `AppActivationBridge` into no-ops, and instead triggering the `AppServerNotifier` directly in the api endpoints that are applicable.

  It is _not_ the most correct solution to the problem, but due to time constraints and urgency this will be applied first so we can move with the correct solution in a future point.

- Migration error when removing 'snipetted' index ([#29215](https://github.com/RocketChat/Rocket.Chat/pull/29215))

### 👩‍💻👨‍💻 Core Team 🤓

- [@d-gubert](https://github.com/d-gubert)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 6.1.6

`2023-05-02  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.38.2`

### 🐛 Bug fixes


- Livechat Triggers not working ([#29073](https://github.com/RocketChat/Rocket.Chat/pull/29073))

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)


`2023-04-24  ·  1 🔍  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.38.2`

<details>
<summary>🔍 Minor changes</summary>


- Update `vm2` ([#29025](https://github.com/RocketChat/Rocket.Chat/pull/29025))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)


# 6.1.4
`2023-04-20  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.38.2`

<details>
<summary>🔍 Minor changes</summary>


- Bump apps-engine version to 1.38.2 ([#28997](https://github.com/RocketChat/Rocket.Chat/pull/28997))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tapiarafael](https://github.com/tapiarafael)


# 6.1.3
`2023-04-17  ·  1 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.38.1`

### 🐛 Bug fixes


- Livechat notifications not working correctly ([#28741](https://github.com/RocketChat/Rocket.Chat/pull/28741))

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@tassoevan](https://github.com/tassoevan)


# 6.1.2
`2023-04-13  ·  4 🐛  ·  3 🔍  ·  11 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.38.1`

### 🐛 Bug fixes


- Add function to get installation source ([#28806](https://github.com/RocketChat/Rocket.Chat/pull/28806))

  There have been reports of problems regarding the missing information of `installationSource` in apps. The only scenario where this information could be missing is if migrations failed to run properly when upgrading to 6.0. We haven't been able to identify the root cause yet, so we decided to provide a workaround in the meanwhile

- Fixed no role assign to manual registered users despite of Default Roles for Users settings ([#28293](https://github.com/RocketChat/Rocket.Chat/pull/28293) by [@bhardwajdisha](https://github.com/bhardwajdisha))

- Quotes chain off by one error in quote chain limit settings ([#28281](https://github.com/RocketChat/Rocket.Chat/pull/28281) by [@jayesh-jain252](https://github.com/jayesh-jain252))

  Fixed off by one error in Quote Chain Limit. Now if a user sets Message_QuoteChainLimit (default is 2) the number of quotes chained matches the setting.
  Changes are made in apps/meteor/app/oembed/server/jumpToMessage.ts file

  With Message_QuoteChainLimit=2
  Before:
  ![quote_limit2_before](https://user-images.githubusercontent.com/79307894/222970577-5d2b2dc9-c191-4758-acea-909786d974ac.PNG)

  After:
  ![quote_limit2_after](https://user-images.githubusercontent.com/79307894/222970247-fa0bcfcf-e7f3-4102-b7b3-820fb43677c1.PNG)

- SMTP warnings on user form ([#28832](https://github.com/RocketChat/Rocket.Chat/pull/28832))

  Check for SMTP config on server side and then show warning on client side

<details>
<summary>🔍 Minor changes</summary>


- Add `rid` to scope of `create-invite-links` permission check ([#28241](https://github.com/RocketChat/Rocket.Chat/pull/28241))

  This PR fixes a bug where users with the `owner` role can't create invites because the button isn't being displayed for him, to solve this issue the `rid` was added to the scope of the check.

- bump apps-engine version to 1.38.1 ([#28885](https://github.com/RocketChat/Rocket.Chat/pull/28885))

- Upgrade `vm2` ([#28860](https://github.com/RocketChat/Rocket.Chat/pull/28860))

  It patches `vm2`.

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@bhardwajdisha](https://github.com/bhardwajdisha)
- [@jayesh-jain252](https://github.com/jayesh-jain252)

### 👩‍💻👨‍💻 Core Team 🤓

- [@LucianoPierdona](https://github.com/LucianoPierdona)
- [@casalsgh](https://github.com/casalsgh)
- [@d-gubert](https://github.com/d-gubert)
- [@hugocostadev](https://github.com/hugocostadev)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tapiarafael](https://github.com/tapiarafael)
- [@tassoevan](https://github.com/tassoevan)
- [@yash-rajpal](https://github.com/yash-rajpal)


# 6.1.1
`2023-04-04  ·  1 🐛  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.38.0`

### 🐛 Bug fixes


- Messages jumping after reaction ([#28770](https://github.com/RocketChat/Rocket.Chat/pull/28770))

### 👩‍💻👨‍💻 Core Team 🤓

- [@casalsgh](https://github.com/casalsgh)
- [@debdutdeb](https://github.com/debdutdeb)
- [@sampaiodiego](https://github.com/sampaiodiego)


# 6.1.0
`2023-03-29  ·  1 🎉  ·  1 🚀  ·  4 🐛  ·  4 🔍  ·  11 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`
- Apps-Engine: `1.38.0`

### 🎉 New features


- VideoConference Guest mode and Conference Router ([#28186](https://github.com/RocketChat/Rocket.Chat/pull/28186))

  Jira Issue: [VC-79]

### 🚀 Improvements


- Adding input type=password to AWS secrets fields ([#28159](https://github.com/RocketChat/Rocket.Chat/pull/28159))

  Some fields that store secrets for AWS were exposing sensitive data because they didn't have the input type as `password`.

  The change includes adding the password type and also changing the autocomplete value from `<PasswordInput />` component to add the value `new-password` to avoid the browser autocompleting with the existing password. (This does not prevent the browser to show the hint to add the password)

### 🐛 Bug fixes


- Engagement dashboard crash on Users tab ([#28131](https://github.com/RocketChat/Rocket.Chat/pull/28131))

- Gallery opening other image after closing ([#27957](https://github.com/RocketChat/Rocket.Chat/pull/27957))

  How to reproduce:
  1   - Upload MANY images to a channel (they have to be images and the bigger and more images the easier to reproduce)
  2   - Click on one of the images
  3   - Try to close the glalery as QUICK as possible

  If done correctly, another image will open after closing the gallery. You could also try opening different images or throttling the network thru the devtools in order to help reproduce it.

  I also took some time to make part of the code more readable.

- hide offline registration option for disconnected workspaces ([#28662](https://github.com/RocketChat/Rocket.Chat/pull/28662))

- Livechat MessageList not auto scrolling on new message ([#28547](https://github.com/RocketChat/Rocket.Chat/pull/28547))

<details>
<summary>🔍 Minor changes</summary>


- Change price filters for Enterprise apps ([#27553](https://github.com/RocketChat/Rocket.Chat/pull/27553))

  * Currently, Enterprise apps are classified as “Free apps”. Now, they have been moved to a new “Enterprise” category in the _Apps_ page of the Marketplace.

  * Created a new "Enterprise" pricing filter in the _Apps_ page.

  * Removed the "Free" tag next to the _install_ button for enterprise apps, on the _App Info_ page.

  ![New-version](https://user-images.githubusercontent.com/84182706/208493531-11fc0153-2c94-4fab-baac-e359ba89ed72.gif)

- regression: removed css for unread and upload indicators ([#28645](https://github.com/RocketChat/Rocket.Chat/pull/28645))

  I had to revert a css deletion to rollback the styles form Upload and Unread indicators

  **Current (problem):**
  ![image](https://user-images.githubusercontent.com/20212776/228034906-57f9a818-e071-4102-9410-b9e03afbb777.png)

  **Expected: (current changes)**
  ![image](https://user-images.githubusercontent.com/20212776/228035090-1ef28ce8-2ab1-46a0-aeff-b9aa76c79e5f.png)
  ![image](https://user-images.githubusercontent.com/20212776/228035150-fc259b37-83c5-458c-8e4f-8a6a822af641.png)

- Remove old css ([#28140](https://github.com/RocketChat/Rocket.Chat/pull/28140))

- Update Apps-Engine to latest ([#28646](https://github.com/RocketChat/Rocket.Chat/pull/28646))

  Update the Apps-Engine version to v1.38.0

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@csuadev](https://github.com/csuadev)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@hugocostadev](https://github.com/hugocostadev)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@rique223](https://github.com/rique223)
- [@totoi690](https://github.com/totoi690)


# 6.0.1
`2023-03-22  ·  5 🔍  ·  7 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`

<details>
<summary>🔍 Minor changes</summary>


- fix: Apps.engine resource consumption ([#28514](https://github.com/RocketChat/Rocket.Chat/pull/28514))

  Added some validations to avoid doing unnecessary updates and also avoid loop that causes high server usage

- fix: Changing the app's error verification ([#28450](https://github.com/RocketChat/Rocket.Chat/pull/28450))

- fix: Horizontal scroll in main room if text is too long ([#28434](https://github.com/RocketChat/Rocket.Chat/pull/28434))

  Removed inline styles from elements and substituted `p` tag for `div`

  For a quick explanation, the `p` tag adds the multiple line breaks by default when copying text. We should revise in the parser how we deal with paragraphs and text blocks.

- fix: Offline register option ([#28467](https://github.com/RocketChat/Rocket.Chat/pull/28467))

- fix: Thread list not scrolling to bottom when sending a message. ([#28346](https://github.com/RocketChat/Rocket.Chat/pull/28346))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@casalsgh](https://github.com/casalsgh)
- [@csuadev](https://github.com/csuadev)
- [@d-gubert](https://github.com/d-gubert)
- [@gabriellsh](https://github.com/gabriellsh)
- [@hugocostadev](https://github.com/hugocostadev)
- [@tapiarafael](https://github.com/tapiarafael)

# 6.0.0
`2023-03-09  ·  20 ️️️⚠️  ·  12 🎉  ·  13 🚀  ·  60 🐛  ·  238 🔍  ·  56 👩‍💻👨‍💻`

### Engine versions
- Node: `14.21.2`
- NPM: `6.14.17`
- MongoDB: `4.4, 5.0, 6.0`

### ⚠️ BREAKING CHANGES


- **ENTERPRISE:** Limit presence statuses to 200 concurrent users when running monolith to keep performance ([#27854](https://github.com/RocketChat/Rocket.Chat/pull/27854))

- **FIX:** VideoConference Ringer working intermittently on microservices ([#27703](https://github.com/RocketChat/Rocket.Chat/pull/27703))

- **IMPROVE:** SMTP warning for invitations  ([#27713](https://github.com/RocketChat/Rocket.Chat/pull/27713))

  - TC-347   - SMTP warning for invitations flow

  - Create rest endpoint for sendInvitationEmail

  - Use endpoint in-place of removed Meteor method

- **NEW:** Custom roles upsell modal ([#27707](https://github.com/RocketChat/Rocket.Chat/pull/27707))

  ![image](https://user-images.githubusercontent.com/40830821/211393807-2dd4ad76-cc98-4950-99a6-93d6c2087406.png)

  Also changed the `edit role` button:
  ![image](https://user-images.githubusercontent.com/40830821/211393881-980293fa-a3af-46a5-8bfe-48f99872333a.png)

- Drop support for MongoDB 4.2 and deprecate MongoDB 4.4 ([#27891](https://github.com/RocketChat/Rocket.Chat/pull/27891))

  As per MongoDB Lifecycle Schedules ([mongodb.com/support-policy/lifecycles](https://www.mongodb.com/support-policy/lifecycles)) we're removing official support to MongoDB version 4.2 that is close to reach end of life (April 2023).

  We recommend upgrading to MongoDB 5.0+, though 4.4 is still a supported version.

  Here are official docs on how to upgrade to some of the supported versions:

  [mongodb.com/docs/v4.4/release-notes/4.4-upgrade-replica-set](https://www.mongodb.com/docs/v4.4/release-notes/4.4-upgrade-replica-set/)
  [mongodb.com/docs/manual/release-notes/5.0-upgrade-replica-set](https://www.mongodb.com/docs/manual/release-notes/5.0-upgrade-replica-set/)
  [mongodb.com/docs/manual/release-notes/6.0-upgrade-replica-set](https://www.mongodb.com/docs/manual/release-notes/6.0-upgrade-replica-set/)

- Freeze Custom Roles ([#27481](https://github.com/RocketChat/Rocket.Chat/pull/27481))

  This PR moves role creation and update to enterprise folder

  --

  - Removed method `authorization:saveRole`

  - Moved `/v1/roles.create/` and `/v1/roles.update` to enterprise edition

  - Changed message for delete a custom role in community edition

- Limit `underscore` usage and remove `underscore.string` (even from integration script sandboxes) ([#28037](https://github.com/RocketChat/Rocket.Chat/pull/28037))

  [Underscore.js](https://underscorejs.org/) is quite outdated and we're not using it in a way that take advantage of modularization, bloating the client bundle. This PR aims to limit its usage across the application.

  break: if you are used to have scripts, and they are using underscore, please pay attention probably you need to update them

- Marketplace standalone page and app request flow ([#27389](https://github.com/RocketChat/Rocket.Chat/pull/27389))

  Remove marketplace from the admin menu (on both the file system and the UI), change it into a standalone page, expose its use to end-users, and create an app request flow that allows end-users to ask for app installations in their workspaces directly through Rocket Chats UI.

  Demo loom: https://www.loom.com/share/643ba3432225418e96c10041f386ff48

  ## Jira tasks and ADRs
  All tasks, descriptions, and designs of work done in this PR can be found on the tasks below, which also double down as simplified ADRs.

  ### [MKP-147](https://rocketchat.atlassian.net/browse/MKP-147?atlOrigin=eyJpIjoiNDJjNjBlNjU1MjI3NGI0M2I0NDZiZTRkMjkyYjcyZWMiLCJwIjoiaiJ9)   - Remove marketplace from the admin menu and put it on its own page

  ### [MKP-68](https://rocketchat.atlassian.net/browse/MKP-68?atlOrigin=eyJpIjoiMGRhMmExYTViNDNlNGI0Y2FjY2ViNDc3MDgyNWUxNDciLCJwIjoiaiJ9)   - Create an enterprise option on the new marketplace sidebar

  ### [MKP-150](https://rocketchat.atlassian.net/browse/MKP-150?atlOrigin=eyJpIjoiOGIyOWZlMWRhNmFmNDhlODhhMmNlOWE0MmMzOTYwMTgiLCJwIjoiaiJ9)   - Implement the SideNav of the new marketplace page

  ### [MKP-151](https://rocketchat.atlassian.net/browse/MKP-151?atlOrigin=eyJpIjoiN2Y2OTc3MzhlZTAzNGJkOTgwYWVmZjFmMGY0MjA0ZmEiLCJwIjoiaiJ9)   - Brainstorm and implement the new marketplace routes

  ### [MKP-179](https://rocketchat.atlassian.net/browse/MKP-179?atlOrigin=eyJpIjoiYjBmMDgxOGE4OTAxNDgzYTgwMDkxZmQxZGQwZTliNDQiLCJwIjoiaiJ9)   - Retrieve number of requested apps and make it available for components

  ### [MKP-181](https://rocketchat.atlassian.net/browse/MKP-181?atlOrigin=eyJpIjoiNzRiNGM0MTM5NjNjNGVlNmFhZmIyZmQ1MGFhZTkzMjgiLCJwIjoiaiJ9)   - Implement requested option on marketplace sidebar

  ### [MKP-184](https://rocketchat.atlassian.net/browse/MKP-184?atlOrigin=eyJpIjoiY2RkYjJhODc2MTcyNDlkOTllNzc1ZGU4OWIyNTMwYmIiLCJwIjoiaiJ9)   - Create requested apps page

  ### [MKP-185](https://rocketchat.atlassian.net/browse/MKP-185?atlOrigin=eyJpIjoiY2M4ZjVmMzZlODA3NDBkZWE3NTU3YTQ2NWMyYWFjYTAiLCJwIjoiaiJ9)   - Implement requested apps list layout and logic

  ### [MKP-180](https://rocketchat.atlassian.net/browse/MKP-180?atlOrigin=eyJpIjoiYjQwOTVkOTQ4YmYyNDlmN2JlNWI5YzcwYmMzYTEzZmIiLCJwIjoiaiJ9)   - Implement requested apps option to home screen kebab menu

  ### [MKP-188](https://rocketchat.atlassian.net/browse/MKP-188?atlOrigin=eyJpIjoiYTkzNWMwMzdlODBlNDMwOGIzOGQ1MGJhMzFkNzhjYmMiLCJwIjoiaiJ9)   - Implement the requested apps tab on app details page

  ### [MKP-187](https://rocketchat.atlassian.net/browse/MKP-187?atlOrigin=eyJpIjoiYmUzMjI2YTE4Njc1NGFjMThjYjUxNDlhYjMwMTc2MDgiLCJwIjoiaiJ9)   - Implement visualized requests system on apps list tags and app requests tab

  ### [MKP-164](https://rocketchat.atlassian.net/browse/MKP-164?atlOrigin=eyJpIjoiMDUxOTJmNzVlNmZjNGQ4ZTljNzY2NDI4YjU5MjU0N2EiLCJwIjoiaiJ9)   - ALL view the app's technical documentation page

  ### [MKP-197](https://rocketchat.atlassian.net/browse/MKP-197)   - Rocket.cat notification for admins when an app is requested

  ### [MKP-224](https://rocketchat.atlassian.net/browse/MKP-224)   - After i click submit request in the modal the modal is not closing

- Move Multiple Department Creation to EE & [NEW] Department Archive ([#27753](https://github.com/RocketChat/Rocket.Chat/pull/27753))

  [BREAK] **Move Multiple Department Creation to EE**: Limit max department creation to 1 in Community edition, existing departments will still function as before.

  [NEW] 📁 **Department archival**: Adds the ability to archive departments, archived departments are disabled and cannot be edited, but will still show in historical data (current chats, directory, chat info, etc...). This offers an alternative to department deletion.

- Move read-receipts to EE and threads check marks improvements ([#27074](https://github.com/RocketChat/Rocket.Chat/pull/27074))

  - Improvement: add read receipts for messages in threads only when the thread is open;

  - Move read-receipts feature to EE (under the `message-read-receipt` module). The `chat.getMessageReadReceipts` endpoint and `getReadReceipts` Meteor method are now EE only.

- Remove Chatpal ([#28012](https://github.com/RocketChat/Rocket.Chat/pull/28012))

- Remove legacy FB Messenger integration ([#27760](https://github.com/RocketChat/Rocket.Chat/pull/27760))

  Legacy FB messenger integration has been removed in favour of the new and enhanced FB App integration. [Click here](https://docs.rocket.chat/guides/app-guides/omnichannel-apps/facebook-app) for more info

- Remove less theming ([#27647](https://github.com/RocketChat/Rocket.Chat/pull/27647))

- Remove message view mode from User Preferences ([#27867](https://github.com/RocketChat/Rocket.Chat/pull/27867))

  Since the view mode setting in `User preferences -> Messages -> View Mode` does not work with the new messages template it will be removed

  It was removed from every file and it was created a migration to remove from user obj in DB

- Remove support to deprecated typing event ([#28234](https://github.com/RocketChat/Rocket.Chat/pull/28234))

- Removed deprecated settings for Legacy Messages, Marked, Snippet Messages, Autolinker and IssueLinks ([#27902](https://github.com/RocketChat/Rocket.Chat/pull/27902))

  Removed Settings:


  - Markdown_Parser

  - Markdown_Headers

  - Markdown_SupportSchemesForLink

  - Markdown_Marked_GFM

  - Markdown_Marked_Tables

  - Markdown_Marked_Breaks

  - Markdown_Marked_Pedantic

  - Markdown_Marked_SmartLists

  - Markdown_Marked_Smartypants

  - Message_AllowSnippeting

  - Message_Attachments_GroupAttach

  - Message_ShowEditedStatus

  - Message_ShowFormattingTips

  - Accounts_Default_User_Preferences_useLegacyMessageTemplate

  - AutoLinker

  - AutoLinker_StripPrefix

  - AutoLinker_Urls_Scheme

  - AutoLinker_Urls_www

  - AutoLinker_Urls_TLD

  - AutoLinker_UrlsRegExp

  - AutoLinker_Email

  - AutoLinker_Phone

  - IssueLinks_Enabled

  - IssueLinks_Template

  - API_EmbedDisabledFor

- Unify monolith and microservices intercommunication on same technology and limit to Enterprise only  ([#27969](https://github.com/RocketChat/Rocket.Chat/pull/27969))

  This change removes the old DDP Matrix communication by Moleculer based breaker over TCP, simplifying code maintenance, allowing better reliability, performance and monitoring.

  It requires a license to enable communication among servers as the rest of the Moleculer implementation.

  Community Edition will loose ephemeral events as Typing indication and others when running multiple instances.

- Update livechat:saveDepartment to accept a string array in departmentsAllowedToForward ([#28261](https://github.com/RocketChat/Rocket.Chat/pull/28261))

  **Breaking change:** There have been some changes to `livechat:saveDepartment` meteor method's `departmentsAllowedToForward` parameter. Previously it used to accept a string which was a comma-separated list of departmentIds. The new type is an array of strings.

  Due to recent changes to the `useDepartmentList` hook the component `AutoCompleteDepartment` became incompatible with many of our existing pages, causing them to break. This PR makes them work again.

- Update Meteor to 2.9.1 and NodeJS to 14.21.2 ([#27639](https://github.com/RocketChat/Rocket.Chat/pull/27639))

- Upgrade to version 6.0 can be done only from version 5.x  ([#28098](https://github.com/RocketChat/Rocket.Chat/pull/28098))

### 🎉 New features


- **EE:** Omnichannel Priorities & SLAs ([#27083](https://github.com/RocketChat/Rocket.Chat/pull/27083))

- **EE:** PDF Chat transcript for Omnichannel conversations ([#27572](https://github.com/RocketChat/Rocket.Chat/pull/27572))

- Attachment Files Redesign ([#27470](https://github.com/RocketChat/Rocket.Chat/pull/27470))

  - Replace File attachments to use `MessageGenericPreview`

  - Move File attachments to the` /MessageList` folder

  - Refactor Video, Image, and Audio Attachments to use `MessageGenericPreview`

  - New component MessageCollapsible

  - Refactored the `OEmbedCollpsible` component to use `MessageCollapsible`

  - Refactored the `AttachmentSize` component to include different style

  - Added `descriptionMd` property to the `MessageAttachment` object to use the new parser in descriptions

  - Added size and format to attachment object at `sendFileMessage.ts`

  - Changed maxWidth and maxHeight of AttachmentContext to be the same as the OEmbed sizes

  **OLD:**
  <img width="448" alt="image" src="https://user-images.githubusercontent.com/20212776/206214767-f6383ee2-7536-419c-93d7-1637857a950c.png">


  **NEW:**
  <img width="405" alt="image" src="https://user-images.githubusercontent.com/20212776/206214236-a2d096bd-66ed-4489-b825-0fd952906067.png">

- Bridge to get all users crated by app and also delete them ([#27877](https://github.com/RocketChat/Rocket.Chat/pull/27877))

  We're working on [MS Teams bridge](https://github.com/RocketChat/Apps.teams.bridge), to make it usable we have created a new method for the apps engine to [create new users](https://github.com/RocketChat/Rocket.Chat.Apps-engine/pull/536) and we'll also need to delete all when we uninstall the app. Therefore, we created this bridge to cover the action of deleting users on the app side.

- Emojis rendering properly on quote message previews ([#27972](https://github.com/RocketChat/Rocket.Chat/pull/27972) by [@Educg550](https://github.com/Educg550))

  ![image](https://user-images.githubusercontent.com/47800334/217540055-de7cdc29-5478-4a23-a884-4476318bd83d.png)

- Homepage new block ([#27540](https://github.com/RocketChat/Rocket.Chat/pull/27540))

  - Create a new admin homepage block that includes:
      - Button to go to /admin/Layout setting
      - Button to show and hide the custom content to the user (a badge on top indicates if the custom content is hidden or not)
      - Button to show and hide the other blocks (add users, create channel) on the homepage (EE only button)

  New homepage block admin view:
  <img width="1437" alt="Screen Shot 2023-02-10 at 14 28 40" src="https://user-images.githubusercontent.com/48109548/218157495-96c60104-655c-45f2-8513-49279202daad.png">

  Normal user view:
  <img width="1440" alt="Screen Shot 2023-02-10 at 17 12 39" src="https://user-images.githubusercontent.com/48109548/218188731-f9ed2bd4-ef7c-40af-88f3-6b6b7119a365.png">


   - Changes on the /admin/Layout settings:
       - text and homepage settings small changes
       - add Layout_Home_Custom_Block_Visible setting to show or hide custom content

  Admin Homepage Content settings page:

  <img width="452" alt="Screen Shot 2023-02-10 at 15 29 18" src="https://user-images.githubusercontent.com/48109548/218169719-33ead352-6668-46f4-9794-bb21fafd6408.png">

- Matrix federation events coverage expansion + bug fixes ([#27763](https://github.com/RocketChat/Rocket.Chat/pull/27763))

  - Disables not supported features in federated channels (#27204)

  - Add support for the whole Matrix Markdown spec (#27725)

  - Allow federated rooms with the same name per different servers when they have a contact between them (#27559)

  -  Matrix Federation send message when multiple users are involved was not working (#27327)

  - Allow the room owner to set roles on federated rooms, following a specific and different approach as normal rooms (available on docs) (https://github.com/RocketChat/Rocket.Chat/pull/27633)

  - E2E Tests (PS: they don't run on CI) (#27578 #27282 #27115)

  - Disables admin actions disallowed for federated users/rooms (https://github.com/RocketChat/Rocket.Chat/pull/27251)

  FED-81

- New Message Composer ([#27566](https://github.com/RocketChat/Rocket.Chat/pull/27566))

- Permission to bypass message editing and removing limits ([#27644](https://github.com/RocketChat/Rocket.Chat/pull/27644))

  This PR adds a new permission called `bypass-time-limit-edit-and-delete`, to bypass the time limit when editing or deleting a message, the purpose of this PR is to remove the limitation for bots that cannot change the message after the specified time.

- Rocket.cat message for users when an app previously requested is installed ([#27672](https://github.com/RocketChat/Rocket.Chat/pull/27672) by [@matheuslc](https://github.com/matheuslc))

- Upload service ([#27543](https://github.com/RocketChat/Rocket.Chat/pull/27543))

- Warning Popup reinforcing Zapier deprecation on Integrations Admin settings ([#27744](https://github.com/RocketChat/Rocket.Chat/pull/27744) by [@Educg550](https://github.com/Educg550))

  #### Warning being displayed on Zapier settings, above Zapier itself:
  ![warning](https://user-images.githubusercontent.com/47800334/213696834-be7ac8e0-7249-4d02-93ba-e4c5e34b67da.png)

### 🚀 Improvements


- Audit ([#27994](https://github.com/RocketChat/Rocket.Chat/pull/27994))

- Authorize search of custom fields on `users.list`  ([#27423](https://github.com/RocketChat/Rocket.Chat/pull/27423))

  This PR allows users to filter and search for custom fields on the `users.list` endpoint

- Emoji picker for large amount of custom emojis ([#27745](https://github.com/RocketChat/Rocket.Chat/pull/27745))

- Increase read receipt size ([#27665](https://github.com/RocketChat/Rocket.Chat/pull/27665))

  increase from 11px to 1rem (16px)
  ![image](https://user-images.githubusercontent.com/40830821/209961616-3198b51a-ff7e-49eb-9627-15b53fbfe16a.png)

- Livechat Persian translation ([#27825](https://github.com/RocketChat/Rocket.Chat/pull/27825) by [@pouyadarabi](https://github.com/pouyadarabi))

- Play selected notification sounds as preview while changing sound settings  ([#24205](https://github.com/RocketChat/Rocket.Chat/pull/24205) by [@try-catch-stack](https://github.com/try-catch-stack))

- Registration Experience ([#27820](https://github.com/RocketChat/Rocket.Chat/pull/27820))

  If you didn't register when you initially setup your server.  Its now easier to register.

  Disconnecting and reconnecting your workspace from the cloud is now also easier

- Require acceptance when setting new E2E Encryption key for another user ([#27556](https://github.com/RocketChat/Rocket.Chat/pull/27556))

  Change the end to end encryption flow to require an acceptance from the user when receiving a new key.


  1. Changes API `e2e.updateGroupKey` to set the new key to an auxiliary property named `E2ESuggestedKey`

  2. Adds new API `e2e.acceptSuggestedGroupKey` to be called to accept the suggested key and save it to the final property `E2EKey`

  3. Adds new API `e2e.rejectSuggestedGroupKey` to be called to reject the suggested key and clear the `E2ESuggestedKey`

- SAML and OAuth role sync to support id and name ([#27405](https://github.com/RocketChat/Rocket.Chat/pull/27405))

  This PR allows the sync of roles by either `name` or `id`.

- Save toPhone when receiving SMSs ([#27656](https://github.com/RocketChat/Rocket.Chat/pull/27656))

- Setup Wizard Flow for airgapped environment ([#28018](https://github.com/RocketChat/Rocket.Chat/pull/28018))

  ![image](https://user-images.githubusercontent.com/40830821/217655867-ddfbd99f-e0b8-4c71-9a33-b06555bb97dc.png)
  ![image](https://user-images.githubusercontent.com/40830821/217655885-b84a92b6-da9f-4f57-b4ef-297e8541ded3.png)

- Spanish home translation ([#27898](https://github.com/RocketChat/Rocket.Chat/pull/27898) by [@nYCSTs](https://github.com/nYCSTs))

  Update translation of home page to Spanish. The page had some untranslated texts.
  ![image](https://user-images.githubusercontent.com/63932475/215656626-5fbeb5b6-e398-4dd4-a150-ec69305ebb56.png)

- User data download overhaul ([#26358](https://github.com/RocketChat/Rocket.Chat/pull/26358))

  It migrates modules to TypeScript, as well adapts the code to the current version of Node.

### 🐛 Bug fixes


- "Jump to first unread" banner does not always appear when the first unread message is outside of the visible screen ([#27941](https://github.com/RocketChat/Rocket.Chat/pull/27941) by [@Educg550](https://github.com/Educg550))

- **ENTERPRISE:** DDP streamer sending data to destroyed streams ([#27929](https://github.com/RocketChat/Rocket.Chat/pull/27929))

- `*.files` endpoints returning hidden files ([#27617](https://github.com/RocketChat/Rocket.Chat/pull/27617))

- Access to localStorage in Livechat ([#27627](https://github.com/RocketChat/Rocket.Chat/pull/27627) by [@jschirrmacher](https://github.com/jschirrmacher))

  This fixes access to localStorage in LiveChat, if the user has third party coockies disabled.

- Add the possibility of danger style prop to close button on UiKit contextual-bar component ([#27533](https://github.com/RocketChat/Rocket.Chat/pull/27533))

  <img width="611" alt="image" src="https://user-images.githubusercontent.com/17487063/207465305-bd1a017b-e80d-40a6-8f22-9a85df5b1c8b.png">

- Announcement banner link opening in the same page ([#27554](https://github.com/RocketChat/Rocket.Chat/pull/27554))

  Channel Announcements that contain links are opening on the same page instead of a new page/tab causing render issues, especially on the desktop client.

  The fix was simple to add a hook for the `dompurify` library to add the `target` and `rel` attributes to keep the _blank behavior.

  Also, it introduced some parsers settings to `inlineWithoutBreaks` variant to avoid breaking messages at Announcements and other places that uses this variant.

- Anonymous user buttons ([#27551](https://github.com/RocketChat/Rocket.Chat/pull/27551))

  When the server accepts an anonymous user to join and chat without login, two buttons appears: one for Login and the other to send messages without login.

  The component was rewritten to use the fuselage Design System and native hooks to perform actions.

  ![image](https://user-images.githubusercontent.com/20212776/207855313-97d0e2dc-b24d-4baf-b6b5-214aed4be6f1.png)

- App page showing version undefined for apps not in marketplace ([#27766](https://github.com/RocketChat/Rocket.Chat/pull/27766))

  The app page is not showing the correct version of apps that are installed in the workspace but not in the Marketplace.

  This PR changes the behavior so that the page shows the version that is installed in the workspace; otherwise, it shows the version in the marketplace

- Auto Translate not working on new message template ([#27317](https://github.com/RocketChat/Rocket.Chat/pull/27317))

  - Fix auto translate not working on new message template;

  - Fix a bug that the auto-translate icon was showing for users who didn't have enabled.

  - Show translated quote messages;

  - Remove translation provider for end users.

  - Translate the ThreadMessagePreview component

- Black screen when try to open a chat with a non-existent department ([#27609](https://github.com/RocketChat/Rocket.Chat/pull/27609))

- Broken settings check for updates ([#27779](https://github.com/RocketChat/Rocket.Chat/pull/27779))

- Comunity users accessing exclusive ee endpoints in omnichannel section ([#27876](https://github.com/RocketChat/Rocket.Chat/pull/27876) by [@FabioCavaleti](https://github.com/FabioCavaleti))

- Custom fields does not appear on the registration form ([#28031](https://github.com/RocketChat/Rocket.Chat/pull/28031))

- Custom languages not being applied to i18next ([#27557](https://github.com/RocketChat/Rocket.Chat/pull/27557))

- Disable video call on read-only rooms for not allowed users ([#27789](https://github.com/RocketChat/Rocket.Chat/pull/27789))

  Jira Issue [VC-58]

- Discussion visibility when inside a private team. ([#27601](https://github.com/RocketChat/Rocket.Chat/pull/27601))

  Create discussions as private when the public channel is inside a private team.

- E2EE initial banner not showing ([#27574](https://github.com/RocketChat/Rocket.Chat/pull/27574))

- Embedded layout opening sidebar ([#27892](https://github.com/RocketChat/Rocket.Chat/pull/27892))

  In the embedded layout view, certain actions were opening the sidebar due to the missing query param mandatory to the embedded layout view (`?layout=embedded`)

  In addition to this issue, the user was able to navigate to different pages in the embedded layout causing them to get stuck on some other pages other than the Room page. Because of the reported issue, I removed some actions that redirect the user to other pages such as: "Reply in Direct Message"

- Emoji rendering on reactions ([#27863](https://github.com/RocketChat/Rocket.Chat/pull/27863))

- Empty DMs go to sidebar's top after updating user preferences ([#27912](https://github.com/RocketChat/Rocket.Chat/pull/27912))

  - Do not use `_updatedAt` as `lm` field when merging info from subscriptions and rooms (since this field is updated along with the user preferences).

- File upload modal not opening after too long message modal ([#28212](https://github.com/RocketChat/Rocket.Chat/pull/28212))

  - Close the 'too long message to attachment' modal before opening the 'file upload' modal

- Filtering users by status username is broken in Administration -> Users ([#27706](https://github.com/RocketChat/Rocket.Chat/pull/27706))

- Fix emoji appearance on sidebar ([#27580](https://github.com/RocketChat/Rocket.Chat/pull/27580))

  The emojis appear in plain text format in the side-bar (As seen in the below issues)
  By this PR, it should be fixed

  This is how it looks now (As shown on the sidebar, it's appearing as an emoji not plaintext)
  ![image](https://user-images.githubusercontent.com/34144004/163888602-7df27713-0a82-443e-8944-f48525232ca8.png)

- Fix Login with Show default form disabled ([#27475](https://github.com/RocketChat/Rocket.Chat/pull/27475))

- Fix typo when create discussion modal opens ([#24982](https://github.com/RocketChat/Rocket.Chat/pull/24982))

  Fixed typo when discussion modal opens. Now it says   - Help keep an overview of what's going on!

  ![Screenshot 2022-03-29 at 6 59 45 PM](https://user-images.githubusercontent.com/74371312/160625549-8de71046-07bd-493f-ab7b-066d3653c16f.png)

- Google Cloud Storage storage type ([#26851](https://github.com/RocketChat/Rocket.Chat/pull/26851) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

  Google Cloud Storage now requires a "project ID" to be filled.

  Useful links:

  https://googleapis.dev/nodejs/storage/latest/global.html#StorageOptions
  https://support.google.com/googleapi/answer/7014113?hl=en

- Ignored messages reactivity ([#27279](https://github.com/RocketChat/Rocket.Chat/pull/27279))

- Invalid regex on search fields crashes UI ([#27942](https://github.com/RocketChat/Rocket.Chat/pull/27942))

- IPostMessageReacted return field named isReacted instead isRemoved ([#27561](https://github.com/RocketChat/Rocket.Chat/pull/27561) by [@Nabhag8848](https://github.com/Nabhag8848))

- Marketplace app status initially disabled ([#27330](https://github.com/RocketChat/Rocket.Chat/pull/27330))

  ## Jira task: [MKP-20](https://rocketchat.atlassian.net/browse/MKP-20?atlOrigin=eyJpIjoiZTA3YWU5MGYwMDU1NDQ0MGJiNzQyMjYxZmMwMWVmMWQiLCJwIjoiaiJ9)

  Currently, the only apps engine statuses considered enabled in the UI are the auto-enabled and manually-enabled statuses, this causes a UX problem in which the app will be considered disabled for the first few seconds of its lifecycle, upon the first installation in a workspace, since it will have the apps engine status of initialized. This PR adds the initialized status to the appEnabledStatuses list and solves this problem.
  Demo gif:
  ![disabled_status_issue_solution](https://user-images.githubusercontent.com/43561537/204306496-961384c3-ec24-4959-90cd-03f4638be948.gif)\

- Message Actions menu does not close upon choosing an action ([#27328](https://github.com/RocketChat/Rocket.Chat/pull/27328))

- Message for VideoConf on SidebarItemExtended ([#27626](https://github.com/RocketChat/Rocket.Chat/pull/27626))

  Jitsi Issue: [VC-30]

  ### before
  ![Screen Shot 2022-12-23 at 11 38 24](https://user-images.githubusercontent.com/27704687/209353143-bef571c6-c79d-4489-828b-0f33ecddb5b7.png)

  ### after
  ![Screen Shot 2022-12-23 at 11 36 09](https://user-images.githubusercontent.com/27704687/209352853-c977ae04-3074-47bd-842b-70f3118a175b.png)

- Message-parser link issues ([#27947](https://github.com/RocketChat/Rocket.Chat/pull/27947))

  The changes were made in the fuselage repository. This PR just update the message-parser package version
  Check the changes in this PR:
  https://github.com/RocketChat/fuselage/pull/962

- Missing placeholders from encrypted channel preview messages now with expected behavior ([#27699](https://github.com/RocketChat/Rocket.Chat/pull/27699) by [@Educg550](https://github.com/Educg550))

  Referent to [TC-259]

  ![Clipboard screenshot](https://user-images.githubusercontent.com/47800334/211094753-30434b6d-46aa-490a-9b27-59770cf0ff24.png)
  Note that now the file uses `isE2EEMessage()` function and the `useTranslation` internal hook.

- Move Omni startup to be EE wrapped ([#28020](https://github.com/RocketChat/Rocket.Chat/pull/28020))

- New users aren't mapped to rooms with OAuth groups/channels map ([#27000](https://github.com/RocketChat/Rocket.Chat/pull/27000) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

  This change deals with the problem with the new users coming from key cloak, this users were not being mapped to the correct channels on RC.

- Not all messages in chat conversations are available when forwarding between agents or departments. ([#27816](https://github.com/RocketChat/Rocket.Chat/pull/27816))

- Notify apps engine event through ms api ([#28169](https://github.com/RocketChat/Rocket.Chat/pull/28169))

  The Apps-Engine must drop the current Streamer utilization and start using the Service APIs to correctly communicate between instances and client-server.

- Omnichannel call provider option ([#27466](https://github.com/RocketChat/Rocket.Chat/pull/27466))

  Jira Issue: [VC-38]

- OmnichannelRoomIconProvider order breaking VideoConfPopup ([#27740](https://github.com/RocketChat/Rocket.Chat/pull/27740))

  Jira Issue [VC-39]

- Option to Join Read-Only Channels ([#27488](https://github.com/RocketChat/Rocket.Chat/pull/27488) by [@henit-chobisa](https://github.com/henit-chobisa))

- Pagination not working on current chats ([#27432](https://github.com/RocketChat/Rocket.Chat/pull/27432))

- Reduce re-subscription on `notify-room/user-activity` stream event ([#27911](https://github.com/RocketChat/Rocket.Chat/pull/27911))

  Whenever something changed the room subscription, it would trigger a re-subscription to `notify-room/user-activity`.

- Register Workspace UI fixes and fix doc link ([#28021](https://github.com/RocketChat/Rocket.Chat/pull/28021))

- Registration and Login placeholders not being used ([#27558](https://github.com/RocketChat/Rocket.Chat/pull/27558))

- Remove invalid settings at startup ([#27653](https://github.com/RocketChat/Rocket.Chat/pull/27653))

- Remove unnecessary permissions check on app permissions review modal ([#27329](https://github.com/RocketChat/Rocket.Chat/pull/27329))

  ## Jira task: [MKP-166](https://rocketchat.atlassian.net/browse/MKP-166?atlOrigin=eyJpIjoiYzdjNzVhMThkOThjNGEzMmIyYTE2YmY2ZDA1MzA4YjEiLCJwIjoiaiJ9)
  Removed an unnecessary check that verified if the app permissions list was an array and threw an error if it wasn't. This check has become unnecessary ever since the app permission review modal changed to show a default list of permissions in case the app happened to not have one and that's what caused those "random" undefined toasts that showed every once in a while.
  Demo gif:
  ![undefined_toast](https://user-images.githubusercontent.com/43561537/203644331-be9583e1-a92d-46a8-ab3b-add875e7a646.gif)

- room data is not erased after deleting rooms by app ([#27886](https://github.com/RocketChat/Rocket.Chat/pull/27886))

- RoomLeader status not working  ([#27576](https://github.com/RocketChat/Rocket.Chat/pull/27576))

  It also fixes some visual issues

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/208500278-85c705a2-e10a-416f-a4e5-afda34e2650f.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/208500309-d4aaa116-268b-4240-9422-abff98da898c.png)

- Save button does not stay disabled in Notification Preferences for no change on mute group option ([#27513](https://github.com/RocketChat/Rocket.Chat/pull/27513) by [@xareyli](https://github.com/xareyli))

  Added default value for "Mute @all and @here mentions" option

- Search list missing key parameter ([#28230](https://github.com/RocketChat/Rocket.Chat/pull/28230))

- Showing thumbnails on files list ([#23301](https://github.com/RocketChat/Rocket.Chat/pull/23301) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- Showing Workspace Section For User Having LiveChat Manager Permission ([#27188](https://github.com/RocketChat/Rocket.Chat/pull/27188))

- Team mention highlight EE ([#27493](https://github.com/RocketChat/Rocket.Chat/pull/27493))

  The team Mentioned highlighted with the char `@` was not working in Enterprise Edition using the new message parser.

  I added validation to the filter by `type: 'team'` and fixed the title to include the team name on mouse hover.

  **Previous:**
  <img width="347" alt="image" src="https://user-images.githubusercontent.com/20212776/206460415-a2e60d1d-71d1-419d-98ae-2f3074d68614.png">


  **NOW:**
  <img width="400" alt="image" src="https://user-images.githubusercontent.com/20212776/206459995-4e7974b4-dbff-4693-bb57-668da64d634a.png">

- Toast notification ignoring 403 errors ([#27624](https://github.com/RocketChat/Rocket.Chat/pull/27624))

- Tokens usage ([#27541](https://github.com/RocketChat/Rocket.Chat/pull/27541))

- Unintended "Reply on thread" button showing on thread's first message ([#27716](https://github.com/RocketChat/Rocket.Chat/pull/27716) by [@Educg550](https://github.com/Educg550))

  Referent to TC-128

  #### Before:
  ![image](https://user-images.githubusercontent.com/47800334/211622867-5d24a4c9-172b-4b36-aac9-cea1af3f925a.png)

  #### After:
  ![image](https://user-images.githubusercontent.com/47800334/211622729-14e8c552-615c-44e3-b5ae-8e815909e5ac.png)

- Unread Message count not displayed for new messages in Omni-Rooms ([#27539](https://github.com/RocketChat/Rocket.Chat/pull/27539))

- User registration with EmailConfirmation not working ([#28143](https://github.com/RocketChat/Rocket.Chat/pull/28143))

- Video Conf Message Blocks not always updating when running on micro services ([#27764](https://github.com/RocketChat/Rocket.Chat/pull/27764))

<details>
<summary>🔍 Minor changes</summary>


- Bump version to 6.0.0-develop ([#27598](https://github.com/RocketChat/Rocket.Chat/pull/27598))

- Chore:  Threads as React components ([#27524](https://github.com/RocketChat/Rocket.Chat/pull/27524))

- Chore: `desktop` icon instead of `computer` icon ([#27959](https://github.com/RocketChat/Rocket.Chat/pull/27959))

- Chore: Add dark theme assets ([#28214](https://github.com/RocketChat/Rocket.Chat/pull/28214))

- Chore: add e2e test coverage for Video Conference ([#27075](https://github.com/RocketChat/Rocket.Chat/pull/27075) by [@lingohub[bot]](https://github.com/lingohub[bot]) & [@weslley543](https://github.com/weslley543))

  Jira Issue: [VC-49]

- Chore: Add E2E tests to Triggers view ([#27413](https://github.com/RocketChat/Rocket.Chat/pull/27413))

- Chore: Add Eslint rules to tests ([#28074](https://github.com/RocketChat/Rocket.Chat/pull/28074))

- Chore: Add extra stats for omnichannel video calling ([#28211](https://github.com/RocketChat/Rocket.Chat/pull/28211))

- Chore: Add hint (description) to CodeSettingInput after label ([#27843](https://github.com/RocketChat/Rocket.Chat/pull/27843))

  - Added hint (description) to CodeSettingInput after label

  - Created a storybook story for that scenario

  - add a checker to not add hint to`<MemoizedSetting />` if the inputType is `code`

  **Before:**
  ![image](https://user-images.githubusercontent.com/20212776/214575455-f2073084-bc10-4e55-9eb2-99bc9fcb71a3.png)

  **After:**
  ![image](https://user-images.githubusercontent.com/20212776/214622377-eb706c31-909f-4b25-ae2e-71cff70f80b2.png)

- Chore: Add quote message option back on live chat rooms ([#28038](https://github.com/RocketChat/Rocket.Chat/pull/28038))

- Chore: Add spacing adjustments Home page ([#27367](https://github.com/RocketChat/Rocket.Chat/pull/27367))

  - Spacings adjustments in homepage

- Chore: Add surface-light background to AppRow ([#27765](https://github.com/RocketChat/Rocket.Chat/pull/27765))

  In light of the recent changes to the fuselage color system, the AppRow went from having a default background color of white to not having a color. Because of this, I've added the bg='surface-light' prop to the Wrapper box of the component.
  Before:
  ![image](https://user-images.githubusercontent.com/43561537/212754530-ab847cc2-9026-45e3-a138-14c3c657f373.png)

  After:
  ![image](https://user-images.githubusercontent.com/43561537/212754573-010bb538-7a2d-4db2-889d-933cc907a9f1.png)

- Chore: Added Enterprise Options to Login customization ([#27855](https://github.com/RocketChat/Rocket.Chat/pull/27855))

- Chore: Adjust ProgressBar usage ([#27832](https://github.com/RocketChat/Rocket.Chat/pull/27832))

- Chore: anonymous e2e test dispatch error ([#28171](https://github.com/RocketChat/Rocket.Chat/pull/28171))

- Chore: AppsTable UI Tweaks ([#27629](https://github.com/RocketChat/Rocket.Chat/pull/27629))

  ### before
  ![Kapture 2022-12-23 at 16 00 51](https://user-images.githubusercontent.com/27704687/209394897-0217725b-25b2-4d70-a7eb-404b7f158a31.gif)


  ### after
  ![Kapture 2022-12-23 at 15 59 21](https://user-images.githubusercontent.com/27704687/209394759-0e703463-3d19-43b5-9aa7-b18c4c4cbdef.gif)

- Chore: Aria busy indicators ([#27978](https://github.com/RocketChat/Rocket.Chat/pull/27978))

- Chore: Bump message-parser version and fix typerrors ([#27643](https://github.com/RocketChat/Rocket.Chat/pull/27643))

  Bumping message-parser version and fix gazzodown package errors.

- Chore: Change bundle tags color and refactor app details page header styles ([#27293](https://github.com/RocketChat/Rocket.Chat/pull/27293))

  Increased the right side margin of the app avatar, removed the 'by' substring from the app author metadata, and changed the font scale and colors for the metadata section and short description.
  Demo image:
  ![image](https://user-images.githubusercontent.com/43561537/202550456-41bc5216-5f6f-4a15-a38e-2e220f8ab3b5.png)

- Chore: change colors to dark theme on Marketplace ([#27532](https://github.com/RocketChat/Rocket.Chat/pull/27532))

  Fixed some bugs on the new dark theme in the Marketplace page. The new version looks like this now:

  ![new-version](https://user-images.githubusercontent.com/84182706/207443296-b9466105-7dfb-46eb-8f71-eee113c3532b.png)

- Chore: Change Omnichannel aggregations to run on a secondary ([#25346](https://github.com/RocketChat/Rocket.Chat/pull/25346))

- Chore: CI improvements ([#28076](https://github.com/RocketChat/Rocket.Chat/pull/28076))

- Chore: Composer missing Slash Command preview ([#27652](https://github.com/RocketChat/Rocket.Chat/pull/27652))

- Chore: Composer Quote Component ([#27604](https://github.com/RocketChat/Rocket.Chat/pull/27604))

  ### before
  <img width="1132" alt="Screen Shot 2022-12-26 at 11 01 17" src="https://user-images.githubusercontent.com/27704687/209556499-e3d2c2f3-0950-4622-9afa-63b1e725ecfa.png">

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/209555642-ca6bdda0-a3f8-4dc1-a34c-d1fb57539b47.png)

- Chore: Composer Styling ([#27620](https://github.com/RocketChat/Rocket.Chat/pull/27620))

- Chore: Composer wrapper around the textarea ([#27658](https://github.com/RocketChat/Rocket.Chat/pull/27658))

- Chore: Convert UserTable on Directory to TS ([#27534](https://github.com/RocketChat/Rocket.Chat/pull/27534) by [@nYCSTs](https://github.com/nYCSTs))

  Rewrote the UserTable component to TS.

- Chore: Create service template ([#27519](https://github.com/RocketChat/Rocket.Chat/pull/27519))

- Chore: Custom emoji empty state ([#27641](https://github.com/RocketChat/Rocket.Chat/pull/27641))

  It also replace `useEndpointData` in favor of `useQuery`
  ### before
  ![Screen Shot 2022-12-26 at 15 43 59](https://user-images.githubusercontent.com/27704687/209576037-93744632-a74f-4b0c-926d-b444cf4601e2.png)

  ### after
  ![Screen Shot 2022-12-26 at 15 43 08](https://user-images.githubusercontent.com/27704687/209576006-4f2f1928-3532-4f42-88fa-ba661a2b7715.png)

- Chore: Custom Sounds Empty State ([#27632](https://github.com/RocketChat/Rocket.Chat/pull/27632))

  It also replace `useEndpointData` in favor of `useQuery`

  ### before
  ![Screen Shot 2022-12-23 at 17 32 35](https://user-images.githubusercontent.com/27704687/209403136-791a8196-93f3-4fa6-8519-1d48a1d17430.png)

  ### after
  ![Screen Shot 2022-12-23 at 17 31 50](https://user-images.githubusercontent.com/27704687/209403089-8f426d3e-c09d-447a-93a7-0e50ea97c0ca.png)

- Chore: Deprecate unused omnichannel API ([#27538](https://github.com/RocketChat/Rocket.Chat/pull/27538))

- Chore: Do not rely on external service on tests ([#27874](https://github.com/RocketChat/Rocket.Chat/pull/27874))

- Chore: e2e changes tests ([#27987](https://github.com/RocketChat/Rocket.Chat/pull/27987))

- Chore: e2e omnichannel tests - Close every opened page after the test ([#28152](https://github.com/RocketChat/Rocket.Chat/pull/28152))

- Chore: E2E tests small corrections ([#28066](https://github.com/RocketChat/Rocket.Chat/pull/28066))

- Chore: EmojiPicker Wrapper Styles ([#28049](https://github.com/RocketChat/Rocket.Chat/pull/28049))

- Chore: ExportMessages missing icon ([#27628](https://github.com/RocketChat/Rocket.Chat/pull/27628))

- Chore: FileItem hover color ([#27600](https://github.com/RocketChat/Rocket.Chat/pull/27600))

- Chore: Fix babel config related to TypeScript `declare` usage ([#28029](https://github.com/RocketChat/Rocket.Chat/pull/28029))

- Chore: Fix CI Docker Alpine build missing ([#28138](https://github.com/RocketChat/Rocket.Chat/pull/28138))

- Chore: Fix CI docker publish ([#28134](https://github.com/RocketChat/Rocket.Chat/pull/28134))

- Chore: Fix e2e EE tests not working reliably ([#28061](https://github.com/RocketChat/Rocket.Chat/pull/28061))

- Chore: fix e2e Omnichannel tests ([#28097](https://github.com/RocketChat/Rocket.Chat/pull/28097))

- Chore: Fix Email Inbox flaky test ([#28294](https://github.com/RocketChat/Rocket.Chat/pull/28294))

- Chore: fix EmailInbox intermittent e2e tests ([#27573](https://github.com/RocketChat/Rocket.Chat/pull/27573))

- Chore: Fix fetching Apps-Engine and MongoDB versions for release notes ([#28129](https://github.com/RocketChat/Rocket.Chat/pull/28129))

- Chore: Fix homepage grid items style ([#27527](https://github.com/RocketChat/Rocket.Chat/pull/27527))

  - Change homepage card border-radius from 4px to 8px

- Chore: Improve `ts-node` startup time with `swc` ([#27686](https://github.com/RocketChat/Rocket.Chat/pull/27686))

- Chore: improve global setup e2e ([#28087](https://github.com/RocketChat/Rocket.Chat/pull/28087))

- Chore: Improve service's licence check ([#27872](https://github.com/RocketChat/Rocket.Chat/pull/27872))

- Chore: improve some e2e selectors ([#27936](https://github.com/RocketChat/Rocket.Chat/pull/27936))

- Chore: Improve time of meteor build ([#28128](https://github.com/RocketChat/Rocket.Chat/pull/28128))

- Chore: Invites Empty State ([#27631](https://github.com/RocketChat/Rocket.Chat/pull/27631))

  It also replace `useEndpointData` in favor of `useQuery`
  ### before
  ![Screen Shot 2022-12-23 at 16 49 45](https://user-images.githubusercontent.com/27704687/209399990-95b15ba3-0ba9-4ae4-92fa-fed4c1d39d31.png)

  ### after
  ![Screen Shot 2022-12-23 at 16 48 27](https://user-images.githubusercontent.com/27704687/209399874-1c38f206-c385-49f5-8050-7b4f7b55bd7a.png)

- Chore: KeyboardShortCut color ([#27599](https://github.com/RocketChat/Rocket.Chat/pull/27599))

  <img src='https://user-images.githubusercontent.com/27704687/208955920-f7ea9b50-ae43-44d9-94fc-aa2c5181c5c5.png' width='420px' />

  <img src='https://user-images.githubusercontent.com/27704687/208955954-bf73e9af-9180-4c95-8f98-635fdfb76a2e.png' width='420px' />

- Chore: Livechat convert emoji to ts ([#27425](https://github.com/RocketChat/Rocket.Chat/pull/27425))

- Chore: Manually define shared secrets to reusable workflows ([#28315](https://github.com/RocketChat/Rocket.Chat/pull/28315))

- Chore: Message search changes ([#28001](https://github.com/RocketChat/Rocket.Chat/pull/28001))

- Chore: Migrate cached collections to TypeScript ([#27909](https://github.com/RocketChat/Rocket.Chat/pull/27909))

- Chore: More E2E tests for PDF transcript feature of Omnichannel ([#28110](https://github.com/RocketChat/Rocket.Chat/pull/28110))

- Chore: Move all variables to first step and reduce code duplication ([#28106](https://github.com/RocketChat/Rocket.Chat/pull/28106))

- Chore: move PaletteStyleTag ([#28086](https://github.com/RocketChat/Rocket.Chat/pull/28086))

- Chore: Move service definitions to core services package ([#27546](https://github.com/RocketChat/Rocket.Chat/pull/27546))

- Chore: Move service shutdown logic to each service ([#27690](https://github.com/RocketChat/Rocket.Chat/pull/27690))

- Chore: Notify Marketplace on App Install ([#27925](https://github.com/RocketChat/Rocket.Chat/pull/27925))

  Notifies Rocket.Chat's Marketplace of an app install action. This correlates with the app request flow.

- Chore: OAuth authorization pages reconditioned ([#28085](https://github.com/RocketChat/Rocket.Chat/pull/28085))

- Chore: Omnichannel Sidebar icons alignment ([#27501](https://github.com/RocketChat/Rocket.Chat/pull/27501))

- Chore: Playwright test improvements ([#28100](https://github.com/RocketChat/Rocket.Chat/pull/28100))

- Chore: Presence cap tweaks ([#28058](https://github.com/RocketChat/Rocket.Chat/pull/28058))

- Chore: Purge styles of the legacy `message` template ([#28126](https://github.com/RocketChat/Rocket.Chat/pull/28126))

- Chore: QoL improvements to Omnichannel E2E tests ([#28075](https://github.com/RocketChat/Rocket.Chat/pull/28075))

- Chore: Reduce Less usage in theming ([#27689](https://github.com/RocketChat/Rocket.Chat/pull/27689))

  This PR is a preparation for a coming breaking change on layout colors.

- Chore: Refactor `AudioMessageRecorder` ([#28019](https://github.com/RocketChat/Rocket.Chat/pull/28019))

  [DSA-11]

  ![Kapture 2023-02-13 at 17 24 54](https://user-images.githubusercontent.com/27704687/218567103-1090cf5c-61d1-4bd9-8c0a-d582d614ef85.gif)

- Chore: Refactor `VideoMessageRecorder` ([#27850](https://github.com/RocketChat/Rocket.Chat/pull/27850))

  Jira Issue: [DSA-2]
  ### before
  <img width='720px' src='https://user-images.githubusercontent.com/27704687/214734963-00537e4b-ae2e-45b8-87ea-d9dfb18e740c.gif' />

  ### after
  <img width='720px' src='https://user-images.githubusercontent.com/27704687/214734774-3beb9433-7493-486e-a9b3-c4efc6385c3b.gif' />

- Chore: Refactor CI to improve code reusability and organization ([#28108](https://github.com/RocketChat/Rocket.Chat/pull/28108))

- Chore: Refactor Composer Collapsed Formatters and Actions ([#28039](https://github.com/RocketChat/Rocket.Chat/pull/28039))

  [DSA-19]

  ![Kapture 2023-02-14 at 14 05 19](https://user-images.githubusercontent.com/27704687/218807178-4c280e92-67f2-48ec-afa3-e5b2948120f2.gif)

- Chore: Refactor Composer Dropdown ([#27931](https://github.com/RocketChat/Rocket.Chat/pull/27931))

  ![Screen Shot 2023-02-01 at 17 59 31](https://user-images.githubusercontent.com/27704687/216162082-ea258bb8-5629-4898-a410-6162a0fa008e.png)

- Chore: Refactor Composer Popup ([#28013](https://github.com/RocketChat/Rocket.Chat/pull/28013))

- Chore: Refactor CreateChannelModal ([#27469](https://github.com/RocketChat/Rocket.Chat/pull/27469))

  Jira Issue: [UFR-11]


  - Replace `useForm`

  - Improve UI validations on Modal

  - Add ToastBar message on creating a channel

  - Fixes `topic` field not being added properly

- Chore: Refactor Directory Tables ([#27646](https://github.com/RocketChat/Rocket.Chat/pull/27646))

  It also replaces `useEndpointData` in favor of `useQuery`

- Chore: Refactor e2e selectors to use roles ([#27582](https://github.com/RocketChat/Rocket.Chat/pull/27582))

- Chore: Refactor message subcomponents ([#27630](https://github.com/RocketChat/Rocket.Chat/pull/27630))

- Chore: Refactor other kinds of message - Phase 1 ([#27712](https://github.com/RocketChat/Rocket.Chat/pull/27712))

  It pays some technical debts on APIs consumed by message-related components.

- Chore: Refactor other kinds of message - Phase 2 ([#27927](https://github.com/RocketChat/Rocket.Chat/pull/27927))

  Migrate "Starred Messages", "Pinned Messages", and "Mentions" from Blaze templates to React components.

- Chore: Refactor useThemeMode in favor of userPreferences ([#28063](https://github.com/RocketChat/Rocket.Chat/pull/28063))

- Chore: Remove `body` template ([#28064](https://github.com/RocketChat/Rocket.Chat/pull/28064))

- Chore: Remove `meteor build --debug` option ([#28170](https://github.com/RocketChat/Rocket.Chat/pull/28170))

- Chore: Remove duplicated functions in tests ([#28336](https://github.com/RocketChat/Rocket.Chat/pull/28336))

- Chore: Remove fail-fast from matrix strategy ([#28153](https://github.com/RocketChat/Rocket.Chat/pull/28153))

- Chore: Remove medium prop from ButtonGroup  ([#27784](https://github.com/RocketChat/Rocket.Chat/pull/27784))

- Chore: Remove method meteor call on message action ([#26213](https://github.com/RocketChat/Rocket.Chat/pull/26213))

- Chore: Remove old tooltip usage ([#26882](https://github.com/RocketChat/Rocket.Chat/pull/26882))

- Chore: Remove Sidebar from Blaze ([#27571](https://github.com/RocketChat/Rocket.Chat/pull/27571))

- Chore: Remove unused Blaze templates after message rewrite ([#28025](https://github.com/RocketChat/Rocket.Chat/pull/28025))

- Chore: Remove unused templates and bump fuselage ([#27606](https://github.com/RocketChat/Rocket.Chat/pull/27606))

- Chore: Replace borders to `default` ([#27667](https://github.com/RocketChat/Rocket.Chat/pull/27667))

- Chore: Replace deprecated color tokens ([#28164](https://github.com/RocketChat/Rocket.Chat/pull/28164))

- Chore: Restrict `ChatMessages API` - Phase 2 ([#27457](https://github.com/RocketChat/Rocket.Chat/pull/27457))

  It split `ChatMessages` service class into a collection of smaller objects, in a composition pattern fashion. Additionally, it loosens its dependency on the DOM tree and assumes almost all methods are asynchronous.

- Chore: Restrict legacy message events ([#27691](https://github.com/RocketChat/Rocket.Chat/pull/27691))

  This PR aims to fix conflicts between the legacy messages and the new ones, specially click events on threads.

- Chore: RoomAutocomplete Debounce Query ([#28083](https://github.com/RocketChat/Rocket.Chat/pull/28083))

- Chore: Service cap ([#28022](https://github.com/RocketChat/Rocket.Chat/pull/28022))

- Chore: Set missing colors ([#27817](https://github.com/RocketChat/Rocket.Chat/pull/27817))

- Chore: Settings regenerator on migration ([#27661](https://github.com/RocketChat/Rocket.Chat/pull/27661))

- Chore: Show different labels based on the call originator on direct calls ([#27729](https://github.com/RocketChat/Rocket.Chat/pull/27729))

  Jira Issue: [VC-26]

- Chore: Sidebar theme ([#27426](https://github.com/RocketChat/Rocket.Chat/pull/27426))

- Chore: SlashCommands Preview ([#28065](https://github.com/RocketChat/Rocket.Chat/pull/28065))

- Chore: Sync `develop` with `master` ([#28043](https://github.com/RocketChat/Rocket.Chat/pull/28043) by [@carlosrodrigues94](https://github.com/carlosrodrigues94) & [@ostjen](https://github.com/ostjen))

- Chore: test turbo cache action ([#28082](https://github.com/RocketChat/Rocket.Chat/pull/28082))

- Chore: Token refactor ([#27655](https://github.com/RocketChat/Rocket.Chat/pull/27655))

- Chore: TwoFactorPass Modals icon misalignment ([#27591](https://github.com/RocketChat/Rocket.Chat/pull/27591))

  ### before
  <img width="620" alt="Screen Shot 2022-12-20 at 21 05 24" src="https://user-images.githubusercontent.com/27704687/208790177-aca2ce19-1e8a-4759-8156-3c418897cb12.png">

  ### after
  <img width="616" alt="Screen Shot 2022-12-20 at 21 04 29" src="https://user-images.githubusercontent.com/27704687/208790090-0a124f58-cb11-41ab-af4d-1715aa0c8f24.png">

- Chore: Update color tokens ([#27704](https://github.com/RocketChat/Rocket.Chat/pull/27704))

  Jira issues:
  [DSA-25](https://rocketchat.atlassian.net/browse/DSA-25)
  [DSA-26](https://rocketchat.atlassian.net/browse/DSA-26)
  [DSA-27](https://rocketchat.atlassian.net/browse/DSA-27)
  [DSA-28](https://rocketchat.atlassian.net/browse/DSA-28)
  [DSA-30](https://rocketchat.atlassian.net/browse/DSA-30)


  - [x] Fix ScreenshotCarousel tokens

  - [x] Replace ScreenshotCarousel Button with IconButton secondary

  - [x] Fix UsagePieGraph tokens

  - [x] Fix Page.tsx tokens

  - [x] Fix VoipFooter tokens

  - [x] Fix DeviceIcon token

  - [x] Fix SidebarFooterWatermark token

  - [x] Fix PaletteDark button hover bg color

  - [x] Fix MessageComposerActionsDivider token

  - [x] Fix room Announcement colors

  - [x] Apply surface-room

  - [x] Replace all deprecated Box color tokens usage

  - [x] Replace all deprecated Box bg tokens usage

- Chore: Update ESlint rules of client code ([#27427](https://github.com/RocketChat/Rocket.Chat/pull/27427))

- Chore: Update Some Composer Icons ([#27862](https://github.com/RocketChat/Rocket.Chat/pull/27862))

  Jira Issue [DSA-20]

  ### before
  ![Screen Shot 2023-01-26 at 18 09 19](https://user-images.githubusercontent.com/27704687/214950981-794d1f23-b33f-4fcf-9ab1-f042925e5639.png)

  ### after
  ![Screen Shot 2023-01-26 at 18 08 28](https://user-images.githubusercontent.com/27704687/214950829-357ea6eb-9fde-4144-8819-5052e21ae604.png)

- Chore: Update tokens ([#28079](https://github.com/RocketChat/Rocket.Chat/pull/28079))

- Chore: Update tsconfig base target to es2020 ([#27552](https://github.com/RocketChat/Rocket.Chat/pull/27552))

  The base files are not split into two other files, a "client" and a "server" file. Both extends the new base one. Packages should extend either "client" or "server" ones:

  ```mermaid
  graph TD;
    base[tsconfig.base.json]-->client[tsconfig.base.client.json];
    base-->server[tsconfig.base.server.json];
    server-->s1["@rocket.chat/models"];
    server-->s2["@rocket.chat/ddp-streamer"];
    server-->s3[...];
    client-->c1["@rocket.chat/ui-theming"];
    client-->c2["@rocket.chat/fuselage-ui-kit"];
    client-->c3[...];
  ```

  Important changes:


  - The client config `target` have been bumped to `es2015` (it was `es5` before)

  - The server config `target` have been bumped to `es2020`

  - The default value for `jsx` is `react-jsx`

  - Raised `"noUnusedLocals": true` to a base config, so had to remove a bunch of imports to `React` that were not being used

- Chore: Upgrade `mongodb` typings ([#27424](https://github.com/RocketChat/Rocket.Chat/pull/27424))

  It upgrades the `mongodb` package to overcome the circular reference issue of `IMessage`.

- Chore: Upgrade EE license for CI ([#27682](https://github.com/RocketChat/Rocket.Chat/pull/27682))

- Chore: use useQuery in place of deprecated useEndpointData ([#27673](https://github.com/RocketChat/Rocket.Chat/pull/27673) by [@Dnouv](https://github.com/Dnouv))

  Chore done:
  useEndpointData -> useEndpoint for:


  - `/apps/meteor/client/views/admin/`
    - `apps`
    - `customEmoji`
    - `customSounds`
    - `customUserStatus`
    - `integrations`
    - `invites`
    - `oauthApps`
    - `permissions`
    - `rooms`
    - `users`

- Chore: Wait message to not be Busy ([#28000](https://github.com/RocketChat/Rocket.Chat/pull/28000))

- Chore(deps): Bump thehanimo/pr-title-checker from 1.3.4 to 1.3.6 ([#27884](https://github.com/RocketChat/Rocket.Chat/pull/27884) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- i18n: Language update from LingoHub 🤖 on 2022-12-05Z ([#27450](https://github.com/RocketChat/Rocket.Chat/pull/27450))

- i18n: Language update from LingoHub 🤖 on 2022-12-22Z ([#27618](https://github.com/RocketChat/Rocket.Chat/pull/27618))

- i18n: Language update from LingoHub 🤖 on 2023-01-09Z ([#27705](https://github.com/RocketChat/Rocket.Chat/pull/27705))

- i18n: Language update from LingoHub 🤖 on 2023-01-23Z ([#27814](https://github.com/RocketChat/Rocket.Chat/pull/27814))

- i18n: Language update from LingoHub 🤖 on 2023-02-14Z ([#28036](https://github.com/RocketChat/Rocket.Chat/pull/28036))

- i18n: Update Hungarian translation ([#27575](https://github.com/RocketChat/Rocket.Chat/pull/27575) by [@urbalazs](https://github.com/urbalazs))

- Merge master into develop & Set version to 5.5.0-develop ([#27452](https://github.com/RocketChat/Rocket.Chat/pull/27452))

- Regression:  Fix mentioning rooms with special chars ([#28206](https://github.com/RocketChat/Rocket.Chat/pull/28206))

- Regression:  Fix sidebar horizontal scrolling ([#28125](https://github.com/RocketChat/Rocket.Chat/pull/28125))

- Regression: "Enable unlimited apps" button on installation modal doesn't do anything ([#28132](https://github.com/RocketChat/Rocket.Chat/pull/28132))

- Regression: `Admin UI -> Rooms` Search filter not working ([#27970](https://github.com/RocketChat/Rocket.Chat/pull/27970))

- Regression: 0 appearing on sidebar on specific occasions ([#28056](https://github.com/RocketChat/Rocket.Chat/pull/28056))

  Fixed faulty logic

- Regression: Add auto translate option back to live chat room ([#28139](https://github.com/RocketChat/Rocket.Chat/pull/28139))

  Add the `translation` option to the live chat room;
  The behavior of this feature in live chat rooms is quite different from direct and group messages. In these rooms, you need to activate and set up the language, while in the live chat room, the `translate` option should always appear for every room and should use the application language to translate.

- Regression: Add button-icon-disabled-color to the palette ([#27522](https://github.com/RocketChat/Rocket.Chat/pull/27522))

- Regression: Add support for 2FA errors to `Meteor.callAsync` ([#27767](https://github.com/RocketChat/Rocket.Chat/pull/27767))

- Regression: Add tshow to composer params ([#27602](https://github.com/RocketChat/Rocket.Chat/pull/27602))

- Regression: Added anchors elements to the allowed list to be clicked ([#28341](https://github.com/RocketChat/Rocket.Chat/pull/28341))

- Regression: Adjusted components using PaginatedMultiSelected to be compatible with new Fuselage version ([#28233](https://github.com/RocketChat/Rocket.Chat/pull/28233))

- Regression: Adjusted departments upsell modal message ([#28258](https://github.com/RocketChat/Rocket.Chat/pull/28258))

  This PR adjusts the logic to display the correct message on the departments upsell modal. This affects users with a trial license, expired expired licence, as well as no licence.

- Regression: Adjusted departments upsell modal to check for licence and modules ([#28246](https://github.com/RocketChat/Rocket.Chat/pull/28246))

  This PR fixes a regression on the departments upsell modal, for the rare cases where the workspace has an enterprise licence but has no active modules. This changes improves the check to also consider modules.

- Regression: App requests notify admin function generating wrong link ([#28111](https://github.com/RocketChat/Rocket.Chat/pull/28111))

  Fixed a development oversight in which the link of the app request Rocket.Cat message was generated without the marketplace version of the app nor the requests tab param.
  Demo gif (before):
  ![notify-admin-before](https://user-images.githubusercontent.com/43561537/220368522-084a171c-52ab-48b4-aa43-f73f6cc12ca6.gif)

  Demo gif (after):
  ![notify-admin-after](https://user-images.githubusercontent.com/43561537/220368591-93c6e157-922f-4b48-b474-f5c65c2b04b8.gif)

- Regression: Apps provider not handling apps lists correctly ([#28264](https://github.com/RocketChat/Rocket.Chat/pull/28264))

  ## Jira tasks: [MKP-272](https://rocketchat.atlassian.net/browse/MKP-272?atlOrigin=eyJpIjoiNDQzMmY4NmYyYTEyNDJjMmJmZmY3ZGUyYmQ3Y2Y2Y2EiLCJwIjoiaiJ9) [MKP-270](https://rocketchat.atlassian.net/browse/MKP-270?atlOrigin=eyJpIjoiOWRhYWM5N2VmY2UwNDAyMjlhY2ZiM2IwYjMwYWQxOWUiLCJwIjoiaiJ9)
  Fixed a bug in which the AppsProvider would not handle the marketplace, installed, and private apps lists correctly when running the install, update, and delete listeners. This also solved related bugs of app duplication during installation and loss of reactivity during uninstalls and status changes(private apps only).
  Demo gif: ![apps-provider-behavior](https://user-images.githubusercontent.com/43561537/222833328-1d9836c0-738c-41d5-ac17-a5d86452ea83.gif)

- Regression: Apps-Engine startup process was faulty ([#28322](https://github.com/RocketChat/Rocket.Chat/pull/28322))

  * App loading routine was forcing apps to be enabled, even if they were previously disabled

  * Isolated Apps startup routine for more granular control

- Regression: Attachment auto size ([#28332](https://github.com/RocketChat/Rocket.Chat/pull/28332))

  Attachment Image or Image Preview size in small screens are not respecting container boundaries

 **Before:**
  ![image](https://user-images.githubusercontent.com/20212776/223826977-507e0b57-aba1-471d-a901-30198a51d82f.png)


  **NOW:**
  ![image](https://user-images.githubusercontent.com/20212776/223826829-7c6006bd-0738-4cd4-acc6-ba8b8c274e3b.png)

- Regression: Avoid rendering unsupported media on PDFs & update quote styling ([#28048](https://github.com/RocketChat/Rocket.Chat/pull/28048))

  - Fix faulty logic when deciding which attachment to render based on the mime type of it


  - Replace media query syntax `(width < 767px)` with `(max-width: 767px)` since the first one isn't supported on safari

  - Fix a bug when has bold text in multiple rows.

- Regression: broken message exhibition when edited ([#28180](https://github.com/RocketChat/Rocket.Chat/pull/28180))

  Sometimes a message will have the fields `editedBy` and `editedAt` present but set to `null`. This PR handle this situation.

- Regression: Broken message jump onto threads ([#28095](https://github.com/RocketChat/Rocket.Chat/pull/28095))

- Regression: Broken room and message composer events ([#27754](https://github.com/RocketChat/Rocket.Chat/pull/27754))

  It hotfixes two issues:

  1. user card not opening on clicking in user mentions;

  2. slash commands inside threads sending results to the main room.

- Regression: Change names of requested apps sorting options ([#28312](https://github.com/RocketChat/Rocket.Chat/pull/28312))

  ## Jira task: [MKP-253](https://rocketchat.atlassian.net/browse/MKP-253)
  Changed the name of the requested app-related sorting options to cause less confusion regarding their expected behavior and solved some UX problems with the initial state of the sorting filter when on different marketplace pages. Also fixed some typos.
  Demo image:
  ![image](https://user-images.githubusercontent.com/43561537/223466309-60f02a71-c21e-4607-a2b4-5de81c3b3cd5.png)

- Regression: Change text of buttons tooltips on custom content homepage block ([#28094](https://github.com/RocketChat/Rocket.Chat/pull/28094))

  ### Show to workspace Button:


  * No custom content added:

  “This action will become available after the custom content has been added”


  * W/ custom content:

  "Not it's visible for everyone"
  "Not it's visible only for admins"

  ---

  ### Show only this content Button:


  * if CE → “Enterprise only”

  * if EE and disabled → "This action will become available after the custom content has been added and made visible to everyone”

  * if EE and enabled → “It will hide…" or “It will show…"

- Regression: Change wording on department removal setting ([#28051](https://github.com/RocketChat/Rocket.Chat/pull/28051))

- Regression: Client crashing when updating CachedChatSubscription ([#28062](https://github.com/RocketChat/Rocket.Chat/pull/28062))

  Currently the typing of 'ISubscription' is a little off from reality. The property `ts` is optional, and this can cause crashes when trying to access `ts`'s properties.

  I decided to avoid changing the type definitions for ISubscription this time, since it will probably impact many other places, and that's not the scope of this task.

- Regression: Client is not loading new settings from server ([#28248](https://github.com/RocketChat/Rocket.Chat/pull/28248))

- Regression: Client-side checks for message deletion ([#27590](https://github.com/RocketChat/Rocket.Chat/pull/27590))

- Regression: Composer fix join room action ([#27657](https://github.com/RocketChat/Rocket.Chat/pull/27657))

- Regression: Composer Toolbox overlapping borders ([#27714](https://github.com/RocketChat/Rocket.Chat/pull/27714))

- Regression: Creating Custom status  ([#28292](https://github.com/RocketChat/Rocket.Chat/pull/28292))

  User is not able to create a custom status from the admin section. Workspace > User Status > New

  The SAVE button is not performing any action
  ![image](https://user-images.githubusercontent.com/20212776/223121583-769a571a-365d-4f72-8d0b-f43016d31546.png)

- Regression: DateRangePicker errors ([#28015](https://github.com/RocketChat/Rocket.Chat/pull/28015))

  The date range picker for `Yesterday`,  `This Week`, `Previous Week`, and `This Month` in the Message Audit page, was not selecting the correct date range and it was causing form validation issues.

  **Error Evidence:**
  ![Clipboard   - February 10, 2023 6_12 PM](https://user-images.githubusercontent.com/20212776/218519404-f8ab1e02-7b95-452f-8433-374b2208b02a.png)
  ![Clipboard   - February 10, 2023 6_10 PM](https://user-images.githubusercontent.com/20212776/218519412-4392b3cd-7e21-42f0-aac5-4c30a980b9af.png)
  ![Clipboard   - February 10, 2023 6_09 PM](https://user-images.githubusercontent.com/20212776/218519417-6726fea6-34bd-41fc-b7fb-e7e3c5ba53cd.png)
  ![Clipboard   - February 10, 2023 6_08 PM](https://user-images.githubusercontent.com/20212776/218519423-8ec8f0b2-6ad6-4d3c-b678-5383792d4ff3.png)

- Regression: Decrypt thread main message for room ([#28262](https://github.com/RocketChat/Rocket.Chat/pull/28262))

- Regression: Denied Camera permission do not disable VideoMessageAction ([#28210](https://github.com/RocketChat/Rocket.Chat/pull/28210))

  #### before
  ![Kapture 2023-02-28 at 16 12 58](https://user-images.githubusercontent.com/27704687/221955658-2c733275-e193-4029-ba9e-777caf3f03ba.gif)

  #### after
  ![Kapture 2023-02-28 at 16 09 20](https://user-images.githubusercontent.com/27704687/221954849-f4379294-0189-4466-a523-ab71e1a8d0af.gif)

- Regression: Denied Microphone permission disables composer ([#28133](https://github.com/RocketChat/Rocket.Chat/pull/28133))

  ![Kapture 2023-02-23 at 13 10 38](https://user-images.githubusercontent.com/27704687/220964655-b2a3b69c-9b32-4f82-b585-49ac0118297a.gif)

- Regression: Disable video message when composer is in use ([#28073](https://github.com/RocketChat/Rocket.Chat/pull/28073))

- Regression: Disabled grandfathered apps must have the option to be enabled ([#28266](https://github.com/RocketChat/Rocket.Chat/pull/28266))

  Grandfathered apps will not follow the new enabling flow and it should always be possible to enable them

- Regression: Emoji picker styling ([#28046](https://github.com/RocketChat/Rocket.Chat/pull/28046))

  ### Before
  <img width="477" alt="image" src="https://user-images.githubusercontent.com/58601732/218936623-832066e0-1854-4b4f-9579-03403ef00a82.png">

  ### After
  <img width="425" alt="image" src="https://user-images.githubusercontent.com/58601732/218940006-c87b91eb-95b5-46db-8a42-152201b3ec93.png">

- Regression: EmojiPicker missing shadow on dark mode ([#28236](https://github.com/RocketChat/Rocket.Chat/pull/28236))

  #### before
  ![Screen Shot 2023-03-01 at 18 23 18](https://user-images.githubusercontent.com/27704687/222267993-3958de34-5f28-4550-ae93-ef81af034b21.png)

  #### after
  ![Screen Shot 2023-03-01 at 18 22 14](https://user-images.githubusercontent.com/27704687/222267788-e39d292b-5dc2-4797-b227-1b47008075e7.png)

- Regression: EnableUnlimitedApps button action ([#28221](https://github.com/RocketChat/Rocket.Chat/pull/28221))

  "Enable unlimited apps" button on installation modal doesn't do anything. Now it redirects to the `'go-fully-featured-registered'` page.

- Regression: fix a wrong behavior with the Department table row ([#28157](https://github.com/RocketChat/Rocket.Chat/pull/28157))

- Regression: Fix agent departments select value ([#28077](https://github.com/RocketChat/Rocket.Chat/pull/28077))

- Regression: fix api tests ([#28067](https://github.com/RocketChat/Rocket.Chat/pull/28067))

- Regression: Fix app status filter not working in private apps page ([#28198](https://github.com/RocketChat/Rocket.Chat/pull/28198))

  ## Jira task: [MKP-266](https://rocketchat.atlassian.net/browse/MKP-266?atlOrigin=eyJpIjoiMzlhNmRhZDNmOGZkNDBmZGEyY2FkNTQ5ZTVlZjUzNzkiLCJwIjoiaiJ9)
  Fixed a bug in which the app status filter didn't work because of the new 'enabled*' and 'disabled*' app status.
  Demo gif:
  ![private-apps-status-filter](https://user-images.githubusercontent.com/43561537/221709473-633f6866-e921-438d-9a20-e6b341823cbf.gif)

- Regression: fix close flextab on click outside the container ([#27857](https://github.com/RocketChat/Rocket.Chat/pull/27857))

- Regression: Fix composer restore ([#27642](https://github.com/RocketChat/Rocket.Chat/pull/27642))

- Regression: Fix Custom CSS  ([#27993](https://github.com/RocketChat/Rocket.Chat/pull/27993))

- Regression: Fix department edit breaking ([#28053](https://github.com/RocketChat/Rocket.Chat/pull/28053))

- Regression: Fix emojiPicker reactivity on load-more ([#28331](https://github.com/RocketChat/Rocket.Chat/pull/28331))

- Regression: Fix file upload on collapsed composer menu ([#28071](https://github.com/RocketChat/Rocket.Chat/pull/28071))

- Regression: Fix go to ThreadList hook ([#27663](https://github.com/RocketChat/Rocket.Chat/pull/27663))

- Regression: Fix hasLicense failing due call stack limit reasons ([#28304](https://github.com/RocketChat/Rocket.Chat/pull/28304))

- Regression: Fix improper usage of useEndpointData ([#28050](https://github.com/RocketChat/Rocket.Chat/pull/28050))

- Regression: Fix intermitent apps engine startup ([#28254](https://github.com/RocketChat/Rocket.Chat/pull/28254))

  Makes the apps limitation functionality depend on methods from the Apps Engine's service instead of a dynamic import of the apps orchestrator, making the engine's load process deterministic.

- Regression: Fix missing Formatting items ([#28044](https://github.com/RocketChat/Rocket.Chat/pull/28044))

- Regression: Fix not showing global search option ([#28342](https://github.com/RocketChat/Rocket.Chat/pull/28342))

- Regression: Fix omnichannel chat forwarding not working ([#28117](https://github.com/RocketChat/Rocket.Chat/pull/28117))

- Regression: Fix presence broadcast not re-enabling ([#28017](https://github.com/RocketChat/Rocket.Chat/pull/28017))

- Regression: Fix private apps already in marketplace not shown properly on app details page ([#28199](https://github.com/RocketChat/Rocket.Chat/pull/28199))

  ## Jira task: [MKP-267](https://rocketchat.atlassian.net/browse/MKP-267?atlOrigin=eyJpIjoiMDVmNDJjYjFjZDNiNGU4NTk4NGQ4ODZjMjM3NDYwNDciLCJwIjoiaiJ9)
  Fixed a bug in which apps that already existed in the marketplace would not show properly when installed via the private apps page.
  Demo gif:
  ![private-apps-same-app](https://user-images.githubusercontent.com/43561537/221710893-004adb81-2dd7-4ad4-b0c6-18b644415ac0.gif)

- Regression: Fix RegisterForm Translations ([#28156](https://github.com/RocketChat/Rocket.Chat/pull/28156))

- Regression: Fix remove user from room shows skeleton ([#28247](https://github.com/RocketChat/Rocket.Chat/pull/28247))

  When the user is removed from a public channel and has it open it will show a grey placeholder screen

  Now, it appears the Join button as usual

- Regression: Fix slash command with preview ([#28127](https://github.com/RocketChat/Rocket.Chat/pull/28127))

- Regression: Fix slash commands ([#28168](https://github.com/RocketChat/Rocket.Chat/pull/28168))

- Regression: fix Thread horizontal scrolling ([#28327](https://github.com/RocketChat/Rocket.Chat/pull/28327))

- Regression: Fix toggle theme breaking UI ([#28161](https://github.com/RocketChat/Rocket.Chat/pull/28161))

- Regression: Fix write stream error on user data export ([#27683](https://github.com/RocketChat/Rocket.Chat/pull/27683))

- Regression: Fixed room edit custom field validation ([#28078](https://github.com/RocketChat/Rocket.Chat/pull/28078))

  This PR fixes custom fields validations not being properly triggered/cleared on the room edit page.

- Regression: Fixed triggers edit form not being properly updated ([#28235](https://github.com/RocketChat/Rocket.Chat/pull/28235))

- Regression: Formatted text rendered by UI Kit ([#28060](https://github.com/RocketChat/Rocket.Chat/pull/28060))

- Regression: Gracefully stop DDP Streamer publication and close WS ([#28121](https://github.com/RocketChat/Rocket.Chat/pull/28121))

- Regression: Hide price and category filters when inside of private apps page ([#28188](https://github.com/RocketChat/Rocket.Chat/pull/28188))

  ## Jira task: [MKP-265](https://rocketchat.atlassian.net/browse/MKP-265?atlOrigin=eyJpIjoiMGUyMjI0ZTJjNjg1NDc5ZWE0Y2U4NDVkMzk4MmRmYmEiLCJwIjoiaiJ9)
  The price and category filters dont make sense for private apps so when inside of the private apps page these filters will now be hidden.
  Demo image:
  ![image](https://user-images.githubusercontent.com/43561537/221595718-c812861a-672e-44ac-bb03-6046064e420a.png)

- Regression: Hide Workspace registration feature for non-admin users ([#28154](https://github.com/RocketChat/Rocket.Chat/pull/28154))

- Regression: Image Attachment Description size ([#28149](https://github.com/RocketChat/Rocket.Chat/pull/28149))

  The Image Attachment is breaking lines to match the size of the image, should follow the same size of the normal message.

  **Previous:**
  ![image](https://user-images.githubusercontent.com/20212776/221175529-e574fbdb-9069-48ae-9946-d6ea475ba4bf.png)

  **Current:**
  ![image](https://user-images.githubusercontent.com/20212776/221175349-486b4c40-16a2-40ab-9593-089963b6315b.png)

- Regression: Incorrect installation flow on app detail and upload app pages ([#28173](https://github.com/RocketChat/Rocket.Chat/pull/28173))

  The install button displayed in the App detail page of an app from the Marketplace that hasn't been installed in the workspace didn't follow the same installation steps performed in the app list on Explore or Enterprise pages.

  This PR isolates the installation handler so the exact same functions are used in both places.

  The same problem was solved in the Upload App page

- Regression: Incorrect system message upon adding/editing SLA policy for a room. ([#28151](https://github.com/RocketChat/Rocket.Chat/pull/28151))

- Regression: Installation of some apps fail ([#28265](https://github.com/RocketChat/Rocket.Chat/pull/28265))

  Installation was failing for apps that did not include a set o permissions required because the process was short circuiting in those cases. However, they are valid as they signify apps that function with the default permission set

- Regression: Jump to message not working ([#28163](https://github.com/RocketChat/Rocket.Chat/pull/28163))

- Regression: Message > `messageActionDefault`> Copy and Report ([#28040](https://github.com/RocketChat/Rocket.Chat/pull/28040))

  This regression was probably generated by the Attachments rewrite.

  Issue 1: When selecting the action `Copy` on the message toolbox with Attachment Messages (messages with files/images)
  The copied content was empty because was getting from an empty prop.

  **Previous output:**
  ![output2](https://user-images.githubusercontent.com/20212776/218820716-e5c6b9cf-8968-4ee7-9e87-f958edcc7fdf.jpg)

  **Current output:**
  ![output1](https://user-images.githubusercontent.com/20212776/218820706-c26ff106-1eb9-4e07-bb71-a4f97cc21d97.jpg)


  Issue 2: When selecting the action `Report` the reported message was showing an unformatted message (with markdown tokens)

  **Previous output:**
  ![output4](https://user-images.githubusercontent.com/20212776/218821154-2090a79d-58ee-4717-8646-e1eb2b5ad46e.jpg)

  **Current output:**
  ![output3](https://user-images.githubusercontent.com/20212776/218821189-e820b58e-1128-4a34-80d8-0aadeb880830.jpg)

- Regression: message box issues ([#27495](https://github.com/RocketChat/Rocket.Chat/pull/27495))

  It fixes some problems introduced/exposed after refactoring the `ChatMessages` API.

- Regression: message-parse version update ([#28245](https://github.com/RocketChat/Rocket.Chat/pull/28245))

  Regression to fix URL parsing issues
  ![image](https://user-images.githubusercontent.com/20212776/222496497-17ee54be-0c45-403f-97b9-95d7428328d8.png)

- Regression: Missing contexts on contextual bar ([#27734](https://github.com/RocketChat/Rocket.Chat/pull/27734))

  It should fixes crashes on starred, pinned, and mentioned messages while those are migrating from Blaze to React.

- Regression: more message box issues ([#27499](https://github.com/RocketChat/Rocket.Chat/pull/27499))

  It handles issues regarding editing messages.

- Regression: New messages not reflected in the chat window for queued chats. ([#28145](https://github.com/RocketChat/Rocket.Chat/pull/28145))

- Regression: OAuth Login ([#28303](https://github.com/RocketChat/Rocket.Chat/pull/28303))

  Login flow with Rocket.Chat as an OAuth provider was broken

- Regression: OAuthApps are added with empty string `_id` field ([#28257](https://github.com/RocketChat/Rocket.Chat/pull/28257))

  - Fix OAuthApps added to the database with a empty string `_id` field.

- Regression: Open Thread ([#27640](https://github.com/RocketChat/Rocket.Chat/pull/27640))

- Regression: Re-add app signature migration to fix the faulty previous one ([#28107](https://github.com/RocketChat/Rocket.Chat/pull/28107))

  Previously merged migration files ended up in a faulty migration

- Regression: Rectifying thread layout ([#27680](https://github.com/RocketChat/Rocket.Chat/pull/27680))

  This PR fixes:

  - the size and scrolling area of the list of messages;

  - the margin and general style of "Also send to channel" checkbox;

  - the size of link previews.

- Regression: Regular users were not able to leave federated rooms ([#28148](https://github.com/RocketChat/Rocket.Chat/pull/28148))

  When regular users (not owners, nor moderators) tried to leave federated rooms, they were not allowed to do so due to a bad permission check.

  Jira: FED-88

- Regression: Remove duplicated broadcast App events ([#28310](https://github.com/RocketChat/Rocket.Chat/pull/28310))

- Regression: Remove unnecessary messages from Email transcript ([#28165](https://github.com/RocketChat/Rocket.Chat/pull/28165))

- Regression: run clientMessageRecieved hooks on thread main message ([#27962](https://github.com/RocketChat/Rocket.Chat/pull/27962))

- Regression: Save button is not enable while trying to save contact manager ([#28183](https://github.com/RocketChat/Rocket.Chat/pull/28183) by [@FabioCavaleti](https://github.com/FabioCavaleti))

- Regression: Scroll bars in sidebar ([#28091](https://github.com/RocketChat/Rocket.Chat/pull/28091))

- Regression: Scrolling on threads ([#28298](https://github.com/RocketChat/Rocket.Chat/pull/28298))

- Regression: SendFileLivechatMessage using deprecated prop affecting PDF transcript ([#28225](https://github.com/RocketChat/Rocket.Chat/pull/28225))

- Regression: Show mention instead of the name of the user in app request messages ([#28200](https://github.com/RocketChat/Rocket.Chat/pull/28200))

  ## Jira task: [MKP-249](https://rocketchat.atlassian.net/browse/MKP-249?atlOrigin=eyJpIjoiYmNmMjBjOGI5OGUwNGVhMTg1NGMyNDZhMGYzMGY4YWMiLCJwIjoiaiJ9)
  Stopped using the name of users that requested apps and now the app request messages directly mention the users.
  Demo image:
  ![image](https://user-images.githubusercontent.com/43561537/221995968-c6e4dc7e-9052-4121-b5d0-610a1fbe7ea1.png)

- Regression: Show messages instead of the composer when there is no action available on federated rooms ([#28093](https://github.com/RocketChat/Rocket.Chat/pull/28093))

  Rules:
  If the federation module is disabled within the workspace: **do not show the composer and show a message instead**;

  If the federation module is enabled, the user is not part of the room, and the workspace is a CE environment: **do not show the composer and show a message instead.**

  If the federation module is enabled, the is not part of the room, but the workspace is an EE environment: **show the composer with the Join button**

  If everything is enabled, and the user is already part of the room: **show the normal composer**

  Jira: [FED-82]

- Regression: Sidebar collapsing on extra small views ([#27651](https://github.com/RocketChat/Rocket.Chat/pull/27651))

  ### before
  <img width="382" alt="Screen Shot 2022-12-27 at 10 39 21" src="https://user-images.githubusercontent.com/27704687/209674871-6eb2171d-6fbf-4539-8af6-c382019d1748.png">


  ### after
  <img width="381" alt="Screen Shot 2022-12-27 at 10 38 10" src="https://user-images.githubusercontent.com/27704687/209674727-6b4f989d-a0d1-43a2-a532-d879521675d3.png">

- Regression: Slash commands detected at any line ([#28142](https://github.com/RocketChat/Rocket.Chat/pull/28142))

- Regression: Small fixes to installation flow ([#28160](https://github.com/RocketChat/Rocket.Chat/pull/28160))

  Some UI fixes on app installation flow:

  * Some apps were being incorrectly shown as "Enabled"
  App status `INITIALIZED` was wrongly considered as meaning an app was "Enabled". That's not the case.

  It was introduced there to mark apps as "installed", but this is not the case anymore.  #27330 wanted to solve the situation where an app was initially shown as disabled right after it was installed, and a different solution to this will be provided by changing how Apps-Engine communicates status changes to the UI.


  * Some installed apps in the "Installed" screen incorrectly not being displayed as grandfathered

  * Installation modal being shown in EE where it shouldn't

  * Installation modal showed wrong label when installing apps from Marketplace

- Regression: Support generating pdfs from queue ([#28162](https://github.com/RocketChat/Rocket.Chat/pull/28162))

  This removes a code validation that prevented PDF files from being generated for rooms that were closed directly from the queue.

  After discussing with product, this is a behavior we want and so we're removing the code preventing it and updating the translation keys.

- Regression: Tooltip for More options dont disappear after click. ([#28201](https://github.com/RocketChat/Rocket.Chat/pull/28201))

- Regression: UiKit message surface styles ([#28213](https://github.com/RocketChat/Rocket.Chat/pull/28213))

- Regression: Undefined default message context ([#27870](https://github.com/RocketChat/Rocket.Chat/pull/27870))

  It fixes some contextual bar tabs (e.g. "Mentions").

- Regression: Update color tokens for voip footer ([#28197](https://github.com/RocketChat/Rocket.Chat/pull/28197))

- Regression: Update Composer Formatters Translation Keys ([#28228](https://github.com/RocketChat/Rocket.Chat/pull/28228))

- Regression: upserting data into cached collections ([#27965](https://github.com/RocketChat/Rocket.Chat/pull/27965))

  This one should get rid of "grey" (temporary) messages.

- Regression: Video Recorder "record" button alignment ([#28122](https://github.com/RocketChat/Rocket.Chat/pull/28122))

  ### Before
  <img width="100" alt="image" src="https://user-images.githubusercontent.com/2263066/220740337-82668932-0ac4-4b43-8a26-07fdb4cb0cd4.png">
  <img width="100" alt="image" src="https://user-images.githubusercontent.com/2263066/220740566-a1d14f75-c207-4f7f-8422-3e15386a6b11.png">

  ### After
  <img width="100" alt="image" src="https://user-images.githubusercontent.com/2263066/220740404-7dd22522-5f55-4538-aa3d-ddf70cecc9a5.png">
  <img width="100" alt="image" src="https://user-images.githubusercontent.com/2263066/220740699-7b34e5e6-2f6c-4169-ac13-55d73b5263bf.png">

- Regression: View mode preferences without the selected option by default ([#28120](https://github.com/RocketChat/Rocket.Chat/pull/28120))

  After removing all Meteor Blaze templates from the project, the View mode preferences started presenting the issue:

  No option is selected by default when the view mode preferences are open.

  Possible reason: React does allow you to use name attributes in the input tag, but it may cause some issues with radio buttons. One possible reason is that React uses a synthetic event system that does not rely on native HTML attributes, since we had the wrapper and several blaze templates in the project, this could be effecting this behavior ignoring the name attribute in the inputs.


  **Previous:**
  ![image](https://user-images.githubusercontent.com/20212776/220721444-51e32397-5106-4f16-8af9-7b7e5d7209ea.png)


  **Current:**
  ![image](https://user-images.githubusercontent.com/20212776/220721529-77af023b-951a-44f6-82a8-b2c18a7d0950.png)

- Regression: Visitor abandonment job not working properly ([#28209](https://github.com/RocketChat/Rocket.Chat/pull/28209))

- Regression: Zapier Callout using wrong props ([#28311](https://github.com/RocketChat/Rocket.Chat/pull/28311))

- Release 5.4.4 ([#28333](https://github.com/RocketChat/Rocket.Chat/pull/28333))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Dnouv](https://github.com/Dnouv)
- [@Educg550](https://github.com/Educg550)
- [@FabioCavaleti](https://github.com/FabioCavaleti)
- [@Nabhag8848](https://github.com/Nabhag8848)
- [@carlosrodrigues94](https://github.com/carlosrodrigues94)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@henit-chobisa](https://github.com/henit-chobisa)
- [@jschirrmacher](https://github.com/jschirrmacher)
- [@lingohub[bot]](https://github.com/lingohub[bot])
- [@matheuslc](https://github.com/matheuslc)
- [@nYCSTs](https://github.com/nYCSTs)
- [@ostjen](https://github.com/ostjen)
- [@pouyadarabi](https://github.com/pouyadarabi)
- [@try-catch-stack](https://github.com/try-catch-stack)
- [@urbalazs](https://github.com/urbalazs)
- [@weslley543](https://github.com/weslley543)
- [@xareyli](https://github.com/xareyli)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AlenDavid](https://github.com/AlenDavid)
- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@Harmeet221](https://github.com/Harmeet221)
- [@KevLehman](https://github.com/KevLehman)
- [@LucianoPierdona](https://github.com/LucianoPierdona)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@PedroRorato](https://github.com/PedroRorato)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@casalsgh](https://github.com/casalsgh)
- [@cauefcr](https://github.com/cauefcr)
- [@csuadev](https://github.com/csuadev)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@engelgabriel](https://github.com/engelgabriel)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@graywolf336](https://github.com/graywolf336)
- [@guijun13](https://github.com/guijun13)
- [@hugocostadev](https://github.com/hugocostadev)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tapiarafael](https://github.com/tapiarafael)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@totoi690](https://github.com/totoi690)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 5.4.5
`2023-03-16  ·  1 🐛  ·  2 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`

### 🐛 Bug fixes


- **ENTERPRISE:** DDP streamer sending data to destroyed streams ([#27929](https://github.com/RocketChat/Rocket.Chat/pull/27929))

<details>
<summary>🔍 Minor changes</summary>


- fix(upload): Restriction setting not being applied to the old UFS route ([#28363](https://github.com/RocketChat/Rocket.Chat/pull/28363))

- Regression: Gracefully stop DDP Streamer publication and close WS ([#28121](https://github.com/RocketChat/Rocket.Chat/pull/28121))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.4.4
`2023-03-08  ·  2 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`

<details>
<summary>🔍 Minor changes</summary>


- Chore: New temporary settings to limit access to files and outside room members ([#28319](https://github.com/RocketChat/Rocket.Chat/pull/28319))

- Release 5.4.4 ([#28333](https://github.com/RocketChat/Rocket.Chat/pull/28333))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.4.3
`2023-02-14  ·  1 🐛  ·  2 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

<details>
<summary>🔍 Minor changes</summary>


- Chore: Do not rely on external service on tests ([#27874](https://github.com/RocketChat/Rocket.Chat/pull/27874))

- Release 5.4.3 ([#28028](https://github.com/RocketChat/Rocket.Chat/pull/28028))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.4.2
`2023-01-25  ·  1 🚀  ·  5 🐛  ·  6 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🚀 Improvements


- Emoji picker for large amount of custom emojis ([#27745](https://github.com/RocketChat/Rocket.Chat/pull/27745))

### 🐛 Bug fixes


- `*.files` endpoints returning hidden files ([#27617](https://github.com/RocketChat/Rocket.Chat/pull/27617))

- New users aren't mapped to rooms with OAuth groups/channels map ([#27000](https://github.com/RocketChat/Rocket.Chat/pull/27000) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

  This change deals with the problem with the new users coming from key cloak, this users were not being mapped to the correct channels on RC.

- Not all messages in chat conversations are available when forwarding between agents or departments. ([#27816](https://github.com/RocketChat/Rocket.Chat/pull/27816))

- OmnichannelRoomIconProvider order breaking VideoConfPopup ([#27740](https://github.com/RocketChat/Rocket.Chat/pull/27740))

  Jira Issue [VC-39]

- Showing thumbnails on files list ([#23301](https://github.com/RocketChat/Rocket.Chat/pull/23301) by [@carlosrodrigues94](https://github.com/carlosrodrigues94) & [@ostjen](https://github.com/ostjen))

### 👩‍💻👨‍💻 Contributors 😍

- [@carlosrodrigues94](https://github.com/carlosrodrigues94)
- [@ostjen](https://github.com/ostjen)

### 👩‍💻👨‍💻 Core Team 🤓

- [@dougfabris](https://github.com/dougfabris)
- [@filipemarins](https://github.com/filipemarins)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.4.1
`2022-12-16  ·  5 🐛  ·  1 🔍  ·  7 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Custom languages not being applied to i18next ([#27557](https://github.com/RocketChat/Rocket.Chat/pull/27557))

- Fix Login with Show default form disabled ([#27475](https://github.com/RocketChat/Rocket.Chat/pull/27475))

- Message Actions menu does not close upon choosing an action ([#27328](https://github.com/RocketChat/Rocket.Chat/pull/27328))

- Pagination not working on current chats ([#27432](https://github.com/RocketChat/Rocket.Chat/pull/27432))

- Registration and Login placeholders not being used ([#27558](https://github.com/RocketChat/Rocket.Chat/pull/27558))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Deprecate unused omnichannel API ([#27538](https://github.com/RocketChat/Rocket.Chat/pull/27538))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@filipemarins](https://github.com/filipemarins)
- [@ggazzo](https://github.com/ggazzo)
- [@hugocostadev](https://github.com/hugocostadev)
- [@murtaza98](https://github.com/murtaza98)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 5.4.0
`2022-12-05  ·  9 🎉  ·  13 🚀  ·  61 🐛  ·  87 🔍  ·  57 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🎉 New features


- Add new endpoint 'livechat/agent.status' & deprecate changeLivechatStatus meteor method  ([#27047](https://github.com/RocketChat/Rocket.Chat/pull/27047))

- Bugsnag client ([#23580](https://github.com/RocketChat/Rocket.Chat/pull/23580))

- Custom MessageType for video conference messages ([#27333](https://github.com/RocketChat/Rocket.Chat/pull/27333))

- Emphasis Elements (italic, strike and bold) in Message Parser Components ([#27003](https://github.com/RocketChat/Rocket.Chat/pull/27003))

  Currently the message parser does not accept Emphasis elements mixed with plain text

  `[Normal Link   - *Bold*, _Italic_  and ~strike~ Styles](https://rocket.chat/)` return plain text → Should return a Lin with bold/italic/strike

  To fix this behavior it was necessary to edit LinkSpan component in gazzodown package (changes included in this PR) and the grammar/utils files in the `fuselage/message-parser` repository

  Fuselage Pull Request:  https://github.com/RocketChat/fuselage/pull/887/

- Federation events coverage expansion ([#27119](https://github.com/RocketChat/Rocket.Chat/pull/27119))

  This PR adds the following features for the Matrix Federation feature:

  - Ability to sync Users' real names (since they have at least one room in common with other users);

  - User typing event;

- Incompatible Apps ([#27280](https://github.com/RocketChat/Rocket.Chat/pull/27280) by [@matheuslc](https://github.com/matheuslc))

- REST API endpoint `/v1/oauth-apps.create` ([#27054](https://github.com/RocketChat/Rocket.Chat/pull/27054))

  Created the 'oauth-apps.addOAuthApp' endpoint for the `apps/meteor/client/views/admin/oauthApps/OAuthAddApp.tsx` file, and added Ajv validation.

- REST API endpoint `/v1/rooms.delete` ([#26866](https://github.com/RocketChat/Rocket.Chat/pull/26866))

- Video Conference Message blocks and info action ([#27310](https://github.com/RocketChat/Rocket.Chat/pull/27310))

### 🚀 Improvements


- Add message name container component to message name header and system message ([#27184](https://github.com/RocketChat/Rocket.Chat/pull/27184))

  Add `MessageNameContainer` wrapper to display `name` and `username` inline and separate them with a blank space.

  Update font size of system message:

  Before:
  ![Screenshot 2022-11-08 at 13 51 58](https://user-images.githubusercontent.com/9275105/200626484-bfcf3eb2-ac36-4b6c-8158-b84bf93023bd.png)


  After:
  <img width="720" alt="Screenshot 2022-11-08 at 10 56 10" src="https://user-images.githubusercontent.com/9275105/200584230-2f8a63b9-137b-441e-9671-b4801688cac5.png">


  Add removed message variation to `ThreadMessageOrigin` component
  Before:
  ![Screenshot 2022-11-08 at 13 35 45](https://user-images.githubusercontent.com/9275105/200622876-5e5bd7a2-2df1-453a-9e81-96635390648e.png)

  After:
  <img width="185" alt="Screenshot 2022-11-08 at 10 51 47" src="https://user-images.githubusercontent.com/9275105/200582261-7e371e1a-adfd-47a0-8440-facd06e61b09.png">

- Add searchTerm support for livechat/rid/messages API ([#27214](https://github.com/RocketChat/Rocket.Chat/pull/27214))

- Add update option to apps list kebab menu and implement new update badge on apps list ([#27246](https://github.com/RocketChat/Rocket.Chat/pull/27246))

  Added a new update option to the app menu to follow the removal of the CTA buttons from the apps list. Also implemented the new update badge that will replace the old update button.
  Demo gif:
  ![update_badge](https://user-images.githubusercontent.com/43561537/202225372-c0369bea-12d4-4ea3-8996-8d4edab00722.gif)

- Adding a noscript tag for letting users know if they have JS disabled ([#23632](https://github.com/RocketChat/Rocket.Chat/pull/23632) by [@sidmohanty11](https://github.com/sidmohanty11))

- Improve searchChats endpoint to have source filter support ([#27262](https://github.com/RocketChat/Rocket.Chat/pull/27262))

- Login rewrite in react ([#26782](https://github.com/RocketChat/Rocket.Chat/pull/26782))

- Marketplace feedback toasts ([#27239](https://github.com/RocketChat/Rocket.Chat/pull/27239))

  ## Jira tasks
  Save app changes toast: [MKP-160](https://rocketchat.atlassian.net/browse/MKP-160?atlOrigin=eyJpIjoiMjM1YmZjMTVjZGU2NGUwMGIxNTRlYTEwODgwMDk2ZDkiLCJwIjoiaiJ9)
  Uninstall app toast: [MKP-168](https://rocketchat.atlassian.net/browse/MKP-168?atlOrigin=eyJpIjoiOThkMjEwOTk5NjhiNDE2OGEwY2MyNWEyNWM5YzNkMTUiLCJwIjoiaiJ9)
  Enable/disable app feedback toast: [MKP-169](https://rocketchat.atlassian.net/browse/MKP-169?atlOrigin=eyJpIjoiN2VjODIzOGMwNmJkNGU3N2JhOWEzMDU3Y2IxZjZkNWMiLCJwIjoiaiJ9)


  Implemented/refactored four toast notifications and refactored another two in marketplace. The first one happens after the user saves the settings of an app, the second one when the user successfully uninstalls an app and the third and fourth ones happen when the user enables and disables an app respectfully.
  Demo gif:
  ![feedback_toasts](https://user-images.githubusercontent.com/43561537/202277707-a3b38536-e090-4c4f-96b4-8e21bcd10070.gif)

- Move app list install logic to app menu ([#27056](https://github.com/RocketChat/Rocket.Chat/pull/27056))

  ## Jira task: [MKP-136](https://rocketchat.atlassian.net/browse/MKP-136?atlOrigin=eyJpIjoiM2M0ODhkZDc0YjQ2NGE5OGE4YTBkZDJhY2M0NGVmZDgiLCJwIjoiaiJ9)
  Moved the install/buy/subscribe logic from the CTA buttons that existed in the app list to the app menu. Now the user can install apps by clicking in the kebab menu in the right of the app list entry. Also solved a little undefined bug happening in the app permissions modal.
  Demo gif:
  ![app_menu](https://user-images.githubusercontent.com/43561537/195204630-e66c7859-028f-4654-8367-96029a855b42.gif)

- Quotes on E2EE Messages ([#26303](https://github.com/RocketChat/Rocket.Chat/pull/26303))

  This PR provides basic quoting to E2EE messages, it doesn't support multiple chaining of quotes messages.

  <img width="725" alt="Screenshot 2022-07-19 at 9 42 19 PM" src="https://user-images.githubusercontent.com/58601732/179798812-c0d092f1-388a-4d46-bb1d-9c332d14cc77.png">

- Read threads when marking a room as read ([#26754](https://github.com/RocketChat/Rocket.Chat/pull/26754))

  This PR changes the functionality of `subscription.read` to add read threads when endpoint is called

- Removed tool tip from sidebar menu ([#24605](https://github.com/RocketChat/Rocket.Chat/pull/24605) by [@Himanshu664](https://github.com/Himanshu664))

- Sorting functionality in team channel while leaving a team ([#21790](https://github.com/RocketChat/Rocket.Chat/pull/21790) by [@sumukhah](https://github.com/sumukhah))

- VideoConf Miss Config Modal ([#27153](https://github.com/RocketChat/Rocket.Chat/pull/27153))

  Jira Issue: [VC-9]

  <img width='420px' src='https://user-images.githubusercontent.com/27704687/199082670-7a5b47ea-077b-48f1-b232-ccdfa682e087.png' />

### 🐛 Bug fixes


- `channels.convertToTeam` endpoint doesn't work when only the `channelName` param is provided ([#26858](https://github.com/RocketChat/Rocket.Chat/pull/26858))

  - Fix the `channels.convertToTeam` endpoint not working when the `channelName` is sent as parameter.

- Add condition to createUser button on UsersPage ([#27189](https://github.com/RocketChat/Rocket.Chat/pull/27189))

  Hide the create user button in admin if the user doesn't have the permission to do so. It was not the case before.


  https://user-images.githubusercontent.com/45966964/115802514-5ab86300-a3df-11eb-98d8-7aba696bfa7e.mp4

- Add condition to invite user if user doesn't have permission ([#27190](https://github.com/RocketChat/Rocket.Chat/pull/27190))

  If you deactivated the permission to send links, the button was always there and led to an error message.
  Before:

  https://user-images.githubusercontent.com/45966964/115801057-23948280-a3dc-11eb-83c2-b3e16f66ddd5.mp4

  After:

  https://user-images.githubusercontent.com/45966964/115801253-956ccc00-a3dc-11eb-95d0-9baa69410fe1.mp4

- Add pause functionality to Custom Sounds ([#24361](https://github.com/RocketChat/Rocket.Chat/pull/24361))

- Add sorting channels on teams ([#21675](https://github.com/RocketChat/Rocket.Chat/pull/21675) by [@sumukhah](https://github.com/sumukhah))

- Adding error message for wrong dates ([#21677](https://github.com/RocketChat/Rocket.Chat/pull/21677) by [@shrinish123](https://github.com/shrinish123))

  Before :
  ![before](https://user-images.githubusercontent.com/56491104/115405052-85ea5900-a20b-11eb-9c78-5e98de6c454c.png)

  After:

  ![after export](https://user-images.githubusercontent.com/56491104/115405085-8da9fd80-a20b-11eb-8b72-de9ef7c2217b.png)

- Adjust read only toggle on create channel based on permissions ([#27318](https://github.com/RocketChat/Rocket.Chat/pull/27318))

- Adjusted form validation to disallow duplicated emails ([#27037](https://github.com/RocketChat/Rocket.Chat/pull/27037))

  This pull request revisits the user info form, fixing a bug that allowed the form to be saved with an already existing e-mail. Taking advantage of this opportunity this PR also refactors the file to typescript and adds new libs like `useForm` and `useQuery`.

- Always parse encrypted messages on client ([#27092](https://github.com/RocketChat/Rocket.Chat/pull/27092))

- Archived channels reappearing permanently ([#20476](https://github.com/RocketChat/Rocket.Chat/pull/20476))

- AttachmentDescription color token ([#27222](https://github.com/RocketChat/Rocket.Chat/pull/27222))

- Avg response time calculation ([#27163](https://github.com/RocketChat/Rocket.Chat/pull/27163))

- Change GridFS error message validation ([#26957](https://github.com/RocketChat/Rocket.Chat/pull/26957))

  Allow uninstalling an app even if source files cannot be found. This validation was already done in the past, but since the error message was changed, the validation was broken.

- Delete first message when initializing thread returns black screen ([#27117](https://github.com/RocketChat/Rocket.Chat/pull/27117))

- Discussion list timestamp and Edit room system messages ([#27180](https://github.com/RocketChat/Rocket.Chat/pull/27180))

- Discussions list divider on contextualBar ([#27178](https://github.com/RocketChat/Rocket.Chat/pull/27178))

- Display Edit Team instead of Edit Room when in a team ([#27230](https://github.com/RocketChat/Rocket.Chat/pull/27230))

- Ensure onetime job runs according to 'startupSetting' everytime ([#27311](https://github.com/RocketChat/Rocket.Chat/pull/27311))

  - Fixes the condition of not running a _onetime job_ at the app's startup scheduled to run by using the [`startupSetting`](https://github.com/RocketChat/Rocket.Chat.Apps-engine/blob/04f5930244836043040a8c42beff0690a2359a53/src/definition/scheduler/IProcessor.ts#L8) if the job was run previously at another app startup (Agenda does not remove already run jobs from the database, preventing the app from scheduling the job a second time as it thinks the job is already scheduled);

  - Declutters the scheduler's collection by removing _onetime jobs_ documents after they are run.

- Featured apps disappearing, install toast config and save changes button behavior ([#27181](https://github.com/RocketChat/Rocket.Chat/pull/27181))

  ## Jira tasks
  Featured apps disappearing: [MKP-161](https://rocketchat.atlassian.net/browse/MKP-161?atlOrigin=eyJpIjoiYjI4MWMyODJkZjlkNDEwMjhkZWFhNjkxZjBiZTJiOGMiLCJwIjoiaiJ9)
  Install toast config: [MKP-162](https://rocketchat.atlassian.net/browse/MKP-162?atlOrigin=eyJpIjoiNjNhNDJjZGE5YWQ5NDJiMWIyZjM4MjMwNmI1MmE5NjUiLCJwIjoiaiJ9)
  Save changes button behavior: [MKP-163](https://rocketchat.atlassian.net/browse/MKP-163?atlOrigin=eyJpIjoiZjc3MzUwZTNmYjU3NDJiZjhlOWI0OGIzMGY3ZWQ5ODUiLCJwIjoiaiJ9)

  Fixed three bugs: In the first one featured apps would disappear from the apps list after installation, in the second one the install toast wasn't correctly configured, and in the third one the app details page save button would render even when the current app wasn't installed.
  Demo gif:

  ![featured_disappearing](https://user-images.githubusercontent.com/43561537/199850435-ca9e8ba1-7924-414e-96f4-dfb373fdd754.gif)

- Fix Piwik and add extra setting to allow workarounds ([#27416](https://github.com/RocketChat/Rocket.Chat/pull/27416))

- Fixed Allow reacting toggle button in Edit room ([#20324](https://github.com/RocketChat/Rocket.Chat/pull/20324) by [@Darshilp326](https://github.com/Darshilp326))

  Users can now see changes for toggling allow reacting button after changes.
  Users do not need to come back for changing allow reacting button.

  https://user-images.githubusercontent.com/55157259/105572410-f274c980-5d7c-11eb-806a-e23c2abd37de.mp4

- Gap between message content and message header when there's no text. ([#27165](https://github.com/RocketChat/Rocket.Chat/pull/27165))

  Before:
  ![image](https://user-images.githubusercontent.com/40830821/199314585-f09920bd-efea-4767-824a-783aca2a229a.png)
  ![image](https://user-images.githubusercontent.com/40830821/199320275-cd32a96c-36a2-4c5b-ac3c-0db6aa57fdf7.png)

  After:
  ![image](https://user-images.githubusercontent.com/40830821/199314648-b6b48512-b8c0-4c11-81bc-d6b97700bf7a.png)
  ![image](https://user-images.githubusercontent.com/40830821/199320172-c6f986b8-29cd-4b2a-95e6-ffe9d51a8eaa.png)

  Additionaly removed a component that was being rendered inside itself, causing spacing issues.

- Improper grammar when converting channel member to owner ([#27265](https://github.com/RocketChat/Rocket.Chat/pull/27265) by [@JoshMcCullough](https://github.com/JoshMcCullough))

- Install private apps modal behavior marketplace ([#26973](https://github.com/RocketChat/Rocket.Chat/pull/26973))

  Fixed two bugs in the private app install page:

  - The first one is a lack of pt-br translation to the agree button of the apps permission modal

  - The second one is that the review modal did not show the default permission list when the app being installed did not provide a permissions list.

  **Demo gif**:
  ![AppsPermissionModal](https://user-images.githubusercontent.com/43561537/193342594-5516b557-948a-4d9d-ade3-65bb1600e458.gif)

- Integration history breaking when there's more than 49 records ([#27290](https://github.com/RocketChat/Rocket.Chat/pull/27290))

  Aditionally, fixed example data for incoming webhooks and converted some files to TS.

- LDAP "Sync Roles" option doesn't work for custom roles ([#26842](https://github.com/RocketChat/Rocket.Chat/pull/26842))

  Previously the sync of custom fields on LDAP wasn't working because the check was assuming that the `name` of the role is the same value from `_id`, which is the same for initial roles, but different for custom.

- LDAP groups to channel mapping attempts to create a new room instead of using an existing one ([#27312](https://github.com/RocketChat/Rocket.Chat/pull/27312))

  - Check rooms' name and **display name** in order to confirm they don't exist (and then try to create a new room).

- Livechat: Allow resolving external image and media blocks  ([#27387](https://github.com/RocketChat/Rocket.Chat/pull/27387))

  Allow external urls to be viewed on livechat.

- MarkdownText component not respecting `Markdown_SupportSchemesForLink` setting ([#27245](https://github.com/RocketChat/Rocket.Chat/pull/27245))

- Marketplace app details page back-button behavior ([#27062](https://github.com/RocketChat/Rocket.Chat/pull/27062))

  Jira task: [MKP-26](https://rocketchat.atlassian.net/browse/MKP-26?atlOrigin=eyJpIjoiM2I4MzVhYmQ2OWRkNDE0ZGI4NWZkMzE3MDQwNmIxMzMiLCJwIjoiaiJ9)

  Fixed the behavior of the marketplace app details page back button. Now it will return the user to the page they accessed the app details from. Also, refactored the overall routing of the marketplace and removed the admin-apps route as everything is now handled by the admin-marketplace route.

  Demo gif:
  ![apps-back-button](https://user-images.githubusercontent.com/43561537/195709074-a886472e-5462-474e-8f65-5cfa33d30263.gif)

- Message Parser version upgrade ([#27284](https://github.com/RocketChat/Rocket.Chat/pull/27284))

- Message search breaking URL, usertags and emojis ([#20878](https://github.com/RocketChat/Rocket.Chat/pull/20878) by [@TBG-FR](https://github.com/TBG-FR))

- Missing React When Read Only setting on Admin Rooms Edit ([#27183](https://github.com/RocketChat/Rocket.Chat/pull/27183))

  When the user was editing a room in the admin, he could not set React When Read Only because the option was not there unlike a normal room edit.  So i added the option.

- Modifying userActionIndicator syntax for translations ([#27004](https://github.com/RocketChat/Rocket.Chat/pull/27004) by [@TBG-FR](https://github.com/TBG-FR))

- multiple user assigned for a role ([#23741](https://github.com/RocketChat/Rocket.Chat/pull/23741) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

- Navigate to home after deleting a channel from edit screen ([#21602](https://github.com/RocketChat/Rocket.Chat/pull/21602) by [@sumukhah](https://github.com/sumukhah))

- Removed mobile requirement for showing real name ([#26968](https://github.com/RocketChat/Rocket.Chat/pull/26968) by [@TedsCabin](https://github.com/TedsCabin))

  Removed the mobile requirement for allowing real names to be used in message headers.

- Replace regex not compatible with safari ([#27294](https://github.com/RocketChat/Rocket.Chat/pull/27294))

- Room Avatar being deleted after upload. ([#27060](https://github.com/RocketChat/Rocket.Chat/pull/27060))

  Remove avatar before updating it. S3 already overwrites the old image, but since this part of the code is shared among many other File Storage providers, we need to make this deletion before the upload.

- RoomForeword design ([#27196](https://github.com/RocketChat/Rocket.Chat/pull/27196))

  Before
  ![image](https://user-images.githubusercontent.com/60678893/200065803-aaafe740-62f6-4d11-b9a4-c4f394f00291.png)


  After
  <img width="725" alt="image" src="https://user-images.githubusercontent.com/60678893/200065737-af395c09-4eab-49a1-9059-b53ad53e0c14.png">

- Scrollable report message ([#26853](https://github.com/RocketChat/Rocket.Chat/pull/26853) by [@yasemincidem](https://github.com/yasemincidem))

- Set default value "false" for global search. ([#25568](https://github.com/RocketChat/Rocket.Chat/pull/25568) by [@ivan1kazantsev](https://github.com/ivan1kazantsev))

  If we disable the "global search", then the "global search" checkbox removes from the UI. It's not what we want. I think, we should set the default to "false", because the default is to search inside the channel/dialog.

- Show a consistent name on information screen ([#21603](https://github.com/RocketChat/Rocket.Chat/pull/21603) by [@sumukhah](https://github.com/sumukhah))

- Show Favorite icon only if user has joined room ([#21976](https://github.com/RocketChat/Rocket.Chat/pull/21976))

  Before: There was a favorite button even if the user hasn't joined the room

  After:

  ![favorite new](https://user-images.githubusercontent.com/56491104/117336514-e8a14d00-aeb9-11eb-8c06-618bdaefa35f.png)

- Shrug missing backslash character ([#27233](https://github.com/RocketChat/Rocket.Chat/pull/27233))

  Previously the escape character `\` was escaping everything.

  To avoid unexpected text formatting errors it was restricted to only escape curtains chars like:   * _ ~ ` # .
  Doing so the Shrug had to change in the code to display the correct ASCII Art

- Sidebar context menu in searchList ([#23830](https://github.com/RocketChat/Rocket.Chat/pull/23830) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

  Removed onClose function from the Box Component inside `searchList.js`  as this component wraps the complete list which is rendered and when clicked on the any rendered row inside the component it closes the searchList preventing the context menu to be displayed.
  Also added `usePreventDefault` hook.
  ## Before

  https://user-images.githubusercontent.com/50165440/144127826-9b6d3e5e-9442-49dc-89c8-b604b910be4c.mp4

  ## After

  https://user-images.githubusercontent.com/50165440/144127815-d60e1026-a0eb-4e9b-a7f3-fe80dd06a2d8.mp4

- Sidebar Room list extended preview not updating on new messages. ([#27259](https://github.com/RocketChat/Rocket.Chat/pull/27259))

- Sort RecordList items in REVERSE chronological order, not FORWARD ([#27201](https://github.com/RocketChat/Rocket.Chat/pull/27201) by [@nmagedman](https://github.com/nmagedman))

  Sort items in the Files sidebar in *reverse* chronological order (newest at top, oldest at bottom), as it did _before_ RC v3.11.0.

- The parent room icon is now clickable ([#21655](https://github.com/RocketChat/Rocket.Chat/pull/21655) by [@shrinish123](https://github.com/shrinish123))

  The parent room icon as shown in the video was not clickable but the cursor type on the icon was a pointer. Now even clicking on the icon or anywhere on the parent room tag will redirect you to the parent room.

  Before :

  https://user-images.githubusercontent.com/56491104/115318759-06717100-a19c-11eb-85e6-f3ad4d788721.mp4


  After:


  https://user-images.githubusercontent.com/56491104/115318784-15582380-a19c-11eb-9aca-b40b872774ad.mp4

- Thread view expand command in wide screens ([#23136](https://github.com/RocketChat/Rocket.Chat/pull/23136) by [@edward-raven](https://github.com/edward-raven))

- ThreadRow hover color ([#27166](https://github.com/RocketChat/Rocket.Chat/pull/27166))

- Threads replied message not clickable on new message template ([#27359](https://github.com/RocketChat/Rocket.Chat/pull/27359))

  Add the link to the parent message on the `ThreadMessagePreview` component;
  Add `message ignored` status to the parent message too;
  Also, allow clicking the message when is ignored status.

- UiKit modals taking 5 seconds to close ([#27225](https://github.com/RocketChat/Rocket.Chat/pull/27225))

- Unable to set idleTimeLimit for users ([#26951](https://github.com/RocketChat/Rocket.Chat/pull/26951))

- Upgrading fuselage package and fix quote message prepend  ([#27307](https://github.com/RocketChat/Rocket.Chat/pull/27307))

  Adding heading styles to message


  ### [OLD] As it was before this change:
  <img width="350" alt="image" src="https://user-images.githubusercontent.com/20212776/202536651-a696839d-8afc-49df-9832-15391f0ae162.png">

  ### [NEW] As it is NOW:
  <img width="406" alt="image" src="https://user-images.githubusercontent.com/20212776/202536808-8c3c6646-4e66-4de3-97b0-00562d494977.png">

  ---

  Fix heading style in quote messages

  Before:
  <img width="413" alt="Screen Shot 2022-11-22 at 14 41 55" src="https://user-images.githubusercontent.com/48109548/203384534-9d0b9cf4-2d87-4f40-a71f-6cfeb44f0131.png">

  After:
  <img width="240" alt="Screen Shot 2022-11-22 at 14 41 47" src="https://user-images.githubusercontent.com/48109548/203384565-bde5105e-0c39-48f9-9e9b-7ed15c20826b.png">

- Uploading Custom Sound files not working, but showing success ([#27177](https://github.com/RocketChat/Rocket.Chat/pull/27177))

- Use name if fname is undefined ([#20459](https://github.com/RocketChat/Rocket.Chat/pull/20459) by [@aKn1ghtOut](https://github.com/aKn1ghtOut))

  In the default general room(and possibly in other cases), the fname property is not set. The site should use the "name" property as a fallback in such cases.

  ### After fix
  ![Screenshot from 2021-01-28 03-47-19](https://user-images.githubusercontent.com/38764067/106062371-b0e97300-611c-11eb-97de-1ff4c668a4c8.png)
  ![Screenshot from 2021-01-28 03-47-55](https://user-images.githubusercontent.com/38764067/106062374-b21aa000-611c-11eb-83db-93a3d0858d46.png)

- User approval email doesn't display username and e-mail when user logs in with OAuth ([#27111](https://github.com/RocketChat/Rocket.Chat/pull/27111) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- User auto complete breaks on enter key press ([#27213](https://github.com/RocketChat/Rocket.Chat/pull/27213))

- User email address does not change when provisioned by OAuth ([#27148](https://github.com/RocketChat/Rocket.Chat/pull/27148) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- UserCard not opening inside Threads ([#27096](https://github.com/RocketChat/Rocket.Chat/pull/27096))

<details>
<summary>🔍 Minor changes</summary>


- Bump version to 5.4.0-develop ([#27439](https://github.com/RocketChat/Rocket.Chat/pull/27439))

- Chore: Add deprecation warning to settings ([#27295](https://github.com/RocketChat/Rocket.Chat/pull/27295))

  ![image](https://user-images.githubusercontent.com/40830821/202707905-dc7e2b02-35ec-4abd-9b91-26b6e66a7124.png)

  List of settings:

  - Show edited status

  - Allow Message snippeting

  - Show formating Tips

  - Disable Embeded for Users

  - Issue tracker links

  - Message attachments > Group Attachment Buttons

  - Markdown > All settings inside Group

  - Autolinker > All settings inside Group

  Edited Message for old federation.

- Chore: Add info log to remove all rooms method ([#27106](https://github.com/RocketChat/Rocket.Chat/pull/27106))

- Chore: Add tests for omni-jobs & add more context in system messages for jobs ([#27048](https://github.com/RocketChat/Rocket.Chat/pull/27048))

- Chore: Added tooltip to options of message-actions ([#24043](https://github.com/RocketChat/Rocket.Chat/pull/24043) by [@aswinidev](https://github.com/aswinidev))

  https://user-images.githubusercontent.com/76481696/147604643-253d0577-65d6-4bfe-b67e-49a7cc67c03e.mp4

- Chore: also send thread to channel translations ([#27242](https://github.com/RocketChat/Rocket.Chat/pull/27242))

  <img width="913" alt="image" src="https://user-images.githubusercontent.com/58601732/202270101-57b4dbb2-b5f8-4a54-99c9-66ad66cf1fac.png">

- Chore: Apps/Marketplace code organization ([#27061](https://github.com/RocketChat/Rocket.Chat/pull/27061))

- Chore: Beta Dark Theme switch ([#27324](https://github.com/RocketChat/Rocket.Chat/pull/27324))

  Add RadioButton on UserDropDown to toggle between light and dark theme.

- Chore: Bump actions/upload-artifact from 2 to 3 ([#27109](https://github.com/RocketChat/Rocket.Chat/pull/27109) by [@rettinghaus](https://github.com/rettinghaus))

  Bump actions/upload-artifact from 2 to 3 (no changes in behavior expected)

- Chore: bumping apps engine version ([#27414](https://github.com/RocketChat/Rocket.Chat/pull/27414))

- Chore: change apps-engine version ([#27326](https://github.com/RocketChat/Rocket.Chat/pull/27326))

- Chore: Convert chat history react ([#27302](https://github.com/RocketChat/Rocket.Chat/pull/27302))

- Chore: Convert client/views/directory/hooks to ts ([#26936](https://github.com/RocketChat/Rocket.Chat/pull/26936))

- Chore: Convert client/views/directory/RoomTags to ts ([#26937](https://github.com/RocketChat/Rocket.Chat/pull/26937))

- Chore: Convert omni libs to typescript  ([#27205](https://github.com/RocketChat/Rocket.Chat/pull/27205))

- Chore: Converting game center to typescript ([#26915](https://github.com/RocketChat/Rocket.Chat/pull/26915))

- Chore: create AccountProfileForm endpoints ([#26415](https://github.com/RocketChat/Rocket.Chat/pull/26415))

  Created the '/v1/users.checkUsernameAvailability' and other endpoints for the `apps/meteor/client/views/account/profile/AccountProfileForm.tsx` file, and added Ajv validations.

- Chore: create MailerRoute endpoints ([#26742](https://github.com/RocketChat/Rocket.Chat/pull/26742))

  Created 'email-inbox.sendMail' endpoint for the `apps/meteor/client/views/admin/mailer/MailerRoute.tsx` file.

- Chore: Create new endpoint for test webhooks and deprecate meteor method ([#27160](https://github.com/RocketChat/Rocket.Chat/pull/27160))

- Chore: Create unique index for `E2EKey` field ([#27301](https://github.com/RocketChat/Rocket.Chat/pull/27301))

- Chore: CreateTeamModal Refactor ([#27027](https://github.com/RocketChat/Rocket.Chat/pull/27027))

  Jira Issue: [UFR-36]


  - Replace `useForm`

  - Improve UI validations on Modal

  - Add ToastBar message on creating a team

- Chore: Cursor pointer to all the action buttons ([#24440](https://github.com/RocketChat/Rocket.Chat/pull/24440) by [@sidmohanty11](https://github.com/sidmohanty11))

  https://user-images.githubusercontent.com/73601258/152863890-88035cbb-ba14-45c4-92ca-22ab4f566281.mp4

- Chore: deprecate refreshClients methods ([#26956](https://github.com/RocketChat/Rocket.Chat/pull/26956))

  Created the 'assets.refreshClients' endpoint for the `apps/meteor/client/views/admin/settings/groups/AssetsGroupPage.tsx` file.

- Chore: Deprecation warning on 'typing' stream event. ([#27299](https://github.com/RocketChat/Rocket.Chat/pull/27299))

- Chore: docs grammar fix ([#26894](https://github.com/RocketChat/Rocket.Chat/pull/26894) by [@tusharxoxoxo](https://github.com/tusharxoxoxo))

- Chore: Enable PR Title Checker for forks ([#27144](https://github.com/RocketChat/Rocket.Chat/pull/27144))

- Chore: Fix grammatical typos in release.md ([#21297](https://github.com/RocketChat/Rocket.Chat/pull/21297) by [@sumukhah](https://github.com/sumukhah))

- Chore: Fix missing license for forks ([#27258](https://github.com/RocketChat/Rocket.Chat/pull/27258))

- Chore: Fix typo in pa-in.js ([#26717](https://github.com/RocketChat/Rocket.Chat/pull/26717) by [@eltociear](https://github.com/eltociear))

- Chore: Fixed typo in a comment ([#27316](https://github.com/RocketChat/Rocket.Chat/pull/27316) by [@xareyli](https://github.com/xareyli))

- Chore: Improve configurations related to Typescript in Livechat ([#27232](https://github.com/RocketChat/Rocket.Chat/pull/27232))

- Chore: Make it easier to run micro services ([#27223](https://github.com/RocketChat/Rocket.Chat/pull/27223))

  You can now run a microservices environment with `yarn turbo run ms`

- Chore: Migrate EE LivechatRooms model to typescript ([#27046](https://github.com/RocketChat/Rocket.Chat/pull/27046))

- Chore: New Password field is confusing ([#20338](https://github.com/RocketChat/Rocket.Chat/pull/20338) by [@im-adithya](https://github.com/im-adithya))

- Chore: README.md ([#21974](https://github.com/RocketChat/Rocket.Chat/pull/21974) by [@satishp962](https://github.com/satishp962))

- Chore: Refactor LeaveTeam to Typescript ([#27197](https://github.com/RocketChat/Rocket.Chat/pull/27197))

  Additionally, it fixes:

  - Users would be able to select team channels that they want to leave while leaving the team.

  - Users would now automatically leave from team channels he/she selected.

  BEFORE



  https://user-images.githubusercontent.com/55157259/116005794-24205980-a626-11eb-888e-59e42ca21f9a.mp4





  BEFORE

  https://user-images.githubusercontent.com/55157259/115970150-4babef00-a55e-11eb-97c9-45683ac16cc1.mp4

  AFTER

  https://user-images.githubusercontent.com/55157259/116005344-21bd0000-a624-11eb-8e58-a956579a08b4.mp4


  AFTER

  https://user-images.githubusercontent.com/55157259/115970155-5070a300-a55e-11eb-877f-862dd9a974d7.mp4

- Chore: remove auto label action ([#27192](https://github.com/RocketChat/Rocket.Chat/pull/27192))

- Chore: Remove blank owner field from rooms  ([#21766](https://github.com/RocketChat/Rocket.Chat/pull/21766) by [@Kartik18g](https://github.com/Kartik18g))

- Chore: Remove js-preventer Action ([#27195](https://github.com/RocketChat/Rocket.Chat/pull/27195))

- Chore: Remove role requirement to use change streams ([#27281](https://github.com/RocketChat/Rocket.Chat/pull/27281))

  We used to require the `clusterMonitor` role to be able to use Change Streams because we performed a `serverStatus` command, to be able to check if the requirements for change streams are met (like using wired tiger for example). But since our minimum MongoDB supported version is now 4.2, and MMAPv1 [was removed on this version](https://www.mongodb.com/docs/v4.2/core/storage-engines/), there is no need to check that.

  The new approach is just try to use change streams, if it fails for any reason, fallback to oplog.

  If oplog fails as well, we're now halting the process, since it wasn't able to establish a connection for reading real time data, something that is crucial for the application. An additional check was added to make sure `$MONGO_OPLOG_URL` is pointing to the `local` database.

- Chore: Remove secrets.RC_TURBO_GH_TOKEN dep from build ([#27176](https://github.com/RocketChat/Rocket.Chat/pull/27176))

- Chore: Remove SoundRow.js ([#27215](https://github.com/RocketChat/Rocket.Chat/pull/27215))

- Chore: Remove turborepo if env is not set ([#27199](https://github.com/RocketChat/Rocket.Chat/pull/27199))

- Chore: Remove unused css ([#27289](https://github.com/RocketChat/Rocket.Chat/pull/27289))

- Chore: removing useEndpointData from license api ([#26634](https://github.com/RocketChat/Rocket.Chat/pull/26634))

  The deprecated hook `useEndpointData` was removed and changed to `useMethod` + `useQuery`separated in a hook.

  In `useQuery` options we added an option to keep the cache as `Infinity` until the queries are invalidated or the page refreshes, also the query keys were changed to consolidate the keys and manage the cache in the best way possible to avoid unnecessary API calls.

  In settings changed or user action that impact the License status was added a method to invalidate the cache for license query keys

  E.g: `queryClient.invalidateQueries(['licenses']);`

- Chore: Replace all saveUserPreferences method calls ([#26187](https://github.com/RocketChat/Rocket.Chat/pull/26187))

- Chore: Restrict `ChatMessages` API - Phase 1 ([#27191](https://github.com/RocketChat/Rocket.Chat/pull/27191))

  It prepares `ChatMessages` to be splitted into smaller components to handle the interaction of a list of messages and the message composer.

- Chore: Rewrite AutoCompleteDepartment to TypeScript ([#27198](https://github.com/RocketChat/Rocket.Chat/pull/27198))

  Department field inside of current chats is one of the places who uses AutoCompleteDeparment:
  ![image](https://user-images.githubusercontent.com/17487063/200659774-9db7b19d-1e5f-471b-8b7d-540ef3aa59fb.png)

- Chore: Rewrite the label/description of the Push_request_content_from_server setting ([#27136](https://github.com/RocketChat/Rocket.Chat/pull/27136) by [@nmagedman](https://github.com/nmagedman))

  Documentation: Clarify the meaning/effect of the setting Push_request_content_from_server ("Fetch full message content from the server on receipt"), which can lead to unexpected "You have a new message" notifications

- Chore: Show better error logs ([#27156](https://github.com/RocketChat/Rocket.Chat/pull/27156))

- Chore: subscriptions.read accepts both "roomId" and "rid" as payload ([#20312](https://github.com/RocketChat/Rocket.Chat/pull/20312) by [@lucassartor](https://github.com/lucassartor))

  Adding `roomId` as another option of payload in the `subscriptions.read` endpoint besides from `rid`.

- Chore: Test for import  ([#26871](https://github.com/RocketChat/Rocket.Chat/pull/26871) by [@weslley543](https://github.com/weslley543))

- Chore: Update Apps-Engine to latest ([#27433](https://github.com/RocketChat/Rocket.Chat/pull/27433))

- Chore: Update badge tokens ([#27363](https://github.com/RocketChat/Rocket.Chat/pull/27363))

- Chore: Update dark theme tokens ([#27386](https://github.com/RocketChat/Rocket.Chat/pull/27386))

  Update dark theme tokens:

  - surface-tint

  - button-background-secondary-disabled

  - button-background-secondary-danger-disabled

  - all status-background

  - all status-font

- Chore: Update tokens ([#27408](https://github.com/RocketChat/Rocket.Chat/pull/27408))

  Add/update tokens on light and dark palette:

  - update stroke-extra-light color

  - add status-warning-2

  - add status-service-3

  - add font-pure-white

  - add font-pure-black

- Chore: Updates rocket.cat's logo to match colors of our new logo ([#27314](https://github.com/RocketChat/Rocket.Chat/pull/27314))

- Chore: UserAvatar wrapper missing key in RoomForeword ([#27300](https://github.com/RocketChat/Rocket.Chat/pull/27300))

- Chore(deps): Bump felixmosh/turborepo-gh-artifacts from 1 to 2 ([#27170](https://github.com/RocketChat/Rocket.Chat/pull/27170) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- i18n: Language update from LingoHub 🤖 on 2022-10-24Z ([#27127](https://github.com/RocketChat/Rocket.Chat/pull/27127))

- i18n: Language update from LingoHub 🤖 on 2022-10-31Z ([#27150](https://github.com/RocketChat/Rocket.Chat/pull/27150))

- i18n: Language update from LingoHub 🤖 on 2022-11-07Z ([#27202](https://github.com/RocketChat/Rocket.Chat/pull/27202))

- i18n: Language update from LingoHub 🤖 on 2022-11-14Z ([#27255](https://github.com/RocketChat/Rocket.Chat/pull/27255))

- i18n: Language update from LingoHub 🤖 on 2022-11-21Z ([#27306](https://github.com/RocketChat/Rocket.Chat/pull/27306))

- i18n: Language update from LingoHub 🤖 on 2022-11-28Z ([#27375](https://github.com/RocketChat/Rocket.Chat/pull/27375))

- i18n: Language update from LingoHub 🤖 on 2022-11-29Z ([#27410](https://github.com/RocketChat/Rocket.Chat/pull/27410))

- Merge master into develop & Set version to 5.4.0-develop ([#27162](https://github.com/RocketChat/Rocket.Chat/pull/27162))

- Regression: Admin menu apps option not working ([#27422](https://github.com/RocketChat/Rocket.Chat/pull/27422))

  Solved a bug caused by the RC production build steps breaking the flow router triggersEnter event that did some rerouting for marketplace. Removed the cited function from the routes.tsx file, and now the rerouting is done directly inside the AppsRoute file.
  Demo gif:
  ![apps_rerouting_issue](https://user-images.githubusercontent.com/43561537/205097014-644be3fd-913e-48d6-8e2b-c082bd8f80cf.gif)

- Regression: Bad words Filtering not working on new Message Parser ([#27368](https://github.com/RocketChat/Rocket.Chat/pull/27368) by [@xareyli](https://github.com/xareyli))

  Was
  ![forGH](https://user-images.githubusercontent.com/118266546/204087809-fca6152b-63db-4873-88b8-d86aeb324531.png)

  Now
  ![forGH2](https://user-images.githubusercontent.com/118266546/204087822-e3273127-a4f0-4a45-a73e-910eb48c9b6f.png)

- Regression: Custom fields form not showing in user profile nor admin ([#27244](https://github.com/RocketChat/Rocket.Chat/pull/27244))

- Regression: Elevation and components z-index fixes ([#27421](https://github.com/RocketChat/Rocket.Chat/pull/27421))

- Regression: fix contact chat history borders ([#27319](https://github.com/RocketChat/Rocket.Chat/pull/27319))

- Regression: Fix custom oauth undefined clientConfig ([#27320](https://github.com/RocketChat/Rocket.Chat/pull/27320))

- Regression: Fix issues with ContactHistoryItem ([#27406](https://github.com/RocketChat/Rocket.Chat/pull/27406))

- Regression: Fix sidebar token highlighted usage ([#27334](https://github.com/RocketChat/Rocket.Chat/pull/27334))

- Regression: fix small issues before release ([#27443](https://github.com/RocketChat/Rocket.Chat/pull/27443))

- Regression: Login and Registration UI Tweaks ([#27411](https://github.com/RocketChat/Rocket.Chat/pull/27411))

- Regression: message-box-editing-color ([#27420](https://github.com/RocketChat/Rocket.Chat/pull/27420))

- Regression: Old threads not opening ([#27384](https://github.com/RocketChat/Rocket.Chat/pull/27384))

- Regression: Quoting Issue ([#27369](https://github.com/RocketChat/Rocket.Chat/pull/27369) by [@henit-chobisa](https://github.com/henit-chobisa))

- Regression: Remove actions from VideoConf Message Block ([#27344](https://github.com/RocketChat/Rocket.Chat/pull/27344))

- Regression: Restore fuselage-ui-kit version ([#27331](https://github.com/RocketChat/Rocket.Chat/pull/27331))

- Regression: Team name validation on Create Team Modal ([#27345](https://github.com/RocketChat/Rocket.Chat/pull/27345))

- Regression: Update VideoConf components colors ([#27365](https://github.com/RocketChat/Rocket.Chat/pull/27365))

- Regression: Update VideoConfListItem Color Tokens ([#27402](https://github.com/RocketChat/Rocket.Chat/pull/27402))

- Regression: videoconf block showing a zero when no user has joined the call ([#27332](https://github.com/RocketChat/Rocket.Chat/pull/27332))

- Regression: VideoConf default info modal not showing meeting URL as a link ([#27382](https://github.com/RocketChat/Rocket.Chat/pull/27382))

  Before:
  ![image](https://user-images.githubusercontent.com/55164754/204304308-87f6e6d3-8411-4974-8628-d81fd9aa07e5.png)


  After:
  ![image](https://user-images.githubusercontent.com/55164754/204303619-6bc7b014-7b11-40a5-a1de-1530e76fff8b.png)

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@Darshilp326](https://github.com/Darshilp326)
- [@Himanshu664](https://github.com/Himanshu664)
- [@JoshMcCullough](https://github.com/JoshMcCullough)
- [@Kartik18g](https://github.com/Kartik18g)
- [@TBG-FR](https://github.com/TBG-FR)
- [@TedsCabin](https://github.com/TedsCabin)
- [@aKn1ghtOut](https://github.com/aKn1ghtOut)
- [@aswinidev](https://github.com/aswinidev)
- [@carlosrodrigues94](https://github.com/carlosrodrigues94)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@edward-raven](https://github.com/edward-raven)
- [@eltociear](https://github.com/eltociear)
- [@henit-chobisa](https://github.com/henit-chobisa)
- [@im-adithya](https://github.com/im-adithya)
- [@ivan1kazantsev](https://github.com/ivan1kazantsev)
- [@lucassartor](https://github.com/lucassartor)
- [@matheuslc](https://github.com/matheuslc)
- [@nmagedman](https://github.com/nmagedman)
- [@rettinghaus](https://github.com/rettinghaus)
- [@satishp962](https://github.com/satishp962)
- [@shrinish123](https://github.com/shrinish123)
- [@sidmohanty11](https://github.com/sidmohanty11)
- [@sumukhah](https://github.com/sumukhah)
- [@tusharxoxoxo](https://github.com/tusharxoxoxo)
- [@weslley543](https://github.com/weslley543)
- [@xareyli](https://github.com/xareyli)
- [@yasemincidem](https://github.com/yasemincidem)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@LucianoPierdona](https://github.com/LucianoPierdona)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@casalsgh](https://github.com/casalsgh)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@hugocostadev](https://github.com/hugocostadev)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rique223](https://github.com/rique223)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tapiarafael](https://github.com/tapiarafael)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 5.3.6
`2023-01-24  ·  1 🚀  ·  1 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🚀 Improvements


- Emoji picker for large amount of custom emojis ([#27745](https://github.com/RocketChat/Rocket.Chat/pull/27745))

### 🐛 Bug fixes


- Not all messages in chat conversations are available when forwarding between agents or departments. ([#27816](https://github.com/RocketChat/Rocket.Chat/pull/27816))

### 👩‍💻👨‍💻 Core Team 🤓

- [@filipemarins](https://github.com/filipemarins)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.3.5
`2022-12-02  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Fix watch db being started on Micro Services env ([#27435](https://github.com/RocketChat/Rocket.Chat/pull/27435))

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 5.3.4
`2022-11-29  ·  1 🐛  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Thread messages being included in the room history even though they are not displayed ([#27391](https://github.com/RocketChat/Rocket.Chat/pull/27391))

<details>
<summary>🔍 Minor changes</summary>


- Release 5.3.3 ([#27340](https://github.com/RocketChat/Rocket.Chat/pull/27340))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@dougfabris](https://github.com/dougfabris)
- [@ggazzo](https://github.com/ggazzo)

# 5.3.3
`2022-11-24  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 5.3.2
`2022-11-18  ·  2 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Replace regex not compatible with safari ([#27294](https://github.com/RocketChat/Rocket.Chat/pull/27294))

- Sidebar Room list extended preview not updating on new messages. ([#27259](https://github.com/RocketChat/Rocket.Chat/pull/27259))

### 👩‍💻👨‍💻 Core Team 🤓

- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)

# 5.3.1
`2022-11-14  ·  5 🐛  ·  1 🔍  ·  5 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- File upload receiving whole file to apply limits ([#27105](https://github.com/RocketChat/Rocket.Chat/pull/27105))

- Hide system messages setting not being respected. ([#27151](https://github.com/RocketChat/Rocket.Chat/pull/27151))

  There was a query missing the parameters in the client.

  Also added a few tests to help reduce the risk of this happening again.

- Multi instance error message ([#27243](https://github.com/RocketChat/Rocket.Chat/pull/27243))

- Next schedule check for Apps ([#27240](https://github.com/RocketChat/Rocket.Chat/pull/27240))

- User merge by e-mail on OAuth is case-sensitive ([#27167](https://github.com/RocketChat/Rocket.Chat/pull/27167))

  - Ignore case when searching for a user by email.

<details>
<summary>🔍 Minor changes</summary>


- Chore: Check for Cloud client secret to check if workspace is registered ([#27229](https://github.com/RocketChat/Rocket.Chat/pull/27229))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@casalsgh](https://github.com/casalsgh)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.3.0
`2022-11-01  ·  3 🎉  ·  4 🚀  ·  13 🐛  ·  23 🔍  ·  23 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🎉 New features


- Add new endpoint 'livechat/room.saveInfo' & deprecate 'livechat:saveInfo' meteor method ([#26789](https://github.com/RocketChat/Rocket.Chat/pull/26789))

- Health check for data stream ([#27026](https://github.com/RocketChat/Rocket.Chat/pull/27026))

- Matrix federation events coverage expansion (adding support for 3 extra events) ([#26859](https://github.com/RocketChat/Rocket.Chat/pull/26859))

  FED-17
  FED-25
  FED-27
  FED-28
  FED-30
  The goal of this PR is to add support for more events on Matrix Federation feature. The new supported events are:


  - Mentions

  - User avatar sync

  - Quotes

### 🚀 Improvements


- Automatically open call info contextual bar when voip room is opened ([#26963](https://github.com/RocketChat/Rocket.Chat/pull/26963))

  This pull request adds the logic necessary to automatically open the call information contextual bar when entering a voip room. This mirrors the behavior we already have for livechat rooms.

  **Before:**
  ![before-voip-480p-speed](https://user-images.githubusercontent.com/6494543/192610275-a81ab19e-2b60-4466-9e04-81b2e938afda.gif)

  **After:**
  ![after-voip-480p-speed](https://user-images.githubusercontent.com/6494543/192610356-896ccd48-8c26-4fb9-8fb4-f792ab63e6d5.gif)

- Better /health response when service not healthy ([#27091](https://github.com/RocketChat/Rocket.Chat/pull/27091))

  Not healthy services will send a HTTP 500 response when not healthy.

- Change status/price badge to fuselage tag ([#27044](https://github.com/RocketChat/Rocket.Chat/pull/27044))

  ## Jira task: [MKP-131](https://rocketchat.atlassian.net/browse/MKP-131?atlOrigin=eyJpIjoiODRjOTk4OGYyZDAwNDIzNmI5N2EyZGRhNTUxOGY2NGEiLCJwIjoiaiJ9)
  Changed the custom component that showed prices and statuses to a fuselage Tag component for maintainability reasons since after this PR every general design change to the tag component will be automatically reflected in the marketplace UI.
  Demo image (App List):
  ![image](https://user-images.githubusercontent.com/43561537/194942430-ba4153f1-2315-4117-85e6-01832cc09d91.png)

  Demo Image (App price):
  ![image](https://user-images.githubusercontent.com/43561537/194942498-5ff64a27-7232-47b8-a686-2fda2289e491.png)

- Respect convert ascii to emoji preference for new message template ([#27038](https://github.com/RocketChat/Rocket.Chat/pull/27038))

### 🐛 Bug fixes


- Actionable messages are now sent to integrations webhook ([#27052](https://github.com/RocketChat/Rocket.Chat/pull/27052))

  Actionable messages, with buttons and similar, (saved as blocks internally) were not being sent to external integrations, so CRMs and the like had no visibility on what was the actionable message sent, this PR adds a yaml version of the actions, as well as a proper json object with the same data on the webhook output, so that our clients can have more visibility in their process

- check if message block has item to show message body ([#27040](https://github.com/RocketChat/Rocket.Chat/pull/27040))

- CSS vars usage ([#27107](https://github.com/RocketChat/Rocket.Chat/pull/27107))

- Email inbox memory leak on connection failure ([#26850](https://github.com/RocketChat/Rocket.Chat/pull/26850))

  - Properly removing event listeners on re-connection.
   - Attachments handling changed from beforeMessageSent to afterMessageSent, as the id of the message was needed, now rocket.cat will send the "Send Attachment To Email" button.
   - Self-disable email inbox when reaching max re-connection attempts

- Livechat CurrentChats infinity re-rendering ([#27076](https://github.com/RocketChat/Rocket.Chat/pull/27076))

- Microphone icon alignment issue (# 27073) ([#27123](https://github.com/RocketChat/Rocket.Chat/pull/27123) by [@mani-rsg](https://github.com/mani-rsg))

  Aligned microphone icon to its respective position on  screen widths <= 500 (mobile screens)

  <img width="360" alt="image" src="https://user-images.githubusercontent.com/72298612/197343254-1506125f-06f4-43d1-b42b-e36071862254.png">
  <img width="439" alt="image" src="https://user-images.githubusercontent.com/72298612/197343268-d7f0e294-4b76-4e5b-9874-0b41586b0487.png">

- On hold reactivity for Omnichannel rooms ([#27013](https://github.com/RocketChat/Rocket.Chat/pull/27013))

  - Fix instabilities from room when changed from on-hold to resume

  - Fix gray messages when resume from on-hold

- Preview message not showing when reply direct message ([#27050](https://github.com/RocketChat/Rocket.Chat/pull/27050))

- Remove contact mananger always to support old servers ([#27053](https://github.com/RocketChat/Rocket.Chat/pull/27053))

- Remove voip extension when agent is removed or deactivated ([#26960](https://github.com/RocketChat/Rocket.Chat/pull/26960))

- starting conferences with mic and cam on their default states do not sync the state with the provider ([#26966](https://github.com/RocketChat/Rocket.Chat/pull/26966))

  Task: [VC-3]

- Uncaught error by listening stream-notify-room without subscription ([#27020](https://github.com/RocketChat/Rocket.Chat/pull/27020))

  fix this:
  <img width="458" alt="image" src="https://user-images.githubusercontent.com/17487063/194358060-7d0fb534-9d04-4af8-abd9-fa2bd79b66c0.png">

- Warning about livechat/inquiries.queuedForUser ([#27086](https://github.com/RocketChat/Rocket.Chat/pull/27086))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Apply correct fuselage color tokens ([#27089](https://github.com/RocketChat/Rocket.Chat/pull/27089))

- Chore: Bump Apps-Engine version ([#27059](https://github.com/RocketChat/Rocket.Chat/pull/27059))

- Chore: bump fuselage packages ([#27157](https://github.com/RocketChat/Rocket.Chat/pull/27157))

- Chore: bump fuselage packages ([#27122](https://github.com/RocketChat/Rocket.Chat/pull/27122))

- Chore: Email Inbox Sanitization ([#26796](https://github.com/RocketChat/Rocket.Chat/pull/26796))

  Jira Issue [UFR-3]


  - Rewrite Email Inbox to typescript

  - Replace `useForm`

  - Fix: return an error if there are no email inboxes in `email-inbox` endpoint
  **documentation update**: https://github.com/RocketChat/developer-docs/pull/132

  - Add e2e test cases for creating email inboxes and deleting email inboxes

- Chore: Implement short description for marketplace apps ([#27030](https://github.com/RocketChat/Rocket.Chat/pull/27030))

  ## Jira task: [MKP-126](https://rocketchat.atlassian.net/browse/MKP-126)
  Implemented the shortDescription field in the marketplace app details header. Now apps have either a shorter description or nothing, in case it doesn't have a shortDescription registered, in their headers description section.
  Demo image:
  ![image](https://user-images.githubusercontent.com/43561537/194640492-9942f6d9-66ad-4df9-97e8-98c7d51a724c.png)

- Chore: Refactor AppLogs to TS ([#26938](https://github.com/RocketChat/Rocket.Chat/pull/26938))

  Rewrote the AppLogs component to TS. Also, improved some error handling logic.

- Chore: Remove default value from custom home content setting ([#26995](https://github.com/RocketChat/Rocket.Chat/pull/26995))

  Remove content from `Custom body` setting so that new workspaces don't have initial unstyled HTML in their homepages.

- Chore: remove excess space from html preview ([#27043](https://github.com/RocketChat/Rocket.Chat/pull/27043))

- Chore: Remove Unused CSS ([#27012](https://github.com/RocketChat/Rocket.Chat/pull/27012))

- Chore: Switch deprecated fields for projection ([#27025](https://github.com/RocketChat/Rocket.Chat/pull/27025))

- Chore: Tests for EE dashboards ([#26974](https://github.com/RocketChat/Rocket.Chat/pull/26974))

- Chore: Update Image and link previews ([#27019](https://github.com/RocketChat/Rocket.Chat/pull/27019))

  - Add message generic cover image preview component to OEmbed Links

  - Add new functionalities to URL Image preview, like click to open preview and arrows to move between images in the current chat

  - Design changes to keep the original aspect ratio of the image to prevent loss of important image pieces of information

  - Add fallback to common issues related to meta tags like `og:image` and others

- Chore: Use a single notification listener for all videoconf messages ([#26682](https://github.com/RocketChat/Rocket.Chat/pull/26682))

  Task: [VC-1]

- Chore: UserCard loader tweaks ([#27068](https://github.com/RocketChat/Rocket.Chat/pull/27068))

  ### before
  ![Kapture 2022-10-14 at 12 47 43](https://user-images.githubusercontent.com/27704687/195888045-6fd900ab-feb1-4dc7-924c-a0fd7634eab6.gif)


  ### after
  ![Kapture 2022-10-14 at 12 45 30](https://user-images.githubusercontent.com/27704687/195887641-652f388b-cf9f-413d-9c07-c0df9a3f7287.gif)

- i18n: Language update from LingoHub 🤖 on 2022-10-03Z ([#26992](https://github.com/RocketChat/Rocket.Chat/pull/26992))

- i18n: Language update from LingoHub 🤖 on 2022-10-10Z ([#27035](https://github.com/RocketChat/Rocket.Chat/pull/27035))

- i18n: Language update from LingoHub 🤖 on 2022-10-17Z ([#27082](https://github.com/RocketChat/Rocket.Chat/pull/27082))

- Merge master into develop & Set version to 5.3.0-develop ([#27067](https://github.com/RocketChat/Rocket.Chat/pull/27067))

- Regression: Quote colors ([#27110](https://github.com/RocketChat/Rocket.Chat/pull/27110))

  Before
  ![image](https://user-images.githubusercontent.com/40830821/196947705-f1b2edf9-7341-4d2a-b8e8-4e3720ab7289.png)


  After
  ![image](https://user-images.githubusercontent.com/40830821/196947512-1267f992-11c7-4ff4-b7a2-9f0b3534f69d.png)

- Regression: Remove margin-bottom inside UserCard actions ([#27100](https://github.com/RocketChat/Rocket.Chat/pull/27100))

- Regression: Toolbox Divider Color ([#27116](https://github.com/RocketChat/Rocket.Chat/pull/27116))

  ![image](https://user-images.githubusercontent.com/27704687/197018407-d591d6bc-e390-4bcd-9b6a-0bf0a1420bc2.png)

- Regression: Unify `isLastDocDelayed` logic ([#27120](https://github.com/RocketChat/Rocket.Chat/pull/27120))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@mani-rsg](https://github.com/mani-rsg)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@casalsgh](https://github.com/casalsgh)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@hugocostadev](https://github.com/hugocostadev)
- [@juliajforesti](https://github.com/juliajforesti)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rique223](https://github.com/rique223)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 5.2.2
`2023-01-24  ·  1 🚀  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🚀 Improvements


- Emoji picker for large amount of custom emojis ([#27745](https://github.com/RocketChat/Rocket.Chat/pull/27745))

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.2.0
`2022-10-13  ·  5 🎉  ·  13 🚀  ·  19 🐛  ·  62 🔍  ·  28 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🎉 New features


- Add Markup to QuoteAttachment ([#26751](https://github.com/RocketChat/Rocket.Chat/pull/26751))

- Get moderators, owners and leaders from room scope via apps-engine ([#26674](https://github.com/RocketChat/Rocket.Chat/pull/26674))

- Matrix Federation events coverage expansion (support for 5 more events) ([#26705](https://github.com/RocketChat/Rocket.Chat/pull/26705))

  The goal of this PR is to add support for more events on Matrix Federation feature. The new supported events are:


  - Edit Messages;

  - Delete Messages

  - File Upload (including video and audio/voice messages);

  - Send emojis on messages;

  - Reactions.

- Move administration links to an exclusive kebab menu ([#26867](https://github.com/RocketChat/Rocket.Chat/pull/26867))

  Move administration links to an exclusive kebab menu.

  <img width="271" alt="Screen Shot 2022-09-14 at 02 59 03" src="https://user-images.githubusercontent.com/9275105/190071665-b4f862d2-bd35-4916-9688-318971c70ab8.png">

- Sections layout and featured apps for marketplace ([#26514](https://github.com/RocketChat/Rocket.Chat/pull/26514))

  ### [MKP??+   - Featured Apps](https://app.clickup.com/t/2t1w9x3)
  Implemented a new layout for marketplace's apps list page. Now the page has an All apps section and a "featured apps" section in which pre-selected and pre-categorized apps are dynamically shown on the top area of the page to make them stand out.
  Demo gif:
  ![featured_apps](https://user-images.githubusercontent.com/43561537/184385727-4f44c1d5-d7f7-43bf-a93d-2bc582bd3159.gif)

  ClickUp Task link: https://app.clickup.com/t/2t1w9x3

### 🚀 Improvements


- Allow delete attachment description on message edit ([#26673](https://github.com/RocketChat/Rocket.Chat/pull/26673))

- Better descriptions for VoIP Settings ([#26877](https://github.com/RocketChat/Rocket.Chat/pull/26877))

- Changed dial pad appearance to match original design ([#26863](https://github.com/RocketChat/Rocket.Chat/pull/26863))

  Before:
  ![Screen Shot 2022-09-13 at 15 00 34](https://user-images.githubusercontent.com/6494543/189976766-6d085795-a832-4189-898b-4bd631cb4309.png)

  After:
  ![Screen Shot 2022-09-13 at 14 59 23](https://user-images.githubusercontent.com/6494543/189976804-c419ac33-6a90-464e-8792-feb0d0ae33e5.png)

- Include `syncAvatars` on `ldap.syncNow` ([#26824](https://github.com/RocketChat/Rocket.Chat/pull/26824))

  This PR includes a new call for the method `syncAvatars` when `ldap.syncNow` is called

- OTR Message ([#24297](https://github.com/RocketChat/Rocket.Chat/pull/24297))

- Results of user auto complete ([#26687](https://github.com/RocketChat/Rocket.Chat/pull/26687))

- Rounded video attachment ([#26832](https://github.com/RocketChat/Rocket.Chat/pull/26832))

- Setting for login email notifications ([#26831](https://github.com/RocketChat/Rocket.Chat/pull/26831))

- System messages' consistency ([#26130](https://github.com/RocketChat/Rocket.Chat/pull/26130))

- Updating voip tooltips and icons ([#26834](https://github.com/RocketChat/Rocket.Chat/pull/26834))

  ### This PR includes the following tooltip expression changes:
  Call toggle button

  * Enabled -> Turn off answer calls

  * Disabled -> Turn on answer calls

  * Signaling connection disconnected -> Waiting for server connection


  Chat toggle button

  * Available -> Turn off answer chats

  * Not available -> Turn on answer chats

  Hold button

  * Hold call -> Hold call / Resume call

  Mute button

  * Mute -> Turn on microphone / Turn off microphone

  ### Also includes the following icon changes:

  Old:
  ![new-1](https://user-images.githubusercontent.com/6494543/189218303-144671cb-6533-46a0-be18-52d62b3701d3.png)
  ![new-2](https://user-images.githubusercontent.com/6494543/189218307-8f24797b-bef6-4d8a-9e25-98e96fa59155.png)
  ![new-3](https://user-images.githubusercontent.com/6494543/189218309-05a836a3-5c17-4370-9cc6-fd7a6da3d8c2.png)


  New:

  ![old-1](https://user-images.githubusercontent.com/6494543/189217735-3d9cde83-8e54-421e-b57a-ac9bda748416.png)
  ![old-2](https://user-images.githubusercontent.com/6494543/189217738-d4bb2bfb-ddfd-4830-a2e8-a9937e93826a.png)
  ![old-3](https://user-images.githubusercontent.com/6494543/189217740-988295bf-9112-4cea-93da-402ea7e82247.png)

- Use cached EE Cloud license on startup ([#26987](https://github.com/RocketChat/Rocket.Chat/pull/26987))

- VideoConference Messages UI ([#26548](https://github.com/RocketChat/Rocket.Chat/pull/26548))

  <img width='300px' src='https://user-images.githubusercontent.com/27704687/186758472-f15837be-0a24-470f-8dec-46422da54c6b.png' />

  <img width='300px' src='https://user-images.githubusercontent.com/27704687/186758582-b6d55be9-e555-4a5d-ab21-9322042fbd5a.png' />

  <img width='300px' src='https://user-images.githubusercontent.com/27704687/186758710-19f6bd5f-e0b4-4a6a-aea8-80a1c25f0ce7.png' />

- VideoConference Messages UI (#26548)" ([#26961](https://github.com/RocketChat/Rocket.Chat/pull/26961))

### 🐛 Bug fixes


- **Livechat:** Unread messages badge ([#26843](https://github.com/RocketChat/Rocket.Chat/pull/26843))

  OC-169

  Even if the page was reopening, Livechat will inform unread messages

- Adjusted livechat fallbacks to take null values into account ([#26909](https://github.com/RocketChat/Rocket.Chat/pull/26909))

- Admin sidebar navigation ([#26958](https://github.com/RocketChat/Rocket.Chat/pull/26958))

  ## [MKP-125](https://rocketchat.atlassian.net/browse/MKP-125?atlOrigin=eyJpIjoiMThlMTIwYmFkZWI5NDBlYjhlMWI3YTc1ZDliYTY3NDUiLCJwIjoiaiJ9)
  Fix the behavior of the admin sidebar, it didn't activate its options properly on pages that had sub-routes.
  Demo gif:
  ![sidebar-bug](https://user-images.githubusercontent.com/43561537/192585542-ddd8fd37-e833-4960-ae67-fb408595c7ba.gif)

- Asset settings description not showing on admin ([#26755](https://github.com/RocketChat/Rocket.Chat/pull/26755))

- Check admin setting for whether to display roles or not ([#26601](https://github.com/RocketChat/Rocket.Chat/pull/26601))

- Ephemeral messages not respecting katex setting ([#26812](https://github.com/RocketChat/Rocket.Chat/pull/26812))

- Expanded thread behind sidebar on small screens ([#26852](https://github.com/RocketChat/Rocket.Chat/pull/26852))

  Sidebar overlapping expanded threads in window sizes between **1135px and 780px** and  but the expanded threads should be limited to sidebar size and should not go through it

  ### **Actual behavior**
  ![image](https://user-images.githubusercontent.com/20212776/189692618-b1c0ebdf-36e1-49cb-9179-29b842260a18.png)


  ### **Expected behavior**
  ![image](https://user-images.githubusercontent.com/20212776/189692714-0cce9947-8f72-48af-9a81-04cc521a9833.png)

- Fix broken legacy message view ([#26819](https://github.com/RocketChat/Rocket.Chat/pull/26819))

  Fixed `messagesHistory` function, it was filtering messages only with existing threads.

- Incorrect filter on contact history search ([#26813](https://github.com/RocketChat/Rocket.Chat/pull/26813) by [@neo-clon](https://github.com/neo-clon))

- Livechat trigger messages covering all the website ([#26776](https://github.com/RocketChat/Rocket.Chat/pull/26776))

- Menu options margin spacing ([#26775](https://github.com/RocketChat/Rocket.Chat/pull/26775))

  - Change margin spacing from 16-4px to 12-8px

  | before | after |
  |--------|-------|
  | ![before](https://user-images.githubusercontent.com/48109548/187940409-903eede8-9ade-448d-9211-0e004ccd0ff2.png) | ![after](https://user-images.githubusercontent.com/48109548/187940513-3189ca2a-5f18-4e39-93bb-5843f13fce27.png) |

- Message sequential after message thread preview ([#26900](https://github.com/RocketChat/Rocket.Chat/pull/26900))

- MIME Type fallback for .mov File Extensions ([#26921](https://github.com/RocketChat/Rocket.Chat/pull/26921))

  Some browsers don't support the MIME type for QuickTime video encoder (.mov), so we had to create a fallback to 'video/mp4'. There are other fallbacks for other browsers, but this is the only one we need for now.

  The fallback func was used in the MediaPreview and VideoAttachments components

- Old rooms without the associated unit will not be displayed on the current chats ([#26685](https://github.com/RocketChat/Rocket.Chat/pull/26685))

- Restore current chats  default table order ([#26808](https://github.com/RocketChat/Rocket.Chat/pull/26808))

- Sign in with Apple on mobile ([#26827](https://github.com/RocketChat/Rocket.Chat/pull/26827))

  Our mobile app uses a different method to log in that was removed at #24879 .

  You can also make it available only on mobile:
  ![image](https://user-images.githubusercontent.com/8591547/188752062-bef03f01-d995-4422-8a24-984ebed49ce2.png)

  Removes the "Sign in with Apple" text from the log in button. This was something we thought were required by Apple, but it is actually allowed to have just the logo as all others OAuth we have. Source: https://developer.apple.com/design/human-interface-guidelines/technologies/sign-in-with-apple/buttons/#creating-a-custom-sign-in-with-apple-button

- Typo on new homepage ([#26768](https://github.com/RocketChat/Rocket.Chat/pull/26768))

- Unable to send native video recording to Whatsapp ([#26669](https://github.com/RocketChat/Rocket.Chat/pull/26669))

- Upload fails when using WebDav as file storage ([#26711](https://github.com/RocketChat/Rocket.Chat/pull/26711))

<details>
<summary>🔍 Minor changes</summary>


- Bump actions/cache from 2 to 3.0.1 ([#25003](https://github.com/RocketChat/Rocket.Chat/pull/25003) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: `improve/media-recorder` ([#26426](https://github.com/RocketChat/Rocket.Chat/pull/26426))

- Chore: `refactor/room` ([#26675](https://github.com/RocketChat/Rocket.Chat/pull/26675))

  Replaces `room` Blaze template with React components.

- Chore: add aria hidden if modal is open ([#26826](https://github.com/RocketChat/Rocket.Chat/pull/26826))

- Chore: Add E2E tests to missing omnichannel endpoints ([#26730](https://github.com/RocketChat/Rocket.Chat/pull/26730))

- Chore: Add RocketChatDesktop function to open video calls when using Electron ([#26793](https://github.com/RocketChat/Rocket.Chat/pull/26793))

- Chore: Add tests to cover issue fixed in #26720 ([#26767](https://github.com/RocketChat/Rocket.Chat/pull/26767))

- Chore: break LDAP manager into smaller pieces to improve unit tests ([#26994](https://github.com/RocketChat/Rocket.Chat/pull/26994))

- Chore: Bump Apps-Engine version ([#27059](https://github.com/RocketChat/Rocket.Chat/pull/27059))

- Chore: Bump fuselage dependencies and implement new tabs variant in marketplace ([#26876](https://github.com/RocketChat/Rocket.Chat/pull/26876))

  Bumped the necessary dependencies of fuselage and implemented the new tabs component underline variant.
  Demo image:
  ![image](https://user-images.githubusercontent.com/43561537/190252796-cd4ad872-90e6-413e-92cb-13c0354399da.png)

- Chore: Bump fuselage to latest ([#27042](https://github.com/RocketChat/Rocket.Chat/pull/27042))

- Chore: Bump vm2 to 3.9.11 ([#26940](https://github.com/RocketChat/Rocket.Chat/pull/26940))

- Chore: Change BundleChips component appearance ([#26686](https://github.com/RocketChat/Rocket.Chat/pull/26686))

  # [MKP-44](https://rocketchat.atlassian.net/browse/MKP-44?atlOrigin=eyJpIjoiOTBiNzQ4NzE1ZTJiNDBjMGE0NjQxNmQ2MWNkMTI4YjgiLCJwIjoiaiJ9)
  Changed the appearance of the marketplace app bundle chips (E.G.: The blue Enterprise tag in the images bellow).

  Demo image for app details page:
  ![image](https://user-images.githubusercontent.com/43561537/190232209-939d29f5-bcdb-4ce4-99d1-1b061d170ab0.png)

  Demo image for list view:
  ![image](https://user-images.githubusercontent.com/43561537/190232168-ab898d8a-6a73-4e34-9f47-a5af01bf29fc.png)

- Chore: Cleanup endpoint handlers ([#26749](https://github.com/RocketChat/Rocket.Chat/pull/26749))

- Chore: Configure Prettier for `@rocket.chat/livechat` ([#26846](https://github.com/RocketChat/Rocket.Chat/pull/26846))

- Chore: Convert current-chats to useQuery ([#26931](https://github.com/RocketChat/Rocket.Chat/pull/26931))

- Chore: Deprecate some omnichannel meteor methods which aren't getting used ([#26839](https://github.com/RocketChat/Rocket.Chat/pull/26839))

- Chore: first non-aggressive CSS removal ([#26714](https://github.com/RocketChat/Rocket.Chat/pull/26714))

- Chore: Fix API tests retry ([#26860](https://github.com/RocketChat/Rocket.Chat/pull/26860))

- Chore: fix regressions for omnichannel due room refactor ([#26912](https://github.com/RocketChat/Rocket.Chat/pull/26912))

- Chore: fix wrong `test.step` usage ([#26873](https://github.com/RocketChat/Rocket.Chat/pull/26873))

- Chore: Introduce `useQuery` as data source for the `Room` component ([#26855](https://github.com/RocketChat/Rocket.Chat/pull/26855))

- Chore: merge all functions using autorun x useSubscription pattern ([#26886](https://github.com/RocketChat/Rocket.Chat/pull/26886))

- Chore: Missing Also_send_thread_message_to_channel setting translation ([#26926](https://github.com/RocketChat/Rocket.Chat/pull/26926))

- Chore: Move Header to ui-client ([#26757](https://github.com/RocketChat/Rocket.Chat/pull/26757))

  <img width="1151" alt="Screen Shot 2022-08-30 at 23 15 18" src="https://user-images.githubusercontent.com/27704687/187577854-08a2c30d-0bd5-48c6-9302-55e28ade96cd.png">

- Chore: Move micro services to packages ([#26884](https://github.com/RocketChat/Rocket.Chat/pull/26884))

- Chore: Move Omnichannel  Room Footer to react ([#26864](https://github.com/RocketChat/Rocket.Chat/pull/26864))

- Chore: Move presence to package ([#25541](https://github.com/RocketChat/Rocket.Chat/pull/25541))

- Chore: Omnichannel endpoints to ts ([#26829](https://github.com/RocketChat/Rocket.Chat/pull/26829))

- Chore: Refactor message list context usage ([#26748](https://github.com/RocketChat/Rocket.Chat/pull/26748))

- Chore: Refactor omnichannel livechat tests ([#26929](https://github.com/RocketChat/Rocket.Chat/pull/26929))

- Chore: Rewrite apps WarningModal component to typescript ([#26845](https://github.com/RocketChat/Rocket.Chat/pull/26845))

  Translated the admin apps WarningModal component from Javascript to Typescript

- Chore: Test/improve reliability ([#26724](https://github.com/RocketChat/Rocket.Chat/pull/26724) by [@souzaramon](https://github.com/souzaramon))

- Chore: Tests for EE features ([#26939](https://github.com/RocketChat/Rocket.Chat/pull/26939))

- Chore: Update fuselage to next version. ([#26841](https://github.com/RocketChat/Rocket.Chat/pull/26841))

- Chore: Updating apps engine ([#26924](https://github.com/RocketChat/Rocket.Chat/pull/26924))

- Chore: Upgrading livechat's ui-kit package to latest version ([#26709](https://github.com/RocketChat/Rocket.Chat/pull/26709))

  This PR upgrades Livechat's UiKit package to the version 0.31.16. and adjusts the renderer to be compatible with said version.

- i18n: Language update from LingoHub 🤖 on 2022-08-29Z ([#26722](https://github.com/RocketChat/Rocket.Chat/pull/26722))

- i18n: Language update from LingoHub 🤖 on 2022-09-05Z ([#26805](https://github.com/RocketChat/Rocket.Chat/pull/26805))

- i18n: Language update from LingoHub 🤖 on 2022-09-12Z ([#26849](https://github.com/RocketChat/Rocket.Chat/pull/26849))

- i18n: Language update from LingoHub 🤖 on 2022-09-19Z ([#26896](https://github.com/RocketChat/Rocket.Chat/pull/26896))

- i18n: Language update from LingoHub 🤖 on 2022-09-26Z ([#26948](https://github.com/RocketChat/Rocket.Chat/pull/26948))

- Merge master into develop & Set version to 5.2.0-develop ([#26792](https://github.com/RocketChat/Rocket.Chat/pull/26792))

- Regression: Cannot edit messages in some environments. ([#27023](https://github.com/RocketChat/Rocket.Chat/pull/27023))

  An empty `$unset` object was being used and causes exceptions in some mongo versions.

- Regression: Composer not reactive when omnichannel room closed ([#26983](https://github.com/RocketChat/Rocket.Chat/pull/26983))

- Regression: Double Table Cell Causing extra padding on Current Chats ([#27008](https://github.com/RocketChat/Rocket.Chat/pull/27008))

- Regression: Event handler blocking mention links ([#26964](https://github.com/RocketChat/Rocket.Chat/pull/26964))

  Fixes mention links being irresponsive to clicks.
  Jira: [TC-55]

  [TC-55]: https://rocketchat.atlassian.net/browse/TC-55?atlOrigin=eyJpIjoiMmQ3ZmE0MWE2NGQwNDIzZThkMzc5NGNhMzU1MjExMGMiLCJwIjoiaiJ9

- Regression: Fix open room from current chats ([#26930](https://github.com/RocketChat/Rocket.Chat/pull/26930))

- Regression: Fixed takeInquiry method not displaying error messages on the client ([#26976](https://github.com/RocketChat/Rocket.Chat/pull/26976))

  This pull request brings back the toast message "The maximum number of simultaneous chats per agent has been reached." that should be displayed when an agent tries to take more chats than the maximum allowed.

  ![image](https://user-images.githubusercontent.com/6494543/192891486-8720a5e3-f0c8-4863-b0dc-fa3b922d776b.png)

- Regression: Handle `undefined` values on `useReactiveQuery`'s query function ([#26988](https://github.com/RocketChat/Rocket.Chat/pull/26988))

  According to https://tanstack.com/query/v4/docs/reference/useQuery, the query function must **not** return `undefined` values, a quirk that we've been ignoring.

- Regression: Incorrect on-hold chat resume message ([#26935](https://github.com/RocketChat/Rocket.Chat/pull/26935))

- Regression: Omnichannel Contact Center empty on no filter search ([#26975](https://github.com/RocketChat/Rocket.Chat/pull/26975))

- Regression: Remove section and replace icon on administration kebab menu ([#26986](https://github.com/RocketChat/Rocket.Chat/pull/26986))

- Regression: Remove symbols from number before storing PBX event ([#26969](https://github.com/RocketChat/Rocket.Chat/pull/26969))

- Regression: Sidebar Room List not working properly. ([#26950](https://github.com/RocketChat/Rocket.Chat/pull/26950))

  The CachedCollection Class was assuming that the passed parameter would be modified, instead of using the callback return.

- Regression: Typo on livechat/queue endpoint client call ([#26962](https://github.com/RocketChat/Rocket.Chat/pull/26962))

- Regression: Use raw models instead of meteor ones on visitor inactivity processing ([#27002](https://github.com/RocketChat/Rocket.Chat/pull/27002))

- Regression: VideoConf Actions Reactivity in SidebarItem ([#27009](https://github.com/RocketChat/Rocket.Chat/pull/27009))

  Jira Issue: [VC-10]

- Regression: wrong permission on livechat/tags endpoints ([#26928](https://github.com/RocketChat/Rocket.Chat/pull/26928))

- Release 5.1.1 ([#26822](https://github.com/RocketChat/Rocket.Chat/pull/26822))

- Release 5.1.3 ([#26914](https://github.com/RocketChat/Rocket.Chat/pull/26914))

- Release 5.1.4  ([#26965](https://github.com/RocketChat/Rocket.Chat/pull/26965))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@neo-clon](https://github.com/neo-clon)
- [@souzaramon](https://github.com/souzaramon)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@LucianoPierdona](https://github.com/LucianoPierdona)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@hugocostadev](https://github.com/hugocostadev)
- [@jeanfbrito](https://github.com/jeanfbrito)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rique223](https://github.com/rique223)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 5.1.4
`2022-09-28  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

<details>
<summary>🔍 Minor changes</summary>


- Release 5.1.4  ([#26965](https://github.com/RocketChat/Rocket.Chat/pull/26965))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@tassoevan](https://github.com/tassoevan)

# 5.1.3
`2022-09-24  ·  4 🐛  ·  2 🔍  ·  8 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- `MongoInvalidArgumentError` on overwriting existing setting ([#26880](https://github.com/RocketChat/Rocket.Chat/pull/26880))

- Check if messsage.replies exist on new message template ([#26652](https://github.com/RocketChat/Rocket.Chat/pull/26652))

- Error when mentioning a non-member of a public channel ([#26917](https://github.com/RocketChat/Rocket.Chat/pull/26917))

- Importer fails when file includes user without an email. ([#26836](https://github.com/RocketChat/Rocket.Chat/pull/26836))

<details>
<summary>🔍 Minor changes</summary>


- Release 5.1.1 ([#26822](https://github.com/RocketChat/Rocket.Chat/pull/26822))

- Release 5.1.3 ([#26914](https://github.com/RocketChat/Rocket.Chat/pull/26914))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@debdutdeb](https://github.com/debdutdeb)
- [@filipemarins](https://github.com/filipemarins)
- [@hugocostadev](https://github.com/hugocostadev)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 5.1.2
`2022-09-12  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 5.1.1
`2022-09-08  ·  3 🐛  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Fix broken legacy message view ([#26819](https://github.com/RocketChat/Rocket.Chat/pull/26819))

  Fixed `messagesHistory` function, it was filtering messages only with existing threads.

- Livechat trigger messages covering all the website ([#26776](https://github.com/RocketChat/Rocket.Chat/pull/26776))

- Restore current chats  default table order ([#26808](https://github.com/RocketChat/Rocket.Chat/pull/26808))

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@hugocostadev](https://github.com/hugocostadev)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 5.1.0
`2022-09-02  ·  8 🎉  ·  7 🚀  ·  42 🐛  ·  129 🔍  ·  37 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🎉 New features


- `Home` page ([#25734](https://github.com/RocketChat/Rocket.Chat/pull/25734))

  <img width="1430" alt="image" src="https://user-images.githubusercontent.com/2263066/181625050-91714d59-dc91-4613-a162-2656216771cd.png">

- Adding oauth crud on the rocket.chat side ([#26220](https://github.com/RocketChat/Rocket.Chat/pull/26220))

- allow ephemeral messages to receive a specific id ([#26118](https://github.com/RocketChat/Rocket.Chat/pull/26118))

  Allow apps to pass a specific ID for ephemeral messages as a way to edit them.

- Capability to search visitors by custom fields ([#26312](https://github.com/RocketChat/Rocket.Chat/pull/26312))

  Users of the endpoints [api/v1/omnichannel/contact.search](https://developer.rocket.chat/reference/api/rest-api/endpoints/omnichannel/livechat-endpoints/livechat-contact/omnichannel-search-contact) and [/api/v1/livechat/visitors.search](https://developer.rocket.chat/reference/api/rest-api/endpoints/omnichannel/livechat-endpoints/visitor/search-for-visitors) are now able to search by custom fields in their objects.
  Capability of selecting if a custom field can be searched for is added in the Omnichannel pannel as a toggle for `searchable`,  the included JSON in the Accounts' Custom Field example has been updated to make it explicit for future configurations that the field has to be enabled as searchable for that to happen.

- Fallback Error component for Engagement Dashboard widgets ([#26441](https://github.com/RocketChat/Rocket.Chat/pull/26441))

  As proposed, was added a fallback component to catch errors at Engagement Dashboard widgets individually.
  It used an Error boundary to catch `react-query` errors, due to this scenario was necessary to install and use the library   [react-error-boundary](https://github.com/bvaughn/react-error-boundary)  that implements everything and more compared to our ErrorBoundary component, the main reason was to capture Query errors and the implementation with `react-query` library.

  **New layout:**

  Before:
  ![image](https://user-images.githubusercontent.com/20212776/184968003-607eda93-ae3f-406c-a775-becd2720a607.png)

  After:
  ![image](https://user-images.githubusercontent.com/20212776/184970152-25a425f3-6aad-4620-b1c1-5f8c8bb35fbb.png)

- Marketplace apps page new list view layout ([#26181](https://github.com/RocketChat/Rocket.Chat/pull/26181))

  Refactored the layout of the marketplace list of apps, now it has a more minimalist and flexbox-based style. Also implemented a new status filter.

  Demo gif:
  ![new-app-list](https://user-images.githubusercontent.com/43561537/179572667-792d8d34-1003-4e95-bf10-37ba93f8c1ef.gif)

  ClickUp task:
  https://app.clickup.com/t/1na7437

- Surface featured apps endpoint  ([#26416](https://github.com/RocketChat/Rocket.Chat/pull/26416))

  Created the /featured endpoints on the rest.js file. Also created the necessary typings to use together with it.

- Warn admins about running multiple instances of the monolith ([#26667](https://github.com/RocketChat/Rocket.Chat/pull/26667))

### 🚀 Improvements


- Added identification on calls to/from existing contacts ([#26334](https://github.com/RocketChat/Rocket.Chat/pull/26334))

  Before:
  <img width="273" alt="Screen Shot 2022-07-02 at 01 50 52" src="https://user-images.githubusercontent.com/6494543/180296563-393ae4e8-2d91-4e21-8567-3112d445b8ee.png">

  After:
  <img width="279" alt="Screen Shot 2022-07-21 at 16 00 27" src="https://user-images.githubusercontent.com/6494543/180296628-188ba5b2-6f49-450f-b0b0-fd8b40d1b45e.png">

- General federation improvements ([#26150](https://github.com/RocketChat/Rocket.Chat/pull/26150))

  I know this changed a lot of files, but the main goal for this PR is not to change any behavior, the goals for the PR are:


  - Refactor the code;

  - Solve any tech debt;

  - Simplify and reuse some parts of the code;

  - Remove duplicated code;

  - Remove all unsafe type castings;

  - Solve all Eslint errors and warnings;

  - Split too big files;

  - Encapsulate the business logic in a better way, avoiding exposing and leaking internal logic to the unintended layers;

  - Improve the actual test cases;

  - Add more test cases, since a lot of cases were omitted during the release phase;

  - Remove unsafe `Object.assign` statements and prefer to use the class `constructor` instead;

- New 'not found page' design ([#26452](https://github.com/RocketChat/Rocket.Chat/pull/26452))

  - Add a new design for the not-found page

  - Add English translation for "page not found" and "Homepage"

  - Update English translation for "Room_not_exist_or_not_permission"

  - Add "Homepage" button on the room not found page

- OTR refactoring ([#24757](https://github.com/RocketChat/Rocket.Chat/pull/24757))

  Rewritten OTR files to TS with new code patterns

- Remove device-management banner and modal ([#26729](https://github.com/RocketChat/Rocket.Chat/pull/26729))

- Spotlight search user results ([#26599](https://github.com/RocketChat/Rocket.Chat/pull/26599))

- use enter key to call using DialPad ([#26454](https://github.com/RocketChat/Rocket.Chat/pull/26454))

### 🐛 Bug fixes


- - Incoming SMSs no longer clash with ongoing livechat conversations by the same visitor ([#26307](https://github.com/RocketChat/Rocket.Chat/pull/26307))

  There was a data race in the defineVisitor function, causing new guests to be created even if a registered guest with that number already existed, also made sure that the open room being searched on is the correct source type, so the clash is not possible anymore.

- Active users count on `@all` and `@here`  ([#25957](https://github.com/RocketChat/Rocket.Chat/pull/25957))

  this PR updates the old `roomMembersCount` to count active users instead of everyone

- add image format validation ([#25912](https://github.com/RocketChat/Rocket.Chat/pull/25912))

- Add Offline License Endpoint ([#26282](https://github.com/RocketChat/Rocket.Chat/pull/26282))

  This PR updates the endpoint to add a license

- Agents (with user status offline & omni-status as available) not able to take or forward chat ([#26575](https://github.com/RocketChat/Rocket.Chat/pull/26575))

- Allow normal user to open apps contextual bar ([#26495](https://github.com/RocketChat/Rocket.Chat/pull/26495))

  Fix the bug where normal users cannot open an app contextual bar.
  The request made by the contextual bar to get the app information, which was for admin only, was removed since the response was not being used.

- Autotranslate method should respect setting ([#26549](https://github.com/RocketChat/Rocket.Chat/pull/26549))

- Avatars of other chats disappear when they located near chat with broken avatar ([#26689](https://github.com/RocketChat/Rocket.Chat/pull/26689))

- Blank screen after requesting transcript ([#26385](https://github.com/RocketChat/Rocket.Chat/pull/26385))

- Chats not getting assigned to offline agents even when "Accept with No Online agents" setting is turned on ([#26147](https://github.com/RocketChat/Rocket.Chat/pull/26147))

- Clear push token on save user password ([#26466](https://github.com/RocketChat/Rocket.Chat/pull/26466))

- Correct IMAP configuration for email inbox ([#25789](https://github.com/RocketChat/Rocket.Chat/pull/25789))

  The primary change here has been to make the library try and reconnect after some time, up to a certain configured number of times, on a few different error classes.

- Current Chat Custom Field Filter ([#26200](https://github.com/RocketChat/Rocket.Chat/pull/26200))

- Decrypt E2EE messages on thread list ([#26133](https://github.com/RocketChat/Rocket.Chat/pull/26133))

  ### Before
  <img width="672" alt="Screenshot 2022-07-05 at 9 28 22 PM" src="https://user-images.githubusercontent.com/58601732/177369226-b863a362-4064-450e-8c93-ff708b378c7b.png">
  ### After
  <img width="674" alt="Screenshot 2022-07-05 at 9 27 42 PM" src="https://user-images.githubusercontent.com/58601732/177369298-fc6b375a-687b-4b84-8600-c0a179637f2a.png">

- Default BH not getting applied in-case any other BH is disabled ([#26471](https://github.com/RocketChat/Rocket.Chat/pull/26471))

- DialPad call button from end to center ([#26459](https://github.com/RocketChat/Rocket.Chat/pull/26459))

- Don't give errors on outbound voip call Request Terminated ([#26373](https://github.com/RocketChat/Rocket.Chat/pull/26373))

- Don't wrap wrap up notes ([#26375](https://github.com/RocketChat/Rocket.Chat/pull/26375))

- incorrect error toast messages ([#26320](https://github.com/RocketChat/Rocket.Chat/pull/26320))

- Katex is not respecting the 'Katex_Enabled' setting ([#26542](https://github.com/RocketChat/Rocket.Chat/pull/26542))

- MDM content alignment ([#26665](https://github.com/RocketChat/Rocket.Chat/pull/26665))

  - remove left margin of MDM content

  before:
  ![image](https://user-images.githubusercontent.com/48109548/186213428-946d6061-8f8d-415f-9b3b-049082c1bc25.png)

  after:
  <img width="610" alt="Screen Shot 2022-08-23 at 11 50 55" src="https://user-images.githubusercontent.com/48109548/186213460-c057e8a1-5838-44f5-b3fa-9f76752f0a89.png">

- Missing bio field UI validation ([#26345](https://github.com/RocketChat/Rocket.Chat/pull/26345))

- Not allowed error in discussion room with a private parent channel ([#26394](https://github.com/RocketChat/Rocket.Chat/pull/26394))

- Notification preferences not updated on save ([#26461](https://github.com/RocketChat/Rocket.Chat/pull/26461))

  Publish required notification subscription fields on change, so that changes can be seen on save.

- Onhold auto chat resume feature not working for email channel ([#26363](https://github.com/RocketChat/Rocket.Chat/pull/26363))

- Open team after room not found page ([#26264](https://github.com/RocketChat/Rocket.Chat/pull/26264))

  After the room not found page, the `FlowRouter` was not clearing `msg` query param, causing the next redirect to private teams break because it's try to find the unknow msg id

- Permission `view-all-teams` is not checked in the `teams.info` endpoint ([#25841](https://github.com/RocketChat/Rocket.Chat/pull/25841))

  Previously any authenticated user was able to access the `teams.info` endpoint, this PR updates this so only users with the `view-all-teams` permission or team members can access it.

- Prevent VoIP issues during disconnection when network failed ([#26321](https://github.com/RocketChat/Rocket.Chat/pull/26321))

- Prune messages not removing thumbnails ([#26443](https://github.com/RocketChat/Rocket.Chat/pull/26443))

  This PR adds a method on `Uploads` called `findOneByName`, and excludes a thumbnail of an image on `cleanRoomHistory`

- Request at least one field in the payload of `/v1/users.setStatus` ([#26490](https://github.com/RocketChat/Rocket.Chat/pull/26490))

  Requests `status` and/or `message` fields on `/v1/users.setStatus` request payload.

- Reset password errors ([#26597](https://github.com/RocketChat/Rocket.Chat/pull/26597))

- Save edited tags for omnichannel departments ([#26481](https://github.com/RocketChat/Rocket.Chat/pull/26481))

- Slack User CSV importer not working ([#26629](https://github.com/RocketChat/Rocket.Chat/pull/26629))

- Slackbridge Connect Error ([#25793](https://github.com/RocketChat/Rocket.Chat/pull/25793))

  This PR fixes an issue that was happening when an invalid token was passed on SlackBridge, basically the app crashes because the error was not being handled

- Slash commands description as undefined ([#26372](https://github.com/RocketChat/Rocket.Chat/pull/26372) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- SMS service check ([#26558](https://github.com/RocketChat/Rocket.Chat/pull/26558))

- Too many REST API requests ([#26330](https://github.com/RocketChat/Rocket.Chat/pull/26330))

  Uses React Query cache as an alternative for querying data "sorta" real time.

- UI fixes on dropdown titles ([#26318](https://github.com/RocketChat/Rocket.Chat/pull/26318))

  - Add paddings on profile dropdown title

  - Fix paddings on 'sort' and 'create new' dropdown titles

  - Remove inline styles of `OptionTitle` (removing uppercase style)

  | Location | Before | After |
  | --------------- | --------------- | --------------- |
  | Sort Dropdown | ![image](https://user-images.githubusercontent.com/48109548/183442156-9cc5269e-458e-4b6a-b2e5-91102dcfe153.png) | <img width="178" alt="Screen Shot 2022-08-05 at 15 54 14" src="https://user-images.githubusercontent.com/48109548/183143281-52205a07-e264-4a92-85b9-cb750623aabe.png">  |
  | User Dropdown | ![image](https://user-images.githubusercontent.com/48109548/183442678-49667402-57fd-4a5c-9077-eaef53aad10c.png) | <img width="244" alt="Screen Shot 2022-08-05 at 15 54 05" src="https://user-images.githubusercontent.com/48109548/183143288-65ab1bc3-6cd7-4318-b973-9b4307e3dbf6.png"> |
  | Create new Dropdown | <img width="173" alt="Screen Shot 2022-08-08 at 11 33 17" src="https://user-images.githubusercontent.com/48109548/183442902-e8586b2c-795b-4dfe-9045-c2c7a8a8194a.png"> | <img width="164" alt="Screen Shot 2022-08-05 at 15 54 26" src="https://user-images.githubusercontent.com/48109548/183143273-ece23507-9b60-4c09-a4fe-dcea00454cf4.png"> |

- Unable to remove a user who joined a public team with a mention ([#26218](https://github.com/RocketChat/Rocket.Chat/pull/26218))

  This PR fixes a bug where a user that joins a team by mention don't get added to the team.

- Unable to send voice recording to Whatsapp ([#26276](https://github.com/RocketChat/Rocket.Chat/pull/26276))

- Users can access public discussions inside private channels they are not members of ([#26619](https://github.com/RocketChat/Rocket.Chat/pull/26619))

- Users can access public discussions inside private channels they are not members of ([#25981](https://github.com/RocketChat/Rocket.Chat/pull/25981))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Accounts/token to TS ([#26434](https://github.com/RocketChat/Rocket.Chat/pull/26434))

- Chore: Add end-to-end tests to teams listing in the `directory` endpoint ([#26347](https://github.com/RocketChat/Rocket.Chat/pull/26347) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- Chore: Add license env var to ee tests ([#26650](https://github.com/RocketChat/Rocket.Chat/pull/26650))

- Chore: add playwright ee coverage ([#26293](https://github.com/RocketChat/Rocket.Chat/pull/26293) by [@souzaramon](https://github.com/souzaramon) & [@weslley543](https://github.com/weslley543))

- Chore: Add translations code owner ([#26560](https://github.com/RocketChat/Rocket.Chat/pull/26560))

- Chore: Bump fuselage packages ([#26769](https://github.com/RocketChat/Rocket.Chat/pull/26769))

- Chore: Bypass turbo cache on `ui-contexts` ([#26526](https://github.com/RocketChat/Rocket.Chat/pull/26526))

  Skips cache for building `@rocket.chat/ui-contexts`, avoiding Turborepo issues with a symlink.

- Chore: Cache playwright  ([#26432](https://github.com/RocketChat/Rocket.Chat/pull/26432))

- Chore: Change some places still using `fields` to `projection` ([#26308](https://github.com/RocketChat/Rocket.Chat/pull/26308))

- Chore: cleanup startup of test and put wizard in setup function ([#26306](https://github.com/RocketChat/Rocket.Chat/pull/26306) by [@weslley543](https://github.com/weslley543))

- Chore: Codecov threshold ([#26477](https://github.com/RocketChat/Rocket.Chat/pull/26477))

- Chore: Convert `client/views/account/preferences` folder to ts ([#26496](https://github.com/RocketChat/Rocket.Chat/pull/26496))

- Chore: Convert `LivechatCustomField` model to raw model ([#26446](https://github.com/RocketChat/Rocket.Chat/pull/26446))

- Chore: Convert AccountPreferencesPage to ts ([#26096](https://github.com/RocketChat/Rocket.Chat/pull/26096))

- Chore: Convert AppSetting to tsx ([#26625](https://github.com/RocketChat/Rocket.Chat/pull/26625))

- Chore: Convert AppSettingsAssembler to tsx ([#26626](https://github.com/RocketChat/Rocket.Chat/pull/26626))

- Chore: Convert AutoCompleteAgent to tsx ([#26704](https://github.com/RocketChat/Rocket.Chat/pull/26704))

- Chore: convert autotranslate to ts ([#25953](https://github.com/RocketChat/Rocket.Chat/pull/25953))

  Converted the `apps/meteor/app/api/server/v1/autotranslate.js` to ts and created endpoint typings on the `packages/rest-typings/src/v1/autotranslate` folder.

- Chore: Convert client/views/account/security folder to ts ([#26413](https://github.com/RocketChat/Rocket.Chat/pull/26413))

- Chore: create a test for managers screen ([#26581](https://github.com/RocketChat/Rocket.Chat/pull/26581) by [@weslley543](https://github.com/weslley543))

- Chore: create removeWebdavAccount endpoint ([#26393](https://github.com/RocketChat/Rocket.Chat/pull/26393))

  Created the '/v1/webdav.removeWebdavAccount' endpoint for the `apps/meteor/client/views/account/integrations/AccountIntegrationsPage.tsx` file, and added Ajv validations.

- Chore: create roomNameExists endpoint ([#26386](https://github.com/RocketChat/Rocket.Chat/pull/26386))

  Created the missing rest endpoint 'roomNameExists' for `apps/meteor/client/sidebar/header/CreateChannel.tsx`, on the packages/rest-typings/src/v1/ folder.

- Chore: Create teams management tests ([#26578](https://github.com/RocketChat/Rocket.Chat/pull/26578) by [@souzaramon](https://github.com/souzaramon))

- Chore: Create tests for Omnichannel admin add a custom fields ([#26609](https://github.com/RocketChat/Rocket.Chat/pull/26609) by [@weslley543](https://github.com/weslley543))

- Chore: Engagement Dashboard end to end tests ([#26702](https://github.com/RocketChat/Rocket.Chat/pull/26702))

  Adding tests to check the behavior of the Engagement Dashboard for the Enterprise Edition license.
  The tests include:

  - Visibility and navigation of page and tabs

  - Fallback component on widgets error

- Chore: ESLint warnings ([#26504](https://github.com/RocketChat/Rocket.Chat/pull/26504))

  The current amount of ESLint warning messages is overwhelming to properly debug serious issues. This PR aims to reduce them to a sane amount.

- Chore: Exclude private/public folders from typecheck ([#26399](https://github.com/RocketChat/Rocket.Chat/pull/26399))

- Chore: Exit process on `unhandledRejection` on CI ([#26467](https://github.com/RocketChat/Rocket.Chat/pull/26467))

- Chore: Fail-fast on callbacks ([#26572](https://github.com/RocketChat/Rocket.Chat/pull/26572))

- Chore: Fix CI intermittent ([#26649](https://github.com/RocketChat/Rocket.Chat/pull/26649))

- Chore: Fix docker latest tag push ([#26770](https://github.com/RocketChat/Rocket.Chat/pull/26770))

- Chore: Fix grammatical typo when only one message is pruned ([#21902](https://github.com/RocketChat/Rocket.Chat/pull/21902) by [@shrinish123](https://github.com/shrinish123))

  Whenever only 1 message is pruned it says '1 messages pruned' instead of '1 message pruned' in the toast message

- Chore: Fix lint issues ([#26531](https://github.com/RocketChat/Rocket.Chat/pull/26531))

  #24757 was an old PR and was recently auto-merged, it was not following our latest eslint rules, so now there are some lint issues on the develop.

- Chore: Fix some settings with incompatible default value types ([#26114](https://github.com/RocketChat/Rocket.Chat/pull/26114))

- Chore: fix tests with beforeEach ([#26335](https://github.com/RocketChat/Rocket.Chat/pull/26335) by [@souzaramon](https://github.com/souzaramon) & [@weslley543](https://github.com/weslley543))

- Chore: Fix UiKit dependency issue for Livechat ([#26534](https://github.com/RocketChat/Rocket.Chat/pull/26534))

- Chore: Importer rest types, meteor methods to TS and API unit tests ([#26284](https://github.com/RocketChat/Rocket.Chat/pull/26284))

- Chore: Improve test for livechat  ([#26527](https://github.com/RocketChat/Rocket.Chat/pull/26527) by [@weslley543](https://github.com/weslley543))

- Chore: Migrate AppPermissionsReviewModal from JS to TS ([#26498](https://github.com/RocketChat/Rocket.Chat/pull/26498))

- Chore: Migrate modules related to `room` template to TypeScript ([#25881](https://github.com/RocketChat/Rocket.Chat/pull/25881))

- Chore: Migrate omni-chat forwarding to use API instead of meteor method ([#26377](https://github.com/RocketChat/Rocket.Chat/pull/26377))

  - Use `livechat/room.forward` endpoint to forward omnichannel chats instead of using meteor method "livechat:transfer"

- Chore: Missing permissions translations ([#26546](https://github.com/RocketChat/Rocket.Chat/pull/26546))

- Chore: Missing some English translation keywords ([#20131](https://github.com/RocketChat/Rocket.Chat/pull/20131) by [@Karting06](https://github.com/Karting06))

  Add missing translation keys in `en.i18n.json` to be able to translate them via Lingohub.

- Chore: Mocha handling multiple React instances ([#26513](https://github.com/RocketChat/Rocket.Chat/pull/26513))

  Whenever Mocha runs a test file which imports stuff from outside `apps/meteor`, it uses a hoisted version of React (i.e. located at the root `node_modules`) instead of the one tied to `apps/meteor/node_modules`. This PR adds a monkey patch while we can't migrate to another test runner.

- Chore: ModalFooterControllers adoption ([#26445](https://github.com/RocketChat/Rocket.Chat/pull/26445))

- Chore: More Omnichannel tests ([#26691](https://github.com/RocketChat/Rocket.Chat/pull/26691))

- Chore: Move `Card` and related components to `@rocket.chat/ui-client` ([#26653](https://github.com/RocketChat/Rocket.Chat/pull/26653))

- Chore: Move fuselage-ui-kit to main repo ([#26630](https://github.com/RocketChat/Rocket.Chat/pull/26630))

- Chore: Omnichannel endpoints e2e tests ([#26376](https://github.com/RocketChat/Rocket.Chat/pull/26376))

- Chore: omnichannel-departments tests  ([#26607](https://github.com/RocketChat/Rocket.Chat/pull/26607))

- Chore: Options in BaseRaw model could possibly be undefined ([#26395](https://github.com/RocketChat/Rocket.Chat/pull/26395))

  I found this while I was doing some refactorings on the federation side. 😬

- Chore: Parallelize e2e tests ([#26390](https://github.com/RocketChat/Rocket.Chat/pull/26390) by [@souzaramon](https://github.com/souzaramon) & [@weslley543](https://github.com/weslley543))

- Chore: Permissions check per endpoint/method ([#26419](https://github.com/RocketChat/Rocket.Chat/pull/26419))

- Chore: Prevent tooltip from opening after click ([#26612](https://github.com/RocketChat/Rocket.Chat/pull/26612))

- Chore: Purge some unused modules ([#26447](https://github.com/RocketChat/Rocket.Chat/pull/26447))

  The title says it all.

- Chore: Refactor create-target-channel util ([#26493](https://github.com/RocketChat/Rocket.Chat/pull/26493) by [@souzaramon](https://github.com/souzaramon))

- Chore: Refactor ReportMessage Modal to React Component ([#26478](https://github.com/RocketChat/Rocket.Chat/pull/26478))

- Chore: Refactor RoomMembers to Typescript ([#26559](https://github.com/RocketChat/Rocket.Chat/pull/26559))

- Chore: Refactor WebdavFilePicker Modal to React Component ([#26422](https://github.com/RocketChat/Rocket.Chat/pull/26422))

- Chore: Remove & Test cannedResponse meteor templates ([#26706](https://github.com/RocketChat/Rocket.Chat/pull/26706))

- Chore: Remove & Test old closeChat templates ([#26631](https://github.com/RocketChat/Rocket.Chat/pull/26631))

- Chore: Remove console.log ([#26618](https://github.com/RocketChat/Rocket.Chat/pull/26618))

- Chore: Remove italic/bold font-style from system messages ([#26655](https://github.com/RocketChat/Rocket.Chat/pull/26655))

  It was removed from system messages font-styles elements (italic and bold) that highlighted some words as `users`, `room_name` and others.

  In addition to this PR, was also created a PR to Fuselage to remove italic font style in general at system messages.

  Fuselage PR:  https://github.com/RocketChat/fuselage/pull/830

- Chore: Remove Livechat Dashboard Templates ([#26627](https://github.com/RocketChat/Rocket.Chat/pull/26627))

- Chore: Remove method calls - Stage 1 ([#26149](https://github.com/RocketChat/Rocket.Chat/pull/26149))

- Chore: Remove public and node_modules folders from TypeScript server watcher ([#26391](https://github.com/RocketChat/Rocket.Chat/pull/26391))

- Chore: Remove settings Fibers usage ([#26465](https://github.com/RocketChat/Rocket.Chat/pull/26465))

- Chore: Remove translation owners ([#26598](https://github.com/RocketChat/Rocket.Chat/pull/26598))

- Chore: Remove trash collection from models when not used ([#26628](https://github.com/RocketChat/Rocket.Chat/pull/26628))

- Chore: remove useMethod calls ([#26195](https://github.com/RocketChat/Rocket.Chat/pull/26195))

- Chore: Remove visitor, agent and customTemplate meteor templates ([#26700](https://github.com/RocketChat/Rocket.Chat/pull/26700))

- Chore: Replace direct multiple icon ([#26342](https://github.com/RocketChat/Rocket.Chat/pull/26342))

- Chore: Replace timeAgo on WebdavFilePickerTable ([#26564](https://github.com/RocketChat/Rocket.Chat/pull/26564))

- Chore: restrict `.only` ([#26537](https://github.com/RocketChat/Rocket.Chat/pull/26537))

- Chore: Rewrite custom OAuth Modals to react ([#26204](https://github.com/RocketChat/Rocket.Chat/pull/26204))

- Chore: Rewrite Location modal to React ([#26196](https://github.com/RocketChat/Rocket.Chat/pull/26196))

- Chore: Rewrite SaveToWebdav Modal to React Component ([#24365](https://github.com/RocketChat/Rocket.Chat/pull/24365))

  ### before
  ![Screen Shot 2022-01-31 at 11 02 34](https://user-images.githubusercontent.com/27704687/151807376-6dc87be5-287a-45a0-ac1b-47a7cdf4e3d3.png)

  ### after
  ![Screen Shot 2022-01-31 at 10 58 04](https://user-images.githubusercontent.com/27704687/151806686-7110cec8-a006-4ac1-befd-a2684550ecc5.png)

- Chore: Rewrite VerticalBarOldActions to TS ([#26277](https://github.com/RocketChat/Rocket.Chat/pull/26277))

- Chore: Separating user edit form to prevent browser autocomplete ([#26280](https://github.com/RocketChat/Rocket.Chat/pull/26280))

  Separating user edit form to prevent browser password and username auto-complete.
  The browser will continue showing the suggestion dropdown for the password field, but when you select a suggestion the other text field will not be impacted, as was happening before with 'Nickname' field

- Chore: skipping tests that are based on kebab menu ([#26616](https://github.com/RocketChat/Rocket.Chat/pull/26616))

- Chore: test for change avatar ([#26543](https://github.com/RocketChat/Rocket.Chat/pull/26543) by [@weslley543](https://github.com/weslley543))

- Chore: Tests intermitences ([#26464](https://github.com/RocketChat/Rocket.Chat/pull/26464) by [@weslley543](https://github.com/weslley543))

- Chore: transfer to another agent ([#26545](https://github.com/RocketChat/Rocket.Chat/pull/26545) by [@weslley543](https://github.com/weslley543))

- Chore: Update Apps-Engine ([#26765](https://github.com/RocketChat/Rocket.Chat/pull/26765))

- Chore: update codeowners for omnichannel ([#25771](https://github.com/RocketChat/Rocket.Chat/pull/25771))

- Chore: update fuselage rounded edition  ([#26540](https://github.com/RocketChat/Rocket.Chat/pull/26540))

- Chore: Upgrade dependencies ([#26694](https://github.com/RocketChat/Rocket.Chat/pull/26694))

- Chore: Upgrade ESLint ([#26132](https://github.com/RocketChat/Rocket.Chat/pull/26132))

  Upgrade ESLint (to 8.19.0) and its dependencies, dropping outdated rules.

- Chore: Upgrade Fuselage packages to next dist-tag ([#26435](https://github.com/RocketChat/Rocket.Chat/pull/26435))

- Chore: Upgrade nivo and React Query ([#26338](https://github.com/RocketChat/Rocket.Chat/pull/26338))

- Chore: Use Docker compose on CI ([#26437](https://github.com/RocketChat/Rocket.Chat/pull/26437))

- Chore: useEndpointData deprecation ([#26494](https://github.com/RocketChat/Rocket.Chat/pull/26494))

- Chore: Wait subscription to expose message composer ([#26600](https://github.com/RocketChat/Rocket.Chat/pull/26600))

- i18n: Fix Korean set role translation ([#24966](https://github.com/RocketChat/Rocket.Chat/pull/24966) by [@imyaman](https://github.com/imyaman))

  English  https://pbs.twimg.com/media/FO2zby1aQAMB84D?format=png&name=small
  Korean  https://pbs.twimg.com/media/FO2zWgKaIAYidJ7?format=png&name=small
  Google Translate  https://pbs.twimg.com/media/FO20MPnaUAU-TU_?format=jpg&name=medium

- i18n: Language update from LingoHub 🤖 on 2022-08-01Z ([#26429](https://github.com/RocketChat/Rocket.Chat/pull/26429))

- i18n: Language update from LingoHub 🤖 on 2022-08-08Z ([#26508](https://github.com/RocketChat/Rocket.Chat/pull/26508))

- i18n: Language update from LingoHub 🤖 on 2022-08-15Z ([#26570](https://github.com/RocketChat/Rocket.Chat/pull/26570))

- i18n: Language update from LingoHub 🤖 on 2022-08-22Z ([#26645](https://github.com/RocketChat/Rocket.Chat/pull/26645))

- i18n: Makes the text less ambiguous ([#20895](https://github.com/RocketChat/Rocket.Chat/pull/20895) by [@pierreozoux](https://github.com/pierreozoux))

- i18n: Manual sync from LingoHub ([#26397](https://github.com/RocketChat/Rocket.Chat/pull/26397))

- i18n: pt-BR translation typo ([#26732](https://github.com/RocketChat/Rocket.Chat/pull/26732))

- Regression: "Cache size is not a function" error when booting ([#26683](https://github.com/RocketChat/Rocket.Chat/pull/26683))

- Regression: Add alsoSendThreadToChannel to user settings api ([#26663](https://github.com/RocketChat/Rocket.Chat/pull/26663))

- Regression: AutoTranslate is disabled error ([#26701](https://github.com/RocketChat/Rocket.Chat/pull/26701))

- Regression: Banner - Room not found - Omnichannel room ([#26693](https://github.com/RocketChat/Rocket.Chat/pull/26693))

- Regression: CI ([#26658](https://github.com/RocketChat/Rocket.Chat/pull/26658))

- Regression: Custom fields not being saved for room ([#26747](https://github.com/RocketChat/Rocket.Chat/pull/26747))

- Regression: Custom status loading forever in Usercard ([#26656](https://github.com/RocketChat/Rocket.Chat/pull/26656))

- Regression: Empty custom-fields filter on Current Chats causing issues ([#26720](https://github.com/RocketChat/Rocket.Chat/pull/26720))

- Regression: Fix Current Chats Page Issues ([#26744](https://github.com/RocketChat/Rocket.Chat/pull/26744))

- Regression: Fix spacing problem on AppStatus component ([#26421](https://github.com/RocketChat/Rocket.Chat/pull/26421))

  Fixed a problem where the AppStatus component would show a unwanted margin when an app was installed and had an update.
  Before:
  ![image](https://user-images.githubusercontent.com/43561537/181837343-c51ed297-442c-4507-aff3-20df5ac9366a.png)

  After:
  ![image](https://user-images.githubusercontent.com/43561537/181838756-b04fe31c-9e85-4830-8dd4-fddf8ec03458.png)

- Regression: Home cards UI tweaks ([#26610](https://github.com/RocketChat/Rocket.Chat/pull/26610))

- Regression: Instances Modal breaking ([#26779](https://github.com/RocketChat/Rocket.Chat/pull/26779))

  Revert back to meteor method for now.

- Regression: invalid statistics format  ([#26684](https://github.com/RocketChat/Rocket.Chat/pull/26684))

- Regression: Modal footer alignment ([#26635](https://github.com/RocketChat/Rocket.Chat/pull/26635))

- Regression: Prevent message from being temp forever ([#26668](https://github.com/RocketChat/Rocket.Chat/pull/26668))

- Regression: Remove log from banners.ts ([#26699](https://github.com/RocketChat/Rocket.Chat/pull/26699))

- Regression: REST setUserPublicAndPrivateKeys ([#26753](https://github.com/RocketChat/Rocket.Chat/pull/26753))

- Regression: Select settings options not visible on Apps Setting panel ([#26759](https://github.com/RocketChat/Rocket.Chat/pull/26759))

- Regression: Sidebar Search list local data cache and keyboard navigation ([#26764](https://github.com/RocketChat/Rocket.Chat/pull/26764))

- Regression: Team name validation failing always. ([#26574](https://github.com/RocketChat/Rocket.Chat/pull/26574))

- Regression: Update custom homepage content behavior ([#26571](https://github.com/RocketChat/Rocket.Chat/pull/26571))

- Regression: Visitor being overwritten on call end ([#26756](https://github.com/RocketChat/Rocket.Chat/pull/26756))

  This PR adds a check to the `createRoom` method, responsible for creating VoIP rooms. It checks whether the visitor already exists before creating a new one, if one is found it uses it instead of overwriting existing visitors.

- Regression: Workaround to handle auto stopped computations 😞  ([#26745](https://github.com/RocketChat/Rocket.Chat/pull/26745))

- Release 5.0.1 ([#26450](https://github.com/RocketChat/Rocket.Chat/pull/26450))

- Release 5.0.2 ([#26507](https://github.com/RocketChat/Rocket.Chat/pull/26507))

- Release 5.0.3 ([#26551](https://github.com/RocketChat/Rocket.Chat/pull/26551))

- Release 5.0.4 ([#26620](https://github.com/RocketChat/Rocket.Chat/pull/26620))

- Release 5.0.5 ([#26718](https://github.com/RocketChat/Rocket.Chat/pull/26718))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Karting06](https://github.com/Karting06)
- [@carlosrodrigues94](https://github.com/carlosrodrigues94)
- [@imyaman](https://github.com/imyaman)
- [@pierreozoux](https://github.com/pierreozoux)
- [@shrinish123](https://github.com/shrinish123)
- [@souzaramon](https://github.com/souzaramon)
- [@weslley543](https://github.com/weslley543)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@LucianoPierdona](https://github.com/LucianoPierdona)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@casalsgh](https://github.com/casalsgh)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@hugocostadev](https://github.com/hugocostadev)
- [@jeanfbrito](https://github.com/jeanfbrito)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tapiarafael](https://github.com/tapiarafael)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 5.0.5
`2022-08-29  ·  3 🐛  ·  1 🔍  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- **ENTERPRISE:** Omnichannel real time data on micro services ([#26703](https://github.com/RocketChat/Rocket.Chat/pull/26703))

- Business Units endpoints not filtering by Unit type ([#26713](https://github.com/RocketChat/Rocket.Chat/pull/26713))

- Omnichannel inquiries being updated even if not needed ([#26692](https://github.com/RocketChat/Rocket.Chat/pull/26692))

<details>
<summary>🔍 Minor changes</summary>


- Release 5.0.5 ([#26718](https://github.com/RocketChat/Rocket.Chat/pull/26718))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@Harmeet221](https://github.com/Harmeet221)
- [@KevLehman](https://github.com/KevLehman)
- [@murtaza98](https://github.com/murtaza98)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.0.4
`2022-08-19  ·  1 🐛  ·  3 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- **ENTERPRISE:** User not marked as offline on log out when using micro services ([#26579](https://github.com/RocketChat/Rocket.Chat/pull/26579))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Fix services image publish do DockerHub ([#26608](https://github.com/RocketChat/Rocket.Chat/pull/26608))

- Regression: Fix services Docker build ([#26617](https://github.com/RocketChat/Rocket.Chat/pull/26617))

- Release 5.0.4 ([#26620](https://github.com/RocketChat/Rocket.Chat/pull/26620))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@murtaza98](https://github.com/murtaza98)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.0.3
`2022-08-11  ·  3 🐛  ·  2 🔍  ·  7 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Chats holds to load history for some time ([#26425](https://github.com/RocketChat/Rocket.Chat/pull/26425))

- Endpoints not working when using "Use Real Name" setting ([#26530](https://github.com/RocketChat/Rocket.Chat/pull/26530))

  The list of endpoints affected is:


  - `/api/v1/channels.list`

  - `/api/v1/channels.list.joined`

  - `/api/v1/groups.list`

  - `/api/v1/groups.listAll`

  - `/api/v1/im.list`

  - `/api/v1/im.list.everyone`

- LDAP fails to sync teams when the user DN has escaped characters. ([#26535](https://github.com/RocketChat/Rocket.Chat/pull/26535))

<details>
<summary>🔍 Minor changes</summary>


- Chore: validateParams to accept different validators per request method ([#26357](https://github.com/RocketChat/Rocket.Chat/pull/26357))

- Release 5.0.3 ([#26551](https://github.com/RocketChat/Rocket.Chat/pull/26551))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.0.2
`2022-08-08  ·  2 🐛  ·  1 🔍  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Empty results on `im.list` endpoint ([#26438](https://github.com/RocketChat/Rocket.Chat/pull/26438))

- Undefined MediaDevices error on HTTP ([#26396](https://github.com/RocketChat/Rocket.Chat/pull/26396))

<details>
<summary>🔍 Minor changes</summary>


- Release 5.0.2 ([#26507](https://github.com/RocketChat/Rocket.Chat/pull/26507))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@murtaza98](https://github.com/murtaza98)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.0.1
`2022-08-02  ·  1 🚀  ·  1 🐛  ·  4 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### 🚀 Improvements


- Use single change stream to watch DB changes ([#26336](https://github.com/RocketChat/Rocket.Chat/pull/26336))

### 🐛 Bug fixes


- Not possible to deactivate users ([#26323](https://github.com/RocketChat/Rocket.Chat/pull/26323))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Convert UserCardWithData to ts ([#26192](https://github.com/RocketChat/Rocket.Chat/pull/26192))

- Chore: Remove square prop from IconButton ([#26343](https://github.com/RocketChat/Rocket.Chat/pull/26343))

- Regression: Fix app privacy links opening in desktop client instead of browser ([#26368](https://github.com/RocketChat/Rocket.Chat/pull/26368))

  Demo gif:
  ![privacy-links](https://user-images.githubusercontent.com/43561537/181083695-bc37b5c2-8aa5-4714-9098-9ad02d2fc2bb.gif)

- Release 5.0.1 ([#26450](https://github.com/RocketChat/Rocket.Chat/pull/26450))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@dougfabris](https://github.com/dougfabris)
- [@rique223](https://github.com/rique223)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 5.0.0
`2022-07-21  ·  14 ️️️⚠️  ·  33 🎉  ·  20 🚀  ·  110 🐛  ·  389 🔍  ·  62 👩‍💻👨‍💻`

### Engine versions
- Node: `14.19.3`
- NPM: `6.14.17`
- MongoDB: `4.2, 4.4, 5.0`

### ⚠️ BREAKING CHANGES


- Chore: Remove unused tokenpass integration code  ([#25831](https://github.com/RocketChat/Rocket.Chat/pull/25831))

- Deactivated team members are added to auto-join rooms ([#25016](https://github.com/RocketChat/Rocket.Chat/pull/25016))

  - Do not add deactivated users to auto-join rooms.

- Remove Blockstack authentication ([#25649](https://github.com/RocketChat/Rocket.Chat/pull/25649))

  Blockstack authentication is broken and is preventing some dependencies to be up to date. As a migration to Stacks authentication is not trivial, we've opted for removing the authentication service.

- Remove RDStation integration ([#25774](https://github.com/RocketChat/Rocket.Chat/pull/25774))

- Remove show message in main thread preference ([#26002](https://github.com/RocketChat/Rocket.Chat/pull/26002))

  This PR removes the confusion between the `show message in main thread` and the function `also to send to channel`. In the past, we used the `show message in main thread` as a solution to help users to understand the thread feature, as this feature is now mature enough there's no reason to maintain this preference.

  Send the thread message to the main channel or just inside of the thread, should be a decision from the user where the function `also send to channel` appears. Because of that, and because of a bunch of requests and issues we received, we're introducing a new preference `also send thread to channel` where users will be able to decide the behavior of the checkbox.

  ![image](https://user-images.githubusercontent.com/27704687/175655594-023c5907-adc8-4924-ba7d-467608d06fec.png)

  Now there are three behavior options

  - `Default`: when it unchecks after sending the first message
  <img width='250px' height='350px' src='https://user-images.githubusercontent.com/27704687/175656500-34817639-7f13-4641-b4fa-9dd106e99443.gif' />


  - `Always`: stay checked for all messages
  <img width='250px' height='350px' src='https://user-images.githubusercontent.com/27704687/175657299-d88efaba-1c2b-4bb9-a23a-f9755dcec5ca.gif' />


  - `Never`: stay unchecked for all messages
  <img width='250px' height='350px' src='https://user-images.githubusercontent.com/27704687/175657544-3dcd0adc-05cf-4196-83a6-f6cc29a1de2b.gif' />

- Remove support to old MongoDB versions ([#26098](https://github.com/RocketChat/Rocket.Chat/pull/26098))

  As per MongoDB Lifecycle Schedules (https://www.mongodb.com/support-policy/lifecycles) we're removing official support to MongoDB versions **3.6 and 4.0** that have already reached end-of-life.

  As MongoDB 4.2 was a "supported" version before Rocket.Chat 5.0, we'll continue supporting it, but will be flagged as deprecated. We recommend upgrading to MongoDB 4.4+.

  Here are official docs on how to upgrade to some of the supported versions:


  - https://www.mongodb.com/docs/manual/release-notes/4.2-upgrade-replica-set/

  - https://www.mongodb.com/docs/v4.4/release-notes/4.4-upgrade-replica-set/

  - https://www.mongodb.com/docs/manual/release-notes/5.0-upgrade-replica-set/

- remove unused endpoints and restify others ([#25889](https://github.com/RocketChat/Rocket.Chat/pull/25889))

- Remove webRTC for channels/dm/groups ([#26225](https://github.com/RocketChat/Rocket.Chat/pull/26225))

- Suspend push notifications when login token is invalidated ([#20913](https://github.com/RocketChat/Rocket.Chat/pull/20913) by [@g-thome](https://github.com/g-thome))

  link the auth token to the push token

- Upgrade to version 5.0 can be done only from version 4.x ([#26100](https://github.com/RocketChat/Rocket.Chat/pull/26100))

- use urlParams on omnichannel/agent/extension/ ([#25982](https://github.com/RocketChat/Rocket.Chat/pull/25982))

- use urlParams on omnichannel/agent/extension/ ([#25874](https://github.com/RocketChat/Rocket.Chat/pull/25874))

- use urlParams on omnichannel/agent/extension/" ([#25980](https://github.com/RocketChat/Rocket.Chat/pull/25980))

- VideoConference ([#25570](https://github.com/RocketChat/Rocket.Chat/pull/25570))

  In this PR we're deprecating the Video Conference functionality from the core of the application and introducing a **new video conference flow**:

  <img src='https://user-images.githubusercontent.com/27704687/176227619-fd7603e5-dc0b-4089-b811-749313b6e674.gif' />

  Now the video conference feature will be agnostic so you'll be able to set the provider such as **Jisti** and **BBB** as apps from our marketplace:

  <img width='70%' src='https://user-images.githubusercontent.com/27704687/176220152-a88dac4e-75ba-4fd5-9d4e-266316d4cb07.png' />

  Video conferences settings are now global, allowing you to set the default provider

  <img width='70%' src='https://user-images.githubusercontent.com/27704687/176220808-a8213628-2168-4c4e-9679-d858215dd4cb.png' />

  ### [Enterprise Features]

  - Video Conferences List
  <img width='300px' height='450' src='https://user-images.githubusercontent.com/27704687/176223821-7a2a280a-149f-4645-ac85-bbdf5b34f311.png' />


  - Ringing function for direct messages

  <img width='70%' src='https://user-images.githubusercontent.com/27704687/176225059-de48a881-5ff4-45ad-abf2-8a7827dd0b1c.gif' />

  <img width='70%' src='https://user-images.githubusercontent.com/27704687/176225530-3a0f6149-5ee9-425b-b841-27d35aed8165.gif' />

### 🎉 New features


- **APPS:** Allow apps to modify a subset of global settings ([#25913](https://github.com/RocketChat/Rocket.Chat/pull/25913))

- **APPS:** Allow dispatchment of actions from input elements ([#25949](https://github.com/RocketChat/Rocket.Chat/pull/25949))

  This allows for apps receiving block actions when a user types on a plain text input field or selects an item from the static. A debounce of 700 ms is done when listening for typing action so the app is not flooded with actions.


  https://user-images.githubusercontent.com/733282/174858175-5ea53046-c791-493e-859b-b80431e94ffa.mp4

- **APPS:** Allowing apps to register authenticated routes ([#25937](https://github.com/RocketChat/Rocket.Chat/pull/25937))

  Adds adaptations that allow apps to declare an API endpoint that requires authorization from Rocket.Chat prior to executing

- **ENTERPRISE:** Device Management ([#25791](https://github.com/RocketChat/Rocket.Chat/pull/25791))

- **ENTERPRISE:** Introducing dial pad component into sidebar, calls table, contextual bar ([#26081](https://github.com/RocketChat/Rocket.Chat/pull/26081))

  This PR adds a new call button that can be used from Sidebar & Contact Center. This also enables Omnichannel agents to make outbound calls from within Rocket.Chat.

  Depending on your server and call server configuration, you can do international calling, national and domestic calling.

  The buttons on Contact Center allows an agent to call an existing number without having to type the number again.

- Ability for RC server to check the business hour for a specific department ([#25436](https://github.com/RocketChat/Rocket.Chat/pull/25436))

- Accept quoted slash command arguments ([#11744](https://github.com/RocketChat/Rocket.Chat/pull/11744) by [@Hudell](https://github.com/Hudell))

- Add expire index to integration history ([#25087](https://github.com/RocketChat/Rocket.Chat/pull/25087))

- Add new app events for pin, react and follow message ([#25337](https://github.com/RocketChat/Rocket.Chat/pull/25337))

- Add new events after user login, logout and change his status ([#25234](https://github.com/RocketChat/Rocket.Chat/pull/25234))

- Add option to show mentions badge when show counter is disabled ([#25329](https://github.com/RocketChat/Rocket.Chat/pull/25329))

- Add user events for apps ([#25165](https://github.com/RocketChat/Rocket.Chat/pull/25165))

- Adding app button on user dropdown ([#25326](https://github.com/RocketChat/Rocket.Chat/pull/25326))

- Alpha Matrix Federation ([#23688](https://github.com/RocketChat/Rocket.Chat/pull/23688))

  Experimental support for Matrix Federation with a Bridge

  https://user-images.githubusercontent.com/51996/164530391-e8b17ecd-a4d0-4ef8-a8b7-81230c1773d3.mp4

- Colors Palette - Buttons ([#25626](https://github.com/RocketChat/Rocket.Chat/pull/25626))

- Community Edition Watermark ([#25844](https://github.com/RocketChat/Rocket.Chat/pull/25844))

- Create releases tab in the marketplace app info page ([#25965](https://github.com/RocketChat/Rocket.Chat/pull/25965))

  Added a Releases tab to the app info page of installed marketplace apps. This tab will show all the released versions of a given app with its version number, release date in humanized form, and the changelog of this given release with the information provided by the publisher, this changelog accepts and renders markdown. Also refactored some component names and logic for maintainability reasons.
  Demo gif:
  ![app-releases-tab-final](https://user-images.githubusercontent.com/43561537/176228928-651074ce-1f8b-4531-95be-1dd107938bf3.gif)

- Create Team with a member list of usernames ([#25868](https://github.com/RocketChat/Rocket.Chat/pull/25868))

- Enable outbound calling for EE (#25843) ([#25960](https://github.com/RocketChat/Rocket.Chat/pull/25960) by [@amolghode1981](https://github.com/amolghode1981))

- Engagement Metrics - Phase 2 ([#25505](https://github.com/RocketChat/Rocket.Chat/pull/25505))

  Add the following new statistics (metrics):
   - Total Broadcast rooms
   - Total rooms with an active Livestream;
   - Total triggered emails;
   - Total subscription roles;
   - Total User Roles;
   - Total uncaught exceptions;
   - `homeTitleChanged`: boolean value to indicate whether the `Layout_Home_Title` setting has been changed;
   - `homeBodyChanged`: boolean value to indicate whether the `Layout_Home_Body` setting has been changed;
   - `customCSSChanged`: boolean value to indicate whether the `theme-custom-css` setting has been changed;
   - `onLogoutCustomScriptChanged`: boolean value to indicate whether the `Custom_Script_On_Logout` setting has been changed;
   - `loggedOutCustomScriptChanged`: boolean value to indicate whether the `Custom_Script_Logged_Out` setting has been changed;
   - `loggedInCustomScriptChanged`: boolean value to indicate whether the `Custom_Script_Logged_In` setting has been changed;
   - `matrixBridgeEnabled`: boolean value to indicate whether the Matrix bridge has been enabled;

- Expand Apps Engine's environment variable allowed list ([#23870](https://github.com/RocketChat/Rocket.Chat/pull/23870) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Federation (Alpha Stabilization) ([#25457](https://github.com/RocketChat/Rocket.Chat/pull/25457))

- Fuselage ToastBar ([#25583](https://github.com/RocketChat/Rocket.Chat/pull/25583))

  ![Kapture 2022-05-20 at 14 50 19](https://user-images.githubusercontent.com/27704687/169584462-270e73aa-6dbe-4045-9847-d429125f15a6.gif)

- Get user's preferred language via apps ([#25514](https://github.com/RocketChat/Rocket.Chat/pull/25514))

- Marketplace new app details page ([#24711](https://github.com/RocketChat/Rocket.Chat/pull/24711))

  Change the app details page layout for the new marketplace UI. General Task: [MKP12   - New UI   - App Detail Page](https://app.clickup.com/t/1na769h)

  ## [MKP12   - Tab Navigation](https://app.clickup.com/t/2452f5u)
  New tab navigation layout for the app details page. Now the app details page is divided into three sections, details, logs, and settings, that can each be accessed through a Tabs fuselage component.

  Demo gif:
  ![tab_navigation_demo_gif](https://user-images.githubusercontent.com/43561537/157276436-3dab34c5-20da-4f5d-99d0-54c1c718ac1f.gif)

  ## [MKP12   - Header](https://app.clickup.com/t/25rhm0x)
  Implemented a new header for the marketplaces app details page.
  -Changed the size of the app name;
  -Implemented the app description field on the header;
  -Changed the "metadata" section of the header(The part with the version and author information) now it also shows the last time the app was updated;
  -Created a chip that will show when an app is part of one or more bundles and inform which are the bundles;
  -Implemented a tooltip for the bundle chips;
  -Created a new button + data badge component to substitute the current App Status;
  -Changed the title of the "purchase button". Now it shows different text based on the "purchase type" of the app;
  -Created a new Pricing & Status display which shows the price when the app is not bought/installed and shows the app status(Enabled/Disabled) when it is bought/installed;
  -Changed the way the tabs are rendered, now if the app is not installed(and consequently doesn't have logs and settings tab) it will not render these tabs;

  Demo gif:
  ![new-header-gif](https://user-images.githubusercontent.com/43561537/159064599-fd64dfe2-86a3-47da-81ba-1e83f1b87432.gif)

  ## [MKP12   - Configuration Tab](https://app.clickup.com/t/2452gh4)
  Delivered together with the tab-navigation task. Changed the app settings from the details of the app to the new settings tab.
  Demo image:
  ![New configuration tab](https://user-images.githubusercontent.com/43561537/160211324-95db0566-85bf-4dde-a814-3c6f23dcee4d.png)

  ## [MKP12   - Log Tab](https://app.clickup.com/t/2452gg1)
  Changed the place of the app logs from the page to the new logs tab. Also changed some styles of the logs accordions to fit better with the new container.

  Before:
  ![Before](https://user-images.githubusercontent.com/43561537/160210302-148ce584-604f-40ff-8209-141667016163.png)

  After
  ![After](https://user-images.githubusercontent.com/43561537/160210984-d4060c5a-f912-4ef9-87e3-fa459080e2d4.png)

  ## [MKP12   - Page Header](https://app.clickup.com/t/29b0b12)
  Changed the design for the page header of the app details page from a title on the left with a save and back button on the right to a back arrow icon on the left side of the title with the save button still on the right. Also changed the title of the page from App details to Back.
  Edit: After some design reconsideration, the page title was changed to App Info.
  Demo gif:
  ![new_page_header_app_details](https://user-images.githubusercontent.com/43561537/160937741-f5514f70-f43b-4400-8b2f-a5a26f95de9d.gif)

  ## [MKP12   - Detail Tab](https://app.clickup.com/t/2452gf7)
  Implemented markdown on the description section of the app details page, now the description will show the detailedDescription.rendered (as rendered JSX) information in case it exists and show the description (a.k.a. short description) information in case it doesn't. Unfortunately, as of right now no app has a visual example of a markdown description and because of that, I will not be able to provide a demo image/gif for this PR.

  ## [MKP12   - Slider Component](https://app.clickup.com/t/2452h26)
  Created an image carousel component on the app details page. This component receives images from the apps/appId/screenshots endpoint and shows them on the content section of the app details of any apps that have screenshots registered, if the app has no screenshots it simply shows nothing where the carousel should be. This component is complete with keyboard arrow navigation on the "open" carousel, hover highlight on the carousel preview and close on esc press.
  Demo gif:
  ![new_carousel_component](https://user-images.githubusercontent.com/43561537/167415212-9d8359c7-4132-4afa-a698-8be4ab1e1393.gif)

- Marketplace security tab app info page ([#25739](https://github.com/RocketChat/Rocket.Chat/pull/25739))

  Created a new security tab for installed apps that displays information related to the given app security policies, terms of services, and necessary permissions for the use of the app.
  Demo gif:
  ![privacy-tab](https://user-images.githubusercontent.com/43561537/173878394-333057d4-3c7e-434e-a3ca-d3e08f33c7bc.gif)

- Matrix Federation UX improvements ([#25847](https://github.com/RocketChat/Rocket.Chat/pull/25847) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- Message Template React Component ([#23971](https://github.com/RocketChat/Rocket.Chat/pull/23971))

  Complete rewrite of the messages component in react. Visual changes should be minimal as well as user impact, with no break changes (unless you've customized the blaze template).



  ![Screen Shot 2022-04-05 at 11 14 18](https://user-images.githubusercontent.com/27704687/161774027-38dd9c7b-eeeb-45e2-b9d8-ea2a9be8486d.png)
  In case you encounter any problems, or want to compare, temporarily it is possible to use the old version

  <img width="556" alt="image" src="https://user-images.githubusercontent.com/5263975/162099800-15806953-f2f5-4905-a424-3f095076bc1d.png">

- New button for network outage ([#25499](https://github.com/RocketChat/Rocket.Chat/pull/25499) by [@amolghode1981](https://github.com/amolghode1981))

  When network outage happens it should be conveyed to the user with special icon. This icon should not be clickable.
  Network outage handling is handled in https://app.clickup.com/t/245c0d8 task.

- New stats rewrite ([#25078](https://github.com/RocketChat/Rocket.Chat/pull/25078) by [@ostjen](https://github.com/ostjen))

  Add the following new statistics (**metrics**):


  - Total users with TOTP enabled;

  - Total users with 2FA enabled;

  - Total pinned messages;

  - Total starred messages;

  - Total email messages;

  - Total rooms with at least one starred message;

  - Total rooms with at least one pinned message;

  - Total encrypted rooms;

  - Total link invitations;

  - Total email invitations;

  - Logo change;

  - Number of rooms inside teams;

  - Number of default (auto-join) rooms inside teams;

  - Number of users created through link invitation;

  - Number of users created through manual entry;

  - Number of imported users (by import type);

- Star message, report and delete message events ([#25383](https://github.com/RocketChat/Rocket.Chat/pull/25383))

- Use setting to determine if initial general channel is needed ([#25441](https://github.com/RocketChat/Rocket.Chat/pull/25441) by [@felipe-menelau](https://github.com/felipe-menelau))

  - Adds flag responsible for overwriting #general channel creation

- VoIP Input/Output Device Selection ([#25966](https://github.com/RocketChat/Rocket.Chat/pull/25966) by [@amolghode1981](https://github.com/amolghode1981))

### 🚀 Improvements


- **ENTERPRISE:** Allow mapping LDAP groups to multiple RC roles ([#23849](https://github.com/RocketChat/Rocket.Chat/pull/23849))

  - Add support to mapping LDAP groups to multiple roles (by specifying arrays in the "User Data Group Map" enterprise setting.

- Add OTR Room States ([#24565](https://github.com/RocketChat/Rocket.Chat/pull/24565))

  Earlier OTR room uses only 2 states, we need more states to support future features.
  This adds more states for the OTR contextualBar.


  - Expired
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 52" src="https://user-images.githubusercontent.com/27704687/164283351-068756be-3419-4773-9d55-c9c1a72f5a19.png">


  - Declined
  <img width="343" alt='Screen Shot 2022-04-20 at 13 49 28' src='https://user-images.githubusercontent.com/27704687/164282312-fa3c6841-23d4-46e1-a8e9-80882a105d8c.png' />


  - Error
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 26" src="https://user-images.githubusercontent.com/27704687/164283261-95e06d06-b0d0-402d-bccc-66596ff4dcd3.png">

- Add tooltip to sidebar room menu ([#24405](https://github.com/RocketChat/Rocket.Chat/pull/24405) by [@Himanshu664](https://github.com/Himanshu664))

- add warnings for federation setup ([#25684](https://github.com/RocketChat/Rocket.Chat/pull/25684) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- Added MaxNickNameLength and MaxBioLength constants ([#25231](https://github.com/RocketChat/Rocket.Chat/pull/25231) by [@aakash-gitdev](https://github.com/aakash-gitdev))

- Added tooltip options for message menu ([#24431](https://github.com/RocketChat/Rocket.Chat/pull/24431) by [@Himanshu664](https://github.com/Himanshu664))

- Avoid using omnichannel-queue collection ([#25491](https://github.com/RocketChat/Rocket.Chat/pull/25491))

- Differ Voip calls from Incoming and Outgoing ([#25643](https://github.com/RocketChat/Rocket.Chat/pull/25643))

  Updated this column and its respective endpoints to support inbound/outfound call definitions
  ![image](https://user-images.githubusercontent.com/34130764/170512008-34202ed8-3ed4-4c28-baa5-25efc17543d5.png)

- Expand the feature set of the new message rendering ([#25970](https://github.com/RocketChat/Rocket.Chat/pull/25970))

  - Everything inside a new package (`@rocket.chat/gazzodown`);

  - KaTeX support;

  - Highlighted Words support;

  - Emoji rendering expanded;

  - Code rendering fixed

- Fix multiple bugs with Matrix bridge ([#25318](https://github.com/RocketChat/Rocket.Chat/pull/25318))

- Improve active/hover colors in account sidebar ([#25024](https://github.com/RocketChat/Rocket.Chat/pull/25024) by [@Himanshu664](https://github.com/Himanshu664))

- Moved call hold/unhold to EE ([#26007](https://github.com/RocketChat/Rocket.Chat/pull/26007))

  This PR adds a restriction, enabling the feature to hold/unhold calls only for Enterprise Edition users.

- Moved call wrap up modal to EE ([#25875](https://github.com/RocketChat/Rocket.Chat/pull/25875))

  This PR adds a restriction, enabling the feature to display the call wrap up modal only for Enterprise Edition users.

- New admin settings Page ([#25439](https://github.com/RocketChat/Rocket.Chat/pull/25439))

  ![Screen Shot 2022-05-09 at 11 31 58](https://user-images.githubusercontent.com/27704687/167432811-f4970f23-5dae-48a0-a427-92269d08a859.png)

- Pass allowDiskUse to channel aggregations on engagement dashboard ([#22374](https://github.com/RocketChat/Rocket.Chat/pull/22374))

- Performance for some Omnichannel features ([#25217](https://github.com/RocketChat/Rocket.Chat/pull/25217))

- Refactor + unit tests for federation-v2 ([#25680](https://github.com/RocketChat/Rocket.Chat/pull/25680))

  The main goal for this PR is to add the ability to add tests in our current federation-v2 implementation.
  In this PR, I've added only unit tests (80%), but the goal is to add other kinds of tests in the near future.

  Also, I've created a diagram to show how this refactor was done, and how is the structure of the code

  ![image](https://user-images.githubusercontent.com/15324204/171039619-22168000-3626-424e-b408-18dea540f786.png)

- Rename upgrade tab routes ([#25097](https://github.com/RocketChat/Rocket.Chat/pull/25097))

  Change 'upgrade tab' routes names from camelCase ('goFullyFeatured') to kebab-case ('go-fully-featured') due to URL naming consistency. Changed types, main function and test.

- Unify voip streams into single stream ([#25108](https://github.com/RocketChat/Rocket.Chat/pull/25108))

- VoIP admin page cleanup: remove unused settings ([#25993](https://github.com/RocketChat/Rocket.Chat/pull/25993))

  https://app.clickup.com/t/2n4m61m

### 🐛 Bug fixes


- `You and @yourUsername reacted with`title on reactions ([#25733](https://github.com/RocketChat/Rocket.Chat/pull/25733))

- Access issue on chat.getThreadsList ([#25750](https://github.com/RocketChat/Rocket.Chat/pull/25750))

- AccountBox checks for condition ([#25708](https://github.com/RocketChat/Rocket.Chat/pull/25708))

- Add katex render to new message react template ([#25239](https://github.com/RocketChat/Rocket.Chat/pull/25239))

- Add open user card to user avatar ([#25445](https://github.com/RocketChat/Rocket.Chat/pull/25445))

- Add reaction not working in legacy messages ([#25222](https://github.com/RocketChat/Rocket.Chat/pull/25222))

- Added invalid password error message ([#24714](https://github.com/RocketChat/Rocket.Chat/pull/24714) by [@Himanshu664](https://github.com/Himanshu664))

- Adjust email label in Setup Wizard i18n files ([#25260](https://github.com/RocketChat/Rocket.Chat/pull/25260))

  - remove 'Company' label on onboarding email keys in certain languages

- AgentOverview analytics wrong departmentId parameter ([#25073](https://github.com/RocketChat/Rocket.Chat/pull/25073) by [@paulobernardoaf](https://github.com/paulobernardoaf))

  When filtering the analytics charts by department, data would not appear because the object:
  ```js
  {
  value: "department-id",
  label: "department-name"
  }
  ```
  was being used in the `departmentId` parameter.


  - Before:
  ![image](https://user-images.githubusercontent.com/30026625/161832057-d96ffd21-a7dd-421e-bfaa-3b9f4a9127b2.png)


  - After:
  ![image](https://user-images.githubusercontent.com/30026625/161831092-9ee77b51-b083-4f45-9c48-ab2e0511c4d6.png)

- AgentsPage pagination ([#25820](https://github.com/RocketChat/Rocket.Chat/pull/25820))

- allow only livechat-agents to be contact manager for any omnichannel contact  ([#25451](https://github.com/RocketChat/Rocket.Chat/pull/25451))

- Append path To Route For Custom Emoji ([#24379](https://github.com/RocketChat/Rocket.Chat/pull/24379))

- Attachments and OEmbed margins ([#25713](https://github.com/RocketChat/Rocket.Chat/pull/25713))

- Broken Omnichannel>Agents page ([#25731](https://github.com/RocketChat/Rocket.Chat/pull/25731))

- Bump meteor-node-stubs to version 1.2.3 ([#25669](https://github.com/RocketChat/Rocket.Chat/pull/25669) by [@Sh0uld](https://github.com/Sh0uld))

  With meteor-node-stubs version 1.2.3 a bug was fixed, which occured in issue #25460 and probably #25513 (last one not tested).
  For the issue in meteor see: https://github.com/meteor/meteor/issues/11974

- Change form body parameter charset to UTF-8 to fix issue #25456 ([#25673](https://github.com/RocketChat/Rocket.Chat/pull/25673) by [@divinespear](https://github.com/divinespear))

  since [mscdex/busboy](https://github.com/mscdex/busboy) 1.5.0, new option named `defParamCharset` for form body parameter encoding is added with default value `latin1`, so unicode filenames are broken since 4.7.0.

  ![Screenshot from 2022-05-28 16-26-06](https://user-images.githubusercontent.com/126630/170815447-1f3bd579-243a-42d3-86f6-814aeaa30ce9.png)

- Change NPS Vote identifier + nps index to unique ([#25423](https://github.com/RocketChat/Rocket.Chat/pull/25423))

- Click to join button Jitsi Call ([#25569](https://github.com/RocketChat/Rocket.Chat/pull/25569))

  Added `ToolboxProvider` to `MessageListProvider` and fixed actionLink.js open function exec

- Client disconnection on network loss ([#25170](https://github.com/RocketChat/Rocket.Chat/pull/25170) by [@amolghode1981](https://github.com/amolghode1981))

  Agent gets disconnected (or Unregistered) from asterisk in multiple ways. The goal is that agent should remain online
  unless agent explicitly logs off.
  Agent can stop receiving calls in multiple ways due to network loss. Network loss can happen in following ways.

  1. User tries to switch the network. User experiences a glitch of disconnectivity. This can be simulated by turning the network off
  in the network tab of chrome's dev tool. This can disconnect the UA if the disconnection happens just before the registration refresh.

  2. Second reason is when computer goes in sleep mode.

  3. Third reason is that when asterisk is crashed/in maintenance mode/explicitly stopped.

  Solution:
  The idea is to detect the network disconnection and start the start the attempts to reconnect.
  The detection of the disconnection does not happen in case#1. The SIPUA's UserAgent transport does not
  call onDisconnected when network loss of such kind happens. To tackle this problem, window's online and offline event handlers are
  used.

  The number of retries is configurable but ideally it is to be kept at -1. Whenever disconnection happens, it should keep on trying to
  reconnect with increasing backoff time. This behaviour is useful when the asterisk is stopped.

  When the server is disconnected, it should be indicated on the phone button.

- Client-generated sort parameters in channel directory  ([#25768](https://github.com/RocketChat/Rocket.Chat/pull/25768) by [@BenWiederhake](https://github.com/BenWiederhake))

- Close room when dismiss wrap up call modal ([#25056](https://github.com/RocketChat/Rocket.Chat/pull/25056))

- Custom emoji reaction size ([#25393](https://github.com/RocketChat/Rocket.Chat/pull/25393))

- Custom sound error toast messages ([#24515](https://github.com/RocketChat/Rocket.Chat/pull/24515) by [@Himanshu664](https://github.com/Himanshu664))

- Deactivating user breaks if user is the only room owner ([#24933](https://github.com/RocketChat/Rocket.Chat/pull/24933) by [@sidmohanty11](https://github.com/sidmohanty11))

  ## Before

  https://user-images.githubusercontent.com/73601258/160000871-cfc2f2a5-2a59-4d27-8049-7754d003dd48.mp4



  ## After
  https://user-images.githubusercontent.com/73601258/159998287-681ab475-ff33-4282-82ff-db751c59a392.mp4

- Desktop notification on multi-instance environments ([#25220](https://github.com/RocketChat/Rocket.Chat/pull/25220))

- Direct Reply ([#22588](https://github.com/RocketChat/Rocket.Chat/pull/22588))

- Discussion alphabetical  ordering ([#25788](https://github.com/RocketChat/Rocket.Chat/pull/25788))

  Added a validation in the prop used for sorting (loweCaseName) checking for a prop that only exists in discussions (prid)

- Dynamic load matrix is enabled and handle failure  ([#25495](https://github.com/RocketChat/Rocket.Chat/pull/25495))

- End call button disappearing when on-hold ([#24936](https://github.com/RocketChat/Rocket.Chat/pull/24936))

- Error "numRequestsAllowed" property in rateLimiter for REST API endpoint when upgrading ([#26058](https://github.com/RocketChat/Rocket.Chat/pull/26058))

- Failure to update Integration History index ([#25473](https://github.com/RocketChat/Rocket.Chat/pull/25473))

- Fix max-width message block ([#25686](https://github.com/RocketChat/Rocket.Chat/pull/25686))

- Fix prom-client new promise usage ([#25781](https://github.com/RocketChat/Rocket.Chat/pull/25781))

- fixes HTML sanitizing error. ([#25410](https://github.com/RocketChat/Rocket.Chat/pull/25410))

  If the user sent a HTML message over our product to a livechat user the HTML would get rendered on the message box, this prevents it from happening.

- Fixing app contextual bar functionality ([#25615](https://github.com/RocketChat/Rocket.Chat/pull/25615))

- Fixing Network connectivity issues with SIP client. ([#25391](https://github.com/RocketChat/Rocket.Chat/pull/25391) by [@amolghode1981](https://github.com/amolghode1981))

  The previous PR https://github.com/RocketChat/Rocket.Chat/pull/25170 did not handle the issues completely.
  This PR is expected to handle

  1. Clearing call related UI when the network is disconnected or switched.

  2. Do clean connectivity. There were few issues discovered in earlier implementation. e.g endpoint would randomly
  get disconnected after a while. This was due to the fact that the earlier socket disconnection caused the
  removal of contact on asterisk. This should be fixed in this PR.

  3. This PR contains a lot of logs. This will be removed before the final merge.

- FormData uploads not working ([#25069](https://github.com/RocketChat/Rocket.Chat/pull/25069))

- Full error message is visible ([#24856](https://github.com/RocketChat/Rocket.Chat/pull/24856) by [@Himanshu664](https://github.com/Himanshu664))

- getUserMentionsByChannel method room permission ([#25748](https://github.com/RocketChat/Rocket.Chat/pull/25748))

- Importer fails to download files from URLs with query string params ([#25934](https://github.com/RocketChat/Rocket.Chat/pull/25934))

- Importer files are unnecessarily transferred over the network. ([#25919](https://github.com/RocketChat/Rocket.Chat/pull/25919))

- Incorrect websocket url in livechat widget ([#25261](https://github.com/RocketChat/Rocket.Chat/pull/25261))

- Initial members value on Create Channel Modal ([#26000](https://github.com/RocketChat/Rocket.Chat/pull/26000))

  #### before
  ![Screen Shot 2022-06-24 at 11 58 22](https://user-images.githubusercontent.com/27704687/175562315-221dbc9a-5695-4259-a8f7-644e2ff0ab36.png)

  #### after
  ![Screen Shot 2022-06-24 at 11 59 38](https://user-images.githubusercontent.com/27704687/175562510-a4a6be49-bbd2-4aeb-aedb-a5a7a6f1159d.png)

- Initial User not added to default channel ([#25544](https://github.com/RocketChat/Rocket.Chat/pull/25544))

  If injecting initial user.  The user wasn’t added to the default General channel

- Integrations avatar attribute misuse ([#25283](https://github.com/RocketChat/Rocket.Chat/pull/25283))

- Invitation links don't redirect to the registration form ([#25082](https://github.com/RocketChat/Rocket.Chat/pull/25082))

- Kebab menu clicking issue  ([#25869](https://github.com/RocketChat/Rocket.Chat/pull/25869))

- LDAP sync removing users from channels when multiple groups are mapped to it ([#25434](https://github.com/RocketChat/Rocket.Chat/pull/25434))

- Members selection field on creating team modal ([#25871](https://github.com/RocketChat/Rocket.Chat/pull/25871))

  - Fix: add members breaking when searching users

  ![image](https://user-images.githubusercontent.com/27704687/121788070-b792f700-cba0-11eb-92b9-5833e1213c74.png)

- Message menu action not working on legacy messages. ([#25148](https://github.com/RocketChat/Rocket.Chat/pull/25148))

- Message menu dropdown not working on Mobile Web ([#25616](https://github.com/RocketChat/Rocket.Chat/pull/25616))

- Message preview not available for queued chats ([#25092](https://github.com/RocketChat/Rocket.Chat/pull/25092))

- Messages spacing ([#25631](https://github.com/RocketChat/Rocket.Chat/pull/25631))

  Adding `sequential` prop to Message component from Fuselage

- Misaligned username on Room Info card for omnichannel chats ([#25331](https://github.com/RocketChat/Rocket.Chat/pull/25331))

- Not showing edit message button when blocking edit after N minutes ([#25724](https://github.com/RocketChat/Rocket.Chat/pull/25724) by [@matthias4217](https://github.com/matthias4217))

  Previously, in Rocketchat 4.7.0 and later,  as mentioned in https://github.com/RocketChat/Rocket.Chat/issues/25478, the edit button was not displayed on the interface in the minute after having sent a message. This is now fixed : messages can be edited right after sending them.

- NPS never finishing sending results ([#25067](https://github.com/RocketChat/Rocket.Chat/pull/25067))

- One of the triggers was not working correctly ([#25409](https://github.com/RocketChat/Rocket.Chat/pull/25409))

- Ordered and unordered list styles, Line breaks. ([#25494](https://github.com/RocketChat/Rocket.Chat/pull/25494))

  Also removed the message.md cache from server, since changes in the parser might break messages in the future (and will in this specific case).

- Pinned Message display cutting off information ([#25535](https://github.com/RocketChat/Rocket.Chat/pull/25535))

- Prevent federation crash on invite users as a non-owner user ([#25683](https://github.com/RocketChat/Rocket.Chat/pull/25683))

- Prevent sequential messages edited icon to hide on hover ([#24984](https://github.com/RocketChat/Rocket.Chat/pull/24984))

  ### before
  <img width="297" alt="Screen Shot 2022-03-29 at 13 35 56" src="https://user-images.githubusercontent.com/27704687/160661700-c2aebe05-a1be-4235-9d20-bce0b6e5fdb5.png">

  ### after
  <img width="300" alt="Screen Shot 2022-03-29 at 11 48 05" src="https://user-images.githubusercontent.com/27704687/160639208-3883a7b0-718a-4e9d-87b1-db960fe9bfcd.png">

- Proxy settings being ignored ([#25022](https://github.com/RocketChat/Rocket.Chat/pull/25022))

  Modify Meteor's `HTTP.call` to add back proxy support

- Quote message spacing ([#25613](https://github.com/RocketChat/Rocket.Chat/pull/25613))

- Read receipts show with color gray when not read yet ([#25244](https://github.com/RocketChat/Rocket.Chat/pull/25244))

- Read receipts showing before message read ([#25216](https://github.com/RocketChat/Rocket.Chat/pull/25216))

- Remove 'total' text in admin info page ([#25638](https://github.com/RocketChat/Rocket.Chat/pull/25638))

  - Remove initial 'total' text from rooms and messages groups in the admin info page

  - Add 'total' before 'rooms' and 'messages' title on the same section. To use the new 'Total Rooms', was created a new key in the en.i18n.json file.

- Remove duplicated icon bell when is thread main message ([#26051](https://github.com/RocketChat/Rocket.Chat/pull/26051))

- Remove duplicated property _USERNAMES from createDirectRoom.ts ([#26087](https://github.com/RocketChat/Rocket.Chat/pull/26087))

  This pull request removes the duplicated property `_USERNAMES` from `apps/meteor/app/lib/server/functions/createDirectRoom.ts`, using only the existing property `roomInfo.usernames`.

- Removing user also removes them from Omni collections ([#25444](https://github.com/RocketChat/Rocket.Chat/pull/25444))

- Replace encrypted text to Encrypted Message Placeholder ([#24166](https://github.com/RocketChat/Rocket.Chat/pull/24166))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/150807900-154a9cdb-ee13-4333-8628-f287ab914b40.png)

  ### after
  <img width="814" alt="Screenshot 2022-01-13 at 8 57 47 PM" src="https://user-images.githubusercontent.com/58601732/149359411-23e2430b-89e4-48b4-a3ad-65471d058551.png">

- Reply button behavior on broadcast channel ([#25175](https://github.com/RocketChat/Rocket.Chat/pull/25175))

  Hide reply button for the user that sent the message

- room creation fails if app framework is disabled ([#25200](https://github.com/RocketChat/Rocket.Chat/pull/25200))

- Rooms' names turn lower case on CSV import ([#24612](https://github.com/RocketChat/Rocket.Chat/pull/24612))

  * Change 'Settings' import to not get cached configs

  * Remove update `UI_Allow_room_names_with_special_chars` value

- Sanitize customUserStatus and fix infinite loop ([#25449](https://github.com/RocketChat/Rocket.Chat/pull/25449))

  ### Additional improves:

  - usage of RHF to avoid unnecessary Add and Edit components separately and form validation

  - usage of `GenericTableV2` and some hooks to avoid unnecessary code

  - fix `IUserStatus` type

  - improves in UI design

  - improves **empty** and **loading** state

  - improves files structure

  [LOOP ERROR ATTACHMENT]
  ![Screen Shot 2022-05-09 at 19 42 53](https://user-images.githubusercontent.com/27704687/167510439-1980461c-a885-46d2-9a49-79da432c7521.png)

- Sanitize styles in message ([#25744](https://github.com/RocketChat/Rocket.Chat/pull/25744))

- Settings listeners not receiving overwritten values from env vars ([#25448](https://github.com/RocketChat/Rocket.Chat/pull/25448))

- Settings not being overwritten to their default values ([#25891](https://github.com/RocketChat/Rocket.Chat/pull/25891))

- Showing Blank Message Inside Report ([#25007](https://github.com/RocketChat/Rocket.Chat/pull/25007))

  https://user-images.githubusercontent.com/53515714/161038085-4a86c7ae-6751-4996-9767-b1c9e0331a6c.mp4

- sidebar colors ([#25987](https://github.com/RocketChat/Rocket.Chat/pull/25987))

- Sort by scope or creation date not working on canned responses list ([#25475](https://github.com/RocketChat/Rocket.Chat/pull/25475))

- Spotlight results showing usernames instead of real names ([#25471](https://github.com/RocketChat/Rocket.Chat/pull/25471))

- Thread Message Preview ([#25709](https://github.com/RocketChat/Rocket.Chat/pull/25709))

- Too many watchers in dev environment. ([#25930](https://github.com/RocketChat/Rocket.Chat/pull/25930))

- Toolbox hiding under contextual bar ([#25237](https://github.com/RocketChat/Rocket.Chat/pull/25237))

- toolbox menu behind thread component ([#25925](https://github.com/RocketChat/Rocket.Chat/pull/25925))

- UI/UX issues on Live Chat widget ([#25407](https://github.com/RocketChat/Rocket.Chat/pull/25407))

- Unable to close chats when comments is disabled ([#26057](https://github.com/RocketChat/Rocket.Chat/pull/26057))

  Fixes https://github.com/RocketChat/Rocket.Chat/issues/25954

- Unable to see channel member list by authorized channel roles ([#25412](https://github.com/RocketChat/Rocket.Chat/pull/25412))

- Undefined headers on API Client ([#26083](https://github.com/RocketChat/Rocket.Chat/pull/26083))

- Unnecessary padding on teams channels footer ([#25712](https://github.com/RocketChat/Rocket.Chat/pull/25712))

  #### before
  <img width='320px' src='https://user-images.githubusercontent.com/27704687/171474795-2280a52c-b460-45f8-9b22-b61eb9d8075d.png' />

  ### after
  <img width='320px' src='https://user-images.githubusercontent.com/27704687/171475198-ee407192-95b2-44a4-9b55-374715078825.png' />

- Update chartjs usage to v3 ([#25873](https://github.com/RocketChat/Rocket.Chat/pull/25873))

- Update import from `csv-parse` ([#25872](https://github.com/RocketChat/Rocket.Chat/pull/25872))

  This PR updates the importing of `csv-parse` because the used method wasn't working anymore, we were receiving the following error:

  `error: "this.csvParser is not a function"`

- Update subscription on update team member ([#25855](https://github.com/RocketChat/Rocket.Chat/pull/25855))

  Added update to subscription when a team member is updated on `teams.updateMember`

- Upgrade tab loader in incorrect position ([#25398](https://github.com/RocketChat/Rocket.Chat/pull/25398))

  - Add invisible prop to iframe when loading state is active.

- Upgrade Tab showing for a split second ([#25050](https://github.com/RocketChat/Rocket.Chat/pull/25050))

- Use correct room property for call ended at ([#24932](https://github.com/RocketChat/Rocket.Chat/pull/24932))

- useCurrentChatTags is not a function ([#25604](https://github.com/RocketChat/Rocket.Chat/pull/25604))

- User abandonment setting was not working doe to failing event hook ([#25520](https://github.com/RocketChat/Rocket.Chat/pull/25520))

  A setting watcher and the query for grabbing abandoned chats were broken, now they're not.

- User avatar reseting and getting random image ([#25603](https://github.com/RocketChat/Rocket.Chat/pull/25603))

  - fixes user avatar not being saved after editing the user profile issue

  - fixes user avatar not getting another user picture due to database deletion error

- user status Offline misnamed as Invisible in Custom Status edit dropdown menu ([#24796](https://github.com/RocketChat/Rocket.Chat/pull/24796) by [@Kunalvrm555](https://github.com/Kunalvrm555))

- User's with non-agent role shown on voip agent association model ([#25682](https://github.com/RocketChat/Rocket.Chat/pull/25682))

- UserAutoComplete not rendering UserAvatar correctly ([#25055](https://github.com/RocketChat/Rocket.Chat/pull/25055))

  ### before
  ![Screen Shot 2022-04-04 at 16 50 21](https://user-images.githubusercontent.com/27704687/161620921-800bf66a-806d-4f83-b2e1-073c34215001.png)

  ### after
  ![Screen Shot 2022-04-04 at 16 49 00](https://user-images.githubusercontent.com/27704687/161620720-3e27774d-c241-46ca-b764-932a9295d709.png)

- UserCard sanitization ([#25089](https://github.com/RocketChat/Rocket.Chat/pull/25089))

  - Rewrites the component to TS

  - Fixes some visual issues

  ### before
  ![Screen Shot 2022-04-07 at 00 23 11](https://user-images.githubusercontent.com/27704687/162113925-5c9484d1-23e9-4623-8b86-3fbc71b461a1.png)

  ### after
  ![Screen Shot 2022-04-07 at 00 07 13](https://user-images.githubusercontent.com/27704687/162112353-afd6aac6-b27c-4470-a642-631b8080d59e.png)

- Users without the `view-other-user-info` permission can't use the `users.list` endpoint ([#26050](https://github.com/RocketChat/Rocket.Chat/pull/26050))

  This PR fix the query when a normal users access `users.list`

- Validate room access ([#24534](https://github.com/RocketChat/Rocket.Chat/pull/24534))

  The request must be blocked If the user has no permission to view rooms.

- Video and Audio not skipping forward ([#19866](https://github.com/RocketChat/Rocket.Chat/pull/19866))

- VOIP CallContext snapshot infinite loop ([#25947](https://github.com/RocketChat/Rocket.Chat/pull/25947))

  The application was crashing due to an error on the `useCallerInfo()` hook.
  The error was:
  ![image](https://user-images.githubusercontent.com/20212776/174823914-4832e5dd-c91a-4ae4-9d1f-1b960bcd372c.png)
  ![image](https://user-images.githubusercontent.com/20212776/174823982-cb543fe0-663f-4530-bb94-0720653ca897.png)

  To prevent this issue to happen it was added a cached and out-of-scope snapshot variable to the hook using `useSyncExternalStore`

- VoIP disabled/enabled  sequence puts voip agent in error state ([#25230](https://github.com/RocketChat/Rocket.Chat/pull/25230) by [@amolghode1981](https://github.com/amolghode1981))

  Initially it was thought that the issue occurs because of the race condition while changing the client settings vs those settings reflected on server side. So a natural solution to solve this is to wait for setting change event 'private-settings-changed'. Then if 'VoIP_Enabled' is updated and it is true, set voipEnabled  to true in useVoipClient.ts (on client side)

  It was realised that the race does not happen because of the database or server noticing the changes late. But because of the time taken to establish the AMI connection with Asterisk.

  Solution:


  1. Change apps/meteor/app/voip/server/startup.ts. When VoIP_Enabled is changed, await for Voip.init() to complete and then broadcast connector.statuschanged  with changed value.

  2. From apps/meteor/server/modules/listeners/listeners.module.ts use notifyLoggedInThisInstance to notify all logged in users on current instance.

  3. in apps/meteor/client/providers/CallProvider/hooks/useVoipClient.ts add the event handler that receives this event. Change voipEnabled from constant to state. Change this state based on the 'value' that is received by the handler.

- Voip endpoint permissions ([#25783](https://github.com/RocketChat/Rocket.Chat/pull/25783))

- Wrong argument name preventing Omnichannel Chat Forward to User  ([#25723](https://github.com/RocketChat/Rocket.Chat/pull/25723))

<details>
<summary>🔍 Minor changes</summary>


- Bump body-parser from 1.19.2 to 1.20.0 in /ee/server/services ([#25042](https://github.com/RocketChat/Rocket.Chat/pull/25042) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ejson from 2.2.1 to 2.2.2 ([#25057](https://github.com/RocketChat/Rocket.Chat/pull/25057) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump eslint-plugin-anti-trojan-source from 1.0.6 to 1.1.0 ([#25076](https://github.com/RocketChat/Rocket.Chat/pull/25076) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump minimist from 1.2.5 to 1.2.6 in /ee/server/services ([#24991](https://github.com/RocketChat/Rocket.Chat/pull/24991) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino and pino-pretty ([#25052](https://github.com/RocketChat/Rocket.Chat/pull/25052))

- Bump template-file from 6.0.0 to 6.0.1 ([#25002](https://github.com/RocketChat/Rocket.Chat/pull/25002) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: `@rocket.chat/favicon` ([#25920](https://github.com/RocketChat/Rocket.Chat/pull/25920))

- Chore: `refactor/tsc-perf` ([#26040](https://github.com/RocketChat/Rocket.Chat/pull/26040))

- Chore: Account/Profile to TS ([#25929](https://github.com/RocketChat/Rocket.Chat/pull/25929))

- Chore: add _id and name options to JSON Schemas ([#25813](https://github.com/RocketChat/Rocket.Chat/pull/25813))

  This pull request adds the `roomId` and `roomName` options for the Ajv JSON Schemas on the `packages/rest-typings/src/v1/channels/` and `packages/rest-typings/src/v1/dm/` folders.

- Chore: Add /v1/video-conference endpoint types ([#25278](https://github.com/RocketChat/Rocket.Chat/pull/25278))

- Chore: Add Agenda fork to the monorepo ([#25681](https://github.com/RocketChat/Rocket.Chat/pull/25681))

- Chore: add Ajv JSON Schema to api/v1 ([#25601](https://github.com/RocketChat/Rocket.Chat/pull/25601))

  This pull request adds Ajv JSON Schema validation to `apps/meteor/app/api/server/v1/` and `packages/rest-typings/src/v1/`, where needed.

- Chore: Add auto label and improve Kodiak configuration ([#25829](https://github.com/RocketChat/Rocket.Chat/pull/25829))

- Chore: Add channel endpoints (rest-typings) ([#25279](https://github.com/RocketChat/Rocket.Chat/pull/25279))

- Chore: Add client folder to CODEOWNERS  ([#25397](https://github.com/RocketChat/Rocket.Chat/pull/25397))

- Chore: Add error boundary to message component ([#25223](https://github.com/RocketChat/Rocket.Chat/pull/25223))

  Not crash the whole application if something goes wrong in the MessageList component.

  ![image](https://user-images.githubusercontent.com/40830821/162269915-931c5c3c-c979-4234-b74c-371f67467ce0.png)

- Chore: Add Livechat repo into Monorepo packages ([#25312](https://github.com/RocketChat/Rocket.Chat/pull/25312))

- Chore: Add missing Swedish livechat translations ([#26048](https://github.com/RocketChat/Rocket.Chat/pull/26048) by [@joakimaho](https://github.com/joakimaho))

  Added missing Swedish translations.

- Chore: Add options to debug stdout and rate limiter ([#25336](https://github.com/RocketChat/Rocket.Chat/pull/25336))

- Chore: Add root package.json to houston files ([#25286](https://github.com/RocketChat/Rocket.Chat/pull/25286))

  See title

- Chore: Add tests for agents screens ([#25637](https://github.com/RocketChat/Rocket.Chat/pull/25637) by [@weslley543](https://github.com/weslley543))

- Chore: Add typings for /v1/webdav.getMyAccounts ([#25276](https://github.com/RocketChat/Rocket.Chat/pull/25276))

- Chore: Add yarn plugin to check node and yarn version ([#25224](https://github.com/RocketChat/Rocket.Chat/pull/25224))

- Chore: Adding default message parser template ([#26064](https://github.com/RocketChat/Rocket.Chat/pull/26064))

- Chore: adjust in some configurations ([#25612](https://github.com/RocketChat/Rocket.Chat/pull/25612) by [@weslley543](https://github.com/weslley543))

- Chore: Allow endpoints to optionally require authentication ([#26084](https://github.com/RocketChat/Rocket.Chat/pull/26084))

- Chore: API test on method GET with params as a number. ([#25769](https://github.com/RocketChat/Rocket.Chat/pull/25769))

- Chore: AutoTranslate contextualBar rewrite ([#25751](https://github.com/RocketChat/Rocket.Chat/pull/25751))

- Chore: Avoid set useless set UTC Offset ([#26270](https://github.com/RocketChat/Rocket.Chat/pull/26270))

- Chore: Avoid unneeded permission updates when EE license is applied ([#26253](https://github.com/RocketChat/Rocket.Chat/pull/26253))

- Chore: Broken Storybook ([#25714](https://github.com/RocketChat/Rocket.Chat/pull/25714))

  There is another small improvement on the way we got storybook files.

- Chore: Bump deps ([#25624](https://github.com/RocketChat/Rocket.Chat/pull/25624))

- Chore: bump fuselage ([#25605](https://github.com/RocketChat/Rocket.Chat/pull/25605))

- Chore: Bump fuselage ([#25371](https://github.com/RocketChat/Rocket.Chat/pull/25371))

- Chore: Bump fuselage and update icon ([#26036](https://github.com/RocketChat/Rocket.Chat/pull/26036))

- Chore: bump fuselage packages ([#26325](https://github.com/RocketChat/Rocket.Chat/pull/26325))

- Chore: Bump Fuselage packages ([#25259](https://github.com/RocketChat/Rocket.Chat/pull/25259))

- Chore: Cancel running jobs if PR is updated ([#24708](https://github.com/RocketChat/Rocket.Chat/pull/24708))

- Chore: Change Apps-Engine version source for info ([#26205](https://github.com/RocketChat/Rocket.Chat/pull/26205))

  Now that we're using `yarn`, the version stored in the `package.json` is no longer the resolved one, but it matches the input. This means that when we ran `yarn add @rocket.chat/apps-engine@alpha`, yarn saves `"alpha"` as the version of the package, while NPM added the resolved version for the tag, e.g. `"1.33.0-alpha.6507"`. This ends up breaking a few places where we need the Apps-Engine version for communication with the Marketplace.

  With this PR we change the source of that info so the problem doesn't happen anymore.

- Chore: Change stats to daily ([#26113](https://github.com/RocketChat/Rocket.Chat/pull/26113))

- Chore: Check for env var values and not just if they are set ([#26219](https://github.com/RocketChat/Rocket.Chat/pull/26219))

- Chore: Chore add validation option to rest endpoints ([#25443](https://github.com/RocketChat/Rocket.Chat/pull/25443))

- Chore: Close tooltip on click ([#26070](https://github.com/RocketChat/Rocket.Chat/pull/26070))

- Chore: Code Improvements for #25391 ([#25606](https://github.com/RocketChat/Rocket.Chat/pull/25606))

- Chore: Collect e2e coverage ([#25743](https://github.com/RocketChat/Rocket.Chat/pull/25743) by [@souzaramon](https://github.com/souzaramon))

- Chore: Colors ([#25969](https://github.com/RocketChat/Rocket.Chat/pull/25969))

- Chore: command's endpoints ([#25630](https://github.com/RocketChat/Rocket.Chat/pull/25630))

- Chore: Convert `UserStatusMenu` to TS ([#25265](https://github.com/RocketChat/Rocket.Chat/pull/25265))

- Chore: Convert additionalForms ([#25586](https://github.com/RocketChat/Rocket.Chat/pull/25586))

- Chore: Convert Admin -> Rooms to TS ([#25348](https://github.com/RocketChat/Rocket.Chat/pull/25348))

- Chore: Convert admin custom sound to tsx ([#25128](https://github.com/RocketChat/Rocket.Chat/pull/25128))

- Chore: Convert Admin/OAuthApps to TS ([#25277](https://github.com/RocketChat/Rocket.Chat/pull/25277))

  - Converts Admin/OAuthApps to TS.

  - migrated forms to react-hook-form

- Chore: Convert AdminSideBar to ts ([#25372](https://github.com/RocketChat/Rocket.Chat/pull/25372))

- Chore: convert apps/meteor/app/api/server/lib/ files to TS ([#25840](https://github.com/RocketChat/Rocket.Chat/pull/25840))

  This pull request converts files on `apps/meteor/app/api/server/lib/` to Typescript.

- Chore: Convert apps/meteor/client/components/UserAutoComplete ([#25554](https://github.com/RocketChat/Rocket.Chat/pull/25554))

- Chore: Convert apps/meteor/client/sidebar/header/index ([#25671](https://github.com/RocketChat/Rocket.Chat/pull/25671))

- Chore: Convert apps/meteor/client/sidebar/search ([#25754](https://github.com/RocketChat/Rocket.Chat/pull/25754))

- Chore: Convert apps/meteor/client/views/admin/settings ([#25565](https://github.com/RocketChat/Rocket.Chat/pull/25565))

- Chore: Convert apps/meteor/client/views/admin/settings/inputs folder ([#25427](https://github.com/RocketChat/Rocket.Chat/pull/25427))

- Chore: Convert assets endpoint to Typescript ([#25358](https://github.com/RocketChat/Rocket.Chat/pull/25358))

- Chore: Convert AutoTranslate ([#25591](https://github.com/RocketChat/Rocket.Chat/pull/25591))

- Chore: Convert client/views/admin/settings/groups folder to ts ([#25345](https://github.com/RocketChat/Rocket.Chat/pull/25345))

- Chore: convert communication methods to Typescript ([#25503](https://github.com/RocketChat/Rocket.Chat/pull/25503))

  Convert files from `apps/meteor/app/apps/server/communication/` to ts.

- Chore: Convert components/sidebar to TS ([#25429](https://github.com/RocketChat/Rocket.Chat/pull/25429))

- Chore: Convert Create Channel ([#25589](https://github.com/RocketChat/Rocket.Chat/pull/25589))

- Chore: Convert CreateChannelWithData ([#25667](https://github.com/RocketChat/Rocket.Chat/pull/25667))

- Chore: Convert customSounds folder to ts ([#25274](https://github.com/RocketChat/Rocket.Chat/pull/25274))

- Chore: Convert customUserStatus folder to ts ([#25288](https://github.com/RocketChat/Rocket.Chat/pull/25288))

- Chore: convert e2e to ts ([#25958](https://github.com/RocketChat/Rocket.Chat/pull/25958))

  Converted the `apps/meteor/app/api/server/v1/e2e.js` to ts and created endpoint typings on the `packages/rest-typings/src/v1/e2e` folder.

- Chore: Convert email inbox feature to TypeScript ([#25298](https://github.com/RocketChat/Rocket.Chat/pull/25298) by [@ujorgeleite](https://github.com/ujorgeleite))

- Chore: Convert federationDashboard folder to ts ([#25343](https://github.com/RocketChat/Rocket.Chat/pull/25343))

- Chore: Convert getStatistics ([#25342](https://github.com/RocketChat/Rocket.Chat/pull/25342))

- Chore: convert import.js endpoints to TS ([#25956](https://github.com/RocketChat/Rocket.Chat/pull/25956))

  Converted the `apps/meteor/app/api/server/v1/import.js` to ts and created endpoint typings on the `packages/rest-typings/src/v1/import` folder.

- Chore: convert info to typescript ([#25420](https://github.com/RocketChat/Rocket.Chat/pull/25420))

- Chore: convert invites, misc and subscriptions to TS and create definitions ([#25350](https://github.com/RocketChat/Rocket.Chat/pull/25350))

  Converted `apps/meteor/app/api/server/v1/invites.js`, `misc.js` and `subscriptions.js` to Typescript and created their endpoint definitions on the rest-typings folder.

- Chore: Convert LivechatAgentActivity to raw model and TS ([#25123](https://github.com/RocketChat/Rocket.Chat/pull/25123))

- Chore: Convert Mailer to TS ([#25121](https://github.com/RocketChat/Rocket.Chat/pull/25121))

- Chore: convert marketplace price display component to use typescript ([#25504](https://github.com/RocketChat/Rocket.Chat/pull/25504) by [@matheuslc](https://github.com/matheuslc))

  **Marketplace apps listing page**
  ![Screen Shot 2022-05-13 at 12 57 43](https://user-images.githubusercontent.com/4161171/168322189-67990fdf-a447-46dc-8f88-08b16c2a5416.png)

  **Apps detail page**
  ![Screen Shot 2022-05-13 at 12 58 56](https://user-images.githubusercontent.com/4161171/168322241-505ee5bb-d3d8-4b0e-8757-873a1a65a6a6.png)

- Chore: Convert MemoizedSetting, Setting, Section ([#25572](https://github.com/RocketChat/Rocket.Chat/pull/25572))

- Chore: Convert normalizeMessagesForUser ([#26059](https://github.com/RocketChat/Rocket.Chat/pull/26059))

- Chore: Convert NotificationStatus to TS ([#25125](https://github.com/RocketChat/Rocket.Chat/pull/25125))

- Chore: Convert push endpoints to TS ([#25347](https://github.com/RocketChat/Rocket.Chat/pull/25347))

- Chore: Convert RoomForeword, TextCopy and RoomAvatarEditor to TS ([#25424](https://github.com/RocketChat/Rocket.Chat/pull/25424))

- Chore: Convert RoomMenu ([#25914](https://github.com/RocketChat/Rocket.Chat/pull/25914))

- Chore: Convert sidebar/header/actions ([#25581](https://github.com/RocketChat/Rocket.Chat/pull/25581))

- Chore: Convert sidebar/item ([#25634](https://github.com/RocketChat/Rocket.Chat/pull/25634))

- Chore: Convert slashCommands to typescript ([#25592](https://github.com/RocketChat/Rocket.Chat/pull/25592) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Chore: Convert to TS omnichannel/agent ([#25511](https://github.com/RocketChat/Rocket.Chat/pull/25511))

- Chore: Convert to TS RoomAutoComplete ([#25536](https://github.com/RocketChat/Rocket.Chat/pull/25536))

- Chore: Convert to typescript some functions from app/lib/server/functions ([#24519](https://github.com/RocketChat/Rocket.Chat/pull/24519))

  Convert to typescript some functions from app/lib/server/functions and transfered theses files to server/lib

- Chore: Convert to typescript the slash commands help files ([#24307](https://github.com/RocketChat/Rocket.Chat/pull/24307) by [@eduardofcabrera](https://github.com/eduardofcabrera))

  Convert to typescript the slash commands help files

- Chore: Convert useFileInput to TS ([#25426](https://github.com/RocketChat/Rocket.Chat/pull/25426))

- Chore: Convert usePreventDefault, useQueryOptions, useShortcutOpenMenu ([#26035](https://github.com/RocketChat/Rocket.Chat/pull/26035))

- Chore: Convert UserAutoCompleteMultiple ([#25587](https://github.com/RocketChat/Rocket.Chat/pull/25587))

- Chore: Convert users endpoints  ([#25635](https://github.com/RocketChat/Rocket.Chat/pull/25635))

- Chore: Convert useSidebarPaletteColor ([#26065](https://github.com/RocketChat/Rocket.Chat/pull/26065))

- Chore: Convert useUpdateAvatar to TS and type avatar endpoints ([#25430](https://github.com/RocketChat/Rocket.Chat/pull/25430))

- Chore: Converting files from app/livechat folder from JS to TS ([#25658](https://github.com/RocketChat/Rocket.Chat/pull/25658) by [@amolghode1981](https://github.com/amolghode1981))

  Converting files from apps/meteor/app/livechat/lib/ from JS to TS

- Chore: Converting omnichannel installation files to ts ([#25665](https://github.com/RocketChat/Rocket.Chat/pull/25665))

  This PR converts the omnichannel/installation folder from js to ts

- Chore: Converting orchestrator.js to ts ([#25367](https://github.com/RocketChat/Rocket.Chat/pull/25367))

- Chore: create a e2e test guideline ([#25884](https://github.com/RocketChat/Rocket.Chat/pull/25884) by [@souzaramon](https://github.com/souzaramon))

- Chore: Create a token for each action ([#26023](https://github.com/RocketChat/Rocket.Chat/pull/26023))

- Chore: Create README.md for Rest Typings ([#25335](https://github.com/RocketChat/Rocket.Chat/pull/25335))

- Chore: Custom Sounds Endpoints ([#25633](https://github.com/RocketChat/Rocket.Chat/pull/25633))

- Chore: Dedicated package for UI contexts ([#25432](https://github.com/RocketChat/Rocket.Chat/pull/25432))

  Moving our React contexts to a different package on the monorepo enable us to deliver components from another packages, because they work as a loose connection to the core APIs.

- Chore: Dependencies upgrade ([#25290](https://github.com/RocketChat/Rocket.Chat/pull/25290))

- Chore: Disabled icon colors on sidebar ([#26257](https://github.com/RocketChat/Rocket.Chat/pull/26257))

- Chore: Do not log integrations using `name` key ([#26163](https://github.com/RocketChat/Rocket.Chat/pull/26163))

- Chore: Enable marketplace screenshots endpoint ([#25395](https://github.com/RocketChat/Rocket.Chat/pull/25395) by [@matheuslc](https://github.com/matheuslc))

- Chore: ensure scripts use cross-env and ignore some dirs (ROC-54) ([#25218](https://github.com/RocketChat/Rocket.Chat/pull/25218) by [@souzaramon](https://github.com/souzaramon))

  - data and test-failure should be ignored

  - ensure scripts use cross-env

- Chore: Fix CI ([#25797](https://github.com/RocketChat/Rocket.Chat/pull/25797))

- Chore: Fix correct unit test to api files ([#25870](https://github.com/RocketChat/Rocket.Chat/pull/25870))

- Chore: Fix incorrect checksum for agenda package (cause of breaking develop builds) ([#25741](https://github.com/RocketChat/Rocket.Chat/pull/25741))

- Chore: Fix Omnichannel E2E tests not running ([#26092](https://github.com/RocketChat/Rocket.Chat/pull/26092))

- Chore: Fix return type warnings ([#25275](https://github.com/RocketChat/Rocket.Chat/pull/25275))

- Chore: Fix version on develop branch  ([#25842](https://github.com/RocketChat/Rocket.Chat/pull/25842))

- Chore: fix watermark condition ([#26095](https://github.com/RocketChat/Rocket.Chat/pull/26095))

- Chore: Fixes e2e playwright intermittences ([#25984](https://github.com/RocketChat/Rocket.Chat/pull/25984) by [@souzaramon](https://github.com/souzaramon) & [@weslley543](https://github.com/weslley543))

- Chore: Fuselage update ([#26004](https://github.com/RocketChat/Rocket.Chat/pull/26004))

- Chore: Fuselage update ([#25983](https://github.com/RocketChat/Rocket.Chat/pull/25983))

- Chore: Handle errors on index creation ([#26094](https://github.com/RocketChat/Rocket.Chat/pull/26094))

- Chore: Hide deprecation query log on production ([#26188](https://github.com/RocketChat/Rocket.Chat/pull/26188))

- Chore: Improve CI cache ([#25907](https://github.com/RocketChat/Rocket.Chat/pull/25907))

- Chore: Improve footer Template ([#26085](https://github.com/RocketChat/Rocket.Chat/pull/26085))

- Chore: Increase performance and security of integrations’ scripts ([#25641](https://github.com/RocketChat/Rocket.Chat/pull/25641))

  Replace internal VM implementation with VM2 which implements many more mechanisms to ensure timeout, security and allow easier configuration for future improvements on the integrations' feature.

- Chore: Info page ([#26201](https://github.com/RocketChat/Rocket.Chat/pull/26201))

- Chore: Introduce Modal Region ([#25962](https://github.com/RocketChat/Rocket.Chat/pull/25962))

- Chore: Introduce new index to query active livechat conversations for cloud scaling ([#26047](https://github.com/RocketChat/Rocket.Chat/pull/26047))

- Chore: Keep the option to run only the meteor app ([#25915](https://github.com/RocketChat/Rocket.Chat/pull/25915))

- Chore: Keyboard shortcuts contextualBar rewrite ([#25753](https://github.com/RocketChat/Rocket.Chat/pull/25753))

- Chore: Livechat change output level ([#25522](https://github.com/RocketChat/Rocket.Chat/pull/25522))

- Chore: Major refactors in pageobjects ([#26015](https://github.com/RocketChat/Rocket.Chat/pull/26015) by [@souzaramon](https://github.com/souzaramon))

- Chore: Make kodiak merge message empty ([#26069](https://github.com/RocketChat/Rocket.Chat/pull/26069))

- Chore: Manager Page Rewrite ([#25431](https://github.com/RocketChat/Rocket.Chat/pull/25431))

- Chore: Messages raw model rewrite to ts ([#25761](https://github.com/RocketChat/Rocket.Chat/pull/25761))

- Chore: Migrate 15-message-popup from cypress to playwright ([#25462](https://github.com/RocketChat/Rocket.Chat/pull/25462) by [@souzaramon](https://github.com/souzaramon))

- Chore: migrate from cypress to pw 14-setting-permission ([#25523](https://github.com/RocketChat/Rocket.Chat/pull/25523) by [@weslley543](https://github.com/weslley543))

- Chore: migrate katex to ts ([#25501](https://github.com/RocketChat/Rocket.Chat/pull/25501))

- Chore: Migrate LivechatVisitors model to raw ([#25756](https://github.com/RocketChat/Rocket.Chat/pull/25756))

- Chore: Migrate NotFoundPage to TS ([#25509](https://github.com/RocketChat/Rocket.Chat/pull/25509))

- Chore: Migrate oauth2server to typescript ([#25126](https://github.com/RocketChat/Rocket.Chat/pull/25126))

- Chore: Migrate oembed to ts ([#25622](https://github.com/RocketChat/Rocket.Chat/pull/25622))

- Chore: Migrate retention-policy to ts ([#25582](https://github.com/RocketChat/Rocket.Chat/pull/25582))

- Chore: Migrate some small helper functions to TypeScript ([#25666](https://github.com/RocketChat/Rocket.Chat/pull/25666))

- Chore: Migrate spotify to ts ([#25507](https://github.com/RocketChat/Rocket.Chat/pull/25507))

- Chore: migrate-to-pw-16-discussion ([#25567](https://github.com/RocketChat/Rocket.Chat/pull/25567) by [@weslley543](https://github.com/weslley543))

- Chore: migrate-to-pw-adjust-in-intermitences ([#25542](https://github.com/RocketChat/Rocket.Chat/pull/25542) by [@weslley543](https://github.com/weslley543))

- Chore: Minor dependency updates ([#25269](https://github.com/RocketChat/Rocket.Chat/pull/25269))

- Chore: Missing keys in APIsDisplay ([#24464](https://github.com/RocketChat/Rocket.Chat/pull/24464))

- Chore: Model Typings ([#25758](https://github.com/RocketChat/Rocket.Chat/pull/25758))

- Chore: Monorepo  ([#25074](https://github.com/RocketChat/Rocket.Chat/pull/25074))

- Chore: Move admin sidebarItems registration to the main file ([#25442](https://github.com/RocketChat/Rocket.Chat/pull/25442))

- Chore: Move ddp-streamer micro service to its own sub-repo ([#25246](https://github.com/RocketChat/Rocket.Chat/pull/25246))

- Chore: move definitions to packages ([#25085](https://github.com/RocketChat/Rocket.Chat/pull/25085))

- Chore: move fork of cas module to the monorepo ([#26107](https://github.com/RocketChat/Rocket.Chat/pull/26107))

- Chore: Move markdown message parser to a `callback` ([#25413](https://github.com/RocketChat/Rocket.Chat/pull/25413))

- Chore: Move voip's Wrap-up and On-hold functionality to EE (Backend) ([#25160](https://github.com/RocketChat/Rocket.Chat/pull/25160))

- Chore: Notification Preferences to TS ([#25827](https://github.com/RocketChat/Rocket.Chat/pull/25827))

  - Notifications Preferences to TS.

  - Fix broken save action.

- Chore: organize test files and fix code coverage ([#24900](https://github.com/RocketChat/Rocket.Chat/pull/24900))

- Chore: Plan tag ([#26224](https://github.com/RocketChat/Rocket.Chat/pull/26224))

  Now we only have one plan tag for all plans \/
  ![image](https://user-images.githubusercontent.com/40830821/178366367-12388c4c-6822-4e41-be8d-ca306718be98.png)

- Chore: Prune Messages contextualBar rewrite ([#25757](https://github.com/RocketChat/Rocket.Chat/pull/25757))

- Chore: Remove all cypress tests, configs and references ([#25564](https://github.com/RocketChat/Rocket.Chat/pull/25564) by [@souzaramon](https://github.com/souzaramon))

- Chore: Remove Alpine image deps after using them ([#25053](https://github.com/RocketChat/Rocket.Chat/pull/25053))

- Chore: Remove compose from main repo ([#23426](https://github.com/RocketChat/Rocket.Chat/pull/23426))

- Chore: Remove duplicate checksumBehavior key from yarn file ([#25730](https://github.com/RocketChat/Rocket.Chat/pull/25730))

- Chore: remove duplicated NotFoundPage.js ([#25749](https://github.com/RocketChat/Rocket.Chat/pull/25749))

- Chore: Remove duplicated useUserRoom ([#25180](https://github.com/RocketChat/Rocket.Chat/pull/25180))

- Chore: Remove Imperative Modal from context  ([#25911](https://github.com/RocketChat/Rocket.Chat/pull/25911))

- Chore: Remove old files from removed Omnichannel feature ([#25129](https://github.com/RocketChat/Rocket.Chat/pull/25129))

- Chore: Remove old rest api code ([#25863](https://github.com/RocketChat/Rocket.Chat/pull/25863))

- Chore: Remove package-lock.json from houston files ([#25280](https://github.com/RocketChat/Rocket.Chat/pull/25280))

  Houston config in the `package.json` file still mentioned `package-lock.json`, but it doesn't exist anymore

- Chore: Remove snap files from Houston config ([#25819](https://github.com/RocketChat/Rocket.Chat/pull/25819))

- Chore: Remove TimeSync usage ([#26294](https://github.com/RocketChat/Rocket.Chat/pull/26294))

- Chore: Remove toastr package ([#25787](https://github.com/RocketChat/Rocket.Chat/pull/25787))

- Chore: Remove unused Drone CI files ([#25124](https://github.com/RocketChat/Rocket.Chat/pull/25124))

- Chore: remove unused locators from e2e tests ([#25860](https://github.com/RocketChat/Rocket.Chat/pull/25860) by [@souzaramon](https://github.com/souzaramon))

- Chore: Remove unused migrations ([#26102](https://github.com/RocketChat/Rocket.Chat/pull/26102))

  After giving it some thought:


  - 234 through 240 are not going to be run anymore. Keeping them does not affect behavior of course, but this (removing) makes it easier to quickly glance at and understand what migrations are actually included in 5.x.y (especially in tag compare view or in general just checking the ref).


  - Also changed the file name of 233 to be more explicit at what it does so to not confuse with actual "migrations" without having to open the file.


  - The redirect to the documentation page (go.rocket....) is not yet set up, jfyi.

- Chore: Reorder unreleased migrations ([#25508](https://github.com/RocketChat/Rocket.Chat/pull/25508))

- Chore: Replace `useSubscription` with `useSyncExternalStore` ([#25909](https://github.com/RocketChat/Rocket.Chat/pull/25909))

- Chore: Replace AnnouncementModal in favor of GenericModal ([#25752](https://github.com/RocketChat/Rocket.Chat/pull/25752))

- Chore: Rest API query parameters handling ([#25648](https://github.com/RocketChat/Rocket.Chat/pull/25648))

- Chore: REST query and body params validation ([#25446](https://github.com/RocketChat/Rocket.Chat/pull/25446))

- Chore: RestApiClient as Package ([#25469](https://github.com/RocketChat/Rocket.Chat/pull/25469))

- Chore: Revert `yarn dev` implementation ([#26075](https://github.com/RocketChat/Rocket.Chat/pull/26075))

- Chore: Rewrite 2fa to typescript ([#25285](https://github.com/RocketChat/Rocket.Chat/pull/25285))

- Chore: Rewrite action-links to ts ([#25418](https://github.com/RocketChat/Rocket.Chat/pull/25418))

- Chore: Rewrite AddUsers to TS ([#25830](https://github.com/RocketChat/Rocket.Chat/pull/25830))

- Chore: Rewrite Admin UsersTable to Typescript ([#25698](https://github.com/RocketChat/Rocket.Chat/pull/25698))

- Chore: Rewrite autotranslate to ts ([#25425](https://github.com/RocketChat/Rocket.Chat/pull/25425))

- Chore: Rewrite im and dm endpoints to ts ([#25521](https://github.com/RocketChat/Rocket.Chat/pull/25521))

  - Endpoints rewritten to TS
    - dm.create
    - dm.delete
    - dm.close
    - dm.counters
    - dm.files
    - dm.history
    - dm.members
    - dm.messages
    - dm.messages.others
    - dm.list
    - dm.list.everyone
    - dm.open
    - dm.setTopic
    - im.create
    - im.delete
    - im.close
    - im.counters
    - im.files
    - im.history
    - im.members
    - im.messages
    - im.messages.others
    - im.list
    - im.list.everyone
    - im.open
    - im.setTopic

  - Some lines of code was refactored on `apps/meteor/app/api/server/v1/im.ts`

  - Unnecessary functions were deleted on `apps/meteor/app/lib/server/functions/getDirectMessageByNameOrIdWithOptionToJoin.ts`

  - New types was added on `apps/meteor/app/api/server/api.d.ts`

- Chore: Rewrite Jitsi Contextualbar to TS ([#25303](https://github.com/RocketChat/Rocket.Chat/pull/25303))

- Chore: Rewrite mail-messages to ts ([#25421](https://github.com/RocketChat/Rocket.Chat/pull/25421))

- Chore: Rewrite RoomWithData ([#25858](https://github.com/RocketChat/Rocket.Chat/pull/25858))

- Chore: Rewrite some Omnichannel files to TypeScript ([#25359](https://github.com/RocketChat/Rocket.Chat/pull/25359))

  apps/meteor/client/components/Omnichannel/modals/*
  apps/meteor/client/components/Omnichannel/Tags.js

- Chore: Room access validation may be called without user information ([#26086](https://github.com/RocketChat/Rocket.Chat/pull/26086))

- Chore: RouteGroup for My Account sidebar  ([#25632](https://github.com/RocketChat/Rocket.Chat/pull/25632))

  Refactoring My Accounts routes. Allows to add "my account" routes for EE.

- Chore: Run tests on docker ([#25556](https://github.com/RocketChat/Rocket.Chat/pull/25556))

- Chore: Settings UI issue ([#26053](https://github.com/RocketChat/Rocket.Chat/pull/26053))

- Chore: Small fix on callProvider ([#25963](https://github.com/RocketChat/Rocket.Chat/pull/25963))

- Chore: solve yarn issues from env var ([#25468](https://github.com/RocketChat/Rocket.Chat/pull/25468))

- Chore: Split useUserInfoActions into small hooks ([#25747](https://github.com/RocketChat/Rocket.Chat/pull/25747))

- Chore: Sync with master ([#25284](https://github.com/RocketChat/Rocket.Chat/pull/25284))

- Chore: Taking out Blaze from routes with `MainLayout`  ([#25697](https://github.com/RocketChat/Rocket.Chat/pull/25697))

  While working with @guijun13 on the new homepage I saw we're still rendering a Blaze template even to just embedded components into `MainLayout`. This PR addresses it.

- Chore: Template to generate packages ([#25174](https://github.com/RocketChat/Rocket.Chat/pull/25174))

  ```
  npx hygen package new test
  ```

- Chore: Test for department screen ([#25696](https://github.com/RocketChat/Rocket.Chat/pull/25696) by [@weslley543](https://github.com/weslley543))

- Chore: test turbo params ([#26038](https://github.com/RocketChat/Rocket.Chat/pull/26038))

- Chore: Testing Kodiak feature ([#25794](https://github.com/RocketChat/Rocket.Chat/pull/25794))

- Chore: Tests refactor pageobjects ([#26245](https://github.com/RocketChat/Rocket.Chat/pull/26245) by [@souzaramon](https://github.com/souzaramon) & [@weslley543](https://github.com/weslley543))

- Chore: Tests with Playwright (task: All works) ([#25122](https://github.com/RocketChat/Rocket.Chat/pull/25122) by [@weslley543](https://github.com/weslley543))

- Chore: Tests with Playwright (task: ROC-25, 06-message) ([#25252](https://github.com/RocketChat/Rocket.Chat/pull/25252) by [@weslley543](https://github.com/weslley543))

- Chore: Tests with Playwright (task: ROC-28, 09-channels) ([#25196](https://github.com/RocketChat/Rocket.Chat/pull/25196))

- Chore: Tests with Playwright (task: ROC-31, 12-settings) ([#25253](https://github.com/RocketChat/Rocket.Chat/pull/25253) by [@souzaramon](https://github.com/souzaramon))

- Chore: Tests with Playwright (task: ROC-66, Intermittent resolution in tests) ([#25416](https://github.com/RocketChat/Rocket.Chat/pull/25416) by [@souzaramon](https://github.com/souzaramon) & [@weslley543](https://github.com/weslley543))

- Chore: Translate admin helpers to TS ([#25690](https://github.com/RocketChat/Rocket.Chat/pull/25690))

- Chore: TS conversion folder client ([#25031](https://github.com/RocketChat/Rocket.Chat/pull/25031))

- Chore: TS migration SortList ([#25167](https://github.com/RocketChat/Rocket.Chat/pull/25167))

- Chore: ui-client package ([#25916](https://github.com/RocketChat/Rocket.Chat/pull/25916))

- Chore: Update Apps-Engine and Fuselage ([#25700](https://github.com/RocketChat/Rocket.Chat/pull/25700))

- Chore: Update Apps-Engine version ([#25617](https://github.com/RocketChat/Rocket.Chat/pull/25617))

- Chore: Update Apps-Engine version ([#26258](https://github.com/RocketChat/Rocket.Chat/pull/26258))

  Bumping Apps-Engine version

- Chore: update avatar colors ([#26153](https://github.com/RocketChat/Rocket.Chat/pull/26153))

- Chore: Update Livechat to the last version ([#25257](https://github.com/RocketChat/Rocket.Chat/pull/25257))

- Chore: Update Livechat version ([#25130](https://github.com/RocketChat/Rocket.Chat/pull/25130))

- Chore: Update Meteor 2.7.3 ([#25991](https://github.com/RocketChat/Rocket.Chat/pull/25991))

- Chore: update OTR icon ([#24521](https://github.com/RocketChat/Rocket.Chat/pull/24521) by [@kibonusp](https://github.com/kibonusp))

  I changed the shredder icon in OTR contextual bar to the stopwatch icon, recently added to the fuselage.

- Chore: Update package.json update tsc memory  ([#25755](https://github.com/RocketChat/Rocket.Chat/pull/25755))

- Chore: update pageobjects to use es6 getters and remove export default ([#25867](https://github.com/RocketChat/Rocket.Chat/pull/25867) by [@souzaramon](https://github.com/souzaramon))

- Chore: Update poplib ([#25964](https://github.com/RocketChat/Rocket.Chat/pull/25964))

- Chore: Update useSidebarPalette selectors ([#26322](https://github.com/RocketChat/Rocket.Chat/pull/26322))

- Chore: Update Volta configuration ([#25394](https://github.com/RocketChat/Rocket.Chat/pull/25394))

  [Volta](https://volta.sh/) need some extra configuration to work on monorepos.

- Chore: Updating Apps-Engine  ([#26001](https://github.com/RocketChat/Rocket.Chat/pull/26001))

- Chore: Upgrade and remove unnecessary Livechat dependencies ([#25672](https://github.com/RocketChat/Rocket.Chat/pull/25672))

- Chore: Upgrade Fuselage packages to `next` dist-tag ([#26274](https://github.com/RocketChat/Rocket.Chat/pull/26274))

  Upgrade Fuselage packages to the latest development versions.

- Chore: use params instead of URL building on livechat endpoints ([#25810](https://github.com/RocketChat/Rocket.Chat/pull/25810))

- Chore: User set UTC offset ([#25381](https://github.com/RocketChat/Rocket.Chat/pull/25381))

- Chore: VideoConference UX/UI Refactor 1st Interaction  ([#26183](https://github.com/RocketChat/Rocket.Chat/pull/26183))

- Chore: VoIP Context ([#25994](https://github.com/RocketChat/Rocket.Chat/pull/25994))

- Chore: Watch for package changes ([#25910](https://github.com/RocketChat/Rocket.Chat/pull/25910))

  With the current `dev` pipeline, whenever we modify a package (e.g. `api-client`), we have to kill the meteor proccess and run `yarn dev` again in order for the changes to be compiled and the new output to be used by meteor.

  This has the drawback of taking a little longer to run the dev environment, since we can't cache a watched buid. In the other hand, it reduces the friction of modifying internal packages since we don't need to rebuild the project for changes to take effect.

  This will enable us to move more things to separate packages without affecting the dev experience too much.

- Chore(deps): Bump sharp from 0.30.4 to 0.30.6 ([#25719](https://github.com/RocketChat/Rocket.Chat/pull/25719) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- i18n: Language update from LingoHub 🤖 on 2022-04-04Z ([#25043](https://github.com/RocketChat/Rocket.Chat/pull/25043))

- Merge master into develop & Set version to 4.7.0-develop ([#25028](https://github.com/RocketChat/Rocket.Chat/pull/25028))

- Merge master into develop & Set version to 5.0.0 ([#25702](https://github.com/RocketChat/Rocket.Chat/pull/25702) by [@felipe-menelau](https://github.com/felipe-menelau))

- Regression:  Admin Avatar Edit endpoint fix ([#26232](https://github.com/RocketChat/Rocket.Chat/pull/26232))

- Regression: [VideoConference] Callee client behaves improperly when accepting a call from someone who lost the connection ([#26101](https://github.com/RocketChat/Rocket.Chat/pull/26101))

  If the caller loses connection and the callee accepts the call anyway, the client will wait for five seconds for confirmation that they can join the call. This PR improves the UI behavior during those five seconds.

- Regression: [VideoConference] If the caller loses connection, direct calls are never canceled ([#26099](https://github.com/RocketChat/Rocket.Chat/pull/26099))

- Regression: `yarn dev` not working ([#26071](https://github.com/RocketChat/Rocket.Chat/pull/26071))

- Regression: Add `isPending` status to message ([#25299](https://github.com/RocketChat/Rocket.Chat/pull/25299))

- Regression: Add appId prop to slashcommand ([#25988](https://github.com/RocketChat/Rocket.Chat/pull/25988))

  Pass the appId when present to the slashcommand array. This avoid problems with contextual bar and modals not opening.

- Regression: Add better error messages when call fails ([#26134](https://github.com/RocketChat/Rocket.Chat/pull/26134))

- Regression: Add Error boundary to katex render component ([#26067](https://github.com/RocketChat/Rocket.Chat/pull/26067))

- Regression: Add eslint package to micro services Dockerfile ([#25311](https://github.com/RocketChat/Rocket.Chat/pull/25311))

- Regression: Add select message to system message and thread preview and allow select on legacy template ([#25251](https://github.com/RocketChat/Rocket.Chat/pull/25251))

- Regression: Add v1 to licenses.add endpoint ([#26311](https://github.com/RocketChat/Rocket.Chat/pull/26311))

- Regression: Added missing call button in the contact info contextual bar ([#26135](https://github.com/RocketChat/Rocket.Chat/pull/26135))

- Regression: Added missing call button to contact center calls list ([#26119](https://github.com/RocketChat/Rocket.Chat/pull/26119))

  This PR adds a call button to the contact center calls list rows.

- Regression: Adjusted priority to run canned responses replace before new parser ([#26298](https://github.com/RocketChat/Rocket.Chat/pull/26298))

  Canned responses placeholders were not being replaced properly after we changed to the new md parser.
  This fix changes the priority so that the canned responses replace logic runs before the parser, thus bringing back this functionality.

  Before:
  <img width="329" alt="Screen Shot 2022-07-18 at 19 25 07" src="https://user-images.githubusercontent.com/6494543/179627632-754f1269-c0bd-498e-b09c-aeb2942fcae3.png">

  After:
  <img width="329" alt="Screen Shot 2022-07-18 at 19 26 09" src="https://user-images.githubusercontent.com/6494543/179627663-d0e558fb-2d99-4afe-aec9-14a5d3afae06.png">

- Regression: Align TypeScript version across workspaces ([#26184](https://github.com/RocketChat/Rocket.Chat/pull/26184))

  Some places were still referring to TypeScript 4.3.4 instead of 4.5.5, so this PR targets it.

- Regression: All users in members list showing as federated ([#26129](https://github.com/RocketChat/Rocket.Chat/pull/26129))

- Regression: App event listeners broke Slackbridge integration and importers ([#25689](https://github.com/RocketChat/Rocket.Chat/pull/25689))

  Some event listeners triggered by Apps were calling `Meteor.user()` in functions that could run outside of Meteor environment

- Regression: Assets & Slack Bridge Setting Page not rendering ([#25629](https://github.com/RocketChat/Rocket.Chat/pull/25629))

- Regression: AutoTranslate on new message template ([#26049](https://github.com/RocketChat/Rocket.Chat/pull/26049))

- Regression: Avatar not loading on first direct message ([#25211](https://github.com/RocketChat/Rocket.Chat/pull/25211))

  fix avatar not loading on a first direct message

- Regression: Better MongoDB connection management for micro services ([#25323](https://github.com/RocketChat/Rocket.Chat/pull/25323))

- Regression: Broken components on Federation and Engagement dashboards ([#25653](https://github.com/RocketChat/Rocket.Chat/pull/25653))

  For reasons I've no clue, any client import path matching `**/data/**` will not be included in the final bundle, failing silently on transpiling/bundling.

- Regression: Broken emoji picker on Livechat ([#26128](https://github.com/RocketChat/Rocket.Chat/pull/26128))

- Regression: bump onboarding-ui version ([#25320](https://github.com/RocketChat/Rocket.Chat/pull/25320))

  - Bump to 'next' the onboarding-ui package from fuselage.

  - Update from 'companyEmail' to 'email' adminData usage types

- Regression: Burger menu showing arrow instead of burguer ([#26170](https://github.com/RocketChat/Rocket.Chat/pull/26170))

- Regression: Call toggle missing network disconnection state ([#26237](https://github.com/RocketChat/Rocket.Chat/pull/26237))

  This PR brings back the network disconnection state to the voip call toggle button

  ![image (4)](https://user-images.githubusercontent.com/6494543/178564719-f436505e-3ae3-4d69-ba5a-27ce8e8c5fba.png)

- Regression: Calling info on VoipFooter when performing an outbound call ([#26138](https://github.com/RocketChat/Rocket.Chat/pull/26138))

  ![image](https://user-images.githubusercontent.com/17487063/177395438-a0b2d30a-e0e2-4a31-9b55-2c6c3216bbd7.png)

- Regression: Cannot logout when CallProvider is unregistered and mounted ([#26158](https://github.com/RocketChat/Rocket.Chat/pull/26158))

- Regression: Cannot open Menu in searched message. ([#26172](https://github.com/RocketChat/Rocket.Chat/pull/26172))

- Regression: Change Audio settings for device settings as modal title ([#26159](https://github.com/RocketChat/Rocket.Chat/pull/26159))

- Regression: Change logic to check if connection is online on unstable networks ([#25618](https://github.com/RocketChat/Rocket.Chat/pull/25618))

- Regression: Change preference to be default legacy messages ([#25255](https://github.com/RocketChat/Rocket.Chat/pull/25255))

- Regression: Changing isEnterprise useQuery name to prevent conflict of queries ([#26116](https://github.com/RocketChat/Rocket.Chat/pull/26116))

  Changed the name of useQuery hook to prevent conflict of queries with same name.

- Regression: Channel `type` icon on Engagement Dashboard ([#26269](https://github.com/RocketChat/Rocket.Chat/pull/26269))

  This PR fixes a bug on which the channel type is inverted.

- Regression: CI playwright ([#25168](https://github.com/RocketChat/Rocket.Chat/pull/25168))

- Regression: CI services build ([#25555](https://github.com/RocketChat/Rocket.Chat/pull/25555))

- Regression: Clear user selection filter after selecting desired user. ([#26295](https://github.com/RocketChat/Rocket.Chat/pull/26295))

- Regression: Close button on modals created via apps not working ([#26127](https://github.com/RocketChat/Rocket.Chat/pull/26127))

- Regression: Contact manager edit/view not working ([#26155](https://github.com/RocketChat/Rocket.Chat/pull/26155))

  Basically, the Contact Center was working, but not the right way. This PR fixes:

  - Ability to select Contact Managers from dropdown

  - Ability to validate Contact Edits without requesting data a ton of times

  - Ability to remove Contact manager from a contact

  - Ability to see Contacts and Contact Managers on Contact View

  - Fix endpoints validation

  - Add validators (ajv) to endpoint, thou not being used yet (since we hit a special endpoint)

- Regression: Contact manager endpoint usage ([#26063](https://github.com/RocketChat/Rocket.Chat/pull/26063))

- Regression: Correct call ringtones ([#26111](https://github.com/RocketChat/Rocket.Chat/pull/26111))

  - outbound-call-ringing ringtone: Should be played when the outbound call is initiated and not yet established(Current implementation is playing the incoming-call ringtone)

  - call-ended ringtone: Should be played whenever a call ends.

- Regression: Device management table missing device icon and ip text ellipsis ([#26255](https://github.com/RocketChat/Rocket.Chat/pull/26255))

- Regression: Do not show federated tooltip on non-federated rooms ([#26115](https://github.com/RocketChat/Rocket.Chat/pull/26115))

- Regression: Docker image publish ([#25931](https://github.com/RocketChat/Rocket.Chat/pull/25931))

- Regression: Don't open mdm feature modal on registration page ([#26234](https://github.com/RocketChat/Rocket.Chat/pull/26234))

- Regression: Emojis displaying as `:undefined:` ([#26141](https://github.com/RocketChat/Rocket.Chat/pull/26141))

- Regression: Empty URL previews in messages. ([#26160](https://github.com/RocketChat/Rocket.Chat/pull/26160))

- Regression: Endpoint types with Ajv Coercing data types ([#25644](https://github.com/RocketChat/Rocket.Chat/pull/25644))

  Ajv Coercing data types should be `true` to accept all kinds of data requested.

- Regression: eslint not running on packages ([#25305](https://github.com/RocketChat/Rocket.Chat/pull/25305))

- Regression: Federated users not showing as federated in Room Members ([#26249](https://github.com/RocketChat/Rocket.Chat/pull/26249))

- Regression: fix `directory` endpoint not listing teams ([#26310](https://github.com/RocketChat/Rocket.Chat/pull/26310) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- Regression: Fix app icons breaking UI ([#26278](https://github.com/RocketChat/Rocket.Chat/pull/26278))

- Regression: fix apps path ([#25809](https://github.com/RocketChat/Rocket.Chat/pull/25809))

- Regression: Fix apps wrong typing ([#25824](https://github.com/RocketChat/Rocket.Chat/pull/25824))

- Regression: Fix assets format ([#26140](https://github.com/RocketChat/Rocket.Chat/pull/26140))

- Regression: Fix blackscreen after app install ([#25950](https://github.com/RocketChat/Rocket.Chat/pull/25950))

  Fixed an error where the client screen would go black after installing an app. This was hapenning because the handleAppAddedOrUpdated function from the AppsProvider had a wrong type for the return of the getAppFromMarketplace function.

  Demo gifs:

  Before
  ![app-install-error-before](https://user-images.githubusercontent.com/43561537/174861410-024dff74-b5d9-49ba-ae67-849f1ff239a9.gif)

  After:
  ![app-install-error-after](https://user-images.githubusercontent.com/43561537/174861448-58b071e6-8e1b-4391-b49a-44b68249acbf.gif)

- Regression: Fix breaking omnichannel tests ([#26305](https://github.com/RocketChat/Rocket.Chat/pull/26305))

- Regression: Fix call direction ([#26055](https://github.com/RocketChat/Rocket.Chat/pull/26055))

- Regression: Fix CI monorepo build ([#25107](https://github.com/RocketChat/Rocket.Chat/pull/25107))

- Regression: Fix clicking on visitor's chat in the sidebar does not display the chat window ([#25380](https://github.com/RocketChat/Rocket.Chat/pull/25380))

  Fix: livechat room not opening.

- Regression: Fix command previews ([#26199](https://github.com/RocketChat/Rocket.Chat/pull/26199))

  Fixes slash command previews not being showed

- Regression: Fix e2e CI ([#25974](https://github.com/RocketChat/Rocket.Chat/pull/25974))

- Regression: Fix English i18n react text ([#25368](https://github.com/RocketChat/Rocket.Chat/pull/25368))

  Incorrect text in reaction tooltip has been fixed

- Regression: Fix extended sidebar item ([#25887](https://github.com/RocketChat/Rocket.Chat/pull/25887))

- Regression: Fix federation Matrix bridge startup ([#25273](https://github.com/RocketChat/Rocket.Chat/pull/25273))

- Regression: Fix files list endpoints ([#26226](https://github.com/RocketChat/Rocket.Chat/pull/26226))

- Regression: Fix get myself user data ([#26328](https://github.com/RocketChat/Rocket.Chat/pull/26328))

- Regression: Fix import endpoints ([#26074](https://github.com/RocketChat/Rocket.Chat/pull/26074))

- Regression: Fix job Id not returned by agenda ([#26315](https://github.com/RocketChat/Rocket.Chat/pull/26315))

- Regression: Fix marketplace app apis visibility problem ([#26080](https://github.com/RocketChat/Rocket.Chat/pull/26080))

  Solved a problem that showed an unwanted zero in place of the APIs section for apps that weren't installed/did not have an APIs section.
  Before:
  ![image](https://user-images.githubusercontent.com/43561537/176743542-8f5d2e97-48e7-4947-a82a-43c3a15ea0ac.png)

  After(non installed app):
  ![image](https://user-images.githubusercontent.com/43561537/176744082-0139e15b-b03b-4c03-9267-9a17d14b70e9.png)

  After(installed app)
  ![image](https://user-images.githubusercontent.com/43561537/176772870-c5382edc-59e6-42e4-8dfa-f1e4fd0267c0.png)

- Regression: Fix marketplace releases tab crash bug ([#26162](https://github.com/RocketChat/Rocket.Chat/pull/26162))

  Fixed a bug where RC would crash because the marketplace releases tab was trying to display undefined data from manually installed apps.
  Demo gif:
  ![app-releases-tab-crash-error](https://user-images.githubusercontent.com/43561537/177656489-325790d3-49e0-46c8-8ac2-1f74c6a309ad.gif)

- Regression: Fix micro services ([#26054](https://github.com/RocketChat/Rocket.Chat/pull/26054))

- Regression: Fix micro services Docker build ([#25193](https://github.com/RocketChat/Rocket.Chat/pull/25193))

- Regression: Fix multi line is not showing an empty line between lines ([#25317](https://github.com/RocketChat/Rocket.Chat/pull/25317))

- Regression: Fix Omnichannel not working after meteor update ([#26194](https://github.com/RocketChat/Rocket.Chat/pull/26194))

  Fixed things:

  - Omnichannel Directory

  - Omnichannel Current Chats

  - Auto Selection Algo

  - Load Balance Algo

  - Manual Selection Algo

  - Livechat New Conversations

  Other fixed things:

  - Warning on fields deprecation

  - Warning on "remove" deprecation

  - Remove findAndModify usage

- Regression: Fix permissions page pagination ([#26304](https://github.com/RocketChat/Rocket.Chat/pull/26304))

- Regression: Fix rendered markdown styling on app info page details section ([#26093](https://github.com/RocketChat/Rocket.Chat/pull/26093))

  Fixed two styling problems on the AppDetails markdown. The first one was a misuse of flex and the second was the fact that the withRichContent flag was missing on the box that received the markdown.
  Demo images:
  Before:
  ![image](https://user-images.githubusercontent.com/43561537/177857346-54476879-2618-452f-8585-1922dcbfa9c1.png)

  After:
  ![image](https://user-images.githubusercontent.com/43561537/177857376-e96e4ad3-3410-4847-89b7-df074ff87b2f.png)

  Clickup task: https://app.clickup.com/t/2rwq0q7

- Regression: Fix reply button not working when hideFlexTab is enabled ([#25306](https://github.com/RocketChat/Rocket.Chat/pull/25306))

- Regression: Fix routing for public queue and visitor abandonment fiber usage ([#26233](https://github.com/RocketChat/Rocket.Chat/pull/26233))

- Regression: Fix scheduler not working ([#26242](https://github.com/RocketChat/Rocket.Chat/pull/26242))

- Regression: Fix services Docker build on CI ([#25181](https://github.com/RocketChat/Rocket.Chat/pull/25181))

- Regression: Fix services-image-build-check ([#25519](https://github.com/RocketChat/Rocket.Chat/pull/25519))

- Regression: Fix size of custom emoji and render emoji on thread message preview ([#25314](https://github.com/RocketChat/Rocket.Chat/pull/25314))

- Regression: Fix sort field files.list ([#25687](https://github.com/RocketChat/Rocket.Chat/pull/25687))

- Regression: Fix the alpine image and dev UX installing matrix-rust-sdk-bindings ([#25319](https://github.com/RocketChat/Rocket.Chat/pull/25319))

  The package only included a few pre-built which caused all macs to have to compile every time they installed and also caused our alpine not to work.

  This temporarily switches to a fork of the matrix-appservice-bridge package.

  Made changes to one of its child dependencies `matrix-rust-sdk-bindings` that adds pre-built binaries for mac and musl (for alpine).

- Regression: Fix threads list ([#26052](https://github.com/RocketChat/Rocket.Chat/pull/26052))

- Regression: Fix users.create call ([#25834](https://github.com/RocketChat/Rocket.Chat/pull/25834))

- Regression: Fix voip call wrap-up model not working ([#26024](https://github.com/RocketChat/Rocket.Chat/pull/26024))

- Regression: get user from `req` on `ui.interaction` endpoints ([#26256](https://github.com/RocketChat/Rocket.Chat/pull/26256))

- Regression: Inline code and copyonly tag styles ([#26173](https://github.com/RocketChat/Rocket.Chat/pull/26173))

- Regression: Invalid Voip host issue preventing agents connecting to asterisk ([#26056](https://github.com/RocketChat/Rocket.Chat/pull/26056))

- Regression: Last_login translation key ([#26203](https://github.com/RocketChat/Rocket.Chat/pull/26203))

- Regression: Link not scrolling to message ([#26073](https://github.com/RocketChat/Rocket.Chat/pull/26073))

- Regression: Livechat not rendering UiKit messages with action buttons ([#26327](https://github.com/RocketChat/Rocket.Chat/pull/26327))

- Regression: Livechat rooms not opening due to route desync ([#26209](https://github.com/RocketChat/Rocket.Chat/pull/26209))

  Due to route information only updating on `Tracker.afterFlush` (https://github.com/RocketChat/Rocket.Chat/pull/25990), we found out that calling the `tabBar.openUserInfo()` method at this point will cause a route change to the previous route instead of the current one, preventing livechat rooms from being opened.

  As a provisory solution, we're delaying the opening of the contextual bar, which then ensures that the route info is up to date. Although this solution works, we need to find a more reliable way of ensuring consistent route changes with up-to-date information.

  ### I'm definitely open for better looking alternatives. Please leave a comment if you have a better solution to share.

- Regression: Matrix Federation regressions ([#26283](https://github.com/RocketChat/Rocket.Chat/pull/26283) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- Regression: Messages in new message template Crashing. ([#25327](https://github.com/RocketChat/Rocket.Chat/pull/25327))

- Regression: Meteor uses `projection` for its observes ([#26223](https://github.com/RocketChat/Rocket.Chat/pull/26223))

- Regression: Missing settings group descriptions ([#25639](https://github.com/RocketChat/Rocket.Chat/pull/25639))

  <img width='100%' height='auto' src='https://user-images.githubusercontent.com/27704687/170372985-d849d71e-389b-49c0-a2b3-2bbd08d65c41.gif' />

- Regression: moving Community Watermark to  `ee` folder ([#26148](https://github.com/RocketChat/Rocket.Chat/pull/26148))

  Due to legal reasons, the Watermark used in community Edition was moved to Enterprise folder `ee`

- Regression: Non-reactive routes ([#25990](https://github.com/RocketChat/Rocket.Chat/pull/25990))

  When `Tracker.autorun()` calls are nested, it's possible that an invalidation at the parent render the children non-reactive due to synchronous calls. To avoid that under the callback given by `useSyncExternalStore`, we schedule an `onStoreChange` callback call to not make it reside at the same backtrace.

- Regression: Omni-chats not getting routed automatically to bots ([#26267](https://github.com/RocketChat/Rocket.Chat/pull/26267))

- Regression: Options overlapping input in Users Autocomplete ([#26309](https://github.com/RocketChat/Rocket.Chat/pull/26309))

- Regression: OTR with new React Messages ([#26179](https://github.com/RocketChat/Rocket.Chat/pull/26179))

  This PR solves 2 OTR issues with new react message components


  - disable the server side message parser for OTR messages

  - adds the stopwatch icon for otr messages

  ### Before
  <img width="548" alt="Screenshot 2022-07-08 at 12 58 08 AM" src="https://user-images.githubusercontent.com/58601732/177856565-54854a45-e82c-443b-b77d-66ec69d70522.png">

  ### After
  <img width="549" alt="Screenshot 2022-07-08 at 12 55 08 AM" src="https://user-images.githubusercontent.com/58601732/177856597-67f7ca01-89ee-4ae9-bcd1-f4b6724db248.png">

- Regression: Parse outbound phone number removing * putting + char ([#26154](https://github.com/RocketChat/Rocket.Chat/pull/26154))

- Regression: Re-add view logs button ([#25876](https://github.com/RocketChat/Rocket.Chat/pull/25876))

  Re-added the view logs button to the appMenu component so that the user can go directly from the marketplace list of apps to the app info page with the logs tab already open.
  Demo gif:
  ![re-add-view-logs-button](https://user-images.githubusercontent.com/43561537/173681990-86c8a93c-bb2e-4540-824d-b7fbb3161356.gif)

- Regression: Remove 4.0 version banner ([#26251](https://github.com/RocketChat/Rocket.Chat/pull/26251))

  Created a migration to disable and dismiss for all users the old 4.0 version banner.
  It happened when a new admin user has been added.

- Regression: Remove alpha tag and fix initialization process ([#26248](https://github.com/RocketChat/Rocket.Chat/pull/26248))

- Regression: remove italic from reaction translation ([#26152](https://github.com/RocketChat/Rocket.Chat/pull/26152))

- Regression: Removed CE watermark from VoipFooter ([#26239](https://github.com/RocketChat/Rocket.Chat/pull/26239))

  The objective of this change is to remove the CE watermark **only** during an active call. The CE watermark will be displayed normally in all other scenarios. Bellow you can see a demonstration of the expected behavior:

  ![ce-watermark-removed-voip](https://user-images.githubusercontent.com/6494543/178615342-8049a2a8-d331-46a9-a8f1-8461ae341b50.gif)

- Regression: Replace contact center icon ([#26216](https://github.com/RocketChat/Rocket.Chat/pull/26216))

- Regression: REST API calls at Engagement Dashboard ([#26235](https://github.com/RocketChat/Rocket.Chat/pull/26235))

  Parameters for GET requests are *not* serialized as for other methods, therefore sending `Date` objects is not viable due to  the way `Date.prototype.toString` works. This PR uses `Date.prototype.toISOString` explicitly to serialize dates.

- Regression: Revert Bugsnag version ([#25313](https://github.com/RocketChat/Rocket.Chat/pull/25313))

- Regression: Revert Livechat packages upgrades/removals that were causing issues ([#26077](https://github.com/RocketChat/Rocket.Chat/pull/26077))

- Regression: Revert replace contact center icon ([#26238](https://github.com/RocketChat/Rocket.Chat/pull/26238))

- Regression: Reverting @rocket.chat/mp3-encoder version to fix Audio Message ([#26197](https://github.com/RocketChat/Rocket.Chat/pull/26197))

  An unknow breaking change (still investigating) happened when upgrading the [@rocket.chat/mp3-encoder](https://github.com/RocketChat/fuselage/tree/develop/packages/mp3-encoder) package to version 0.25.0, because of that we revert the version to 0.24.0 the last know working version.

- Regression: Rocket.Chat Webapp not loading. ([#25349](https://github.com/RocketChat/Rocket.Chat/pull/25349))

- Regression: Room Endpoint Call Issues ([#25928](https://github.com/RocketChat/Rocket.Chat/pull/25928))

  This PR fixes small management bugs related with channels, rooms and teams

- Regression: Search on Member List ([#26273](https://github.com/RocketChat/Rocket.Chat/pull/26273))

- Regression: Send files with `enter` key ([#26136](https://github.com/RocketChat/Rocket.Chat/pull/26136))

- Regression: Set `offset` and `count` optional on `ChatGetThreadsListSchema` ([#25961](https://github.com/RocketChat/Rocket.Chat/pull/25961))

- Regression: Show username and real name on the message system ([#25254](https://github.com/RocketChat/Rocket.Chat/pull/25254))

- Regression: Shows error if micro service cannot connect to Mongo ([#25301](https://github.com/RocketChat/Rocket.Chat/pull/25301))

- Regression: Sidebar icons spacing ([#26139](https://github.com/RocketChat/Rocket.Chat/pull/26139))

  - Fixed the sidebar icons ('display' and 'create new') spacing issue

  before:
  ![image](https://user-images.githubusercontent.com/5263975/178897210-50615ea9-28d5-4b35-a93a-c5facea365e5.png)



  after:

  ![image](https://user-images.githubusercontent.com/5263975/178896945-1bf71112-8a01-4db6-9f9b-20ea778496f7.png)

- Regression: Special characters on phone number ([#26241](https://github.com/RocketChat/Rocket.Chat/pull/26241))

  PR Includes:

  - Keep focus on phone input of dial pad

  - Handle submit with "Enter" key

  - Remove mask and mandatory "+" char

  - Long press for "0"/"+" button

- Regression: Subscription menu not appearing for non installed but subscribed apps ([#25627](https://github.com/RocketChat/Rocket.Chat/pull/25627))

  Fixed a problem on which the AppMenu component did not appear for apps that had an active subscription but weren't installed, now the rendering of the component is also based on the isSubscribed flag, and the appearance of the uninstall and enable/disable options are based on the app.installed flag so that the correct options appear on all the edge cases.
  Demo gif:
  ![subscription-manager-fix](https://user-images.githubusercontent.com/43561537/170132040-dc8535c0-8056-4fb2-b008-afaece744868.gif)

- Regression: TOTP Modal with new rest api package ([#25893](https://github.com/RocketChat/Rocket.Chat/pull/25893))

- Regression: UIKit buttons auth user validation ([#26171](https://github.com/RocketChat/Rocket.Chat/pull/26171))

  Fix the validation to match the new feature that allows apps to register auth-required routes.

- Regression: Unable to click on UiKit buttons provided by apps ([#26125](https://github.com/RocketChat/Rocket.Chat/pull/26125))

- Regression: Unable to edit user details via admin panel ([#25923](https://github.com/RocketChat/Rocket.Chat/pull/25923))

- Regression: Unavailable devices in unsupported browsers ([#26174](https://github.com/RocketChat/Rocket.Chat/pull/26174))

- Regression: Unhandled Exceptions metric causing a secondary exception ([#26088](https://github.com/RocketChat/Rocket.Chat/pull/26088))

- Regression: Update error message on `useEndpointActionExperimental` ([#26062](https://github.com/RocketChat/Rocket.Chat/pull/26062))

  This PR changes the way we show an error message to the user on the `useEndpointActionExperimental` hook, previously for `Object` error messages it was being shown as undefined

- Regression: Update message reaction text ([#26097](https://github.com/RocketChat/Rocket.Chat/pull/26097))

- Regression: Update settings groups description ([#25663](https://github.com/RocketChat/Rocket.Chat/pull/25663))

- Regression: Use exact Node version on micro services Docker images ([#25287](https://github.com/RocketChat/Rocket.Chat/pull/25287))

- Regression: Use fname instead real unique name for Voip ([#26319](https://github.com/RocketChat/Rocket.Chat/pull/26319))

  Affect:

  - Voip room header

  - Contacts table

  - Contact info

- Regression: UserInfo/RoomInfo Menu ([#26252](https://github.com/RocketChat/Rocket.Chat/pull/26252))

  **note**: next fuselage's version needed

  #### before
  ![Screen Shot 2022-07-13 at 12 24 38](https://user-images.githubusercontent.com/27704687/178771262-d482b300-de80-4961-be2e-8c034480d237.png)

  #### after
  ![Screen Shot 2022-07-13 at 12 25 39](https://user-images.githubusercontent.com/27704687/178771460-db10883b-aa6d-4254-82d4-8cadd6991ae8.png)

- Regression: Users on new sessions are forced to re-configure 2fa ([#26117](https://github.com/RocketChat/Rocket.Chat/pull/26117))

- Regression: Users Table loading state ([#26079](https://github.com/RocketChat/Rocket.Chat/pull/26079))

- Regression: Validate empty fields for Message template ([#25250](https://github.com/RocketChat/Rocket.Chat/pull/25250))

- Regression: VoIp wrap up modal not opening after call disconnect ([#25651](https://github.com/RocketChat/Rocket.Chat/pull/25651))

  This PR fixes a bug preventing the wrap up call modal from being displayed after caller or agent ends the call.

- Regression: Webhook Integration Creation + string error toast msg ([#26008](https://github.com/RocketChat/Rocket.Chat/pull/26008))

- Regression: yarn dev triggers build dependencies ([#25208](https://github.com/RocketChat/Rocket.Chat/pull/25208))

- Revert:  "Chore: Collect e2e coverage" ([#25936](https://github.com/RocketChat/Rocket.Chat/pull/25936) by [@souzaramon](https://github.com/souzaramon))

- Test: Migrate 13-permissions from cypress to playwright ([#25558](https://github.com/RocketChat/Rocket.Chat/pull/25558) by [@souzaramon](https://github.com/souzaramon))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@BenWiederhake](https://github.com/BenWiederhake)
- [@Himanshu664](https://github.com/Himanshu664)
- [@Hudell](https://github.com/Hudell)
- [@Kunalvrm555](https://github.com/Kunalvrm555)
- [@Sh0uld](https://github.com/Sh0uld)
- [@aakash-gitdev](https://github.com/aakash-gitdev)
- [@amolghode1981](https://github.com/amolghode1981)
- [@carlosrodrigues94](https://github.com/carlosrodrigues94)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@divinespear](https://github.com/divinespear)
- [@eduardofcabrera](https://github.com/eduardofcabrera)
- [@felipe-menelau](https://github.com/felipe-menelau)
- [@g-thome](https://github.com/g-thome)
- [@joakimaho](https://github.com/joakimaho)
- [@kibonusp](https://github.com/kibonusp)
- [@matheuslc](https://github.com/matheuslc)
- [@matthias4217](https://github.com/matthias4217)
- [@ostjen](https://github.com/ostjen)
- [@paulobernardoaf](https://github.com/paulobernardoaf)
- [@sidmohanty11](https://github.com/sidmohanty11)
- [@souzaramon](https://github.com/souzaramon)
- [@ujorgeleite](https://github.com/ujorgeleite)
- [@weslley543](https://github.com/weslley543)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@LucianoPierdona](https://github.com/LucianoPierdona)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@PedroRorato](https://github.com/PedroRorato)
- [@alansikora](https://github.com/alansikora)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@cauefcr](https://github.com/cauefcr)
- [@csuadev](https://github.com/csuadev)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@dudanogueira](https://github.com/dudanogueira)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@hugocostadev](https://github.com/hugocostadev)
- [@jeanfbrito](https://github.com/jeanfbrito)
- [@juliajforesti](https://github.com/juliajforesti)
- [@marceloschmidt](https://github.com/marceloschmidt)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tapiarafael](https://github.com/tapiarafael)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@tmontini](https://github.com/tmontini)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.8.4
`2022-08-11  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Endpoints `im.list` not working with Use Real Name setting ([#26532](https://github.com/RocketChat/Rocket.Chat/pull/26532))

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.8.3
`2022-08-02  ·  4 🐛  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Empty results on `im.list` endpoint ([#26438](https://github.com/RocketChat/Rocket.Chat/pull/26438))

- Unable to close chats when comments is disabled ([#26057](https://github.com/RocketChat/Rocket.Chat/pull/26057))

  Fixes https://github.com/RocketChat/Rocket.Chat/issues/25954

- Unable to send voice recording to Whatsapp ([#26276](https://github.com/RocketChat/Rocket.Chat/pull/26276))

- Update chartjs usage to v3 ([#25873](https://github.com/RocketChat/Rocket.Chat/pull/25873))

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@murtaza98](https://github.com/murtaza98)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.8.2
`2022-07-21  ·  4 🐛  ·  3 🔍  ·  7 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Error "numRequestsAllowed" property in rateLimiter for REST API endpoint when upgrading ([#26058](https://github.com/RocketChat/Rocket.Chat/pull/26058))

- Not showing edit message button when blocking edit after N minutes ([#25724](https://github.com/RocketChat/Rocket.Chat/pull/25724) by [@matthias4217](https://github.com/matthias4217))

  Previously, in Rocketchat 4.7.0 and later,  as mentioned in https://github.com/RocketChat/Rocket.Chat/issues/25478, the edit button was not displayed on the interface in the minute after having sent a message. This is now fixed : messages can be edited right after sending them.

- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

- Settings not being overwritten to their default values ([#25891](https://github.com/RocketChat/Rocket.Chat/pull/25891))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Avoid unneeded permission updates when EE license is applied ([#26253](https://github.com/RocketChat/Rocket.Chat/pull/26253))

- Release 4.8.1 ([#25814](https://github.com/RocketChat/Rocket.Chat/pull/25814) by [@Sh0uld](https://github.com/Sh0uld))

- Release 4.8.2 ([#26326](https://github.com/RocketChat/Rocket.Chat/pull/26326) by [@matthias4217](https://github.com/matthias4217))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Sh0uld](https://github.com/Sh0uld)
- [@matthias4217](https://github.com/matthias4217)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@dudanogueira](https://github.com/dudanogueira)
- [@ggazzo](https://github.com/ggazzo)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.8.1
`2022-06-08  ·  4 🐛  ·  5 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🐛 Bug fixes


- AccountBox checks for condition ([#25708](https://github.com/RocketChat/Rocket.Chat/pull/25708))

- Bump meteor-node-stubs to version 1.2.3 ([#25669](https://github.com/RocketChat/Rocket.Chat/pull/25669) by [@Sh0uld](https://github.com/Sh0uld))

  With meteor-node-stubs version 1.2.3 a bug was fixed, which occured in issue #25460 and probably #25513 (last one not tested).
  For the issue in meteor see: https://github.com/meteor/meteor/issues/11974

- Fix prom-client new promise usage ([#25781](https://github.com/RocketChat/Rocket.Chat/pull/25781))

- Wrong argument name preventing Omnichannel Chat Forward to User  ([#25723](https://github.com/RocketChat/Rocket.Chat/pull/25723))

### 👩‍💻👨‍💻 Contributors 😍

- [@Sh0uld](https://github.com/Sh0uld)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@dudanogueira](https://github.com/dudanogueira)
- [@ggazzo](https://github.com/ggazzo)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.8.0
`2022-05-31  ·  16 🎉  ·  13 🚀  ·  55 🐛  ·  151 🔍  ·  52 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🎉 New features


- Ability for RC server to check the business hour for a specific department ([#25436](https://github.com/RocketChat/Rocket.Chat/pull/25436))

- Add expire index to integration history ([#25087](https://github.com/RocketChat/Rocket.Chat/pull/25087))

- Add new app events for pin, react and follow message ([#25337](https://github.com/RocketChat/Rocket.Chat/pull/25337))

- Add new events after user login, logout and change his status ([#25234](https://github.com/RocketChat/Rocket.Chat/pull/25234))

- Add option to show mentions badge when show counter is disabled ([#25329](https://github.com/RocketChat/Rocket.Chat/pull/25329))

- Add user events for apps ([#25165](https://github.com/RocketChat/Rocket.Chat/pull/25165))

- Adding app button on user dropdown ([#25326](https://github.com/RocketChat/Rocket.Chat/pull/25326))

- Alpha Matrix Federation ([#23688](https://github.com/RocketChat/Rocket.Chat/pull/23688))

  Experimental support for Matrix Federation with a Bridge

  https://user-images.githubusercontent.com/51996/164530391-e8b17ecd-a4d0-4ef8-a8b7-81230c1773d3.mp4

- Expand Apps Engine's environment variable allowed list ([#23870](https://github.com/RocketChat/Rocket.Chat/pull/23870) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Federation (Alpha Stabilization) ([#25457](https://github.com/RocketChat/Rocket.Chat/pull/25457))

- Get user's preferred language via apps ([#25514](https://github.com/RocketChat/Rocket.Chat/pull/25514))

- Marketplace new app details page ([#24711](https://github.com/RocketChat/Rocket.Chat/pull/24711))

  Change the app details page layout for the new marketplace UI. General Task: [MKP12   - New UI   - App Detail Page](https://app.clickup.com/t/1na769h)

  ## [MKP12   - Tab Navigation](https://app.clickup.com/t/2452f5u)
  New tab navigation layout for the app details page. Now the app details page is divided into three sections, details, logs, and settings, that can each be accessed through a Tabs fuselage component.

  Demo gif:
  ![tab_navigation_demo_gif](https://user-images.githubusercontent.com/43561537/157276436-3dab34c5-20da-4f5d-99d0-54c1c718ac1f.gif)

  ## [MKP12   - Header](https://app.clickup.com/t/25rhm0x)
  Implemented a new header for the marketplaces app details page.
  -Changed the size of the app name;
  -Implemented the app description field on the header;
  -Changed the "metadata" section of the header(The part with the version and author information) now it also shows the last time the app was updated;
  -Created a chip that will show when an app is part of one or more bundles and inform which are the bundles;
  -Implemented a tooltip for the bundle chips;
  -Created a new button + data badge component to substitute the current App Status;
  -Changed the title of the "purchase button". Now it shows different text based on the "purchase type" of the app;
  -Created a new Pricing & Status display which shows the price when the app is not bought/installed and shows the app status(Enabled/Disabled) when it is bought/installed;
  -Changed the way the tabs are rendered, now if the app is not installed(and consequently doesn't have logs and settings tab) it will not render these tabs;

  Demo gif:
  ![new-header-gif](https://user-images.githubusercontent.com/43561537/159064599-fd64dfe2-86a3-47da-81ba-1e83f1b87432.gif)

  ## [MKP12   - Configuration Tab](https://app.clickup.com/t/2452gh4)
  Delivered together with the tab-navigation task. Changed the app settings from the details of the app to the new settings tab.
  Demo image:
  ![New configuration tab](https://user-images.githubusercontent.com/43561537/160211324-95db0566-85bf-4dde-a814-3c6f23dcee4d.png)

  ## [MKP12   - Log Tab](https://app.clickup.com/t/2452gg1)
  Changed the place of the app logs from the page to the new logs tab. Also changed some styles of the logs accordions to fit better with the new container.

  Before:
  ![Before](https://user-images.githubusercontent.com/43561537/160210302-148ce584-604f-40ff-8209-141667016163.png)

  After
  ![After](https://user-images.githubusercontent.com/43561537/160210984-d4060c5a-f912-4ef9-87e3-fa459080e2d4.png)

  ## [MKP12   - Page Header](https://app.clickup.com/t/29b0b12)
  Changed the design for the page header of the app details page from a title on the left with a save and back button on the right to a back arrow icon on the left side of the title with the save button still on the right. Also changed the title of the page from App details to Back.
  Edit: After some design reconsideration, the page title was changed to App Info.
  Demo gif:
  ![new_page_header_app_details](https://user-images.githubusercontent.com/43561537/160937741-f5514f70-f43b-4400-8b2f-a5a26f95de9d.gif)

  ## [MKP12   - Detail Tab](https://app.clickup.com/t/2452gf7)
  Implemented markdown on the description section of the app details page, now the description will show the detailedDescription.rendered (as rendered JSX) information in case it exists and show the description (a.k.a. short description) information in case it doesn't. Unfortunately, as of right now no app has a visual example of a markdown description and because of that, I will not be able to provide a demo image/gif for this PR.

  ## [MKP12   - Slider Component](https://app.clickup.com/t/2452h26)
  Created an image carousel component on the app details page. This component receives images from the apps/appId/screenshots endpoint and shows them on the content section of the app details of any apps that have screenshots registered, if the app has no screenshots it simply shows nothing where the carousel should be. This component is complete with keyboard arrow navigation on the "open" carousel, hover highlight on the carousel preview and close on esc press.
  Demo gif:
  ![new_carousel_component](https://user-images.githubusercontent.com/43561537/167415212-9d8359c7-4132-4afa-a698-8be4ab1e1393.gif)

- Message Template React Component ([#23971](https://github.com/RocketChat/Rocket.Chat/pull/23971))

  Complete rewrite of the messages component in react. Visual changes should be minimal as well as user impact, with no break changes (unless you've customized the blaze template).



  ![Screen Shot 2022-04-05 at 11 14 18](https://user-images.githubusercontent.com/27704687/161774027-38dd9c7b-eeeb-45e2-b9d8-ea2a9be8486d.png)
  In case you encounter any problems, or want to compare, temporarily it is possible to use the old version

  <img width="556" alt="image" src="https://user-images.githubusercontent.com/5263975/162099800-15806953-f2f5-4905-a424-3f095076bc1d.png">

- New button for network outage ([#25499](https://github.com/RocketChat/Rocket.Chat/pull/25499) by [@amolghode1981](https://github.com/amolghode1981))

  When network outage happens it should be conveyed to the user with special icon. This icon should not be clickable.
  Network outage handling is handled in https://app.clickup.com/t/245c0d8 task.

- New stats rewrite ([#25078](https://github.com/RocketChat/Rocket.Chat/pull/25078) by [@ostjen](https://github.com/ostjen))

  Add the following new statistics (**metrics**):


  - Total users with TOTP enabled;

  - Total users with 2FA enabled;

  - Total pinned messages;

  - Total starred messages;

  - Total email messages;

  - Total rooms with at least one starred message;

  - Total rooms with at least one pinned message;

  - Total encrypted rooms;

  - Total link invitations;

  - Total email invitations;

  - Logo change;

  - Number of custom script lines;

  - Number of custom CSS lines;

  - Number of rooms inside teams;

  - Number of default (auto-join) rooms inside teams;

  - Number of users created through link invitation;

  - Number of users created through manual entry;

  - Number of imported users (by import type);

- Star message, report and delete message events ([#25383](https://github.com/RocketChat/Rocket.Chat/pull/25383))

### 🚀 Improvements


- **ENTERPRISE:** Allow mapping LDAP groups to multiple RC roles ([#23849](https://github.com/RocketChat/Rocket.Chat/pull/23849))

  - Add support to mapping LDAP groups to multiple roles (by specifying arrays in the "User Data Group Map" enterprise setting.

- Add OTR Room States ([#24565](https://github.com/RocketChat/Rocket.Chat/pull/24565))

  Earlier OTR room uses only 2 states, we need more states to support future features.
  This adds more states for the OTR contextualBar.


  - Expired
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 52" src="https://user-images.githubusercontent.com/27704687/164283351-068756be-3419-4773-9d55-c9c1a72f5a19.png">


  - Declined
  <img width="343" alt='Screen Shot 2022-04-20 at 13 49 28' src='https://user-images.githubusercontent.com/27704687/164282312-fa3c6841-23d4-46e1-a8e9-80882a105d8c.png' />


  - Error
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 26" src="https://user-images.githubusercontent.com/27704687/164283261-95e06d06-b0d0-402d-bccc-66596ff4dcd3.png">

- Add tooltip to sidebar room menu ([#24405](https://github.com/RocketChat/Rocket.Chat/pull/24405) by [@Himanshu664](https://github.com/Himanshu664))

- add warnings for federation setup ([#25684](https://github.com/RocketChat/Rocket.Chat/pull/25684) by [@carlosrodrigues94](https://github.com/carlosrodrigues94))

- Added MaxNickNameLength and MaxBioLength constants ([#25231](https://github.com/RocketChat/Rocket.Chat/pull/25231) by [@aakash-gitdev](https://github.com/aakash-gitdev))

- Added tooltip options for message menu ([#24431](https://github.com/RocketChat/Rocket.Chat/pull/24431) by [@Himanshu664](https://github.com/Himanshu664))

- Fix multiple bugs with Matrix bridge ([#25318](https://github.com/RocketChat/Rocket.Chat/pull/25318))

- Improve active/hover colors in account sidebar ([#25024](https://github.com/RocketChat/Rocket.Chat/pull/25024) by [@Himanshu664](https://github.com/Himanshu664))

- New admin settings Page ([#25439](https://github.com/RocketChat/Rocket.Chat/pull/25439))

  ![Screen Shot 2022-05-09 at 11 31 58](https://user-images.githubusercontent.com/27704687/167432811-f4970f23-5dae-48a0-a427-92269d08a859.png)

- Pass allowDiskUse to channel aggregations on engagement dashboard ([#22374](https://github.com/RocketChat/Rocket.Chat/pull/22374))

- Performance for some Omnichannel features ([#25217](https://github.com/RocketChat/Rocket.Chat/pull/25217))

- Rename upgrade tab routes ([#25097](https://github.com/RocketChat/Rocket.Chat/pull/25097))

  Change 'upgrade tab' routes names from camelCase ('goFullyFeatured') to kebab-case ('go-fully-featured') due to URL naming consistency. Changed types, main function and test.

- Unify voip streams into single stream ([#25108](https://github.com/RocketChat/Rocket.Chat/pull/25108))

### 🐛 Bug fixes


- Add katex render to new message react template ([#25239](https://github.com/RocketChat/Rocket.Chat/pull/25239))

- Add open user card to user avatar ([#25445](https://github.com/RocketChat/Rocket.Chat/pull/25445))

- Add reaction not working in legacy messages ([#25222](https://github.com/RocketChat/Rocket.Chat/pull/25222))

- Added invalid password error message ([#24714](https://github.com/RocketChat/Rocket.Chat/pull/24714) by [@Himanshu664](https://github.com/Himanshu664))

- Adjust email label in Setup Wizard i18n files ([#25260](https://github.com/RocketChat/Rocket.Chat/pull/25260))

  - remove 'Company' label on onboarding email keys in certain languages

- AgentOverview analytics wrong departmentId parameter ([#25073](https://github.com/RocketChat/Rocket.Chat/pull/25073) by [@paulobernardoaf](https://github.com/paulobernardoaf))

  When filtering the analytics charts by department, data would not appear because the object:
  ```js
  {
  value: "department-id",
  label: "department-name"
  }
  ```
  was being used in the `departmentId` parameter.


  - Before:
  ![image](https://user-images.githubusercontent.com/30026625/161832057-d96ffd21-a7dd-421e-bfaa-3b9f4a9127b2.png)


  - After:
  ![image](https://user-images.githubusercontent.com/30026625/161831092-9ee77b51-b083-4f45-9c48-ab2e0511c4d6.png)

- Change form body parameter charset to UTF-8 to fix issue #25456 ([#25673](https://github.com/RocketChat/Rocket.Chat/pull/25673) by [@divinespear](https://github.com/divinespear))

  since [mscdex/busboy](https://github.com/mscdex/busboy) 1.5.0, new option named `defParamCharset` for form body parameter encoding is added with default value `latin1`, so unicode filenames are broken since 4.7.0.

  ![Screenshot from 2022-05-28 16-26-06](https://user-images.githubusercontent.com/126630/170815447-1f3bd579-243a-42d3-86f6-814aeaa30ce9.png)

- Change NPS Vote identifier + nps index to unique ([#25423](https://github.com/RocketChat/Rocket.Chat/pull/25423))

- Click to join button Jitsi Call ([#25569](https://github.com/RocketChat/Rocket.Chat/pull/25569))

  Added `ToolboxProvider` to `MessageListProvider` and fixed actionLink.js open function exec

- Client disconnection on network loss ([#25170](https://github.com/RocketChat/Rocket.Chat/pull/25170) by [@amolghode1981](https://github.com/amolghode1981))

  Agent gets disconnected (or Unregistered) from asterisk in multiple ways. The goal is that agent should remain online
  unless agent explicitly logs off.
  Agent can stop receiving calls in multiple ways due to network loss. Network loss can happen in following ways.

  1. User tries to switch the network. User experiences a glitch of disconnectivity. This can be simulated by turning the network off
  in the network tab of chrome's dev tool. This can disconnect the UA if the disconnection happens just before the registration refresh.

  2. Second reason is when computer goes in sleep mode.

  3. Third reason is that when asterisk is crashed/in maintenance mode/explicitly stopped.

  Solution:
  The idea is to detect the network disconnection and start the start the attempts to reconnect.
  The detection of the disconnection does not happen in case#1. The SIPUA's UserAgent transport does not
  call onDisconnected when network loss of such kind happens. To tackle this problem, window's online and offline event handlers are
  used.

  The number of retries is configurable but ideally it is to be kept at -1. Whenever disconnection happens, it should keep on trying to
  reconnect with increasing backoff time. This behaviour is useful when the asterisk is stopped.

  When the server is disconnected, it should be indicated on the phone button.

- Close room when dismiss wrap up call modal ([#25056](https://github.com/RocketChat/Rocket.Chat/pull/25056))

- Custom sound error toast messages ([#24515](https://github.com/RocketChat/Rocket.Chat/pull/24515) by [@Himanshu664](https://github.com/Himanshu664))

- Deactivating user breaks if user is the only room owner ([#24933](https://github.com/RocketChat/Rocket.Chat/pull/24933) by [@sidmohanty11](https://github.com/sidmohanty11))

  ## Before

  https://user-images.githubusercontent.com/73601258/160000871-cfc2f2a5-2a59-4d27-8049-7754d003dd48.mp4



  ## After
  https://user-images.githubusercontent.com/73601258/159998287-681ab475-ff33-4282-82ff-db751c59a392.mp4

- Desktop notification on multi-instance environments ([#25220](https://github.com/RocketChat/Rocket.Chat/pull/25220))

- End call button disappearing when on-hold ([#24936](https://github.com/RocketChat/Rocket.Chat/pull/24936))

- Failure to update Integration History index ([#25473](https://github.com/RocketChat/Rocket.Chat/pull/25473))

- Fix max-width message block ([#25686](https://github.com/RocketChat/Rocket.Chat/pull/25686))

- Fixing app contextual bar functionality ([#25615](https://github.com/RocketChat/Rocket.Chat/pull/25615))

- Fixing Network connectivity issues with SIP client. ([#25391](https://github.com/RocketChat/Rocket.Chat/pull/25391) by [@amolghode1981](https://github.com/amolghode1981))

  The previous PR https://github.com/RocketChat/Rocket.Chat/pull/25170 did not handle the issues completely.
  This PR is expected to handle

  1. Clearing call related UI when the network is disconnected or switched.

  2. Do clean connectivity. There were few issues discovered in earlier implementation. e.g endpoint would randomly
  get disconnected after a while. This was due to the fact that the earlier socket disconnection caused the
  removal of contact on asterisk. This should be fixed in this PR.

  3. This PR contains a lot of logs. This will be removed before the final merge.

- FormData uploads not working ([#25069](https://github.com/RocketChat/Rocket.Chat/pull/25069))

- Full error message is visible ([#24856](https://github.com/RocketChat/Rocket.Chat/pull/24856) by [@Himanshu664](https://github.com/Himanshu664))

- Incorrect websocket url in livechat widget ([#25261](https://github.com/RocketChat/Rocket.Chat/pull/25261))

- Integrations avatar attribute misuse ([#25283](https://github.com/RocketChat/Rocket.Chat/pull/25283))

- Invitation links don't redirect to the registration form ([#25082](https://github.com/RocketChat/Rocket.Chat/pull/25082))

- Message menu action not working on legacy messages. ([#25148](https://github.com/RocketChat/Rocket.Chat/pull/25148))

- Message menu dropdown not working on Mobile Web ([#25616](https://github.com/RocketChat/Rocket.Chat/pull/25616))

- Message preview not available for queued chats ([#25092](https://github.com/RocketChat/Rocket.Chat/pull/25092))

- NPS never finishing sending results ([#25067](https://github.com/RocketChat/Rocket.Chat/pull/25067))

- Ordered and unordered list styles, Line breaks. ([#25494](https://github.com/RocketChat/Rocket.Chat/pull/25494))

  Also removed the message.md cache from server, since changes in the parser might break messages in the future (and will in this specific case).

- Pinned Message display cutting off information ([#25535](https://github.com/RocketChat/Rocket.Chat/pull/25535))

- Prevent federation crash on invite users as a non-owner user ([#25683](https://github.com/RocketChat/Rocket.Chat/pull/25683))

- Prevent sequential messages edited icon to hide on hover ([#24984](https://github.com/RocketChat/Rocket.Chat/pull/24984))

  ### before
  <img width="297" alt="Screen Shot 2022-03-29 at 13 35 56" src="https://user-images.githubusercontent.com/27704687/160661700-c2aebe05-a1be-4235-9d20-bce0b6e5fdb5.png">

  ### after
  <img width="300" alt="Screen Shot 2022-03-29 at 11 48 05" src="https://user-images.githubusercontent.com/27704687/160639208-3883a7b0-718a-4e9d-87b1-db960fe9bfcd.png">

- Proxy settings being ignored ([#25022](https://github.com/RocketChat/Rocket.Chat/pull/25022))

  Modify Meteor's `HTTP.call` to add back proxy support

- Quote message spacing ([#25613](https://github.com/RocketChat/Rocket.Chat/pull/25613))

- Read receipts show with color gray when not read yet ([#25244](https://github.com/RocketChat/Rocket.Chat/pull/25244))

- Read receipts showing before message read ([#25216](https://github.com/RocketChat/Rocket.Chat/pull/25216))

- Remove 'total' text in admin info page ([#25638](https://github.com/RocketChat/Rocket.Chat/pull/25638))

  - Remove initial 'total' text from rooms and messages groups in the admin info page

  - Add 'total' before 'rooms' and 'messages' title on the same section. To use the new 'Total Rooms', was created a new key in the en.i18n.json file.

- Removing user also removes them from Omni collections ([#25444](https://github.com/RocketChat/Rocket.Chat/pull/25444))

- Replace encrypted text to Encrypted Message Placeholder ([#24166](https://github.com/RocketChat/Rocket.Chat/pull/24166))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/150807900-154a9cdb-ee13-4333-8628-f287ab914b40.png)

  ### after
  <img width="814" alt="Screenshot 2022-01-13 at 8 57 47 PM" src="https://user-images.githubusercontent.com/58601732/149359411-23e2430b-89e4-48b4-a3ad-65471d058551.png">

- Reply button behavior on broadcast channel ([#25175](https://github.com/RocketChat/Rocket.Chat/pull/25175))

  Hide reply button for the user that sent the message

- room creation fails if app framework is disabled ([#25200](https://github.com/RocketChat/Rocket.Chat/pull/25200))

- Rooms' names turn lower case on CSV import ([#24612](https://github.com/RocketChat/Rocket.Chat/pull/24612))

  * Change 'Settings' import to not get cached configs

  * Remove update `UI_Allow_room_names_with_special_chars` value

- Sanitize customUserStatus and fix infinite loop ([#25449](https://github.com/RocketChat/Rocket.Chat/pull/25449))

  ### Additional improves:

  - usage of RHF to avoid unnecessary Add and Edit components separately and form validation

  - usage of `GenericTableV2` and some hooks to avoid unnecessary code

  - fix `IUserStatus` type

  - improves in UI design

  - improves **empty** and **loading** state

  - improves files structure

  [LOOP ERROR ATTACHMENT]
  ![Screen Shot 2022-05-09 at 19 42 53](https://user-images.githubusercontent.com/27704687/167510439-1980461c-a885-46d2-9a49-79da432c7521.png)

- Settings listeners not receiving overwritten values from env vars ([#25448](https://github.com/RocketChat/Rocket.Chat/pull/25448))

- Showing Blank Message Inside Report ([#25007](https://github.com/RocketChat/Rocket.Chat/pull/25007))

  https://user-images.githubusercontent.com/53515714/161038085-4a86c7ae-6751-4996-9767-b1c9e0331a6c.mp4

- Toolbox hiding under contextual bar ([#25237](https://github.com/RocketChat/Rocket.Chat/pull/25237))

- Unable to see channel member list by authorized channel roles ([#25412](https://github.com/RocketChat/Rocket.Chat/pull/25412))

- Upgrade tab loader in incorrect position ([#25398](https://github.com/RocketChat/Rocket.Chat/pull/25398))

  - Add invisible prop to iframe when loading state is active.

- Upgrade Tab showing for a split second ([#25050](https://github.com/RocketChat/Rocket.Chat/pull/25050))

- Use correct room property for call ended at ([#24932](https://github.com/RocketChat/Rocket.Chat/pull/24932))

- useCurrentChatTags is not a function ([#25604](https://github.com/RocketChat/Rocket.Chat/pull/25604))

- UserAutoComplete not rendering UserAvatar correctly ([#25055](https://github.com/RocketChat/Rocket.Chat/pull/25055))

  ### before
  ![Screen Shot 2022-04-04 at 16 50 21](https://user-images.githubusercontent.com/27704687/161620921-800bf66a-806d-4f83-b2e1-073c34215001.png)

  ### after
  ![Screen Shot 2022-04-04 at 16 49 00](https://user-images.githubusercontent.com/27704687/161620720-3e27774d-c241-46ca-b764-932a9295d709.png)

- UserCard sanitization ([#25089](https://github.com/RocketChat/Rocket.Chat/pull/25089))

  - Rewrites the component to TS

  - Fixes some visual issues

  ### before
  ![Screen Shot 2022-04-07 at 00 23 11](https://user-images.githubusercontent.com/27704687/162113925-5c9484d1-23e9-4623-8b86-3fbc71b461a1.png)

  ### after
  ![Screen Shot 2022-04-07 at 00 07 13](https://user-images.githubusercontent.com/27704687/162112353-afd6aac6-b27c-4470-a642-631b8080d59e.png)

- Video and Audio not skipping forward ([#19866](https://github.com/RocketChat/Rocket.Chat/pull/19866))

- VoIP disabled/enabled  sequence puts voip agent in error state ([#25230](https://github.com/RocketChat/Rocket.Chat/pull/25230) by [@amolghode1981](https://github.com/amolghode1981))

  Initially it was thought that the issue occurs because of the race condition while changing the client settings vs those settings reflected on server side. So a natural solution to solve this is to wait for setting change event 'private-settings-changed'. Then if 'VoIP_Enabled' is updated and it is true, set voipEnabled  to true in useVoipClient.ts (on client side)

  It was realised that the race does not happen because of the database or server noticing the changes late. But because of the time taken to establish the AMI connection with Asterisk.

  Solution:


  1. Change apps/meteor/app/voip/server/startup.ts. When VoIP_Enabled is changed, await for Voip.init() to complete and then broadcast connector.statuschanged  with changed value.

  2. From apps/meteor/server/modules/listeners/listeners.module.ts use notifyLoggedInThisInstance to notify all logged in users on current instance.

  3. in apps/meteor/client/providers/CallProvider/hooks/useVoipClient.ts add the event handler that receives this event. Change voipEnabled from constant to state. Change this state based on the 'value' that is received by the handler.

<details>
<summary>🔍 Minor changes</summary>


- Bump body-parser from 1.19.2 to 1.20.0 in /ee/server/services ([#25042](https://github.com/RocketChat/Rocket.Chat/pull/25042) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ejson from 2.2.1 to 2.2.2 ([#25057](https://github.com/RocketChat/Rocket.Chat/pull/25057) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump eslint-plugin-anti-trojan-source from 1.0.6 to 1.1.0 ([#25076](https://github.com/RocketChat/Rocket.Chat/pull/25076) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump minimist from 1.2.5 to 1.2.6 in /ee/server/services ([#24991](https://github.com/RocketChat/Rocket.Chat/pull/24991) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino and pino-pretty ([#25052](https://github.com/RocketChat/Rocket.Chat/pull/25052))

- Bump template-file from 6.0.0 to 6.0.1 ([#25002](https://github.com/RocketChat/Rocket.Chat/pull/25002) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: Add /v1/video-conference endpoint types ([#25278](https://github.com/RocketChat/Rocket.Chat/pull/25278))

- Chore: Add channel endpoints (rest-typings) ([#25279](https://github.com/RocketChat/Rocket.Chat/pull/25279))

- Chore: Add client folder to CODEOWNERS  ([#25397](https://github.com/RocketChat/Rocket.Chat/pull/25397))

- Chore: Add error boundary to message component ([#25223](https://github.com/RocketChat/Rocket.Chat/pull/25223))

  Not crash the whole application if something goes wrong in the MessageList component.

  ![image](https://user-images.githubusercontent.com/40830821/162269915-931c5c3c-c979-4234-b74c-371f67467ce0.png)

- Chore: Add options to debug stdout and rate limiter ([#25336](https://github.com/RocketChat/Rocket.Chat/pull/25336))

- Chore: Add root package.json to houston files ([#25286](https://github.com/RocketChat/Rocket.Chat/pull/25286))

  See title

- Chore: Add typings for /v1/webdav.getMyAccounts ([#25276](https://github.com/RocketChat/Rocket.Chat/pull/25276))

- Chore: Add yarn plugin to check node and yarn version ([#25224](https://github.com/RocketChat/Rocket.Chat/pull/25224))

- Chore: bump fuselage ([#25605](https://github.com/RocketChat/Rocket.Chat/pull/25605))

- Chore: Bump fuselage ([#25371](https://github.com/RocketChat/Rocket.Chat/pull/25371))

- Chore: Bump Fuselage packages ([#25259](https://github.com/RocketChat/Rocket.Chat/pull/25259))

- Chore: Cancel running jobs if PR is updated ([#24708](https://github.com/RocketChat/Rocket.Chat/pull/24708))

- Chore: Chore add validation option to rest endpoints ([#25443](https://github.com/RocketChat/Rocket.Chat/pull/25443))

- Chore: Code Improvements for #25391 ([#25606](https://github.com/RocketChat/Rocket.Chat/pull/25606))

- Chore: Convert `UserStatusMenu` to TS ([#25265](https://github.com/RocketChat/Rocket.Chat/pull/25265))

- Chore: Convert additionalForms ([#25586](https://github.com/RocketChat/Rocket.Chat/pull/25586))

- Chore: Convert Admin -> Rooms to TS ([#25348](https://github.com/RocketChat/Rocket.Chat/pull/25348))

- Chore: Convert admin custom sound to tsx ([#25128](https://github.com/RocketChat/Rocket.Chat/pull/25128))

- Chore: Convert Admin/OAuthApps to TS ([#25277](https://github.com/RocketChat/Rocket.Chat/pull/25277))

  - Converts Admin/OAuthApps to TS.

  - migrated forms to react-hook-form

- Chore: Convert AdminSideBar to ts ([#25372](https://github.com/RocketChat/Rocket.Chat/pull/25372))

- Chore: Convert apps/meteor/client/components/UserAutoComplete ([#25554](https://github.com/RocketChat/Rocket.Chat/pull/25554))

- Chore: Convert apps/meteor/client/views/admin/settings ([#25565](https://github.com/RocketChat/Rocket.Chat/pull/25565))

- Chore: Convert apps/meteor/client/views/admin/settings/inputs folder ([#25427](https://github.com/RocketChat/Rocket.Chat/pull/25427))

- Chore: Convert AutoTranslate ([#25591](https://github.com/RocketChat/Rocket.Chat/pull/25591))

- Chore: Convert client/views/admin/settings/groups folder to ts ([#25345](https://github.com/RocketChat/Rocket.Chat/pull/25345))

- Chore: Convert Create Channel ([#25589](https://github.com/RocketChat/Rocket.Chat/pull/25589))

- Chore: Convert customSounds folder to ts ([#25274](https://github.com/RocketChat/Rocket.Chat/pull/25274))

- Chore: Convert customUserStatus folder to ts ([#25288](https://github.com/RocketChat/Rocket.Chat/pull/25288))

- Chore: Convert email inbox feature to TypeScript ([#25298](https://github.com/RocketChat/Rocket.Chat/pull/25298) by [@ujorgeleite](https://github.com/ujorgeleite))

- Chore: Convert federationDashboard folder to ts ([#25343](https://github.com/RocketChat/Rocket.Chat/pull/25343))

- Chore: Convert getStatistics ([#25342](https://github.com/RocketChat/Rocket.Chat/pull/25342))

- Chore: convert info to typescript ([#25420](https://github.com/RocketChat/Rocket.Chat/pull/25420))

- Chore: Convert LivechatAgentActivity to raw model and TS ([#25123](https://github.com/RocketChat/Rocket.Chat/pull/25123))

- Chore: Convert Mailer to TS ([#25121](https://github.com/RocketChat/Rocket.Chat/pull/25121))

- Chore: convert marketplace price display component to use typescript ([#25504](https://github.com/RocketChat/Rocket.Chat/pull/25504) by [@matheuslc](https://github.com/matheuslc))

  **Marketplace apps listing page**
  ![Screen Shot 2022-05-13 at 12 57 43](https://user-images.githubusercontent.com/4161171/168322189-67990fdf-a447-46dc-8f88-08b16c2a5416.png)

  **Apps detail page**
  ![Screen Shot 2022-05-13 at 12 58 56](https://user-images.githubusercontent.com/4161171/168322241-505ee5bb-d3d8-4b0e-8757-873a1a65a6a6.png)

- Chore: Convert NotificationStatus to TS ([#25125](https://github.com/RocketChat/Rocket.Chat/pull/25125))

- Chore: Convert push endpoints to TS ([#25347](https://github.com/RocketChat/Rocket.Chat/pull/25347))

- Chore: Convert RoomForeword, TextCopy and RoomAvatarEditor to TS ([#25424](https://github.com/RocketChat/Rocket.Chat/pull/25424))

- Chore: Convert slashCommands to typescript ([#25592](https://github.com/RocketChat/Rocket.Chat/pull/25592) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Chore: Convert to typescript some functions from app/lib/server/functions ([#24519](https://github.com/RocketChat/Rocket.Chat/pull/24519))

  Convert to typescript some functions from app/lib/server/functions and transfered theses files to server/lib

- Chore: Convert to typescript the slash commands help files ([#24307](https://github.com/RocketChat/Rocket.Chat/pull/24307) by [@eduardofcabrera](https://github.com/eduardofcabrera))

  Convert to typescript the slash commands help files

- Chore: Convert useFileInput to TS ([#25426](https://github.com/RocketChat/Rocket.Chat/pull/25426))

- Chore: Convert useUpdateAvatar to TS and type avatar endpoints ([#25430](https://github.com/RocketChat/Rocket.Chat/pull/25430))

- Chore: Converting orchestrator.js to ts ([#25367](https://github.com/RocketChat/Rocket.Chat/pull/25367))

- Chore: Create README.md for Rest Typings ([#25335](https://github.com/RocketChat/Rocket.Chat/pull/25335))

- Chore: Dedicated package for UI contexts ([#25432](https://github.com/RocketChat/Rocket.Chat/pull/25432))

  Moving our React contexts to a different package on the monorepo enable us to deliver components from another packages, because they work as a loose connection to the core APIs.

- Chore: Dependencies upgrade ([#25290](https://github.com/RocketChat/Rocket.Chat/pull/25290))

- Chore: Enable marketplace screenshots endpoint ([#25395](https://github.com/RocketChat/Rocket.Chat/pull/25395) by [@matheuslc](https://github.com/matheuslc))

- Chore: ensure scripts use cross-env and ignore some dirs (ROC-54) ([#25218](https://github.com/RocketChat/Rocket.Chat/pull/25218) by [@souzaramon](https://github.com/souzaramon))

  - data and test-failure should be ignored

  - ensure scripts use cross-env

- Chore: Fix return type warnings ([#25275](https://github.com/RocketChat/Rocket.Chat/pull/25275))

- Chore: Increase performance and security of integrations’ scripts ([#25641](https://github.com/RocketChat/Rocket.Chat/pull/25641))

  Replace internal VM implementation with VM2 which implements many more mechanisms to ensure timeout, security and allow easier configuration for future improvements on the integrations' feature.

- Chore: Livechat change output level ([#25522](https://github.com/RocketChat/Rocket.Chat/pull/25522))

- Chore: Manager Page Rewrite ([#25431](https://github.com/RocketChat/Rocket.Chat/pull/25431))

- Chore: Migrate 15-message-popup from cypress to playwright ([#25462](https://github.com/RocketChat/Rocket.Chat/pull/25462) by [@souzaramon](https://github.com/souzaramon))

- Chore: migrate from cypress to pw 14-setting-permission ([#25523](https://github.com/RocketChat/Rocket.Chat/pull/25523) by [@weslley543](https://github.com/weslley543))

- Chore: Migrate NotFoundPage to TS ([#25509](https://github.com/RocketChat/Rocket.Chat/pull/25509))

- Chore: Migrate oauth2server to typescript ([#25126](https://github.com/RocketChat/Rocket.Chat/pull/25126))

- Chore: Migrate retention-policy to ts ([#25582](https://github.com/RocketChat/Rocket.Chat/pull/25582))

- Chore: Migrate spotify to ts ([#25507](https://github.com/RocketChat/Rocket.Chat/pull/25507))

- Chore: migrate-to-pw-adjust-in-intermitences ([#25542](https://github.com/RocketChat/Rocket.Chat/pull/25542) by [@weslley543](https://github.com/weslley543))

- Chore: Minor dependency updates ([#25269](https://github.com/RocketChat/Rocket.Chat/pull/25269))

- Chore: Missing keys in APIsDisplay ([#24464](https://github.com/RocketChat/Rocket.Chat/pull/24464))

- Chore: Monorepo  ([#25074](https://github.com/RocketChat/Rocket.Chat/pull/25074))

- Chore: Move admin sidebarItems registration to the main file ([#25442](https://github.com/RocketChat/Rocket.Chat/pull/25442))

- Chore: Move ddp-streamer micro service to its own sub-repo ([#25246](https://github.com/RocketChat/Rocket.Chat/pull/25246))

- Chore: move definitions to packages ([#25085](https://github.com/RocketChat/Rocket.Chat/pull/25085))

- Chore: Move markdown message parser to a `callback` ([#25413](https://github.com/RocketChat/Rocket.Chat/pull/25413))

- Chore: organize test files and fix code coverage ([#24900](https://github.com/RocketChat/Rocket.Chat/pull/24900))

- Chore: Remove Alpine image deps after using them ([#25053](https://github.com/RocketChat/Rocket.Chat/pull/25053))

- Chore: Remove duplicated useUserRoom ([#25180](https://github.com/RocketChat/Rocket.Chat/pull/25180))

- Chore: Remove old files from removed Omnichannel feature ([#25129](https://github.com/RocketChat/Rocket.Chat/pull/25129))

- Chore: Remove package-lock.json from houston files ([#25280](https://github.com/RocketChat/Rocket.Chat/pull/25280))

  Houston config in the `package.json` file still mentioned `package-lock.json`, but it doesn't exist anymore

- Chore: Remove unused Drone CI files ([#25124](https://github.com/RocketChat/Rocket.Chat/pull/25124))

- Chore: Reorder unreleased migrations ([#25508](https://github.com/RocketChat/Rocket.Chat/pull/25508))

- Chore: Rest API query parameters handling ([#25648](https://github.com/RocketChat/Rocket.Chat/pull/25648))

- Chore: REST query and body params validation ([#25446](https://github.com/RocketChat/Rocket.Chat/pull/25446))

- Chore: Rewrite 2fa to typescript ([#25285](https://github.com/RocketChat/Rocket.Chat/pull/25285))

- Chore: Rewrite action-links to ts ([#25418](https://github.com/RocketChat/Rocket.Chat/pull/25418))

- Chore: Rewrite autotranslate to ts ([#25425](https://github.com/RocketChat/Rocket.Chat/pull/25425))

- Chore: Rewrite im and dm endpoints to ts ([#25521](https://github.com/RocketChat/Rocket.Chat/pull/25521))

  - Endpoints rewritten to TS
    - dm.create
    - dm.delete
    - dm.close
    - dm.counters
    - dm.files
    - dm.history
    - dm.members
    - dm.messages
    - dm.messages.others
    - dm.list
    - dm.list.everyone
    - dm.open
    - dm.setTopic
    - im.create
    - im.delete
    - im.close
    - im.counters
    - im.files
    - im.history
    - im.members
    - im.messages
    - im.messages.others
    - im.list
    - im.list.everyone
    - im.open
    - im.setTopic

  - Some lines of code was refactored on `apps/meteor/app/api/server/v1/im.ts`

  - Unnecessary functions were deleted on `apps/meteor/app/lib/server/functions/getDirectMessageByNameOrIdWithOptionToJoin.ts`

  - New types was added on `apps/meteor/app/api/server/api.d.ts`

- Chore: Rewrite Jitsi Contextualbar to TS ([#25303](https://github.com/RocketChat/Rocket.Chat/pull/25303))

- Chore: Rewrite mail-messages to ts ([#25421](https://github.com/RocketChat/Rocket.Chat/pull/25421))

- Chore: Rewrite some Omnichannel files to TypeScript ([#25359](https://github.com/RocketChat/Rocket.Chat/pull/25359))

  apps/meteor/client/components/Omnichannel/modals/*
  apps/meteor/client/components/Omnichannel/Tags.js

- Chore: solve yarn issues from env var ([#25468](https://github.com/RocketChat/Rocket.Chat/pull/25468))

- Chore: Sync with master ([#25284](https://github.com/RocketChat/Rocket.Chat/pull/25284))

- Chore: Template to generate packages ([#25174](https://github.com/RocketChat/Rocket.Chat/pull/25174))

  ```
  npx hygen package new test
  ```

- Chore: Tests with Playwright (task: All works) ([#25122](https://github.com/RocketChat/Rocket.Chat/pull/25122) by [@weslley543](https://github.com/weslley543))

- Chore: Tests with Playwright (task: ROC-25, 06-message) ([#25252](https://github.com/RocketChat/Rocket.Chat/pull/25252) by [@weslley543](https://github.com/weslley543))

- Chore: Tests with Playwright (task: ROC-28, 09-channels) ([#25196](https://github.com/RocketChat/Rocket.Chat/pull/25196))

- Chore: Tests with Playwright (task: ROC-31, 12-settings) ([#25253](https://github.com/RocketChat/Rocket.Chat/pull/25253) by [@souzaramon](https://github.com/souzaramon))

- Chore: Tests with Playwright (task: ROC-66, Intermittent resolution in tests) ([#25416](https://github.com/RocketChat/Rocket.Chat/pull/25416) by [@souzaramon](https://github.com/souzaramon) & [@weslley543](https://github.com/weslley543))

- Chore: TS conversion folder client ([#25031](https://github.com/RocketChat/Rocket.Chat/pull/25031))

- Chore: TS migration SortList ([#25167](https://github.com/RocketChat/Rocket.Chat/pull/25167))

- Chore: Update Apps-Engine and Fuselage ([#25700](https://github.com/RocketChat/Rocket.Chat/pull/25700))

- Chore: Update Apps-Engine version ([#25617](https://github.com/RocketChat/Rocket.Chat/pull/25617))

- Chore: Update Livechat to the last version ([#25257](https://github.com/RocketChat/Rocket.Chat/pull/25257))

- Chore: Update Livechat version ([#25130](https://github.com/RocketChat/Rocket.Chat/pull/25130))

- Chore: update OTR icon ([#24521](https://github.com/RocketChat/Rocket.Chat/pull/24521) by [@kibonusp](https://github.com/kibonusp))

  I changed the shredder icon in OTR contextual bar to the stopwatch icon, recently added to the fuselage.

- Chore: Update Volta configuration ([#25394](https://github.com/RocketChat/Rocket.Chat/pull/25394))

  [Volta](https://volta.sh/) need some extra configuration to work on monorepos.

- Chore: User set UTC offset ([#25381](https://github.com/RocketChat/Rocket.Chat/pull/25381))

- i18n: Language update from LingoHub 🤖 on 2022-04-04Z ([#25043](https://github.com/RocketChat/Rocket.Chat/pull/25043))

- Merge master into develop & Set version to 4.7.0-develop ([#25028](https://github.com/RocketChat/Rocket.Chat/pull/25028))

- Regression: Add `isPending` status to message ([#25299](https://github.com/RocketChat/Rocket.Chat/pull/25299))

- Regression: Add eslint package to micro services Dockerfile ([#25311](https://github.com/RocketChat/Rocket.Chat/pull/25311))

- Regression: Add select message to system message and thread preview and allow select on legacy template ([#25251](https://github.com/RocketChat/Rocket.Chat/pull/25251))

- Regression: App event listeners broke Slackbridge integration and importers ([#25689](https://github.com/RocketChat/Rocket.Chat/pull/25689))

  Some event listeners triggered by Apps were calling `Meteor.user()` in functions that could run outside of Meteor environment

- Regression: Assets & Slack Bridge Setting Page not rendering ([#25629](https://github.com/RocketChat/Rocket.Chat/pull/25629))

- Regression: Avatar not loading on first direct message ([#25211](https://github.com/RocketChat/Rocket.Chat/pull/25211))

  fix avatar not loading on a first direct message

- Regression: Better MongoDB connection management for micro services ([#25323](https://github.com/RocketChat/Rocket.Chat/pull/25323))

- Regression: Broken components on Federation and Engagement dashboards ([#25653](https://github.com/RocketChat/Rocket.Chat/pull/25653))

  For reasons I've no clue, any client import path matching `**/data/**` will not be included in the final bundle, failing silently on transpiling/bundling.

- Regression: bump onboarding-ui version ([#25320](https://github.com/RocketChat/Rocket.Chat/pull/25320))

  - Bump to 'next' the onboarding-ui package from fuselage.

  - Update from 'companyEmail' to 'email' adminData usage types

- Regression: Change logic to check if connection is online on unstable networks ([#25618](https://github.com/RocketChat/Rocket.Chat/pull/25618))

- Regression: Change preference to be default legacy messages ([#25255](https://github.com/RocketChat/Rocket.Chat/pull/25255))

- Regression: CI playwright ([#25168](https://github.com/RocketChat/Rocket.Chat/pull/25168))

- Regression: CI services build ([#25555](https://github.com/RocketChat/Rocket.Chat/pull/25555))

- Regression: Endpoint types with Ajv Coercing data types ([#25644](https://github.com/RocketChat/Rocket.Chat/pull/25644))

  Ajv Coercing data types should be `true` to accept all kinds of data requested.

- Regression: eslint not running on packages ([#25305](https://github.com/RocketChat/Rocket.Chat/pull/25305))

- Regression: Fix CI monorepo build ([#25107](https://github.com/RocketChat/Rocket.Chat/pull/25107))

- Regression: Fix clicking on visitor's chat in the sidebar does not display the chat window ([#25380](https://github.com/RocketChat/Rocket.Chat/pull/25380))

  Fix: livechat room not opening.

- Regression: Fix English i18n react text ([#25368](https://github.com/RocketChat/Rocket.Chat/pull/25368))

  Incorrect text in reaction tooltip has been fixed

- Regression: Fix federation Matrix bridge startup ([#25273](https://github.com/RocketChat/Rocket.Chat/pull/25273))

- Regression: Fix micro services Docker build ([#25193](https://github.com/RocketChat/Rocket.Chat/pull/25193))

- Regression: Fix multi line is not showing an empty line between lines ([#25317](https://github.com/RocketChat/Rocket.Chat/pull/25317))

- Regression: Fix reply button not working when hideFlexTab is enabled ([#25306](https://github.com/RocketChat/Rocket.Chat/pull/25306))

- Regression: Fix services Docker build on CI ([#25181](https://github.com/RocketChat/Rocket.Chat/pull/25181))

- Regression: Fix services-image-build-check ([#25519](https://github.com/RocketChat/Rocket.Chat/pull/25519))

- Regression: Fix size of custom emoji and render emoji on thread message preview ([#25314](https://github.com/RocketChat/Rocket.Chat/pull/25314))

- Regression: Fix sort field files.list ([#25687](https://github.com/RocketChat/Rocket.Chat/pull/25687))

- Regression: Fix the alpine image and dev UX installing matrix-rust-sdk-bindings ([#25319](https://github.com/RocketChat/Rocket.Chat/pull/25319))

  The package only included a few pre-built which caused all macs to have to compile every time they installed and also caused our alpine not to work.

  This temporarily switches to a fork of the matrix-appservice-bridge package.

  Made changes to one of its child dependencies `matrix-rust-sdk-bindings` that adds pre-built binaries for mac and musl (for alpine).

- Regression: Messages in new message template Crashing. ([#25327](https://github.com/RocketChat/Rocket.Chat/pull/25327))

- Regression: Missing settings group descriptions ([#25639](https://github.com/RocketChat/Rocket.Chat/pull/25639))

  <img width='100%' height='auto' src='https://user-images.githubusercontent.com/27704687/170372985-d849d71e-389b-49c0-a2b3-2bbd08d65c41.gif' />

- Regression: Revert Bugsnag version ([#25313](https://github.com/RocketChat/Rocket.Chat/pull/25313))

- Regression: Rocket.Chat Webapp not loading. ([#25349](https://github.com/RocketChat/Rocket.Chat/pull/25349))

- Regression: Show username and real name on the message system ([#25254](https://github.com/RocketChat/Rocket.Chat/pull/25254))

- Regression: Shows error if micro service cannot connect to Mongo ([#25301](https://github.com/RocketChat/Rocket.Chat/pull/25301))

- Regression: Subscription menu not appearing for non installed but subscribed apps ([#25627](https://github.com/RocketChat/Rocket.Chat/pull/25627))

  Fixed a problem on which the AppMenu component did not appear for apps that had an active subscription but weren't installed, now the rendering of the component is also based on the isSubscribed flag, and the appearance of the uninstall and enable/disable options are based on the app.installed flag so that the correct options appear on all the edge cases.
  Demo gif:
  ![subscription-manager-fix](https://user-images.githubusercontent.com/43561537/170132040-dc8535c0-8056-4fb2-b008-afaece744868.gif)

- Regression: Update settings groups description ([#25663](https://github.com/RocketChat/Rocket.Chat/pull/25663))

- Regression: Use exact Node version on micro services Docker images ([#25287](https://github.com/RocketChat/Rocket.Chat/pull/25287))

- Regression: Validate empty fields for Message template ([#25250](https://github.com/RocketChat/Rocket.Chat/pull/25250))

- Regression: VoIp wrap up modal not opening after call disconnect ([#25651](https://github.com/RocketChat/Rocket.Chat/pull/25651))

  This PR fixes a bug preventing the wrap up call modal from being displayed after caller or agent ends the call.

- Regression: yarn dev triggers build dependencies ([#25208](https://github.com/RocketChat/Rocket.Chat/pull/25208))

- Release 4.7.0 ([#25390](https://github.com/RocketChat/Rocket.Chat/pull/25390) by [@Himanshu664](https://github.com/Himanshu664) & [@dependabot[bot]](https://github.com/dependabot[bot]) & [@lingohub[bot]](https://github.com/lingohub[bot]))

- Release 4.7.1 ([#25510](https://github.com/RocketChat/Rocket.Chat/pull/25510) by [@felipe-menelau](https://github.com/felipe-menelau))

- Release 4.7.2 ([#25580](https://github.com/RocketChat/Rocket.Chat/pull/25580))

- Test: Migrate 13-permissions from cypress to playwright ([#25558](https://github.com/RocketChat/Rocket.Chat/pull/25558) by [@souzaramon](https://github.com/souzaramon))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Himanshu664](https://github.com/Himanshu664)
- [@aakash-gitdev](https://github.com/aakash-gitdev)
- [@amolghode1981](https://github.com/amolghode1981)
- [@carlosrodrigues94](https://github.com/carlosrodrigues94)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@divinespear](https://github.com/divinespear)
- [@eduardofcabrera](https://github.com/eduardofcabrera)
- [@felipe-menelau](https://github.com/felipe-menelau)
- [@kibonusp](https://github.com/kibonusp)
- [@lingohub[bot]](https://github.com/lingohub[bot])
- [@matheuslc](https://github.com/matheuslc)
- [@ostjen](https://github.com/ostjen)
- [@paulobernardoaf](https://github.com/paulobernardoaf)
- [@sidmohanty11](https://github.com/sidmohanty11)
- [@souzaramon](https://github.com/souzaramon)
- [@ujorgeleite](https://github.com/ujorgeleite)
- [@weslley543](https://github.com/weslley543)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@PedroRorato](https://github.com/PedroRorato)
- [@alansikora](https://github.com/alansikora)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@aleksandernsilva](https://github.com/aleksandernsilva)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@hugocostadev](https://github.com/hugocostadev)
- [@jeanfbrito](https://github.com/jeanfbrito)
- [@juliajforesti](https://github.com/juliajforesti)
- [@marceloschmidt](https://github.com/marceloschmidt)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tapiarafael](https://github.com/tapiarafael)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@tmontini](https://github.com/tmontini)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.7.4
`2022-05-30  ·  1 🐛  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

<details>
<summary>🔍 Minor changes</summary>


- Load missed messages from opened rooms when reconnect ([#553](https://github.com/RocketChat/Rocket.Chat/pull/553))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)
- [@rodrigok](https://github.com/rodrigok)

# 4.7.3
`2022-05-20  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 4.7.2
`2022-05-20  ·  5 🐛  ·  2 🔍  ·  7 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Dynamic load matrix is enabled and handle failure  ([#25495](https://github.com/RocketChat/Rocket.Chat/pull/25495))

- Initial User not added to default channel ([#25544](https://github.com/RocketChat/Rocket.Chat/pull/25544))

  If injecting initial user.  The user wasn’t added to the default General channel

- One of the triggers was not working correctly ([#25409](https://github.com/RocketChat/Rocket.Chat/pull/25409))

- UI/UX issues on Live Chat widget ([#25407](https://github.com/RocketChat/Rocket.Chat/pull/25407))

- User abandonment setting was not working doe to failing event hook ([#25520](https://github.com/RocketChat/Rocket.Chat/pull/25520))

  A setting watcher and the query for grabbing abandoned chats were broken, now they're not.

<details>
<summary>🔍 Minor changes</summary>


- Chore: Add Livechat repo into Monorepo packages ([#25312](https://github.com/RocketChat/Rocket.Chat/pull/25312))

- Release 4.7.2 ([#25580](https://github.com/RocketChat/Rocket.Chat/pull/25580))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.7.1
`2022-05-13  ·  1 🎉  ·  2 🐛  ·  1 🔍  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🎉 New features


- Use setting to determine if initial general channel is needed ([#25441](https://github.com/RocketChat/Rocket.Chat/pull/25441) by [@felipe-menelau](https://github.com/felipe-menelau))

  - Adds flag responsible for overwriting #general channel creation

### 🐛 Bug fixes


- LDAP sync removing users from channels when multiple groups are mapped to it ([#25434](https://github.com/RocketChat/Rocket.Chat/pull/25434))

- Spotlight results showing usernames instead of real names ([#25471](https://github.com/RocketChat/Rocket.Chat/pull/25471))

<details>
<summary>🔍 Minor changes</summary>


- Release 4.7.1 ([#25510](https://github.com/RocketChat/Rocket.Chat/pull/25510) by [@felipe-menelau](https://github.com/felipe-menelau))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@felipe-menelau](https://github.com/felipe-menelau)

### 👩‍💻👨‍💻 Core Team 🤓

- [@d-gubert](https://github.com/d-gubert)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.7.0
`2022-05-04  ·  4 🎉  ·  7 🚀  ·  33 🐛  ·  69 🔍  ·  35 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🎉 New features


- Add expire index to integration history ([#25087](https://github.com/RocketChat/Rocket.Chat/pull/25087))

- Alpha Matrix Federation ([#23688](https://github.com/RocketChat/Rocket.Chat/pull/23688))

  Experimental support for Matrix Federation with a Bridge

  https://user-images.githubusercontent.com/51996/164530391-e8b17ecd-a4d0-4ef8-a8b7-81230c1773d3.mp4

- Expand Apps Engine's environment variable allowed list ([#23870](https://github.com/RocketChat/Rocket.Chat/pull/23870) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Message Template React Component ([#23971](https://github.com/RocketChat/Rocket.Chat/pull/23971))

  Complete rewrite of the messages component in react. Visual changes should be minimal as well as user impact, with no break changes (unless you've customized the blaze template).



  ![Screen Shot 2022-04-05 at 11 14 18](https://user-images.githubusercontent.com/27704687/161774027-38dd9c7b-eeeb-45e2-b9d8-ea2a9be8486d.png)
  In case you encounter any problems, or want to compare, temporarily it is possible to use the old version

  <img width="556" alt="image" src="https://user-images.githubusercontent.com/5263975/162099800-15806953-f2f5-4905-a424-3f095076bc1d.png">

### 🚀 Improvements


- Add OTR Room States ([#24565](https://github.com/RocketChat/Rocket.Chat/pull/24565))

  Earlier OTR room uses only 2 states, we need more states to support future features.
  This adds more states for the OTR contextualBar.


  - Expired
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 52" src="https://user-images.githubusercontent.com/27704687/164283351-068756be-3419-4773-9d55-c9c1a72f5a19.png">


  - Declined
  <img width="343" alt='Screen Shot 2022-04-20 at 13 49 28' src='https://user-images.githubusercontent.com/27704687/164282312-fa3c6841-23d4-46e1-a8e9-80882a105d8c.png' />


  - Error
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 26" src="https://user-images.githubusercontent.com/27704687/164283261-95e06d06-b0d0-402d-bccc-66596ff4dcd3.png">

- Add tooltip to sidebar room menu ([#24405](https://github.com/RocketChat/Rocket.Chat/pull/24405) by [@Himanshu664](https://github.com/Himanshu664))

- Added MaxNickNameLength and MaxBioLength constants ([#25231](https://github.com/RocketChat/Rocket.Chat/pull/25231) by [@aakash-gitdev](https://github.com/aakash-gitdev))

- Added tooltip options for message menu ([#24431](https://github.com/RocketChat/Rocket.Chat/pull/24431) by [@Himanshu664](https://github.com/Himanshu664))

- Improve active/hover colors in account sidebar ([#25024](https://github.com/RocketChat/Rocket.Chat/pull/25024) by [@Himanshu664](https://github.com/Himanshu664))

- Performance for some Omnichannel features ([#25217](https://github.com/RocketChat/Rocket.Chat/pull/25217))

- Rename upgrade tab routes ([#25097](https://github.com/RocketChat/Rocket.Chat/pull/25097))

  Change 'upgrade tab' routes names from camelCase ('goFullyFeatured') to kebab-case ('go-fully-featured') due to URL naming consistency. Changed types, main function and test.

### 🐛 Bug fixes


- Add katex render to new message react template ([#25239](https://github.com/RocketChat/Rocket.Chat/pull/25239))

- Add reaction not working in legacy messages ([#25222](https://github.com/RocketChat/Rocket.Chat/pull/25222))

- Added invalid password error message ([#24714](https://github.com/RocketChat/Rocket.Chat/pull/24714) by [@Himanshu664](https://github.com/Himanshu664))

- Adjust email label in Setup Wizard i18n files ([#25260](https://github.com/RocketChat/Rocket.Chat/pull/25260))

  - remove 'Company' label on onboarding email keys in certain languages

- AgentOverview analytics wrong departmentId parameter ([#25073](https://github.com/RocketChat/Rocket.Chat/pull/25073) by [@paulobernardoaf](https://github.com/paulobernardoaf))

  When filtering the analytics charts by department, data would not appear because the object:
  ```js
  {
  value: "department-id",
  label: "department-name"
  }
  ```
  was being used in the `departmentId` parameter.


  - Before:
  ![image](https://user-images.githubusercontent.com/30026625/161832057-d96ffd21-a7dd-421e-bfaa-3b9f4a9127b2.png)


  - After:
  ![image](https://user-images.githubusercontent.com/30026625/161831092-9ee77b51-b083-4f45-9c48-ab2e0511c4d6.png)

- Client disconnection on network loss ([#25170](https://github.com/RocketChat/Rocket.Chat/pull/25170) by [@amolghode1981](https://github.com/amolghode1981))

  Agent gets disconnected (or Unregistered) from asterisk in multiple ways. The goal is that agent should remain online
  unless agent explicitly logs off.
  Agent can stop receiving calls in multiple ways due to network loss. Network loss can happen in following ways.

  1. User tries to switch the network. User experiences a glitch of disconnectivity. This can be simulated by turning the network off
  in the network tab of chrome's dev tool. This can disconnect the UA if the disconnection happens just before the registration refresh.

  2. Second reason is when computer goes in sleep mode.

  3. Third reason is that when asterisk is crashed/in maintenance mode/explicitly stopped.

  Solution:
  The idea is to detect the network disconnection and start the start the attempts to reconnect.
  The detection of the disconnection does not happen in case#1. The SIPUA's UserAgent transport does not
  call onDisconnected when network loss of such kind happens. To tackle this problem, window's online and offline event handlers are
  used.

  The number of retries is configurable but ideally it is to be kept at -1. Whenever disconnection happens, it should keep on trying to
  reconnect with increasing backoff time. This behaviour is useful when the asterisk is stopped.

  When the server is disconnected, it should be indicated on the phone button.

- Close room when dismiss wrap up call modal ([#25056](https://github.com/RocketChat/Rocket.Chat/pull/25056))

- Custom sound error toast messages ([#24515](https://github.com/RocketChat/Rocket.Chat/pull/24515) by [@Himanshu664](https://github.com/Himanshu664))

- Deactivating user breaks if user is the only room owner ([#24933](https://github.com/RocketChat/Rocket.Chat/pull/24933) by [@sidmohanty11](https://github.com/sidmohanty11))

  ## Before

  https://user-images.githubusercontent.com/73601258/160000871-cfc2f2a5-2a59-4d27-8049-7754d003dd48.mp4



  ## After
  https://user-images.githubusercontent.com/73601258/159998287-681ab475-ff33-4282-82ff-db751c59a392.mp4

- Desktop notification on multi-instance environments ([#25220](https://github.com/RocketChat/Rocket.Chat/pull/25220))

- End call button disappearing when on-hold ([#24936](https://github.com/RocketChat/Rocket.Chat/pull/24936))

- FormData uploads not working ([#25069](https://github.com/RocketChat/Rocket.Chat/pull/25069))

- Full error message is visible ([#24856](https://github.com/RocketChat/Rocket.Chat/pull/24856) by [@Himanshu664](https://github.com/Himanshu664))

- Incorrect websocket url in livechat widget ([#25261](https://github.com/RocketChat/Rocket.Chat/pull/25261))

- Invitation links don't redirect to the registration form ([#25082](https://github.com/RocketChat/Rocket.Chat/pull/25082))

- Message menu action not working on legacy messages. ([#25148](https://github.com/RocketChat/Rocket.Chat/pull/25148))

- Message preview not available for queued chats ([#25092](https://github.com/RocketChat/Rocket.Chat/pull/25092))

- NPS never finishing sending results ([#25067](https://github.com/RocketChat/Rocket.Chat/pull/25067))

- Prevent sequential messages edited icon to hide on hover ([#24984](https://github.com/RocketChat/Rocket.Chat/pull/24984))

  ### before
  <img width="297" alt="Screen Shot 2022-03-29 at 13 35 56" src="https://user-images.githubusercontent.com/27704687/160661700-c2aebe05-a1be-4235-9d20-bce0b6e5fdb5.png">

  ### after
  <img width="300" alt="Screen Shot 2022-03-29 at 11 48 05" src="https://user-images.githubusercontent.com/27704687/160639208-3883a7b0-718a-4e9d-87b1-db960fe9bfcd.png">

- Proxy settings being ignored ([#25022](https://github.com/RocketChat/Rocket.Chat/pull/25022))

  Modify Meteor's `HTTP.call` to add back proxy support

- Read receipts show with color gray when not read yet ([#25244](https://github.com/RocketChat/Rocket.Chat/pull/25244))

- Read receipts showing before message read ([#25216](https://github.com/RocketChat/Rocket.Chat/pull/25216))

- Replace encrypted text to Encrypted Message Placeholder ([#24166](https://github.com/RocketChat/Rocket.Chat/pull/24166))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/150807900-154a9cdb-ee13-4333-8628-f287ab914b40.png)

  ### after
  <img width="814" alt="Screenshot 2022-01-13 at 8 57 47 PM" src="https://user-images.githubusercontent.com/58601732/149359411-23e2430b-89e4-48b4-a3ad-65471d058551.png">

- Reply button behavior on broadcast channel ([#25175](https://github.com/RocketChat/Rocket.Chat/pull/25175))

  Hide reply button for the user that sent the message

- room creation fails if app framework is disabled ([#25200](https://github.com/RocketChat/Rocket.Chat/pull/25200))

- Showing Blank Message Inside Report ([#25007](https://github.com/RocketChat/Rocket.Chat/pull/25007))

  https://user-images.githubusercontent.com/53515714/161038085-4a86c7ae-6751-4996-9767-b1c9e0331a6c.mp4

- Toolbox hiding under contextual bar ([#25237](https://github.com/RocketChat/Rocket.Chat/pull/25237))

- Upgrade Tab showing for a split second ([#25050](https://github.com/RocketChat/Rocket.Chat/pull/25050))

- Use correct room property for call ended at ([#24932](https://github.com/RocketChat/Rocket.Chat/pull/24932))

- UserAutoComplete not rendering UserAvatar correctly ([#25055](https://github.com/RocketChat/Rocket.Chat/pull/25055))

  ### before
  ![Screen Shot 2022-04-04 at 16 50 21](https://user-images.githubusercontent.com/27704687/161620921-800bf66a-806d-4f83-b2e1-073c34215001.png)

  ### after
  ![Screen Shot 2022-04-04 at 16 49 00](https://user-images.githubusercontent.com/27704687/161620720-3e27774d-c241-46ca-b764-932a9295d709.png)

- UserCard sanitization ([#25089](https://github.com/RocketChat/Rocket.Chat/pull/25089))

  - Rewrites the component to TS

  - Fixes some visual issues

  ### before
  ![Screen Shot 2022-04-07 at 00 23 11](https://user-images.githubusercontent.com/27704687/162113925-5c9484d1-23e9-4623-8b86-3fbc71b461a1.png)

  ### after
  ![Screen Shot 2022-04-07 at 00 07 13](https://user-images.githubusercontent.com/27704687/162112353-afd6aac6-b27c-4470-a642-631b8080d59e.png)

- Video and Audio not skipping forward ([#19866](https://github.com/RocketChat/Rocket.Chat/pull/19866))

- VoIP disabled/enabled  sequence puts voip agent in error state ([#25230](https://github.com/RocketChat/Rocket.Chat/pull/25230) by [@amolghode1981](https://github.com/amolghode1981))

  Initially it was thought that the issue occurs because of the race condition while changing the client settings vs those settings reflected on server side. So a natural solution to solve this is to wait for setting change event 'private-settings-changed'. Then if 'VoIP_Enabled' is updated and it is true, set voipEnabled  to true in useVoipClient.ts (on client side)

  It was realised that the race does not happen because of the database or server noticing the changes late. But because of the time taken to establish the AMI connection with Asterisk.

  Solution:


  1. Change apps/meteor/app/voip/server/startup.ts. When VoIP_Enabled is changed, await for Voip.init() to complete and then broadcast connector.statuschanged  with changed value.

  2. From apps/meteor/server/modules/listeners/listeners.module.ts use notifyLoggedInThisInstance to notify all logged in users on current instance.

  3. in apps/meteor/client/providers/CallProvider/hooks/useVoipClient.ts add the event handler that receives this event. Change voipEnabled from constant to state. Change this state based on the 'value' that is received by the handler.

<details>
<summary>🔍 Minor changes</summary>


- Bump body-parser from 1.19.2 to 1.20.0 in /ee/server/services ([#25042](https://github.com/RocketChat/Rocket.Chat/pull/25042) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ejson from 2.2.1 to 2.2.2 ([#25057](https://github.com/RocketChat/Rocket.Chat/pull/25057) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump eslint-plugin-anti-trojan-source from 1.0.6 to 1.1.0 ([#25076](https://github.com/RocketChat/Rocket.Chat/pull/25076) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump minimist from 1.2.5 to 1.2.6 in /ee/server/services ([#24991](https://github.com/RocketChat/Rocket.Chat/pull/24991) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino and pino-pretty ([#25052](https://github.com/RocketChat/Rocket.Chat/pull/25052))

- Bump template-file from 6.0.0 to 6.0.1 ([#25002](https://github.com/RocketChat/Rocket.Chat/pull/25002) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: Add error boundary to message component ([#25223](https://github.com/RocketChat/Rocket.Chat/pull/25223))

  Not crash the whole application if something goes wrong in the MessageList component.

  ![image](https://user-images.githubusercontent.com/40830821/162269915-931c5c3c-c979-4234-b74c-371f67467ce0.png)

- Chore: Add options to debug stdout and rate limiter ([#25336](https://github.com/RocketChat/Rocket.Chat/pull/25336))

- Chore: Add root package.json to houston files ([#25286](https://github.com/RocketChat/Rocket.Chat/pull/25286))

  See title

- Chore: Add yarn plugin to check node and yarn version ([#25224](https://github.com/RocketChat/Rocket.Chat/pull/25224))

- Chore: Bump fuselage ([#25371](https://github.com/RocketChat/Rocket.Chat/pull/25371))

- Chore: Bump Fuselage packages ([#25259](https://github.com/RocketChat/Rocket.Chat/pull/25259))

- Chore: Cancel running jobs if PR is updated ([#24708](https://github.com/RocketChat/Rocket.Chat/pull/24708))

- Chore: Convert admin custom sound to tsx ([#25128](https://github.com/RocketChat/Rocket.Chat/pull/25128))

- Chore: Convert LivechatAgentActivity to raw model and TS ([#25123](https://github.com/RocketChat/Rocket.Chat/pull/25123))

- Chore: Convert Mailer to TS ([#25121](https://github.com/RocketChat/Rocket.Chat/pull/25121))

- Chore: Convert NotificationStatus to TS ([#25125](https://github.com/RocketChat/Rocket.Chat/pull/25125))

- Chore: Create README.md for Rest Typings ([#25335](https://github.com/RocketChat/Rocket.Chat/pull/25335))

- Chore: ensure scripts use cross-env and ignore some dirs (ROC-54) ([#25218](https://github.com/RocketChat/Rocket.Chat/pull/25218) by [@souzaramon](https://github.com/souzaramon))

  - data and test-failure should be ignored

  - ensure scripts use cross-env

- Chore: Fix return type warnings ([#25275](https://github.com/RocketChat/Rocket.Chat/pull/25275))

- Chore: Migrate oauth2server to typescript ([#25126](https://github.com/RocketChat/Rocket.Chat/pull/25126))

- Chore: Minor dependency updates ([#25269](https://github.com/RocketChat/Rocket.Chat/pull/25269))

- Chore: Missing keys in APIsDisplay ([#24464](https://github.com/RocketChat/Rocket.Chat/pull/24464))

- Chore: Monorepo  ([#25074](https://github.com/RocketChat/Rocket.Chat/pull/25074))

- Chore: move definitions to packages ([#25085](https://github.com/RocketChat/Rocket.Chat/pull/25085))

- Chore: organize test files and fix code coverage ([#24900](https://github.com/RocketChat/Rocket.Chat/pull/24900))

- Chore: Remove Alpine image deps after using them ([#25053](https://github.com/RocketChat/Rocket.Chat/pull/25053))

- Chore: Remove duplicated useUserRoom ([#25180](https://github.com/RocketChat/Rocket.Chat/pull/25180))

- Chore: Remove old files from removed Omnichannel feature ([#25129](https://github.com/RocketChat/Rocket.Chat/pull/25129))

- Chore: Remove package-lock.json from houston files ([#25280](https://github.com/RocketChat/Rocket.Chat/pull/25280))

  Houston config in the `package.json` file still mentioned `package-lock.json`, but it doesn't exist anymore

- Chore: Remove unused Drone CI files ([#25124](https://github.com/RocketChat/Rocket.Chat/pull/25124))

- Chore: Sync with master ([#25284](https://github.com/RocketChat/Rocket.Chat/pull/25284))

- Chore: Template to generate packages ([#25174](https://github.com/RocketChat/Rocket.Chat/pull/25174))

  ```
  npx hygen package new test
  ```

- Chore: Tests with Playwright (task: All works) ([#25122](https://github.com/RocketChat/Rocket.Chat/pull/25122) by [@weslley543](https://github.com/weslley543))

- Chore: Tests with Playwright (task: ROC-28, 09-channels) ([#25196](https://github.com/RocketChat/Rocket.Chat/pull/25196))

- Chore: TS conversion folder client ([#25031](https://github.com/RocketChat/Rocket.Chat/pull/25031))

- Chore: TS migration SortList ([#25167](https://github.com/RocketChat/Rocket.Chat/pull/25167))

- Chore: Update Livechat to the last version ([#25257](https://github.com/RocketChat/Rocket.Chat/pull/25257))

- Chore: Update Livechat version ([#25130](https://github.com/RocketChat/Rocket.Chat/pull/25130))

- Chore: update OTR icon ([#24521](https://github.com/RocketChat/Rocket.Chat/pull/24521) by [@kibonusp](https://github.com/kibonusp))

  I changed the shredder icon in OTR contextual bar to the stopwatch icon, recently added to the fuselage.

- i18n: Language update from LingoHub 🤖 on 2022-04-04Z ([#25043](https://github.com/RocketChat/Rocket.Chat/pull/25043))

- Merge master into develop & Set version to 4.7.0-develop ([#25028](https://github.com/RocketChat/Rocket.Chat/pull/25028))

- Regression: Add `isPending` status to message ([#25299](https://github.com/RocketChat/Rocket.Chat/pull/25299))

- Regression: Add eslint package to micro services Dockerfile ([#25311](https://github.com/RocketChat/Rocket.Chat/pull/25311))

- Regression: Add select message to system message and thread preview and allow select on legacy template ([#25251](https://github.com/RocketChat/Rocket.Chat/pull/25251))

- Regression: Avatar not loading on first direct message ([#25211](https://github.com/RocketChat/Rocket.Chat/pull/25211))

  fix avatar not loading on a first direct message

- Regression: Better MongoDB connection management for micro services ([#25323](https://github.com/RocketChat/Rocket.Chat/pull/25323))

- Regression: bump onboarding-ui version ([#25320](https://github.com/RocketChat/Rocket.Chat/pull/25320))

  - Bump to 'next' the onboarding-ui package from fuselage.

  - Update from 'companyEmail' to 'email' adminData usage types

- Regression: Change preference to be default legacy messages ([#25255](https://github.com/RocketChat/Rocket.Chat/pull/25255))

- Regression: CI playwright ([#25168](https://github.com/RocketChat/Rocket.Chat/pull/25168))

- Regression: eslint not running on packages ([#25305](https://github.com/RocketChat/Rocket.Chat/pull/25305))

- Regression: Fix CI monorepo build ([#25107](https://github.com/RocketChat/Rocket.Chat/pull/25107))

- Regression: Fix clicking on visitor's chat in the sidebar does not display the chat window ([#25380](https://github.com/RocketChat/Rocket.Chat/pull/25380))

  Fix: livechat room not opening.

- Regression: Fix English i18n react text ([#25368](https://github.com/RocketChat/Rocket.Chat/pull/25368))

  Incorrect text in reaction tooltip has been fixed

- Regression: Fix federation Matrix bridge startup ([#25273](https://github.com/RocketChat/Rocket.Chat/pull/25273))

- Regression: Fix micro services Docker build ([#25193](https://github.com/RocketChat/Rocket.Chat/pull/25193))

- Regression: Fix multi line is not showing an empty line between lines ([#25317](https://github.com/RocketChat/Rocket.Chat/pull/25317))

- Regression: Fix reply button not working when hideFlexTab is enabled ([#25306](https://github.com/RocketChat/Rocket.Chat/pull/25306))

- Regression: Fix services Docker build on CI ([#25181](https://github.com/RocketChat/Rocket.Chat/pull/25181))

- Regression: Fix size of custom emoji and render emoji on thread message preview ([#25314](https://github.com/RocketChat/Rocket.Chat/pull/25314))

- Regression: Fix the alpine image and dev UX installing matrix-rust-sdk-bindings ([#25319](https://github.com/RocketChat/Rocket.Chat/pull/25319))

  The package only included a few pre-built which caused all macs to have to compile every time they installed and also caused our alpine not to work.

  This temporarily switches to a fork of the matrix-appservice-bridge package.

  Made changes to one of its child dependencies `matrix-rust-sdk-bindings` that adds pre-built binaries for mac and musl (for alpine).

- Regression: Messages in new message template Crashing. ([#25327](https://github.com/RocketChat/Rocket.Chat/pull/25327))

- Regression: Revert Bugsnag version ([#25313](https://github.com/RocketChat/Rocket.Chat/pull/25313))

- Regression: Rocket.Chat Webapp not loading. ([#25349](https://github.com/RocketChat/Rocket.Chat/pull/25349))

- Regression: Show username and real name on the message system ([#25254](https://github.com/RocketChat/Rocket.Chat/pull/25254))

- Regression: Shows error if micro service cannot connect to Mongo ([#25301](https://github.com/RocketChat/Rocket.Chat/pull/25301))

- Regression: Use exact Node version on micro services Docker images ([#25287](https://github.com/RocketChat/Rocket.Chat/pull/25287))

- Regression: Validate empty fields for Message template ([#25250](https://github.com/RocketChat/Rocket.Chat/pull/25250))

- Regression: yarn dev triggers build dependencies ([#25208](https://github.com/RocketChat/Rocket.Chat/pull/25208))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Himanshu664](https://github.com/Himanshu664)
- [@aakash-gitdev](https://github.com/aakash-gitdev)
- [@amolghode1981](https://github.com/amolghode1981)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@kibonusp](https://github.com/kibonusp)
- [@paulobernardoaf](https://github.com/paulobernardoaf)
- [@sidmohanty11](https://github.com/sidmohanty11)
- [@souzaramon](https://github.com/souzaramon)
- [@weslley543](https://github.com/weslley543)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@alansikora](https://github.com/alansikora)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@jeanfbrito](https://github.com/jeanfbrito)
- [@juliajforesti](https://github.com/juliajforesti)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@tmontini](https://github.com/tmontini)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.6.3
`2022-04-19  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🐛 Bug fixes


- Desktop notification on multi-instance environments ([#25220](https://github.com/RocketChat/Rocket.Chat/pull/25220))

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.6.2
`2022-04-14  ·  2 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🐛 Bug fixes


- Database indexes not being created ([#25101](https://github.com/RocketChat/Rocket.Chat/pull/25101))

- Deactivating user breaks if user is the only room owner ([#24933](https://github.com/RocketChat/Rocket.Chat/pull/24933) by [@sidmohanty11](https://github.com/sidmohanty11))

  ## Before

  https://user-images.githubusercontent.com/73601258/160000871-cfc2f2a5-2a59-4d27-8049-7754d003dd48.mp4



  ## After
  https://user-images.githubusercontent.com/73601258/159998287-681ab475-ff33-4282-82ff-db751c59a392.mp4

### 👩‍💻👨‍💻 Contributors 😍

- [@sidmohanty11](https://github.com/sidmohanty11)

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.6.1
`2022-04-07  ·  6 🐛  ·  5 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🐛 Bug fixes


- FormData uploads not working ([#25069](https://github.com/RocketChat/Rocket.Chat/pull/25069))

- Invitation links don't redirect to the registration form ([#25082](https://github.com/RocketChat/Rocket.Chat/pull/25082))

- NPS never finishing sending results ([#25067](https://github.com/RocketChat/Rocket.Chat/pull/25067))

- Proxy settings being ignored ([#25022](https://github.com/RocketChat/Rocket.Chat/pull/25022))

  Modify Meteor's `HTTP.call` to add back proxy support

- Upgrade Tab showing for a split second ([#25050](https://github.com/RocketChat/Rocket.Chat/pull/25050))

- UserAutoComplete not rendering UserAvatar correctly ([#25055](https://github.com/RocketChat/Rocket.Chat/pull/25055))

  ### before
  ![Screen Shot 2022-04-04 at 16 50 21](https://user-images.githubusercontent.com/27704687/161620921-800bf66a-806d-4f83-b2e1-073c34215001.png)

  ### after
  ![Screen Shot 2022-04-04 at 16 49 00](https://user-images.githubusercontent.com/27704687/161620720-3e27774d-c241-46ca-b764-932a9295d709.png)

### 👩‍💻👨‍💻 Core Team 🤓

- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.6.0
`2022-04-01  ·  2 🎉  ·  7 🚀  ·  57 🐛  ·  62 🔍  ·  34 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🎉 New features


- Telemetry Events ([#24781](https://github.com/RocketChat/Rocket.Chat/pull/24781) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Upgrade Tab ([#24835](https://github.com/RocketChat/Rocket.Chat/pull/24835))

  ![image](https://user-images.githubusercontent.com/27704687/160172260-c656282e-a487-4092-948d-d11c9bacb598.png)

### 🚀 Improvements


- **ENTERPRISE:** Don't start presence monitor when running micro services ([#24739](https://github.com/RocketChat/Rocket.Chat/pull/24739))

- Adding new statistics related to voip and omnichannel ([#24887](https://github.com/RocketChat/Rocket.Chat/pull/24887))

  - Total of Canned response messages sent

  - Total of tags used

  - Last-Chatted Agent Preferred (enabled/disabled)

  - Assign new conversations to the contact manager (enabled/disabled)

  - How to handle Visitor Abandonment setting

  - Amount of chats placed on hold

  - VoIP Enabled

  - Amount of VoIP Calls

  - Amount of VoIP Extensions connected

  - Amount of Calls placed on hold (1x per call)

  - Fixed Session Aggregation type definitions

- New omnichannel statistics and async statistics processing. ([#24749](https://github.com/RocketChat/Rocket.Chat/pull/24749))

  https://app.clickup.com/t/1z4zg4e

- Standarize queue behavior for managers and agents when subscribing ([#24837](https://github.com/RocketChat/Rocket.Chat/pull/24837))

- Updated links in readme ([#24028](https://github.com/RocketChat/Rocket.Chat/pull/24028) by [@aswinidev](https://github.com/aswinidev))

- UX - VoIP Call Component ([#24748](https://github.com/RocketChat/Rocket.Chat/pull/24748))

- Voip Extensions disabled state ([#24750](https://github.com/RocketChat/Rocket.Chat/pull/24750))

### 🐛 Bug fixes


- "livechat/webrtc.call" endpoint not working ([#24804](https://github.com/RocketChat/Rocket.Chat/pull/24804))

- "Match error" when converting a team to a channel ([#24629](https://github.com/RocketChat/Rocket.Chat/pull/24629))

  - Fix "Match error"  when trying to convert a channel to a team;

- **ENTERPRISE:** Auto reload feature of ddp-streamer micro service ([#24793](https://github.com/RocketChat/Rocket.Chat/pull/24793))

- **ENTERPRISE:** DDP streamer not sending data to all clients ([#24738](https://github.com/RocketChat/Rocket.Chat/pull/24738))

- **ENTERPRISE:** Notifications not being sent by ddp-streamer ([#24831](https://github.com/RocketChat/Rocket.Chat/pull/24831))

- **ENTERPRISE:** Presence micro service logic ([#24724](https://github.com/RocketChat/Rocket.Chat/pull/24724))

- **VOIP:** SidebarFooter component  ([#24838](https://github.com/RocketChat/Rocket.Chat/pull/24838))

  - Improve the CallProvider code;

  - Adjust the text case of the VoIP component on the FooterSidebar;

  - Fix the bad behavior with the changes in queue's name.

- `PaginatedSelectFiltered` not handling changes ([#24732](https://github.com/RocketChat/Rocket.Chat/pull/24732))

- API Error preventing adding an email to users without one (like bot/app users) ([#24709](https://github.com/RocketChat/Rocket.Chat/pull/24709))

- Apple login script being loaded even when Apple Login is disabled. ([#24760](https://github.com/RocketChat/Rocket.Chat/pull/24760))

- Apple OAuth ([#24879](https://github.com/RocketChat/Rocket.Chat/pull/24879))

- auto-join team channels not honoring user preferences ([#24779](https://github.com/RocketChat/Rocket.Chat/pull/24779) by [@ostjen](https://github.com/ostjen))

- Broken build caused by PRs modifying same file differently ([#24863](https://github.com/RocketChat/Rocket.Chat/pull/24863))

- Broken multiple OAuth integrations ([#24705](https://github.com/RocketChat/Rocket.Chat/pull/24705))

- Components for user search ([#24677](https://github.com/RocketChat/Rocket.Chat/pull/24677))

- Critical: Incorrect visitor getting assigned to a chat from apps ([#24805](https://github.com/RocketChat/Rocket.Chat/pull/24805))

- Custom script not being fired ([#24901](https://github.com/RocketChat/Rocket.Chat/pull/24901))

- Date Message Export Filter Fix ([#24542](https://github.com/RocketChat/Rocket.Chat/pull/24542) by [@eduardofcabrera](https://github.com/eduardofcabrera))

  Fix message export filter to get all messages between "from date" and "to date", including "to date".

- DDP Rate Limiter Translation key ([#24898](https://github.com/RocketChat/Rocket.Chat/pull/24898))

  Before:
  <img width="267" alt="image" src="https://user-images.githubusercontent.com/40830821/159324037-b17e2492-e007-49fd-bfd1-f1d009301c44.png">


  Now:
  <img width="611" alt="image" src="https://user-images.githubusercontent.com/40830821/159323594-10cf69a8-57dd-4e01-b4d3-31c92667a754.png">

- DDP streamer errors ([#24710](https://github.com/RocketChat/Rocket.Chat/pull/24710))

- Disable voip button when call is in progress ([#24864](https://github.com/RocketChat/Rocket.Chat/pull/24864))

- Duplicated 'name' log key ([#24590](https://github.com/RocketChat/Rocket.Chat/pull/24590))

- Duplicated "jump to message" button on starred messages ([#24867](https://github.com/RocketChat/Rocket.Chat/pull/24867) by [@Himanshu664](https://github.com/Himanshu664))

- External search providers not working ([#24860](https://github.com/RocketChat/Rocket.Chat/pull/24860) by [@tkurz](https://github.com/tkurz))

- German translation for Monitore ([#24785](https://github.com/RocketChat/Rocket.Chat/pull/24785) by [@JMoVS](https://github.com/JMoVS))

- Handle Other Formats inside Upload Avatar ([#24226](https://github.com/RocketChat/Rocket.Chat/pull/24226))

  After resolving issue #24213 :


  https://user-images.githubusercontent.com/53515714/150325012-91413025-786e-4ce0-ae75-629f6b05b024.mp4

- High CPU usage caused by CallProvider ([#24994](https://github.com/RocketChat/Rocket.Chat/pull/24994))

  Remove infinity loop inside useVoipClient hook.

  #closes #24970

- Ignore customClass on messages ([#24845](https://github.com/RocketChat/Rocket.Chat/pull/24845))

- LDAP avatars being rotated according to metadata even if the setting to rotate uploads is off ([#24320](https://github.com/RocketChat/Rocket.Chat/pull/24320))

  - Use the `FileUpload_RotateImages` setting (**Administration > File Upload > Rotate images on upload**) to control whether avatars should be rotated automatically based on their data (XEIF);

  - Display the avatar image preview (orientation) according to the `FileUpload_RotateImages` setting.

- Missing dependency on useEffect at CallProvider ([#24882](https://github.com/RocketChat/Rocket.Chat/pull/24882))

- Missing username on messages imported from Slack ([#24674](https://github.com/RocketChat/Rocket.Chat/pull/24674))

  - Fix missing sender's username on messages imported from Slack.

- Nextcloud OAuth for incomplete token URL ([#24476](https://github.com/RocketChat/Rocket.Chat/pull/24476))

- no id of room closer in livechat-close message ([#24683](https://github.com/RocketChat/Rocket.Chat/pull/24683))

- Opening a new DM from user card ([#24623](https://github.com/RocketChat/Rocket.Chat/pull/24623))

  A race condition on `useRoomIcon` -- delayed merge of rooms and subscriptions -- was causing a UI crash whenever someone tried to open a DM from the user card component.

- Prevent call button toggle when user is on call ([#24758](https://github.com/RocketChat/Rocket.Chat/pull/24758))

- Prune Message issue ([#24424](https://github.com/RocketChat/Rocket.Chat/pull/24424))

- Push privacy config to not show username not being respected ([#24606](https://github.com/RocketChat/Rocket.Chat/pull/24606))

- Register with Secret URL ([#24921](https://github.com/RocketChat/Rocket.Chat/pull/24921))

- Reload roomslist after successful deletion of a room from admin panel. ([#23795](https://github.com/RocketChat/Rocket.Chat/pull/23795) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

  Removed the logic for calling the `rooms.adminRooms` endPoint from the `RoomsTable` Component and moved it to its parent component `RoomsPage`.
  This allows to call the endPoint `rooms.adminRooms` from `EditRoomContextBar` Component which is also has `RoomPage` Component as its parent.

  Also added a succes toast message after the successful deletion of room.

- Revert AutoComplete ([#24812](https://github.com/RocketChat/Rocket.Chat/pull/24812))

- Room archived/unarchived system messages aren't sent when editing room settings ([#24897](https://github.com/RocketChat/Rocket.Chat/pull/24897))

  - Send the "Room archived" and "Room unarchived" system messages when editing room settings (and not only when rooms are archived/unarchived with the slash-command);

  - Fix the "Hide System Messages" option for the "Room archived" and "Room unarchived" system messages;

- room message not load when is a new message ([#24955](https://github.com/RocketChat/Rocket.Chat/pull/24955))

  When the room object is searched for the first time, it does not exist on the front object yet (subscription), adding a fallback search for room list will guarantee to search the room details.

  before:
  https://user-images.githubusercontent.com/9275105/160223241-d2319f3e-82c5-47d6-867f-695ab2361a17.mp4

  after:
  https://user-images.githubusercontent.com/9275105/160223244-84d0d2a1-3d95-464d-8b8a-e264b0d4d690.mp4

- Room's message count not being incremented on import ([#24696](https://github.com/RocketChat/Rocket.Chat/pull/24696))

  - Fix rooms' message counter not being incremented on message import.

- SAML Force name to string ([#24930](https://github.com/RocketChat/Rocket.Chat/pull/24930))

- Several issues related to custom roles ([#24052](https://github.com/RocketChat/Rocket.Chat/pull/24052))

  - Throw an error when trying to delete a role (User or Subscription role) that are still being used;

  - Fix "Invalid Role" error for custom roles in Role Editing sidebar;

  - Fix "Users in Role" screen for custom roles.

- Show call icon only when user has extension associated ([#24752](https://github.com/RocketChat/Rocket.Chat/pull/24752))

- Show only available agents on extension association modal ([#24680](https://github.com/RocketChat/Rocket.Chat/pull/24680))

- Show only enabled departments on forward ([#24829](https://github.com/RocketChat/Rocket.Chat/pull/24829))

- System messages are sent when adding or removing a group from a team ([#24743](https://github.com/RocketChat/Rocket.Chat/pull/24743))

  - Do not send system messages when adding or removing a new or existing _group_ from a team.

- Typo and placeholder on wrap up call modal ([#24737](https://github.com/RocketChat/Rocket.Chat/pull/24737))

- Typo in wrap-up term ([#24661](https://github.com/RocketChat/Rocket.Chat/pull/24661))

- VoIP button gets disabled whenever user status changes ([#24789](https://github.com/RocketChat/Rocket.Chat/pull/24789) by [@amolghode1981](https://github.com/amolghode1981))

- VoIP Enable/Disable setting on CallContext/CallProvider Notifications ([#24607](https://github.com/RocketChat/Rocket.Chat/pull/24607))

- Voip Stream Reinitialization Error ([#24657](https://github.com/RocketChat/Rocket.Chat/pull/24657) by [@amolghode1981](https://github.com/amolghode1981))

- VoipExtensionsPage component call ([#24792](https://github.com/RocketChat/Rocket.Chat/pull/24792))

- Wrong business hour behavior ([#24896](https://github.com/RocketChat/Rocket.Chat/pull/24896))

- Wrong param usage on queue summary call ([#24799](https://github.com/RocketChat/Rocket.Chat/pull/24799))

<details>
<summary>🔍 Minor changes</summary>


- Bump @rocket.chat/emitter from 0.31.4 to 0.31.9 in /ee/server/services ([#25021](https://github.com/RocketChat/Rocket.Chat/pull/25021) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/message-parser from 0.31.4 to 0.31.9 in /ee/server/services ([#25019](https://github.com/RocketChat/Rocket.Chat/pull/25019) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/string-helpers from 0.31.4 to 0.31.9 in /ee/server/services ([#25018](https://github.com/RocketChat/Rocket.Chat/pull/25018) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/ui-kit from 0.31.4 to 0.31.9 in /ee/server/services ([#25020](https://github.com/RocketChat/Rocket.Chat/pull/25020) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/clipboard from 2.0.1 to 2.0.7 ([#24832](https://github.com/RocketChat/Rocket.Chat/pull/24832) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/mailparser from 3.0.2 to 3.4.0 ([#24833](https://github.com/RocketChat/Rocket.Chat/pull/24833) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/nodemailer from 6.4.2 to 6.4.4 ([#24822](https://github.com/RocketChat/Rocket.Chat/pull/24822) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 8.2.3 to 8.5.2 in /ee/server/services ([#24666](https://github.com/RocketChat/Rocket.Chat/pull/24666) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 8.5.2 to 8.5.3 in /ee/server/services ([#24820](https://github.com/RocketChat/Rocket.Chat/pull/24820) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump actions/checkout from 2 to 3 ([#24668](https://github.com/RocketChat/Rocket.Chat/pull/24668) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump actions/setup-node from 2 to 3 ([#24642](https://github.com/RocketChat/Rocket.Chat/pull/24642) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.0 to 1.19.2 ([#24821](https://github.com/RocketChat/Rocket.Chat/pull/24821) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump is-svg from 4.3.1 to 4.3.2 ([#24801](https://github.com/RocketChat/Rocket.Chat/pull/24801) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump jschardet from 1.6.0 to 3.0.0 ([#23121](https://github.com/RocketChat/Rocket.Chat/pull/23121) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino from 7.8.0 to 7.8.1 in /ee/server/services ([#24783](https://github.com/RocketChat/Rocket.Chat/pull/24783) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino from 7.8.1 to 7.9.1 in /ee/server/services ([#24869](https://github.com/RocketChat/Rocket.Chat/pull/24869) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.1 to 7.5.2 in /ee/server/services ([#24689](https://github.com/RocketChat/Rocket.Chat/pull/24689) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.2 to 7.5.3 in /ee/server/services ([#24698](https://github.com/RocketChat/Rocket.Chat/pull/24698) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.3 to 7.5.4 in /ee/server/services ([#24870](https://github.com/RocketChat/Rocket.Chat/pull/24870) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump prometheus-gc-stats from 0.6.2 to 0.6.3 ([#24803](https://github.com/RocketChat/Rocket.Chat/pull/24803) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ts-node from 10.5.0 to 10.6.0 in /ee/server/services ([#24667](https://github.com/RocketChat/Rocket.Chat/pull/24667) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ts-node from 10.6.0 to 10.7.0 in /ee/server/services ([#24716](https://github.com/RocketChat/Rocket.Chat/pull/24716) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump url-parse from 1.5.7 to 1.5.10 ([#24640](https://github.com/RocketChat/Rocket.Chat/pull/24640) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: Add E2E tests for livechat/room.close ([#24729](https://github.com/RocketChat/Rocket.Chat/pull/24729) by [@Muramatsu2602](https://github.com/Muramatsu2602))

  * Create a new test suite file under tests/end-to-end/api/livechat
    * Create tests for the following endpoint:
	  + ivechat/room.close

- Chore: Add E2E tests for livechat/visitor ([#24764](https://github.com/RocketChat/Rocket.Chat/pull/24764) by [@Muramatsu2602](https://github.com/Muramatsu2602))

  - Create a new test suite file under tests/end-to-end/api/livechat

  - Create tests for the following endpoints:
   + livechat/visitor (create visitor, update visitor, add custom fields to visitors)

- Chore: add some missing REST definitions ([#24925](https://github.com/RocketChat/Rocket.Chat/pull/24925) by [@gerzonc](https://github.com/gerzonc))

  On the [mobile client](https://github.com/RocketChat/Rocket.Chat.ReactNative), we made an effort to collect more `REST API` definitions that are missing on the server side during our migration to TypeScript. Since we're both migrating to TypeScript, we thought it would be a good idea to share those so you guys can benefit from our initiative.

- Chore: added Server Instances endpoint types ([#24507](https://github.com/RocketChat/Rocket.Chat/pull/24507))

  Created typing for endpoint definitions on `instances.ts`.

- Chore: added settings endpoint types ([#24506](https://github.com/RocketChat/Rocket.Chat/pull/24506))

  Created typing for endpoint definitions on `settings.ts`.

- Chore: APIClass types ([#24747](https://github.com/RocketChat/Rocket.Chat/pull/24747))

  This pull request creates a new `restivus` module (.d.ts) for the `api.js` file.

- Chore: Bump Fuselage packages ([#25015](https://github.com/RocketChat/Rocket.Chat/pull/25015))

  It uses the last stable version of Fuselage packages.

- Chore: Convert server functions from javascript to typescript ([#24384](https://github.com/RocketChat/Rocket.Chat/pull/24384))

  This pull request will be used to rewrite some functions on the Chat Engine to Typescript, in order to increase security and specify variable types on the code.

- Chore: converted more hooks to typescript ([#24628](https://github.com/RocketChat/Rocket.Chat/pull/24628))

  Converted some functions on `client/hooks/` from JavaScript to Typescript.

- Chore: Fix Cypress tests ([#24544](https://github.com/RocketChat/Rocket.Chat/pull/24544))

- Chore: Fix grammatical errors in Code of Conduct ([#24759](https://github.com/RocketChat/Rocket.Chat/pull/24759) by [@aadishJ01](https://github.com/aadishJ01))

- Chore: fix grammatical errors in Features ([#24771](https://github.com/RocketChat/Rocket.Chat/pull/24771) by [@aadishJ01](https://github.com/aadishJ01))

- Chore: Fix MongoDB versions on release notes ([#24877](https://github.com/RocketChat/Rocket.Chat/pull/24877))

- Chore: Get Settings Statistics ([#24397](https://github.com/RocketChat/Rocket.Chat/pull/24397))

- Chore: Improve logger to allow log of `unknown` values ([#24726](https://github.com/RocketChat/Rocket.Chat/pull/24726))

- Chore: Improvements on role syncing (ldap, oauth and saml) ([#23824](https://github.com/RocketChat/Rocket.Chat/pull/23824))

- Chore: Micro services fixes and cleanup ([#24753](https://github.com/RocketChat/Rocket.Chat/pull/24753))

- Chore: Remove old scripts ([#24911](https://github.com/RocketChat/Rocket.Chat/pull/24911))

- Chore: Skip local services changes when shutting down duplicated services ([#24810](https://github.com/RocketChat/Rocket.Chat/pull/24810))

- Chore: Storybook mocking and examples improved ([#24969](https://github.com/RocketChat/Rocket.Chat/pull/24969))

  - Stories from `ee/` included;

  - Differentiate root story kinds;

  - Mocking of `ServerContext` via Storybook parameters.

- Chore: Update Livechat ([#24754](https://github.com/RocketChat/Rocket.Chat/pull/24754))

- Chore: Update Livechat ([#24990](https://github.com/RocketChat/Rocket.Chat/pull/24990))

- Chore(deps-dev): Bump @types/mock-require from 2.0.0 to 2.0.1 ([#24574](https://github.com/RocketChat/Rocket.Chat/pull/24574) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- i18n: Language update from LingoHub 🤖 on 2022-02-28Z ([#24644](https://github.com/RocketChat/Rocket.Chat/pull/24644))

- i18n: Language update from LingoHub 🤖 on 2022-03-07Z ([#24717](https://github.com/RocketChat/Rocket.Chat/pull/24717))

- i18n: Language update from LingoHub 🤖 on 2022-03-14Z ([#24823](https://github.com/RocketChat/Rocket.Chat/pull/24823))

- i18n: Language update from LingoHub 🤖 on 2022-03-21Z ([#24895](https://github.com/RocketChat/Rocket.Chat/pull/24895))

- i18n: Language update from LingoHub 🤖 on 2022-03-28Z ([#24971](https://github.com/RocketChat/Rocket.Chat/pull/24971))

- Merge master into develop & Set version to 4.6.0-develop ([#24653](https://github.com/RocketChat/Rocket.Chat/pull/24653))

- Regression: Add createdOTR index ([#25017](https://github.com/RocketChat/Rocket.Chat/pull/25017))

- Regression: Call doesn't stop ringing after agent unregistration ([#24908](https://github.com/RocketChat/Rocket.Chat/pull/24908))

- Regression: Custom roles displaying ID instead of name on some admin screens ([#24999](https://github.com/RocketChat/Rocket.Chat/pull/24999))

  ![image](https://user-images.githubusercontent.com/55164754/160981416-555bcaa1-c075-4260-937c-64523472da43.png)
  ![image](https://user-images.githubusercontent.com/55164754/160981452-6eae4e74-8425-4073-8256-472aba72b9db.png)

- Regression: Error is raised when there's no Asterisk queue available yet ([#24980](https://github.com/RocketChat/Rocket.Chat/pull/24980) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Fix account service login expiration ([#24920](https://github.com/RocketChat/Rocket.Chat/pull/24920))

- Regression: Fix ParentRoomWithEndpointData in loop ([#24809](https://github.com/RocketChat/Rocket.Chat/pull/24809))

- Regression: Fix unexpected errors breaking ddp-streamer ([#24948](https://github.com/RocketChat/Rocket.Chat/pull/24948))

- Regression: Improve Sidenav open/close handling and fixed codeql configs and E2E tests ([#24756](https://github.com/RocketChat/Rocket.Chat/pull/24756))

- Regression: Register services right away ([#24800](https://github.com/RocketChat/Rocket.Chat/pull/24800))

- Regression: Role Sync not always working ([#24850](https://github.com/RocketChat/Rocket.Chat/pull/24850))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@Himanshu664](https://github.com/Himanshu664)
- [@JMoVS](https://github.com/JMoVS)
- [@Muramatsu2602](https://github.com/Muramatsu2602)
- [@aadishJ01](https://github.com/aadishJ01)
- [@amolghode1981](https://github.com/amolghode1981)
- [@aswinidev](https://github.com/aswinidev)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@eduardofcabrera](https://github.com/eduardofcabrera)
- [@gerzonc](https://github.com/gerzonc)
- [@ostjen](https://github.com/ostjen)
- [@tkurz](https://github.com/tkurz)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@cauefcr](https://github.com/cauefcr)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.5.6
`2022-04-07  ·  2 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🐛 Bug fixes


- NPS never finishing sending results ([#25067](https://github.com/RocketChat/Rocket.Chat/pull/25067))

- Proxy settings being ignored ([#25022](https://github.com/RocketChat/Rocket.Chat/pull/25022))

  Modify Meteor's `HTTP.call` to add back proxy support

### 👩‍💻👨‍💻 Core Team 🤓

- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.5.5
`2022-03-30  ·  2 🐛  ·  2 🔍  ·  6 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🐛 Bug fixes


- High CPU usage caused by CallProvider ([#24994](https://github.com/RocketChat/Rocket.Chat/pull/24994))

  Remove infinity loop inside useVoipClient hook.

  #closes #24970

- Multiple issues starting a new DM ([#24955](https://github.com/RocketChat/Rocket.Chat/pull/24955))

  When the room object is searched for the first time, it does not exist on the front object yet (subscription), adding a fallback search for room list will guarantee to search the room details.

  before:
  https://user-images.githubusercontent.com/9275105/160223241-d2319f3e-82c5-47d6-867f-695ab2361a17.mp4

  after:
  https://user-images.githubusercontent.com/9275105/160223244-84d0d2a1-3d95-464d-8b8a-e264b0d4d690.mp4

<details>
<summary>🔍 Minor changes</summary>


- Chore: Update Livechat ([#24990](https://github.com/RocketChat/Rocket.Chat/pull/24990))

- Release 4.5.5 ([#24998](https://github.com/RocketChat/Rocket.Chat/pull/24998))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@filipemarins](https://github.com/filipemarins)
- [@ggazzo](https://github.com/ggazzo)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.5.4
`2022-03-24  ·  1 🐛  ·  1 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🐛 Bug fixes


- SAML Force name to string ([#24930](https://github.com/RocketChat/Rocket.Chat/pull/24930))

<details>
<summary>🔍 Minor changes</summary>


- Release 4.5.4 ([#24938](https://github.com/RocketChat/Rocket.Chat/pull/24938))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)

# 4.5.3
`2022-03-21  ·  2 🚀  ·  8 🐛  ·  1 🔍  ·  5 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🚀 Improvements


- Standarize queue behavior for managers and agents when subscribing ([#24837](https://github.com/RocketChat/Rocket.Chat/pull/24837))

- UX - VoIP Call Component ([#24748](https://github.com/RocketChat/Rocket.Chat/pull/24748))

### 🐛 Bug fixes


- **VOIP:** SidebarFooter component  ([#24838](https://github.com/RocketChat/Rocket.Chat/pull/24838))

  - Improve the CallProvider code;

  - Adjust the text case of the VoIP component on the FooterSidebar;

  - Fix the bad behavior with the changes in queue's name.

- Broken build caused by PRs modifying same file differently ([#24863](https://github.com/RocketChat/Rocket.Chat/pull/24863))

- Custom script not being fired ([#24901](https://github.com/RocketChat/Rocket.Chat/pull/24901))

- Disable voip button when call is in progress ([#24864](https://github.com/RocketChat/Rocket.Chat/pull/24864))

- Show call icon only when user has extension associated ([#24752](https://github.com/RocketChat/Rocket.Chat/pull/24752))

- Show only enabled departments on forward ([#24829](https://github.com/RocketChat/Rocket.Chat/pull/24829))

- VoIP button gets disabled whenever user status changes ([#24789](https://github.com/RocketChat/Rocket.Chat/pull/24789) by [@amolghode1981](https://github.com/amolghode1981))

- Wrong param usage on queue summary call ([#24799](https://github.com/RocketChat/Rocket.Chat/pull/24799))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Fix MongoDB versions on release notes ([#24877](https://github.com/RocketChat/Rocket.Chat/pull/24877))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@amolghode1981](https://github.com/amolghode1981)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@ggazzo](https://github.com/ggazzo)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.5.2
`2022-03-12  ·  1 🚀  ·  7 🐛  ·  1 🔍  ·  8 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🚀 Improvements


- Voip Extensions disabled state ([#24750](https://github.com/RocketChat/Rocket.Chat/pull/24750))

### 🐛 Bug fixes


- "livechat/webrtc.call" endpoint not working ([#24804](https://github.com/RocketChat/Rocket.Chat/pull/24804))

- `PaginatedSelectFiltered` not handling changes ([#24732](https://github.com/RocketChat/Rocket.Chat/pull/24732))

- Broken multiple OAuth integrations ([#24705](https://github.com/RocketChat/Rocket.Chat/pull/24705))

- Critical: Incorrect visitor getting assigned to a chat from apps ([#24805](https://github.com/RocketChat/Rocket.Chat/pull/24805))

- Opening a new DM from user card ([#24623](https://github.com/RocketChat/Rocket.Chat/pull/24623))

  A race condition on `useRoomIcon` -- delayed merge of rooms and subscriptions -- was causing a UI crash whenever someone tried to open a DM from the user card component.

- Revert AutoComplete ([#24812](https://github.com/RocketChat/Rocket.Chat/pull/24812))

- VoipExtensionsPage component call ([#24792](https://github.com/RocketChat/Rocket.Chat/pull/24792))

<details>
<summary>🔍 Minor changes</summary>


- Regression: Fix ParentRoomWithEndpointData in loop ([#24809](https://github.com/RocketChat/Rocket.Chat/pull/24809))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@debdutdeb](https://github.com/debdutdeb)
- [@ggazzo](https://github.com/ggazzo)
- [@juliajforesti](https://github.com/juliajforesti)
- [@murtaza98](https://github.com/murtaza98)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)

# 4.5.1
`2022-03-09  ·  13 🐛  ·  2 🔍  ·  12 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🐛 Bug fixes


- Apple login script being loaded even when Apple Login is disabled. ([#24760](https://github.com/RocketChat/Rocket.Chat/pull/24760))

- Components for user search ([#24677](https://github.com/RocketChat/Rocket.Chat/pull/24677))

- Duplicated 'name' log key ([#24590](https://github.com/RocketChat/Rocket.Chat/pull/24590))

- Missing username on messages imported from Slack ([#24674](https://github.com/RocketChat/Rocket.Chat/pull/24674))

  - Fix missing sender's username on messages imported from Slack.

- no id of room closer in livechat-close message ([#24683](https://github.com/RocketChat/Rocket.Chat/pull/24683))

- Reload roomslist after successful deletion of a room from admin panel. ([#23795](https://github.com/RocketChat/Rocket.Chat/pull/23795) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

  Removed the logic for calling the `rooms.adminRooms` endPoint from the `RoomsTable` Component and moved it to its parent component `RoomsPage`.
  This allows to call the endPoint `rooms.adminRooms` from `EditRoomContextBar` Component which is also has `RoomPage` Component as its parent.

  Also added a succes toast message after the successful deletion of room.

- Room's message count not being incremented on import ([#24696](https://github.com/RocketChat/Rocket.Chat/pull/24696))

  - Fix rooms' message counter not being incremented on message import.

- Show only available agents on extension association modal ([#24680](https://github.com/RocketChat/Rocket.Chat/pull/24680))

- System messages are sent when adding or removing a group from a team ([#24743](https://github.com/RocketChat/Rocket.Chat/pull/24743))

  - Do not send system messages when adding or removing a new or existing _group_ from a team.

- Typo and placeholder on wrap up call modal ([#24737](https://github.com/RocketChat/Rocket.Chat/pull/24737))

- Typo in wrap-up term ([#24661](https://github.com/RocketChat/Rocket.Chat/pull/24661))

- VoIP Enable/Disable setting on CallContext/CallProvider Notifications ([#24607](https://github.com/RocketChat/Rocket.Chat/pull/24607))

- Voip Stream Reinitialization Error ([#24657](https://github.com/RocketChat/Rocket.Chat/pull/24657) by [@amolghode1981](https://github.com/amolghode1981))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Update Livechat ([#24754](https://github.com/RocketChat/Rocket.Chat/pull/24754))

- Release 4.5.1 ([#24782](https://github.com/RocketChat/Rocket.Chat/pull/24782) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari) & [@amolghode1981](https://github.com/amolghode1981) & [@cuonghuunguyen](https://github.com/cuonghuunguyen))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@amolghode1981](https://github.com/amolghode1981)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.5.0
`2022-02-28  ·  3 🎉  ·  15 🚀  ·  19 🐛  ·  72 🔍  ·  30 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.31.0`

### 🎉 New features


- E2E password generator ([#24114](https://github.com/RocketChat/Rocket.Chat/pull/24114) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Marketplace sort filter ([#24567](https://github.com/RocketChat/Rocket.Chat/pull/24567) by [@ujorgeleite](https://github.com/ujorgeleite))

  Implemented a sort filter for the marketplace screen. This component sorts the marketplace apps list in 4 ways, alphabetical order(A-Z), inverse alphabetical order(Z-A), most recently updated(MRU), and least recent updated(LRU). Besides that, I've generalized some components and types to increase code reusability, renamed some helpers as well as deleted some useless ones, and inserted the necessary new translations on the English i18n dictionary.
  Demo gif:
  ![Marketplace sort filter](https://user-images.githubusercontent.com/43561537/155033709-e07a6306-a85a-4f7f-9624-b53ba5dd7fa9.gif)

- VoIP Support for Omnichannel ([#23102](https://github.com/RocketChat/Rocket.Chat/pull/23102) by [@amolghode1981](https://github.com/amolghode1981))

  - Created VoipService to manage VoIP connections and PBX connection

  - Created LivechatVoipService that will handle custom cases for livechat (creating rooms, assigning chats to queue, actions when call is finished, etc)

  - Created Basic interfaces to support new services and new model

  - Created Endpoints for management interfaces

  - Implemented asterisk connector on VoIP service

  - Created UI components to show calls incoming and to allow answering/rejecting calls

  - Added new settings to control call server/management server connection values

  - Added endpoints to associate Omnichannel Agents with PBX Extensions

  - Added support for event listening on server side, to get metadata about calls being received/ongoing

  - Created new pages to update settings & to see user-extension association

  - Created new page to see ongoing calls (and past calls)

  - Added support for remote hangup/hold on calls

  - Implemented call metrics calculation (hold time, waiting time, talk time)

  - Show a notificaiton when call is received

### 🚀 Improvements


- **ENTERPRISE:** Improve how micro services are loaded ([#24388](https://github.com/RocketChat/Rocket.Chat/pull/24388))

- Add return button in chats opened from the list of current chats ([#24458](https://github.com/RocketChat/Rocket.Chat/pull/24458) by [@LucasFASouza](https://github.com/LucasFASouza))

  The new return button for Omnichannel chats came out with release 3.15  but the feature was only available for chats that were opened from Omnichannel Contact Center.
  Now, the same UI/UX is supported for chats opened from Current Chats list.

  ![image](https://user-images.githubusercontent.com/32396925/153283190-bd5c9748-c36b-4874-a704-6043afc7e3a1.png)

  The chat now opens in the Omnichannel settings and has the return button so the user can go back to the Current Chats list.

  ![image](https://user-images.githubusercontent.com/32396925/153285591-fad8e4a0-d2ea-4a02-8b2a-15e383b3c876.png)

- Add tooltips on action buttons of Canned Response message composer ([#24483](https://github.com/RocketChat/Rocket.Chat/pull/24483) by [@LucasFASouza](https://github.com/LucasFASouza))

  The tooltips were missing on the action buttons of CR message composer.

  ![image](https://user-images.githubusercontent.com/32396925/153620327-91107245-4b47-4d39-a99a-6da6d1cf5734.png)

  Users can now feel more encouraged to use these actions knowing what they are supposed to do.

- Add user to room on "Click to Join!" button press ([#24041](https://github.com/RocketChat/Rocket.Chat/pull/24041) by [@ostjen](https://github.com/ostjen))

  - Add user to room on "Click to Join!" button press;

  - Display the "Join" button in discussions inside channels (keeping the behavior consistent with discussions inside groups).

- Added a new "All" tab which shows all integrations in Integrations ([#24109](https://github.com/RocketChat/Rocket.Chat/pull/24109) by [@aswinidev](https://github.com/aswinidev))

- ChatBox Text to File Description ([#24451](https://github.com/RocketChat/Rocket.Chat/pull/24451) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  The text content from chatbox goes to the file description when drag and drop a file.

- Close modal on esc and outside click ([#24275](https://github.com/RocketChat/Rocket.Chat/pull/24275))

  This is a QUICK change in order to close modals pressing Esc button and clicking outside of it **intentionally**.

- CloudLoginModal visual consistency ([#24334](https://github.com/RocketChat/Rocket.Chat/pull/24334))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/151585064-dc6a1e29-9903-4241-8fbd-dfbe6c55fbef.png)

  ### after
  ![Screen Shot 2022-01-28 at 13 32 02](https://user-images.githubusercontent.com/27704687/151585101-75b98502-9aae-4198-bc3e-4956750e5d8b.png)

- Convert tag edit with department data to tsx ([#24369](https://github.com/RocketChat/Rocket.Chat/pull/24369) by [@LucasFASouza](https://github.com/LucasFASouza))

- Descriptive tooltip for Encrypted Key on Room Header ([#24121](https://github.com/RocketChat/Rocket.Chat/pull/24121))

- OTR system messages ([#24382](https://github.com/RocketChat/Rocket.Chat/pull/24382))

  OTR system messages to indicate key refresh and joining chat to users.

- Purchase Type Filter for marketplace apps and Categories filter anchor refactoring ([#24454](https://github.com/RocketChat/Rocket.Chat/pull/24454))

  Implemented a filter by purchase type(free or paid) component for the apps screen of the marketplace. Besides that, new entries on the dictionary, fixed some parts of the App type (purchaseType was typed as unknown and price as string), and created some helpers to work alongside the filter. Will be refactoring the categories filter anchor and then will open this PR for reviews.

  Demo gif:
  ![purchaseTypeFIlter](https://user-images.githubusercontent.com/43561537/153101228-7b7ebdc3-2d34-420f-aa9d-f7cbc8d4b53f.gif)

  Refactored the categories filter anchor from a plain fuselage select to a select button with dynamic colors.
  Demo gif:
  ![New categories filter anchor(PR)](https://user-images.githubusercontent.com/43561537/153422427-28012b7d-e0ec-45f4-861d-c9368c57ad04.gif)

- Replace AutoComplete in UserAutoComplete & UserAutoCompleteMultiple components ([#24529](https://github.com/RocketChat/Rocket.Chat/pull/24529))

  This PR replaces a deprecated fuselage's component `AutoComplete` in favor of `Select` and `MultiSelect` which fixes some of UX/UI issues in selecting users

  ### before
  ![Screen Shot 2022-02-19 at 13 33 28](https://user-images.githubusercontent.com/27704687/154809737-8181a06c-4f20-48ea-90f7-01e828b9a452.png)

  ### after
  ![Screen Shot 2022-02-19 at 13 30 58](https://user-images.githubusercontent.com/27704687/154809653-a8ec9a80-c0dd-4a25-9c00-0f96147d79e9.png)

- Skip encryption for slash commands in E2E rooms ([#24475](https://github.com/RocketChat/Rocket.Chat/pull/24475))

  Currently Slash Commands don't work in an E2EE room, as we encrypt the message before slash command is detected by the server, So removed encryption for slash commands in e2e rooms.

- Team system messages feedback ([#24209](https://github.com/RocketChat/Rocket.Chat/pull/24209) by [@ostjen](https://github.com/ostjen))

  - Delete some keys that aren't being used (eg: User_left_female).

  - Add new Teams' system messages:
      - `added-user-to-team`: **added** @\user to this Team;
      - `removed-user-from-team`: **removed** @\user from this Team;
      - `user-converted-to-team`: **converted** #\room to a Team;
      - `user-converted-to-channel`: **converted** #\room to a Channel;
      - `user-removed-room-from-team`: **removed** @\user from this Team;
      - `user-deleted-room-from-team`: **deleted** #\room from this Team;
      - `user-added-room-to-team`: **deleted** #\room to this Team;

  - Add the corresponding options to hide each new system message and the missing `ujt` and `ult` hide options.

### 🐛 Bug fixes


- 2FA via email when logging in using OAuth ([#24572](https://github.com/RocketChat/Rocket.Chat/pull/24572))

- Add ?close to OAuth callback url ([#24381](https://github.com/RocketChat/Rocket.Chat/pull/24381))

- GDPR action to forget visitor data on request ([#24441](https://github.com/RocketChat/Rocket.Chat/pull/24441))

- Implement client errors on ddp-streamer ([#24310](https://github.com/RocketChat/Rocket.Chat/pull/24310))

- Inconsistent validation of user's access to rooms ([#24037](https://github.com/RocketChat/Rocket.Chat/pull/24037) by [@ostjen](https://github.com/ostjen))

- Issues on selecting users when importing CSV ([#24253](https://github.com/RocketChat/Rocket.Chat/pull/24253))

  * Fix users selecting by fixing their _id

  * Add condition to disable 'Start importing' button if `usersCount`, `channelsCount` and `messageCount` equals 0, or if messageCount is alone

  * Remove `disabled={usersCount === 0}` on user Tab

- OAuth mismatch redirect_uri error ([#24450](https://github.com/RocketChat/Rocket.Chat/pull/24450))

- Oembed request not respecting payload limit ([#24418](https://github.com/RocketChat/Rocket.Chat/pull/24418))

- Omnichannel managers can't join chats in progress ([#24553](https://github.com/RocketChat/Rocket.Chat/pull/24553))

- Outgoing webhook without scripts not saving messages ([#24401](https://github.com/RocketChat/Rocket.Chat/pull/24401))

- Prevent Apps Bridge to remove visitor status from room ([#24305](https://github.com/RocketChat/Rocket.Chat/pull/24305))

- Read receipts showing first messages of the room as read even if not read by everyone ([#24508](https://github.com/RocketChat/Rocket.Chat/pull/24508))

- respect `Accounts_Registration_Users_Default_Roles` setting ([#24173](https://github.com/RocketChat/Rocket.Chat/pull/24173))

  - Fix `user` role being added as default regardless of the `Accounts_Registration_Users_Default_Roles` setting.

- Room context tabs not working in Omnichannel current chats page ([#24559](https://github.com/RocketChat/Rocket.Chat/pull/24559))

- Skip admin info in setup wizard for servers with admin registered ([#24485](https://github.com/RocketChat/Rocket.Chat/pull/24485))

- Skip cloud steps for registered servers on setup wizard ([#24407](https://github.com/RocketChat/Rocket.Chat/pull/24407))

- Slash commands previews not working ([#24387](https://github.com/RocketChat/Rocket.Chat/pull/24387) by [@ostjen](https://github.com/ostjen))

- Startup errors creating indexes ([#24409](https://github.com/RocketChat/Rocket.Chat/pull/24409))

  Fix `bio` and `prid` startup index creation errors.

- typo on register server tooltip of setup wizard ([#24466](https://github.com/RocketChat/Rocket.Chat/pull/24466))

<details>
<summary>🔍 Minor changes</summary>


- Bump @types/ws from 8.2.2 to 8.2.3 in /ee/server/services ([#24556](https://github.com/RocketChat/Rocket.Chat/pull/24556) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump adm-zip from 0.4.14 to 0.5.9 ([#24538](https://github.com/RocketChat/Rocket.Chat/pull/24538) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.0 to 1.19.1 in /ee/server/services ([#23963](https://github.com/RocketChat/Rocket.Chat/pull/23963) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.1 to 1.19.2 in /ee/server/services ([#24517](https://github.com/RocketChat/Rocket.Chat/pull/24517) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump cookie from 0.4.1 to 0.4.2 in /ee/server/services ([#24472](https://github.com/RocketChat/Rocket.Chat/pull/24472) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump date-fns from 2.24.0 to 2.28.0 ([#24058](https://github.com/RocketChat/Rocket.Chat/pull/24058) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump express from 4.17.1 to 4.17.2 in /ee/server/services ([#24469](https://github.com/RocketChat/Rocket.Chat/pull/24469) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump express from 4.17.2 to 4.17.3 in /ee/server/services ([#24522](https://github.com/RocketChat/Rocket.Chat/pull/24522) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump follow-redirects from 1.14.7 to 1.14.8 in /ee/server/services ([#24491](https://github.com/RocketChat/Rocket.Chat/pull/24491) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump jaeger-client from 3.18.1 to 3.19.0 in /ee/server/services ([#23961](https://github.com/RocketChat/Rocket.Chat/pull/23961) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pm2 from 5.1.2 to 5.2.0 in /ee/server/services ([#24537](https://github.com/RocketChat/Rocket.Chat/pull/24537) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump simple-get from 4.0.0 to 4.0.1 ([#24341](https://github.com/RocketChat/Rocket.Chat/pull/24341) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump sodium-native from 3.2.1 to 3.3.0 in /ee/server/services ([#23512](https://github.com/RocketChat/Rocket.Chat/pull/23512) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump underscore.string from 3.3.5 to 3.3.6 in /ee/server/services ([#24498](https://github.com/RocketChat/Rocket.Chat/pull/24498) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump url-parse from 1.5.3 to 1.5.7 ([#24528](https://github.com/RocketChat/Rocket.Chat/pull/24528) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump vm2 from 3.9.5 to 3.9.7 in /ee/server/services ([#24509](https://github.com/RocketChat/Rocket.Chat/pull/24509) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: `twoFactorRequired` signature ([#24518](https://github.com/RocketChat/Rocket.Chat/pull/24518))

  Improved type checking for decorator `twoFactorRequired`.

- Chore: Add description to global OTR setting ([#24333](https://github.com/RocketChat/Rocket.Chat/pull/24333) by [@pedrogssouza](https://github.com/pedrogssouza))

- Chore: Bump Fuselage packages ([#24573](https://github.com/RocketChat/Rocket.Chat/pull/24573))

  It uses the last stable version of Fuselage packages.

- Chore: bump fuselage version ([#24453](https://github.com/RocketChat/Rocket.Chat/pull/24453))

- Chore: Convert JS files to Typescript ([#24410](https://github.com/RocketChat/Rocket.Chat/pull/24410))

  This pull request converts 26 more files from Javascript to Typescript, to check variable types and increase validation on the code.

- Chore: Convert to typescript the me slashCommands files ([#24321](https://github.com/RocketChat/Rocket.Chat/pull/24321) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the me slashCommands files

- Chore: Convert to typescript the mute and unmute slash commands files ([#24325](https://github.com/RocketChat/Rocket.Chat/pull/24325) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the mute and unmute slash commands files

- Chore: Convert to typescript the slash commands create files ([#24306](https://github.com/RocketChat/Rocket.Chat/pull/24306) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert Slash Commands create files to typescript.

- Chore: Convert to typescript the slash commands invite files ([#24311](https://github.com/RocketChat/Rocket.Chat/pull/24311) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the slash commands invite files

- Chore: Convert to typescript the unarchive slash commands files ([#24331](https://github.com/RocketChat/Rocket.Chat/pull/24331) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the unarchive slash commands files

- Chore: Delete unused file (NewAdminInfoPage.js) ([#24196](https://github.com/RocketChat/Rocket.Chat/pull/24196))

  Just removing a duplicated/unused file.

- Chore: Improve PR title validation regex ([#24467](https://github.com/RocketChat/Rocket.Chat/pull/24467))

- Chore: Js to ts slash commands archive ([#24304](https://github.com/RocketChat/Rocket.Chat/pull/24304) by [@eduardofcabrera](https://github.com/eduardofcabrera))

  Convert Slash Commands archive files to typescript

- Chore: Remove storybook build job from CI ([#24530](https://github.com/RocketChat/Rocket.Chat/pull/24530))

- Chore: roomTypes: Stop mixing client and server code together ([#24536](https://github.com/RocketChat/Rocket.Chat/pull/24536))

- Chore: Run tests using microservices deployment on CI ([#24513](https://github.com/RocketChat/Rocket.Chat/pull/24513))

- Chore: Set Docker image tag to latest only when really latest ([#24366](https://github.com/RocketChat/Rocket.Chat/pull/24366))

- Chore: Unify ILivechatAgent with ILivechatAgentRecord ([#24406](https://github.com/RocketChat/Rocket.Chat/pull/24406))

- Chore: Update Apps-Engine ([#24568](https://github.com/RocketChat/Rocket.Chat/pull/24568))

- Chore: Update Apps-Engine ([#24651](https://github.com/RocketChat/Rocket.Chat/pull/24651))

- Chore: Update fuselage deps to match monolith versions ([#24501](https://github.com/RocketChat/Rocket.Chat/pull/24501))

- Chore: Update Meteor to 2.5.6 ([#24461](https://github.com/RocketChat/Rocket.Chat/pull/24461))

- Chore: Update ws package ([#24477](https://github.com/RocketChat/Rocket.Chat/pull/24477))

- Chore(deps-dev): Bump ts-node from 10.0.0 to 10.5.0 in /ee/server/services ([#24435](https://github.com/RocketChat/Rocket.Chat/pull/24435) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore(deps): Bump node-fetch from 2.6.1 to 2.6.7 in /ee/server/services ([#24299](https://github.com/RocketChat/Rocket.Chat/pull/24299) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- i18n: Language update from LingoHub 🤖 on 2022-01-31Z ([#24357](https://github.com/RocketChat/Rocket.Chat/pull/24357))

- i18n: Language update from LingoHub 🤖 on 2022-02-07Z ([#24429](https://github.com/RocketChat/Rocket.Chat/pull/24429))

- i18n: Language update from LingoHub 🤖 on 2022-02-14Z ([#24493](https://github.com/RocketChat/Rocket.Chat/pull/24493))

- i18n: Language update from LingoHub 🤖 on 2022-02-21Z ([#24558](https://github.com/RocketChat/Rocket.Chat/pull/24558))

- Merge master into develop & Set version to 4.5.0-develop ([#24363](https://github.com/RocketChat/Rocket.Chat/pull/24363))

- Regression: Add support to namespace within micro services ([#24581](https://github.com/RocketChat/Rocket.Chat/pull/24581))

- Regression: Admin Sidebar colors inverted. ([#24609](https://github.com/RocketChat/Rocket.Chat/pull/24609))

- Regression: Bunch of settings fixes for VoIP ([#24594](https://github.com/RocketChat/Rocket.Chat/pull/24594))

- Regression: Do not show toast on incoming voip calls ([#24619](https://github.com/RocketChat/Rocket.Chat/pull/24619))

- Regression: Encode registration info as JWT when signing key is provided ([#24626](https://github.com/RocketChat/Rocket.Chat/pull/24626))

- Regression: Error setting user avatars and mentioning rooms on Slack Import ([#24585](https://github.com/RocketChat/Rocket.Chat/pull/24585))

  - Fix `Mentioned room not found` error when importing rooms from Slack;

  - Fix `Forbidden` error when setting avatars for users imported from Slack (on user import/creation);

  - Fix incorrect message count on imported rooms;

  - Fix missing username on messages imported from Slack;

- Regression: Error when trying to load name of dm rooms for avatars and notifications ([#24583](https://github.com/RocketChat/Rocket.Chat/pull/24583))

- Regression: Extension List panel UI not aligned with designs ([#24645](https://github.com/RocketChat/Rocket.Chat/pull/24645))

- Regression: Fix double value on holdTime and empty msg on last message ([#24630](https://github.com/RocketChat/Rocket.Chat/pull/24630))

- Regression: Fix in-correct room status shown to agents ([#24592](https://github.com/RocketChat/Rocket.Chat/pull/24592))

- Regression: Fix incoming voip call ringtone is not ringing ([#24616](https://github.com/RocketChat/Rocket.Chat/pull/24616))

- Regression: Fix room not getting created due to null visitor status ([#24562](https://github.com/RocketChat/Rocket.Chat/pull/24562))

- Regression: Fix time fields and wrap up in Voip Room Contexual bar ([#24625](https://github.com/RocketChat/Rocket.Chat/pull/24625))

- Regression: Fix time format on Voip system messages ([#24603](https://github.com/RocketChat/Rocket.Chat/pull/24603))

- Regression: Fix translation for call started message ([#24615](https://github.com/RocketChat/Rocket.Chat/pull/24615))

- Regression: Fix wrong tab name for VoIP settings ([#24647](https://github.com/RocketChat/Rocket.Chat/pull/24647))

- Regression: Fixes in Voice Contextual Bar and Directory ([#24596](https://github.com/RocketChat/Rocket.Chat/pull/24596))

- Regression: If Asterisk suddenly goes down, server has no way to know. Causes server to get stuck. Needs restart ([#24624](https://github.com/RocketChat/Rocket.Chat/pull/24624) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Mark all rooms as read modal closing instantly. ([#24610](https://github.com/RocketChat/Rocket.Chat/pull/24610))

- Regression: No audio when call comes from Skype/IP phone ([#24602](https://github.com/RocketChat/Rocket.Chat/pull/24602) by [@amolghode1981](https://github.com/amolghode1981))

  The audio was not rendered because of re-rendering of react element based on
  queueCounter and roomInfo. queueCounter and roomInfo cause the dom to re-render when call gets accepted
  because after accepting call, queueCounter changes or a room gets created.
  The audio element gets recreated. But VoIP user probably holds the old one.
  The behaviour is not predictable when such case happens. If everything gets cleanly setup,
  even if the audio element goes headless, it still continues to play the remote audio.
  But in other cases, it is unreferenced the one on dom has its srcObject as null.
  This causes no audio.

  This fix provides a way to re-initialise the rendering elements in VoIP user
  and calls this function on useEffect() if the re-render has happen.

- Regression: Prevent button from losing state when rerendering ([#24648](https://github.com/RocketChat/Rocket.Chat/pull/24648))

- Regression: Prevent connect to asterisk when VoIP is disabled ([#24601](https://github.com/RocketChat/Rocket.Chat/pull/24601))

- Regression: Queue counter aggregator for incoming/hanged calls ([#24635](https://github.com/RocketChat/Rocket.Chat/pull/24635) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Refresh server connection when MI server settings change ([#24649](https://github.com/RocketChat/Rocket.Chat/pull/24649))

- Regression: Server crashing if Voip credentials are invalid ([#24646](https://github.com/RocketChat/Rocket.Chat/pull/24646))

- Regression: VoIP service button displayed when VoIP is disabled ([#24598](https://github.com/RocketChat/Rocket.Chat/pull/24598))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@LucasFASouza](https://github.com/LucasFASouza)
- [@amolghode1981](https://github.com/amolghode1981)
- [@aswinidev](https://github.com/aswinidev)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@eduardofcabrera](https://github.com/eduardofcabrera)
- [@ostjen](https://github.com/ostjen)
- [@pedrogssouza](https://github.com/pedrogssouza)
- [@ujorgeleite](https://github.com/ujorgeleite)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.4.5
`2022-05-30  ·  12 🎉  ·  26 🚀  ·  79 🐛  ·  213 🔍  ·  54 👩‍💻👨‍💻`

### Engine versions
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🎉 New features


- Add expire index to integration history ([#25087](https://github.com/RocketChat/Rocket.Chat/pull/25087))

- Alpha Matrix Federation ([#23688](https://github.com/RocketChat/Rocket.Chat/pull/23688))

  Experimental support for Matrix Federation with a Bridge

  https://user-images.githubusercontent.com/51996/164530391-e8b17ecd-a4d0-4ef8-a8b7-81230c1773d3.mp4

- E2E password generator ([#24114](https://github.com/RocketChat/Rocket.Chat/pull/24114) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Engagement Statistics ([#24989](https://github.com/RocketChat/Rocket.Chat/pull/24989))

- Engagement Statistics ([#24777](https://github.com/RocketChat/Rocket.Chat/pull/24777) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Expand Apps Engine's environment variable allowed list ([#23870](https://github.com/RocketChat/Rocket.Chat/pull/23870) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Marketplace sort filter ([#24567](https://github.com/RocketChat/Rocket.Chat/pull/24567) by [@ujorgeleite](https://github.com/ujorgeleite))

  Implemented a sort filter for the marketplace screen. This component sorts the marketplace apps list in 4 ways, alphabetical order(A-Z), inverse alphabetical order(Z-A), most recently updated(MRU), and least recent updated(LRU). Besides that, I've generalized some components and types to increase code reusability, renamed some helpers as well as deleted some useless ones, and inserted the necessary new translations on the English i18n dictionary.
  Demo gif:
  ![Marketplace sort filter](https://user-images.githubusercontent.com/43561537/155033709-e07a6306-a85a-4f7f-9624-b53ba5dd7fa9.gif)

- Message Template React Component ([#23971](https://github.com/RocketChat/Rocket.Chat/pull/23971))

  Complete rewrite of the messages component in react. Visual changes should be minimal as well as user impact, with no break changes (unless you've customized the blaze template).



  ![Screen Shot 2022-04-05 at 11 14 18](https://user-images.githubusercontent.com/27704687/161774027-38dd9c7b-eeeb-45e2-b9d8-ea2a9be8486d.png)
  In case you encounter any problems, or want to compare, temporarily it is possible to use the old version

  <img width="556" alt="image" src="https://user-images.githubusercontent.com/5263975/162099800-15806953-f2f5-4905-a424-3f095076bc1d.png">

- Telemetry Events ([#24781](https://github.com/RocketChat/Rocket.Chat/pull/24781) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Upgrade Tab ([#24835](https://github.com/RocketChat/Rocket.Chat/pull/24835))

  ![image](https://user-images.githubusercontent.com/27704687/160172260-c656282e-a487-4092-948d-d11c9bacb598.png)

- Use setting to determine if initial general channel is needed ([#25441](https://github.com/RocketChat/Rocket.Chat/pull/25441) by [@felipe-menelau](https://github.com/felipe-menelau))

  - Adds flag responsible for overwriting #general channel creation

- VoIP Support for Omnichannel ([#23102](https://github.com/RocketChat/Rocket.Chat/pull/23102) by [@amolghode1981](https://github.com/amolghode1981))

  - Created VoipService to manage VoIP connections and PBX connection

  - Created LivechatVoipService that will handle custom cases for livechat (creating rooms, assigning chats to queue, actions when call is finished, etc)

  - Created Basic interfaces to support new services and new model

  - Created Endpoints for management interfaces

  - Implemented asterisk connector on VoIP service

  - Created UI components to show calls incoming and to allow answering/rejecting calls

  - Added new settings to control call server/management server connection values

  - Added endpoints to associate Omnichannel Agents with PBX Extensions

  - Added support for event listening on server side, to get metadata about calls being received/ongoing

  - Created new pages to update settings & to see user-extension association

  - Created new page to see ongoing calls (and past calls)

  - Added support for remote hangup/hold on calls

  - Implemented call metrics calculation (hold time, waiting time, talk time)

  - Show a notificaiton when call is received

### 🚀 Improvements


- **ENTERPRISE:** Don't start presence monitor when running micro services ([#24739](https://github.com/RocketChat/Rocket.Chat/pull/24739))

- **ENTERPRISE:** Improve how micro services are loaded ([#24388](https://github.com/RocketChat/Rocket.Chat/pull/24388))

- Add OTR Room States ([#24565](https://github.com/RocketChat/Rocket.Chat/pull/24565))

  Earlier OTR room uses only 2 states, we need more states to support future features.
  This adds more states for the OTR contextualBar.


  - Expired
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 52" src="https://user-images.githubusercontent.com/27704687/164283351-068756be-3419-4773-9d55-c9c1a72f5a19.png">


  - Declined
  <img width="343" alt='Screen Shot 2022-04-20 at 13 49 28' src='https://user-images.githubusercontent.com/27704687/164282312-fa3c6841-23d4-46e1-a8e9-80882a105d8c.png' />


  - Error
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 26" src="https://user-images.githubusercontent.com/27704687/164283261-95e06d06-b0d0-402d-bccc-66596ff4dcd3.png">

- Add return button in chats opened from the list of current chats ([#24458](https://github.com/RocketChat/Rocket.Chat/pull/24458) by [@LucasFASouza](https://github.com/LucasFASouza))

  The new return button for Omnichannel chats came out with release 3.15  but the feature was only available for chats that were opened from Omnichannel Contact Center.
  Now, the same UI/UX is supported for chats opened from Current Chats list.

  ![image](https://user-images.githubusercontent.com/32396925/153283190-bd5c9748-c36b-4874-a704-6043afc7e3a1.png)

  The chat now opens in the Omnichannel settings and has the return button so the user can go back to the Current Chats list.

  ![image](https://user-images.githubusercontent.com/32396925/153285591-fad8e4a0-d2ea-4a02-8b2a-15e383b3c876.png)

- Add tooltip to sidebar room menu ([#24405](https://github.com/RocketChat/Rocket.Chat/pull/24405) by [@Himanshu664](https://github.com/Himanshu664))

- Add tooltips on action buttons of Canned Response message composer ([#24483](https://github.com/RocketChat/Rocket.Chat/pull/24483) by [@LucasFASouza](https://github.com/LucasFASouza))

  The tooltips were missing on the action buttons of CR message composer.

  ![image](https://user-images.githubusercontent.com/32396925/153620327-91107245-4b47-4d39-a99a-6da6d1cf5734.png)

  Users can now feel more encouraged to use these actions knowing what they are supposed to do.

- Add user to room on "Click to Join!" button press ([#24041](https://github.com/RocketChat/Rocket.Chat/pull/24041) by [@ostjen](https://github.com/ostjen))

  - Add user to room on "Click to Join!" button press;

  - Display the "Join" button in discussions inside channels (keeping the behavior consistent with discussions inside groups).

- Added a new "All" tab which shows all integrations in Integrations ([#24109](https://github.com/RocketChat/Rocket.Chat/pull/24109) by [@aswinidev](https://github.com/aswinidev))

- Added MaxNickNameLength and MaxBioLength constants ([#25231](https://github.com/RocketChat/Rocket.Chat/pull/25231) by [@aakash-gitdev](https://github.com/aakash-gitdev))

- Added tooltip options for message menu ([#24431](https://github.com/RocketChat/Rocket.Chat/pull/24431) by [@Himanshu664](https://github.com/Himanshu664))

- Adding new statistics related to voip and omnichannel ([#24887](https://github.com/RocketChat/Rocket.Chat/pull/24887))

  - Total of Canned response messages sent

  - Total of tags used

  - Last-Chatted Agent Preferred (enabled/disabled)

  - Assign new conversations to the contact manager (enabled/disabled)

  - How to handle Visitor Abandonment setting

  - Amount of chats placed on hold

  - VoIP Enabled

  - Amount of VoIP Calls

  - Amount of VoIP Extensions connected

  - Amount of Calls placed on hold (1x per call)

  - Fixed Session Aggregation type definitions

- ChatBox Text to File Description ([#24451](https://github.com/RocketChat/Rocket.Chat/pull/24451) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  The text content from chatbox goes to the file description when drag and drop a file.

- Close modal on esc and outside click ([#24275](https://github.com/RocketChat/Rocket.Chat/pull/24275))

  This is a QUICK change in order to close modals pressing Esc button and clicking outside of it **intentionally**.

- CloudLoginModal visual consistency ([#24334](https://github.com/RocketChat/Rocket.Chat/pull/24334))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/151585064-dc6a1e29-9903-4241-8fbd-dfbe6c55fbef.png)

  ### after
  ![Screen Shot 2022-01-28 at 13 32 02](https://user-images.githubusercontent.com/27704687/151585101-75b98502-9aae-4198-bc3e-4956750e5d8b.png)

- Convert tag edit with department data to tsx ([#24369](https://github.com/RocketChat/Rocket.Chat/pull/24369) by [@LucasFASouza](https://github.com/LucasFASouza))

- Descriptive tooltip for Encrypted Key on Room Header ([#24121](https://github.com/RocketChat/Rocket.Chat/pull/24121))

- Improve active/hover colors in account sidebar ([#25024](https://github.com/RocketChat/Rocket.Chat/pull/25024) by [@Himanshu664](https://github.com/Himanshu664))

- New omnichannel statistics and async statistics processing. ([#24749](https://github.com/RocketChat/Rocket.Chat/pull/24749))

  https://app.clickup.com/t/1z4zg4e

- OTR system messages ([#24382](https://github.com/RocketChat/Rocket.Chat/pull/24382))

  OTR system messages to indicate key refresh and joining chat to users.

- Performance for some Omnichannel features ([#25217](https://github.com/RocketChat/Rocket.Chat/pull/25217))

- Purchase Type Filter for marketplace apps and Categories filter anchor refactoring ([#24454](https://github.com/RocketChat/Rocket.Chat/pull/24454))

  Implemented a filter by purchase type(free or paid) component for the apps screen of the marketplace. Besides that, new entries on the dictionary, fixed some parts of the App type (purchaseType was typed as unknown and price as string), and created some helpers to work alongside the filter. Will be refactoring the categories filter anchor and then will open this PR for reviews.

  Demo gif:
  ![purchaseTypeFIlter](https://user-images.githubusercontent.com/43561537/153101228-7b7ebdc3-2d34-420f-aa9d-f7cbc8d4b53f.gif)

  Refactored the categories filter anchor from a plain fuselage select to a select button with dynamic colors.
  Demo gif:
  ![New categories filter anchor(PR)](https://user-images.githubusercontent.com/43561537/153422427-28012b7d-e0ec-45f4-861d-c9368c57ad04.gif)

- Rename upgrade tab routes ([#25097](https://github.com/RocketChat/Rocket.Chat/pull/25097))

  Change 'upgrade tab' routes names from camelCase ('goFullyFeatured') to kebab-case ('go-fully-featured') due to URL naming consistency. Changed types, main function and test.

- Replace AutoComplete in UserAutoComplete & UserAutoCompleteMultiple components ([#24529](https://github.com/RocketChat/Rocket.Chat/pull/24529))

  This PR replaces a deprecated fuselage's component `AutoComplete` in favor of `Select` and `MultiSelect` which fixes some of UX/UI issues in selecting users

  ### before
  ![Screen Shot 2022-02-19 at 13 33 28](https://user-images.githubusercontent.com/27704687/154809737-8181a06c-4f20-48ea-90f7-01e828b9a452.png)

  ### after
  ![Screen Shot 2022-02-19 at 13 30 58](https://user-images.githubusercontent.com/27704687/154809653-a8ec9a80-c0dd-4a25-9c00-0f96147d79e9.png)

- Skip encryption for slash commands in E2E rooms ([#24475](https://github.com/RocketChat/Rocket.Chat/pull/24475))

  Currently Slash Commands don't work in an E2EE room, as we encrypt the message before slash command is detected by the server, So removed encryption for slash commands in e2e rooms.

- Team system messages feedback ([#24209](https://github.com/RocketChat/Rocket.Chat/pull/24209) by [@ostjen](https://github.com/ostjen))

  - Delete some keys that aren't being used (eg: User_left_female).

  - Add new Teams' system messages:
      - `added-user-to-team`: **added** @\user to this Team;
      - `removed-user-from-team`: **removed** @\user from this Team;
      - `user-converted-to-team`: **converted** #\room to a Team;
      - `user-converted-to-channel`: **converted** #\room to a Channel;
      - `user-removed-room-from-team`: **removed** @\user from this Team;
      - `user-deleted-room-from-team`: **deleted** #\room from this Team;
      - `user-added-room-to-team`: **deleted** #\room to this Team;

  - Add the corresponding options to hide each new system message and the missing `ujt` and `ult` hide options.

- Updated links in readme ([#24028](https://github.com/RocketChat/Rocket.Chat/pull/24028) by [@aswinidev](https://github.com/aswinidev))

### 🐛 Bug fixes


- "Match error" when converting a team to a channel ([#24629](https://github.com/RocketChat/Rocket.Chat/pull/24629))

  - Fix "Match error"  when trying to convert a channel to a team;

- **ENTERPRISE:** Auto reload feature of ddp-streamer micro service ([#24793](https://github.com/RocketChat/Rocket.Chat/pull/24793))

- **ENTERPRISE:** DDP streamer not sending data to all clients ([#24738](https://github.com/RocketChat/Rocket.Chat/pull/24738))

- **ENTERPRISE:** Notifications not being sent by ddp-streamer ([#24831](https://github.com/RocketChat/Rocket.Chat/pull/24831))

- **ENTERPRISE:** Presence micro service logic ([#24724](https://github.com/RocketChat/Rocket.Chat/pull/24724))

- 2FA via email when logging in using OAuth ([#24572](https://github.com/RocketChat/Rocket.Chat/pull/24572))

- Add ?close to OAuth callback url ([#24381](https://github.com/RocketChat/Rocket.Chat/pull/24381))

- Add katex render to new message react template ([#25239](https://github.com/RocketChat/Rocket.Chat/pull/25239))

- Add reaction not working in legacy messages ([#25222](https://github.com/RocketChat/Rocket.Chat/pull/25222))

- Added invalid password error message ([#24714](https://github.com/RocketChat/Rocket.Chat/pull/24714) by [@Himanshu664](https://github.com/Himanshu664))

- Adjust email label in Setup Wizard i18n files ([#25260](https://github.com/RocketChat/Rocket.Chat/pull/25260))

  - remove 'Company' label on onboarding email keys in certain languages

- AgentOverview analytics wrong departmentId parameter ([#25073](https://github.com/RocketChat/Rocket.Chat/pull/25073) by [@paulobernardoaf](https://github.com/paulobernardoaf))

  When filtering the analytics charts by department, data would not appear because the object:
  ```js
  {
  value: "department-id",
  label: "department-name"
  }
  ```
  was being used in the `departmentId` parameter.


  - Before:
  ![image](https://user-images.githubusercontent.com/30026625/161832057-d96ffd21-a7dd-421e-bfaa-3b9f4a9127b2.png)


  - After:
  ![image](https://user-images.githubusercontent.com/30026625/161831092-9ee77b51-b083-4f45-9c48-ab2e0511c4d6.png)

- API Error preventing adding an email to users without one (like bot/app users) ([#24709](https://github.com/RocketChat/Rocket.Chat/pull/24709))

- Apple OAuth ([#24879](https://github.com/RocketChat/Rocket.Chat/pull/24879))

- auto-join team channels not honoring user preferences ([#24779](https://github.com/RocketChat/Rocket.Chat/pull/24779) by [@ostjen](https://github.com/ostjen))

- Client disconnection on network loss ([#25170](https://github.com/RocketChat/Rocket.Chat/pull/25170) by [@amolghode1981](https://github.com/amolghode1981))

  Agent gets disconnected (or Unregistered) from asterisk in multiple ways. The goal is that agent should remain online
  unless agent explicitly logs off.
  Agent can stop receiving calls in multiple ways due to network loss. Network loss can happen in following ways.

  1. User tries to switch the network. User experiences a glitch of disconnectivity. This can be simulated by turning the network off
  in the network tab of chrome's dev tool. This can disconnect the UA if the disconnection happens just before the registration refresh.

  2. Second reason is when computer goes in sleep mode.

  3. Third reason is that when asterisk is crashed/in maintenance mode/explicitly stopped.

  Solution:
  The idea is to detect the network disconnection and start the start the attempts to reconnect.
  The detection of the disconnection does not happen in case#1. The SIPUA's UserAgent transport does not
  call onDisconnected when network loss of such kind happens. To tackle this problem, window's online and offline event handlers are
  used.

  The number of retries is configurable but ideally it is to be kept at -1. Whenever disconnection happens, it should keep on trying to
  reconnect with increasing backoff time. This behaviour is useful when the asterisk is stopped.

  When the server is disconnected, it should be indicated on the phone button.

- Close room when dismiss wrap up call modal ([#25056](https://github.com/RocketChat/Rocket.Chat/pull/25056))

- Custom sound error toast messages ([#24515](https://github.com/RocketChat/Rocket.Chat/pull/24515) by [@Himanshu664](https://github.com/Himanshu664))

- Database indexes not being created ([#25101](https://github.com/RocketChat/Rocket.Chat/pull/25101))

- Date Message Export Filter Fix ([#24542](https://github.com/RocketChat/Rocket.Chat/pull/24542) by [@eduardofcabrera](https://github.com/eduardofcabrera))

  Fix message export filter to get all messages between "from date" and "to date", including "to date".

- DDP Rate Limiter Translation key ([#24898](https://github.com/RocketChat/Rocket.Chat/pull/24898))

  Before:
  <img width="267" alt="image" src="https://user-images.githubusercontent.com/40830821/159324037-b17e2492-e007-49fd-bfd1-f1d009301c44.png">


  Now:
  <img width="611" alt="image" src="https://user-images.githubusercontent.com/40830821/159323594-10cf69a8-57dd-4e01-b4d3-31c92667a754.png">

- DDP streamer errors ([#24710](https://github.com/RocketChat/Rocket.Chat/pull/24710))

- Duplicated "jump to message" button on starred messages ([#24867](https://github.com/RocketChat/Rocket.Chat/pull/24867) by [@Himanshu664](https://github.com/Himanshu664))

- Dynamic load matrix is enabled and handle failure  ([#25495](https://github.com/RocketChat/Rocket.Chat/pull/25495))

- End call button disappearing when on-hold ([#24936](https://github.com/RocketChat/Rocket.Chat/pull/24936))

- External search providers not working ([#24860](https://github.com/RocketChat/Rocket.Chat/pull/24860) by [@tkurz](https://github.com/tkurz))

- Full error message is visible ([#24856](https://github.com/RocketChat/Rocket.Chat/pull/24856) by [@Himanshu664](https://github.com/Himanshu664))

- GDPR action to forget visitor data on request ([#24441](https://github.com/RocketChat/Rocket.Chat/pull/24441))

- German translation for Monitore ([#24785](https://github.com/RocketChat/Rocket.Chat/pull/24785) by [@JMoVS](https://github.com/JMoVS))

- Handle Other Formats inside Upload Avatar ([#24226](https://github.com/RocketChat/Rocket.Chat/pull/24226))

  After resolving issue #24213 :


  https://user-images.githubusercontent.com/53515714/150325012-91413025-786e-4ce0-ae75-629f6b05b024.mp4

- Ignore customClass on messages ([#24845](https://github.com/RocketChat/Rocket.Chat/pull/24845))

- Implement client errors on ddp-streamer ([#24310](https://github.com/RocketChat/Rocket.Chat/pull/24310))

- Inconsistent validation of user's access to rooms ([#24037](https://github.com/RocketChat/Rocket.Chat/pull/24037) by [@ostjen](https://github.com/ostjen))

- Incorrect websocket url in livechat widget ([#25261](https://github.com/RocketChat/Rocket.Chat/pull/25261))

- Initial User not added to default channel ([#25544](https://github.com/RocketChat/Rocket.Chat/pull/25544))

  If injecting initial user.  The user wasn’t added to the default General channel

- Issues on selecting users when importing CSV ([#24253](https://github.com/RocketChat/Rocket.Chat/pull/24253))

  * Fix users selecting by fixing their _id

  * Add condition to disable 'Start importing' button if `usersCount`, `channelsCount` and `messageCount` equals 0, or if messageCount is alone

  * Remove `disabled={usersCount === 0}` on user Tab

- LDAP avatars being rotated according to metadata even if the setting to rotate uploads is off ([#24320](https://github.com/RocketChat/Rocket.Chat/pull/24320))

  - Use the `FileUpload_RotateImages` setting (**Administration > File Upload > Rotate images on upload**) to control whether avatars should be rotated automatically based on their data (XEIF);

  - Display the avatar image preview (orientation) according to the `FileUpload_RotateImages` setting.

- LDAP sync removing users from channels when multiple groups are mapped to it ([#25434](https://github.com/RocketChat/Rocket.Chat/pull/25434))

- Message menu action not working on legacy messages. ([#25148](https://github.com/RocketChat/Rocket.Chat/pull/25148))

- Message preview not available for queued chats ([#25092](https://github.com/RocketChat/Rocket.Chat/pull/25092))

- Missing dependency on useEffect at CallProvider ([#24882](https://github.com/RocketChat/Rocket.Chat/pull/24882))

- Nextcloud OAuth for incomplete token URL ([#24476](https://github.com/RocketChat/Rocket.Chat/pull/24476))

- OAuth mismatch redirect_uri error ([#24450](https://github.com/RocketChat/Rocket.Chat/pull/24450))

- Oembed request not respecting payload limit ([#24418](https://github.com/RocketChat/Rocket.Chat/pull/24418))

- Omnichannel managers can't join chats in progress ([#24553](https://github.com/RocketChat/Rocket.Chat/pull/24553))

- One of the triggers was not working correctly ([#25409](https://github.com/RocketChat/Rocket.Chat/pull/25409))

- Outgoing webhook without scripts not saving messages ([#24401](https://github.com/RocketChat/Rocket.Chat/pull/24401))

- Prevent Apps Bridge to remove visitor status from room ([#24305](https://github.com/RocketChat/Rocket.Chat/pull/24305))

- Prevent call button toggle when user is on call ([#24758](https://github.com/RocketChat/Rocket.Chat/pull/24758))

- Prevent sequential messages edited icon to hide on hover ([#24984](https://github.com/RocketChat/Rocket.Chat/pull/24984))

  ### before
  <img width="297" alt="Screen Shot 2022-03-29 at 13 35 56" src="https://user-images.githubusercontent.com/27704687/160661700-c2aebe05-a1be-4235-9d20-bce0b6e5fdb5.png">

  ### after
  <img width="300" alt="Screen Shot 2022-03-29 at 11 48 05" src="https://user-images.githubusercontent.com/27704687/160639208-3883a7b0-718a-4e9d-87b1-db960fe9bfcd.png">

- Prune Message issue ([#24424](https://github.com/RocketChat/Rocket.Chat/pull/24424))

- Push privacy config to not show username not being respected ([#24606](https://github.com/RocketChat/Rocket.Chat/pull/24606))

- Read receipts show with color gray when not read yet ([#25244](https://github.com/RocketChat/Rocket.Chat/pull/25244))

- Read receipts showing before message read ([#25216](https://github.com/RocketChat/Rocket.Chat/pull/25216))

- Read receipts showing first messages of the room as read even if not read by everyone ([#24508](https://github.com/RocketChat/Rocket.Chat/pull/24508))

- Register with Secret URL ([#24921](https://github.com/RocketChat/Rocket.Chat/pull/24921))

- Replace encrypted text to Encrypted Message Placeholder ([#24166](https://github.com/RocketChat/Rocket.Chat/pull/24166))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/150807900-154a9cdb-ee13-4333-8628-f287ab914b40.png)

  ### after
  <img width="814" alt="Screenshot 2022-01-13 at 8 57 47 PM" src="https://user-images.githubusercontent.com/58601732/149359411-23e2430b-89e4-48b4-a3ad-65471d058551.png">

- Reply button behavior on broadcast channel ([#25175](https://github.com/RocketChat/Rocket.Chat/pull/25175))

  Hide reply button for the user that sent the message

- respect `Accounts_Registration_Users_Default_Roles` setting ([#24173](https://github.com/RocketChat/Rocket.Chat/pull/24173))

  - Fix `user` role being added as default regardless of the `Accounts_Registration_Users_Default_Roles` setting.

- Room archived/unarchived system messages aren't sent when editing room settings ([#24897](https://github.com/RocketChat/Rocket.Chat/pull/24897))

  - Send the "Room archived" and "Room unarchived" system messages when editing room settings (and not only when rooms are archived/unarchived with the slash-command);

  - Fix the "Hide System Messages" option for the "Room archived" and "Room unarchived" system messages;

- Room context tabs not working in Omnichannel current chats page ([#24559](https://github.com/RocketChat/Rocket.Chat/pull/24559))

- room creation fails if app framework is disabled ([#25200](https://github.com/RocketChat/Rocket.Chat/pull/25200))

- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

- Several issues related to custom roles ([#24052](https://github.com/RocketChat/Rocket.Chat/pull/24052))

  - Throw an error when trying to delete a role (User or Subscription role) that are still being used;

  - Fix "Invalid Role" error for custom roles in Role Editing sidebar;

  - Fix "Users in Role" screen for custom roles.

- Showing Blank Message Inside Report ([#25007](https://github.com/RocketChat/Rocket.Chat/pull/25007))

  https://user-images.githubusercontent.com/53515714/161038085-4a86c7ae-6751-4996-9767-b1c9e0331a6c.mp4

- Skip admin info in setup wizard for servers with admin registered ([#24485](https://github.com/RocketChat/Rocket.Chat/pull/24485))

- Skip cloud steps for registered servers on setup wizard ([#24407](https://github.com/RocketChat/Rocket.Chat/pull/24407))

- Slash commands previews not working ([#24387](https://github.com/RocketChat/Rocket.Chat/pull/24387) by [@ostjen](https://github.com/ostjen))

- Spotlight results showing usernames instead of real names ([#25471](https://github.com/RocketChat/Rocket.Chat/pull/25471))

- Startup errors creating indexes ([#24409](https://github.com/RocketChat/Rocket.Chat/pull/24409))

  Fix `bio` and `prid` startup index creation errors.

- Toolbox hiding under contextual bar ([#25237](https://github.com/RocketChat/Rocket.Chat/pull/25237))

- typo on register server tooltip of setup wizard ([#24466](https://github.com/RocketChat/Rocket.Chat/pull/24466))

- UI/UX issues on Live Chat widget ([#25407](https://github.com/RocketChat/Rocket.Chat/pull/25407))

- Use correct room property for call ended at ([#24932](https://github.com/RocketChat/Rocket.Chat/pull/24932))

- User abandonment setting was not working doe to failing event hook ([#25520](https://github.com/RocketChat/Rocket.Chat/pull/25520))

  A setting watcher and the query for grabbing abandoned chats were broken, now they're not.

- UserCard sanitization ([#25089](https://github.com/RocketChat/Rocket.Chat/pull/25089))

  - Rewrites the component to TS

  - Fixes some visual issues

  ### before
  ![Screen Shot 2022-04-07 at 00 23 11](https://user-images.githubusercontent.com/27704687/162113925-5c9484d1-23e9-4623-8b86-3fbc71b461a1.png)

  ### after
  ![Screen Shot 2022-04-07 at 00 07 13](https://user-images.githubusercontent.com/27704687/162112353-afd6aac6-b27c-4470-a642-631b8080d59e.png)

- Video and Audio not skipping forward ([#19866](https://github.com/RocketChat/Rocket.Chat/pull/19866))

- VoIP disabled/enabled  sequence puts voip agent in error state ([#25230](https://github.com/RocketChat/Rocket.Chat/pull/25230) by [@amolghode1981](https://github.com/amolghode1981))

  Initially it was thought that the issue occurs because of the race condition while changing the client settings vs those settings reflected on server side. So a natural solution to solve this is to wait for setting change event 'private-settings-changed'. Then if 'VoIP_Enabled' is updated and it is true, set voipEnabled  to true in useVoipClient.ts (on client side)

  It was realised that the race does not happen because of the database or server noticing the changes late. But because of the time taken to establish the AMI connection with Asterisk.

  Solution:


  1. Change apps/meteor/app/voip/server/startup.ts. When VoIP_Enabled is changed, await for Voip.init() to complete and then broadcast connector.statuschanged  with changed value.

  2. From apps/meteor/server/modules/listeners/listeners.module.ts use notifyLoggedInThisInstance to notify all logged in users on current instance.

  3. in apps/meteor/client/providers/CallProvider/hooks/useVoipClient.ts add the event handler that receives this event. Change voipEnabled from constant to state. Change this state based on the 'value' that is received by the handler.

- Wrong business hour behavior ([#24896](https://github.com/RocketChat/Rocket.Chat/pull/24896))

<details>
<summary>🔍 Minor changes</summary>


- Bump @rocket.chat/emitter from 0.31.4 to 0.31.9 in /ee/server/services ([#25021](https://github.com/RocketChat/Rocket.Chat/pull/25021) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/message-parser from 0.31.4 to 0.31.9 in /ee/server/services ([#25019](https://github.com/RocketChat/Rocket.Chat/pull/25019) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/string-helpers from 0.31.4 to 0.31.9 in /ee/server/services ([#25018](https://github.com/RocketChat/Rocket.Chat/pull/25018) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/ui-kit from 0.31.4 to 0.31.9 in /ee/server/services ([#25020](https://github.com/RocketChat/Rocket.Chat/pull/25020) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/clipboard from 2.0.1 to 2.0.7 ([#24832](https://github.com/RocketChat/Rocket.Chat/pull/24832) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/mailparser from 3.0.2 to 3.4.0 ([#24833](https://github.com/RocketChat/Rocket.Chat/pull/24833) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/nodemailer from 6.4.2 to 6.4.4 ([#24822](https://github.com/RocketChat/Rocket.Chat/pull/24822) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 8.2.2 to 8.2.3 in /ee/server/services ([#24556](https://github.com/RocketChat/Rocket.Chat/pull/24556) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 8.2.3 to 8.5.2 in /ee/server/services ([#24666](https://github.com/RocketChat/Rocket.Chat/pull/24666) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 8.5.2 to 8.5.3 in /ee/server/services ([#24820](https://github.com/RocketChat/Rocket.Chat/pull/24820) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump actions/checkout from 2 to 3 ([#24668](https://github.com/RocketChat/Rocket.Chat/pull/24668) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump actions/setup-node from 2 to 3 ([#24642](https://github.com/RocketChat/Rocket.Chat/pull/24642) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump adm-zip from 0.4.14 to 0.5.9 ([#24538](https://github.com/RocketChat/Rocket.Chat/pull/24538) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.0 to 1.19.1 in /ee/server/services ([#23963](https://github.com/RocketChat/Rocket.Chat/pull/23963) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.0 to 1.19.2 ([#24821](https://github.com/RocketChat/Rocket.Chat/pull/24821) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.1 to 1.19.2 in /ee/server/services ([#24517](https://github.com/RocketChat/Rocket.Chat/pull/24517) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.2 to 1.20.0 in /ee/server/services ([#25042](https://github.com/RocketChat/Rocket.Chat/pull/25042) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump cookie from 0.4.1 to 0.4.2 in /ee/server/services ([#24472](https://github.com/RocketChat/Rocket.Chat/pull/24472) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump date-fns from 2.24.0 to 2.28.0 ([#24058](https://github.com/RocketChat/Rocket.Chat/pull/24058) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ejson from 2.2.1 to 2.2.2 ([#25057](https://github.com/RocketChat/Rocket.Chat/pull/25057) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump eslint-plugin-anti-trojan-source from 1.0.6 to 1.1.0 ([#25076](https://github.com/RocketChat/Rocket.Chat/pull/25076) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump express from 4.17.1 to 4.17.2 in /ee/server/services ([#24469](https://github.com/RocketChat/Rocket.Chat/pull/24469) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump express from 4.17.2 to 4.17.3 in /ee/server/services ([#24522](https://github.com/RocketChat/Rocket.Chat/pull/24522) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump follow-redirects from 1.14.7 to 1.14.8 in /ee/server/services ([#24491](https://github.com/RocketChat/Rocket.Chat/pull/24491) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump is-svg from 4.3.1 to 4.3.2 ([#24801](https://github.com/RocketChat/Rocket.Chat/pull/24801) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump jaeger-client from 3.18.1 to 3.19.0 in /ee/server/services ([#23961](https://github.com/RocketChat/Rocket.Chat/pull/23961) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump jschardet from 1.6.0 to 3.0.0 ([#23121](https://github.com/RocketChat/Rocket.Chat/pull/23121) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump minimist from 1.2.5 to 1.2.6 in /ee/server/services ([#24991](https://github.com/RocketChat/Rocket.Chat/pull/24991) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino and pino-pretty ([#25052](https://github.com/RocketChat/Rocket.Chat/pull/25052))

- Bump pino from 7.8.0 to 7.8.1 in /ee/server/services ([#24783](https://github.com/RocketChat/Rocket.Chat/pull/24783) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino from 7.8.1 to 7.9.1 in /ee/server/services ([#24869](https://github.com/RocketChat/Rocket.Chat/pull/24869) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.1 to 7.5.2 in /ee/server/services ([#24689](https://github.com/RocketChat/Rocket.Chat/pull/24689) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.2 to 7.5.3 in /ee/server/services ([#24698](https://github.com/RocketChat/Rocket.Chat/pull/24698) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.3 to 7.5.4 in /ee/server/services ([#24870](https://github.com/RocketChat/Rocket.Chat/pull/24870) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pm2 from 5.1.2 to 5.2.0 in /ee/server/services ([#24537](https://github.com/RocketChat/Rocket.Chat/pull/24537) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump prometheus-gc-stats from 0.6.2 to 0.6.3 ([#24803](https://github.com/RocketChat/Rocket.Chat/pull/24803) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump simple-get from 4.0.0 to 4.0.1 ([#24341](https://github.com/RocketChat/Rocket.Chat/pull/24341) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump sodium-native from 3.2.1 to 3.3.0 in /ee/server/services ([#23512](https://github.com/RocketChat/Rocket.Chat/pull/23512) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump template-file from 6.0.0 to 6.0.1 ([#25002](https://github.com/RocketChat/Rocket.Chat/pull/25002) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ts-node from 10.5.0 to 10.6.0 in /ee/server/services ([#24667](https://github.com/RocketChat/Rocket.Chat/pull/24667) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ts-node from 10.6.0 to 10.7.0 in /ee/server/services ([#24716](https://github.com/RocketChat/Rocket.Chat/pull/24716) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump underscore.string from 3.3.5 to 3.3.6 in /ee/server/services ([#24498](https://github.com/RocketChat/Rocket.Chat/pull/24498) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump url-parse from 1.5.3 to 1.5.7 ([#24528](https://github.com/RocketChat/Rocket.Chat/pull/24528) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump url-parse from 1.5.7 to 1.5.10 ([#24640](https://github.com/RocketChat/Rocket.Chat/pull/24640) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump vm2 from 3.9.5 to 3.9.7 in /ee/server/services ([#24509](https://github.com/RocketChat/Rocket.Chat/pull/24509) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: `twoFactorRequired` signature ([#24518](https://github.com/RocketChat/Rocket.Chat/pull/24518))

  Improved type checking for decorator `twoFactorRequired`.

- Chore: Add description to global OTR setting ([#24333](https://github.com/RocketChat/Rocket.Chat/pull/24333) by [@pedrogssouza](https://github.com/pedrogssouza))

- Chore: Add E2E tests for livechat/room.close ([#24729](https://github.com/RocketChat/Rocket.Chat/pull/24729) by [@Muramatsu2602](https://github.com/Muramatsu2602))

  * Create a new test suite file under tests/end-to-end/api/livechat
    * Create tests for the following endpoint:
	  + ivechat/room.close

- Chore: Add E2E tests for livechat/visitor ([#24764](https://github.com/RocketChat/Rocket.Chat/pull/24764) by [@Muramatsu2602](https://github.com/Muramatsu2602))

  - Create a new test suite file under tests/end-to-end/api/livechat

  - Create tests for the following endpoints:
   + livechat/visitor (create visitor, update visitor, add custom fields to visitors)

- Chore: Add error boundary to message component ([#25223](https://github.com/RocketChat/Rocket.Chat/pull/25223))

  Not crash the whole application if something goes wrong in the MessageList component.

  ![image](https://user-images.githubusercontent.com/40830821/162269915-931c5c3c-c979-4234-b74c-371f67467ce0.png)

- Chore: Add Livechat repo into Monorepo packages ([#25312](https://github.com/RocketChat/Rocket.Chat/pull/25312))

- Chore: Add options to debug stdout and rate limiter ([#25336](https://github.com/RocketChat/Rocket.Chat/pull/25336))

- Chore: Add root package.json to houston files ([#25286](https://github.com/RocketChat/Rocket.Chat/pull/25286))

  See title

- Chore: add some missing REST definitions ([#24925](https://github.com/RocketChat/Rocket.Chat/pull/24925) by [@gerzonc](https://github.com/gerzonc))

  On the [mobile client](https://github.com/RocketChat/Rocket.Chat.ReactNative), we made an effort to collect more `REST API` definitions that are missing on the server side during our migration to TypeScript. Since we're both migrating to TypeScript, we thought it would be a good idea to share those so you guys can benefit from our initiative.

- Chore: Add yarn plugin to check node and yarn version ([#25224](https://github.com/RocketChat/Rocket.Chat/pull/25224))

- Chore: added Server Instances endpoint types ([#24507](https://github.com/RocketChat/Rocket.Chat/pull/24507))

  Created typing for endpoint definitions on `instances.ts`.

- Chore: added settings endpoint types ([#24506](https://github.com/RocketChat/Rocket.Chat/pull/24506))

  Created typing for endpoint definitions on `settings.ts`.

- Chore: APIClass types ([#24747](https://github.com/RocketChat/Rocket.Chat/pull/24747))

  This pull request creates a new `restivus` module (.d.ts) for the `api.js` file.

- Chore: Bump fuselage ([#25371](https://github.com/RocketChat/Rocket.Chat/pull/25371))

- Chore: Bump Fuselage packages ([#25259](https://github.com/RocketChat/Rocket.Chat/pull/25259))

- Chore: Bump Fuselage packages ([#25015](https://github.com/RocketChat/Rocket.Chat/pull/25015))

  It uses the last stable version of Fuselage packages.

- Chore: Bump Fuselage packages ([#24573](https://github.com/RocketChat/Rocket.Chat/pull/24573))

  It uses the last stable version of Fuselage packages.

- Chore: bump fuselage version ([#24453](https://github.com/RocketChat/Rocket.Chat/pull/24453))

- Chore: Cancel running jobs if PR is updated ([#24708](https://github.com/RocketChat/Rocket.Chat/pull/24708))

- Chore: Convert admin custom sound to tsx ([#25128](https://github.com/RocketChat/Rocket.Chat/pull/25128))

- Chore: Convert JS files to Typescript ([#24410](https://github.com/RocketChat/Rocket.Chat/pull/24410))

  This pull request converts 26 more files from Javascript to Typescript, to check variable types and increase validation on the code.

- Chore: Convert LivechatAgentActivity to raw model and TS ([#25123](https://github.com/RocketChat/Rocket.Chat/pull/25123))

- Chore: Convert Mailer to TS ([#25121](https://github.com/RocketChat/Rocket.Chat/pull/25121))

- Chore: Convert NotificationStatus to TS ([#25125](https://github.com/RocketChat/Rocket.Chat/pull/25125))

- Chore: Convert server functions from javascript to typescript ([#24384](https://github.com/RocketChat/Rocket.Chat/pull/24384))

  This pull request will be used to rewrite some functions on the Chat Engine to Typescript, in order to increase security and specify variable types on the code.

- Chore: Convert to typescript the me slashCommands files ([#24321](https://github.com/RocketChat/Rocket.Chat/pull/24321) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the me slashCommands files

- Chore: Convert to typescript the mute and unmute slash commands files ([#24325](https://github.com/RocketChat/Rocket.Chat/pull/24325) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the mute and unmute slash commands files

- Chore: Convert to typescript the slash commands create files ([#24306](https://github.com/RocketChat/Rocket.Chat/pull/24306) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert Slash Commands create files to typescript.

- Chore: Convert to typescript the slash commands invite files ([#24311](https://github.com/RocketChat/Rocket.Chat/pull/24311) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the slash commands invite files

- Chore: Convert to typescript the unarchive slash commands files ([#24331](https://github.com/RocketChat/Rocket.Chat/pull/24331) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the unarchive slash commands files

- Chore: converted more hooks to typescript ([#24628](https://github.com/RocketChat/Rocket.Chat/pull/24628))

  Converted some functions on `client/hooks/` from JavaScript to Typescript.

- Chore: Create README.md for Rest Typings ([#25335](https://github.com/RocketChat/Rocket.Chat/pull/25335))

- Chore: Delete unused file (NewAdminInfoPage.js) ([#24196](https://github.com/RocketChat/Rocket.Chat/pull/24196))

  Just removing a duplicated/unused file.

- Chore: ensure scripts use cross-env and ignore some dirs (ROC-54) ([#25218](https://github.com/RocketChat/Rocket.Chat/pull/25218) by [@souzaramon](https://github.com/souzaramon))

  - data and test-failure should be ignored

  - ensure scripts use cross-env

- Chore: Fix Cypress tests ([#24544](https://github.com/RocketChat/Rocket.Chat/pull/24544))

- Chore: Fix grammatical errors in Code of Conduct ([#24759](https://github.com/RocketChat/Rocket.Chat/pull/24759) by [@aadishJ01](https://github.com/aadishJ01))

- Chore: fix grammatical errors in Features ([#24771](https://github.com/RocketChat/Rocket.Chat/pull/24771) by [@aadishJ01](https://github.com/aadishJ01))

- Chore: Fix return type warnings ([#25275](https://github.com/RocketChat/Rocket.Chat/pull/25275))

- Chore: Get Settings Statistics ([#24397](https://github.com/RocketChat/Rocket.Chat/pull/24397))

- Chore: Improve logger to allow log of `unknown` values ([#24726](https://github.com/RocketChat/Rocket.Chat/pull/24726))

- Chore: Improve PR title validation regex ([#24467](https://github.com/RocketChat/Rocket.Chat/pull/24467))

- Chore: Improvements on role syncing (ldap, oauth and saml) ([#23824](https://github.com/RocketChat/Rocket.Chat/pull/23824))

- Chore: Js to ts slash commands archive ([#24304](https://github.com/RocketChat/Rocket.Chat/pull/24304) by [@eduardofcabrera](https://github.com/eduardofcabrera))

  Convert Slash Commands archive files to typescript

- Chore: Micro services fixes and cleanup ([#24753](https://github.com/RocketChat/Rocket.Chat/pull/24753))

- Chore: Migrate oauth2server to typescript ([#25126](https://github.com/RocketChat/Rocket.Chat/pull/25126))

- Chore: Minor dependency updates ([#25269](https://github.com/RocketChat/Rocket.Chat/pull/25269))

- Chore: Missing keys in APIsDisplay ([#24464](https://github.com/RocketChat/Rocket.Chat/pull/24464))

- Chore: Monorepo  ([#25074](https://github.com/RocketChat/Rocket.Chat/pull/25074))

- Chore: move definitions to packages ([#25085](https://github.com/RocketChat/Rocket.Chat/pull/25085))

- Chore: organize test files and fix code coverage ([#24900](https://github.com/RocketChat/Rocket.Chat/pull/24900))

- Chore: Remove Alpine image deps after using them ([#25053](https://github.com/RocketChat/Rocket.Chat/pull/25053))

- Chore: Remove duplicated useUserRoom ([#25180](https://github.com/RocketChat/Rocket.Chat/pull/25180))

- Chore: Remove old files from removed Omnichannel feature ([#25129](https://github.com/RocketChat/Rocket.Chat/pull/25129))

- Chore: Remove old scripts ([#24911](https://github.com/RocketChat/Rocket.Chat/pull/24911))

- Chore: Remove package-lock.json from houston files ([#25280](https://github.com/RocketChat/Rocket.Chat/pull/25280))

  Houston config in the `package.json` file still mentioned `package-lock.json`, but it doesn't exist anymore

- Chore: Remove storybook build job from CI ([#24530](https://github.com/RocketChat/Rocket.Chat/pull/24530))

- Chore: Remove unused Drone CI files ([#25124](https://github.com/RocketChat/Rocket.Chat/pull/25124))

- Chore: roomTypes: Stop mixing client and server code together ([#24536](https://github.com/RocketChat/Rocket.Chat/pull/24536))

- Chore: Run tests using microservices deployment on CI ([#24513](https://github.com/RocketChat/Rocket.Chat/pull/24513))

- Chore: Set Docker image tag to latest only when really latest ([#24366](https://github.com/RocketChat/Rocket.Chat/pull/24366))

- Chore: Skip local services changes when shutting down duplicated services ([#24810](https://github.com/RocketChat/Rocket.Chat/pull/24810))

- Chore: Storybook mocking and examples improved ([#24969](https://github.com/RocketChat/Rocket.Chat/pull/24969))

  - Stories from `ee/` included;

  - Differentiate root story kinds;

  - Mocking of `ServerContext` via Storybook parameters.

- Chore: Sync with master ([#25284](https://github.com/RocketChat/Rocket.Chat/pull/25284))

- Chore: Template to generate packages ([#25174](https://github.com/RocketChat/Rocket.Chat/pull/25174))

  ```
  npx hygen package new test
  ```

- Chore: Tests with Playwright (task: All works) ([#25122](https://github.com/RocketChat/Rocket.Chat/pull/25122) by [@weslley543](https://github.com/weslley543))

- Chore: Tests with Playwright (task: ROC-28, 09-channels) ([#25196](https://github.com/RocketChat/Rocket.Chat/pull/25196))

- Chore: TS conversion folder client ([#25031](https://github.com/RocketChat/Rocket.Chat/pull/25031))

- Chore: TS migration SortList ([#25167](https://github.com/RocketChat/Rocket.Chat/pull/25167))

- Chore: Unify ILivechatAgent with ILivechatAgentRecord ([#24406](https://github.com/RocketChat/Rocket.Chat/pull/24406))

- Chore: Update Apps-Engine ([#24651](https://github.com/RocketChat/Rocket.Chat/pull/24651))

- Chore: Update Apps-Engine ([#24568](https://github.com/RocketChat/Rocket.Chat/pull/24568))

- Chore: Update fuselage deps to match monolith versions ([#24501](https://github.com/RocketChat/Rocket.Chat/pull/24501))

- Chore: Update Livechat to the last version ([#25257](https://github.com/RocketChat/Rocket.Chat/pull/25257))

- Chore: Update Livechat version ([#25130](https://github.com/RocketChat/Rocket.Chat/pull/25130))

- Chore: Update Meteor to 2.5.6 ([#24461](https://github.com/RocketChat/Rocket.Chat/pull/24461))

- Chore: update OTR icon ([#24521](https://github.com/RocketChat/Rocket.Chat/pull/24521) by [@kibonusp](https://github.com/kibonusp))

  I changed the shredder icon in OTR contextual bar to the stopwatch icon, recently added to the fuselage.

- Chore: Update ws package ([#24477](https://github.com/RocketChat/Rocket.Chat/pull/24477))

- Chore(deps-dev): Bump @types/mock-require from 2.0.0 to 2.0.1 ([#24574](https://github.com/RocketChat/Rocket.Chat/pull/24574) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore(deps-dev): Bump ts-node from 10.0.0 to 10.5.0 in /ee/server/services ([#24435](https://github.com/RocketChat/Rocket.Chat/pull/24435) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore(deps): Bump node-fetch from 2.6.1 to 2.6.7 in /ee/server/services ([#24299](https://github.com/RocketChat/Rocket.Chat/pull/24299) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- i18n: Language update from LingoHub 🤖 on 2022-01-31Z ([#24357](https://github.com/RocketChat/Rocket.Chat/pull/24357))

- i18n: Language update from LingoHub 🤖 on 2022-02-07Z ([#24429](https://github.com/RocketChat/Rocket.Chat/pull/24429))

- i18n: Language update from LingoHub 🤖 on 2022-02-14Z ([#24493](https://github.com/RocketChat/Rocket.Chat/pull/24493))

- i18n: Language update from LingoHub 🤖 on 2022-02-21Z ([#24558](https://github.com/RocketChat/Rocket.Chat/pull/24558))

- i18n: Language update from LingoHub 🤖 on 2022-02-28Z ([#24644](https://github.com/RocketChat/Rocket.Chat/pull/24644))

- i18n: Language update from LingoHub 🤖 on 2022-03-07Z ([#24717](https://github.com/RocketChat/Rocket.Chat/pull/24717))

- i18n: Language update from LingoHub 🤖 on 2022-03-14Z ([#24823](https://github.com/RocketChat/Rocket.Chat/pull/24823))

- i18n: Language update from LingoHub 🤖 on 2022-03-21Z ([#24895](https://github.com/RocketChat/Rocket.Chat/pull/24895))

- i18n: Language update from LingoHub 🤖 on 2022-03-28Z ([#24971](https://github.com/RocketChat/Rocket.Chat/pull/24971))

- i18n: Language update from LingoHub 🤖 on 2022-04-04Z ([#25043](https://github.com/RocketChat/Rocket.Chat/pull/25043))

- Merge master into develop & Set version to 4.5.0-develop ([#24363](https://github.com/RocketChat/Rocket.Chat/pull/24363))

- Merge master into develop & Set version to 4.6.0-develop ([#24653](https://github.com/RocketChat/Rocket.Chat/pull/24653))

- Merge master into develop & Set version to 4.7.0-develop ([#25028](https://github.com/RocketChat/Rocket.Chat/pull/25028))

- Regression: Add `isPending` status to message ([#25299](https://github.com/RocketChat/Rocket.Chat/pull/25299))

- Regression: Add createdOTR index ([#25017](https://github.com/RocketChat/Rocket.Chat/pull/25017))

- Regression: Add eslint package to micro services Dockerfile ([#25311](https://github.com/RocketChat/Rocket.Chat/pull/25311))

- Regression: Add select message to system message and thread preview and allow select on legacy template ([#25251](https://github.com/RocketChat/Rocket.Chat/pull/25251))

- Regression: Add support to namespace within micro services ([#24581](https://github.com/RocketChat/Rocket.Chat/pull/24581))

- Regression: Admin Sidebar colors inverted. ([#24609](https://github.com/RocketChat/Rocket.Chat/pull/24609))

- Regression: Avatar not loading on first direct message ([#25211](https://github.com/RocketChat/Rocket.Chat/pull/25211))

  fix avatar not loading on a first direct message

- Regression: Better MongoDB connection management for micro services ([#25323](https://github.com/RocketChat/Rocket.Chat/pull/25323))

- Regression: bump onboarding-ui version ([#25320](https://github.com/RocketChat/Rocket.Chat/pull/25320))

  - Bump to 'next' the onboarding-ui package from fuselage.

  - Update from 'companyEmail' to 'email' adminData usage types

- Regression: Bunch of settings fixes for VoIP ([#24594](https://github.com/RocketChat/Rocket.Chat/pull/24594))

- Regression: Call doesn't stop ringing after agent unregistration ([#24908](https://github.com/RocketChat/Rocket.Chat/pull/24908))

- Regression: Change preference to be default legacy messages ([#25255](https://github.com/RocketChat/Rocket.Chat/pull/25255))

- Regression: CI playwright ([#25168](https://github.com/RocketChat/Rocket.Chat/pull/25168))

- Regression: Custom roles displaying ID instead of name on some admin screens ([#24999](https://github.com/RocketChat/Rocket.Chat/pull/24999))

  ![image](https://user-images.githubusercontent.com/55164754/160981416-555bcaa1-c075-4260-937c-64523472da43.png)
  ![image](https://user-images.githubusercontent.com/55164754/160981452-6eae4e74-8425-4073-8256-472aba72b9db.png)

- Regression: Do not show toast on incoming voip calls ([#24619](https://github.com/RocketChat/Rocket.Chat/pull/24619))

- Regression: Encode registration info as JWT when signing key is provided ([#24626](https://github.com/RocketChat/Rocket.Chat/pull/24626))

- Regression: Error is raised when there's no Asterisk queue available yet ([#24980](https://github.com/RocketChat/Rocket.Chat/pull/24980) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Error setting user avatars and mentioning rooms on Slack Import ([#24585](https://github.com/RocketChat/Rocket.Chat/pull/24585))

  - Fix `Mentioned room not found` error when importing rooms from Slack;

  - Fix `Forbidden` error when setting avatars for users imported from Slack (on user import/creation);

  - Fix incorrect message count on imported rooms;

  - Fix missing username on messages imported from Slack;

- Regression: Error when trying to load name of dm rooms for avatars and notifications ([#24583](https://github.com/RocketChat/Rocket.Chat/pull/24583))

- Regression: eslint not running on packages ([#25305](https://github.com/RocketChat/Rocket.Chat/pull/25305))

- Regression: Extension List panel UI not aligned with designs ([#24645](https://github.com/RocketChat/Rocket.Chat/pull/24645))

- Regression: Fix account service login expiration ([#24920](https://github.com/RocketChat/Rocket.Chat/pull/24920))

- Regression: Fix CI monorepo build ([#25107](https://github.com/RocketChat/Rocket.Chat/pull/25107))

- Regression: Fix clicking on visitor's chat in the sidebar does not display the chat window ([#25380](https://github.com/RocketChat/Rocket.Chat/pull/25380))

  Fix: livechat room not opening.

- Regression: Fix double value on holdTime and empty msg on last message ([#24630](https://github.com/RocketChat/Rocket.Chat/pull/24630))

- Regression: Fix English i18n react text ([#25368](https://github.com/RocketChat/Rocket.Chat/pull/25368))

  Incorrect text in reaction tooltip has been fixed

- Regression: Fix federation Matrix bridge startup ([#25273](https://github.com/RocketChat/Rocket.Chat/pull/25273))

- Regression: Fix in-correct room status shown to agents ([#24592](https://github.com/RocketChat/Rocket.Chat/pull/24592))

- Regression: Fix incoming voip call ringtone is not ringing ([#24616](https://github.com/RocketChat/Rocket.Chat/pull/24616))

- Regression: Fix micro services Docker build ([#25193](https://github.com/RocketChat/Rocket.Chat/pull/25193))

- Regression: Fix multi line is not showing an empty line between lines ([#25317](https://github.com/RocketChat/Rocket.Chat/pull/25317))

- Regression: Fix reply button not working when hideFlexTab is enabled ([#25306](https://github.com/RocketChat/Rocket.Chat/pull/25306))

- Regression: Fix room not getting created due to null visitor status ([#24562](https://github.com/RocketChat/Rocket.Chat/pull/24562))

- Regression: Fix services Docker build on CI ([#25181](https://github.com/RocketChat/Rocket.Chat/pull/25181))

- Regression: Fix size of custom emoji and render emoji on thread message preview ([#25314](https://github.com/RocketChat/Rocket.Chat/pull/25314))

- Regression: Fix the alpine image and dev UX installing matrix-rust-sdk-bindings ([#25319](https://github.com/RocketChat/Rocket.Chat/pull/25319))

  The package only included a few pre-built which caused all macs to have to compile every time they installed and also caused our alpine not to work.

  This temporarily switches to a fork of the matrix-appservice-bridge package.

  Made changes to one of its child dependencies `matrix-rust-sdk-bindings` that adds pre-built binaries for mac and musl (for alpine).

- Regression: Fix time fields and wrap up in Voip Room Contexual bar ([#24625](https://github.com/RocketChat/Rocket.Chat/pull/24625))

- Regression: Fix time format on Voip system messages ([#24603](https://github.com/RocketChat/Rocket.Chat/pull/24603))

- Regression: Fix translation for call started message ([#24615](https://github.com/RocketChat/Rocket.Chat/pull/24615))

- Regression: Fix unexpected errors breaking ddp-streamer ([#24948](https://github.com/RocketChat/Rocket.Chat/pull/24948))

- Regression: Fix wrong tab name for VoIP settings ([#24647](https://github.com/RocketChat/Rocket.Chat/pull/24647))

- Regression: Fixes in Voice Contextual Bar and Directory ([#24596](https://github.com/RocketChat/Rocket.Chat/pull/24596))

- Regression: If Asterisk suddenly goes down, server has no way to know. Causes server to get stuck. Needs restart ([#24624](https://github.com/RocketChat/Rocket.Chat/pull/24624) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Improve Sidenav open/close handling and fixed codeql configs and E2E tests ([#24756](https://github.com/RocketChat/Rocket.Chat/pull/24756))

- Regression: Mark all rooms as read modal closing instantly. ([#24610](https://github.com/RocketChat/Rocket.Chat/pull/24610))

- Regression: Messages in new message template Crashing. ([#25327](https://github.com/RocketChat/Rocket.Chat/pull/25327))

- Regression: No audio when call comes from Skype/IP phone ([#24602](https://github.com/RocketChat/Rocket.Chat/pull/24602) by [@amolghode1981](https://github.com/amolghode1981))

  The audio was not rendered because of re-rendering of react element based on
  queueCounter and roomInfo. queueCounter and roomInfo cause the dom to re-render when call gets accepted
  because after accepting call, queueCounter changes or a room gets created.
  The audio element gets recreated. But VoIP user probably holds the old one.
  The behaviour is not predictable when such case happens. If everything gets cleanly setup,
  even if the audio element goes headless, it still continues to play the remote audio.
  But in other cases, it is unreferenced the one on dom has its srcObject as null.
  This causes no audio.

  This fix provides a way to re-initialise the rendering elements in VoIP user
  and calls this function on useEffect() if the re-render has happen.

- Regression: Prevent button from losing state when rerendering ([#24648](https://github.com/RocketChat/Rocket.Chat/pull/24648))

- Regression: Prevent connect to asterisk when VoIP is disabled ([#24601](https://github.com/RocketChat/Rocket.Chat/pull/24601))

- Regression: Queue counter aggregator for incoming/hanged calls ([#24635](https://github.com/RocketChat/Rocket.Chat/pull/24635) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Refresh server connection when MI server settings change ([#24649](https://github.com/RocketChat/Rocket.Chat/pull/24649))

- Regression: Register services right away ([#24800](https://github.com/RocketChat/Rocket.Chat/pull/24800))

- Regression: Revert Bugsnag version ([#25313](https://github.com/RocketChat/Rocket.Chat/pull/25313))

- Regression: Rocket.Chat Webapp not loading. ([#25349](https://github.com/RocketChat/Rocket.Chat/pull/25349))

- Regression: Role Sync not always working ([#24850](https://github.com/RocketChat/Rocket.Chat/pull/24850))

- Regression: Server crashing if Voip credentials are invalid ([#24646](https://github.com/RocketChat/Rocket.Chat/pull/24646))

- Regression: Show username and real name on the message system ([#25254](https://github.com/RocketChat/Rocket.Chat/pull/25254))

- Regression: Shows error if micro service cannot connect to Mongo ([#25301](https://github.com/RocketChat/Rocket.Chat/pull/25301))

- Regression: Use exact Node version on micro services Docker images ([#25287](https://github.com/RocketChat/Rocket.Chat/pull/25287))

- Regression: Validate empty fields for Message template ([#25250](https://github.com/RocketChat/Rocket.Chat/pull/25250))

- Regression: VoIP service button displayed when VoIP is disabled ([#24598](https://github.com/RocketChat/Rocket.Chat/pull/24598))

- Regression: yarn dev triggers build dependencies ([#25208](https://github.com/RocketChat/Rocket.Chat/pull/25208))

- Release 4.5.0 ([#24652](https://github.com/RocketChat/Rocket.Chat/pull/24652) by [@LucasFASouza](https://github.com/LucasFASouza) & [@aswinidev](https://github.com/aswinidev) & [@dependabot[bot]](https://github.com/dependabot[bot]) & [@lingohub[bot]](https://github.com/lingohub[bot]) & [@ostjen](https://github.com/ostjen))

- Release 4.5.1 ([#24782](https://github.com/RocketChat/Rocket.Chat/pull/24782) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari) & [@amolghode1981](https://github.com/amolghode1981) & [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Release 4.5.2 ([#24814](https://github.com/RocketChat/Rocket.Chat/pull/24814))

- Release 4.5.3 ([#24884](https://github.com/RocketChat/Rocket.Chat/pull/24884) by [@amolghode1981](https://github.com/amolghode1981))

- Release 4.5.4 ([#24938](https://github.com/RocketChat/Rocket.Chat/pull/24938))

- Release 4.5.5 ([#24998](https://github.com/RocketChat/Rocket.Chat/pull/24998))

- Release 4.6.0 ([#25027](https://github.com/RocketChat/Rocket.Chat/pull/25027) by [@amolghode1981](https://github.com/amolghode1981) & [@aswinidev](https://github.com/aswinidev) & [@dependabot[bot]](https://github.com/dependabot[bot]) & [@eduardofcabrera](https://github.com/eduardofcabrera) & [@lingohub[bot]](https://github.com/lingohub[bot]))

- Release 4.6.1 ([#25095](https://github.com/RocketChat/Rocket.Chat/pull/25095))

- Release 4.6.2 ([#25191](https://github.com/RocketChat/Rocket.Chat/pull/25191) by [@sidmohanty11](https://github.com/sidmohanty11))

- Release 4.6.3 ([#25235](https://github.com/RocketChat/Rocket.Chat/pull/25235))

- Release 4.7.0 ([#25390](https://github.com/RocketChat/Rocket.Chat/pull/25390) by [@Himanshu664](https://github.com/Himanshu664) & [@dependabot[bot]](https://github.com/dependabot[bot]) & [@lingohub[bot]](https://github.com/lingohub[bot]))

- Release 4.7.1 ([#25510](https://github.com/RocketChat/Rocket.Chat/pull/25510) by [@felipe-menelau](https://github.com/felipe-menelau))

- Release 4.7.2 ([#25580](https://github.com/RocketChat/Rocket.Chat/pull/25580))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@Himanshu664](https://github.com/Himanshu664)
- [@JMoVS](https://github.com/JMoVS)
- [@LucasFASouza](https://github.com/LucasFASouza)
- [@Muramatsu2602](https://github.com/Muramatsu2602)
- [@aadishJ01](https://github.com/aadishJ01)
- [@aakash-gitdev](https://github.com/aakash-gitdev)
- [@amolghode1981](https://github.com/amolghode1981)
- [@aswinidev](https://github.com/aswinidev)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@eduardofcabrera](https://github.com/eduardofcabrera)
- [@felipe-menelau](https://github.com/felipe-menelau)
- [@gerzonc](https://github.com/gerzonc)
- [@kibonusp](https://github.com/kibonusp)
- [@lingohub[bot]](https://github.com/lingohub[bot])
- [@ostjen](https://github.com/ostjen)
- [@paulobernardoaf](https://github.com/paulobernardoaf)
- [@pedrogssouza](https://github.com/pedrogssouza)
- [@sidmohanty11](https://github.com/sidmohanty11)
- [@souzaramon](https://github.com/souzaramon)
- [@tkurz](https://github.com/tkurz)
- [@ujorgeleite](https://github.com/ujorgeleite)
- [@weslley543](https://github.com/weslley543)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@alansikora](https://github.com/alansikora)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@jeanfbrito](https://github.com/jeanfbrito)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@tmontini](https://github.com/tmontini)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.4.4
`2022-05-20  ·  12 🎉  ·  26 🚀  ·  79 🐛  ·  213 🔍  ·  54 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.3`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🎉 New features


- Add expire index to integration history ([#25087](https://github.com/RocketChat/Rocket.Chat/pull/25087))

- Alpha Matrix Federation ([#23688](https://github.com/RocketChat/Rocket.Chat/pull/23688))

  Experimental support for Matrix Federation with a Bridge

  https://user-images.githubusercontent.com/51996/164530391-e8b17ecd-a4d0-4ef8-a8b7-81230c1773d3.mp4

- E2E password generator ([#24114](https://github.com/RocketChat/Rocket.Chat/pull/24114) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Engagement Statistics ([#24989](https://github.com/RocketChat/Rocket.Chat/pull/24989))

- Engagement Statistics ([#24777](https://github.com/RocketChat/Rocket.Chat/pull/24777) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Expand Apps Engine's environment variable allowed list ([#23870](https://github.com/RocketChat/Rocket.Chat/pull/23870) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Marketplace sort filter ([#24567](https://github.com/RocketChat/Rocket.Chat/pull/24567) by [@ujorgeleite](https://github.com/ujorgeleite))

  Implemented a sort filter for the marketplace screen. This component sorts the marketplace apps list in 4 ways, alphabetical order(A-Z), inverse alphabetical order(Z-A), most recently updated(MRU), and least recent updated(LRU). Besides that, I've generalized some components and types to increase code reusability, renamed some helpers as well as deleted some useless ones, and inserted the necessary new translations on the English i18n dictionary.
  Demo gif:
  ![Marketplace sort filter](https://user-images.githubusercontent.com/43561537/155033709-e07a6306-a85a-4f7f-9624-b53ba5dd7fa9.gif)

- Message Template React Component ([#23971](https://github.com/RocketChat/Rocket.Chat/pull/23971))

  Complete rewrite of the messages component in react. Visual changes should be minimal as well as user impact, with no break changes (unless you've customized the blaze template).



  ![Screen Shot 2022-04-05 at 11 14 18](https://user-images.githubusercontent.com/27704687/161774027-38dd9c7b-eeeb-45e2-b9d8-ea2a9be8486d.png)
  In case you encounter any problems, or want to compare, temporarily it is possible to use the old version

  <img width="556" alt="image" src="https://user-images.githubusercontent.com/5263975/162099800-15806953-f2f5-4905-a424-3f095076bc1d.png">

- Telemetry Events ([#24781](https://github.com/RocketChat/Rocket.Chat/pull/24781) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

- Upgrade Tab ([#24835](https://github.com/RocketChat/Rocket.Chat/pull/24835))

  ![image](https://user-images.githubusercontent.com/27704687/160172260-c656282e-a487-4092-948d-d11c9bacb598.png)

- Use setting to determine if initial general channel is needed ([#25441](https://github.com/RocketChat/Rocket.Chat/pull/25441) by [@felipe-menelau](https://github.com/felipe-menelau))

  - Adds flag responsible for overwriting #general channel creation

- VoIP Support for Omnichannel ([#23102](https://github.com/RocketChat/Rocket.Chat/pull/23102) by [@amolghode1981](https://github.com/amolghode1981))

  - Created VoipService to manage VoIP connections and PBX connection

  - Created LivechatVoipService that will handle custom cases for livechat (creating rooms, assigning chats to queue, actions when call is finished, etc)

  - Created Basic interfaces to support new services and new model

  - Created Endpoints for management interfaces

  - Implemented asterisk connector on VoIP service

  - Created UI components to show calls incoming and to allow answering/rejecting calls

  - Added new settings to control call server/management server connection values

  - Added endpoints to associate Omnichannel Agents with PBX Extensions

  - Added support for event listening on server side, to get metadata about calls being received/ongoing

  - Created new pages to update settings & to see user-extension association

  - Created new page to see ongoing calls (and past calls)

  - Added support for remote hangup/hold on calls

  - Implemented call metrics calculation (hold time, waiting time, talk time)

  - Show a notificaiton when call is received

### 🚀 Improvements


- **ENTERPRISE:** Don't start presence monitor when running micro services ([#24739](https://github.com/RocketChat/Rocket.Chat/pull/24739))

- **ENTERPRISE:** Improve how micro services are loaded ([#24388](https://github.com/RocketChat/Rocket.Chat/pull/24388))

- Add OTR Room States ([#24565](https://github.com/RocketChat/Rocket.Chat/pull/24565))

  Earlier OTR room uses only 2 states, we need more states to support future features.
  This adds more states for the OTR contextualBar.


  - Expired
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 52" src="https://user-images.githubusercontent.com/27704687/164283351-068756be-3419-4773-9d55-c9c1a72f5a19.png">


  - Declined
  <img width="343" alt='Screen Shot 2022-04-20 at 13 49 28' src='https://user-images.githubusercontent.com/27704687/164282312-fa3c6841-23d4-46e1-a8e9-80882a105d8c.png' />


  - Error
  <img width="343" alt="Screen Shot 2022-04-20 at 13 55 26" src="https://user-images.githubusercontent.com/27704687/164283261-95e06d06-b0d0-402d-bccc-66596ff4dcd3.png">

- Add return button in chats opened from the list of current chats ([#24458](https://github.com/RocketChat/Rocket.Chat/pull/24458) by [@LucasFASouza](https://github.com/LucasFASouza))

  The new return button for Omnichannel chats came out with release 3.15  but the feature was only available for chats that were opened from Omnichannel Contact Center.
  Now, the same UI/UX is supported for chats opened from Current Chats list.

  ![image](https://user-images.githubusercontent.com/32396925/153283190-bd5c9748-c36b-4874-a704-6043afc7e3a1.png)

  The chat now opens in the Omnichannel settings and has the return button so the user can go back to the Current Chats list.

  ![image](https://user-images.githubusercontent.com/32396925/153285591-fad8e4a0-d2ea-4a02-8b2a-15e383b3c876.png)

- Add tooltip to sidebar room menu ([#24405](https://github.com/RocketChat/Rocket.Chat/pull/24405) by [@Himanshu664](https://github.com/Himanshu664))

- Add tooltips on action buttons of Canned Response message composer ([#24483](https://github.com/RocketChat/Rocket.Chat/pull/24483) by [@LucasFASouza](https://github.com/LucasFASouza))

  The tooltips were missing on the action buttons of CR message composer.

  ![image](https://user-images.githubusercontent.com/32396925/153620327-91107245-4b47-4d39-a99a-6da6d1cf5734.png)

  Users can now feel more encouraged to use these actions knowing what they are supposed to do.

- Add user to room on "Click to Join!" button press ([#24041](https://github.com/RocketChat/Rocket.Chat/pull/24041) by [@ostjen](https://github.com/ostjen))

  - Add user to room on "Click to Join!" button press;

  - Display the "Join" button in discussions inside channels (keeping the behavior consistent with discussions inside groups).

- Added a new "All" tab which shows all integrations in Integrations ([#24109](https://github.com/RocketChat/Rocket.Chat/pull/24109) by [@aswinidev](https://github.com/aswinidev))

- Added MaxNickNameLength and MaxBioLength constants ([#25231](https://github.com/RocketChat/Rocket.Chat/pull/25231) by [@aakash-gitdev](https://github.com/aakash-gitdev))

- Added tooltip options for message menu ([#24431](https://github.com/RocketChat/Rocket.Chat/pull/24431) by [@Himanshu664](https://github.com/Himanshu664))

- Adding new statistics related to voip and omnichannel ([#24887](https://github.com/RocketChat/Rocket.Chat/pull/24887))

  - Total of Canned response messages sent

  - Total of tags used

  - Last-Chatted Agent Preferred (enabled/disabled)

  - Assign new conversations to the contact manager (enabled/disabled)

  - How to handle Visitor Abandonment setting

  - Amount of chats placed on hold

  - VoIP Enabled

  - Amount of VoIP Calls

  - Amount of VoIP Extensions connected

  - Amount of Calls placed on hold (1x per call)

  - Fixed Session Aggregation type definitions

- ChatBox Text to File Description ([#24451](https://github.com/RocketChat/Rocket.Chat/pull/24451) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  The text content from chatbox goes to the file description when drag and drop a file.

- Close modal on esc and outside click ([#24275](https://github.com/RocketChat/Rocket.Chat/pull/24275))

  This is a QUICK change in order to close modals pressing Esc button and clicking outside of it **intentionally**.

- CloudLoginModal visual consistency ([#24334](https://github.com/RocketChat/Rocket.Chat/pull/24334))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/151585064-dc6a1e29-9903-4241-8fbd-dfbe6c55fbef.png)

  ### after
  ![Screen Shot 2022-01-28 at 13 32 02](https://user-images.githubusercontent.com/27704687/151585101-75b98502-9aae-4198-bc3e-4956750e5d8b.png)

- Convert tag edit with department data to tsx ([#24369](https://github.com/RocketChat/Rocket.Chat/pull/24369) by [@LucasFASouza](https://github.com/LucasFASouza))

- Descriptive tooltip for Encrypted Key on Room Header ([#24121](https://github.com/RocketChat/Rocket.Chat/pull/24121))

- Improve active/hover colors in account sidebar ([#25024](https://github.com/RocketChat/Rocket.Chat/pull/25024) by [@Himanshu664](https://github.com/Himanshu664))

- New omnichannel statistics and async statistics processing. ([#24749](https://github.com/RocketChat/Rocket.Chat/pull/24749))

  https://app.clickup.com/t/1z4zg4e

- OTR system messages ([#24382](https://github.com/RocketChat/Rocket.Chat/pull/24382))

  OTR system messages to indicate key refresh and joining chat to users.

- Performance for some Omnichannel features ([#25217](https://github.com/RocketChat/Rocket.Chat/pull/25217))

- Purchase Type Filter for marketplace apps and Categories filter anchor refactoring ([#24454](https://github.com/RocketChat/Rocket.Chat/pull/24454))

  Implemented a filter by purchase type(free or paid) component for the apps screen of the marketplace. Besides that, new entries on the dictionary, fixed some parts of the App type (purchaseType was typed as unknown and price as string), and created some helpers to work alongside the filter. Will be refactoring the categories filter anchor and then will open this PR for reviews.

  Demo gif:
  ![purchaseTypeFIlter](https://user-images.githubusercontent.com/43561537/153101228-7b7ebdc3-2d34-420f-aa9d-f7cbc8d4b53f.gif)

  Refactored the categories filter anchor from a plain fuselage select to a select button with dynamic colors.
  Demo gif:
  ![New categories filter anchor(PR)](https://user-images.githubusercontent.com/43561537/153422427-28012b7d-e0ec-45f4-861d-c9368c57ad04.gif)

- Rename upgrade tab routes ([#25097](https://github.com/RocketChat/Rocket.Chat/pull/25097))

  Change 'upgrade tab' routes names from camelCase ('goFullyFeatured') to kebab-case ('go-fully-featured') due to URL naming consistency. Changed types, main function and test.

- Replace AutoComplete in UserAutoComplete & UserAutoCompleteMultiple components ([#24529](https://github.com/RocketChat/Rocket.Chat/pull/24529))

  This PR replaces a deprecated fuselage's component `AutoComplete` in favor of `Select` and `MultiSelect` which fixes some of UX/UI issues in selecting users

  ### before
  ![Screen Shot 2022-02-19 at 13 33 28](https://user-images.githubusercontent.com/27704687/154809737-8181a06c-4f20-48ea-90f7-01e828b9a452.png)

  ### after
  ![Screen Shot 2022-02-19 at 13 30 58](https://user-images.githubusercontent.com/27704687/154809653-a8ec9a80-c0dd-4a25-9c00-0f96147d79e9.png)

- Skip encryption for slash commands in E2E rooms ([#24475](https://github.com/RocketChat/Rocket.Chat/pull/24475))

  Currently Slash Commands don't work in an E2EE room, as we encrypt the message before slash command is detected by the server, So removed encryption for slash commands in e2e rooms.

- Team system messages feedback ([#24209](https://github.com/RocketChat/Rocket.Chat/pull/24209) by [@ostjen](https://github.com/ostjen))

  - Delete some keys that aren't being used (eg: User_left_female).

  - Add new Teams' system messages:
      - `added-user-to-team`: **added** @\user to this Team;
      - `removed-user-from-team`: **removed** @\user from this Team;
      - `user-converted-to-team`: **converted** #\room to a Team;
      - `user-converted-to-channel`: **converted** #\room to a Channel;
      - `user-removed-room-from-team`: **removed** @\user from this Team;
      - `user-deleted-room-from-team`: **deleted** #\room from this Team;
      - `user-added-room-to-team`: **deleted** #\room to this Team;

  - Add the corresponding options to hide each new system message and the missing `ujt` and `ult` hide options.

- Updated links in readme ([#24028](https://github.com/RocketChat/Rocket.Chat/pull/24028) by [@aswinidev](https://github.com/aswinidev))

### 🐛 Bug fixes


- "Match error" when converting a team to a channel ([#24629](https://github.com/RocketChat/Rocket.Chat/pull/24629))

  - Fix "Match error"  when trying to convert a channel to a team;

- **ENTERPRISE:** Auto reload feature of ddp-streamer micro service ([#24793](https://github.com/RocketChat/Rocket.Chat/pull/24793))

- **ENTERPRISE:** DDP streamer not sending data to all clients ([#24738](https://github.com/RocketChat/Rocket.Chat/pull/24738))

- **ENTERPRISE:** Notifications not being sent by ddp-streamer ([#24831](https://github.com/RocketChat/Rocket.Chat/pull/24831))

- **ENTERPRISE:** Presence micro service logic ([#24724](https://github.com/RocketChat/Rocket.Chat/pull/24724))

- 2FA via email when logging in using OAuth ([#24572](https://github.com/RocketChat/Rocket.Chat/pull/24572))

- Add ?close to OAuth callback url ([#24381](https://github.com/RocketChat/Rocket.Chat/pull/24381))

- Add katex render to new message react template ([#25239](https://github.com/RocketChat/Rocket.Chat/pull/25239))

- Add reaction not working in legacy messages ([#25222](https://github.com/RocketChat/Rocket.Chat/pull/25222))

- Added invalid password error message ([#24714](https://github.com/RocketChat/Rocket.Chat/pull/24714) by [@Himanshu664](https://github.com/Himanshu664))

- Adjust email label in Setup Wizard i18n files ([#25260](https://github.com/RocketChat/Rocket.Chat/pull/25260))

  - remove 'Company' label on onboarding email keys in certain languages

- AgentOverview analytics wrong departmentId parameter ([#25073](https://github.com/RocketChat/Rocket.Chat/pull/25073) by [@paulobernardoaf](https://github.com/paulobernardoaf))

  When filtering the analytics charts by department, data would not appear because the object:
  ```js
  {
  value: "department-id",
  label: "department-name"
  }
  ```
  was being used in the `departmentId` parameter.


  - Before:
  ![image](https://user-images.githubusercontent.com/30026625/161832057-d96ffd21-a7dd-421e-bfaa-3b9f4a9127b2.png)


  - After:
  ![image](https://user-images.githubusercontent.com/30026625/161831092-9ee77b51-b083-4f45-9c48-ab2e0511c4d6.png)

- API Error preventing adding an email to users without one (like bot/app users) ([#24709](https://github.com/RocketChat/Rocket.Chat/pull/24709))

- Apple OAuth ([#24879](https://github.com/RocketChat/Rocket.Chat/pull/24879))

- auto-join team channels not honoring user preferences ([#24779](https://github.com/RocketChat/Rocket.Chat/pull/24779) by [@ostjen](https://github.com/ostjen))

- Client disconnection on network loss ([#25170](https://github.com/RocketChat/Rocket.Chat/pull/25170) by [@amolghode1981](https://github.com/amolghode1981))

  Agent gets disconnected (or Unregistered) from asterisk in multiple ways. The goal is that agent should remain online
  unless agent explicitly logs off.
  Agent can stop receiving calls in multiple ways due to network loss. Network loss can happen in following ways.

  1. User tries to switch the network. User experiences a glitch of disconnectivity. This can be simulated by turning the network off
  in the network tab of chrome's dev tool. This can disconnect the UA if the disconnection happens just before the registration refresh.

  2. Second reason is when computer goes in sleep mode.

  3. Third reason is that when asterisk is crashed/in maintenance mode/explicitly stopped.

  Solution:
  The idea is to detect the network disconnection and start the start the attempts to reconnect.
  The detection of the disconnection does not happen in case#1. The SIPUA's UserAgent transport does not
  call onDisconnected when network loss of such kind happens. To tackle this problem, window's online and offline event handlers are
  used.

  The number of retries is configurable but ideally it is to be kept at -1. Whenever disconnection happens, it should keep on trying to
  reconnect with increasing backoff time. This behaviour is useful when the asterisk is stopped.

  When the server is disconnected, it should be indicated on the phone button.

- Close room when dismiss wrap up call modal ([#25056](https://github.com/RocketChat/Rocket.Chat/pull/25056))

- Custom sound error toast messages ([#24515](https://github.com/RocketChat/Rocket.Chat/pull/24515) by [@Himanshu664](https://github.com/Himanshu664))

- Database indexes not being created ([#25101](https://github.com/RocketChat/Rocket.Chat/pull/25101))

- Date Message Export Filter Fix ([#24542](https://github.com/RocketChat/Rocket.Chat/pull/24542) by [@eduardofcabrera](https://github.com/eduardofcabrera))

  Fix message export filter to get all messages between "from date" and "to date", including "to date".

- DDP Rate Limiter Translation key ([#24898](https://github.com/RocketChat/Rocket.Chat/pull/24898))

  Before:
  <img width="267" alt="image" src="https://user-images.githubusercontent.com/40830821/159324037-b17e2492-e007-49fd-bfd1-f1d009301c44.png">


  Now:
  <img width="611" alt="image" src="https://user-images.githubusercontent.com/40830821/159323594-10cf69a8-57dd-4e01-b4d3-31c92667a754.png">

- DDP streamer errors ([#24710](https://github.com/RocketChat/Rocket.Chat/pull/24710))

- Duplicated "jump to message" button on starred messages ([#24867](https://github.com/RocketChat/Rocket.Chat/pull/24867) by [@Himanshu664](https://github.com/Himanshu664))

- Dynamic load matrix is enabled and handle failure  ([#25495](https://github.com/RocketChat/Rocket.Chat/pull/25495))

- End call button disappearing when on-hold ([#24936](https://github.com/RocketChat/Rocket.Chat/pull/24936))

- External search providers not working ([#24860](https://github.com/RocketChat/Rocket.Chat/pull/24860) by [@tkurz](https://github.com/tkurz))

- Full error message is visible ([#24856](https://github.com/RocketChat/Rocket.Chat/pull/24856) by [@Himanshu664](https://github.com/Himanshu664))

- GDPR action to forget visitor data on request ([#24441](https://github.com/RocketChat/Rocket.Chat/pull/24441))

- German translation for Monitore ([#24785](https://github.com/RocketChat/Rocket.Chat/pull/24785) by [@JMoVS](https://github.com/JMoVS))

- Handle Other Formats inside Upload Avatar ([#24226](https://github.com/RocketChat/Rocket.Chat/pull/24226))

  After resolving issue #24213 :


  https://user-images.githubusercontent.com/53515714/150325012-91413025-786e-4ce0-ae75-629f6b05b024.mp4

- Ignore customClass on messages ([#24845](https://github.com/RocketChat/Rocket.Chat/pull/24845))

- Implement client errors on ddp-streamer ([#24310](https://github.com/RocketChat/Rocket.Chat/pull/24310))

- Inconsistent validation of user's access to rooms ([#24037](https://github.com/RocketChat/Rocket.Chat/pull/24037) by [@ostjen](https://github.com/ostjen))

- Incorrect websocket url in livechat widget ([#25261](https://github.com/RocketChat/Rocket.Chat/pull/25261))

- Initial User not added to default channel ([#25544](https://github.com/RocketChat/Rocket.Chat/pull/25544))

  If injecting initial user.  The user wasn’t added to the default General channel

- Issues on selecting users when importing CSV ([#24253](https://github.com/RocketChat/Rocket.Chat/pull/24253))

  * Fix users selecting by fixing their _id

  * Add condition to disable 'Start importing' button if `usersCount`, `channelsCount` and `messageCount` equals 0, or if messageCount is alone

  * Remove `disabled={usersCount === 0}` on user Tab

- LDAP avatars being rotated according to metadata even if the setting to rotate uploads is off ([#24320](https://github.com/RocketChat/Rocket.Chat/pull/24320))

  - Use the `FileUpload_RotateImages` setting (**Administration > File Upload > Rotate images on upload**) to control whether avatars should be rotated automatically based on their data (XEIF);

  - Display the avatar image preview (orientation) according to the `FileUpload_RotateImages` setting.

- LDAP sync removing users from channels when multiple groups are mapped to it ([#25434](https://github.com/RocketChat/Rocket.Chat/pull/25434))

- Message menu action not working on legacy messages. ([#25148](https://github.com/RocketChat/Rocket.Chat/pull/25148))

- Message preview not available for queued chats ([#25092](https://github.com/RocketChat/Rocket.Chat/pull/25092))

- Missing dependency on useEffect at CallProvider ([#24882](https://github.com/RocketChat/Rocket.Chat/pull/24882))

- Nextcloud OAuth for incomplete token URL ([#24476](https://github.com/RocketChat/Rocket.Chat/pull/24476))

- OAuth mismatch redirect_uri error ([#24450](https://github.com/RocketChat/Rocket.Chat/pull/24450))

- Oembed request not respecting payload limit ([#24418](https://github.com/RocketChat/Rocket.Chat/pull/24418))

- Omnichannel managers can't join chats in progress ([#24553](https://github.com/RocketChat/Rocket.Chat/pull/24553))

- One of the triggers was not working correctly ([#25409](https://github.com/RocketChat/Rocket.Chat/pull/25409))

- Outgoing webhook without scripts not saving messages ([#24401](https://github.com/RocketChat/Rocket.Chat/pull/24401))

- Prevent Apps Bridge to remove visitor status from room ([#24305](https://github.com/RocketChat/Rocket.Chat/pull/24305))

- Prevent call button toggle when user is on call ([#24758](https://github.com/RocketChat/Rocket.Chat/pull/24758))

- Prevent sequential messages edited icon to hide on hover ([#24984](https://github.com/RocketChat/Rocket.Chat/pull/24984))

  ### before
  <img width="297" alt="Screen Shot 2022-03-29 at 13 35 56" src="https://user-images.githubusercontent.com/27704687/160661700-c2aebe05-a1be-4235-9d20-bce0b6e5fdb5.png">

  ### after
  <img width="300" alt="Screen Shot 2022-03-29 at 11 48 05" src="https://user-images.githubusercontent.com/27704687/160639208-3883a7b0-718a-4e9d-87b1-db960fe9bfcd.png">

- Prune Message issue ([#24424](https://github.com/RocketChat/Rocket.Chat/pull/24424))

- Push privacy config to not show username not being respected ([#24606](https://github.com/RocketChat/Rocket.Chat/pull/24606))

- Read receipts show with color gray when not read yet ([#25244](https://github.com/RocketChat/Rocket.Chat/pull/25244))

- Read receipts showing before message read ([#25216](https://github.com/RocketChat/Rocket.Chat/pull/25216))

- Read receipts showing first messages of the room as read even if not read by everyone ([#24508](https://github.com/RocketChat/Rocket.Chat/pull/24508))

- Register with Secret URL ([#24921](https://github.com/RocketChat/Rocket.Chat/pull/24921))

- Replace encrypted text to Encrypted Message Placeholder ([#24166](https://github.com/RocketChat/Rocket.Chat/pull/24166))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/150807900-154a9cdb-ee13-4333-8628-f287ab914b40.png)

  ### after
  <img width="814" alt="Screenshot 2022-01-13 at 8 57 47 PM" src="https://user-images.githubusercontent.com/58601732/149359411-23e2430b-89e4-48b4-a3ad-65471d058551.png">

- Reply button behavior on broadcast channel ([#25175](https://github.com/RocketChat/Rocket.Chat/pull/25175))

  Hide reply button for the user that sent the message

- respect `Accounts_Registration_Users_Default_Roles` setting ([#24173](https://github.com/RocketChat/Rocket.Chat/pull/24173))

  - Fix `user` role being added as default regardless of the `Accounts_Registration_Users_Default_Roles` setting.

- Room archived/unarchived system messages aren't sent when editing room settings ([#24897](https://github.com/RocketChat/Rocket.Chat/pull/24897))

  - Send the "Room archived" and "Room unarchived" system messages when editing room settings (and not only when rooms are archived/unarchived with the slash-command);

  - Fix the "Hide System Messages" option for the "Room archived" and "Room unarchived" system messages;

- Room context tabs not working in Omnichannel current chats page ([#24559](https://github.com/RocketChat/Rocket.Chat/pull/24559))

- room creation fails if app framework is disabled ([#25200](https://github.com/RocketChat/Rocket.Chat/pull/25200))

- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

- Several issues related to custom roles ([#24052](https://github.com/RocketChat/Rocket.Chat/pull/24052))

  - Throw an error when trying to delete a role (User or Subscription role) that are still being used;

  - Fix "Invalid Role" error for custom roles in Role Editing sidebar;

  - Fix "Users in Role" screen for custom roles.

- Showing Blank Message Inside Report ([#25007](https://github.com/RocketChat/Rocket.Chat/pull/25007))

  https://user-images.githubusercontent.com/53515714/161038085-4a86c7ae-6751-4996-9767-b1c9e0331a6c.mp4

- Skip admin info in setup wizard for servers with admin registered ([#24485](https://github.com/RocketChat/Rocket.Chat/pull/24485))

- Skip cloud steps for registered servers on setup wizard ([#24407](https://github.com/RocketChat/Rocket.Chat/pull/24407))

- Slash commands previews not working ([#24387](https://github.com/RocketChat/Rocket.Chat/pull/24387) by [@ostjen](https://github.com/ostjen))

- Spotlight results showing usernames instead of real names ([#25471](https://github.com/RocketChat/Rocket.Chat/pull/25471))

- Startup errors creating indexes ([#24409](https://github.com/RocketChat/Rocket.Chat/pull/24409))

  Fix `bio` and `prid` startup index creation errors.

- Toolbox hiding under contextual bar ([#25237](https://github.com/RocketChat/Rocket.Chat/pull/25237))

- typo on register server tooltip of setup wizard ([#24466](https://github.com/RocketChat/Rocket.Chat/pull/24466))

- UI/UX issues on Live Chat widget ([#25407](https://github.com/RocketChat/Rocket.Chat/pull/25407))

- Use correct room property for call ended at ([#24932](https://github.com/RocketChat/Rocket.Chat/pull/24932))

- User abandonment setting was not working doe to failing event hook ([#25520](https://github.com/RocketChat/Rocket.Chat/pull/25520))

  A setting watcher and the query for grabbing abandoned chats were broken, now they're not.

- UserCard sanitization ([#25089](https://github.com/RocketChat/Rocket.Chat/pull/25089))

  - Rewrites the component to TS

  - Fixes some visual issues

  ### before
  ![Screen Shot 2022-04-07 at 00 23 11](https://user-images.githubusercontent.com/27704687/162113925-5c9484d1-23e9-4623-8b86-3fbc71b461a1.png)

  ### after
  ![Screen Shot 2022-04-07 at 00 07 13](https://user-images.githubusercontent.com/27704687/162112353-afd6aac6-b27c-4470-a642-631b8080d59e.png)

- Video and Audio not skipping forward ([#19866](https://github.com/RocketChat/Rocket.Chat/pull/19866))

- VoIP disabled/enabled  sequence puts voip agent in error state ([#25230](https://github.com/RocketChat/Rocket.Chat/pull/25230) by [@amolghode1981](https://github.com/amolghode1981))

  Initially it was thought that the issue occurs because of the race condition while changing the client settings vs those settings reflected on server side. So a natural solution to solve this is to wait for setting change event 'private-settings-changed'. Then if 'VoIP_Enabled' is updated and it is true, set voipEnabled  to true in useVoipClient.ts (on client side)

  It was realised that the race does not happen because of the database or server noticing the changes late. But because of the time taken to establish the AMI connection with Asterisk.

  Solution:


  1. Change apps/meteor/app/voip/server/startup.ts. When VoIP_Enabled is changed, await for Voip.init() to complete and then broadcast connector.statuschanged  with changed value.

  2. From apps/meteor/server/modules/listeners/listeners.module.ts use notifyLoggedInThisInstance to notify all logged in users on current instance.

  3. in apps/meteor/client/providers/CallProvider/hooks/useVoipClient.ts add the event handler that receives this event. Change voipEnabled from constant to state. Change this state based on the 'value' that is received by the handler.

- Wrong business hour behavior ([#24896](https://github.com/RocketChat/Rocket.Chat/pull/24896))

<details>
<summary>🔍 Minor changes</summary>


- Bump @rocket.chat/emitter from 0.31.4 to 0.31.9 in /ee/server/services ([#25021](https://github.com/RocketChat/Rocket.Chat/pull/25021) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/message-parser from 0.31.4 to 0.31.9 in /ee/server/services ([#25019](https://github.com/RocketChat/Rocket.Chat/pull/25019) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/string-helpers from 0.31.4 to 0.31.9 in /ee/server/services ([#25018](https://github.com/RocketChat/Rocket.Chat/pull/25018) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @rocket.chat/ui-kit from 0.31.4 to 0.31.9 in /ee/server/services ([#25020](https://github.com/RocketChat/Rocket.Chat/pull/25020) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/clipboard from 2.0.1 to 2.0.7 ([#24832](https://github.com/RocketChat/Rocket.Chat/pull/24832) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/mailparser from 3.0.2 to 3.4.0 ([#24833](https://github.com/RocketChat/Rocket.Chat/pull/24833) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/nodemailer from 6.4.2 to 6.4.4 ([#24822](https://github.com/RocketChat/Rocket.Chat/pull/24822) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 8.2.2 to 8.2.3 in /ee/server/services ([#24556](https://github.com/RocketChat/Rocket.Chat/pull/24556) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 8.2.3 to 8.5.2 in /ee/server/services ([#24666](https://github.com/RocketChat/Rocket.Chat/pull/24666) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 8.5.2 to 8.5.3 in /ee/server/services ([#24820](https://github.com/RocketChat/Rocket.Chat/pull/24820) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump actions/checkout from 2 to 3 ([#24668](https://github.com/RocketChat/Rocket.Chat/pull/24668) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump actions/setup-node from 2 to 3 ([#24642](https://github.com/RocketChat/Rocket.Chat/pull/24642) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump adm-zip from 0.4.14 to 0.5.9 ([#24538](https://github.com/RocketChat/Rocket.Chat/pull/24538) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.0 to 1.19.1 in /ee/server/services ([#23963](https://github.com/RocketChat/Rocket.Chat/pull/23963) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.0 to 1.19.2 ([#24821](https://github.com/RocketChat/Rocket.Chat/pull/24821) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.1 to 1.19.2 in /ee/server/services ([#24517](https://github.com/RocketChat/Rocket.Chat/pull/24517) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump body-parser from 1.19.2 to 1.20.0 in /ee/server/services ([#25042](https://github.com/RocketChat/Rocket.Chat/pull/25042) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump cookie from 0.4.1 to 0.4.2 in /ee/server/services ([#24472](https://github.com/RocketChat/Rocket.Chat/pull/24472) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump date-fns from 2.24.0 to 2.28.0 ([#24058](https://github.com/RocketChat/Rocket.Chat/pull/24058) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ejson from 2.2.1 to 2.2.2 ([#25057](https://github.com/RocketChat/Rocket.Chat/pull/25057) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump eslint-plugin-anti-trojan-source from 1.0.6 to 1.1.0 ([#25076](https://github.com/RocketChat/Rocket.Chat/pull/25076) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump express from 4.17.1 to 4.17.2 in /ee/server/services ([#24469](https://github.com/RocketChat/Rocket.Chat/pull/24469) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump express from 4.17.2 to 4.17.3 in /ee/server/services ([#24522](https://github.com/RocketChat/Rocket.Chat/pull/24522) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump follow-redirects from 1.14.7 to 1.14.8 in /ee/server/services ([#24491](https://github.com/RocketChat/Rocket.Chat/pull/24491) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump is-svg from 4.3.1 to 4.3.2 ([#24801](https://github.com/RocketChat/Rocket.Chat/pull/24801) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump jaeger-client from 3.18.1 to 3.19.0 in /ee/server/services ([#23961](https://github.com/RocketChat/Rocket.Chat/pull/23961) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump jschardet from 1.6.0 to 3.0.0 ([#23121](https://github.com/RocketChat/Rocket.Chat/pull/23121) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump minimist from 1.2.5 to 1.2.6 in /ee/server/services ([#24991](https://github.com/RocketChat/Rocket.Chat/pull/24991) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino and pino-pretty ([#25052](https://github.com/RocketChat/Rocket.Chat/pull/25052))

- Bump pino from 7.8.0 to 7.8.1 in /ee/server/services ([#24783](https://github.com/RocketChat/Rocket.Chat/pull/24783) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino from 7.8.1 to 7.9.1 in /ee/server/services ([#24869](https://github.com/RocketChat/Rocket.Chat/pull/24869) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.1 to 7.5.2 in /ee/server/services ([#24689](https://github.com/RocketChat/Rocket.Chat/pull/24689) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.2 to 7.5.3 in /ee/server/services ([#24698](https://github.com/RocketChat/Rocket.Chat/pull/24698) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pino-pretty from 7.5.3 to 7.5.4 in /ee/server/services ([#24870](https://github.com/RocketChat/Rocket.Chat/pull/24870) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pm2 from 5.1.2 to 5.2.0 in /ee/server/services ([#24537](https://github.com/RocketChat/Rocket.Chat/pull/24537) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump prometheus-gc-stats from 0.6.2 to 0.6.3 ([#24803](https://github.com/RocketChat/Rocket.Chat/pull/24803) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump simple-get from 4.0.0 to 4.0.1 ([#24341](https://github.com/RocketChat/Rocket.Chat/pull/24341) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump sodium-native from 3.2.1 to 3.3.0 in /ee/server/services ([#23512](https://github.com/RocketChat/Rocket.Chat/pull/23512) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump template-file from 6.0.0 to 6.0.1 ([#25002](https://github.com/RocketChat/Rocket.Chat/pull/25002) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ts-node from 10.5.0 to 10.6.0 in /ee/server/services ([#24667](https://github.com/RocketChat/Rocket.Chat/pull/24667) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ts-node from 10.6.0 to 10.7.0 in /ee/server/services ([#24716](https://github.com/RocketChat/Rocket.Chat/pull/24716) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump underscore.string from 3.3.5 to 3.3.6 in /ee/server/services ([#24498](https://github.com/RocketChat/Rocket.Chat/pull/24498) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump url-parse from 1.5.3 to 1.5.7 ([#24528](https://github.com/RocketChat/Rocket.Chat/pull/24528) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump url-parse from 1.5.7 to 1.5.10 ([#24640](https://github.com/RocketChat/Rocket.Chat/pull/24640) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump vm2 from 3.9.5 to 3.9.7 in /ee/server/services ([#24509](https://github.com/RocketChat/Rocket.Chat/pull/24509) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: `twoFactorRequired` signature ([#24518](https://github.com/RocketChat/Rocket.Chat/pull/24518))

  Improved type checking for decorator `twoFactorRequired`.

- Chore: Add description to global OTR setting ([#24333](https://github.com/RocketChat/Rocket.Chat/pull/24333) by [@pedrogssouza](https://github.com/pedrogssouza))

- Chore: Add E2E tests for livechat/room.close ([#24729](https://github.com/RocketChat/Rocket.Chat/pull/24729) by [@Muramatsu2602](https://github.com/Muramatsu2602))

  * Create a new test suite file under tests/end-to-end/api/livechat
    * Create tests for the following endpoint:
	  + ivechat/room.close

- Chore: Add E2E tests for livechat/visitor ([#24764](https://github.com/RocketChat/Rocket.Chat/pull/24764) by [@Muramatsu2602](https://github.com/Muramatsu2602))

  - Create a new test suite file under tests/end-to-end/api/livechat

  - Create tests for the following endpoints:
   + livechat/visitor (create visitor, update visitor, add custom fields to visitors)

- Chore: Add error boundary to message component ([#25223](https://github.com/RocketChat/Rocket.Chat/pull/25223))

  Not crash the whole application if something goes wrong in the MessageList component.

  ![image](https://user-images.githubusercontent.com/40830821/162269915-931c5c3c-c979-4234-b74c-371f67467ce0.png)

- Chore: Add Livechat repo into Monorepo packages ([#25312](https://github.com/RocketChat/Rocket.Chat/pull/25312))

- Chore: Add options to debug stdout and rate limiter ([#25336](https://github.com/RocketChat/Rocket.Chat/pull/25336))

- Chore: Add root package.json to houston files ([#25286](https://github.com/RocketChat/Rocket.Chat/pull/25286))

  See title

- Chore: add some missing REST definitions ([#24925](https://github.com/RocketChat/Rocket.Chat/pull/24925) by [@gerzonc](https://github.com/gerzonc))

  On the [mobile client](https://github.com/RocketChat/Rocket.Chat.ReactNative), we made an effort to collect more `REST API` definitions that are missing on the server side during our migration to TypeScript. Since we're both migrating to TypeScript, we thought it would be a good idea to share those so you guys can benefit from our initiative.

- Chore: Add yarn plugin to check node and yarn version ([#25224](https://github.com/RocketChat/Rocket.Chat/pull/25224))

- Chore: added Server Instances endpoint types ([#24507](https://github.com/RocketChat/Rocket.Chat/pull/24507))

  Created typing for endpoint definitions on `instances.ts`.

- Chore: added settings endpoint types ([#24506](https://github.com/RocketChat/Rocket.Chat/pull/24506))

  Created typing for endpoint definitions on `settings.ts`.

- Chore: APIClass types ([#24747](https://github.com/RocketChat/Rocket.Chat/pull/24747))

  This pull request creates a new `restivus` module (.d.ts) for the `api.js` file.

- Chore: Bump fuselage ([#25371](https://github.com/RocketChat/Rocket.Chat/pull/25371))

- Chore: Bump Fuselage packages ([#25259](https://github.com/RocketChat/Rocket.Chat/pull/25259))

- Chore: Bump Fuselage packages ([#25015](https://github.com/RocketChat/Rocket.Chat/pull/25015))

  It uses the last stable version of Fuselage packages.

- Chore: Bump Fuselage packages ([#24573](https://github.com/RocketChat/Rocket.Chat/pull/24573))

  It uses the last stable version of Fuselage packages.

- Chore: bump fuselage version ([#24453](https://github.com/RocketChat/Rocket.Chat/pull/24453))

- Chore: Cancel running jobs if PR is updated ([#24708](https://github.com/RocketChat/Rocket.Chat/pull/24708))

- Chore: Convert admin custom sound to tsx ([#25128](https://github.com/RocketChat/Rocket.Chat/pull/25128))

- Chore: Convert JS files to Typescript ([#24410](https://github.com/RocketChat/Rocket.Chat/pull/24410))

  This pull request converts 26 more files from Javascript to Typescript, to check variable types and increase validation on the code.

- Chore: Convert LivechatAgentActivity to raw model and TS ([#25123](https://github.com/RocketChat/Rocket.Chat/pull/25123))

- Chore: Convert Mailer to TS ([#25121](https://github.com/RocketChat/Rocket.Chat/pull/25121))

- Chore: Convert NotificationStatus to TS ([#25125](https://github.com/RocketChat/Rocket.Chat/pull/25125))

- Chore: Convert server functions from javascript to typescript ([#24384](https://github.com/RocketChat/Rocket.Chat/pull/24384))

  This pull request will be used to rewrite some functions on the Chat Engine to Typescript, in order to increase security and specify variable types on the code.

- Chore: Convert to typescript the me slashCommands files ([#24321](https://github.com/RocketChat/Rocket.Chat/pull/24321) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the me slashCommands files

- Chore: Convert to typescript the mute and unmute slash commands files ([#24325](https://github.com/RocketChat/Rocket.Chat/pull/24325) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the mute and unmute slash commands files

- Chore: Convert to typescript the slash commands create files ([#24306](https://github.com/RocketChat/Rocket.Chat/pull/24306) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert Slash Commands create files to typescript.

- Chore: Convert to typescript the slash commands invite files ([#24311](https://github.com/RocketChat/Rocket.Chat/pull/24311) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the slash commands invite files

- Chore: Convert to typescript the unarchive slash commands files ([#24331](https://github.com/RocketChat/Rocket.Chat/pull/24331) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert to typescript the unarchive slash commands files

- Chore: converted more hooks to typescript ([#24628](https://github.com/RocketChat/Rocket.Chat/pull/24628))

  Converted some functions on `client/hooks/` from JavaScript to Typescript.

- Chore: Create README.md for Rest Typings ([#25335](https://github.com/RocketChat/Rocket.Chat/pull/25335))

- Chore: Delete unused file (NewAdminInfoPage.js) ([#24196](https://github.com/RocketChat/Rocket.Chat/pull/24196))

  Just removing a duplicated/unused file.

- Chore: ensure scripts use cross-env and ignore some dirs (ROC-54) ([#25218](https://github.com/RocketChat/Rocket.Chat/pull/25218) by [@souzaramon](https://github.com/souzaramon))

  - data and test-failure should be ignored

  - ensure scripts use cross-env

- Chore: Fix Cypress tests ([#24544](https://github.com/RocketChat/Rocket.Chat/pull/24544))

- Chore: Fix grammatical errors in Code of Conduct ([#24759](https://github.com/RocketChat/Rocket.Chat/pull/24759) by [@aadishJ01](https://github.com/aadishJ01))

- Chore: fix grammatical errors in Features ([#24771](https://github.com/RocketChat/Rocket.Chat/pull/24771) by [@aadishJ01](https://github.com/aadishJ01))

- Chore: Fix return type warnings ([#25275](https://github.com/RocketChat/Rocket.Chat/pull/25275))

- Chore: Get Settings Statistics ([#24397](https://github.com/RocketChat/Rocket.Chat/pull/24397))

- Chore: Improve logger to allow log of `unknown` values ([#24726](https://github.com/RocketChat/Rocket.Chat/pull/24726))

- Chore: Improve PR title validation regex ([#24467](https://github.com/RocketChat/Rocket.Chat/pull/24467))

- Chore: Improvements on role syncing (ldap, oauth and saml) ([#23824](https://github.com/RocketChat/Rocket.Chat/pull/23824))

- Chore: Js to ts slash commands archive ([#24304](https://github.com/RocketChat/Rocket.Chat/pull/24304) by [@eduardofcabrera](https://github.com/eduardofcabrera))

  Convert Slash Commands archive files to typescript

- Chore: Micro services fixes and cleanup ([#24753](https://github.com/RocketChat/Rocket.Chat/pull/24753))

- Chore: Migrate oauth2server to typescript ([#25126](https://github.com/RocketChat/Rocket.Chat/pull/25126))

- Chore: Minor dependency updates ([#25269](https://github.com/RocketChat/Rocket.Chat/pull/25269))

- Chore: Missing keys in APIsDisplay ([#24464](https://github.com/RocketChat/Rocket.Chat/pull/24464))

- Chore: Monorepo  ([#25074](https://github.com/RocketChat/Rocket.Chat/pull/25074))

- Chore: move definitions to packages ([#25085](https://github.com/RocketChat/Rocket.Chat/pull/25085))

- Chore: organize test files and fix code coverage ([#24900](https://github.com/RocketChat/Rocket.Chat/pull/24900))

- Chore: Remove Alpine image deps after using them ([#25053](https://github.com/RocketChat/Rocket.Chat/pull/25053))

- Chore: Remove duplicated useUserRoom ([#25180](https://github.com/RocketChat/Rocket.Chat/pull/25180))

- Chore: Remove old files from removed Omnichannel feature ([#25129](https://github.com/RocketChat/Rocket.Chat/pull/25129))

- Chore: Remove old scripts ([#24911](https://github.com/RocketChat/Rocket.Chat/pull/24911))

- Chore: Remove package-lock.json from houston files ([#25280](https://github.com/RocketChat/Rocket.Chat/pull/25280))

  Houston config in the `package.json` file still mentioned `package-lock.json`, but it doesn't exist anymore

- Chore: Remove storybook build job from CI ([#24530](https://github.com/RocketChat/Rocket.Chat/pull/24530))

- Chore: Remove unused Drone CI files ([#25124](https://github.com/RocketChat/Rocket.Chat/pull/25124))

- Chore: roomTypes: Stop mixing client and server code together ([#24536](https://github.com/RocketChat/Rocket.Chat/pull/24536))

- Chore: Run tests using microservices deployment on CI ([#24513](https://github.com/RocketChat/Rocket.Chat/pull/24513))

- Chore: Set Docker image tag to latest only when really latest ([#24366](https://github.com/RocketChat/Rocket.Chat/pull/24366))

- Chore: Skip local services changes when shutting down duplicated services ([#24810](https://github.com/RocketChat/Rocket.Chat/pull/24810))

- Chore: Storybook mocking and examples improved ([#24969](https://github.com/RocketChat/Rocket.Chat/pull/24969))

  - Stories from `ee/` included;

  - Differentiate root story kinds;

  - Mocking of `ServerContext` via Storybook parameters.

- Chore: Sync with master ([#25284](https://github.com/RocketChat/Rocket.Chat/pull/25284))

- Chore: Template to generate packages ([#25174](https://github.com/RocketChat/Rocket.Chat/pull/25174))

  ```
  npx hygen package new test
  ```

- Chore: Tests with Playwright (task: All works) ([#25122](https://github.com/RocketChat/Rocket.Chat/pull/25122) by [@weslley543](https://github.com/weslley543))

- Chore: Tests with Playwright (task: ROC-28, 09-channels) ([#25196](https://github.com/RocketChat/Rocket.Chat/pull/25196))

- Chore: TS conversion folder client ([#25031](https://github.com/RocketChat/Rocket.Chat/pull/25031))

- Chore: TS migration SortList ([#25167](https://github.com/RocketChat/Rocket.Chat/pull/25167))

- Chore: Unify ILivechatAgent with ILivechatAgentRecord ([#24406](https://github.com/RocketChat/Rocket.Chat/pull/24406))

- Chore: Update Apps-Engine ([#24651](https://github.com/RocketChat/Rocket.Chat/pull/24651))

- Chore: Update Apps-Engine ([#24568](https://github.com/RocketChat/Rocket.Chat/pull/24568))

- Chore: Update fuselage deps to match monolith versions ([#24501](https://github.com/RocketChat/Rocket.Chat/pull/24501))

- Chore: Update Livechat to the last version ([#25257](https://github.com/RocketChat/Rocket.Chat/pull/25257))

- Chore: Update Livechat version ([#25130](https://github.com/RocketChat/Rocket.Chat/pull/25130))

- Chore: Update Meteor to 2.5.6 ([#24461](https://github.com/RocketChat/Rocket.Chat/pull/24461))

- Chore: update OTR icon ([#24521](https://github.com/RocketChat/Rocket.Chat/pull/24521) by [@kibonusp](https://github.com/kibonusp))

  I changed the shredder icon in OTR contextual bar to the stopwatch icon, recently added to the fuselage.

- Chore: Update ws package ([#24477](https://github.com/RocketChat/Rocket.Chat/pull/24477))

- Chore(deps-dev): Bump @types/mock-require from 2.0.0 to 2.0.1 ([#24574](https://github.com/RocketChat/Rocket.Chat/pull/24574) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore(deps-dev): Bump ts-node from 10.0.0 to 10.5.0 in /ee/server/services ([#24435](https://github.com/RocketChat/Rocket.Chat/pull/24435) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore(deps): Bump node-fetch from 2.6.1 to 2.6.7 in /ee/server/services ([#24299](https://github.com/RocketChat/Rocket.Chat/pull/24299) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- i18n: Language update from LingoHub 🤖 on 2022-01-31Z ([#24357](https://github.com/RocketChat/Rocket.Chat/pull/24357))

- i18n: Language update from LingoHub 🤖 on 2022-02-07Z ([#24429](https://github.com/RocketChat/Rocket.Chat/pull/24429))

- i18n: Language update from LingoHub 🤖 on 2022-02-14Z ([#24493](https://github.com/RocketChat/Rocket.Chat/pull/24493))

- i18n: Language update from LingoHub 🤖 on 2022-02-21Z ([#24558](https://github.com/RocketChat/Rocket.Chat/pull/24558))

- i18n: Language update from LingoHub 🤖 on 2022-02-28Z ([#24644](https://github.com/RocketChat/Rocket.Chat/pull/24644))

- i18n: Language update from LingoHub 🤖 on 2022-03-07Z ([#24717](https://github.com/RocketChat/Rocket.Chat/pull/24717))

- i18n: Language update from LingoHub 🤖 on 2022-03-14Z ([#24823](https://github.com/RocketChat/Rocket.Chat/pull/24823))

- i18n: Language update from LingoHub 🤖 on 2022-03-21Z ([#24895](https://github.com/RocketChat/Rocket.Chat/pull/24895))

- i18n: Language update from LingoHub 🤖 on 2022-03-28Z ([#24971](https://github.com/RocketChat/Rocket.Chat/pull/24971))

- i18n: Language update from LingoHub 🤖 on 2022-04-04Z ([#25043](https://github.com/RocketChat/Rocket.Chat/pull/25043))

- Merge master into develop & Set version to 4.5.0-develop ([#24363](https://github.com/RocketChat/Rocket.Chat/pull/24363))

- Merge master into develop & Set version to 4.6.0-develop ([#24653](https://github.com/RocketChat/Rocket.Chat/pull/24653))

- Merge master into develop & Set version to 4.7.0-develop ([#25028](https://github.com/RocketChat/Rocket.Chat/pull/25028))

- Regression: Add `isPending` status to message ([#25299](https://github.com/RocketChat/Rocket.Chat/pull/25299))

- Regression: Add createdOTR index ([#25017](https://github.com/RocketChat/Rocket.Chat/pull/25017))

- Regression: Add eslint package to micro services Dockerfile ([#25311](https://github.com/RocketChat/Rocket.Chat/pull/25311))

- Regression: Add select message to system message and thread preview and allow select on legacy template ([#25251](https://github.com/RocketChat/Rocket.Chat/pull/25251))

- Regression: Add support to namespace within micro services ([#24581](https://github.com/RocketChat/Rocket.Chat/pull/24581))

- Regression: Admin Sidebar colors inverted. ([#24609](https://github.com/RocketChat/Rocket.Chat/pull/24609))

- Regression: Avatar not loading on first direct message ([#25211](https://github.com/RocketChat/Rocket.Chat/pull/25211))

  fix avatar not loading on a first direct message

- Regression: Better MongoDB connection management for micro services ([#25323](https://github.com/RocketChat/Rocket.Chat/pull/25323))

- Regression: bump onboarding-ui version ([#25320](https://github.com/RocketChat/Rocket.Chat/pull/25320))

  - Bump to 'next' the onboarding-ui package from fuselage.

  - Update from 'companyEmail' to 'email' adminData usage types

- Regression: Bunch of settings fixes for VoIP ([#24594](https://github.com/RocketChat/Rocket.Chat/pull/24594))

- Regression: Call doesn't stop ringing after agent unregistration ([#24908](https://github.com/RocketChat/Rocket.Chat/pull/24908))

- Regression: Change preference to be default legacy messages ([#25255](https://github.com/RocketChat/Rocket.Chat/pull/25255))

- Regression: CI playwright ([#25168](https://github.com/RocketChat/Rocket.Chat/pull/25168))

- Regression: Custom roles displaying ID instead of name on some admin screens ([#24999](https://github.com/RocketChat/Rocket.Chat/pull/24999))

  ![image](https://user-images.githubusercontent.com/55164754/160981416-555bcaa1-c075-4260-937c-64523472da43.png)
  ![image](https://user-images.githubusercontent.com/55164754/160981452-6eae4e74-8425-4073-8256-472aba72b9db.png)

- Regression: Do not show toast on incoming voip calls ([#24619](https://github.com/RocketChat/Rocket.Chat/pull/24619))

- Regression: Encode registration info as JWT when signing key is provided ([#24626](https://github.com/RocketChat/Rocket.Chat/pull/24626))

- Regression: Error is raised when there's no Asterisk queue available yet ([#24980](https://github.com/RocketChat/Rocket.Chat/pull/24980) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Error setting user avatars and mentioning rooms on Slack Import ([#24585](https://github.com/RocketChat/Rocket.Chat/pull/24585))

  - Fix `Mentioned room not found` error when importing rooms from Slack;

  - Fix `Forbidden` error when setting avatars for users imported from Slack (on user import/creation);

  - Fix incorrect message count on imported rooms;

  - Fix missing username on messages imported from Slack;

- Regression: Error when trying to load name of dm rooms for avatars and notifications ([#24583](https://github.com/RocketChat/Rocket.Chat/pull/24583))

- Regression: eslint not running on packages ([#25305](https://github.com/RocketChat/Rocket.Chat/pull/25305))

- Regression: Extension List panel UI not aligned with designs ([#24645](https://github.com/RocketChat/Rocket.Chat/pull/24645))

- Regression: Fix account service login expiration ([#24920](https://github.com/RocketChat/Rocket.Chat/pull/24920))

- Regression: Fix CI monorepo build ([#25107](https://github.com/RocketChat/Rocket.Chat/pull/25107))

- Regression: Fix clicking on visitor's chat in the sidebar does not display the chat window ([#25380](https://github.com/RocketChat/Rocket.Chat/pull/25380))

  Fix: livechat room not opening.

- Regression: Fix double value on holdTime and empty msg on last message ([#24630](https://github.com/RocketChat/Rocket.Chat/pull/24630))

- Regression: Fix English i18n react text ([#25368](https://github.com/RocketChat/Rocket.Chat/pull/25368))

  Incorrect text in reaction tooltip has been fixed

- Regression: Fix federation Matrix bridge startup ([#25273](https://github.com/RocketChat/Rocket.Chat/pull/25273))

- Regression: Fix in-correct room status shown to agents ([#24592](https://github.com/RocketChat/Rocket.Chat/pull/24592))

- Regression: Fix incoming voip call ringtone is not ringing ([#24616](https://github.com/RocketChat/Rocket.Chat/pull/24616))

- Regression: Fix micro services Docker build ([#25193](https://github.com/RocketChat/Rocket.Chat/pull/25193))

- Regression: Fix multi line is not showing an empty line between lines ([#25317](https://github.com/RocketChat/Rocket.Chat/pull/25317))

- Regression: Fix reply button not working when hideFlexTab is enabled ([#25306](https://github.com/RocketChat/Rocket.Chat/pull/25306))

- Regression: Fix room not getting created due to null visitor status ([#24562](https://github.com/RocketChat/Rocket.Chat/pull/24562))

- Regression: Fix services Docker build on CI ([#25181](https://github.com/RocketChat/Rocket.Chat/pull/25181))

- Regression: Fix size of custom emoji and render emoji on thread message preview ([#25314](https://github.com/RocketChat/Rocket.Chat/pull/25314))

- Regression: Fix the alpine image and dev UX installing matrix-rust-sdk-bindings ([#25319](https://github.com/RocketChat/Rocket.Chat/pull/25319))

  The package only included a few pre-built which caused all macs to have to compile every time they installed and also caused our alpine not to work.

  This temporarily switches to a fork of the matrix-appservice-bridge package.

  Made changes to one of its child dependencies `matrix-rust-sdk-bindings` that adds pre-built binaries for mac and musl (for alpine).

- Regression: Fix time fields and wrap up in Voip Room Contexual bar ([#24625](https://github.com/RocketChat/Rocket.Chat/pull/24625))

- Regression: Fix time format on Voip system messages ([#24603](https://github.com/RocketChat/Rocket.Chat/pull/24603))

- Regression: Fix translation for call started message ([#24615](https://github.com/RocketChat/Rocket.Chat/pull/24615))

- Regression: Fix unexpected errors breaking ddp-streamer ([#24948](https://github.com/RocketChat/Rocket.Chat/pull/24948))

- Regression: Fix wrong tab name for VoIP settings ([#24647](https://github.com/RocketChat/Rocket.Chat/pull/24647))

- Regression: Fixes in Voice Contextual Bar and Directory ([#24596](https://github.com/RocketChat/Rocket.Chat/pull/24596))

- Regression: If Asterisk suddenly goes down, server has no way to know. Causes server to get stuck. Needs restart ([#24624](https://github.com/RocketChat/Rocket.Chat/pull/24624) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Improve Sidenav open/close handling and fixed codeql configs and E2E tests ([#24756](https://github.com/RocketChat/Rocket.Chat/pull/24756))

- Regression: Mark all rooms as read modal closing instantly. ([#24610](https://github.com/RocketChat/Rocket.Chat/pull/24610))

- Regression: Messages in new message template Crashing. ([#25327](https://github.com/RocketChat/Rocket.Chat/pull/25327))

- Regression: No audio when call comes from Skype/IP phone ([#24602](https://github.com/RocketChat/Rocket.Chat/pull/24602) by [@amolghode1981](https://github.com/amolghode1981))

  The audio was not rendered because of re-rendering of react element based on
  queueCounter and roomInfo. queueCounter and roomInfo cause the dom to re-render when call gets accepted
  because after accepting call, queueCounter changes or a room gets created.
  The audio element gets recreated. But VoIP user probably holds the old one.
  The behaviour is not predictable when such case happens. If everything gets cleanly setup,
  even if the audio element goes headless, it still continues to play the remote audio.
  But in other cases, it is unreferenced the one on dom has its srcObject as null.
  This causes no audio.

  This fix provides a way to re-initialise the rendering elements in VoIP user
  and calls this function on useEffect() if the re-render has happen.

- Regression: Prevent button from losing state when rerendering ([#24648](https://github.com/RocketChat/Rocket.Chat/pull/24648))

- Regression: Prevent connect to asterisk when VoIP is disabled ([#24601](https://github.com/RocketChat/Rocket.Chat/pull/24601))

- Regression: Queue counter aggregator for incoming/hanged calls ([#24635](https://github.com/RocketChat/Rocket.Chat/pull/24635) by [@amolghode1981](https://github.com/amolghode1981))

- Regression: Refresh server connection when MI server settings change ([#24649](https://github.com/RocketChat/Rocket.Chat/pull/24649))

- Regression: Register services right away ([#24800](https://github.com/RocketChat/Rocket.Chat/pull/24800))

- Regression: Revert Bugsnag version ([#25313](https://github.com/RocketChat/Rocket.Chat/pull/25313))

- Regression: Rocket.Chat Webapp not loading. ([#25349](https://github.com/RocketChat/Rocket.Chat/pull/25349))

- Regression: Role Sync not always working ([#24850](https://github.com/RocketChat/Rocket.Chat/pull/24850))

- Regression: Server crashing if Voip credentials are invalid ([#24646](https://github.com/RocketChat/Rocket.Chat/pull/24646))

- Regression: Show username and real name on the message system ([#25254](https://github.com/RocketChat/Rocket.Chat/pull/25254))

- Regression: Shows error if micro service cannot connect to Mongo ([#25301](https://github.com/RocketChat/Rocket.Chat/pull/25301))

- Regression: Use exact Node version on micro services Docker images ([#25287](https://github.com/RocketChat/Rocket.Chat/pull/25287))

- Regression: Validate empty fields for Message template ([#25250](https://github.com/RocketChat/Rocket.Chat/pull/25250))

- Regression: VoIP service button displayed when VoIP is disabled ([#24598](https://github.com/RocketChat/Rocket.Chat/pull/24598))

- Regression: yarn dev triggers build dependencies ([#25208](https://github.com/RocketChat/Rocket.Chat/pull/25208))

- Release 4.5.0 ([#24652](https://github.com/RocketChat/Rocket.Chat/pull/24652) by [@LucasFASouza](https://github.com/LucasFASouza) & [@aswinidev](https://github.com/aswinidev) & [@dependabot[bot]](https://github.com/dependabot[bot]) & [@lingohub[bot]](https://github.com/lingohub[bot]) & [@ostjen](https://github.com/ostjen))

- Release 4.5.1 ([#24782](https://github.com/RocketChat/Rocket.Chat/pull/24782) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari) & [@amolghode1981](https://github.com/amolghode1981) & [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Release 4.5.2 ([#24814](https://github.com/RocketChat/Rocket.Chat/pull/24814))

- Release 4.5.3 ([#24884](https://github.com/RocketChat/Rocket.Chat/pull/24884) by [@amolghode1981](https://github.com/amolghode1981))

- Release 4.5.4 ([#24938](https://github.com/RocketChat/Rocket.Chat/pull/24938))

- Release 4.5.5 ([#24998](https://github.com/RocketChat/Rocket.Chat/pull/24998))

- Release 4.6.0 ([#25027](https://github.com/RocketChat/Rocket.Chat/pull/25027) by [@amolghode1981](https://github.com/amolghode1981) & [@aswinidev](https://github.com/aswinidev) & [@dependabot[bot]](https://github.com/dependabot[bot]) & [@eduardofcabrera](https://github.com/eduardofcabrera) & [@lingohub[bot]](https://github.com/lingohub[bot]))

- Release 4.6.1 ([#25095](https://github.com/RocketChat/Rocket.Chat/pull/25095))

- Release 4.6.2 ([#25191](https://github.com/RocketChat/Rocket.Chat/pull/25191) by [@sidmohanty11](https://github.com/sidmohanty11))

- Release 4.6.3 ([#25235](https://github.com/RocketChat/Rocket.Chat/pull/25235))

- Release 4.7.0 ([#25390](https://github.com/RocketChat/Rocket.Chat/pull/25390) by [@Himanshu664](https://github.com/Himanshu664) & [@dependabot[bot]](https://github.com/dependabot[bot]) & [@lingohub[bot]](https://github.com/lingohub[bot]))

- Release 4.7.1 ([#25510](https://github.com/RocketChat/Rocket.Chat/pull/25510) by [@felipe-menelau](https://github.com/felipe-menelau))

- Release 4.7.2 ([#25580](https://github.com/RocketChat/Rocket.Chat/pull/25580))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@Himanshu664](https://github.com/Himanshu664)
- [@JMoVS](https://github.com/JMoVS)
- [@LucasFASouza](https://github.com/LucasFASouza)
- [@Muramatsu2602](https://github.com/Muramatsu2602)
- [@aadishJ01](https://github.com/aadishJ01)
- [@aakash-gitdev](https://github.com/aakash-gitdev)
- [@amolghode1981](https://github.com/amolghode1981)
- [@aswinidev](https://github.com/aswinidev)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@eduardofcabrera](https://github.com/eduardofcabrera)
- [@felipe-menelau](https://github.com/felipe-menelau)
- [@gerzonc](https://github.com/gerzonc)
- [@kibonusp](https://github.com/kibonusp)
- [@lingohub[bot]](https://github.com/lingohub[bot])
- [@ostjen](https://github.com/ostjen)
- [@paulobernardoaf](https://github.com/paulobernardoaf)
- [@pedrogssouza](https://github.com/pedrogssouza)
- [@sidmohanty11](https://github.com/sidmohanty11)
- [@souzaramon](https://github.com/souzaramon)
- [@tkurz](https://github.com/tkurz)
- [@ujorgeleite](https://github.com/ujorgeleite)
- [@weslley543](https://github.com/weslley543)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@alansikora](https://github.com/alansikora)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@felipe-rod123](https://github.com/felipe-rod123)
- [@filipemarins](https://github.com/filipemarins)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@guijun13](https://github.com/guijun13)
- [@jeanfbrito](https://github.com/jeanfbrito)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@tmontini](https://github.com/tmontini)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.4.3
`2022-04-07  ·  2 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.2`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.30.0`

### 🐛 Bug fixes


- NPS never finishing sending results ([#25067](https://github.com/RocketChat/Rocket.Chat/pull/25067))

- Proxy settings being ignored ([#25022](https://github.com/RocketChat/Rocket.Chat/pull/25022))

  Modify Meteor's `HTTP.call` to add back proxy support

### 👩‍💻👨‍💻 Core Team 🤓

- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.4.2
`2022-02-09  ·  1 🐛  ·  2 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.2`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.30.0`

### 🐛 Bug fixes


- OAuth mismatch redirect_uri error ([#24450](https://github.com/RocketChat/Rocket.Chat/pull/24450))

<details>
<summary>🔍 Minor changes</summary>


- Chore: bump fuselage version ([#24453](https://github.com/RocketChat/Rocket.Chat/pull/24453))

- Release 4.4.2 ([#24459](https://github.com/RocketChat/Rocket.Chat/pull/24459))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@dougfabris](https://github.com/dougfabris)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.4.1
`2022-02-07  ·  6 🐛  ·  1 🔍  ·  6 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.2`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.30.0`

### 🐛 Bug fixes


- Add ?close to OAuth callback url ([#24381](https://github.com/RocketChat/Rocket.Chat/pull/24381))

- Oembed request not respecting payload limit ([#24418](https://github.com/RocketChat/Rocket.Chat/pull/24418))

- Outgoing webhook without scripts not saving messages ([#24401](https://github.com/RocketChat/Rocket.Chat/pull/24401))

- Skip cloud steps for registered servers on setup wizard ([#24407](https://github.com/RocketChat/Rocket.Chat/pull/24407))

- Slash commands previews not working ([#24387](https://github.com/RocketChat/Rocket.Chat/pull/24387) by [@ostjen](https://github.com/ostjen))

- Startup errors creating indexes ([#24409](https://github.com/RocketChat/Rocket.Chat/pull/24409))

  Fix `bio` and `prid` startup index creation errors.

<details>
<summary>🔍 Minor changes</summary>


- Release 4.4.1 ([#24432](https://github.com/RocketChat/Rocket.Chat/pull/24432) by [@ostjen](https://github.com/ostjen))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@ostjen](https://github.com/ostjen)

### 👩‍💻👨‍💻 Core Team 🤓

- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)

# 4.4.0
`2022-01-28  ·  4 🎉  ·  13 🚀  ·  29 🐛  ·  44 🔍  ·  34 👩‍💻👨‍💻`

### Engine versions
- Node: `14.18.2`
- NPM: `6.14.15`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.30.0`

### 🎉 New features


- **EE:** Allow to filter departments by Business Units on Livechat ([#24162](https://github.com/RocketChat/Rocket.Chat/pull/24162))

- App empty states component, category filter and empty states error variation implementations ([#23818](https://github.com/RocketChat/Rocket.Chat/pull/23818))

  Created and implemented the category filters component:
  Demo gif:
  ![categories_filter_demo](https://user-images.githubusercontent.com/43561537/148579731-1de83bf8-91ce-47e7-b6e5-7781384fdef9.gif)

  Created and implemented the empty states(States on fuselage) component:
  Demo gif:
  ![empty_states_demo](https://user-images.githubusercontent.com/43561537/148579930-49c2ff69-88f4-4a57-a24a-060868d76209.gif)

  Implemented a variations system for the empty states component and created a error message for network outage:
  Demo gif:
  ![empty_states_variation_demo](https://user-images.githubusercontent.com/43561537/148580047-39adf8ef-2ee0-4c3e-8709-5faea4a5e335.gif)

- Apple Login ([#24060](https://github.com/RocketChat/Rocket.Chat/pull/24060))

- Enabling emoji on custom status ([#24170](https://github.com/RocketChat/Rocket.Chat/pull/24170))

### 🚀 Improvements


- Add Rocket.Chat version to User-Agent header for oembed requests ([#23605](https://github.com/RocketChat/Rocket.Chat/pull/23605) by [@sidmohanty11](https://github.com/sidmohanty11))

- Added a Reset Button in the Account Profile Page ([#24078](https://github.com/RocketChat/Rocket.Chat/pull/24078) by [@aswinidev](https://github.com/aswinidev))

- Admin page header buttons consistency ([#24168](https://github.com/RocketChat/Rocket.Chat/pull/24168))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/149371746-66e5e6e4-5c8e-46d7-b230-ecbc4502b665.png)
  ![image](https://user-images.githubusercontent.com/27704687/149371759-c3d948af-d877-486c-a263-da12c0b70185.png)
  ![image](https://user-images.githubusercontent.com/27704687/149371769-09b0623d-a5c5-43e0-a4ef-73ba0bcf1730.png)
  ![image](https://user-images.githubusercontent.com/27704687/149371782-b1b898c7-3aad-47ee-8c5c-cf9cb816d72b.png)
  ![image](https://user-images.githubusercontent.com/27704687/149371796-b88514d2-3c8d-4d9d-a45b-24f48783e95c.png)


  ### after
  ![Screen Shot 2022-01-13 at 13 38 00](https://user-images.githubusercontent.com/27704687/149371084-668d5f14-e03e-4cdd-8763-058db9c2f16c.png)
  ![Screen Shot 2022-01-13 at 13 38 18](https://user-images.githubusercontent.com/27704687/149371126-23a059cb-efa7-4ffb-970b-da23d8742bb1.png)
  ![Screen Shot 2022-01-13 at 13 38 38](https://user-images.githubusercontent.com/27704687/149371181-c8bbbbbd-ed6d-48b4-844f-09fdce0080b6.png)
  ![Screen Shot 2022-01-13 at 13 38 59](https://user-images.githubusercontent.com/27704687/149371232-3d292f5e-e8b0-41e1-b065-90a80a5f08ce.png)
  ![Screen Shot 2022-01-13 at 13 39 08](https://user-images.githubusercontent.com/27704687/149371263-64fd09e4-456e-48ee-9976-83f42b90e4d9.png)

- Importer text for CSV upload file format ([#23817](https://github.com/RocketChat/Rocket.Chat/pull/23817) by [@ostjen](https://github.com/ostjen))

- lib/Statistics improved and metrics collector ([#24177](https://github.com/RocketChat/Rocket.Chat/pull/24177) by [@ostjen](https://github.com/ostjen))

  - On `statistics` object the property `get`  is an async function now.

  - We need to collect additional data of feature activation through the statistics collector.
    - Some codes were splitted into another file just to organize.

- Limit recent emojis to 27 ([#24210](https://github.com/RocketChat/Rocket.Chat/pull/24210))

  Limits the recent emoji list to a maximum of 3 rows instead of listing every emoji you've used so far.

  ![image](https://user-images.githubusercontent.com/8591547/150033087-92721b76-9203-42fe-ac2e-5b9eca50edab.png)

- Rewrite AddWebdavAccountModal to React Component  ([#24070](https://github.com/RocketChat/Rocket.Chat/pull/24070))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/147777054-bf2f84e4-5226-4ebc-ab6e-287b83889b85.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/147769132-2b938ae8-aba3-4230-876d-572e46268b9a.png)

- Rewrite Omnichannel Queue Page to React ([#24176](https://github.com/RocketChat/Rocket.Chat/pull/24176))

  ![image](https://user-images.githubusercontent.com/17487063/149458880-03c201ab-11cd-4c71-82aa-51bd557d3b6e.png)

- Rewrite roomNotFound to React Component ([#24044](https://github.com/RocketChat/Rocket.Chat/pull/24044))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/147608307-468e6955-5db4-40c5-86a7-91448ac03427.png)
  ![image](https://user-images.githubusercontent.com/27704687/147608377-d979adf5-615f-4180-8587-449369bf87f8.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/149158027-e39bc0a0-4c33-465b-83e0-873e558a037b.png)
  ![image](https://user-images.githubusercontent.com/27704687/149157692-3e73c0b4-1759-430c-b1c4-b521e47d774d.png)

- Setup Wizard Registration Flow ([#23676](https://github.com/RocketChat/Rocket.Chat/pull/23676))

  This pull request brings a few improvements in our setup wizard flow, the very first contact with a Rocket.Chat. Some of them:

  - A brand new visual design;

  - Form validation improves;

  - Allow users to navigate back to all steps;

  - Optimized steps to register your workspace or keep standalone. And many more!


  ![Kapture 2022-01-20 at 11 19 47](https://user-images.githubusercontent.com/27704687/150356868-425666b4-511f-4690-9ce5-e61b839b1d19.gif)

- Show Channel Icons on Room Header & Info panels ([#24239](https://github.com/RocketChat/Rocket.Chat/pull/24239))

  Updates Omnichannel Header & room Info component to render the source info
  Built on top of https://github.com/RocketChat/Rocket.Chat/pull/24237

- Throw 404 error in invalid endpoints ([#24053](https://github.com/RocketChat/Rocket.Chat/pull/24053))

  - Throw 404 error when trying to call invalid endpoints.

- Throw 404 error in invalid endpoints" ([#24118](https://github.com/RocketChat/Rocket.Chat/pull/24118))

### 🐛 Bug fixes


- **APPS:** Action buttons not removed when app is disabled or uninstalled ([#24107](https://github.com/RocketChat/Rocket.Chat/pull/24107))

  Fixes a problem where action buttons registered by any app would not be removed if the app was disabled or uninstalled

- **APPS:** Prevents emails from being sent when apps framework is disabled ([#24105](https://github.com/RocketChat/Rocket.Chat/pull/24105))

  Introduction of new event `IPreEmailSent` was breaking the email function when the Apps-Engine framework was disabled in the administration

- **EE:** Agent cannot change status to Available despite being within open business hours ([#24112](https://github.com/RocketChat/Rocket.Chat/pull/24112))

- **ENTERPRISE:** Leading slashes in Engagement Dashboard API requests ([#24142](https://github.com/RocketChat/Rocket.Chat/pull/24142))

  - Remove trailing slashes from Engagement Dashboard API requests;

- App Framework Enable hanging indefinitely ([#24158](https://github.com/RocketChat/Rocket.Chat/pull/24158))

- Apps Contextual Bar not carrying title and room information   ([#24241](https://github.com/RocketChat/Rocket.Chat/pull/24241))

  Fixes:


  - the app's name being rendered instead of the view's title,

  - the room's information (`IRoom`) wasn't being sent to the app when a `block action` happened

  Fixed behavior with correct view title and room information included in the block action event:

  https://user-images.githubusercontent.com/733282/150420847-59bfcf8a-24a9-4dc5-8609-0d92dba38b70.mp4

- Avoid updating all rooms with visitor abandonment queries ([#24252](https://github.com/RocketChat/Rocket.Chat/pull/24252))

- Change canned response model index to match other definition ([#24235](https://github.com/RocketChat/Rocket.Chat/pull/24235))

- CSV Importer failing to import users ([#24090](https://github.com/RocketChat/Rocket.Chat/pull/24090))

  - Update use of `setRealName` function to `_setRealName`.

- Custom Emoji Image preview ([#24117](https://github.com/RocketChat/Rocket.Chat/pull/24117) by [@sidmohanty11](https://github.com/sidmohanty11))

  Before,

  ![custom-img-preview-rc3](https://user-images.githubusercontent.com/73601258/148431936-c82d4200-69b1-484b-8be2-d72f5c28202b.png)

  After,

  ![custom-img-preview-rc1](https://user-images.githubusercontent.com/73601258/148431955-8842a2e3-b9f3-4d68-b0d8-c5444419f767.png)

  also if any error, (for example   - if we upload a video mp4 file)

  ![custom-img-preview-rc2](https://user-images.githubusercontent.com/73601258/148431998-64bc1fbb-9958-495c-89c1-61df06adec75.png)

- Discussions not loading message history if not joined ([#24316](https://github.com/RocketChat/Rocket.Chat/pull/24316))

- Ensure Firefox 91 ESR support ([#24096](https://github.com/RocketChat/Rocket.Chat/pull/24096))

  It:

  - Adds `Firefox ESR` to `browserslist`;

  - Upgrades `@rocket.chat/fuselage-hooks` to overcome a bug related to Firefox implementation of `ResizeObserver` API.

- Enter not working on modal's multi-line input ([#23981](https://github.com/RocketChat/Rocket.Chat/pull/23981))

  Right now, if we try to press enter for a new line on multi-line modal input... it auto triggers the submit event. This PR fixes this behaviour by not submitting the modal in case the enter was pressed within an input text with multiline expected

- Errors on advanced sync prevent LDAP users from logging in ([#23958](https://github.com/RocketChat/Rocket.Chat/pull/23958) by [@ostjen](https://github.com/ostjen))

- Filter ability for admin room checkboxes ([#23970](https://github.com/RocketChat/Rocket.Chat/pull/23970) by [@sidmohanty11](https://github.com/sidmohanty11))

  Now,

  https://user-images.githubusercontent.com/73601258/146380812-d3aa5561-64e1-4515-a639-3b6d87432ae4.mp4

  Before,

  https://user-images.githubusercontent.com/73601258/146385538-85a70fce-9974-40e0-8757-eda1a5d411b7.mp4

- Fixed broken links in setup wizard ([#24248](https://github.com/RocketChat/Rocket.Chat/pull/24248) by [@Himanshu664](https://github.com/Himanshu664))

- Fixing the changing custom status behavior ([#24218](https://github.com/RocketChat/Rocket.Chat/pull/24218))

- Integration section crashing opening in My Account ([#24068](https://github.com/RocketChat/Rocket.Chat/pull/24068))

- Make canned responses popup dependent on Canned_responses_enabled setting ([#23804](https://github.com/RocketChat/Rocket.Chat/pull/23804))

- MAU when using micro services ([#24204](https://github.com/RocketChat/Rocket.Chat/pull/24204))

- Message Erasure Type "Keep" Messages not working ([#24024](https://github.com/RocketChat/Rocket.Chat/pull/24024) by [@arshxyz](https://github.com/arshxyz))

- MongoError during startup saying "ns not found" ([#24015](https://github.com/RocketChat/Rocket.Chat/pull/24015))

- Omnichannel Current chats pagination not working ([#24039](https://github.com/RocketChat/Rocket.Chat/pull/24039))

- Omnichannel enabled setting not working when creating rooms ([#24067](https://github.com/RocketChat/Rocket.Chat/pull/24067))

- openUserInfo not working after changing room types ([#24098](https://github.com/RocketChat/Rocket.Chat/pull/24098) by [@grahhnt](https://github.com/grahhnt))

- Password error should not be shown when selecting set random password ([#21181](https://github.com/RocketChat/Rocket.Chat/pull/21181))

  We should not keep `password` as required field when we check set random password field. In this password should not be required

- Solved Report Message Blank  ([#24262](https://github.com/RocketChat/Rocket.Chat/pull/24262))

  After resolving issue #24261  :

  https://user-images.githubusercontent.com/53515714/150629459-5f0a9cf6-9b0e-417f-8fc1-44c810bd5428.mp4

- Wrong german translation for 2FA-Promt ([#24126](https://github.com/RocketChat/Rocket.Chat/pull/24126) by [@mbreslein-thd](https://github.com/mbreslein-thd))

- wrong new userInfo during user creation ([#24051](https://github.com/RocketChat/Rocket.Chat/pull/24051) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

<details>
<summary>🔍 Minor changes</summary>


- Add: Alpine image as option for build ([#12548](https://github.com/RocketChat/Rocket.Chat/pull/12548))

- Bump follow-redirects from 1.14.5 to 1.14.7 in /ee/server/services ([#24182](https://github.com/RocketChat/Rocket.Chat/pull/24182) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: add script to fix code with prettier ([#24054](https://github.com/RocketChat/Rocket.Chat/pull/24054))

- Chore: Apply generics to infer types of useForm hook ([#22400](https://github.com/RocketChat/Rocket.Chat/pull/22400))

- Chore: Bump fuselage hooks ([#24233](https://github.com/RocketChat/Rocket.Chat/pull/24233))

- Chore: Bump Livechat package version to 1.12.0 ([#24232](https://github.com/RocketChat/Rocket.Chat/pull/24232))

- Chore: Convert model LoginServiceConfiguration to raw ([#24187](https://github.com/RocketChat/Rocket.Chat/pull/24187))

- Chore: Fix Houston `getNodeNpmVersions` regex to correctly get Node and Npm complete versions ([#24111](https://github.com/RocketChat/Rocket.Chat/pull/24111))

- Chore: Include REG_TOKEN in docker-compose ([#24123](https://github.com/RocketChat/Rocket.Chat/pull/24123))

- Chore: Migrate useOutsideClick to fuselage-hooks ([#24133](https://github.com/RocketChat/Rocket.Chat/pull/24133))

- Chore: Move `callbacks` to /lib ([#23456](https://github.com/RocketChat/Rocket.Chat/pull/23456))

  It moves to `/lib`, migrates to TypeScript, and deprecates the `callbacks` API.

- Chore: Prettier for us all ([#24000](https://github.com/RocketChat/Rocket.Chat/pull/24000))

- Chore: Remove unused assets ([#24023](https://github.com/RocketChat/Rocket.Chat/pull/24023))

- Chore: Removing hubot from docker-compose ([#23591](https://github.com/RocketChat/Rocket.Chat/pull/23591))

  Remove hubot from docker-compose.  This is forcing everyone to spin up Hubot every time they deploy Rocket.Chat and not that many people are using it.  So we are wasting resources on peoples machines by forcing it

- Chore: Replace `isEmail` with `validateEmail` ([#24020](https://github.com/RocketChat/Rocket.Chat/pull/24020))

  Follows #23816.

- Chore: Replace Blaze templates ([#24165](https://github.com/RocketChat/Rocket.Chat/pull/24165))

  It replaces some templates used by login and invitation flows with React components. It also drops `main` template, allowing `appLayout` to just handle components now.

- Chore: Slash Commands Join to Typescript ([#24254](https://github.com/RocketChat/Rocket.Chat/pull/24254) by [@eduardofcabrera](https://github.com/eduardofcabrera) & [@ostjen](https://github.com/ostjen))

  Convert the slash commands .js files to .ts files.

- Chore: Update Apps-Engine to 1.29.2 ([#24171](https://github.com/RocketChat/Rocket.Chat/pull/24171))

- Chore: Update Apps-Engine version ([#24335](https://github.com/RocketChat/Rocket.Chat/pull/24335))

- Chore: Update copyright notices ([#24022](https://github.com/RocketChat/Rocket.Chat/pull/24022))

  Update date range in copyright notices to `2015-2022`.

- Chore: Update Livechat to 1.11.1 ([#24091](https://github.com/RocketChat/Rocket.Chat/pull/24091))

- Chore: Update mem to 8.1.1 ([#23954](https://github.com/RocketChat/Rocket.Chat/pull/23954))

- Chore: Update Meteor to 2.5.3 ([#24075](https://github.com/RocketChat/Rocket.Chat/pull/24075))

- Chore: Update Omnichannel widget version to 1.11.2 ([#24169](https://github.com/RocketChat/Rocket.Chat/pull/24169))

- Chore: Update pino and pino-pretty ([#24242](https://github.com/RocketChat/Rocket.Chat/pull/24242))

- i18n: Language update from LingoHub 🤖 on 2022-01-10Z ([#24127](https://github.com/RocketChat/Rocket.Chat/pull/24127))

- i18n: Language update from LingoHub 🤖 on 2022-01-17Z ([#24193](https://github.com/RocketChat/Rocket.Chat/pull/24193))

- i18n: Language update from LingoHub 🤖 on 2022-01-24Z ([#24268](https://github.com/RocketChat/Rocket.Chat/pull/24268))

- Merge master into develop & Set version to 4.4.0-develop ([#24049](https://github.com/RocketChat/Rocket.Chat/pull/24049))

- Regression: Align Omni-Source icon sizes with designs ([#24269](https://github.com/RocketChat/Rocket.Chat/pull/24269))

- Regression: Create migration to fix index issue at boot ([#24289](https://github.com/RocketChat/Rocket.Chat/pull/24289))

- Regression: Discussion room crashing ([#24272](https://github.com/RocketChat/Rocket.Chat/pull/24272))

- Regression: Enable custom emoji on admin custom status page ([#24186](https://github.com/RocketChat/Rocket.Chat/pull/24186))

- Regression: Fix Alpine release tag ([#24259](https://github.com/RocketChat/Rocket.Chat/pull/24259))

- Regression: Fix Default Business hour overriding other Business Hours ([#24288](https://github.com/RocketChat/Rocket.Chat/pull/24288))

- Regression: Fix handling of http requests in apps bridge ([#24211](https://github.com/RocketChat/Rocket.Chat/pull/24211))

  Changes made during Meteor upgrade broke HTTP requests made in Rocket.Chat Apps

- Regression: Fix Inactive Departments still visible on Livechat ([#24267](https://github.com/RocketChat/Rocket.Chat/pull/24267))

- Regression: Fix incompatibility of apps http requests ([#24276](https://github.com/RocketChat/Rocket.Chat/pull/24276))

  HTTP GET and HEAD requests made with an empty object as `data` were breaking, as the bridge converted this to the request's body as `'{}'` but meteor's new lib doesn't allow for body content on either of this request methods.

  To maintain compatibility, we forced an empty body whenever we have a GET or HEAD request. This was probably the case previously, with the body of requests made with this methods being ignored either before being sent or in the third party server receiving the request

- Regression: Fix OmnichannelAppSourceRoomIcon sizes ([#24322](https://github.com/RocketChat/Rocket.Chat/pull/24322))

- Regression: Fix pino child log levels ([#24302](https://github.com/RocketChat/Rocket.Chat/pull/24302))

- Regression: Remove extra call to `useOutsideClick` hook not following the function signature ([#24243](https://github.com/RocketChat/Rocket.Chat/pull/24243))

  It migrates `client/sidebar/header/actions/Search` component to TypeScript and mitigates a invalid call to `Array.prototype.every`:

  ![image](https://user-images.githubusercontent.com/2263066/150441397-3ff403b2-10c1-4a29-b37f-892d7d4a9252.png)

- Regression: Standalone register path failing when saving data ([#24324](https://github.com/RocketChat/Rocket.Chat/pull/24324))

- Regression: Update tap-i18n package ([#24298](https://github.com/RocketChat/Rocket.Chat/pull/24298))

  Fix the issue breaking IE11.

- Release 4.3.3 ([#24340](https://github.com/RocketChat/Rocket.Chat/pull/24340))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@Himanshu664](https://github.com/Himanshu664)
- [@arshxyz](https://github.com/arshxyz)
- [@aswinidev](https://github.com/aswinidev)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@eduardofcabrera](https://github.com/eduardofcabrera)
- [@grahhnt](https://github.com/grahhnt)
- [@mbreslein-thd](https://github.com/mbreslein-thd)
- [@ostjen](https://github.com/ostjen)
- [@sidmohanty11](https://github.com/sidmohanty11)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@LuluGO](https://github.com/LuluGO)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@albuquerquefabio](https://github.com/albuquerquefabio)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@nishant23122000](https://github.com/nishant23122000)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rique223](https://github.com/rique223)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.3.3
`2022-01-28  ·  1 🐛  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.12`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.29.2`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

<details>
<summary>🔍 Minor changes</summary>


- Release 4.3.3 ([#24340](https://github.com/RocketChat/Rocket.Chat/pull/24340))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@gronke](https://github.com/gronke)

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.3.2
`2022-01-19  ·  5 🐛  ·  1 🔍  ·  10 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.29.2`

### 🐛 Bug fixes


- **ENTERPRISE:** Leading slashes in Engagement Dashboard API requests ([#24142](https://github.com/RocketChat/Rocket.Chat/pull/24142))

  - Remove trailing slashes from Engagement Dashboard API requests;

- App Framework Enable hanging indefinitely ([#24158](https://github.com/RocketChat/Rocket.Chat/pull/24158))

- CSV Importer failing to import users ([#24090](https://github.com/RocketChat/Rocket.Chat/pull/24090))

  - Update use of `setRealName` function to `_setRealName`.

- Integration section crashing opening in My Account ([#24068](https://github.com/RocketChat/Rocket.Chat/pull/24068))

- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

<details>
<summary>🔍 Minor changes</summary>


- Chore: Update Apps-Engine to 1.29.2 ([#24171](https://github.com/RocketChat/Rocket.Chat/pull/24171))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@gronke](https://github.com/gronke)

### 👩‍💻👨‍💻 Core Team 🤓

- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.3.1
`2022-01-05  ·  6 🐛  ·  1 🔍  ·  6 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.29.1`

### 🐛 Bug fixes


- **APPS:** Action buttons not removed when app is disabled or uninstalled ([#24107](https://github.com/RocketChat/Rocket.Chat/pull/24107))

  Fixes a problem where action buttons registered by any app would not be removed if the app was disabled or uninstalled

- **APPS:** Prevents emails from being sent when apps framework is disabled ([#24105](https://github.com/RocketChat/Rocket.Chat/pull/24105))

  Introduction of new event `IPreEmailSent` was breaking the email function when the Apps-Engine framework was disabled in the administration

- Ensure Firefox 91 ESR support ([#24096](https://github.com/RocketChat/Rocket.Chat/pull/24096))

  It:

  - Adds `Firefox ESR` to `browserslist`;

  - Upgrades `@rocket.chat/fuselage-hooks` to overcome a bug related to Firefox implementation of `ResizeObserver` API.

- Enter not working on modal's multi-line input ([#23981](https://github.com/RocketChat/Rocket.Chat/pull/23981))

  Right now, if we try to press enter for a new line on multi-line modal input... it auto triggers the submit event. This PR fixes this behaviour by not submitting the modal in case the enter was pressed within an input text with multiline expected

- Omnichannel Current chats pagination not working ([#24039](https://github.com/RocketChat/Rocket.Chat/pull/24039))

- Omnichannel enabled setting not working when creating rooms ([#24067](https://github.com/RocketChat/Rocket.Chat/pull/24067))

<details>
<summary>🔍 Minor changes</summary>


- Chore: Update Livechat to 1.11.1 ([#24091](https://github.com/RocketChat/Rocket.Chat/pull/24091))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@d-gubert](https://github.com/d-gubert)
- [@murtaza98](https://github.com/murtaza98)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.3.0
`2021-12-28  ·  7 🎉  ·  5 🚀  ·  26 🐛  ·  37 🔍  ·  28 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.29.0`

### 🎉 New features


- **APPS:** Add new email event for apps ([#23925](https://github.com/RocketChat/Rocket.Chat/pull/23925))

  Introduces a new event called before an email is sent by the Mailer. Apps can intercept and modify the email that will be sent, or even prevent it from being sent altogether. For more details, check https://github.com/RocketChat/Rocket.Chat.Apps-engine/pull/461/files#diff-301e8a58164edbf315da2a43c4923f153dbc909573de1e60aa9f730f7488ac82

- **APPS:** Allow apps to open contextual bar ([#23843](https://github.com/RocketChat/Rocket.Chat/pull/23843))

  Opens a contextual bar using app ui interactions (`CONTEXTUAL_BAR_OPEN`)

  https://user-images.githubusercontent.com/733282/146704076-d2d115f2-6ca6-4ed0-b450-81be580889a4.mp4

- **APPS:** Allow Rocket.Chat Apps to register custom action buttons ([#23679](https://github.com/RocketChat/Rocket.Chat/pull/23679))

  Add an action button manager that allows apps to register custom action buttons that trigger interaction callbacks in them

- **APPS:** getUserUnreadMessageCount Bridge ([#23972](https://github.com/RocketChat/Rocket.Chat/pull/23972))

- **APPS:** Possibility to set room closer via Apps LivechatBridge.closeRoom ([#21025](https://github.com/RocketChat/Rocket.Chat/pull/21025))

  Add an optional param named `closer` into `LivechatBridge.closeRoom` so that it will be possible to close the room and send a close room message with the correct room closer.
  If the param is not passed, use the room visitor as the room closer.

- **EE:** Introduce fallback department support ([#23939](https://github.com/RocketChat/Rocket.Chat/pull/23939))

- Show Omnichannel room icon based on source definition ([#23912](https://github.com/RocketChat/Rocket.Chat/pull/23912))

### 🚀 Improvements


- Allow e-mail channel to be used without default department. ([#23945](https://github.com/RocketChat/Rocket.Chat/pull/23945))

  Due to a missing condition in the e-mail input processing, Rocket.Chat was unable to receive e-mails from e-mail channels that did not have a default department.

- Omnichannel Visitor Endpoints error handling ([#23819](https://github.com/RocketChat/Rocket.Chat/pull/23819))

- Replace SortListItem and CreateListItem with ListItem ([#24007](https://github.com/RocketChat/Rocket.Chat/pull/24007))

- Update "Message Erasure Type" setting's description ([#23879](https://github.com/RocketChat/Rocket.Chat/pull/23879))

  - Improves the "Message Erasure Type" setting's description by providing more details regarding the expected behavior of each option ("Keep Messages and User Name", "Delete All Messages" and "Remove link between user and messages");

  - Remove outdated translations (for this setting's description).

- Webdav methods sanitization ([#23924](https://github.com/RocketChat/Rocket.Chat/pull/23924))

  The improvement modify `server_url` and `user_id` params into `serverURL` and `userId` more suitable to our camelCase pattern. Also converts the webdav methods into .ts helping us to prevent issues in the next modal rewrites efforts.

### 🐛 Bug fixes


- Add CSP to authorize auto-close of CAS login window ([#23215](https://github.com/RocketChat/Rocket.Chat/pull/23215) by [@goyome](https://github.com/goyome))

  Add the hash of the JS inside the page that won't close ( window.close(); )

- Add missing .png to clipboard uploaded file name ([#23833](https://github.com/RocketChat/Rocket.Chat/pull/23833))

- broken `Word Placement Anywhere` and `Run on edits` toggles in integration page ([#23901](https://github.com/RocketChat/Rocket.Chat/pull/23901) by [@aswinidev](https://github.com/aswinidev))

- Broken links present in some languages ([#23987](https://github.com/RocketChat/Rocket.Chat/pull/23987) by [@aswinidev](https://github.com/aswinidev))

- Changes on department agents should mark form as dirty ([#19640](https://github.com/RocketChat/Rocket.Chat/pull/19640) by [@rafaelblink](https://github.com/rafaelblink))

- creating room with federated member ([#23347](https://github.com/RocketChat/Rocket.Chat/pull/23347) by [@qwertiko](https://github.com/qwertiko))

- Custom emoji route in admin ([#23882](https://github.com/RocketChat/Rocket.Chat/pull/23882) by [@sidmohanty11](https://github.com/sidmohanty11))

  https://user-images.githubusercontent.com/73601258/144975689-912cfd73-da16-433c-899a-4d4ffac8e146.mp4

- Custom status doesn't update properly ([#23860](https://github.com/RocketChat/Rocket.Chat/pull/23860))

- DMs being created with username instead of user's name ([#23848](https://github.com/RocketChat/Rocket.Chat/pull/23848))

- Email notifications settings not being honored on new DMs ([#23574](https://github.com/RocketChat/Rocket.Chat/pull/23574) by [@ostjen](https://github.com/ostjen))

- Error when creating an inactive user in admin panel ([#23859](https://github.com/RocketChat/Rocket.Chat/pull/23859))

  - Fix `usersInRole` array used to send email to activate a user.

- Fix no message size limit for method sendMessageLivechat ([#23558](https://github.com/RocketChat/Rocket.Chat/pull/23558))

- Headers already sent error when user data download is disabled ([#23805](https://github.com/RocketChat/Rocket.Chat/pull/23805))

  When using the export message tool when trying to download the file using the link sent via email if the feature "Export User Data" is disabled an error was being thrown causing the request to halt.

  This is the error shown in the logs:
  ```
  === UnHandledPromiseRejection ===
  Error [ERR_HTTP_HEADERS_SENT] [ERR_HTTP_HEADERS_SENT]: Cannot set headers after they are sent to the client
    at ServerResponse.setHeader (_http_outgoing.js:530:11)
    at ServerResponse.res.setHeader (/app/bundle/programs/server/npm/node_modules/meteor/simple_json-routes/node_modules/connect/lib/patch.js:134:22)
    at app/user-data-download/server/exportDownload.js:14:7
    at /app/bundle/programs/server/npm/node_modules/meteor/promise/node_modules/meteor-promise/fiber_pool.js:43:40 {
  code: 'ERR_HTTP_HEADERS_SENT'
  }
  ---------------------------------
  Errors like this can cause oplog processing errors.
  Setting EXIT_UNHANDLEDPROMISEREJECTION will cause the process to exit allowing your service to automatically restart the process
  Future node.js versions will automatically exit the process
  =================================
  ```

- Jitsi call already ended ([#23904](https://github.com/RocketChat/Rocket.Chat/pull/23904) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

  - Fix Jitsi timeout update -- which caused the "Jitsi call already ended" error when trying to join a call some time after its creation;

- LDAP Sync doing nothing when set to only import new users. ([#23823](https://github.com/RocketChat/Rocket.Chat/pull/23823))

- Missing custom user status ellipsis ([#23831](https://github.com/RocketChat/Rocket.Chat/pull/23831))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/144270229-baca14f5-e168-42b7-86d1-e7217be561a9.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/144274255-39216e69-8283-45c5-8a77-b835d284f655.png)

- Missing edit icon in sequential thread messages ([#23948](https://github.com/RocketChat/Rocket.Chat/pull/23948))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/146083450-ca6d7197-dc55-4058-8212-943b42c82473.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/146083055-36c9731a-33c6-483a-93a5-1355d8689e3a.png)

- Modal keeps state if reset too fast. ([#23791](https://github.com/RocketChat/Rocket.Chat/pull/23791))

  ~Queued updates so the Modal has a chance to close.~
  Used a random key to ensure modal doesn't keep it's state.

- OTR not working ([#23973](https://github.com/RocketChat/Rocket.Chat/pull/23973))

  A rule on the user notification streamer was changed recently, and the check for writing on the streamer was wrong. Changed it to allow all logged users.

- Popover position for arabic languages ([#23888](https://github.com/RocketChat/Rocket.Chat/pull/23888))

- Removing Edit message from messageBox on room changed ([#23910](https://github.com/RocketChat/Rocket.Chat/pull/23910))

  Removing edit message from messageBox and local storage on messageBox destroyed.

- Segmentation fault on CentOS 7 due to outdated `sharp` ([#23796](https://github.com/RocketChat/Rocket.Chat/pull/23796))

  Upgrades `sharp` to avoid a segmentation fault on CentOS 7 during startup related to `sharp.node` being loaded via `process.dlopen()`.

  Suggested as a fix for versions `4.0.x` and `4.1.x`.

- teams.leave client usage ([#23959](https://github.com/RocketChat/Rocket.Chat/pull/23959))

- teams.removeMembers client usage ([#23857](https://github.com/RocketChat/Rocket.Chat/pull/23857))

- Translations for App Select Settings not working ([#23908](https://github.com/RocketChat/Rocket.Chat/pull/23908))

  Derived from PR https://github.com/RocketChat/Rocket.Chat/pull/19238

- Wrong button for non trial apps ([#23861](https://github.com/RocketChat/Rocket.Chat/pull/23861))

  This PR solves a bug on the marketplace that was happening with WhatsApp where it was displaying a trial button even though it didn't have a free trial period. The new verification I've added checks if the app is subscription-based and then checks if it has 0 trial days in all of its tiers. If it does, it shows a subscribe button. If it doesn't, it displays a trial button. Also, I've exposed the itsEnterpriseOnly flag as an extra measure in the case of apps like Facebook Messenger that are enterprise-only and consequently should show the subscribe button.
  Before:
  ![image](https://user-images.githubusercontent.com/43561537/144687716-baef06ce-7a80-42fc-8393-b0283c0f349a.png)
  After:
  ![image](https://user-images.githubusercontent.com/43561537/144687924-1a3eb3a7-783f-4450-abd2-1efa0de64658.png)

<details>
<summary>🔍 Minor changes</summary>


- Bump @rocket.chat/string-helpers from 0.29.0 to 0.30.1 in /ee/server/services ([#23526](https://github.com/RocketChat/Rocket.Chat/pull/23526) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump cookie-parser from 1.4.5 to 1.4.6 in /ee/server/services ([#23921](https://github.com/RocketChat/Rocket.Chat/pull/23921) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump mailparser from 3.2.0 to 3.4.0 ([#23466](https://github.com/RocketChat/Rocket.Chat/pull/23466) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump path-parse from 1.0.6 to 1.0.7 ([#23689](https://github.com/RocketChat/Rocket.Chat/pull/23689) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pm2 from 5.1.1 to 5.1.2 in /ee/server/services ([#23289](https://github.com/RocketChat/Rocket.Chat/pull/23289) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump thehanimo/pr-title-checker from 1.2 to 1.3.4 ([#23853](https://github.com/RocketChat/Rocket.Chat/pull/23853) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: added last login to users.list ([#23846](https://github.com/RocketChat/Rocket.Chat/pull/23846) by [@ostjen](https://github.com/ostjen))

- Chore: Bump fuselage 0.31.0 ([#24046](https://github.com/RocketChat/Rocket.Chat/pull/24046))

- Chore: Centralize email validation functionality ([#23816](https://github.com/RocketChat/Rocket.Chat/pull/23816))

  - Create lib for validating emails

  - Modify places that validate emails to use the new central function

- Chore: Change Menu props to accept next fuselage version ([#23839](https://github.com/RocketChat/Rocket.Chat/pull/23839))

- Chore: Create script to add new migrations ([#23822](https://github.com/RocketChat/Rocket.Chat/pull/23822))

  - Create NPM script to add new migrations

  - TODO:  Infer next migration number from file list

- Chore: Deleted LivechatPageVisited ([#23993](https://github.com/RocketChat/Rocket.Chat/pull/23993) by [@ostjen](https://github.com/ostjen))

- Chore: Enable prefer-optional-chain ESLint rule for TypeScript files ([#23786](https://github.com/RocketChat/Rocket.Chat/pull/23786))

  > Code is bad. It rots. It requires periodic maintenance. It has bugs that need to be found. New features mean old code has to be adapted.
  > The more code you have, the more places there are for bugs to hide. The longer checkouts or compiles take. The longer it takes a new employee to make sense of your system. If you have to refactor there's more stuff to move around.
  > Furthermore, more code often means less flexibility and functionality. This is counter-intuitive, but a lot of times a simple, elegant solution is faster and more general than the plodding mess of code produced by a programmer of lesser talent.
  > Code is produced by engineers. To make more code requires more engineers. Engineers have n^2 communication costs, and all that code they add to the system, while expanding its capability, also increases a whole basket of costs.
  > You should do whatever possible to increase the productivity of individual programmers in terms of the expressive power of the code they write. Less code to do the same thing (and possibly better). Less programmers to hire. Less organizational communication costs.

  — <cite>[Rich Skrenta][1]</cite>

  Mixing two problem domains in code is prone to errors. In this small example

  ```ts
  declare const y: { z: unknown } | undefined;

  const x = y && y.z;
  ```

  we're (1) checking the nullity of `y` and (2) attributing `y.z` to `x`, where (2) is _clearly_ the main problem we're solving with code. The optional chaining is a good technique to handle nullity as a mere implementation detail:

  ```ts
  declare const y: { z: unknown } | undefined;

  const x = y?.z;
  ```

  Attributing `y.z` to `x` is more easily readable than the nullity check of `y`.

  This PR aims to add `@typescript-eslint/prefer-optional-chain` rule to ESlint configuration at warning level.

- Chore: Fix hasRole warning ([#23914](https://github.com/RocketChat/Rocket.Chat/pull/23914))

- Chore: Remove the `mobile-download-file` permission ([#23996](https://github.com/RocketChat/Rocket.Chat/pull/23996))

  - Remove the `mobile-download-file` permission and its descriptions.

- Chore: Replace new typography ([#23756](https://github.com/RocketChat/Rocket.Chat/pull/23756))

- Chore: Replace typography ([#24021](https://github.com/RocketChat/Rocket.Chat/pull/24021))

- Chore: Update Apps-Engine to latest ([#24045](https://github.com/RocketChat/Rocket.Chat/pull/24045))

- Chore: update docker image base to latest node 12 patch ([#23875](https://github.com/RocketChat/Rocket.Chat/pull/23875))

- Chore: Update Livechat ([#23913](https://github.com/RocketChat/Rocket.Chat/pull/23913))

- Chore: Update pino deps ([#23922](https://github.com/RocketChat/Rocket.Chat/pull/23922))

- Chore: Use only LivechatTriggerRaw model ([#23974](https://github.com/RocketChat/Rocket.Chat/pull/23974))

- i18n: Language update from LingoHub 🤖 on 2021-12-06Z ([#23873](https://github.com/RocketChat/Rocket.Chat/pull/23873))

- i18n: Language update from LingoHub 🤖 on 2021-12-13Z ([#23930](https://github.com/RocketChat/Rocket.Chat/pull/23930))

- i18n: Language update from LingoHub 🤖 on 2021-12-20Z ([#23991](https://github.com/RocketChat/Rocket.Chat/pull/23991))

- i18n: Language update from LingoHub 🤖 on 2021-12-27Z ([#24030](https://github.com/RocketChat/Rocket.Chat/pull/24030))

- Merge master into develop & Set version to 4.3.0-develop ([#23827](https://github.com/RocketChat/Rocket.Chat/pull/23827))

- Regression: Add migration for omni rooms with no source ([#24012](https://github.com/RocketChat/Rocket.Chat/pull/24012))

  Add a migration to add source property to all the omnichannel rooms which don't have it yet. All these rooms will have source type as `other`

- Regression: Add optional chaining to possibly undefined fields ([#24033](https://github.com/RocketChat/Rocket.Chat/pull/24033))

- Regression: addAction verification breaking rooms ([#24019](https://github.com/RocketChat/Rocket.Chat/pull/24019))

- Regression: Ensure room action buttons only appear inside menu ([#24035](https://github.com/RocketChat/Rocket.Chat/pull/24035))

  Currently, action buttons registered by apps to appear in the ROOM_ACTION context show in the first position of the list, but since they don't have an icon they are effectively invisible in the tab bar.

  Here we change the order configuration of the button so we make sure it only shows inside the room menu

- Regression: Fix omnichannel empty source usage ([#24008](https://github.com/RocketChat/Rocket.Chat/pull/24008))

- Regression: Let Meteor.absoluteUrl.defaultOptions.rootUrl as baseURI ([#24009](https://github.com/RocketChat/Rocket.Chat/pull/24009))

- Regression: Missing padding in popover with custom template ([#23877](https://github.com/RocketChat/Rocket.Chat/pull/23877))

  ![Screen Shot 2021-12-06 at 14 16 40](https://user-images.githubusercontent.com/27704687/144891474-a5bf982e-56af-46df-b472-adf9d999ce02.png)

- Regression: Remove dangling console.log ([#24034](https://github.com/RocketChat/Rocket.Chat/pull/24034))

  A empty array have been printed to console due to a promise chained to `console.log` and `console.error` calls, probably for debugging purposes.

- Regression: Remove self from fallback departments dropdown ([#24018](https://github.com/RocketChat/Rocket.Chat/pull/24018))

- Regression: Toolbox render item ([#23862](https://github.com/RocketChat/Rocket.Chat/pull/23862))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@aswinidev](https://github.com/aswinidev)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@goyome](https://github.com/goyome)
- [@ostjen](https://github.com/ostjen)
- [@qwertiko](https://github.com/qwertiko)
- [@rafaelblink](https://github.com/rafaelblink)
- [@sidmohanty11](https://github.com/sidmohanty11)

### 👩‍💻👨‍💻 Core Team 🤓

- [@AllanPazRibeiro](https://github.com/AllanPazRibeiro)
- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@debdutdeb](https://github.com/debdutdeb)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@juliajforesti](https://github.com/juliajforesti)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rique223](https://github.com/rique223)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.2.2
`2021-12-14  ·  1 🐛  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.1`

### 🐛 Bug fixes


- creating room with federated member ([#23347](https://github.com/RocketChat/Rocket.Chat/pull/23347) by [@qwertiko](https://github.com/qwertiko))

<details>
<summary>🔍 Minor changes</summary>


- Release 4.2.2 ([#23940](https://github.com/RocketChat/Rocket.Chat/pull/23940) by [@qwertiko](https://github.com/qwertiko))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@qwertiko](https://github.com/qwertiko)

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 4.2.1
`2021-12-10  ·  4 🐛  ·  2 🔍  ·  8 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.1`

### 🐛 Bug fixes


- Error when creating an inactive user in admin panel ([#23859](https://github.com/RocketChat/Rocket.Chat/pull/23859))

  - Fix `usersInRole` array used to send email to activate a user.

- Segmentation fault on CentOS 7 due to outdated `sharp` ([#23796](https://github.com/RocketChat/Rocket.Chat/pull/23796))

  Upgrades `sharp` to avoid a segmentation fault on CentOS 7 during startup related to `sharp.node` being loaded via `process.dlopen()`.

  Suggested as a fix for versions `4.0.x` and `4.1.x`.

- teams.removeMembers client usage ([#23857](https://github.com/RocketChat/Rocket.Chat/pull/23857))

- Wrong button for non trial apps ([#23861](https://github.com/RocketChat/Rocket.Chat/pull/23861))

  This PR solves a bug on the marketplace that was happening with WhatsApp where it was displaying a trial button even though it didn't have a free trial period. The new verification I've added checks if the app is subscription-based and then checks if it has 0 trial days in all of its tiers. If it does, it shows a subscribe button. If it doesn't, it displays a trial button. Also, I've exposed the itsEnterpriseOnly flag as an extra measure in the case of apps like Facebook Messenger that are enterprise-only and consequently should show the subscribe button.
  Before:
  ![image](https://user-images.githubusercontent.com/43561537/144687716-baef06ce-7a80-42fc-8393-b0283c0f349a.png)
  After:
  ![image](https://user-images.githubusercontent.com/43561537/144687924-1a3eb3a7-783f-4450-abd2-1efa0de64658.png)

<details>
<summary>🔍 Minor changes</summary>


- Chore: Update Livechat ([#23913](https://github.com/RocketChat/Rocket.Chat/pull/23913))

- Release 4.2.1 ([#23917](https://github.com/RocketChat/Rocket.Chat/pull/23917))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@dougfabris](https://github.com/dougfabris)
- [@ggazzo](https://github.com/ggazzo)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@rique223](https://github.com/rique223)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.2.0
`2021-11-30  ·  9 🎉  ·  7 🚀  ·  26 🐛  ·  27 🔍  ·  24 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.1`

### 🎉 New features


- Allow Omnichannel statistics to be collected. ([#23694](https://github.com/RocketChat/Rocket.Chat/pull/23694))

  This PR adds the possibility for business stakeholders to see what is actually being used of the Omnichannel integrations.

- Allow registering by REG_TOKEN environment variable ([#23737](https://github.com/RocketChat/Rocket.Chat/pull/23737))

  You can provide the REG_TOKEN environment variable containing a registration token and it will automatically register to your cloud account.  This simplifies the registration flow

- Audio and Video calling in Livechat ([#23004](https://github.com/RocketChat/Rocket.Chat/pull/23004) by [@Deepak-learner](https://github.com/Deepak-learner) & [@dhruvjain99](https://github.com/dhruvjain99))

- Enable LDAP manual sync to deployments without EE license ([#23761](https://github.com/RocketChat/Rocket.Chat/pull/23761))

  Open the Enterprise LDAP API that executes background sync to be used without any Enterprise License and enforce 2FA requirements.

- Permission for download/uploading files on mobile ([#23686](https://github.com/RocketChat/Rocket.Chat/pull/23686) by [@ostjen](https://github.com/ostjen))

- Permissions for interacting with Omnichannel Contact Center ([#23389](https://github.com/RocketChat/Rocket.Chat/pull/23389))

  Adds a new permission, one that allows for control over user access to Omnichannel Contact Center,

- Rate limiting for user registering ([#23732](https://github.com/RocketChat/Rocket.Chat/pull/23732) by [@ostjen](https://github.com/ostjen))

- REST endpoints to manage Omnichannel Business Units ([#23750](https://github.com/RocketChat/Rocket.Chat/pull/23750))

  Basic documentation about endpoints can be found at https://www.postman.com/kaleman960/workspace/rocketchat-public-api/request/3865466-71502450-8c8f-42b4-8954-1cd3d01fcb0c

- Show on-hold metrics on analytics pages and current chats ([#23498](https://github.com/RocketChat/Rocket.Chat/pull/23498))

### 🚀 Improvements


- Allow override of default department for SMS Livechat sessions ([#23626](https://github.com/RocketChat/Rocket.Chat/pull/23626) by [@bhardwajaditya](https://github.com/bhardwajaditya))

- Engagement Dashboard ([#23547](https://github.com/RocketChat/Rocket.Chat/pull/23547))

  - Adds helpers `onToggledFeature` for server and client code to handle license activation/deactivation without server restart;

  - Replaces usage of `useEndpointData` with `useQuery` (from [React Query](https://react-query.tanstack.com/));

  - Introduces `view-engagement-dashboard` permission.

- Improve the add user drop down for add a user in create channel modal for UserAutoCompleteMultiple ([#23766](https://github.com/RocketChat/Rocket.Chat/pull/23766) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  Seeing only the name of the person you are not adding is not practical in my opinion because two people can have the same name. Moreover, you can't see the username of the person you want to add in the dropdown. So I changed that and created another selection of users to show the username as well. I made this change so that it would appear in the key place for creating a room and adding a user.

  Before:

  https://user-images.githubusercontent.com/45966964/115287805-faac8d00-a150-11eb-871f-147ab011ced0.mp4


  After:

  https://user-images.githubusercontent.com/45966964/115287664-d2249300-a150-11eb-8cf6-0e04730b425d.mp4

- MKP12 - New UI - Merge Apps and Marketplace Tabs and Content ([#23542](https://github.com/RocketChat/Rocket.Chat/pull/23542))

  Merged the Marketplace and Apps page into a single page with a tabs component that changes between Markeplace and installed apps.
  ![page merging](https://user-images.githubusercontent.com/43561537/138516558-f86d62e6-1a5c-4817-a229-a1b876323960.gif)

- Re-naming department query param for Twilio ([#23725](https://github.com/RocketChat/Rocket.Chat/pull/23725))

  Since the endpoint supports both, department ID and department Name, so we're renaming it to reflect the same. `departmentName` -> `department`

- Reduce complexity in some functions ([#23387](https://github.com/RocketChat/Rocket.Chat/pull/23387))

  Overhauls all places where eslint's `complexity` rule is disabled.

- Stricter API types ([#23735](https://github.com/RocketChat/Rocket.Chat/pull/23735))

  It:

  - Adds stricter types for `API`;

  - Enables types for `urlParams`;

  - Removes mandatory passage of `undefined` payload on client;

  - Corrects some regressions;

  - Reassures my belief in TypeScript supremacy.

### 🐛 Bug fixes


- "to users" not working in export message ([#23576](https://github.com/RocketChat/Rocket.Chat/pull/23576) by [@ostjen](https://github.com/ostjen))

- **ENTERPRISE:** OAuth "Merge Roles" removes roles from users ([#23588](https://github.com/RocketChat/Rocket.Chat/pull/23588))

  - Fix OAuth "Merge Roles": the "Merge Roles" option now synchronize only the roles described in the "**Roles to Sync**" setting available in each Custom OAuth settings' group (instead of replacing users' roles by their OAuth roles);

  - Fix "Merge Roles" and "Channel Mapping" not being performed/updated on OAuth login.

- **ENTERPRISE:** Private rooms and discussions can't be audited ([#23673](https://github.com/RocketChat/Rocket.Chat/pull/23673))

  - Add Private rooms (groups) and Discussions to the Message Auditing (Channels) autocomplete;

  - Update "Channels" tab name to "Rooms".

- **ENTERPRISE:** Replace all occurrences of a placeholder on string instead of just first one ([#23703](https://github.com/RocketChat/Rocket.Chat/pull/23703))

- Advanced LDAP Sync Features ([#23608](https://github.com/RocketChat/Rocket.Chat/pull/23608))

- App update flow failing in HA setups ([#23607](https://github.com/RocketChat/Rocket.Chat/pull/23607))

  The flow for app updates is broken in specific scenarios with HA setups. Here we change the method calls in the Apps-Engine to avoid race conditions

- Apps scheduler "losing" jobs after server restart ([#23566](https://github.com/RocketChat/Rocket.Chat/pull/23566))

  If a job is scheduled and the server restarted, said job won't be executed, giving the impression it's been lost.

  What happens is that the scheduler is only started when some app tries to schedule an app   - if that happens, all jobs that are "late" will be executed; if that doesn't happen, no job will run.

  This PR starts the apps scheduler right after all apps have been loaded

- Autofocus on search input in admin ([#23738](https://github.com/RocketChat/Rocket.Chat/pull/23738))

  Removed "generic" autofocus on sidenav template.

- Await promise to handle error when attempting to transfer a room ([#23739](https://github.com/RocketChat/Rocket.Chat/pull/23739))

- broken avatar preview when changing avatar ([#23659](https://github.com/RocketChat/Rocket.Chat/pull/23659) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

- Discussions created inside discussions ([#23733](https://github.com/RocketChat/Rocket.Chat/pull/23733))

- Fix typo in FR translation ([#23711](https://github.com/RocketChat/Rocket.Chat/pull/23711) by [@Cormoran96](https://github.com/Cormoran96))

- Fixed E2E default room settings not being honoured ([#23468](https://github.com/RocketChat/Rocket.Chat/pull/23468) by [@TheDigitalEagle](https://github.com/TheDigitalEagle) & [@ostjen](https://github.com/ostjen))

- LDAP users being disabled when an AD security policy is enabled ([#23820](https://github.com/RocketChat/Rocket.Chat/pull/23820))

- LDAP users not being re-activated on login ([#23627](https://github.com/RocketChat/Rocket.Chat/pull/23627))

- Missing user roles in edit user tab ([#23734](https://github.com/RocketChat/Rocket.Chat/pull/23734))

- New specific endpoint for contactChatHistoryMessages with right permissions ([#23533](https://github.com/RocketChat/Rocket.Chat/pull/23533))

  Anyone with 'View Omnichannel Rooms' permission can see the History Messages.

- Notifications are not being filtered ([#23487](https://github.com/RocketChat/Rocket.Chat/pull/23487))

  - Add a migration to update the `Accounts_Default_User_Preferences_pushNotifications` setting's value to the `Accounts_Default_User_Preferences_mobileNotifications` setting's value;
   - Remove the `Accounts_Default_User_Preferences_mobileNotifications` setting (replaced by `Accounts_Default_User_Preferences_pushNotifications`);
   - Rename 'mobileNotifications' user's preference to 'pushNotifications'.

- Omnichannel business hours page breaking navigation ([#23595](https://github.com/RocketChat/Rocket.Chat/pull/23595) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

- Omnichannel contact center navigation ([#23691](https://github.com/RocketChat/Rocket.Chat/pull/23691))

  Derives from: https://github.com/RocketChat/Rocket.Chat/pull/23656

  This PR includes a different approach to solving navigation problems following the same code structure and UI definitions of other "ActionButtons" components in Sidebar.

- Omnichannel status being changed on page refresh ([#23587](https://github.com/RocketChat/Rocket.Chat/pull/23587))

- Omnichannel webhooks can't be saved ([#23641](https://github.com/RocketChat/Rocket.Chat/pull/23641) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

- Performance issues when running Omnichannel job queue dispatcher ([#23661](https://github.com/RocketChat/Rocket.Chat/pull/23661))

- PhotoSwipe crashing on show ([#23499](https://github.com/RocketChat/Rocket.Chat/pull/23499))

  Waits for initial content to load before showing it.

- Prevent UserAction.addStream without Subscription ([#23705](https://github.com/RocketChat/Rocket.Chat/pull/23705))

  When you take an Omnichannel chat from queue, the guest's typing information will appear.

- Registration not possible when any user is blocked for multiple failed logins ([#23565](https://github.com/RocketChat/Rocket.Chat/pull/23565) by [@ostjen](https://github.com/ostjen))

<details>
<summary>🔍 Minor changes</summary>


- Chore: add `no-bidi` rule ([#23695](https://github.com/RocketChat/Rocket.Chat/pull/23695))

- Chore: add index on appId + associations for apps_persistence collection ([#23675](https://github.com/RocketChat/Rocket.Chat/pull/23675))

- Chore: Api definitions ([#23701](https://github.com/RocketChat/Rocket.Chat/pull/23701))

- Chore: Bump Rocket.Chat@livechat to 1.10 ([#23768](https://github.com/RocketChat/Rocket.Chat/pull/23768))

- Chore: Convert Fiber models to async Step 1 ([#23633](https://github.com/RocketChat/Rocket.Chat/pull/23633))

- Chore: Generic Table  ([#23745](https://github.com/RocketChat/Rocket.Chat/pull/23745))

- Chore: Mocha testing configuration ([#23706](https://github.com/RocketChat/Rocket.Chat/pull/23706))

  We've been writing integration tests for the REST API quite regularly, but we can't say the same for UI-related modules. This PR is based on the assumption that _improving the developer experience on writing tests_ would increase our coverage and promote the adoption even for newcomers.

  Here as summary of the proposal:


  - Change Mocha configuration files:
    - Add a base configuration (`.mocharc.base.json`);
    - Rename the configuration for REST API tests (`mocha_end_to_end.opts.js -> .mocharc.api.js`);
    - Add a configuration for client modules (`.mocharc.client.js`);
    - Enable ESLint for them.

  - Add a Mocha test command exclusive for client modules (`npm run testunit-client`);

  - Enable fast watch mode:
    - Configure `ts-node` to only transpile code (skip type checking);
    - Define a list of files to be watched.

  - Configure `mocha` environment on ESLint only for test files (required when using Mocha's globals);

  - Adopt Chai as our assertion library:
    - Unify the setup of Chai plugins (`chai-spies`, `chai-datetime`, `chai-dom`);
    - Replace `assert` with `chai`;
    - Replace `chai.expect` with `expect`.

  - Enable integration tests with React components:
    - Enable JSX support on our default Babel configuration;
    - Adopt [testing library](https://testing-library.com/).

- Chore: Rearrange module typings ([#23452](https://github.com/RocketChat/Rocket.Chat/pull/23452))

  - Move all external module declarations (definitions and augmentations) to `/definition/externals`;

  - ~Symlink some modules on `/definition/externals` to `/ee/server/services/definition/externals`~ Share types with `/ee/server/services`;

  - Use TypeScript as server code entrypoint.

- Chore: Remove duplicated 'name' key from rate limiter logs ([#23771](https://github.com/RocketChat/Rocket.Chat/pull/23771))

- Chore: Remove useCallbacks ([#23696](https://github.com/RocketChat/Rocket.Chat/pull/23696))

- Chore: Type omnichannel models ([#23758](https://github.com/RocketChat/Rocket.Chat/pull/23758))

- Chore: Update settings.ts ([#23769](https://github.com/RocketChat/Rocket.Chat/pull/23769))

- i18n: Language update from LingoHub 🤖 on 2021-11-01Z ([#23603](https://github.com/RocketChat/Rocket.Chat/pull/23603))

- i18n: Language update from LingoHub 🤖 on 2021-11-29Z ([#23812](https://github.com/RocketChat/Rocket.Chat/pull/23812))

- Merge master into develop & Set version to 4.2.0-develop ([#23586](https://github.com/RocketChat/Rocket.Chat/pull/23586))

- Regression:  Units endpoint to TS ([#23757](https://github.com/RocketChat/Rocket.Chat/pull/23757))

- Regression: "When is the chat busier" and "Users by time of day" charts are not working ([#23815](https://github.com/RocketChat/Rocket.Chat/pull/23815))

  - Fix "When is the chat busier" (Hours) and "Users by time of day" charts, which weren't displaying any data;

- Regression: Add @rocket.chat/emitter to EE services ([#23802](https://github.com/RocketChat/Rocket.Chat/pull/23802))

- Regression: Add trash to raw models ([#23774](https://github.com/RocketChat/Rocket.Chat/pull/23774))

- Regression: Current Chats not Filtering ([#23803](https://github.com/RocketChat/Rocket.Chat/pull/23803))

- Regression: Fix incorrect API path for livechat calls ([#23778](https://github.com/RocketChat/Rocket.Chat/pull/23778))

- Regression: Fix LDAP sync route ([#23775](https://github.com/RocketChat/Rocket.Chat/pull/23775))

- Regression: Fix sendMessagesToAdmins not in Fiber ([#23770](https://github.com/RocketChat/Rocket.Chat/pull/23770))

- Regression: Fix sort param on omnichannel endpoints ([#23789](https://github.com/RocketChat/Rocket.Chat/pull/23789))

- Regression: Improve AggregationCursor types ([#23692](https://github.com/RocketChat/Rocket.Chat/pull/23692))

- Regression: Include files on EE services build ([#23793](https://github.com/RocketChat/Rocket.Chat/pull/23793))

- Regression: Mark Livechat WebRTC video calling as alpha ([#23813](https://github.com/RocketChat/Rocket.Chat/pull/23813))

  ![image](https://user-images.githubusercontent.com/34130764/143832378-82b99a72-23e8-4115-8b28-a0d210de598b.png)

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@Cormoran96](https://github.com/Cormoran96)
- [@Deepak-learner](https://github.com/Deepak-learner)
- [@Jeanstaquet](https://github.com/Jeanstaquet)
- [@TheDigitalEagle](https://github.com/TheDigitalEagle)
- [@bhardwajaditya](https://github.com/bhardwajaditya)
- [@dhruvjain99](https://github.com/dhruvjain99)
- [@ostjen](https://github.com/ostjen)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@cauefcr](https://github.com/cauefcr)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 4.1.6
`2022-06-02  ·  1 🐛  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`

### 🐛 Bug fixes


- Omnichannel managers can't join chats in progress ([#24553](https://github.com/RocketChat/Rocket.Chat/pull/24553))

<details>
<summary>🔍 Minor changes</summary>


- Regression: Fix in-correct room status shown to agents ([#24592](https://github.com/RocketChat/Rocket.Chat/pull/24592))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@murtaza98](https://github.com/murtaza98)
- [@renatobecker](https://github.com/renatobecker)

# 4.1.2
`2021-11-08  ·  3 🐛  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.1`

### 🐛 Bug fixes


- Notifications are not being filtered ([#23487](https://github.com/RocketChat/Rocket.Chat/pull/23487))

  - Add a migration to update the `Accounts_Default_User_Preferences_pushNotifications` setting's value to the `Accounts_Default_User_Preferences_mobileNotifications` setting's value;
   - Remove the `Accounts_Default_User_Preferences_mobileNotifications` setting (replaced by `Accounts_Default_User_Preferences_pushNotifications`);
   - Rename 'mobileNotifications' user's preference to 'pushNotifications'.

- Omnichannel status being changed on page refresh ([#23587](https://github.com/RocketChat/Rocket.Chat/pull/23587))

- Performance issues when running Omnichannel job queue dispatcher ([#23661](https://github.com/RocketChat/Rocket.Chat/pull/23661))

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@renatobecker](https://github.com/renatobecker)

# 4.1.1
`2021-11-05  ·  4 🐛  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.1`

### 🐛 Bug fixes


- Advanced LDAP Sync Features ([#23608](https://github.com/RocketChat/Rocket.Chat/pull/23608))

- App update flow failing in HA setups ([#23607](https://github.com/RocketChat/Rocket.Chat/pull/23607))

  The flow for app updates is broken in specific scenarios with HA setups. Here we change the method calls in the Apps-Engine to avoid race conditions

- LDAP users not being re-activated on login ([#23627](https://github.com/RocketChat/Rocket.Chat/pull/23627))

- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

### 👩‍💻👨‍💻 Core Team 🤓

- [@d-gubert](https://github.com/d-gubert)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.1.0
`2021-10-28  ·  1 🎉  ·  4 🚀  ·  25 🐛  ·  38 🔍  ·  23 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.0`

### 🎉 New features


- Stream to get individual presence updates ([#22950](https://github.com/RocketChat/Rocket.Chat/pull/22950))

### 🚀 Improvements


- Add markdown to custom fields in user Info ([#20947](https://github.com/RocketChat/Rocket.Chat/pull/20947))

  Added markdown to custom fields to render links

- Allow Omnichannel to handle huge queues  ([#23392](https://github.com/RocketChat/Rocket.Chat/pull/23392))

- Make Livechat Instructions setting multi-line ([#23515](https://github.com/RocketChat/Rocket.Chat/pull/23515))

  Since now we're supporting markdown text on this field (via this PR   - https://github.com/RocketChat/Rocket.Chat.Livechat/pull/648), it would be nice to make this setting multiline so users can have more space to edit the text
  ![image](https://user-images.githubusercontent.com/34130764/138146712-13e4968b-5312-4d53-b44c-b5699c5e49c1.png)

- optimized groups.listAll response time ([#22941](https://github.com/RocketChat/Rocket.Chat/pull/22941) by [@ostjen](https://github.com/ostjen))

  groups.listAll endpoint was having performance issues, specially when the total number of groups was high. This happened because the endpoint was loading all objects in memory then using splice to paginate, instead of paginating beforehand.

  Considering 70k groups, this was the performance improvement:

  before
  ![image](https://user-images.githubusercontent.com/28611993/129601314-bdf89337-79fa-4446-9f44-95264af4adb3.png)

  after
  ![image](https://user-images.githubusercontent.com/28611993/129601358-5872e166-f923-4c1c-b21d-eb9507365ecf.png)

### 🐛 Bug fixes


- **APPS:** Communication problem when updating and uninstalling apps in cluster ([#23418](https://github.com/RocketChat/Rocket.Chat/pull/23418))

  - Make the hook responsible for receiving app update events inside a cluster fetch the app's package (zip file) in the correct place.

  - Also shows a warning message on uninstalls inside a cluster. As there are many servers writing to the same place, some race conditions may occur. This prevents problems related to terminating the process in the middle due to errors being thrown and leaving the server in a faulty state.

- **ENTERPRISE:** Omnichannel agent is not leaving the room when a forwarded chat is queued ([#23404](https://github.com/RocketChat/Rocket.Chat/pull/23404))

- Admins can't update or reset user avatars when the "Allow User Avatar Change" setting is off ([#23228](https://github.com/RocketChat/Rocket.Chat/pull/23228))

  - Allow admins (or any other user with the `edit-other-user-avatar` permission) to update or reset user avatars even when the "Allow User Avatar Change" setting is off.

- Attachment buttons overlap in mobile view ([#23377](https://github.com/RocketChat/Rocket.Chat/pull/23377) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

- Avoid last admin deactivate itself ([#22949](https://github.com/RocketChat/Rocket.Chat/pull/22949) by [@ostjen](https://github.com/ostjen))

  Co-authored-by: @Kartik18g

- BigBlueButton integration error due to missing file import ([#23366](https://github.com/RocketChat/Rocket.Chat/pull/23366) by [@wolbernd](https://github.com/wolbernd))

  Fixes BigBlueButton integration

- Delay start of email inbox ([#23521](https://github.com/RocketChat/Rocket.Chat/pull/23521))

- imported migration v240 ([#23374](https://github.com/RocketChat/Rocket.Chat/pull/23374) by [@ostjen](https://github.com/ostjen))

- LDAP not stoping after wrong password ([#23382](https://github.com/RocketChat/Rocket.Chat/pull/23382))

- Markdown quote message style ([#23462](https://github.com/RocketChat/Rocket.Chat/pull/23462))

  Before:
  ![image](https://user-images.githubusercontent.com/17487063/137496669-3abecab4-cf90-45cb-8b1b-d9411a5682dd.png)

  After:
  ![image](https://user-images.githubusercontent.com/17487063/137496905-fd727f90-f707-4ec6-8139-ba2eb1a2146e.png)

- MONGO_OPTIONS being ignored for oplog connection ([#23314](https://github.com/RocketChat/Rocket.Chat/pull/23314) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- MongoDB deprecation link ([#23381](https://github.com/RocketChat/Rocket.Chat/pull/23381))

- OAuth login not working on mobile app ([#23541](https://github.com/RocketChat/Rocket.Chat/pull/23541))

- Omni-Webhook's retry mechanism going in infinite loop ([#23394](https://github.com/RocketChat/Rocket.Chat/pull/23394))

- Prevent starting Omni-Queue if Omnichannel is disabled ([#23396](https://github.com/RocketChat/Rocket.Chat/pull/23396))

  Whenever the Routing system setting changes, and omnichannel is disabled, then we shouldn't start the queue.

- Queue error handling and unlocking behavior ([#23522](https://github.com/RocketChat/Rocket.Chat/pull/23522))

- Read only description in team creation ([#23213](https://github.com/RocketChat/Rocket.Chat/pull/23213))

  ![image](https://user-images.githubusercontent.com/27704687/133608433-8ca788a3-71a8-4d40-8c40-8156ab03c606.png)

  ![image](https://user-images.githubusercontent.com/27704687/133608400-4cdc7a67-95e5-46c6-8c65-29ab107cd314.png)

- resumeToken not working ([#23379](https://github.com/RocketChat/Rocket.Chat/pull/23379))

- Rewrite missing webRTC feature ([#23172](https://github.com/RocketChat/Rocket.Chat/pull/23172))

- SAML Users' roles being reset to default on login ([#23411](https://github.com/RocketChat/Rocket.Chat/pull/23411))

  - Remove `roles` field update on `insertOrUpdateSAMLUser` function;

  - Add SAML `syncRoles` event;

- Server crashing when Routing method is not available at start ([#23473](https://github.com/RocketChat/Rocket.Chat/pull/23473))

- unwanted toastr error message when deleting user ([#23372](https://github.com/RocketChat/Rocket.Chat/pull/23372) by [@ostjen](https://github.com/ostjen))

- useEndpointAction replace by useEndpointActionExperimental ([#23469](https://github.com/RocketChat/Rocket.Chat/pull/23469))

- user/agent upload not working via Apps Engine after 3.16.0 ([#23393](https://github.com/RocketChat/Rocket.Chat/pull/23393))

  Fixes #22974

- Users' `roles` and `type` being reset to default on LDAP DataSync ([#23378](https://github.com/RocketChat/Rocket.Chat/pull/23378))

  - Update `roles` and `type` fields only if they are specified in the data imported from LDAP (otherwise, no changes are applied).

<details>
<summary>🔍 Minor changes</summary>


- Bump url-parse from 1.4.7 to 1.5.3 ([#23376](https://github.com/RocketChat/Rocket.Chat/pull/23376) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump: fuselage 0.30.1 ([#23391](https://github.com/RocketChat/Rocket.Chat/pull/23391))

- Chore: clean README ([#23342](https://github.com/RocketChat/Rocket.Chat/pull/23342) by [@AbhJ](https://github.com/AbhJ))

- Chore: Document REST API endpoints (banners) ([#23361](https://github.com/RocketChat/Rocket.Chat/pull/23361))

  Describes endpoints for banners on REST API using a JSDoc annotation compatible with OpenAPI spec.

- Chore: Document REST API endpoints (DNS) ([#23405](https://github.com/RocketChat/Rocket.Chat/pull/23405))

  Describes endpoints for DNS on REST API using a JSDoc annotation compatible with OpenAPI spec.

- Chore: Document REST API endpoints (E2E) ([#23430](https://github.com/RocketChat/Rocket.Chat/pull/23430))

  Describes endpoints for end-to-end encryption on REST API using a JSDoc annotation compatible with OpenAPI spec.

- Chore: Document REST API endpoints (Misc) ([#23428](https://github.com/RocketChat/Rocket.Chat/pull/23428))

  Describes miscellaneous endpoints on REST API using a JSDoc annotation compatible with OpenAPI spec.

- Chore: Ensure all permissions are created up to this point ([#23514](https://github.com/RocketChat/Rocket.Chat/pull/23514))

- Chore: Fix some TS warnings ([#23524](https://github.com/RocketChat/Rocket.Chat/pull/23524))

- Chore: Fixed a Typo in 11-admin.js test ([#23355](https://github.com/RocketChat/Rocket.Chat/pull/23355) by [@badbart](https://github.com/badbart))

- Chore: Improve watch OAuth settings logic ([#23505](https://github.com/RocketChat/Rocket.Chat/pull/23505))

  Just prevent to perform 200 deletions for registers that not even exist

- Chore: Make omnichannel settings dependent on omnichannel being enabled ([#23495](https://github.com/RocketChat/Rocket.Chat/pull/23495))

- Chore: Migrate some React components/hooks to TypeScript ([#23370](https://github.com/RocketChat/Rocket.Chat/pull/23370))

  Just low-hanging fruits.

- Chore: Move `addMinutesToADate` helper ([#23490](https://github.com/RocketChat/Rocket.Chat/pull/23490))

- Chore: Move `isEmail` helper ([#23489](https://github.com/RocketChat/Rocket.Chat/pull/23489))

- Chore: Move `isJSON` helper ([#23491](https://github.com/RocketChat/Rocket.Chat/pull/23491))

- Chore: Move components away from /app/ ([#23360](https://github.com/RocketChat/Rocket.Chat/pull/23360))

  We currently do NOT recommend placing React components under `/app`.

- Chore: Partially migrate 2FA client code to TypeScript ([#23419](https://github.com/RocketChat/Rocket.Chat/pull/23419))

  Additionally, hides `toastr` behind an module to handle UI's toast notifications.

- Chore: Remove dangling README file ([#23385](https://github.com/RocketChat/Rocket.Chat/pull/23385))

  Removes the elderly `server/restapi/README.md`.

- Chore: Replace `promises` helper ([#23488](https://github.com/RocketChat/Rocket.Chat/pull/23488))

- Chore: Startup Time ([#23210](https://github.com/RocketChat/Rocket.Chat/pull/23210))

  The settings logic has been improved as a whole.

  All the logic to get the data from the env var was confusing.

  Setting default values was tricky to understand.

  Every time the server booted, all settings were updated and callbacks were called 2x or more (horrible for environments with multiple instances and generating a turbulent startup).

  `Settings.get(......, callback);` was deprecated. We now have better methods for each case.

- Chore: Update Apps-Engine version ([#23375](https://github.com/RocketChat/Rocket.Chat/pull/23375))

- Chore: Update Livechat Package ([#23523](https://github.com/RocketChat/Rocket.Chat/pull/23523))

- Chore: Update pino and pino-pretty ([#23510](https://github.com/RocketChat/Rocket.Chat/pull/23510))

- Chore: Upgrade Storybook ([#23364](https://github.com/RocketChat/Rocket.Chat/pull/23364))

- i18n: Language update from LingoHub 🤖 on 2021-10-18Z ([#23486](https://github.com/RocketChat/Rocket.Chat/pull/23486))

- Merge master into develop & Set version to 4.1.0-develop ([#23362](https://github.com/RocketChat/Rocket.Chat/pull/23362))

- Regression: Debounce call based on params on omnichannel queue dispatch ([#23577](https://github.com/RocketChat/Rocket.Chat/pull/23577))

- Regression: Fix enterprise setting validation ([#23519](https://github.com/RocketChat/Rocket.Chat/pull/23519))

- Regression: Fix user typings style ([#23511](https://github.com/RocketChat/Rocket.Chat/pull/23511))

- Regression: Mail body contains `undefined` text ([#23552](https://github.com/RocketChat/Rocket.Chat/pull/23552))

  ### Before
  ![image](https://user-images.githubusercontent.com/2263066/138733018-10449892-5c2d-46fb-9355-00e98e0d6c9f.png)

  ### After
  ![image](https://user-images.githubusercontent.com/2263066/138733074-a1b88a77-bf64-41c3-a6c3-ac9e1cb63de1.png)

- Regression: Prevent settings from getting updated ([#23556](https://github.com/RocketChat/Rocket.Chat/pull/23556))

- Regression: Prevent Settings Unit Test Error  ([#23506](https://github.com/RocketChat/Rocket.Chat/pull/23506))

- Regression: Routing method not available when called from listeners at startup ([#23568](https://github.com/RocketChat/Rocket.Chat/pull/23568))

- Regression: Settings order ([#23528](https://github.com/RocketChat/Rocket.Chat/pull/23528))

- Regression: Waiting_queue setting not being applied due to missing module key ([#23531](https://github.com/RocketChat/Rocket.Chat/pull/23531))

- Regression: watchByRegex without Fibers ([#23529](https://github.com/RocketChat/Rocket.Chat/pull/23529))

- Update the community open call link in README ([#23497](https://github.com/RocketChat/Rocket.Chat/pull/23497))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@AbhJ](https://github.com/AbhJ)
- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)
- [@badbart](https://github.com/badbart)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@ostjen](https://github.com/ostjen)
- [@wolbernd](https://github.com/wolbernd)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@Sing-Li](https://github.com/Sing-Li)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 4.0.5
`2021-10-25  ·  1 🐛  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.0`

### 🐛 Bug fixes


- OAuth login not working on mobile app ([#23541](https://github.com/RocketChat/Rocket.Chat/pull/23541))

<details>
<summary>🔍 Minor changes</summary>


- Release 4.0.5 ([#23554](https://github.com/RocketChat/Rocket.Chat/pull/23554))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.0.4
`2021-10-21  ·  2 🐛  ·  1 🔍  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.0`

### 🐛 Bug fixes


- Queue error handling and unlocking behavior ([#23522](https://github.com/RocketChat/Rocket.Chat/pull/23522))

- SAML Users' roles being reset to default on login ([#23411](https://github.com/RocketChat/Rocket.Chat/pull/23411))

  - Remove `roles` field update on `insertOrUpdateSAMLUser` function;

  - Add SAML `syncRoles` event;

<details>
<summary>🔍 Minor changes</summary>


- Release 4.0.4 ([#23532](https://github.com/RocketChat/Rocket.Chat/pull/23532))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.0.3
`2021-10-18  ·  2 🐛  ·  1 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.0`

### 🐛 Bug fixes


- **APPS:** Communication problem when updating and uninstalling apps in cluster ([#23418](https://github.com/RocketChat/Rocket.Chat/pull/23418))

  - Make the hook responsible for receiving app update events inside a cluster fetch the app's package (zip file) in the correct place.

  - Also shows a warning message on uninstalls inside a cluster. As there are many servers writing to the same place, some race conditions may occur. This prevents problems related to terminating the process in the middle due to errors being thrown and leaving the server in a faulty state.

- Server crashing when Routing method is not available at start ([#23473](https://github.com/RocketChat/Rocket.Chat/pull/23473))

<details>
<summary>🔍 Minor changes</summary>


- Release 4.0.3 ([#23496](https://github.com/RocketChat/Rocket.Chat/pull/23496))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@thassiov](https://github.com/thassiov)

# 4.0.2
`2021-10-14  ·  4 🐛  ·  1 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.0`

### 🐛 Bug fixes


- **ENTERPRISE:** Omnichannel agent is not leaving the room when a forwarded chat is queued ([#23404](https://github.com/RocketChat/Rocket.Chat/pull/23404))

- Attachment buttons overlap in mobile view ([#23377](https://github.com/RocketChat/Rocket.Chat/pull/23377) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

- Prevent starting Omni-Queue if Omnichannel is disabled ([#23396](https://github.com/RocketChat/Rocket.Chat/pull/23396))

  Whenever the Routing system setting changes, and omnichannel is disabled, then we shouldn't start the queue.

- user/agent upload not working via Apps Engine after 3.16.0 ([#23393](https://github.com/RocketChat/Rocket.Chat/pull/23393))

  Fixes #22974

<details>
<summary>🔍 Minor changes</summary>


- Release 4.0.2 ([#23460](https://github.com/RocketChat/Rocket.Chat/pull/23460) by [@Aman-Maheshwari](https://github.com/Aman-Maheshwari))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Aman-Maheshwari](https://github.com/Aman-Maheshwari)

### 👩‍💻👨‍💻 Core Team 🤓

- [@murtaza98](https://github.com/murtaza98)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 4.0.1
`2021-10-06  ·  7 🐛  ·  2 🔍  ·  7 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.0`

### 🐛 Bug fixes


- BigBlueButton integration error due to missing file import ([#23366](https://github.com/RocketChat/Rocket.Chat/pull/23366) by [@wolbernd](https://github.com/wolbernd))

  Fixes BigBlueButton integration

- imported migration v240 ([#23374](https://github.com/RocketChat/Rocket.Chat/pull/23374) by [@ostjen](https://github.com/ostjen))

- LDAP not stoping after wrong password ([#23382](https://github.com/RocketChat/Rocket.Chat/pull/23382))

- MongoDB deprecation link ([#23381](https://github.com/RocketChat/Rocket.Chat/pull/23381))

- resumeToken not working ([#23379](https://github.com/RocketChat/Rocket.Chat/pull/23379))

- unwanted toastr error message when deleting user ([#23372](https://github.com/RocketChat/Rocket.Chat/pull/23372) by [@ostjen](https://github.com/ostjen))

- Users' `roles` and `type` being reset to default on LDAP DataSync ([#23378](https://github.com/RocketChat/Rocket.Chat/pull/23378))

  - Update `roles` and `type` fields only if they are specified in the data imported from LDAP (otherwise, no changes are applied).

<details>
<summary>🔍 Minor changes</summary>


- Chore: Update Apps-Engine version ([#23375](https://github.com/RocketChat/Rocket.Chat/pull/23375))

- Release 4.0.1 ([#23386](https://github.com/RocketChat/Rocket.Chat/pull/23386) by [@ostjen](https://github.com/ostjen) & [@wolbernd](https://github.com/wolbernd))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@ostjen](https://github.com/ostjen)
- [@wolbernd](https://github.com/wolbernd)

### 👩‍💻👨‍💻 Core Team 🤓

- [@d-gubert](https://github.com/d-gubert)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)

# 4.0.0
`2021-10-01  ·  15 ️️️⚠️  ·  4 🎉  ·  11 🚀  ·  24 🐛  ·  67 🔍  ·  26 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.6, 4.0, 4.2, 4.4, 5.0`
- Apps-Engine: `1.28.0-alpha.5428`

### ⚠️ BREAKING CHANGES


- **ENTERPRISE:** "Download CSV" button doesn't work in the Engagement Dashboard's Active Users section ([#23013](https://github.com/RocketChat/Rocket.Chat/pull/23013))

  - Fix "Download CSV" button in the Engagement Dashboard's Active Users section;

  - Add column headers to the CSV file downloaded from the Engagement Dashboard's Active Users section;

  - Split the data in multiple CSV files.

- **ENTERPRISE:** CSV file downloaded in the Engagement Dashboard's New Users section contains undefined data ([#23014](https://github.com/RocketChat/Rocket.Chat/pull/23014))

  - Fix CSV file downloaded in the Engagement Dashboard's New Users section;
   - Add column headers to the CSV file downloaded from the Engagement Dashboard's New Users section.

- **ENTERPRISE:** Missing headers in CSV files downloaded from the Engagement Dashboard ([#23223](https://github.com/RocketChat/Rocket.Chat/pull/23223))

  - Add headers to all CSV files downloaded from the "Messages" and "Channels" tabs from the Engagement Dashboard;
   - Add headers to the CSV file downloaded from the "Users by time of day" section (in the "Users" tab).

- LDAP Refactoring ([#23171](https://github.com/RocketChat/Rocket.Chat/pull/23171))

- Moved advanced oAuth features to EE ([#23201](https://github.com/RocketChat/Rocket.Chat/pull/23201) by [@ostjen](https://github.com/ostjen))

- Moved role-sync and advanced SAML settings to EE ([#23107](https://github.com/RocketChat/Rocket.Chat/pull/23107) by [@ostjen](https://github.com/ostjen))

- Moved SAML custom field map to EE ([#23319](https://github.com/RocketChat/Rocket.Chat/pull/23319) by [@ostjen](https://github.com/ostjen))

- Remove cordova compatibility setting ([#23302](https://github.com/RocketChat/Rocket.Chat/pull/23302) by [@ostjen](https://github.com/ostjen))

- Remove deprecated endpoints ([#23162](https://github.com/RocketChat/Rocket.Chat/pull/23162))

  The following REST endpoints were removed:


  - `/api/v1/emoji-custom`

  - `/api/v1/info`

  - `/api/v1/permissions`

  - `/api/v1/permissions.list`

  The following Real time API Methods were removed:


  - `getFullUserData`

  - `getServerInfo`

  - `livechat:saveOfficeHours`

- Remove Google Vision features ([#23160](https://github.com/RocketChat/Rocket.Chat/pull/23160))

  Google Vision features like "block adult images" or label detection were not being maintained and totally broken. So we decided to remove its feature and maybe in the future release the same features as an app.

- Remove old migrations up to version 2.4.14 ([#23277](https://github.com/RocketChat/Rocket.Chat/pull/23277))

  To update to version 4.0.0 you'll need to be running at least version 3.0.0, otherwise you might loose some database migrations which might have unexpected effects.

  This aims to clean up the code, since upgrades jumping 2 major versions are too risky and hard to maintain, we'll keep only migration from that last major (in this case 3.x).

- Remove patch info from endpoint /api/info for non-logged in users ([#16050](https://github.com/RocketChat/Rocket.Chat/pull/16050))

- Removed support of MongoDB 3.4; Deprecated MongoDB 3.6 and 4.0 ([#22907](https://github.com/RocketChat/Rocket.Chat/pull/22907) by [@ostjen](https://github.com/ostjen))

- Stop sending audio notifications via stream ([#23108](https://github.com/RocketChat/Rocket.Chat/pull/23108))

  Remove audio preferences and make them tied to desktop notification preferences.

  TL;DR: new message sounds will play only if you receive a desktop notification. you'll still be able to chose to not play any sound though

- Webhook will fail if user is not part of the channel ([#23310](https://github.com/RocketChat/Rocket.Chat/pull/23310))

  Remove deprecated behavior added by https://github.com/RocketChat/Rocket.Chat/pull/18024 that accepts webhook integrations sending messages even if the user is not part of the channel.

  Starting from 4.0.0 the webhook request will fail with `error-not-allowed` error:

  ```
  {"success":false,"error":"error-not-allowed"}
  ```

### 🎉 New features


- **APPS:** Get livechat's room transcript via bridge method ([#22985](https://github.com/RocketChat/Rocket.Chat/pull/22985))

  Adds a new method for retrieving a room's transcript via a new method in the Livechat bridge

- Add activity indicators for Uploading and Recording using new API; Support thread context; Deprecate the old typing API ([#22392](https://github.com/RocketChat/Rocket.Chat/pull/22392) by [@sumukhah](https://github.com/sumukhah))

- Omnichannel source identification fields ([#23090](https://github.com/RocketChat/Rocket.Chat/pull/23090))

  This PR adds new fields to the room schema that aids in the identification of the source that created an Omnichannel room, which can be either via livechat widget, SMS, app, etc.

- Seats Cap ([#23017](https://github.com/RocketChat/Rocket.Chat/pull/23017) by [@g-thome](https://github.com/g-thome))

  - Adding New Members
    - Awareness of seats usage while adding new members
    - Seats Cap about to be reached
    - Seats Cap reached
    - Request more seats

  - Warning Admins
    - System telling admins max seats are about to exceed
    - System telling admins max seats were exceed
    - Metric on Info Page
    - Request more seats

  - Warning Members
    - Invite link
      - Block creating new invite links
      - Block existing invite links (feedback on register process)
    - Register to Workspaces

  - Emails
    - System telling admins max seats are about to exceed
    - System telling admins max seats were exceed

### 🚀 Improvements


- **APPS:** New storage strategy for Apps-Engine file packages ([#22657](https://github.com/RocketChat/Rocket.Chat/pull/22657))

  This is an enabler for our initiative to support NPM packages in the Apps-Engine.

  Currently, the packages (zip files) for Rocket.Chat Apps are stored as a base64 encoded string in a document in the database, which constrains us due to the size limit of a document in MongoDB (16Mb).

  When we allow apps to include NPM packages, the size of the App package itself will be potentially _very large_ (I'm looking at you `node_modules`). Thus we'll be changing the strategy to store apps either with GridFS or the host's File System itself.

- **APPS:** Return task ids when using the scheduler api ([#23023](https://github.com/RocketChat/Rocket.Chat/pull/23023))

  In the methods that create tasks (`scheduleRecurring` and `scheduleOnce`) return the `id` of the document created in the database so the user can cancel each task individually.

- Add missing pt-BR translations, fix typos and unify language ([#23176](https://github.com/RocketChat/Rocket.Chat/pull/23176) by [@gabrieloliverio](https://github.com/gabrieloliverio))

- Better text for auth banner ([#23256](https://github.com/RocketChat/Rocket.Chat/pull/23256) by [@g-thome](https://github.com/g-thome))

  Change the text in the banner warning for auth changes

- Canned response admin settings ([#23190](https://github.com/RocketChat/Rocket.Chat/pull/23190))

- Change log format to JSON ([#22975](https://github.com/RocketChat/Rocket.Chat/pull/22975))

- Change occurences of Livechat to Omnichannel in ES translations were applicable ([#23199](https://github.com/RocketChat/Rocket.Chat/pull/23199))

- Do not re-create General room on every server start ([#22957](https://github.com/RocketChat/Rocket.Chat/pull/22957))

  - Check the `Show_Setup_Wizard` Setting's value to control whether the general room should be created. This channel will only be created if the `Show_Setup_Wizard` Setting is 'pending'.

- Load code highlighting languages on demand and fixes on new message parser ([#23232](https://github.com/RocketChat/Rocket.Chat/pull/23232))

  Now we have this setting called 'Code highlighting languages list' where you can define the languages that you want to be loaded by default.

- Throw error if no appId is provided to useUIKitHandleAction ([#23221](https://github.com/RocketChat/Rocket.Chat/pull/23221))

- Use PaginatedSelectFiltered in department edition ([#23054](https://github.com/RocketChat/Rocket.Chat/pull/23054))

### 🐛 Bug fixes


- "Parent channel or group" search in discussions' creation throws "Unexpected end of JSON input" error ([#23076](https://github.com/RocketChat/Rocket.Chat/pull/23076))

  - Use `encodeURIComponent()` to encode values received by `_generateQueryFromParams()`.

- "Read Only" and "Allow Reacting" system messages are missing in rooms ([#23037](https://github.com/RocketChat/Rocket.Chat/pull/23037) by [@ostjen](https://github.com/ostjen))

  - Add system message to notify changes on the **"Read Only"** setting;
   - Add system message to notify changes on the **"Allow Reacting"** setting;
   - Fix "Allow Reacting" setting's description (updated from "Only authorized users can write new messages" to "Only authorized users can react to messages").
  ![system-messages](https://user-images.githubusercontent.com/36537004/130883527-9eb47fcd-c8e5-41fb-af34-5d99bd0a6780.PNG)

- Add check before placing chat on-hold to confirm that contact sent last message ([#23053](https://github.com/RocketChat/Rocket.Chat/pull/23053))

- Add missing custom fields to apps' users converter ([#21176](https://github.com/RocketChat/Rocket.Chat/pull/21176) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Avoid bots to be marked as unavailable when log off/login ([#23262](https://github.com/RocketChat/Rocket.Chat/pull/23262))

- Can't edit profile information if any field update setting is disabled ([#23110](https://github.com/RocketChat/Rocket.Chat/pull/23110))

  - Check which fields have been updated before throwing errors in `validateUserEditing`.

- Inaccurate use of 'Mobile notifications' instead of 'Push notifications' in i18n strings ([#22978](https://github.com/RocketChat/Rocket.Chat/pull/22978) by [@ostjen](https://github.com/ostjen))

  - Fix inaccurate use of 'Mobile notifications' (which is misleading in German) by 'Push notifications';
   - Update `'Notification_Mobile_Default_For'` key to `'Notification_Push_Default_For'` (and text to 'Send Push Notifications For' for English Language);
   - Update `'Accounts_Default_User_Preferences_mobileNotifications'` key to `'Accounts_Default_User_Preferences_pushNotifications'`;
   - Update `'Mobile_Notifications_Default_Alert'` key to `'Mobile_Push_Notifications_Default_Alert'`;

- Logging out from other clients ([#23276](https://github.com/RocketChat/Rocket.Chat/pull/23276))

- Mark agents as unavailable when they logout ([#23219](https://github.com/RocketChat/Rocket.Chat/pull/23219))

- Modals is cutting pixels of the content ([#23243](https://github.com/RocketChat/Rocket.Chat/pull/23243))

  Fuselage Dependency: [543](https://github.com/RocketChat/Rocket.Chat.Fuselage/pull/543)
  ![image](https://user-images.githubusercontent.com/27704687/134049227-3cd1deed-34ba-454f-a95e-e99b79a7a7b9.png)

- Omnichannel On hold chats being forwarded to offline agents ([#23185](https://github.com/RocketChat/Rocket.Chat/pull/23185))

- Omnichannel transcript button without user's email ([#23150](https://github.com/RocketChat/Rocket.Chat/pull/23150))

- Prevent users to edit an existing role when adding a new one with the same name used before. ([#22407](https://github.com/RocketChat/Rocket.Chat/pull/22407) by [@lucassartor](https://github.com/lucassartor))

  ### before
  ![Peek 2021-07-13 16-31](https://user-images.githubusercontent.com/27704687/125513721-953d84f4-1c95-45ca-80e1-b00992b874f6.gif)

  ### after
  ![Peek 2021-07-13 16-34](https://user-images.githubusercontent.com/27704687/125514098-91ee8014-51e5-4c62-9027-5538acf57d08.gif)

- Remove doubled "Canned Responses" strings ([#23056](https://github.com/RocketChat/Rocket.Chat/pull/23056))

  - Remove doubled canned response setting introduced in #22703 (by setting id change);
   - Update "Canned Responses" keys to "Canned_Responses".

- Remove margin from quote inside quote ([#21779](https://github.com/RocketChat/Rocket.Chat/pull/21779))

  ![image](https://user-images.githubusercontent.com/17487063/116253926-4a89e600-a747-11eb-9172-f2ed1245fa1b.png)

- Save department agents  ([#23209](https://github.com/RocketChat/Rocket.Chat/pull/23209))

- Sidebar not closing when clicking in Home or Directory on mobile view ([#23218](https://github.com/RocketChat/Rocket.Chat/pull/23218))

  ### Additional fixed

  - Merge Burger menu components into a single component

  - Show a badge with no-read messages in the Burger Button:
  ![image](https://user-images.githubusercontent.com/27704687/133679378-20fea2c0-4ac1-4b4e-886e-45154cc6afea.png)

  - remove useSidebarClose hook

- Stop queue when Omnichannel is disabled or the routing method does not support it ([#23261](https://github.com/RocketChat/Rocket.Chat/pull/23261))

  - Add missing key logs

  - Stop queue (and logs) when livechat is disabled or when routing method does not support queue

  - Stop ignoring offline bot agents from delegation (previously, if a bot was offline, even with "Assign new conversations to bot agent" enabled, bot will be ignored and chat will be left in limbo (since bot was assigned, but offline).

- Toolbox click not working on Safari(iOS) ([#23244](https://github.com/RocketChat/Rocket.Chat/pull/23244))

- transfer message when tranferring room by Apps Engine ([#23074](https://github.com/RocketChat/Rocket.Chat/pull/23074) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Update bugsnag package ([#23104](https://github.com/RocketChat/Rocket.Chat/pull/23104))

- User list not being updated after creation/deletion of user ([#23032](https://github.com/RocketChat/Rocket.Chat/pull/23032) by [@ostjen](https://github.com/ostjen))

- Wrap canned-responses endpoints with ee license ([#23204](https://github.com/RocketChat/Rocket.Chat/pull/23204))

- Wrong docs link on Omni-Webhook page ([#23117](https://github.com/RocketChat/Rocket.Chat/pull/23117))

<details>
<summary>🔍 Minor changes</summary>


- Bump @rocket.chat/string-helpers from 0.27.0 to 0.29.0 in /ee/server/services ([#23138](https://github.com/RocketChat/Rocket.Chat/pull/23138) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @storybook/react from 6.3.6 to 6.3.8 ([#23165](https://github.com/RocketChat/Rocket.Chat/pull/23165) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/cookie from 0.4.0 to 0.4.1 in /ee/server/services ([#22600](https://github.com/RocketChat/Rocket.Chat/pull/22600) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ejson from 2.1.2 to 2.1.3 in /ee/server/services ([#23126](https://github.com/RocketChat/Rocket.Chat/pull/23126) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/express from 4.17.12 to 4.17.13 in /ee/server/services ([#22598](https://github.com/RocketChat/Rocket.Chat/pull/22598) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/imap from 0.8.34 to 0.8.35 ([#23122](https://github.com/RocketChat/Rocket.Chat/pull/23122) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump @types/ws from 7.4.6 to 7.4.7 in /ee/server/services ([#23095](https://github.com/RocketChat/Rocket.Chat/pull/23095) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump actions/stale from 3.0.19 to 4 ([#22673](https://github.com/RocketChat/Rocket.Chat/pull/22673) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump csv-parse from 4.16.0 to 4.16.3 ([#23120](https://github.com/RocketChat/Rocket.Chat/pull/23120) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ejson from 2.2.1 to 2.2.2 in /ee/server/services ([#23236](https://github.com/RocketChat/Rocket.Chat/pull/23236) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump iconv-lite from 0.4.24 to 0.6.3 ([#22527](https://github.com/RocketChat/Rocket.Chat/pull/22527) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump image-size from 0.6.3 to 1.0.0 ([#22528](https://github.com/RocketChat/Rocket.Chat/pull/22528) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump ip-range-check from 0.0.2 to 0.2.0 ([#22532](https://github.com/RocketChat/Rocket.Chat/pull/22532) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump jsrsasign from 10.3.0 to 10.4.0 ([#23163](https://github.com/RocketChat/Rocket.Chat/pull/23163) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump juice from 5.2.0 to 8.0.0 ([#22177](https://github.com/RocketChat/Rocket.Chat/pull/22177) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump object-path from 0.11.5 to 0.11.6 ([#23088](https://github.com/RocketChat/Rocket.Chat/pull/23088) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump pm2 from 5.1.0 to 5.1.1 in /ee/server/services ([#23128](https://github.com/RocketChat/Rocket.Chat/pull/23128) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump stylelint-order from 2.2.1 to 4.1.0 ([#22036](https://github.com/RocketChat/Rocket.Chat/pull/22036) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump supertest from 6.1.3 to 6.1.6 ([#23139](https://github.com/RocketChat/Rocket.Chat/pull/23139) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump tar from 6.1.0 to 6.1.11 in /ee/server/services ([#23068](https://github.com/RocketChat/Rocket.Chat/pull/23068) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump xml-crypto from 2.1.2 to 2.1.3 ([#23141](https://github.com/RocketChat/Rocket.Chat/pull/23141) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Chore: Change Ubuntu version to 20.04 on all GitHub Actions ([#23200](https://github.com/RocketChat/Rocket.Chat/pull/23200))

- Chore: client endpoints typings ([#23152](https://github.com/RocketChat/Rocket.Chat/pull/23152))

- Chore: Convert VerticalBar component to typescript ([#22542](https://github.com/RocketChat/Rocket.Chat/pull/22542))

- Chore: Environmental variable for marketplace url ([#22922](https://github.com/RocketChat/Rocket.Chat/pull/22922))

- Chore: Make SMTP empty on docker-compose so registration won't hang out of the box ([#23255](https://github.com/RocketChat/Rocket.Chat/pull/23255))

- Chore: Move client helpers ([#23178](https://github.com/RocketChat/Rocket.Chat/pull/23178))

  Moves helper modules under `app/` to `client/lib/utils/`.

- Chore: Re-enable session tests on local after removal of mongo-unit ([#23263](https://github.com/RocketChat/Rocket.Chat/pull/23263))

- Chore: Remove non-used dependencies ([#23109](https://github.com/RocketChat/Rocket.Chat/pull/23109))

- Chore: Remove wrong usages of `Meteor.wrapAsync` ([#23079](https://github.com/RocketChat/Rocket.Chat/pull/23079))

- Chore: Update Livechat widget to 1.9.4 ([#23198](https://github.com/RocketChat/Rocket.Chat/pull/23198))

- Chore: Update pino and pino-pretty ([#23269](https://github.com/RocketChat/Rocket.Chat/pull/23269))

- Chore: Update pino and pino-pretty ([#23157](https://github.com/RocketChat/Rocket.Chat/pull/23157))

- Chore: Upgrade limax ([#23187](https://github.com/RocketChat/Rocket.Chat/pull/23187))

  Upgrades `limax` for faster slugify algorithm.

- i18n: Language update from LingoHub 🤖 on 2021-08-30Z ([#23061](https://github.com/RocketChat/Rocket.Chat/pull/23061))

- i18n: Language update from LingoHub 🤖 on 2021-09-06Z ([#23123](https://github.com/RocketChat/Rocket.Chat/pull/23123))

- i18n: Language update from LingoHub 🤖 on 2021-09-13Z ([#23184](https://github.com/RocketChat/Rocket.Chat/pull/23184))

- Merge master into develop & Set version to 4.0.0 ([#23086](https://github.com/RocketChat/Rocket.Chat/pull/23086))

- Regression: "Join" button not working ([#23320](https://github.com/RocketChat/Rocket.Chat/pull/23320))

- Regression: `renderEmoji` helper referred as a template ([#23212](https://github.com/RocketChat/Rocket.Chat/pull/23212))

- Regression: Add default value when no cookies are present ([#23318](https://github.com/RocketChat/Rocket.Chat/pull/23318))

- Regression: Blank screen in Jitsi video calls ([#23322](https://github.com/RocketChat/Rocket.Chat/pull/23322))

  - Fix Jitsi calls being disposed even when "Open in new window" setting is disabled;
   - Fix misspelling on `CallJitsWithData.js` file name.

- Regression: Create new loggers based on server log level ([#23297](https://github.com/RocketChat/Rocket.Chat/pull/23297))

- Regression: Fix app storage migration ([#23286](https://github.com/RocketChat/Rocket.Chat/pull/23286))

  The previous version of this migration didn't take into consideration apps that were installed prior to [Rocket.Chat@3.8.0](https://github.com/RocketChat/Rocket.Chat/releases/tag/3.8.0), which [removed the typescript compiler from the server](https://github.com/RocketChat/Rocket.Chat/pull/18687) and into the CLI. As a result, the zip files inside each installed app's document in the database had typescript files in them instead of the now required javascript files.

  As the new strategy of source code storage for apps changes the way the app is loaded, those zip files containing the source code are read everytime the app is started (or [in this particular case, updated](https://github.com/RocketChat/Rocket.Chat/pull/23286/files#diff-caf9f7a22478639e58d6514be039140a42ce1ab2d999c3efe5678c38ee36d0ccR43)), and as the zips' contents were wrong, the operation was failing.

  The fix extract the data from old apps and creates new zip files with the compiled `js` already present.

- Regression: Fix Bugsnag not started error ([#23308](https://github.com/RocketChat/Rocket.Chat/pull/23308))

- Regression: Fix channel icons on queue ([#23304](https://github.com/RocketChat/Rocket.Chat/pull/23304))

- Regression: Fix user registration stuck ([#23254](https://github.com/RocketChat/Rocket.Chat/pull/23254))

- Regression: Fix view logs admin screen ([#23194](https://github.com/RocketChat/Rocket.Chat/pull/23194))

- Regression: invalid `call` import ([#23328](https://github.com/RocketChat/Rocket.Chat/pull/23328))

- Regression: invalid `call` import ([#23334](https://github.com/RocketChat/Rocket.Chat/pull/23334))

- Regression: LDAP Channel/Role Sync not working ([#23311](https://github.com/RocketChat/Rocket.Chat/pull/23311))

- Regression: LDAP Issues ([#23306](https://github.com/RocketChat/Rocket.Chat/pull/23306))

- Regression: LDAP Refactoring ([#23231](https://github.com/RocketChat/Rocket.Chat/pull/23231))

- Regression: LDAP User Data Sync not always working ([#23321](https://github.com/RocketChat/Rocket.Chat/pull/23321))

- Regression: LDAP: Handle base authentication and prevent crash ([#23331](https://github.com/RocketChat/Rocket.Chat/pull/23331))

  When AD requires TLS the auth crashes the server if StartTLS is not set, the error shows at the end because the code was not waiting on this operation.

- Regression: Log Sections not respecting Log Level setting ([#23230](https://github.com/RocketChat/Rocket.Chat/pull/23230))

- Regression: Missing i18n key ([#23282](https://github.com/RocketChat/Rocket.Chat/pull/23282))

- Regression: Properly trickle-down state from UsersPage to UsersTable ([#23196](https://github.com/RocketChat/Rocket.Chat/pull/23196))

  Spotted by @gabriellsh.

- Regression: Removed exclusive tests statement ([#23333](https://github.com/RocketChat/Rocket.Chat/pull/23333) by [@ostjen](https://github.com/ostjen))

- Regression: Request seats link ([#23312](https://github.com/RocketChat/Rocket.Chat/pull/23312))

- Regression: Request seats url ([#23317](https://github.com/RocketChat/Rocket.Chat/pull/23317))

- Regression: SAML identifier mapping ([#23330](https://github.com/RocketChat/Rocket.Chat/pull/23330))

- Regression: Seats Cap banner not being disabled if not enterprise ([#23278](https://github.com/RocketChat/Rocket.Chat/pull/23278))

- Regression: View Logs administration page crashing ([#23205](https://github.com/RocketChat/Rocket.Chat/pull/23205))

  Fixes the `stdout.queue` endpoint; makes the components type-safe.

- Regression: wrong settings order ([#23281](https://github.com/RocketChat/Rocket.Chat/pull/23281))

- Release 3.18.1 ([#23135](https://github.com/RocketChat/Rocket.Chat/pull/23135) by [@g-thome](https://github.com/g-thome))

- Release 3.18.2 ([#23338](https://github.com/RocketChat/Rocket.Chat/pull/23338))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@g-thome](https://github.com/g-thome)
- [@gabrieloliverio](https://github.com/gabrieloliverio)
- [@lucassartor](https://github.com/lucassartor)
- [@ostjen](https://github.com/ostjen)
- [@sumukhah](https://github.com/sumukhah)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MarcosSpessatto](https://github.com/MarcosSpessatto)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@casalsgh](https://github.com/casalsgh)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@graywolf336](https://github.com/graywolf336)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 3.18.7
`2022-05-30  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- MongoDB: `3.4, 3.6, 4.0, 4.2`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 3.18.6
`2022-05-26  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- MongoDB: `3.4, 3.6, 4.0, 4.2`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 3.18.2
`2021-10-01  ·  2 🐛  ·  2 🔍  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

- Update visitor info on email reception based on current inbox settings ([#23280](https://github.com/RocketChat/Rocket.Chat/pull/23280))

<details>
<summary>🔍 Minor changes</summary>


- Regression: Change some logs to new format ([#23307](https://github.com/RocketChat/Rocket.Chat/pull/23307))

- Release 3.18.2 ([#23338](https://github.com/RocketChat/Rocket.Chat/pull/23338))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.18.1
`2021-09-06  ·  1 🚀  ·  1 🐛  ·  2 🔍  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

### 🚀 Improvements


- Change HTTP and Method logs to level INFO ([#23100](https://github.com/RocketChat/Rocket.Chat/pull/23100))

### 🐛 Bug fixes


- Change way emails are validated on livechat registerGuest method ([#23089](https://github.com/RocketChat/Rocket.Chat/pull/23089))

<details>
<summary>🔍 Minor changes</summary>


- Regression: Auth banner for EE ([#23091](https://github.com/RocketChat/Rocket.Chat/pull/23091) by [@g-thome](https://github.com/g-thome))

  Dimisses auth banners assigned to EE admins and prevents new ones from appearing.

- Release 3.18.1 ([#23135](https://github.com/RocketChat/Rocket.Chat/pull/23135) by [@g-thome](https://github.com/g-thome))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@g-thome](https://github.com/g-thome)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@casalsgh](https://github.com/casalsgh)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.18.0
`2021-08-31  ·  5 🎉  ·  7 🚀  ·  20 🐛  ·  19 🔍  ·  25 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

### 🎉 New features


- **ENTERPRISE:** Maximum waiting time for chats in Omnichannel queue ([#22955](https://github.com/RocketChat/Rocket.Chat/pull/22955))

  - Add new settings to support closing chats that have been too long on waiting queue

  - Moved old settings to new "Queue Management" section

  - Fix issue when closing a livechat room that caused client to not to know if room was open or not

- Banner for the updates regarding authentication services ([#23055](https://github.com/RocketChat/Rocket.Chat/pull/23055) by [@g-thome](https://github.com/g-thome))

  Add a banner to inform admins about future authentication changes. This banner targets servers that use some sort of authentication service since they're the ones which this update concerns the most.

- Report "Read Receipts" setting on stat collector ([#23033](https://github.com/RocketChat/Rocket.Chat/pull/23033))

- REST endpoint to delete a DM and allow DM for two other users ([#18022](https://github.com/RocketChat/Rocket.Chat/pull/18022) by [@abrom](https://github.com/abrom))

  [NEW] Improve DM create/delete API management

- Separate RegEx Settings for Channels and Usernames validation ([#21937](https://github.com/RocketChat/Rocket.Chat/pull/21937) by [@aditya-mitra](https://github.com/aditya-mitra))

  Now, there are 2 separate settings for validating names   - One for **channels** and another for **usernames**.

  This change also removes the old `UTF8_Names_Validation` setting and adds 2 new settings `UTF8_User_Names_Validation` and `UTF8_Channel_Names_Validation`.

  https://user-images.githubusercontent.com/55396651/116969904-af5bb800-acd4-11eb-9fc4-dacac60cb08f.mp4

### 🚀 Improvements


- Add default permission 'start-discussion' and 'start-discussion-other-user' to app user ([#22577](https://github.com/RocketChat/Rocket.Chat/pull/22577))

- Create thumbnails from uploaded images ([#20907](https://github.com/RocketChat/Rocket.Chat/pull/20907))

- Exclude archived rooms from unread-message count ([#22515](https://github.com/RocketChat/Rocket.Chat/pull/22515) by [@nmagedman](https://github.com/nmagedman))

- Increase the verbosity of Omnichannel routing system debugging outputs ([#22977](https://github.com/RocketChat/Rocket.Chat/pull/22977))

- Rewrite File Upload Modal ([#22750](https://github.com/RocketChat/Rocket.Chat/pull/22750))

  Image preview:
  ![image](https://user-images.githubusercontent.com/40830821/127223432-dccd2182-aec0-430f-8d70-03ac88aec791.png)

  Video preview:
  ![image](https://user-images.githubusercontent.com/40830821/127225982-f8b21840-0d9c-4aff-a354-16188c7ed66e.png)

  Files larger than 10mb:
  ![image](https://user-images.githubusercontent.com/40830821/127222611-5265040f-a06b-4ec5-b528-89b40e6a9072.png)

- Types from currentChatsPage.tsx ([#22967](https://github.com/RocketChat/Rocket.Chat/pull/22967))

- Use tag autocomplete in more places ([#22902](https://github.com/RocketChat/Rocket.Chat/pull/22902))

  Use the proper autocomplete component for omnichannel tags, this adds proper sorting of results and better consistency.

### 🐛 Bug fixes


- "Read Only" field description is incorrect when the option is checked ([#21868](https://github.com/RocketChat/Rocket.Chat/pull/21868) by [@epif4nio](https://github.com/epif4nio))

- "Users By Time of the Day" chart displays incorrect data for Local Timezone ([#22836](https://github.com/RocketChat/Rocket.Chat/pull/22836))

  - Add local timezone conversion to the "Users By Time of the Day" chart in the Engagement Dashboard;
   - Simplify date creations by using `endOf` and `startOf` methods.

- Atlassian Crowd connection not working ([#22996](https://github.com/RocketChat/Rocket.Chat/pull/22996) by [@piotrkochan](https://github.com/piotrkochan))

- Audio recording doesn't stop in direct messages on channel switch ([#22880](https://github.com/RocketChat/Rocket.Chat/pull/22880))

  - Cancel audio recordings on message bar destroy event.
  ![test-22372](https://user-images.githubusercontent.com/36537004/128569780-d83747b0-fb9c-4dc6-9bc5-7ae573e720c8.gif)

- Bad words falling if message is empty ([#22930](https://github.com/RocketChat/Rocket.Chat/pull/22930))

- Broken download link on uploaded files ([#22848](https://github.com/RocketChat/Rocket.Chat/pull/22848) by [@ostjen](https://github.com/ostjen))

  Uploaded files had wrong download links when the deploy had a sub directory. This misbehavior was caused by the wrong usage of the rtrim method, the 2nd parameter is a list of chars, [not a string](https://www.php.net/manual/pt_BR/function.rtrim.php) (this method was inspired by php)

- Can't access other administration menus after opening Engagement Dashboard ([#22870](https://github.com/RocketChat/Rocket.Chat/pull/22870) by [@ostjen](https://github.com/ostjen))

- Go command duplicating subfolder path on iframes. ([#22796](https://github.com/RocketChat/Rocket.Chat/pull/22796) by [@ostjen](https://github.com/ostjen))

- Manually approve new users is not applied to SAML users ([#22823](https://github.com/RocketChat/Rocket.Chat/pull/22823) by [@ostjen](https://github.com/ostjen))

- Production-environment dependencies ([#22868](https://github.com/RocketChat/Rocket.Chat/pull/22868))

  `@rocket.chat/icons` was incorrectly referred as development dependency.

- QuickActions for mobile screen ([#23016](https://github.com/RocketChat/Rocket.Chat/pull/23016))

- Registration not possible with TOTP and email verification ([#22778](https://github.com/RocketChat/Rocket.Chat/pull/22778) by [@ostjen](https://github.com/ostjen))

- Return transcript/dashboards based on timezone settings ([#22850](https://github.com/RocketChat/Rocket.Chat/pull/22850))

  - Added new setting to manage timezones

  - Applied new setting to omnichannel dashboards (realtime, analytics) [NOTE: Other dashboards aren't using this setting actually)

  - Change getAnalyticsBetweenDate query to filter out system messages instead of substracting them

- Tab margin style ([#22851](https://github.com/RocketChat/Rocket.Chat/pull/22851))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/128103848-2a25ba7e-0e59-4502-9bcd-2569cad9379a.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/128103633-ec7b93fc-4667-4dc9-bad3-bfffaff3974e.png)

- Threads and discussions searches don't display proper results ([#22914](https://github.com/RocketChat/Rocket.Chat/pull/22914))

  - _Fix_ issue in discussions search (which wasn't working after a search with no results was made);
   - _Improve_ discussions and threads searches: both searches (`chat.getDiscussions` and `chat.getThreadsList`) are now case insensitive (do NOT differ capital from lower letters) and match incomplete words or terms.

- Threads List being requested more than expected ([#22879](https://github.com/RocketChat/Rocket.Chat/pull/22879))

- TypeError on Callout type prop ([#22790](https://github.com/RocketChat/Rocket.Chat/pull/22790) by [@hrahul2605](https://github.com/hrahul2605))

- User is still asked for 2FA confirmation even if it is deactivated ([#22801](https://github.com/RocketChat/Rocket.Chat/pull/22801) by [@ostjen](https://github.com/ostjen))

- User presence being processes even if presence monitor was disabled ([#22927](https://github.com/RocketChat/Rocket.Chat/pull/22927))

- users registered via third party apps bypass custom required fields ([#22396](https://github.com/RocketChat/Rocket.Chat/pull/22396) by [@g-thome](https://github.com/g-thome))

  moves the custom fields from the initial registration form to the "pick a username" screen so that everyone is forced to fill the custom required fields

<details>
<summary>🔍 Minor changes</summary>


- Bump: Fuselage 0.29.0 ([#23067](https://github.com/RocketChat/Rocket.Chat/pull/23067))

- Chore: Enable husky pre-push hook (back again) ([#22994](https://github.com/RocketChat/Rocket.Chat/pull/22994))

- Chore: Fix RHEL container build issue due to gpg keyserver deprecation ([#22672](https://github.com/RocketChat/Rocket.Chat/pull/22672) by [@jsm84](https://github.com/jsm84))

  Changed gpg keyserver in RHEL Dockerfile to openpgp.org due to deprecation of the SKS keyserver network.

- Chore: Fix typo in rtl.css ([#22431](https://github.com/RocketChat/Rocket.Chat/pull/22431) by [@eltociear](https://github.com/eltociear))

- Chore: Prevent new JS files being added ([#22972](https://github.com/RocketChat/Rocket.Chat/pull/22972))

  We are moving our code base to TS, one way to help developers remember this is create a task that will notify you every time a new file is created.

- Chore: Script to start Rocket.Chat in HA mode during development ([#22398](https://github.com/RocketChat/Rocket.Chat/pull/22398))

  Sometimes we need to start Rocket.Chat in High-Availability mode (cluster) during development to test how a feature behaves or hunt down a bug. Currently, this involves a lot of commands with details that might be lost if you haven't done it in a while.

  This PR intends to provide a really simple way for us to start many instances of Rocket.Chat connected in a cluster.

- Chore: Update Livechat widget to 1.9.4 ([#22990](https://github.com/RocketChat/Rocket.Chat/pull/22990))

- i18n: Language update from LingoHub 🤖 on 2021-08-09Z ([#22888](https://github.com/RocketChat/Rocket.Chat/pull/22888))

- i18n: Language update from LingoHub 🤖 on 2021-08-16Z ([#22937](https://github.com/RocketChat/Rocket.Chat/pull/22937))

- i18n: Language update from LingoHub 🤖 on 2021-08-23Z ([#23007](https://github.com/RocketChat/Rocket.Chat/pull/23007))

- Merge master into develop & Set version to 3.18.0-develop ([#22834](https://github.com/RocketChat/Rocket.Chat/pull/22834))

- Regression: Attachment not rendering on message ([#23046](https://github.com/RocketChat/Rocket.Chat/pull/23046))

- Regression: File upload name suggestion ([#22953](https://github.com/RocketChat/Rocket.Chat/pull/22953))

  Before:
  ![image](https://user-images.githubusercontent.com/40830821/129774936-ecdbe9a1-5e3f-4a0a-ad1e-6f13eb15c60b.png)
  ![image](https://user-images.githubusercontent.com/40830821/129775011-fb0df01d-74e4-41ae-bb47-dcf4cc17735e.png)


  After:
  ![image](https://user-images.githubusercontent.com/40830821/129774877-928a8aa0-c003-4e57-8b33-ea6accc32774.png)
  ![image](https://user-images.githubusercontent.com/40830821/129774972-d67debaf-0ce9-44fb-93cb-d7612dd18edf.png)

- Regression: Fix creation of self-DMs ([#23015](https://github.com/RocketChat/Rocket.Chat/pull/23015))

- Regression: Logs were missing from Omnichannel callback methods ([#23048](https://github.com/RocketChat/Rocket.Chat/pull/23048))

- Regression: no-js-action bump version ([#22997](https://github.com/RocketChat/Rocket.Chat/pull/22997))

- Regression: readNow blocked by a invalid condition ([#22952](https://github.com/RocketChat/Rocket.Chat/pull/22952))

- Release 3.17.1 ([#22942](https://github.com/RocketChat/Rocket.Chat/pull/22942))

- Release 3.17.2 ([#23045](https://github.com/RocketChat/Rocket.Chat/pull/23045))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@abrom](https://github.com/abrom)
- [@aditya-mitra](https://github.com/aditya-mitra)
- [@eltociear](https://github.com/eltociear)
- [@epif4nio](https://github.com/epif4nio)
- [@g-thome](https://github.com/g-thome)
- [@hrahul2605](https://github.com/hrahul2605)
- [@jsm84](https://github.com/jsm84)
- [@nmagedman](https://github.com/nmagedman)
- [@ostjen](https://github.com/ostjen)
- [@piotrkochan](https://github.com/piotrkochan)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@marceloschmidt](https://github.com/marceloschmidt)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 3.17.2
`2021-08-26  ·  3 🐛  ·  1 🔍  ·  5 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

### 🐛 Bug fixes


- applyChatRestictions callback not working for community version ([#22839](https://github.com/RocketChat/Rocket.Chat/pull/22839) by [@Shailesh351](https://github.com/Shailesh351))

  Building on top of https://github.com/RocketChat/Rocket.Chat/pull/22838

- Error getting default agent when routing system algorithm is Auto Selection ([#22976](https://github.com/RocketChat/Rocket.Chat/pull/22976))

- Fix Auto Selection algorithm on community edition ([#22991](https://github.com/RocketChat/Rocket.Chat/pull/22991))

  - When using the autoselection algo on community editions, all agents were marked as unavailable due to an unapplied filter

  - Fixed an issue when both user & system setting to manange EE max number of chats allowed were set to 0

<details>
<summary>🔍 Minor changes</summary>


- Release 3.17.2 ([#23045](https://github.com/RocketChat/Rocket.Chat/pull/23045))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Shailesh351](https://github.com/Shailesh351)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@murtaza98](https://github.com/murtaza98)
- [@renatobecker](https://github.com/renatobecker)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.17.1
`2021-08-16  ·  5 🐛  ·  1 🔍  ·  8 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

### 🐛 Bug fixes


- "Click to Join" button is not working if there are no muted users in the room ([#22871](https://github.com/RocketChat/Rocket.Chat/pull/22871))

  - Add check to `room.muted` array so as to cover the case in which it is `undefined`;

- Apps-Engine's scheduler failing to update run tasks ([#22882](https://github.com/RocketChat/Rocket.Chat/pull/22882))

  [Agenda](https://github.com/agenda/agenda), the library that manages scheduling, depended on setting a job property named `nextRunAt` as `undefined` to signal whether it should be run on schedule or not. [Rocket.Chat's current Mongo driver](https://github.com/RocketChat/Rocket.Chat/pull/22399) ignores `undefined` values when updating documents and this was causing jobs to never stop running as Agenda couldn't clear that property (set them as `undefined`).
  This updates Rocket.Chat's dependency on Agenda.js to point to [a fork that fixes the problem](https://github.com/RocketChat/agenda/releases/tag/3.1.2).

- Close omnichannel conversations when agent is deactivated ([#22917](https://github.com/RocketChat/Rocket.Chat/pull/22917))

- Message update not working in some cases ([#22856](https://github.com/RocketChat/Rocket.Chat/pull/22856))

- Use correct param on saveBusinessHour method ([#22835](https://github.com/RocketChat/Rocket.Chat/pull/22835))

<details>
<summary>🔍 Minor changes</summary>


- Release 3.17.1 ([#22942](https://github.com/RocketChat/Rocket.Chat/pull/22942))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@d-gubert](https://github.com/d-gubert)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@renatobecker](https://github.com/renatobecker)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)

# 3.17.0
`2021-07-30  ·  7 🎉  ·  19 🚀  ·  39 🐛  ·  56 🔍  ·  28 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

### 🎉 New features


- `roles.delete` endpoint ([#22497](https://github.com/RocketChat/Rocket.Chat/pull/22497) by [@lucassartor](https://github.com/lucassartor))

- Collect data about LDAP, SAML, CAS and OAuth usage. ([#22719](https://github.com/RocketChat/Rocket.Chat/pull/22719))

- Convert Team to Channel ([#22476](https://github.com/RocketChat/Rocket.Chat/pull/22476))

  ![image](https://user-images.githubusercontent.com/27704687/123525502-8558bd80-d6a7-11eb-8211-12633cb3b5c6.png)

- Federation setup ([#22208](https://github.com/RocketChat/Rocket.Chat/pull/22208) by [@g-thome](https://github.com/g-thome))

- Logout other user endpoint ([#22661](https://github.com/RocketChat/Rocket.Chat/pull/22661) by [@ostjen](https://github.com/ostjen))

- Monitoring Track messages' round trip time ([#22676](https://github.com/RocketChat/Rocket.Chat/pull/22676))

  Track messages' roundtrip time from backend saves time to the time when received back from the oplog allowing track of oplog slowness.
  Prometheus metric: `rocketchat_messages_roundtrip_time`

- REST endpoint to remove User from Role ([#20485](https://github.com/RocketChat/Rocket.Chat/pull/20485) by [@Cosnavel](https://github.com/Cosnavel) & [@lucassartor](https://github.com/lucassartor) & [@ostjen](https://github.com/ostjen))

### 🚀 Improvements


- Canned responses ([#22703](https://github.com/RocketChat/Rocket.Chat/pull/22703) by [@rafaelblink](https://github.com/rafaelblink))

- Change message deletion confirmation modal to toast ([#22544](https://github.com/RocketChat/Rocket.Chat/pull/22544))

  Changed a timed modal for a toast message
  ![image](https://user-images.githubusercontent.com/40830821/124192670-0646f900-da9c-11eb-941c-9ae35421f6ef.png)

- Configuration for indices in Apps-Engine models ([#22705](https://github.com/RocketChat/Rocket.Chat/pull/22705))

  * Add `appId` field to the data saved by the Scheduler

  * Add `appId` index to `rocketchat_apps_persistence` model

  * Skip "trash collection" when deleting records from `rocketchat_apps_persistence`

  * Add a new setting to control for how long we should keep logs from the apps

  ![image](https://user-images.githubusercontent.com/1810309/126246666-907f9d98-1d84-4dfe-a80a-7dd874d36fa8.png)


  ![image](https://user-images.githubusercontent.com/1810309/126246655-2ce3cb5f-b2f5-456e-a9c4-beccd9b3ef41.png)

- Make `shortcut` field of canned responses unique ([#22700](https://github.com/RocketChat/Rocket.Chat/pull/22700))

- Paginated department select on forward chat ([#22123](https://github.com/RocketChat/Rocket.Chat/pull/22123))

  Changes the department dropdown to use the new paginated selects, allowing for searching and displaying more than 50 departments

- Paginated multiselect for EE tags ([#22315](https://github.com/RocketChat/Rocket.Chat/pull/22315) by [@rafaelblink](https://github.com/rafaelblink))

  This uses the paginated multiselect for the EE tags selection, allowing more than 50 tags to be shown.

- Preview message URLs only once ([#22516](https://github.com/RocketChat/Rocket.Chat/pull/22516) by [@nmagedman](https://github.com/nmagedman))

- Refactor `livechat.registerGuest` function ([#22684](https://github.com/RocketChat/Rocket.Chat/pull/22684))

- Replace OTR Icon on Contextual Bar & Update Icons ([#22377](https://github.com/RocketChat/Rocket.Chat/pull/22377))

  ![image](https://user-images.githubusercontent.com/27704687/122999868-2cc2b100-d385-11eb-8f30-3f34998d0b5d.png)

- Replace remaing discussion creation modals with React modal. ([#22448](https://github.com/RocketChat/Rocket.Chat/pull/22448))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/123840524-cbe72b80-d8e4-11eb-9ddb-23a9f9d90aac.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/123840219-74e15680-d8e4-11eb-95aa-00a990ffe0e7.png)

- Return open room if available for visitors ([#22742](https://github.com/RocketChat/Rocket.Chat/pull/22742))

- Rewrite Enter Encryption Password Modal ([#22456](https://github.com/RocketChat/Rocket.Chat/pull/22456))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/123182889-bbf3c580-d466-11eb-8d4d-9cfc3d224e33.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/123182916-cada7800-d466-11eb-96ee-850be190d419.png)

  ### Aditional Improves:

  - Added a visual validation in the password field

- Rewrite OTR modals ([#22583](https://github.com/RocketChat/Rocket.Chat/pull/22583))

  ![image](https://user-images.githubusercontent.com/40830821/124513267-cb510800-ddb0-11eb-8165-f103029c348f.png)
  ![image](https://user-images.githubusercontent.com/40830821/124513354-04897800-ddb1-11eb-96f4-41fe906ca0d7.png)
  ![image](https://user-images.githubusercontent.com/40830821/124513395-1b2fcf00-ddb1-11eb-83e4-3f8f9b4676ba.png)

- Rewrite Save Encryption Password Modal ([#22447](https://github.com/RocketChat/Rocket.Chat/pull/22447))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/122980201-c337a800-d36e-11eb-8e2b-68534cea8e1e.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/122980409-f8dc9100-d36e-11eb-9c15-aff779c84a91.png)

- Rewrite sidebar footer as React Component ([#22687](https://github.com/RocketChat/Rocket.Chat/pull/22687))

- Rewrite URL check modal ([#22540](https://github.com/RocketChat/Rocket.Chat/pull/22540))

  ![image](https://user-images.githubusercontent.com/40830821/124157878-a3d80380-da6f-11eb-8bd8-03dffd14c658.png)

- Sidebar icons margins ([#22498](https://github.com/RocketChat/Rocket.Chat/pull/22498))

- Update README.md ([#22462](https://github.com/RocketChat/Rocket.Chat/pull/22462))

- Wrong error message when trying to create a blocked username ([#22452](https://github.com/RocketChat/Rocket.Chat/pull/22452) by [@lucassartor](https://github.com/lucassartor))

  When trying to create a user with a blocked username, the UI was showing generic error message that it wasn't very detailed.

  Old error message:
  ![image](https://user-images.githubusercontent.com/49413772/123120080-6d203e80-d41a-11eb-8c87-64e34334c856.png)

  New error message:
  ![aaa](https://user-images.githubusercontent.com/49413772/123120251-8c1ed080-d41a-11eb-8dc2-d7484923d851.PNG)

### 🐛 Bug fixes


- **ENTERPRISE:** Engagement Dashboard displaying incorrect data about active users ([#22381](https://github.com/RocketChat/Rocket.Chat/pull/22381))

  - Fix sessions' and users' grouping in the Engagement Dashboard API endpoints;
   - Fix the data displayed in the charts from the "Active users", "Users by time of day" and "When is the chat busier?" sections of the Engagement Dashboard;
   - Replace label used to describe the amount of Active Users in the License section of the Info page.

- **ENTERPRISE:** Make AutoSelect algo take current agent load in consideration ([#22611](https://github.com/RocketChat/Rocket.Chat/pull/22611))

- **ENTERPRISE:** Race condition on Omnichannel visitor abandoned callback ([#22413](https://github.com/RocketChat/Rocket.Chat/pull/22413))

  As you can see [here](https://github.com/RocketChat/Rocket.Chat/blob/857791c39c97b51b5b6fd3718e0c816959a81c3b/ee/app/livechat-enterprise/server/lib/Helper.js#L127) the `predictedVisitorAbandonment` flag is not set if the room object doesn't have  `v.lastMessageTs` property. So we need to always make sure the `v.lastMessageTs` is set before this method is called.

  Currently the `v.lastMessageTs` is being set in [this](https://github.com/RocketChat/Rocket.Chat/blob/857791c39c97b51b5b6fd3718e0c816959a81c3b/app/livechat/server/hooks/saveLastVisitorMessageTs.js#L4) (lets call this **hook-1**) hook which has `HIGH` priority
  and the `predictedVisitorAbandonment` check is inturn performed in [this](https://github.com/RocketChat/Rocket.Chat/blob/857791c39c97b51b5b6fd3718e0c816959a81c3b/ee/app/livechat-enterprise/server/hooks/setPredictedVisitorAbandonmentTime.js#L5) (let call this **hook-2**) hook which is also `HIGH` priority.

  So ideally we'd except the **hook-1** to be called b4 **hook-2**, however currently since both of them are at same priority, there is no way to control which one is executed first. Hence in this PR, I'm making the priority of **hook-2** as `MEDIUM` to keeping the priority of **hook-1** the same as b4, i.e. `HIGH`. This should make sure that the **hook-1** is always executed b4 **hook-2**

- Admin page crashing when commit hash is null ([#22057](https://github.com/RocketChat/Rocket.Chat/pull/22057) by [@cprice-kgi](https://github.com/cprice-kgi))

  If the commit hash happens to be null, the administration page will still attempt to slice the value and display it. This causes the admin page to not display, and essentially crash the web app. This fixes it by checking for a null value first.

- Blank screen in message auditing DM tab ([#22763](https://github.com/RocketChat/Rocket.Chat/pull/22763) by [@ostjen](https://github.com/ostjen))

  The DM tab in message auditing was displaying a blank screen, instead of the actual tab.

  ![image](https://user-images.githubusercontent.com/28611993/127041404-dfca7f6a-2b8b-4c15-9cbd-c6238fac0063.png)

- Bugs in AutoCompleteDepartment ([#22414](https://github.com/RocketChat/Rocket.Chat/pull/22414))

- Call button is still displayed when the user doesn't have permission to use it ([#22170](https://github.com/RocketChat/Rocket.Chat/pull/22170))

  - Hide 'Call' buttons from the tab bar for muted users;

  - Display an error when a muted user attempts to enter a call using the 'Click to Join!' button.

- Can't see full user profile on team's room ([#22355](https://github.com/RocketChat/Rocket.Chat/pull/22355))

  ### before
  ![before](https://user-images.githubusercontent.com/27704687/121966860-bbac4980-cd45-11eb-8d48-2b0457110fc7.gif)

  ### after
  ![after](https://user-images.githubusercontent.com/27704687/121966870-bea73a00-cd45-11eb-9c89-ec52ac17e20f.gif)

  ### aditional fix :rocket:

  - unnecessary `TeamsMembers` component removed

- Cannot create a discussion from top left sidebar as a user ([#22618](https://github.com/RocketChat/Rocket.Chat/pull/22618) by [@lucassartor](https://github.com/lucassartor))

  When trying to create a discussion using the top left sidebar modal with an role that don't have the `view-other-user-channels ` permission, an empty list would be shown, which is a wrong behavior.
  Also, when being able to use this modal, discussions were listed as options, which is also a wrong behavior as there can't be nested discussions.

  This PR looks to fix both these issues.

  **Old behavior:**
  ![old](https://user-images.githubusercontent.com/49413772/124960017-3c333280-dff2-11eb-86cd-b2638311517e.png)

  **New behavior:**
  ![image](https://user-images.githubusercontent.com/49413772/124958882-05a8e800-dff1-11eb-8203-b34a4f1c98a0.png)

- Channel is automatically getting added to the first option in move to team feature ([#22670](https://github.com/RocketChat/Rocket.Chat/pull/22670) by [@ostjen](https://github.com/ostjen))

- Channels or Teams deleted are not removed from the sidebar. ([#22613](https://github.com/RocketChat/Rocket.Chat/pull/22613) by [@ostjen](https://github.com/ostjen))

- Checks the list of agents if at least one is online ([#22584](https://github.com/RocketChat/Rocket.Chat/pull/22584))

- Confirm owner change process when deleting own account ([#22609](https://github.com/RocketChat/Rocket.Chat/pull/22609))

- Content-Security-Policy ignoring CDN configuration ([#22791](https://github.com/RocketChat/Rocket.Chat/pull/22791) by [@nmagedman](https://github.com/nmagedman))

- Create discussion modal - cancel button and invite users alignment ([#22718](https://github.com/RocketChat/Rocket.Chat/pull/22718) by [@ostjen](https://github.com/ostjen))

  Changes in "open discussion" modal

  > Added cancel button
  > Fixed alignment in invite user


  ![image](https://user-images.githubusercontent.com/28611993/126388304-6ac76574-6924-426e-843d-afd53dc1c874.png)

- crush in the getChannelHistory method ([#22667](https://github.com/RocketChat/Rocket.Chat/pull/22667) by [@MaestroArt](https://github.com/MaestroArt))

- Deleting own account asks for the username in the UI instead of the password ([#22405](https://github.com/RocketChat/Rocket.Chat/pull/22405))

- Emoji not rendered on attachments description ([#22437](https://github.com/RocketChat/Rocket.Chat/pull/22437))

- Error in permission check for getLivechatDepartmentByNameOrId method in Apps ([#22545](https://github.com/RocketChat/Rocket.Chat/pull/22545))

  Update the Apps-Engine with a fix for the permission check on the `getLivechatDepartmentByNameOrId` method

- Livechat apps permission error ([#22511](https://github.com/RocketChat/Rocket.Chat/pull/22511))

  Updated Apps-Engine version fixes errors with apps using livechat features.

- Livechat config endpoint is not returning all settings ([#22686](https://github.com/RocketChat/Rocket.Chat/pull/22686))

- Livechat webhook request without headers ([#22589](https://github.com/RocketChat/Rocket.Chat/pull/22589))

- Markdown for UiKit blocks ([#22619](https://github.com/RocketChat/Rocket.Chat/pull/22619))

- Omnichannel - Fix issue with modals on room preview mode. ([#22541](https://github.com/RocketChat/Rocket.Chat/pull/22541))

- Omnichannel/Twilio - When a file is sent as first message, chat is not queued ([#22590](https://github.com/RocketChat/Rocket.Chat/pull/22590))

- Prune messages not applying the user filter ([#22506](https://github.com/RocketChat/Rocket.Chat/pull/22506))

- Put title into AutocompleteDepartment components ([#22417](https://github.com/RocketChat/Rocket.Chat/pull/22417))

  Dependencies: https://github.com/RocketChat/Rocket.Chat.Fuselage/pull/475

- Quote message not working for Livechat visitors ([#22586](https://github.com/RocketChat/Rocket.Chat/pull/22586))

  ### Before:
  ![image](https://user-images.githubusercontent.com/34130764/124583613-de2b1180-de70-11eb-82aa-18564b317626.png)
  ### After:
  ![image](https://user-images.githubusercontent.com/34130764/124583775-12063700-de71-11eb-8ab5-b0169fac2d40.png)

- Redirect to login after delete own account ([#22499](https://github.com/RocketChat/Rocket.Chat/pull/22499))

  Redirect the user to login after delete own account

  ### Aditional fixes:

  - Visual issue in password input on Delete Own Account Modal

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/123711503-f5ea1080-d846-11eb-96aa-8ed638ca665c.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/123711336-b3c0cf00-d846-11eb-9408-a686d8668ba5.png)

- Remove stack traces from Meteor errors when debug setting is disabled ([#22699](https://github.com/RocketChat/Rocket.Chat/pull/22699))

  - Fix 'not iterable' errors in the `normalizeMessage` function;

  - Remove stack traces from errors thrown by the `jitsi:updateTimeout` (and other `Meteor.Error`s) method.

- Rewrite CurrentChats to TS ([#22424](https://github.com/RocketChat/Rocket.Chat/pull/22424))

- Sort AutocompleteDepartmentsMultiple ([#22419](https://github.com/RocketChat/Rocket.Chat/pull/22419))

- status message won't show up for other users ([#22110](https://github.com/RocketChat/Rocket.Chat/pull/22110) by [@g-thome](https://github.com/g-thome))

  replace the current blaze block that queries the local session store by a react component that fetches memoized user data

- Store department value correctly ([#22685](https://github.com/RocketChat/Rocket.Chat/pull/22685))

- Support ID param on createVisitor method ([#22772](https://github.com/RocketChat/Rocket.Chat/pull/22772))

- UIKit URL prop being ignored for buttons  ([#22579](https://github.com/RocketChat/Rocket.Chat/pull/22579))

- Unnecessary space on members list footer ([#22514](https://github.com/RocketChat/Rocket.Chat/pull/22514))

- Use room's last message time when visitor did not send any message ([#22695](https://github.com/RocketChat/Rocket.Chat/pull/22695) by [@ericrosenthal](https://github.com/ericrosenthal))

- VisitorClientInfo not showing ([#22593](https://github.com/RocketChat/Rocket.Chat/pull/22593))

  ![image](https://user-images.githubusercontent.com/17487063/124694887-87492a80-deb8-11eb-89a3-a0e407841a32.png)

<details>
<summary>🔍 Minor changes</summary>


- [Fix] Omnichannel Real Time Monitoring charts not displaying all data ([#22363](https://github.com/RocketChat/Rocket.Chat/pull/22363))

- [Fix] Real Time Monitoring charts - chats-per-agent and chats-per-department - not visible ([#22406](https://github.com/RocketChat/Rocket.Chat/pull/22406))

- Bump actions/stale from 3.0.18 to 3.0.19 ([#22060](https://github.com/RocketChat/Rocket.Chat/pull/22060) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump glob-parent from 5.1.1 to 5.1.2 in /ee/server/services ([#22328](https://github.com/RocketChat/Rocket.Chat/pull/22328) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump: Fuselage 0.28.0 ([#22822](https://github.com/RocketChat/Rocket.Chat/pull/22822))

- Chore: [Snyk] Security upgrade node-gcm from 0.14.4 to 1.0.0 ([#22582](https://github.com/RocketChat/Rocket.Chat/pull/22582) by [@snyk-bot](https://github.com/snyk-bot))

- Chore: added pagination to search msg endpoint ([#22632](https://github.com/RocketChat/Rocket.Chat/pull/22632) by [@ostjen](https://github.com/ostjen))

- Chore: Create README.md ([#22615](https://github.com/RocketChat/Rocket.Chat/pull/22615))

- Chore: Enable Omnicahnnel by default ([#22697](https://github.com/RocketChat/Rocket.Chat/pull/22697) by [@ostjen](https://github.com/ostjen))

- Chore: Meteor 2.2 and bump dependencies ([#22399](https://github.com/RocketChat/Rocket.Chat/pull/22399))

- Chore: Remove JSON parse middleware ([#22454](https://github.com/RocketChat/Rocket.Chat/pull/22454))

- Chore: Remove Sodium from the main client ([#22459](https://github.com/RocketChat/Rocket.Chat/pull/22459))

- Chore: Review some dependencies ([#22522](https://github.com/RocketChat/Rocket.Chat/pull/22522))

  Upgrade some development dependencies.

- Chore: Support other pr titles ([#22494](https://github.com/RocketChat/Rocket.Chat/pull/22494))

- Chore: Upgrade Micro Services NPM dependencies ([#22561](https://github.com/RocketChat/Rocket.Chat/pull/22561))

- Chore: Upgrade NPM dependencies ([#22562](https://github.com/RocketChat/Rocket.Chat/pull/22562))

- Chore: Use projection instead of fields to avoid error log ([#22629](https://github.com/RocketChat/Rocket.Chat/pull/22629))

- Fix Closed chats doesn't shows who picked the call ([#22368](https://github.com/RocketChat/Rocket.Chat/pull/22368))

- i18n: Language update from LingoHub 🤖 on 2021-06-28Z ([#22491](https://github.com/RocketChat/Rocket.Chat/pull/22491))

- i18n: Language update from LingoHub 🤖 on 2021-07-05Z ([#22572](https://github.com/RocketChat/Rocket.Chat/pull/22572))

- Merge master into develop & Set version to 3.17.0-develop ([#22493](https://github.com/RocketChat/Rocket.Chat/pull/22493))

- Regression: Added missing translate keys for Federation ([#22810](https://github.com/RocketChat/Rocket.Chat/pull/22810))

- Regression: Allow users to search canned responses based on shortcut or content ([#22735](https://github.com/RocketChat/Rocket.Chat/pull/22735))

- Regression: Allow users to update canned responses scope ([#22738](https://github.com/RocketChat/Rocket.Chat/pull/22738))

- Regression: Change the name of called methods in Users model ([#22620](https://github.com/RocketChat/Rocket.Chat/pull/22620))

- Regression: Check for text before parse preview in create canned response form ([#22754](https://github.com/RocketChat/Rocket.Chat/pull/22754))

- Regression: Client crashing on startup ([#22610](https://github.com/RocketChat/Rocket.Chat/pull/22610))

- Regression: Create livechat-monitor permissions for Canned Responses ([#22781](https://github.com/RocketChat/Rocket.Chat/pull/22781))

- Regression: Data in the "Active Users" section is delayed in 1 day ([#22794](https://github.com/RocketChat/Rocket.Chat/pull/22794))

  - Fix 1 day delay in the Engagement Dashboard's "Active Users" section;

  - Downgrade `@nivo/line` version.
  **Expected behavior:**
  ![active-users-engagement-dashboard](https://user-images.githubusercontent.com/36537004/127372185-390dc42f-bc90-4841-a22b-731f0aafcafe.PNG)

- Regression: Data in the "New Users" section is delayed in 1 day ([#22751](https://github.com/RocketChat/Rocket.Chat/pull/22751))

  - Update nivo version (which was causing errors in the bar chart);
   - Fix 1 day delay in '7 days' and '30 days' periods;
   - Update tooltip theme.

- Regression: Federation warnings on ci ([#22765](https://github.com/RocketChat/Rocket.Chat/pull/22765) by [@g-thome](https://github.com/g-thome))

  fix some linting warnings on federation modal

- Regression: Filter of canned responses in contextual-bar ([#22762](https://github.com/RocketChat/Rocket.Chat/pull/22762))

- Regression: fix canned responses filters for monitors ([#22782](https://github.com/RocketChat/Rocket.Chat/pull/22782))

- Regression: Fix canned responses permissions for monitors & managers ([#22793](https://github.com/RocketChat/Rocket.Chat/pull/22793))

- Regression: Fix ee microservices build ([#22656](https://github.com/RocketChat/Rocket.Chat/pull/22656))

- Regression: Fix empty canned responses table when searching ([#22743](https://github.com/RocketChat/Rocket.Chat/pull/22743))

- Regression: Fix empty tag field ([#22767](https://github.com/RocketChat/Rocket.Chat/pull/22767))

- Regression: fix non ee tag field on canned responses ([#22775](https://github.com/RocketChat/Rocket.Chat/pull/22775))

- Regression: fix outdated data on canned filters ([#22766](https://github.com/RocketChat/Rocket.Chat/pull/22766))

- Regression: Fix tooltip style in the "Busiest Chat Times" chart ([#22813](https://github.com/RocketChat/Rocket.Chat/pull/22813))

  - Fix tooltip in the Engagement Dashboard's "Busiest Chat Times" chart (Hours).

  **Expected behavior:**
  ![busiest-times-ed](https://user-images.githubusercontent.com/36537004/127527827-465397ed-f089-4fb7-9ab2-6fa8cea6abdf.PNG)

- Regression: Fix users not being able to see the scope of the canned m… ([#22760](https://github.com/RocketChat/Rocket.Chat/pull/22760))

- Regression: Fixes empty department field on edit canned responses ([#22741](https://github.com/RocketChat/Rocket.Chat/pull/22741))

  This fixes the empty department field when editing a canned response via table on omnichannel menu. this also convert some of the files to TS that were created in js initially, also created/adjusted some types

- Regression: Internal Error when saving files using GridFS ([#22792](https://github.com/RocketChat/Rocket.Chat/pull/22792))

- Regression: observe-sequence version syntax broken on IE ([#22557](https://github.com/RocketChat/Rocket.Chat/pull/22557))

- Regression: Parse canned responses placeholders ([#22777](https://github.com/RocketChat/Rocket.Chat/pull/22777))

- Regression: Prevent custom status from being visible in sequential messages ([#22733](https://github.com/RocketChat/Rocket.Chat/pull/22733))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/126641946-866dae96-1983-43a5-b689-b24670473ad0.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/126641752-3163eb95-1cd4-4d99-a61a-4d06d9e7e13e.png)

- Regression: Properly force newline in attachment fields ([#22727](https://github.com/RocketChat/Rocket.Chat/pull/22727))

  I've incorrectly enforcing the newline character in attachment fields, resulting in "&lt;br /&gt;" text being rendered.

- Regression: Remove Tags from canned response filter ([#22779](https://github.com/RocketChat/Rocket.Chat/pull/22779))

- Regression: Replaced manual state control with a .once event ([#22800](https://github.com/RocketChat/Rocket.Chat/pull/22800))

- Regression: Rocket.Chat crashes on startup if there's a Custom OAuth service configured ([#22740](https://github.com/RocketChat/Rocket.Chat/pull/22740))

- Regression: roles.removeUserFromRole API not working with scoped roles. ([#22799](https://github.com/RocketChat/Rocket.Chat/pull/22799))

- Regression: Small UI changes Federation ([#22811](https://github.com/RocketChat/Rocket.Chat/pull/22811))

- Regression: Text wrap in MarkdownTextEditor and PreviewText ([#22798](https://github.com/RocketChat/Rocket.Chat/pull/22798))

- Regression: Translate scope on canned responses dashboard ([#22773](https://github.com/RocketChat/Rocket.Chat/pull/22773))

- Release 3.16.4 ([#22815](https://github.com/RocketChat/Rocket.Chat/pull/22815))

- revert the lastMessage fix for visitor abandonment ([#22720](https://github.com/RocketChat/Rocket.Chat/pull/22720) by [@ericrosenthal](https://github.com/ericrosenthal))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Cosnavel](https://github.com/Cosnavel)
- [@MaestroArt](https://github.com/MaestroArt)
- [@cprice-kgi](https://github.com/cprice-kgi)
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@ericrosenthal](https://github.com/ericrosenthal)
- [@g-thome](https://github.com/g-thome)
- [@lucassartor](https://github.com/lucassartor)
- [@nmagedman](https://github.com/nmagedman)
- [@ostjen](https://github.com/ostjen)
- [@rafaelblink](https://github.com/rafaelblink)
- [@snyk-bot](https://github.com/snyk-bot)

### 👩‍💻👨‍💻 Core Team 🤓

- [@Faria-TechWrite](https://github.com/Faria-TechWrite)
- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@alansikora](https://github.com/alansikora)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 3.16.4
`2021-07-30  ·  1 🔍  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

<details>
<summary>🔍 Minor changes</summary>


- Release 3.16.4 ([#22815](https://github.com/RocketChat/Rocket.Chat/pull/22815))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)

# 3.16.3
`2021-07-13  ·  1 🐛  ·  5 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

### 👩‍💻👨‍💻 Contributors 😍

- [@g-thome](https://github.com/g-thome)

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.16.2
`2021-07-08  ·  4 🐛  ·  1 🔍  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.1`

### 🐛 Bug fixes


- Checks the list of agents if at least one is online ([#22584](https://github.com/RocketChat/Rocket.Chat/pull/22584))

- Error in permission check for getLivechatDepartmentByNameOrId method in Apps ([#22545](https://github.com/RocketChat/Rocket.Chat/pull/22545))

  Update the Apps-Engine with a fix for the permission check on the `getLivechatDepartmentByNameOrId` method

- Livechat webhook request without headers ([#22589](https://github.com/RocketChat/Rocket.Chat/pull/22589))

- Markdown for UiKit blocks ([#22619](https://github.com/RocketChat/Rocket.Chat/pull/22619))

<details>
<summary>🔍 Minor changes</summary>


- Regression: Change the name of called methods in Users model ([#22620](https://github.com/RocketChat/Rocket.Chat/pull/22620))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@d-gubert](https://github.com/d-gubert)
- [@ggazzo](https://github.com/ggazzo)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 3.16.1
`2021-07-01  ·  2 🐛  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.0`

### 🐛 Bug fixes


- Livechat apps permission error ([#22511](https://github.com/RocketChat/Rocket.Chat/pull/22511))

  Updated Apps-Engine version fixes errors with apps using livechat features.

- Prune messages not applying the user filter ([#22506](https://github.com/RocketChat/Rocket.Chat/pull/22506))

### 👩‍💻👨‍💻 Core Team 🤓

- [@d-gubert](https://github.com/d-gubert)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.16.0
`2021-06-28  ·  5 🎉  ·  13 🚀  ·  44 🐛  ·  26 🔍  ·  23 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.27.0-alpha.5237`

### 🎉 New features


- Add `teams.convertToChannel` endpoint ([#22188](https://github.com/RocketChat/Rocket.Chat/pull/22188))

  - Add new `teams.converToChannel` endpoint;

  - Update `ConvertToTeam` modal text (since this action can now be reversed);

  - Remove corresponding team memberships when a team is deleted or converted to a channel;

- Add setting to configure default role for user on manual registration ([#20650](https://github.com/RocketChat/Rocket.Chat/pull/20650) by [@lucassartor](https://github.com/lucassartor))

  Add an `admin` setting to determine the initial `role` for new users who registered manually (through the register form and via API, not using an authentication service), normally all new users are assigned to the `user` role.

  The setting can be found in `Admin`->`Accounts`->`Registration`.

  ![image](https://user-images.githubusercontent.com/49413772/107252603-47b70900-6a14-11eb-9cc6-df76720b7365.png)
  The setting initial value is false, so the default behaviour stays the same while creating a new server or upgrading one.

  https://user-images.githubusercontent.com/49413772/107253220-ddeb2f00-6a14-11eb-85b4-f770dbbe4970.mp4

  Video showing an example of the setting being used and creating an new user with the default roles via API.

- Content-Security-Policy for inline scripts ([#20724](https://github.com/RocketChat/Rocket.Chat/pull/20724))

  Security policies were applied for inline scripts cases. Due to the libraries and components we use it is not possible to disable inline styles and images as they would break Oembeds and other libraries.


  basically the inline scripts were moved to a js file

  and besides that some suggars syntax like `addScript` and `addStyle` were added, this way the application already takes care of inserting the elements and providing the content automatically.

- Open modals in side effects outside React ([#22247](https://github.com/RocketChat/Rocket.Chat/pull/22247))

- Remove "Game Center" setting ([#22232](https://github.com/RocketChat/Rocket.Chat/pull/22232) by [@lolimay](https://github.com/lolimay))

### 🚀 Improvements


- **APPS:** Refactor bridges ([#21253](https://github.com/RocketChat/Rocket.Chat/pull/21253))

  Make the bridge classes extend abstract classes provided by the engine instead of just implementing an interface. The new abstract classes feature proxy methods used for permission verification in each method. This is also offers space to add more behaviors before executing the actual bridge methods.

- Add BBB and Jitsi to Team ([#22312](https://github.com/RocketChat/Rocket.Chat/pull/22312))

  Added 2 new settings:

  - `Admin > Video Conference > Big Blue Button > Enable for teams`

  - `Admin > Video Conference > Jitsi > Enable in teams`

- Add debouncing to units selects filters ([#22097](https://github.com/RocketChat/Rocket.Chat/pull/22097))

- Add modal to close chats when tags/comments are not required ([#22245](https://github.com/RocketChat/Rocket.Chat/pull/22245) by [@rafaelblink](https://github.com/rafaelblink))

  When neither tags or comments are required to close a livechat, show this modal instead:
  ![Screen Shot 2021-05-20 at 7 33 19 PM](https://user-images.githubusercontent.com/20868078/119057741-6af23c80-b9a3-11eb-902f-f8a7458ad11c.png)

- Fallback messages on contextual bar ([#22376](https://github.com/RocketChat/Rocket.Chat/pull/22376))

  ![image](https://user-images.githubusercontent.com/27704687/122301100-9569e380-ced6-11eb-992a-e3a7fd9d0d73.png)

- Missing tests to `fname` and `prid` in the `rooms.createDiscussion` endpoint ([#22223](https://github.com/RocketChat/Rocket.Chat/pull/22223))

  - Add tests to the values of `fname` and `prid` in the `rooms.createDiscussion` endpoint's results.

- New indexes for Omnichannel-related collections ([#22367](https://github.com/RocketChat/Rocket.Chat/pull/22367))

- Paginated department select on forward chat ([#22123](https://github.com/RocketChat/Rocket.Chat/pull/22123))

  Changes the department dropdown to use the new paginated selects, allowing for searching and displaying more than 50 departments

- Paginated multiselect for EE tags ([#22315](https://github.com/RocketChat/Rocket.Chat/pull/22315) by [@rafaelblink](https://github.com/rafaelblink))

  This uses the paginated multiselect for the EE tags selection, allowing more than 50 tags to be shown.

- Remove differentiation between public x private channels in sidebar ([#22160](https://github.com/RocketChat/Rocket.Chat/pull/22160))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/119752184-e7d55880-be72-11eb-9167-be2f305ddb3f.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/119752125-c8d6c680-be72-11eb-8444-2e0c7cb1c600.png)

- Rewrite create direct modal ([#22209](https://github.com/RocketChat/Rocket.Chat/pull/22209))

  ![image](https://user-images.githubusercontent.com/27704687/120384584-bb02c480-c2fc-11eb-8e8e-c197b08b5201.png)

- Rewrite Create Discussion Modal (only through sidebar) ([#22224](https://github.com/RocketChat/Rocket.Chat/pull/22224))

  This is only available by creating a new discussion when clicking on the sidebar button. Other places will be implemented afterwards.

  ![image](https://user-images.githubusercontent.com/40830821/120556093-6af63180-c3d2-11eb-97ea-63c5423049dc.png)

- Send only relevant data via WebSocket ([#22258](https://github.com/RocketChat/Rocket.Chat/pull/22258))

  Previously when any data changed on subscriptions or rooms we were getting fresh data from database, to also remove undesired fields, but sometimes the data that changed was not relevant so we were sending the whole object everytime **without** the fields that actually changed. This change aims to reduce this overhead and also send less data to clients.

### 🐛 Bug fixes


- _updatedAt attribute not being automatically updated by raw models ([#22306](https://github.com/RocketChat/Rocket.Chat/pull/22306))

- **EE:** Canned responses can't be deleted ([#22095](https://github.com/RocketChat/Rocket.Chat/pull/22095) by [@rafaelblink](https://github.com/rafaelblink))

  Deletion button has been removed from the edition option.

  ## Before
  ![image](https://user-images.githubusercontent.com/2493803/119059416-9f1b2c80-b9a6-11eb-933a-4efa1ac0552a.png)

  ### After
  ![Rocket Chat (2)](https://user-images.githubusercontent.com/2493803/119172517-72b1ef80-ba3c-11eb-9178-04a12176f312.gif)

- **ENTERPRISE:** Omnichannel enterprise permissions being added back to its default roles ([#22322](https://github.com/RocketChat/Rocket.Chat/pull/22322))

  Fix omnichannel monitor permissions being added back to omnichannel monitor role on every startup.

- **ENTERPRISE:** Prevent Visitor Abandonment after forwarding chat ([#22243](https://github.com/RocketChat/Rocket.Chat/pull/22243))

  Currently the Visitor Abandonment timer isn't affected when the chat is forwarded. However this is affecting the UX in certain situations like eg: A bot forwarding a chat to an human agent
  ![image](https://user-images.githubusercontent.com/34130764/120896383-e4925780-c63e-11eb-937e-ffd7c4836159.png)

  To solve this issue, we'll now be stoping the Visitor Abandonment timer once a chat is forwarded.

- **IMPROVE:** Prevent creation of duplicated roles and new `roles.update` endpoint ([#22279](https://github.com/RocketChat/Rocket.Chat/pull/22279) by [@lucassartor](https://github.com/lucassartor))

  Currently, the action of updating a role is broken: because roles have their `_id` = `name`, when updating a role there's no way to validate if the user is trying to update or create a new role with a name that already exists   -  which causes wrong behaviors, such as roles with the same name and not being able to update them.

  To proper fix this, this PR looks to change the creation of roles. Now, roles have a unique  `_id` value and there's a endpoint to update roles: `/api/v1/roles.update`.

  Doing so, it's possible to validate on both endpoints (`roles.create` and `roles.update`) to not allow roles with duplicated names.

  **OBS:** The unique id changes only reflect new roles, the standard roles (such as admin and user) still have `_id` = `name`, but new roles now **can't** have the same name as them.

- `channels.history`, `groups.history` and `im.history` REST endpoints not respecting hide system message config ([#22364](https://github.com/RocketChat/Rocket.Chat/pull/22364))

- Apps not syncing status correctly on HA setups ([#22415](https://github.com/RocketChat/Rocket.Chat/pull/22415))

  FIxes erros where, on HA setups, instances that DID NOT originate the action of uninstalling and updating an app would maintain the wrong status of apps when they received the notification of these events via Streamer.

- Attachments and avatars not rendered if deployed on subfolder ([#22290](https://github.com/RocketChat/Rocket.Chat/pull/22290))

- Auditing page not printing all messages ([#22272](https://github.com/RocketChat/Rocket.Chat/pull/22272))

  Changed CSS so printed media from the auditing page includes all page content.

- Can't delete file from Room's file list ([#22191](https://github.com/RocketChat/Rocket.Chat/pull/22191))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/120215931-bb239700-c20c-11eb-9494-d4bc017df390.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/120216113-f8882480-c20c-11eb-9afb-b127e66a43da.png)

- Cancel button and success toast at Leave Team modal ([#22373](https://github.com/RocketChat/Rocket.Chat/pull/22373))

- Chore: `team.addMembers` doesn't add member to main team room ([#22169](https://github.com/RocketChat/Rocket.Chat/pull/22169) by [@lucassartor](https://github.com/lucassartor))

  Fix `team.addMembers` endpoint as it currently doesn't work properly. The API call is adding members to a team's channels but not to the main team room.

- Convert and Move team permission ([#22350](https://github.com/RocketChat/Rocket.Chat/pull/22350))

  ### before
  https://user-images.githubusercontent.com/45966964/114909360-5c04f100-9e1d-11eb-9363-f308e5d0be68.mp4

  ### after
  https://user-images.githubusercontent.com/45966964/114909388-61fad200-9e1d-11eb-9bbe-114b55954a9f.mp4

- CORS error while interacting with any action button on Livechat  ([#22150](https://github.com/RocketChat/Rocket.Chat/pull/22150))

- DeepL supported languages ([#22326](https://github.com/RocketChat/Rocket.Chat/pull/22326) by [@mrsimpson](https://github.com/mrsimpson))

- Error generating Jitsi Token ([#22301](https://github.com/RocketChat/Rocket.Chat/pull/22301))

- Game center close button ([#22353](https://github.com/RocketChat/Rocket.Chat/pull/22353))

  ![Peek 2021-06-14 18-19](https://user-images.githubusercontent.com/27704687/121960896-155c4600-cd3d-11eb-9be9-9712f4a1087b.gif)

- Jitsi integration sending random "join now" messages ([#22277](https://github.com/RocketChat/Rocket.Chat/pull/22277))

- LDAP and SAML: changed usernames are not reflected on old data ([#22304](https://github.com/RocketChat/Rocket.Chat/pull/22304))

- Members tab visual issues ([#22138](https://github.com/RocketChat/Rocket.Chat/pull/22138))

  ## Before
  ![image](https://user-images.githubusercontent.com/27704687/119558283-95fbd800-bd77-11eb-91b4-91821f365bf3.png)

  ## After
  ![image](https://user-images.githubusercontent.com/27704687/119558120-6947c080-bd77-11eb-8ecb-7fedc07afa82.png)

- Memory leak generated by Stream Cast usage ([#22329](https://github.com/RocketChat/Rocket.Chat/pull/22329))

  Stream Cast uses a different approach to broadcast data to the instances, it uses the DDP subscription method that requires a collection on the other side, if no collection exists with the given name `broadcast-stream` it caches in memory waiting for the collection to be set later. The cache is cleared only when a reconnection happens.

  This PR overrides the function that processes the data for that specific connection, preventing the cache and everything else to be processed since we already have our low-level listener to process the data.

- Message box hiding on mobile view (Safari) ([#22212](https://github.com/RocketChat/Rocket.Chat/pull/22212))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/120404256-5b1c1600-c31c-11eb-96e9-860e4132db5f.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/120404406-acc4a080-c31c-11eb-9efb-c2ad88664fda.png)

- Missing burger menu on direct messages ([#22211](https://github.com/RocketChat/Rocket.Chat/pull/22211))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/120403671-09bf5700-c31b-11eb-92a1-a2f589bd85fc.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/120403693-1643af80-c31b-11eb-8027-dbdc4f560647.png)

- Missing Throbber while thread list is loading ([#22316](https://github.com/RocketChat/Rocket.Chat/pull/22316))

  ### before
  List was starting with no results even if there's results:

  ![image](https://user-images.githubusercontent.com/27704687/121606744-1e8ba100-ca25-11eb-9b31-706fb998d05f.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/121606635-e97f4e80-ca24-11eb-81f7-af8b0cc41c89.png)

- Not possible to edit some messages inside threads ([#22325](https://github.com/RocketChat/Rocket.Chat/pull/22325))

  ### Before
  ![before](https://user-images.githubusercontent.com/27704687/121755733-4eeb4200-caee-11eb-9d77-1b498c38c478.gif)

  ### After
  ![after](https://user-images.githubusercontent.com/27704687/121755736-514d9c00-caee-11eb-9897-78fcead172f2.gif)

- Notifications not using user's name ([#22309](https://github.com/RocketChat/Rocket.Chat/pull/22309))

- OAuth login not working on electron app with temp sessions. ([#22401](https://github.com/RocketChat/Rocket.Chat/pull/22401))

- Omnichannel information panel is not displaying departments correctly ([#22155](https://github.com/RocketChat/Rocket.Chat/pull/22155))

- Permission check for teams.listRoomsOfUser ([#22313](https://github.com/RocketChat/Rocket.Chat/pull/22313))

  If the user is trying to list his own channels, the permission check is skipped.

- Read receipts are broken ([#22203](https://github.com/RocketChat/Rocket.Chat/pull/22203))

- Remove invalid check before sending notifications to Omnichannel online agents ([#22278](https://github.com/RocketChat/Rocket.Chat/pull/22278))

- Remove useless message options from Omnichannel Rooms ([#21549](https://github.com/RocketChat/Rocket.Chat/pull/21549) by [@rafaelblink](https://github.com/rafaelblink))

- Removed follow button from message box in threads ([#21019](https://github.com/RocketChat/Rocket.Chat/pull/21019) by [@Darshilp326](https://github.com/Darshilp326))

  Removed follow button from message box as it was coinciding with audio/file message in threads.

- Setup wizard infinite loop when on subfolder. ([#22395](https://github.com/RocketChat/Rocket.Chat/pull/22395))

- Sidebar not closing when clicking on a channel ([#22271](https://github.com/RocketChat/Rocket.Chat/pull/22271))

  ### before
  ![before](https://user-images.githubusercontent.com/27704687/121074843-c6e20100-c7aa-11eb-88db-76e39b57b064.gif)

  ### after
  ![after](https://user-images.githubusercontent.com/27704687/121074860-cb0e1e80-c7aa-11eb-9e96-06d75044b763.gif)

- Sound notification is not emitted when the Omnichannel chat comes from another department ([#22291](https://github.com/RocketChat/Rocket.Chat/pull/22291))

- Support DISABLE_PRESENCE_MONITOR env var in new DB watchers ([#22257](https://github.com/RocketChat/Rocket.Chat/pull/22257))

- Unable to change protected role's description ([#22402](https://github.com/RocketChat/Rocket.Chat/pull/22402) by [@lucassartor](https://github.com/lucassartor))

- Undefined error when forwarding chats to offline department ([#22154](https://github.com/RocketChat/Rocket.Chat/pull/22154) by [@rafaelblink](https://github.com/rafaelblink))

  ![Screen Shot 2021-05-26 at 5 29 17 PM](https://user-images.githubusercontent.com/59577424/119727520-c495b380-be48-11eb-88a2-158017c7ad0a.png)

  Omnichannel agents are facing the error shown above when forwarding chats to offline departments.
  The error usually takes place when the routing system algorithm is **Manual Selection**.

- Unread bar in channel flash quickly and then disappear ([#22275](https://github.com/RocketChat/Rocket.Chat/pull/22275))

  ![unread_messages](https://user-images.githubusercontent.com/27704687/121092865-960dc600-c7c2-11eb-9074-81060d826811.gif)

- User Info displaying own user. ([#22219](https://github.com/RocketChat/Rocket.Chat/pull/22219))

- Visitor info screen being updated multiple times ([#22482](https://github.com/RocketChat/Rocket.Chat/pull/22482))

- Web navigation breaks after visiting integrations admin page ([#21983](https://github.com/RocketChat/Rocket.Chat/pull/21983) by [@rexzing](https://github.com/rexzing))

  Fix the navigation breaks issue after visiting the integrations administration page

- Wrong member's contextualBar on direct multiple ([#21452](https://github.com/RocketChat/Rocket.Chat/pull/21452))

  ![image](https://user-images.githubusercontent.com/27704687/113620310-893cec80-9630-11eb-83e2-0e8b2181cc42.png)

<details>
<summary>🔍 Minor changes</summary>


- Bump: Fuselage 0.27.0 ([#22486](https://github.com/RocketChat/Rocket.Chat/pull/22486))

- Chore: Attachment Definitions and UiKitDefinitions ([#22354](https://github.com/RocketChat/Rocket.Chat/pull/22354))

- Chore: Bump node_modules cache key ([#22250](https://github.com/RocketChat/Rocket.Chat/pull/22250))

- Chore: Change modals for remove user from team && leave team ([#22141](https://github.com/RocketChat/Rocket.Chat/pull/22141))

  ![image](https://user-images.githubusercontent.com/40830821/119576154-93f14380-bd8e-11eb-8885-f889f2939bf4.png)
  ![image](https://user-images.githubusercontent.com/40830821/119576219-b5eac600-bd8e-11eb-832c-ea7a17a56bdd.png)

- Chore: Check PR Title on every submission ([#22140](https://github.com/RocketChat/Rocket.Chat/pull/22140))

- Chore: Enable push gateway only if the server is registered ([#22346](https://github.com/RocketChat/Rocket.Chat/pull/22346) by [@lucassartor](https://github.com/lucassartor))

  Currently, when creating an unregistered server, the default value of the push gateway setting is set to true and is disabled (it can't be changed unless the server is registered). This is a wrong behavior as an unregistered server **can't** use the push gateway.

  This PR creates a validation to check if the server is registered when enabling the push gateway. That way, even if the push gateway setting is turned on, but the server is unregistered, the push gateway **won't** work   - it will behave like it is off.

- Chore: Enforce TypeScript on Storybook ([#22317](https://github.com/RocketChat/Rocket.Chat/pull/22317))

  Rewrite some Storybook stories in TypeScript, as an example.

- Chore: Move getUserRoles to service and add cache ([#22345](https://github.com/RocketChat/Rocket.Chat/pull/22345))

- Chore: Remove Meter.wrapAsync from upload api ([#22286](https://github.com/RocketChat/Rocket.Chat/pull/22286))

- Chore: Remove not used scripts and its dependencies ([#22167](https://github.com/RocketChat/Rocket.Chat/pull/22167))

- Chore: Remove unnecessary modals replacing to GenericModal ([#21853](https://github.com/RocketChat/Rocket.Chat/pull/21853))

- Chore: Update delete team modal to new design ([#22127](https://github.com/RocketChat/Rocket.Chat/pull/22127))

  Now the modal has only 2 steps (steps 1 and 2 were merged)
  ![image](https://user-images.githubusercontent.com/40830821/119414580-2e398480-bcc6-11eb-9a47-515568257974.png)

- Language update from LingoHub 🤖 on 2021-05-31Z ([#22196](https://github.com/RocketChat/Rocket.Chat/pull/22196))

- Language update from LingoHub 🤖 on 2021-06-14Z ([#22340](https://github.com/RocketChat/Rocket.Chat/pull/22340))

- Merge master into develop & Set version to 3.16.0-develop ([#22184](https://github.com/RocketChat/Rocket.Chat/pull/22184))

- Refactor few methods to improve Omnichannel flow ([#22321](https://github.com/RocketChat/Rocket.Chat/pull/22321))

- Regression: Api tests not running ([#22369](https://github.com/RocketChat/Rocket.Chat/pull/22369))

- Regression: Block-size property on firefox ([#22433](https://github.com/RocketChat/Rocket.Chat/pull/22433))

- Regression: CSP for external Media and Frames ([#22465](https://github.com/RocketChat/Rocket.Chat/pull/22465))

- Regression: Enable unregistered servers to use their own push gateway ([#22391](https://github.com/RocketChat/Rocket.Chat/pull/22391) by [@lucassartor](https://github.com/lucassartor))

  https://github.com/RocketChat/Rocket.Chat/pull/22346 prevented unregistered servers from using the RC push gateway but was still blocking this servers from using their own push gateway, this PR looks to fix that.

- Regression: Fix CORS in uikit endpoints ([#22214](https://github.com/RocketChat/Rocket.Chat/pull/22214))

- Regression: Fix livechat find departments ([#22472](https://github.com/RocketChat/Rocket.Chat/pull/22472))

- Regression: Missing flexDirection on select field ([#22300](https://github.com/RocketChat/Rocket.Chat/pull/22300))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/121425905-532a2a80-c949-11eb-885f-e8ddaf5c8d5c.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/121425770-283fd680-c949-11eb-8d94-86886f174599.png)

- Regression: RoomProvider using wrong types ([#22370](https://github.com/RocketChat/Rocket.Chat/pull/22370))

- Release 3.15.2 ([#22483](https://github.com/RocketChat/Rocket.Chat/pull/22483))

- Update README.md ([#22461](https://github.com/RocketChat/Rocket.Chat/pull/22461))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Darshilp326](https://github.com/Darshilp326)
- [@lolimay](https://github.com/lolimay)
- [@lucassartor](https://github.com/lucassartor)
- [@mrsimpson](https://github.com/mrsimpson)
- [@rafaelblink](https://github.com/rafaelblink)
- [@rexzing](https://github.com/rexzing)

### 👩‍💻👨‍💻 Core Team 🤓

- [@Faria-TechWrite](https://github.com/Faria-TechWrite)
- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 3.15.3
`2021-07-01  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.26.0`

### 🐛 Bug fixes


- Prune messages not applying the user filter ([#22506](https://github.com/RocketChat/Rocket.Chat/pull/22506))

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.15.2
`2021-06-27  ·  3 🐛  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.26.0`

### 🐛 Bug fixes


- **ENTERPRISE:** Omnichannel enterprise permissions being added back to its default roles ([#22322](https://github.com/RocketChat/Rocket.Chat/pull/22322))

  Fix omnichannel monitor permissions being added back to omnichannel monitor role on every startup.

- Sound notification is not emitted when the Omnichannel chat comes from another department ([#22291](https://github.com/RocketChat/Rocket.Chat/pull/22291))

- Visitor info screen being updated multiple times ([#22482](https://github.com/RocketChat/Rocket.Chat/pull/22482))

<details>
<summary>🔍 Minor changes</summary>


- Release 3.15.2 ([#22483](https://github.com/RocketChat/Rocket.Chat/pull/22483))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@renatobecker](https://github.com/renatobecker)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.15.1
`2021-06-21  ·  3 🐛  ·  1 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.26.0`

### 🐛 Bug fixes


- Attachments and avatars not rendered if deployed on subfolder ([#22290](https://github.com/RocketChat/Rocket.Chat/pull/22290))

- Setup wizard infinite loop when on subfolder. ([#22395](https://github.com/RocketChat/Rocket.Chat/pull/22395))

- Support DISABLE_PRESENCE_MONITOR env var in new DB watchers ([#22257](https://github.com/RocketChat/Rocket.Chat/pull/22257))

<details>
<summary>🔍 Minor changes</summary>


- Release 3.15.1 ([#22432](https://github.com/RocketChat/Rocket.Chat/pull/22432))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@gabriellsh](https://github.com/gabriellsh)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)

# 3.15.0
`2021-05-28  ·  8 🎉  ·  12 🚀  ·  62 🐛  ·  47 🔍  ·  34 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0, 4.2`
- Apps-Engine: `1.26.0`

### 🎉 New features


- **APPS:** Ability for Rocket.Chat Apps to delete rooms ([#21875](https://github.com/RocketChat/Rocket.Chat/pull/21875) by [@lucassartor](https://github.com/lucassartor))

  Adds a new `delete` method on the rooms bridge in order to trigger the deletion of rooms via the Apps-Engine.

- **ENTERPRISE:** Introduce Load Rotation routing algorithm for Omnichannel ([#22090](https://github.com/RocketChat/Rocket.Chat/pull/22090) by [@rafaelblink](https://github.com/rafaelblink))

  This PR introduces a new Auto Chat Distribution (ACD) algorithm for Omnichannel: **Load Rotation**.
  The algorithm distributes chats to agents one by one, which means that when a new chat arrives, the agent with the oldest routing assignment time will be selected to serve the chat, regardless of the number of chats in progress each agent has.

  ![Screen Shot 2021-05-20 at 5 17 40 PM](https://user-images.githubusercontent.com/59577424/119043752-c61a3400-b98f-11eb-8543-f3176879af1d.png)

- Back button for Omnichannel ([#21647](https://github.com/RocketChat/Rocket.Chat/pull/21647) by [@rafaelblink](https://github.com/rafaelblink))

- New Message Parser ([#21962](https://github.com/RocketChat/Rocket.Chat/pull/21962))

  The objective is to put an end to the confusion that we face having multiple parsers, and the problems that this brings, it is still experimental then users need to choose to use it.

  The benefits are multiple. no more unexpected cases or grammatical collisions (in addition to more flexible nested cases like bold within link labels).
  Besides, we no longer render raw html, instead we use components, so the xss attacks are over (the easy ones at least). Without further discoveries and at the fronted, we only reder what is delivered thus improving our performance.
  This can be used in multiple places, (message, alert, sidenav and in the entire mobile application.)

- Option to notify failed login attempts to a channel ([#21968](https://github.com/RocketChat/Rocket.Chat/pull/21968))

- Option to prevent users from using Invisible status ([#20084](https://github.com/RocketChat/Rocket.Chat/pull/20084) by [@lucassartor](https://github.com/lucassartor))

  Add an `admin` option to allow/disallow the `Invisible` status option from all users. This option is available in the `Accounts` section.

  ![2021-01-06-11-55-22](https://user-images.githubusercontent.com/49413772/103782988-ebc52300-5016-11eb-8a29-dd540c21e11c.gif)

  If the option is turned off, the `users.setStatus` endpoint is also restricted from users trying to change their status to `Invisible`, throwing the following error:
  ```json
  {
    "success": false,
    "error": "Invisible status is disabled [error-not-allowed]",
    "stack": "Error: Invisible status is disabled [error-not-allowed]\n    at DDPCommon.MethodInvocation.<anonymous> (app/api/server/v1/users.js:425:13)\n    at packages/dispatch_run-as-user.js:211:14\n    at Meteor.EnvironmentVariable.EVp.withValue (packages/meteor.js:1234:12)\n    at Object.Meteor.runAsUser (packages/dispatch_run-as-user.js:210:33)\n    at Object.post (app/api/server/v1/users.js:415:10)\n    at app/api/server/api.js:394:82\n    at Meteor.EnvironmentVariable.EVp.withValue (packages/meteor.js:1234:12)\n    at Object._internalRouteActionHandler [as action] (app/api/server/api.js:394:39)\n    at Route.share.Route.Route._callEndpoint (packages/nimble_restivus/lib/route.coffee:150:32)\n    at packages/nimble_restivus/lib/route.coffee:59:33\n    at packages/simple_json-routes.js:98:9",
    "errorType": "error-not-allowed",
    "details": {
        "method": "users.setStatus"
    }
  }
  ```

- Paginated and Filtered selects on new/edit unit ([#22052](https://github.com/RocketChat/Rocket.Chat/pull/22052) by [@rafaelblink](https://github.com/rafaelblink))

  REQUIRES https://github.com/RocketChat/Rocket.Chat.Fuselage/pull/447

  Adds infinite scrolling selects to the units edit/create  with the ability to be filtered by text as well

  ![Screen Shot 2021-05-17 at 9 24 19 AM](https://user-images.githubusercontent.com/20868078/118487999-abc32a80-b6f1-11eb-8d58-d031111ea0fb.png)

  This Affects the monitors and departments inputs

- Remove exif metadata from uploaded files ([#22044](https://github.com/RocketChat/Rocket.Chat/pull/22044))

### 🚀 Improvements


- Add groups to the directory channels list ([#21687](https://github.com/RocketChat/Rocket.Chat/pull/21687))

  - Add groups (private channels) to the directory channels list. Only groups in which the logged user is subscribed are shown in the list.

- Add support to queries in `channels.members` and `groups.members` endpoints ([#21414](https://github.com/RocketChat/Rocket.Chat/pull/21414))

  - Add support to queries (within the `query` parameter) in `channels.members` and `groups.members` endpoints.

- Add support to queries in the `im.members` endpoint ([#21471](https://github.com/RocketChat/Rocket.Chat/pull/21471))

  - Add support to queries within the `name`, `username` and `status` parameters.

- Add team members to channel when set as auto join ([#22056](https://github.com/RocketChat/Rocket.Chat/pull/22056) by [@g-thome](https://github.com/g-thome))

  Create a channels.autojoin endpoint to set a channel as autojoin. Also make it so that old team members join this channel automatically

- CAS popup login size input type ([#21907](https://github.com/RocketChat/Rocket.Chat/pull/21907) by [@Deepak-learner](https://github.com/Deepak-learner))

- Inconsistent and misleading 2FA settings ([#22042](https://github.com/RocketChat/Rocket.Chat/pull/22042) by [@lucassartor](https://github.com/lucassartor))

  Currently, there are some inconsistencies and incorrect behaviors on the 2FA settings, such as:


  - When disabling the TOTP 2FA, all 2FA are disabled;

  - There are no option to disable only the TOTP 2FA;

  - If 2FA are disabled, the other settings aren't blocked (the e-mail 2FA setting, for example);

  - It lacks some labels to warn the user of some specific 2FA options.

  This PR looks to fix those issues.

- LDAP port setting input type to allow only numbers ([#21912](https://github.com/RocketChat/Rocket.Chat/pull/21912) by [@Deepak-learner](https://github.com/Deepak-learner))

- Missing modal on deleting a role ([#22020](https://github.com/RocketChat/Rocket.Chat/pull/22020))

  ![image](https://user-images.githubusercontent.com/27704687/118047610-613c5980-b351-11eb-96c7-6b28ae24363e.png)

- Omnichannel Room Information panel flow when user save or close on form page. ([#21688](https://github.com/RocketChat/Rocket.Chat/pull/21688) by [@rafaelblink](https://github.com/rafaelblink))

- Prevent gallery to close when clicking on a non-zoomable image ([#21854](https://github.com/RocketChat/Rocket.Chat/pull/21854))

- Replace method to API Endpoint on Prune Messages ([#21836](https://github.com/RocketChat/Rocket.Chat/pull/21836))

- Support for Google OAuth for mobile app ([#22014](https://github.com/RocketChat/Rocket.Chat/pull/22014))

### 🐛 Bug fixes


- **APPS:** Scheduler duplicating recurrent tasks after server restart ([#21866](https://github.com/RocketChat/Rocket.Chat/pull/21866))

  Reintroduces the old method for creating recurring tasks in the apps' scheduler bridge to ensure tasks won't be duplicated.

  By introducing the [`skipImmediate` property option](https://github.com/RocketChat/Rocket.Chat/pull/21353)  at the [`scheduleRecurring`](https://github.com/RocketChat/Rocket.Chat/blob/f8171f464ed8a7487795651767695fb33a1c709e/app/apps/server/bridges/scheduler.js#L119) method, the `every` method from _agenda.js_, which ensured no duplicates were created, was removed in favor of a more manual procedure. The new procedure was not taking into account the management of duplicates and as a result multiple copies of the same task could be created and they would get executed at the same time.

  In the case of server restarts, every time this event happened and the app had the `startupSetting` configured to use _recurring tasks_, they would get recreated the same number of times. In the case of a server that restarts frequently (_n_ times), there would be the same (_n_) number of tasks duplicated (and running) in the system.

- **ENTERPRISE:** Omnichannel Monitors can't forward chats to departments that they are not supervising ([#22128](https://github.com/RocketChat/Rocket.Chat/pull/22128))

  Currently, Omnichannel Monitors just can't forward chats to a department that is part of a `Business Unit` they're not supervising. This issue is causing critical problems on customer operations since this behaviour is not by design.
  The reason this issue is taking place is that, by design, Monitors just have access to departments related to the `Business Units` they're monitoring, but this restriction is designed only for Omnichannel management areas, which means in case the monitor is, also, an agent, they're supposed to be able to forward a chat to any available departments regardless the `Business Units` it's associated with.
  So, initially, the restriction was implemented on the `Department Model` and, now, we're implementing the logic properly and introducing a new parameter to department endpoints, so the client will define which type of departments it needs.

- **ENTERPRISE:** Omnichannel Monitors can't forward chats to departments that they are not supervising ([#22142](https://github.com/RocketChat/Rocket.Chat/pull/22142))

- Adding Custom Fields to show on user info check ([#20955](https://github.com/RocketChat/Rocket.Chat/pull/20955))

  The setting custom fields to show under user info was not being used when rendering fields in user info. This pr adds those checks and only renders the fields mentioned under in admin -> accounts -> Custom Fields to Show in User Info.

- Adding permission 'add-team-channel' for Team Channels Contextual bar ([#21591](https://github.com/RocketChat/Rocket.Chat/pull/21591))

  Added 'add-team-channel' permission to the 2 buttons in team channels contextual bar, for adding channels to teams.

- Adding retentionEnabledDefault check before showing warning message  ([#20692](https://github.com/RocketChat/Rocket.Chat/pull/20692))

  Added check for retentionEnabledDefault before showing prune warning message.

- App crashes when downloads come from WebDAV and the server is not available ([#21985](https://github.com/RocketChat/Rocket.Chat/pull/21985))

- App license error detail message removed ([#22091](https://github.com/RocketChat/Rocket.Chat/pull/22091))

  Banner in the App Detail page that showed a message explaining why the license validation had failed was removed previously, likely during the React rewrite.

  We're bringing it back.

- Auto-join Tags misalignment  ([#21980](https://github.com/RocketChat/Rocket.Chat/pull/21980))

  <img width="419" alt="Captura de Tela 2021-05-06 às 18 07 07" src="https://user-images.githubusercontent.com/27704687/117366637-7586df00-ae97-11eb-80ca-f41fd7515ff0.png">

- Close stream properly at Omnichannel room when move to queue ([#22015](https://github.com/RocketChat/Rocket.Chat/pull/22015))

- Contact Bar not reactive  ([#22016](https://github.com/RocketChat/Rocket.Chat/pull/22016) by [@rafaelblink](https://github.com/rafaelblink))

- Convert a channel to Team Modal Visual Issues ([#21967](https://github.com/RocketChat/Rocket.Chat/pull/21967))

  ![image](https://user-images.githubusercontent.com/27704687/117193225-fae79200-adb8-11eb-9f09-e8d328f3228b.png)

- Correcting a the wrong Archived label in edit room ([#21717](https://github.com/RocketChat/Rocket.Chat/pull/21717) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  ![image](https://user-images.githubusercontent.com/45966964/116584997-3cd78a80-a918-11eb-81fa-8a7eb5318ae9.png)

  A label exists for Archived, and it has not been used. So I replaced it with the existing one. the label 'Archived' does not exist.

- Custom OAuth not being completely deleted ([#21637](https://github.com/RocketChat/Rocket.Chat/pull/21637) by [@siva2204](https://github.com/siva2204))

- Directory Table's Sort Function ([#21921](https://github.com/RocketChat/Rocket.Chat/pull/21921))

  ### TableRow Margin Issue:
  ![image](https://user-images.githubusercontent.com/27704687/116907348-d6a07f80-ac17-11eb-9411-edfe0906bfe1.png)

  ### Table Sort Action Issue:
  ![directory](https://user-images.githubusercontent.com/27704687/116907441-f20b8a80-ac17-11eb-8790-bfce19e89a67.gif)

- Discussion names showing a random value ([#22172](https://github.com/RocketChat/Rocket.Chat/pull/22172))

- Dismiss button for save your encryption password dialog Issue#13557 ([#19872](https://github.com/RocketChat/Rocket.Chat/pull/19872) by [@savish28](https://github.com/savish28))

- Display Modes ([#22058](https://github.com/RocketChat/Rocket.Chat/pull/22058))

- Emails being sent with HTML entities getting escaped multiple times ([#21994](https://github.com/RocketChat/Rocket.Chat/pull/21994) by [@bhavayAnand9](https://github.com/bhavayAnand9))

  fixes an issue where if password contains special HTML character like &, in the email it would end up something like `&amp;amp;`


  password was going through multiple escapeHTML function calls
  `secure&123 => secure&amp;123 => secure&amp;amp;123
  `

- Error when you look at the members list of a room in which you are not a member ([#21952](https://github.com/RocketChat/Rocket.Chat/pull/21952) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  Before, when you look at the members of a room in which you are not a member the app crashed, i corrected this problem.
  Indeed, there was a check on each currentSubscription.<somehting> to see if it was not undefined except on currentSubscription.blocker

  https://user-images.githubusercontent.com/45966964/117087470-d3101400-ad4f-11eb-8f44-0ebca830a4d8.mp4

- errors when viewing a room that you're not subscribed to ([#21984](https://github.com/RocketChat/Rocket.Chat/pull/21984))

- Files list will not show deleted files. ([#21732](https://github.com/RocketChat/Rocket.Chat/pull/21732) by [@Darshilp326](https://github.com/Darshilp326))

  When you delete files from the header option, deleted files will not be shown.

  https://user-images.githubusercontent.com/55157259/115730786-38552400-a3a4-11eb-9684-7f510920db66.mp4

- Fixed the fact that when a team was deleted, not all channels were unlinked from the team ([#21942](https://github.com/RocketChat/Rocket.Chat/pull/21942) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  Fixed the fact that when a team was deleted, not all channels were unlinked from the team. Only the first room of the rooms list was unlinked.

  After the fix, there is nos more errors:


  https://user-images.githubusercontent.com/45966964/117055182-2a47c180-ad1b-11eb-806f-07fb3fa7ec12.mp4

- Fixing Jitsi call ended Issue. ([#21808](https://github.com/RocketChat/Rocket.Chat/pull/21808))

  The new rewrite in react of contextual call component broke the Jitsi "click to join" messages. The issue being after 10 seconds of initiating the call, the message "click to join" always returned "Call Ended" even if the call was still going on.
  This was due to the fact that after closing the contextual bar, the react component gets unmounted and we are not able to keep track of ongoing call and increase jitsi room timeout.

  This PR solves this issue by using the setInterval methods on component will unmount. When the call component unmounts, we keep on checking the state of jitsi call and based on conditions increase the jitsi room timeout. After the call is ended all setInterval calls are closed.

  This PR also removes the implementation of HEARTBEAT events of JitsiBridge. This is because this is no longer needed and all logic is being taken care of by the unmount function.

- Handle NPS errors instead of throwing them ([#21945](https://github.com/RocketChat/Rocket.Chat/pull/21945))

- Header Tag Visual Issues ([#21991](https://github.com/RocketChat/Rocket.Chat/pull/21991))

  ### Normal
  ![image](https://user-images.githubusercontent.com/27704687/117504793-69635600-af59-11eb-8b79-9d8f631490ee.png)

  ### Hover
  ![image](https://user-images.githubusercontent.com/27704687/117504934-97489a80-af59-11eb-87c3-0a62731e9ce3.png)

- Horizontal scrollbar not showing on tables ([#21852](https://github.com/RocketChat/Rocket.Chat/pull/21852))

- IE11 support ([#21893](https://github.com/RocketChat/Rocket.Chat/pull/21893))

- iFrame size on embedded videos ([#21992](https://github.com/RocketChat/Rocket.Chat/pull/21992))

  ### Before
  ![image](https://user-images.githubusercontent.com/27704687/117508802-8bf86d80-af5f-11eb-9eb8-29e55b73eac5.png)

  ### After
  ![image](https://user-images.githubusercontent.com/27704687/117508870-a4688800-af5f-11eb-9176-7f24de5fc424.png)

- Incorrect error message when opening channel in anonymous read ([#22066](https://github.com/RocketChat/Rocket.Chat/pull/22066) by [@lucassartor](https://github.com/lucassartor))

  Every time you open a public channel with threads in it when using anonymous read an `Incorrect User` error will be thrown.
  This is an incorrect behaviour as everything that is public should be valid for an anonymous user.

  Some files are adapted to that and have already removed this kind of incorrect error, but there are some that need some fix, this PR aims to do that.

- Incorrect Team's Info spacing ([#22021](https://github.com/RocketChat/Rocket.Chat/pull/22021))

  ![image](https://user-images.githubusercontent.com/27704687/118049044-9053ca80-b353-11eb-8b21-7a309ec2ba7e.png)

- Label's disabled color on Create New Modal ([#21975](https://github.com/RocketChat/Rocket.Chat/pull/21975))

  <img width="572" alt="Captura de Tela 2021-05-06 às 13 20 06" src="https://user-images.githubusercontent.com/27704687/117332505-4f007e00-ae6e-11eb-85de-03a21e5e2a36.png">

- Make the FR translation consistent with the 'room' translation + typos ([#21913](https://github.com/RocketChat/Rocket.Chat/pull/21913) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  In the FR translation files, there were two terms that were used to refer to **'room'**:

  - 'salon' (149 times used)

  ![image](https://user-images.githubusercontent.com/45966964/116829860-ac62a980-aba6-11eb-8212-e6f15ed0af82.png)


  - 'salle' (46 times used)

  ![image](https://user-images.githubusercontent.com/45966964/116829871-be444c80-aba6-11eb-9b42-e213fee6586a.png)

  The problem is that both were used in the same context and sometimes even in the same option list.
  However, since 'salon' is a better translation and was also in the majority, I used the translation 'salon' wherever 'salle' was marked.

  For example:
  ![image](https://user-images.githubusercontent.com/45966964/116830523-1da45b80-abab-11eb-81f8-5225d51cecc6.png)

- Maximum 25 channels can be loaded in the teams' channels list ([#21708](https://github.com/RocketChat/Rocket.Chat/pull/21708) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  Before a maximum 25 of channels was able to be displayed in the teams' channels list.

- Missing margins on select team modal ([#21965](https://github.com/RocketChat/Rocket.Chat/pull/21965))

  ![select_team](https://user-images.githubusercontent.com/27704687/117164325-e5fc0600-ad9a-11eb-861e-a246064b78b4.png)

- Missing proper permissions on Teams Channels ([#21946](https://github.com/RocketChat/Rocket.Chat/pull/21946))

- No warning message is sent when user is removed from a team's main channel ([#21949](https://github.com/RocketChat/Rocket.Chat/pull/21949))

  - Send a warning message to a team's main channel when a user is removed from the team;
   - Trigger events while removing a user from a team's main channel;
   - Fix `usersCount` field in the team's main room when a user is removed from the team (`usersCount` is now decreased by 1).

- Not possible accept video call if "Hide right sidebar with click" is enabled ([#22175](https://github.com/RocketChat/Rocket.Chat/pull/22175))

- Notify with sound first message in queue list ([#21969](https://github.com/RocketChat/Rocket.Chat/pull/21969))

- Open a new DM throwing  error 404 ([#22100](https://github.com/RocketChat/Rocket.Chat/pull/22100))

  Adapts the `openRoom` function to the new signature of `createDirectMessage`.

- Permission's scope on Teams Channels ([#22083](https://github.com/RocketChat/Rocket.Chat/pull/22083))

  Allow moderators and owners to add or create channels on Teams Channels

- Presence.get method ([#22129](https://github.com/RocketChat/Rocket.Chat/pull/22129))

  closes #21873

- Prevent the userInfo tab to return 'User not found' each time if a certain member of a DM group has been deleted ([#21970](https://github.com/RocketChat/Rocket.Chat/pull/21970) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  Prevent the userInfo tab to return 'User not found' if a member of a DM group has been deleted.
  This happens if the user that has been deleted is the one originally displayed on the userInfo tab in a DM group with >2 users.

  https://user-images.githubusercontent.com/45966964/117221081-db785580-ae08-11eb-9b33-2314a99eb037.mp4

- Prune messages not cleaning up unread threads ([#21326](https://github.com/RocketChat/Rocket.Chat/pull/21326) by [@renancleyson-dev](https://github.com/renancleyson-dev))

  Fixes permanent unread messages when admin prune at least two different thread messages in the room that were unread by some user.
  ![screencapture-localhost-3000-channel-general-thread-2021-03-26-13_17_16](https://user-images.githubusercontent.com/43624243/112678973-62b9cd00-8e4a-11eb-9af9-56f17cc66baf.png)

- Redirect on remove user from channel by user profile tab ([#21951](https://github.com/RocketChat/Rocket.Chat/pull/21951))

  ![redirect](https://user-images.githubusercontent.com/27704687/117078454-498d2180-ad10-11eb-9df2-936552a2b3ce.gif)

- Remove referer header when requesting attachment data ([#21987](https://github.com/RocketChat/Rocket.Chat/pull/21987))

- Removed fields from User Info for which the user doesn't have permissions. ([#20923](https://github.com/RocketChat/Rocket.Chat/pull/20923) by [@Darshilp326](https://github.com/Darshilp326))

  Removed LastLogin, CreatedAt and Roles for users who don't have permission.

  https://user-images.githubusercontent.com/55157259/109381351-f2c62e80-78ff-11eb-9289-e11072bf62f8.mp4

- Replace `query` param by `name`, `username` and `status` on the `teams.members` endpoint ([#21539](https://github.com/RocketChat/Rocket.Chat/pull/21539))

  - Replace `query` param by `name`, `username` and `status` on the `teams.members` endpoint.

- Scenarios where 2FA enforcement was not working properly ([#22017](https://github.com/RocketChat/Rocket.Chat/pull/22017))

- Tooltip pointer is blocking Text ([#21645](https://github.com/RocketChat/Rocket.Chat/pull/21645) by [@sumukhah](https://github.com/sumukhah))

- Unable to edit a 'direct' room setting in the admin due to the room name ([#21636](https://github.com/RocketChat/Rocket.Chat/pull/21636) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  When you are in the admin and want to change a room 'd' setting, it doesn't work because it takes into account the name that is set automatically and therefore tries to save that name. Since the name is not valid and should not be registered, we cannot change the setting for the 'd' room.
  I made sure that when you want to change a setting in a 'd' room, that you don't take the name into account


  https://user-images.githubusercontent.com/45966964/115150919-cd85af00-a06a-11eb-9667-ef3dcfc5adb6.mp4


  Behind the scene, the name is not saved

- Unable to edit a user who does not have an email via the admin or via the user's profile ([#21626](https://github.com/RocketChat/Rocket.Chat/pull/21626) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  If a user does not have an email address, they cannot change it via their profile or via the admin. I fixed this issue. I have created several profiles and there was one that didn't have an email, I don't know how I did it, I am working on it. I had not modified the db to delete his email, hence the fix

  in admin

  https://user-images.githubusercontent.com/45966964/115112617-9b9b1c80-9f86-11eb-8e3a-950c3c1a1746.mp4



  in the user profile

  https://user-images.githubusercontent.com/45966964/115112620-a0f86700-9f86-11eb-97b1-56eaba42216b.mp4

- Unable to get channels, sort by most recent message ([#21701](https://github.com/RocketChat/Rocket.Chat/pull/21701) by [@sumukhah](https://github.com/sumukhah))

- Unable to update app manually ([#21215](https://github.com/RocketChat/Rocket.Chat/pull/21215))

  It allows for update of apps using a zip file.

  When installing apps using the zip file, either by url or the file form, if the app was already installed, an error would be thrown stating the condition and forbidding the installation. Now, when sending a zip file of an app that is already installed, the user is presented with the following modal:

  ![2021-04-30-113936_627x235_scrot](https://user-images.githubusercontent.com/733282/116711383-2cbbbb80-a9a9-11eb-8c77-22d6802cb9f5.png)

  If the app also requires permissions to be reviewed, the modal that handles permission reviews will be shown after this one is accepted.

- Unpin message reactivity ([#22029](https://github.com/RocketChat/Rocket.Chat/pull/22029))

  ![Peek 2021-05-13 11-18](https://user-images.githubusercontent.com/27704687/118138696-03555380-b3dd-11eb-8549-730fff0b4ea8.gif)

- Uploading files from WebDAV ([#21948](https://github.com/RocketChat/Rocket.Chat/pull/21948))

- User Impersonation through sendMessage API ([#20391](https://github.com/RocketChat/Rocket.Chat/pull/20391) by [@lucassartor](https://github.com/lucassartor))

  Create a new permission: `message-impersonate`. For new installs only bot role will have the permission and for updating installs the permission will also be given to user role, so it won't break running deployments.

  If a message is being sent with `avatar` or `alias` properties, it validates if the sender has the `message-impersonate` permission, if not, an error is throwed:
  ```json
  {
    "success": false,
    "error": "Not enough permission",
    "stack": "Error: Not enough permission\n ..."
  }
  ```

- Visibility of burger menu on certain width ([#20736](https://github.com/RocketChat/Rocket.Chat/pull/20736))

  Burger was not visible on a certain width, specifically between 600 to   780. if width is more than 780px sidebar is shown, if less than 600 then burger icon was shown. But it wasn't shown between 600px to 780 px.
  It was because for showing burger icon we were only checking for `isMobile` which is lenght only less than   600. So i added one more check for condition if length is less than 780 px.

- When closing chats a comment is always required ([#21947](https://github.com/RocketChat/Rocket.Chat/pull/21947))

  Fixes issue with the setting `Livechat_request_comment_when_closing_conversation` not working as intended

- Workaround for Autolinker phone problem ([#21515](https://github.com/RocketChat/Rocket.Chat/pull/21515))

- Wrong color and size, thread list Metrics ([#21950](https://github.com/RocketChat/Rocket.Chat/pull/21950))

  ![image](https://user-images.githubusercontent.com/40830821/117066452-1db57000-acff-11eb-9e75-956db65b2fb9.png)

- Wrong icon on "Move to team" option in the channel info actions ([#21944](https://github.com/RocketChat/Rocket.Chat/pull/21944))

  ![image](https://user-images.githubusercontent.com/40830821/117061659-d9bf6c80-acf8-11eb-8e29-be47e702dedd.png)

  Depends on https://github.com/RocketChat/Rocket.Chat.Fuselage/pull/444

<details>
<summary>🔍 Minor changes</summary>


- [EE] Improve Forwarding Department behaviour with Waiting queue feature ([#22043](https://github.com/RocketChat/Rocket.Chat/pull/22043))

- [EE] Omnichannel monitors not authorized to view departments ([#22048](https://github.com/RocketChat/Rocket.Chat/pull/22048))

- [FIXf] Parent Room Tag Overlapping ([#22009](https://github.com/RocketChat/Rocket.Chat/pull/22009))

  ![tag](https://user-images.githubusercontent.com/27704687/117905720-069bf280-b2aa-11eb-81ed-a5b8c2152d54.gif)

- Add two more test cases to the slash-command test suite ([#21317](https://github.com/RocketChat/Rocket.Chat/pull/21317) by [@EduardoPicolo](https://github.com/EduardoPicolo))

  Added two more test cases to the slash-command test suite:

  - 'should return an error when the command does not exist'';

  - 'should return an error when no command is provided';

- Bump actions/stale from v3.0.8 to v3.0.18 ([#21877](https://github.com/RocketChat/Rocket.Chat/pull/21877) by [@dependabot[bot]](https://github.com/dependabot[bot]))

- Bump: Fuselage 0.26.0 ([#22178](https://github.com/RocketChat/Rocket.Chat/pull/22178))

- Chore: Add missing 'Teams' label in the i18n files for every languages ([#21751](https://github.com/RocketChat/Rocket.Chat/pull/21751) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  I added the missing Teams label in the i18n folder for EN, FR & NL

- Chore: Add mongo 4.2 to array of mongo versions supported ([#21550](https://github.com/RocketChat/Rocket.Chat/pull/21550))

  - MongoDB 4.2 is now supported

- Chore: Bump message parser ([#22101](https://github.com/RocketChat/Rocket.Chat/pull/22101))

- Chore: Correct some spelling/typos in English for descriptions/modal ([#21832](https://github.com/RocketChat/Rocket.Chat/pull/21832) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  I found typos, spelling mistakes, I corrected them

- Chore: Doc Client Readme ([#21588](https://github.com/RocketChat/Rocket.Chat/pull/21588) by [@umakantv](https://github.com/umakantv))

- Chore: fix invalid type name on TS file ([#21814](https://github.com/RocketChat/Rocket.Chat/pull/21814))

- Chore: Storybook organization and errors ([#21923](https://github.com/RocketChat/Rocket.Chat/pull/21923))

- Chore: Update Docker container references to use registry.rocket.chat endpoint ([#22080](https://github.com/RocketChat/Rocket.Chat/pull/22080) by [@aviaviavi](https://github.com/aviaviavi))

  This change updates the Docker installation instructions to use the new registry.rocket.chat endpoint to pull the rocketchat/rocket.chat container. This is part of the rollout described here: https://rocket.chat/blog/product/docker-images-change/

- Chore: update fuselage && icons ([#22092](https://github.com/RocketChat/Rocket.Chat/pull/22092))

- i18n: Add missing translation string in account preference ([#21448](https://github.com/RocketChat/Rocket.Chat/pull/21448) by [@sumukhah](https://github.com/sumukhah))

  "Test Desktop Notifications" was missing in translation, Added to the file.
  <img width="691" alt="Screenshot 2021-04-05 at 3 58 01 PM" src="https://user-images.githubusercontent.com/23723464/113565830-475c7800-9629-11eb-8d93-3c177b9d0030.png">

  <img width="701" alt="Screenshot 2021-04-05 at 3 58 32 PM" src="https://user-images.githubusercontent.com/23723464/113565823-44fa1e00-9629-11eb-9af1-839f42e132ca.png">

- i18n: Correct a typo in German ([#21711](https://github.com/RocketChat/Rocket.Chat/pull/21711) by [@Jeanstaquet](https://github.com/Jeanstaquet))

- Language update from LingoHub 🤖 on 2021-04-26Z ([#21801](https://github.com/RocketChat/Rocket.Chat/pull/21801))

- Language update from LingoHub 🤖 on 2021-05-03Z ([#21917](https://github.com/RocketChat/Rocket.Chat/pull/21917))

- Language update from LingoHub 🤖 on 2021-05-10Z ([#21998](https://github.com/RocketChat/Rocket.Chat/pull/21998))

- Language update from LingoHub 🤖 on 2021-05-18Z ([#22065](https://github.com/RocketChat/Rocket.Chat/pull/22065))

- Merge master into develop & Set version to 3.15.0-develop ([#21847](https://github.com/RocketChat/Rocket.Chat/pull/21847))

- Regression: Add "User left team" message type ([#22109](https://github.com/RocketChat/Rocket.Chat/pull/22109))

  - Add 'ult' system message type, which is sent when a user leaves a team ("Has left the team.").

- Regression: Add i18n to license error messages ([#22171](https://github.com/RocketChat/Rocket.Chat/pull/22171))

- Regression: Add impersonate permission to app role ([#22006](https://github.com/RocketChat/Rocket.Chat/pull/22006))

- regression: bump Rocket.Chat.Fuselage package with paginated selects ([#22059](https://github.com/RocketChat/Rocket.Chat/pull/22059))

- Regression: discussions display on sidebar ([#22157](https://github.com/RocketChat/Rocket.Chat/pull/22157))

  ### group by type active
  ![image](https://user-images.githubusercontent.com/27704687/119741996-37a92500-be5d-11eb-8b36-4067a7a229f1.png)

  ### group by type inactive
  ![image](https://user-images.githubusercontent.com/27704687/119742054-56a7b700-be5d-11eb-8810-e31d4216f573.png)

- regression: fix departments with empty ancestors not being returned ([#22068](https://github.com/RocketChat/Rocket.Chat/pull/22068))

- Regression: Fix new 'message-impersonate' permission blocking livechat messages ([#21961](https://github.com/RocketChat/Rocket.Chat/pull/21961))

- Regression: Fix send message validation ([#21982](https://github.com/RocketChat/Rocket.Chat/pull/21982))

- regression: Fix Users list in the Administration  ([#22034](https://github.com/RocketChat/Rocket.Chat/pull/22034) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  The app crashed if no custom fields for user profiles have been created by the admin. I fixed this issue. This bug was introduced by a recent commit.

  https://user-images.githubusercontent.com/45966964/118210838-5b3a9b80-b46b-11eb-9fe5-5b813848190c.mp4

- Regression: Improve migration 225 ([#22099](https://github.com/RocketChat/Rocket.Chat/pull/22099))

- Regression: Make referrer header configurable ([#22126](https://github.com/RocketChat/Rocket.Chat/pull/22126))

- Regression: Match `name` or `fname` when fetching room to send notification for blocked log in attemps ([#22067](https://github.com/RocketChat/Rocket.Chat/pull/22067))

- regression: Migration 225 setting not being fetched correctly ([#22108](https://github.com/RocketChat/Rocket.Chat/pull/22108))

- Regression: Missing room scope on teams channels permission ([#22137](https://github.com/RocketChat/Rocket.Chat/pull/22137))

- regression: Misspelled property in migration 225 ([#22093](https://github.com/RocketChat/Rocket.Chat/pull/22093))

- Regression: not allowed to edit roles due to a new verification ([#22159](https://github.com/RocketChat/Rocket.Chat/pull/22159))

  introduced by https://github.com/RocketChat/Rocket.Chat/pull/21905
  ![Peek 2021-05-26 22-21](https://user-images.githubusercontent.com/27704687/119750970-b9567e00-be70-11eb-9d52-04c8595950df.gif)

- regression: Select Team Modal margin ([#22030](https://github.com/RocketChat/Rocket.Chat/pull/22030))

  ![image](https://user-images.githubusercontent.com/27704687/118140652-f2a5dd00-b3de-11eb-8075-d0cac4b28650.png)

- regression: UserInfoTab Broken ([#22019](https://github.com/RocketChat/Rocket.Chat/pull/22019))

- Regression: Visual issue on sort list item  ([#22158](https://github.com/RocketChat/Rocket.Chat/pull/22158))

  ### before
  ![image](https://user-images.githubusercontent.com/27704687/119743703-d84d1400-be60-11eb-97cc-c8256b2c8b07.png)

  ### after
  ![image](https://user-images.githubusercontent.com/27704687/119743638-b18edd80-be60-11eb-828d-22cc5e1b2f5b.png)

- Release 3.14.2 ([#22135](https://github.com/RocketChat/Rocket.Chat/pull/22135))

- Release 3.14.4 ([#22181](https://github.com/RocketChat/Rocket.Chat/pull/22181))

- Remove memory leak from userData ([#22094](https://github.com/RocketChat/Rocket.Chat/pull/22094) by [@g-thome](https://github.com/g-thome))

- String helpers ([#21988](https://github.com/RocketChat/Rocket.Chat/pull/21988))

  It uses string helpers from a external package (`@rocket.chat/string-helpers`).

- Update Apps-Engine version ([#22176](https://github.com/RocketChat/Rocket.Chat/pull/22176))

- Upgrade to GitHub-native Dependabot ([#21874](https://github.com/RocketChat/Rocket.Chat/pull/21874) by [@dependabot-preview[bot]](https://github.com/dependabot-preview[bot]))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Darshilp326](https://github.com/Darshilp326)
- [@Deepak-learner](https://github.com/Deepak-learner)
- [@EduardoPicolo](https://github.com/EduardoPicolo)
- [@Jeanstaquet](https://github.com/Jeanstaquet)
- [@aviaviavi](https://github.com/aviaviavi)
- [@bhavayAnand9](https://github.com/bhavayAnand9)
- [@dependabot-preview[bot]](https://github.com/dependabot-preview[bot])
- [@dependabot[bot]](https://github.com/dependabot[bot])
- [@g-thome](https://github.com/g-thome)
- [@lucassartor](https://github.com/lucassartor)
- [@rafaelblink](https://github.com/rafaelblink)
- [@renancleyson-dev](https://github.com/renancleyson-dev)
- [@savish28](https://github.com/savish28)
- [@siva2204](https://github.com/siva2204)
- [@sumukhah](https://github.com/sumukhah)
- [@umakantv](https://github.com/umakantv)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@marceloschmidt](https://github.com/marceloschmidt)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@renatobecker](https://github.com/renatobecker)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 3.14.5
`2021-06-06  ·  1 🚀  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.25.0`

### 🚀 Improvements


- Send only relevant data via WebSocket ([#22258](https://github.com/RocketChat/Rocket.Chat/pull/22258))

  Previously when any data changed on subscriptions or rooms we were getting fresh data from database, to also remove undesired fields, but sometimes the data that changed was not relevant so we were sending the whole object everytime **without** the fields that actually changed. This change aims to reduce this overhead and also send less data to clients.

### 🐛 Bug fixes


- Support DISABLE_PRESENCE_MONITOR env var in new DB watchers ([#22257](https://github.com/RocketChat/Rocket.Chat/pull/22257))

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.14.4
`2021-05-28  ·  2 🐛  ·  1 🔍  ·  2 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.25.0`

### 🐛 Bug fixes


- Discussion names showing a random value ([#22172](https://github.com/RocketChat/Rocket.Chat/pull/22172))

- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

<details>
<summary>🔍 Minor changes</summary>


- Release 3.14.4 ([#22181](https://github.com/RocketChat/Rocket.Chat/pull/22181))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@ggazzo](https://github.com/ggazzo)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.14.3
`2021-05-26  ·  1 🐛  ·  1 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.25.0`

### 🐛 Bug fixes


- **ENTERPRISE:** Omnichannel Monitors can't forward chats to departments that they are not supervising ([#22142](https://github.com/RocketChat/Rocket.Chat/pull/22142))

<details>
<summary>🔍 Minor changes</summary>


- Release 3.14.3 ([#22147](https://github.com/RocketChat/Rocket.Chat/pull/22147))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@murtaza98](https://github.com/murtaza98)
- [@renatobecker](https://github.com/renatobecker)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.14.2
`2021-05-25  ·  1 🐛  ·  1 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.25.0`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

<details>
<summary>🔍 Minor changes</summary>


- Release 3.14.2 ([#22135](https://github.com/RocketChat/Rocket.Chat/pull/22135))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@g-thome](https://github.com/g-thome)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.14.1
`2021-05-19  ·  1 🎉  ·  2 🚀  ·  4 🐛  ·  3 🔍  ·  7 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.25.0`

### 🎉 New features


- Paginated and Filtered selects on new/edit unit ([#22052](https://github.com/RocketChat/Rocket.Chat/pull/22052) by [@rafaelblink](https://github.com/rafaelblink))

  REQUIRES https://github.com/RocketChat/Rocket.Chat.Fuselage/pull/447

  Adds infinite scrolling selects to the units edit/create  with the ability to be filtered by text as well

  ![Screen Shot 2021-05-17 at 9 24 19 AM](https://user-images.githubusercontent.com/20868078/118487999-abc32a80-b6f1-11eb-8d58-d031111ea0fb.png)

  This Affects the monitors and departments inputs

### 🚀 Improvements


- Forwarding Department behaviour with Waiting queue feature ([#22043](https://github.com/RocketChat/Rocket.Chat/pull/22043))

- Omnichannel Room Information panel flow when user save or close on form page. ([#21688](https://github.com/RocketChat/Rocket.Chat/pull/21688) by [@rafaelblink](https://github.com/rafaelblink))

### 🐛 Bug fixes


- Close stream properly at Omnichannel room when move to queue ([#22015](https://github.com/RocketChat/Rocket.Chat/pull/22015))

- IE11 support ([#21893](https://github.com/RocketChat/Rocket.Chat/pull/21893))

- Notify with sound first message in queue list ([#21969](https://github.com/RocketChat/Rocket.Chat/pull/21969))

- When closing chats a comment is always required ([#21947](https://github.com/RocketChat/Rocket.Chat/pull/21947))

  Fixes issue with the setting `Livechat_request_comment_when_closing_conversation` not working as intended

<details>
<summary>🔍 Minor changes</summary>


- [EE] Omnichannel monitors not authorized to view departments ([#22048](https://github.com/RocketChat/Rocket.Chat/pull/22048))

- [Patch] [EE] Improve Forwarding Department behaviour with Waiting queue feature ([#22077](https://github.com/RocketChat/Rocket.Chat/pull/22077))

- regression: fix departments with empty ancestors not being returned ([#22068](https://github.com/RocketChat/Rocket.Chat/pull/22068))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@rafaelblink](https://github.com/rafaelblink)

### 👩‍💻👨‍💻 Core Team 🤓

- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@dougfabris](https://github.com/dougfabris)
- [@ggazzo](https://github.com/ggazzo)
- [@murtaza98](https://github.com/murtaza98)
- [@renatobecker](https://github.com/renatobecker)
- [@tiagoevanp](https://github.com/tiagoevanp)

# 3.14.0
`2021-04-28  ·  9 🎉  ·  9 🚀  ·  55 🐛  ·  38 🔍  ·  30 👩‍💻👨‍💻`

### Engine versions
- Node: `12.22.1`
- NPM: `6.14.1`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.25.0`

### 🎉 New features


- **APPS:** Method to fetch Livechat Departments ([#21690](https://github.com/RocketChat/Rocket.Chat/pull/21690))

  New method in the livechat bridge that allows apps to fetch departments that are enabled and have agents assigned

- **APPS:** onInstall and onUninstall events ([#21565](https://github.com/RocketChat/Rocket.Chat/pull/21565) by [@lucassartor](https://github.com/lucassartor))

  Adding the `user` information when installing and uninstalling an App to the Apps-Engine.

- **ENTERPRISE:** LDAP Teams Sync ([#21658](https://github.com/RocketChat/Rocket.Chat/pull/21658))

- **Enterprise:** Second layer encryption for data transport (alpha) ([#21692](https://github.com/RocketChat/Rocket.Chat/pull/21692))

  The second layer encryption for data transport works implementing the ECDH algorithm where session keys are exchanged before the rest of the communication. This feature is **enterprise only** since it requires the micro-services architecture and it's in the early stage of tests as an **alpha** feature and documentation may not be available before the beta stage.

- New set of rules for client code ([#21318](https://github.com/RocketChat/Rocket.Chat/pull/21318))

  This _small_ PR does the following:


  - Now **React** is the web client's first-class citizen, being **loaded before Blaze**. Thus, `BlazeLayout` calls render templates inside of a React component (`BlazeLayoutWrapper`);

  - Main client startup code, including polyfills, is written in **TypeScript**;

  - At the moment, routes are treated as regular startup code; it's expected that `FlowRouter` will be deprecated in favor of a new routing library;

  - **React** was updated to major version **17**, deprecating the usage of `React` as namespace (e.g. use `memo()` instead of `React.memo()`);

  - The `client/` and `ee/client/` directory are linted with a **custom ESLint configuration** that includes:
    - **Prettier**;
    - `react-hooks/*` rules for TypeScript files;
    - `react/no-multi-comp`, enforcing the rule of **one single React component per module**;
    - `react/display-name`, which enforces that **React components must have a name for debugging**;
    - `import/named`, avoiding broken named imports.

  - A bunch of components were refactored to match the new ESLint rules.

- On Hold system messages ([#21360](https://github.com/RocketChat/Rocket.Chat/pull/21360) by [@rafaelblink](https://github.com/rafaelblink))

  ![image](https://user-images.githubusercontent.com/34130764/115442079-3a49a680-a22f-11eb-9ee8-6c705097cd57.png)

- Password history ([#21607](https://github.com/RocketChat/Rocket.Chat/pull/21607))

  - Store each user's previously used passwords in a `passwordHistory` field (in the `users` record);

  - Users' previously used passwords are stored in their `passwordHistory` even when the setting is disabled;

  - Add "Password History" setting -- when enabled, it blocks users from reusing their most recent passwords;

  - Convert `comparePassword` file to TypeScript.

  ![Password_Change](https://user-images.githubusercontent.com/36537004/115035168-ac726200-9ea2-11eb-93c6-fc8182ba5f3f.png)
  ![Password_History](https://user-images.githubusercontent.com/36537004/115035175-ad0af880-9ea2-11eb-9f40-94c6327a9854.png)

- REST endpoint `teams.update` ([#21134](https://github.com/RocketChat/Rocket.Chat/pull/21134) by [@g-thome](https://github.com/g-thome))

  add teams.update endpoint

- Standard Importer Structure ([#18357](https://github.com/RocketChat/Rocket.Chat/pull/18357))

### 🚀 Improvements


- **APPS:** Scheduler option to skip immediate execution of recurring jobs ([#21353](https://github.com/RocketChat/Rocket.Chat/pull/21353) by [@lolimay](https://github.com/lolimay))

  Create and schedule a task manually at `scheduleRecurring` method so the first iteration runs after the configured interval. This is accomplished by adding the setting `skipImmediate: true` when setting up the task.

- Add error messages to the creation of channels or usernames containing reserved words ([#21016](https://github.com/RocketChat/Rocket.Chat/pull/21016))

  Display error messages when the user attempts to create or edit users' or channels' names with any of the following words (**case-insensitive**):

  - admin;

  - administrator;

  - system;

  - user.
  ![create-channel](https://user-images.githubusercontent.com/36537004/110132223-b421ef80-7da9-11eb-82bc-f0d4e1df967f.png)
  ![register-username](https://user-images.githubusercontent.com/36537004/110132234-b71ce000-7da9-11eb-904e-580233625951.png)
  ![change-channel](https://user-images.githubusercontent.com/36537004/110143057-96f31e00-7db5-11eb-994a-39ae9e63392e.png)
  ![change-username](https://user-images.githubusercontent.com/36537004/110143065-98244b00-7db5-11eb-9d13-afc5dc9866de.png)

- add permission check when adding a channel to a team ([#21689](https://github.com/RocketChat/Rocket.Chat/pull/21689) by [@g-thome](https://github.com/g-thome))

  add permission check for each room

- Add proxy for data export ([#20998](https://github.com/RocketChat/Rocket.Chat/pull/20998))

  Add a proxy for data export downloads (instead of just linking ufs urls) so we can have more control over its response. Also added a human readable message when the user tries to download the user-data unauthenticated.

- Add support to range downloads on file system storage ([#21463](https://github.com/RocketChat/Rocket.Chat/pull/21463))

- Alert on team deletion ([#21617](https://github.com/RocketChat/Rocket.Chat/pull/21617))

  <img width="731" alt="Screen Shot 2021-04-16 at 7 03 30 PM" src="https://user-images.githubusercontent.com/20868078/115088417-7d7ddf80-9ee6-11eb-9e58-1eb2862aa62c.png">

- Do not require pre-configured tags in Omnichannel chats ([#21488](https://github.com/RocketChat/Rocket.Chat/pull/21488) by [@rafaelblink](https://github.com/rafaelblink))

- OEmbed details by requesting using the accept language header on the request ([#21686](https://github.com/RocketChat/Rocket.Chat/pull/21686))

  - Send `Accept-Language` header on oembed requests

- Resize custom emojis on upload instead of saving at max res ([#21593](https://github.com/RocketChat/Rocket.Chat/pull/21593))

  - Create new MediaService (ideally, should be in charge of all media-related operations)

  - Resize emojis to 128x128

### 🐛 Bug fixes


- **Enterprise:** Omnichannel simultaneous chat limit is not properly checking the limit by department ([#21839](https://github.com/RocketChat/Rocket.Chat/pull/21839))

  The Omnichannel Concurrent Chat Limit feature is not working properly when checking the limit per department, the reason is that the algorithm that fetches the number of ongoing chats per agent wasn't considering the department of the subscriptions, hence,  the number returned from DB was bigger than it should be.

- Add tag input to Closing Chat modal ([#21462](https://github.com/RocketChat/Rocket.Chat/pull/21462) by [@rafaelblink](https://github.com/rafaelblink))

- Admin Users list pagination ([#21469](https://github.com/RocketChat/Rocket.Chat/pull/21469))

  - Fix Administration/Users pagination

- Allow deletion of own account for passwordless accounts (e.g. OAUTH) ([#21119](https://github.com/RocketChat/Rocket.Chat/pull/21119) by [@wolbernd](https://github.com/wolbernd))

- Allows more than 25 discussions/files to be loaded in the contextualbar ([#21511](https://github.com/RocketChat/Rocket.Chat/pull/21511) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  In some places, you could not load more than 25 threads/discussions/files on the screen when searching the lists in the contextualbar.
  Threads & list are numbered for a better view of the solution


  https://user-images.githubusercontent.com/45966964/114222225-93335800-996e-11eb-833f-568e83129aae.mp4

- Allows more than 25 threads to be loaded, fixes #21507 ([#21508](https://github.com/RocketChat/Rocket.Chat/pull/21508) by [@Jeanstaquet](https://github.com/Jeanstaquet))

- Allows to display more than 25 users maximum in the users list ([#21518](https://github.com/RocketChat/Rocket.Chat/pull/21518) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  Now when you scroll to the bottom of the users list, it shows more users. Before the fix, the limit for the query for loadMore was calculated so that no additional users could be loaded.

  Before

  https://user-images.githubusercontent.com/45966964/114249739-baece500-999b-11eb-9bb0-3a5bcee18ad8.mp4

  After


  https://user-images.githubusercontent.com/45966964/114249895-364e9680-999c-11eb-985c-47aedc763488.mp4

- App installation from marketplace not correctly displaying the permissions ([#21470](https://github.com/RocketChat/Rocket.Chat/pull/21470))

  Fixes the marketplace app installation not correctly displaying the permissions modal.

- Archive permissions for room moderator ([#21563](https://github.com/RocketChat/Rocket.Chat/pull/21563))

- Attachment files are not rendered properly on SMS channels ([#21746](https://github.com/RocketChat/Rocket.Chat/pull/21746))

- Audio message same pattern as image message ([#21466](https://github.com/RocketChat/Rocket.Chat/pull/21466))

  ![image](https://user-images.githubusercontent.com/17487063/113760168-4c363000-96ec-11eb-9138-0fbcedb3fa42.png)

- Avoid sidebar being broke ([#21490](https://github.com/RocketChat/Rocket.Chat/pull/21490))

- Change margin size for quote messages ([#21461](https://github.com/RocketChat/Rocket.Chat/pull/21461))

  ![image](https://user-images.githubusercontent.com/17487063/113723723-02d3e980-96c8-11eb-9bc7-70aab5ea8091.png)

- Change team private info text ([#21535](https://github.com/RocketChat/Rocket.Chat/pull/21535))

- Change the active appearance for toolbox buttons ([#21416](https://github.com/RocketChat/Rocket.Chat/pull/21416))

  ![image](https://user-images.githubusercontent.com/17487063/113359447-2d1b5500-931e-11eb-81fa-86f60fcee3a9.png)

- Checking 'start-discussion' Permission for MessageBox Actions ([#21564](https://github.com/RocketChat/Rocket.Chat/pull/21564))

  Permissions 'start-discussion-other-user' and 'start-discussion' are checked everywhere before letting anyone start any discussions, this permission check was missing for message box actions, so added it.

- Close chat button is not available for Omnichannel agents ([#21481](https://github.com/RocketChat/Rocket.Chat/pull/21481) by [@rafaelblink](https://github.com/rafaelblink))

- Correcting the case there are no result in admin users list  ([#21556](https://github.com/RocketChat/Rocket.Chat/pull/21556) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  I added a default case to the total when there are no result to the user's query

- Discussions not showing in Safari ([#21270](https://github.com/RocketChat/Rocket.Chat/pull/21270) by [@Kartik18g](https://github.com/Kartik18g))

- Don't allow whitespace on bold, italic and strike ([#21483](https://github.com/RocketChat/Rocket.Chat/pull/21483))

  Stops the original markdown rendered from rendering empty bold, italic and strike text. Stops `_ _`, `* *` and `~ ~`

- Don't ask again modals blinking ([#21454](https://github.com/RocketChat/Rocket.Chat/pull/21454))

  Made the check before opening the modal.

- Duplicated header on admin's user contextualbar ([#21810](https://github.com/RocketChat/Rocket.Chat/pull/21810))

  ![image](https://user-images.githubusercontent.com/27704687/116125858-5ff60600-a69c-11eb-9859-41f7393b78bf.png)

- Error when editing Omnichannel rooms without custom fields ([#21450](https://github.com/RocketChat/Rocket.Chat/pull/21450) by [@rafaelblink](https://github.com/rafaelblink))

- Fix the bugs opening discussions ([#21557](https://github.com/RocketChat/Rocket.Chat/pull/21557) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  I added the right row export to display the discussions list

- Generic Attachment broken somehow ([#21657](https://github.com/RocketChat/Rocket.Chat/pull/21657))

- Header component breaking if user is not part of teams room. ([#21465](https://github.com/RocketChat/Rocket.Chat/pull/21465))

- Livechat not retrieving messages ([#21644](https://github.com/RocketChat/Rocket.Chat/pull/21644) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Make Omnichannel's closing chat button the last action in the toolbox ([#21476](https://github.com/RocketChat/Rocket.Chat/pull/21476) by [@rafaelblink](https://github.com/rafaelblink))

- Margins on contextual bar information ([#21457](https://github.com/RocketChat/Rocket.Chat/pull/21457))

  ### Room
  **Before**
  ![image](https://user-images.githubusercontent.com/27704687/115080812-ba8fa500-9ed9-11eb-9078-3625603bf92b.png)

  **After**
  ![image](https://user-images.githubusercontent.com/27704687/115080966-e9a61680-9ed9-11eb-929f-6516c1563e99.png)

  ### Livechat
  ![image](https://user-images.githubusercontent.com/27704687/113640101-1859fc80-9651-11eb-88f8-09a899953988.png)

- Message Block ordering  ([#21464](https://github.com/RocketChat/Rocket.Chat/pull/21464))

  Reactions should come before reply button.
  ![image](https://user-images.githubusercontent.com/40830821/113748926-6f0e1780-96df-11eb-93a5-ddcfa891413e.png)

- Message link null corrupts message rendering ([#21579](https://github.com/RocketChat/Rocket.Chat/pull/21579) by [@g-thome](https://github.com/g-thome))

  Additional checks on message_link field before rendering message contents

- Omnichannel Activity Monitor closing chats returned to the queue ([#21782](https://github.com/RocketChat/Rocket.Chat/pull/21782))

  Fix `VisitorInactivityMonitor` is still monitoring rooms that returned to `Queue Chats`

- Omnichannel current chats and agents grid aren't sorting by status properly ([#21616](https://github.com/RocketChat/Rocket.Chat/pull/21616) by [@rafaelblink](https://github.com/rafaelblink))

- Omnichannel queue manager returning outdated room object ([#21485](https://github.com/RocketChat/Rocket.Chat/pull/21485))

  The Omnichannel Queue Manager is returning outdated room object when delegating the chat to an agent, hence, our Livechat widget is affected and the agent assigned to the chat is not displayed on the widget, only after refreshing/reloading.

- Omnichannel room information panel breaking due to lack of data verification ([#21608](https://github.com/RocketChat/Rocket.Chat/pull/21608) by [@rafaelblink](https://github.com/rafaelblink))

- public teams not appearing on spotlight search results ([#21495](https://github.com/RocketChat/Rocket.Chat/pull/21495))

- Remove all agent subscriptions when an Omnichannel chat is closed ([#21509](https://github.com/RocketChat/Rocket.Chat/pull/21509))

- Remove size prop from StatusBullet component ([#21428](https://github.com/RocketChat/Rocket.Chat/pull/21428))

- Rename Omnichannel Rooms, Inquiries and Subscriptions when the Contact Name changes ([#21513](https://github.com/RocketChat/Rocket.Chat/pull/21513) by [@rafaelblink](https://github.com/rafaelblink))

- Rename team not working properly ([#21552](https://github.com/RocketChat/Rocket.Chat/pull/21552))

- Selected channels are not showing in Teams ([#21669](https://github.com/RocketChat/Rocket.Chat/pull/21669) by [@sumukhah](https://github.com/sumukhah))

- Send alternative color to unread sidebar icon ([#21432](https://github.com/RocketChat/Rocket.Chat/pull/21432))

  ![image](https://user-images.githubusercontent.com/17487063/113469819-08f76b00-9427-11eb-942e-783c186ba7cd.png)

- Show direct rooms as readonly when one of the users is deactivated ([#21684](https://github.com/RocketChat/Rocket.Chat/pull/21684))

- Tag component is no longer rendering on Chat Room Information panel ([#21429](https://github.com/RocketChat/Rocket.Chat/pull/21429) by [@rafaelblink](https://github.com/rafaelblink))

- Team types in admin -> rooms. ([#21612](https://github.com/RocketChat/Rocket.Chat/pull/21612))

  ![print](https://user-images.githubusercontent.com/40830821/115068327-82339b00-9ec8-11eb-8e37-726baf9d2db0.jpg)

- Team's channels list for teams with too many channels ([#21491](https://github.com/RocketChat/Rocket.Chat/pull/21491))

  - Fix teams.listRooms pagination for non-admin users

- Too many request on loadHistory method ([#21594](https://github.com/RocketChat/Rocket.Chat/pull/21594))

- Toolbox icons order ([#21739](https://github.com/RocketChat/Rocket.Chat/pull/21739))

- Typos/missing elements in the French translation ([#21525](https://github.com/RocketChat/Rocket.Chat/pull/21525) by [@Jeanstaquet](https://github.com/Jeanstaquet))

  - I have corrected some typos in the translation

  - I added a translation for missing words

  - I took the opportunity to correct a mistranslated word

  - Test_Desktop_Notifications was missing in the EN and FR file
  ![image](https://user-images.githubusercontent.com/45966964/114290186-e7792d80-9a7d-11eb-8164-3b5e72e93703.png)

- Updating a message causing URLs to be parsed even within markdown code ([#21489](https://github.com/RocketChat/Rocket.Chat/pull/21489))

  - Fix `updateMessage` to avoid parsing URLs inside markdown

  - Honor `parseUrls` property when updating messages

- Use async await in TeamChannels delete channel action ([#21534](https://github.com/RocketChat/Rocket.Chat/pull/21534))

- User status out of sync ([#21656](https://github.com/RocketChat/Rocket.Chat/pull/21656))

- Wrong title on Omnichannel contact information panel ([#21682](https://github.com/RocketChat/Rocket.Chat/pull/21682) by [@rafaelblink](https://github.com/rafaelblink))

- Wrong useMemo on Priorities EE field. ([#21453](https://github.com/RocketChat/Rocket.Chat/pull/21453) by [@rafaelblink](https://github.com/rafaelblink))

- Wrong user in user info ([#21451](https://github.com/RocketChat/Rocket.Chat/pull/21451))

  Fixed some race conditions in admin.

  Self DMs used to be created with the userId duplicated. Sometimes rooms can have 2 equal uids, but it's a self DM. Fixed a getter so this isn't a problem anymore.

<details>
<summary>🔍 Minor changes</summary>


-  Doc: Corrected links to documentation of rocket.chat README.md  ([#20478](https://github.com/RocketChat/Rocket.Chat/pull/20478) by [@joshi008](https://github.com/joshi008))

  The link for documentation in the readme was previously https://rocket.chat/docs/ while that was not working and according to the website it was https://docs.rocket.chat/
  The link for deployment methods in readme was corrected from https://rocket.chat/docs/installation/paas-deployments/ to https://docs.rocket.chat/installation/paas-deployments
  Some more links to the documentations were giving 404 error which hence updated.

- [Improve] Remove useless tabbar options from Omnichannel rooms ([#21561](https://github.com/RocketChat/Rocket.Chat/pull/21561) by [@rafaelblink](https://github.com/rafaelblink))

- A React-based replacement for BlazeLayout ([#21527](https://github.com/RocketChat/Rocket.Chat/pull/21527))

  - The Meteor package **`kadira:blaze-layout` was removed**;

  - A **global subscription** for the current application layout (**`appLayout`**) replaces `BlazeLayout` entirely;

  - The **`#react-root` element** is rendered on server-side instead of dynamically injected into the DOM tree;

  - The **"page loading" throbber** is now rendered on the React tree;

  - The **`renderRouteComponent` helper was removed**;

  - Some code run without any criteria on **`main` template** module was moved into **client startup modules**;

  - React portals used to embed Blaze templates have their own subscription (**`blazePortals`**);

  - Some **route components were refactored** to remove a URL path trap originally disabled by `renderRouteComponent`;

  - A new component to embed the DOM nodes generated by **`RoomManager`** was created.

- Add ')' after Date and Time in DB migration ([#21519](https://github.com/RocketChat/Rocket.Chat/pull/21519) by [@im-adithya](https://github.com/im-adithya))

- Bump Apps-Engine version ([#21840](https://github.com/RocketChat/Rocket.Chat/pull/21840))

- bump fuselage ([#21841](https://github.com/RocketChat/Rocket.Chat/pull/21841))

- Bump Livechat Version ([#21694](https://github.com/RocketChat/Rocket.Chat/pull/21694))

- Chore: Add tests for teams.update REST endpoint ([#21653](https://github.com/RocketChat/Rocket.Chat/pull/21653) by [@g-thome](https://github.com/g-thome))

  add more tests to this endpoint

- Chore: Cache EE node_modules on CI ([#21831](https://github.com/RocketChat/Rocket.Chat/pull/21831))

- Chore: Do not stop animations on Test Mode ([#21484](https://github.com/RocketChat/Rocket.Chat/pull/21484))

- Chore: Increase testing coverage on password policy class ([#21482](https://github.com/RocketChat/Rocket.Chat/pull/21482))

- Chore: Meteor update to 2.1.1 ([#21494](https://github.com/RocketChat/Rocket.Chat/pull/21494))

  Basically Node update to version 12.22.1

  Meteor change log https://github.com/meteor/meteor/blob/devel/History.md#v211-2021-04-06

- Chore: Remove control character from room model operation ([#21493](https://github.com/RocketChat/Rocket.Chat/pull/21493))

- Fix typo in app/apps/README file ([#21204](https://github.com/RocketChat/Rocket.Chat/pull/21204) by [@sauravjoshi23](https://github.com/sauravjoshi23))

- Fix: Missing module `eventemitter3` for micro services ([#21611](https://github.com/RocketChat/Rocket.Chat/pull/21611))

  - Fix error when running micro services after version 3.12

  - Fix build of docker image version latest for micro services

- Language update from LingoHub 🤖 on 2021-04-05Z ([#21446](https://github.com/RocketChat/Rocket.Chat/pull/21446))

- Language update from LingoHub 🤖 on 2021-04-12Z ([#21530](https://github.com/RocketChat/Rocket.Chat/pull/21530))

- Language update from LingoHub 🤖 on 2021-04-19Z ([#21642](https://github.com/RocketChat/Rocket.Chat/pull/21642))

- Merge master into develop & Set version to 3.14.0-develop ([#21441](https://github.com/RocketChat/Rocket.Chat/pull/21441))

- QoL improvements to add channel to team flow ([#21778](https://github.com/RocketChat/Rocket.Chat/pull/21778))

  - Fixed canAccessRoom validation

  - Added e2e tests

  - Removed channels that user cannot add to the team from autocomplete suggestions

  - Improved error messages

- Regression: Bold, italic and strike render (Original markdown) ([#21747](https://github.com/RocketChat/Rocket.Chat/pull/21747))

  Modified regex to avoid spaces between the marked text and the symbols. Also made it possible to apply the three markings at the same time, independing of order.

- regression: Cannot enable e2e in direct room. ([#21650](https://github.com/RocketChat/Rocket.Chat/pull/21650))

- Regression: Change CI files hashes for caching ([#21776](https://github.com/RocketChat/Rocket.Chat/pull/21776))

- Regression: Edit user in admin breaking ([#21613](https://github.com/RocketChat/Rocket.Chat/pull/21613))

- Regression: Fix room not returning to the previous room after directory ([#21757](https://github.com/RocketChat/Rocket.Chat/pull/21757))

- Regression: Fix scroll to bottom ([#21731](https://github.com/RocketChat/Rocket.Chat/pull/21731))

- Regression: Fix services Docker image build ([#21750](https://github.com/RocketChat/Rocket.Chat/pull/21750))

- regression: Italic being parsed with surrounding non-whitespace text ([#21815](https://github.com/RocketChat/Rocket.Chat/pull/21815))

- Regression: Legacy Banner Position ([#21598](https://github.com/RocketChat/Rocket.Chat/pull/21598))

  ### Before:
  ![image](https://user-images.githubusercontent.com/27704687/114961773-dc3c4e00-9e3f-11eb-9a32-e882db3fbfbc.png)

  ### After
  ![image](https://user-images.githubusercontent.com/27704687/114961673-a6976500-9e3f-11eb-9238-a12870d7db8f.png)

- regression: Markdown broken on safari ([#21780](https://github.com/RocketChat/Rocket.Chat/pull/21780))

- Regression: Problem with Importer's logs ([#21812](https://github.com/RocketChat/Rocket.Chat/pull/21812))

- Regression: React + Blaze  reconciliation  ([#21567](https://github.com/RocketChat/Rocket.Chat/pull/21567))

- Regression: Reactivate direct conversations only if all involved users are active ([#21714](https://github.com/RocketChat/Rocket.Chat/pull/21714))

- Regression: Reconnection not working properly due to changes on ECHD Proxy ([#21741](https://github.com/RocketChat/Rocket.Chat/pull/21741))

  The ECHD Proxy implements a delay on websocket connection, the first implementation lost the reference to auto reconnect functionality.

- regression: Team Channels actions ([#21417](https://github.com/RocketChat/Rocket.Chat/pull/21417))

- Regression: team sync not accepting multiple teams ([#21768](https://github.com/RocketChat/Rocket.Chat/pull/21768))

- Regression: Unread Threads Header and List ([#21816](https://github.com/RocketChat/Rocket.Chat/pull/21816))

- Regression: Update fuselage for icons fix ([#21809](https://github.com/RocketChat/Rocket.Chat/pull/21809))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Jeanstaquet](https://github.com/Jeanstaquet)
- [@Kartik18g](https://github.com/Kartik18g)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@g-thome](https://github.com/g-thome)
- [@im-adithya](https://github.com/im-adithya)
- [@joshi008](https://github.com/joshi008)
- [@lolimay](https://github.com/lolimay)
- [@lucassartor](https://github.com/lucassartor)
- [@rafaelblink](https://github.com/rafaelblink)
- [@sauravjoshi23](https://github.com/sauravjoshi23)
- [@sumukhah](https://github.com/sumukhah)
- [@wolbernd](https://github.com/wolbernd)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@ggazzo](https://github.com/ggazzo)
- [@graywolf336](https://github.com/graywolf336)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@r0zbot](https://github.com/r0zbot)
- [@renatobecker](https://github.com/renatobecker)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@thassiov](https://github.com/thassiov)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 3.13.5
`2021-05-27  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `12.21.0`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.24.1`

### 🐛 Bug fixes


- Discussion names showing a random value ([#22172](https://github.com/RocketChat/Rocket.Chat/pull/22172))

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.13.3
`2021-04-20  ·  2 🐛  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.21.0`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.24.1`

### 🐛 Bug fixes


- Livechat not retrieving messages ([#21644](https://github.com/RocketChat/Rocket.Chat/pull/21644) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Team's channels list for teams with too many channels ([#21491](https://github.com/RocketChat/Rocket.Chat/pull/21491))

  - Fix teams.listRooms pagination for non-admin users

### 👩‍💻👨‍💻 Contributors 😍

- [@cuonghuunguyen](https://github.com/cuonghuunguyen)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.13.2
`2021-04-14  ·  1 🐛  ·  1 🔍  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.21.0`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.24.1`

### 🐛 Bug fixes


- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

<details>
<summary>🔍 Minor changes</summary>


- Release 3.13.2 ([#21570](https://github.com/RocketChat/Rocket.Chat/pull/21570))

</details>

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@renatobecker](https://github.com/renatobecker)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.13.1
`2021-04-08  ·  9 🐛  ·  1 🔍  ·  8 👩‍💻👨‍💻`

### Engine versions
- Node: `12.21.0`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.24.1`

### 🐛 Bug fixes


- Add tag input to Closing Chat modal ([#21462](https://github.com/RocketChat/Rocket.Chat/pull/21462) by [@rafaelblink](https://github.com/rafaelblink))

- Admin Users list pagination ([#21469](https://github.com/RocketChat/Rocket.Chat/pull/21469))

  - Fix Administration/Users pagination

- App installation from marketplace not correctly displaying the permissions ([#21470](https://github.com/RocketChat/Rocket.Chat/pull/21470))

  Fixes the marketplace app installation not correctly displaying the permissions modal.

- Close chat button is not available for Omnichannel agents ([#21481](https://github.com/RocketChat/Rocket.Chat/pull/21481) by [@rafaelblink](https://github.com/rafaelblink))

- Error when editing Omnichannel rooms without custom fields ([#21450](https://github.com/RocketChat/Rocket.Chat/pull/21450) by [@rafaelblink](https://github.com/rafaelblink))

- Header component breaking if user is not part of teams room. ([#21465](https://github.com/RocketChat/Rocket.Chat/pull/21465))

- Make Omnichannel's closing chat button the last action in the toolbox ([#21476](https://github.com/RocketChat/Rocket.Chat/pull/21476) by [@rafaelblink](https://github.com/rafaelblink))

- Omnichannel queue manager returning outdated room object ([#21485](https://github.com/RocketChat/Rocket.Chat/pull/21485))

  The Omnichannel Queue Manager is returning outdated room object when delegating the chat to an agent, hence, our Livechat widget is affected and the agent assigned to the chat is not displayed on the widget, only after refreshing/reloading.

- Wrong useMemo on Priorities EE field. ([#21453](https://github.com/RocketChat/Rocket.Chat/pull/21453) by [@rafaelblink](https://github.com/rafaelblink))

<details>
<summary>🔍 Minor changes</summary>


- Release 3.13.1 ([#21486](https://github.com/RocketChat/Rocket.Chat/pull/21486) by [@rafaelblink](https://github.com/rafaelblink))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@rafaelblink](https://github.com/rafaelblink)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@d-gubert](https://github.com/d-gubert)
- [@gabriellsh](https://github.com/gabriellsh)
- [@graywolf336](https://github.com/graywolf336)
- [@renatobecker](https://github.com/renatobecker)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@thassiov](https://github.com/thassiov)

# 3.13.0
`2021-04-04  ·  7 🎉  ·  11 🚀  ·  36 🐛  ·  61 🔍  ·  38 👩‍💻👨‍💻`

### Engine versions
- Node: `12.21.0`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.24.0`

### 🎉 New features


- **APPS:** Map description as a room value in Apps ([#20811](https://github.com/RocketChat/Rocket.Chat/pull/20811) by [@lucassartor](https://github.com/lucassartor))

  Add the `description` value of a `room` as a mapped value in the Apps-Engine. That way developers can get the `description` information from a `room` in their app.

- **APPS:** New event interfaces for pre/post user leaving a room ([#20917](https://github.com/RocketChat/Rocket.Chat/pull/20917) by [@lucassartor](https://github.com/lucassartor))

  Added events and errors that trigger when a user leaves a room.
  That way it can communicate with the Apps-Engine by the `IPreRoomUserLeave` and `IPostRoomUserLeave` event interfaces.

- **Enterprise:** Omnichannel On-Hold Queue ([#20945](https://github.com/RocketChat/Rocket.Chat/pull/20945))

  ### About this feature
  This feature has been introduced to deal with Inactive chats. A chat is considered Inactive if an Omnichannel End User (aka Visitor) has not replied back to an agent in some time. These types of inactive chats become very important when an organisation has a limit set for `Max Simultaneous Chats per agent` which is defined by the following setting :point_down:  , as more number of Inactive chats would directly affect an agent's productivity.
  ![image](https://user-images.githubusercontent.com/34130764/111533003-4d7ad980-878c-11eb-8c1c-2796678a07db.png)

  Before this feature, we only had one option to deal with such Inactive/Abandoned chats   - which was to auto close abandoned chats via this setting :point_down:
  ![image](https://user-images.githubusercontent.com/34130764/111534353-e65e2480-878d-11eb-82a5-71368064ef45.png)

  however closing a chat isn't a best option for some cases. Let me take an example to explain a scenario

  > An agent is assisting a customer for installing a very huge software which is likely to take more than 20-30 minutes to download. In such scenarios closing a chat isn't the best approach since even after the lengthy download the customer might still need some assist from the agent.
  > So basically this chat is going to block the agent's queue until the customer is able to finish his time-consuming download task in which he/she doesn't require any agent's assistance. Due to the `Max Simultaneous Chats per agent` limit, the agent is also not able to use this extra time to help other customer thus affecting his overall productivity.

  **So how does the On-Hold feature solve this problem?**
  With the On-Hold feature, an agent is now able to place a chat on-hold. On-Hold chats **don’t count towards the maximum number of concurrent chats** an agent can have. So in our above example, the agent can simply now place the customer on-hold for 20-30 minutes until the customer downloads the software and within this time, the agent can serve other customers   - hence increasing the productivity of an agent.

  ----------------------------------------
  ### Working of the new On-Hold feature

  #### How can you place a chat on Hold ?

  A chat can be placed on-hold via 2 means

  1. Automatically place Abandoned chats On-hold
      ![image](https://user-images.githubusercontent.com/34130764/111537074-06431780-8791-11eb-8d23-99f5d9f8ec45.png)
    Via this :top: option you can define a timer which will get started when a customer sends a message. If we don't receive any message from the customer within this timer, the timer will get expired and the chat will be considered as Abandoned.
      ![image](https://user-images.githubusercontent.com/34130764/111537346-53bf8480-8791-11eb-8dc7-260633b4e98f.png)
    The via this :top:  setting you can choose to automatically place this abandoned chat On Hold

  2.  Manually place a chat On Hold
      As an admin, you can allow an agent to manually place a chat on-hold. To do so, you'll need to turn on this :point_down: setting
      ![image](https://user-images.githubusercontent.com/34130764/111537545-97b28980-8791-11eb-86fd-db45b87e9cc1.png)
      Now an agent will be able to see a new `On Hold` button within their `Visitor Info Panel` like this :point_down: , provided the agent has sent the last message
      ![image](https://user-images.githubusercontent.com/34130764/111537853-f24be580-8791-11eb-9561-d77ba430c625.png)

  #### How can you resume a On Hold chat ?
  An On Hold chat can be resumed via 2 means


  1. If the Customer sends a message
     If the Customer / Omnichannel End User sends a message to the On Hold chat, the On Hold chat will get automatically resumed.

  2. Manually by agent
    An Agent can manually resume the On Hold chat via clicking the `Resume` button in the bottom of a chat room.
   ![image](https://user-images.githubusercontent.com/34130764/111538666-f88e9180-8792-11eb-8d14-01453b8e3db0.png)

  #### What would happen if the agent already reached maximum chats, and a On-Hold chat gets resumed ?
  Based on how the chat was resumed, there are multiple cases are each case is dealt differently


  - If an agent manually tries to resume the On Hold chat, he/she will get an error saying  `Maximum Simultaneous chat limit reached`

  - If a customer replies back on an On Hold chat and the last serving agent has reached maximum capacity, then this customer will be placed on the queue again from where based on the Routing Algorithm selected, the chat will get transferred to any available agent

- Ability to hide 'Room topic changed' system messages ([#21062](https://github.com/RocketChat/Rocket.Chat/pull/21062) by [@Tirieru](https://github.com/Tirieru))

- Add Omnichannel Livechat Trigger option for when user opens the chat window ([#20030](https://github.com/RocketChat/Rocket.Chat/pull/20030) by [@reda-alaoui](https://github.com/reda-alaoui))

- Quick action buttons for Omnichannel ([#21123](https://github.com/RocketChat/Rocket.Chat/pull/21123) by [@rafaelblink](https://github.com/rafaelblink))

- Teams ([#20966](https://github.com/RocketChat/Rocket.Chat/pull/20966) by [@g-thome](https://github.com/g-thome))

  ## Teams



  You can easily group your users as Teams on Rocket.Chat. The feature takes the hassle out of managing multiple users one by one and allows you to handle them at the same time efficiently.



  - Teams can be public or private and each team can have its own channels, which also can be public or private.

  - It's possible to add existing channels to a Team or create new ones inside a Team.

  - It's possible to invite people outside a Team to join Team's channels.

  - It's possible to convert channels to Teams

  - It's possible to add all team members to a channel at once

  - Team members have roles


  ![image](https://user-images.githubusercontent.com/70927132/113421955-4f56b680-93a2-11eb-80dc-9b70a3f09b3e.png)



  **Quickly onboard new users with Autojoin channels**

  Teams can have Auto-join channels –  channels to which the team members are automatically added, so you don’t need to go through the manual process of adding users repetitively

  ![image](https://user-images.githubusercontent.com/70927132/113419284-81194e80-939d-11eb-9fff-aeb05cbc8089.png)

  **Instantly mention multiple members at once** (available in EE)

  With Teams, you don’t need to remember everyone’s name to communicate with a team quickly. Just mention a Team — @engineers, for instance —  and all members will be instantly notified.

### 🚀 Improvements


- Add spacing between elements in Profile Page ([#20742](https://github.com/RocketChat/Rocket.Chat/pull/20742) by [@cyberShaw](https://github.com/cyberShaw))

- Added modal-box for preview after recording audio. ([#20370](https://github.com/RocketChat/Rocket.Chat/pull/20370) by [@Darshilp326](https://github.com/Darshilp326))

  A modal box will be displayed so that users can change the filename and add description.

  **Before**

  https://user-images.githubusercontent.com/55157259/105687301-4e2a8880-5f1e-11eb-873d-dc8a880a2fc8.mp4

  **After**

  https://user-images.githubusercontent.com/55157259/105687342-597db400-5f1e-11eb-8b61-8f9d9ebad0c4.mp4

- Adds toast after follow/unfollow messages and following icon for followed messages without threads. ([#20025](https://github.com/RocketChat/Rocket.Chat/pull/20025) by [@RonLek](https://github.com/RonLek))

  There was no alert on following/unfollowing a message previously. Also, it was impossible to make out a followed message with no threads from an unfollowed one.

  This PR would show an alert on following/unfollowing a message and also display a small bell icon (similar to the ones for starred and pinned messages) when a message with no thread is followed.

  https://user-images.githubusercontent.com/28918901/103813540-43e73e00-5086-11eb-8592-2877eb650f3e.mp4

- Back to threads list button on threads contextual bar ([#20882](https://github.com/RocketChat/Rocket.Chat/pull/20882))

  ![image](https://user-images.githubusercontent.com/27704687/108926702-ad62e200-761d-11eb-8c18-5406246a6955.png)

- Better new channel popover ([#21018](https://github.com/RocketChat/Rocket.Chat/pull/21018))

- grammatical typos in pull request template ([#21115](https://github.com/RocketChat/Rocket.Chat/pull/21115) by [@sumukhah](https://github.com/sumukhah))

- Improve Apps permission modal ([#21193](https://github.com/RocketChat/Rocket.Chat/pull/21193) by [@lucassartor](https://github.com/lucassartor))

  Improve the UI of the Apps permission modal when installing an App that requires permissions.

  **New UI:**
  ![after](https://user-images.githubusercontent.com/49413772/111685622-e817fe80-8806-11eb-998d-b56623560e74.PNG)

  **Old UI:**
  ![before](https://user-images.githubusercontent.com/49413772/111685897-375e2f00-8807-11eb-814e-cb8060dc1830.PNG)

- Make debug logs of Apps configurable via Log_Level setting in the Admin panel ([#21000](https://github.com/RocketChat/Rocket.Chat/pull/21000) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

- Re-design Omnichannel Room Info Panel ([#21199](https://github.com/RocketChat/Rocket.Chat/pull/21199) by [@rafaelblink](https://github.com/rafaelblink))

- Set description in create channel modal ([#21132](https://github.com/RocketChat/Rocket.Chat/pull/21132))

- Sort Users List In Case Insensitive Manner ([#20790](https://github.com/RocketChat/Rocket.Chat/pull/20790) by [@aditya-mitra](https://github.com/aditya-mitra))

  The users listed in the admin panel were sorted in a case-sensitive manner , where the capitals came first and then the small letters (like   - *A B C a b c*). This Change fixes this by sorting the names in a caseinsensitive manner (now   - *A a B b C c*).

  ### Before

  ![before](https://user-images.githubusercontent.com/55396651/108189880-3fa74980-7137-11eb-99da-6498707b4bf8.png)


  ### With This Change

  ![after](https://user-images.githubusercontent.com/55396651/108190177-9dd42c80-7137-11eb-8b4e-b7cef4ba512f.png)

### 🐛 Bug fixes


- 'Chats in Progress' Section is not rendering when the routing algorithm is not Manual Selection ([#21324](https://github.com/RocketChat/Rocket.Chat/pull/21324))

- "Taken At" and "Average of Response Time" fields not rendering properly on Room Information panel ([#21365](https://github.com/RocketChat/Rocket.Chat/pull/21365) by [@rafaelblink](https://github.com/rafaelblink))

- **Apps:** Fix Game Center icon disappeared after the React refactor ([#21091](https://github.com/RocketChat/Rocket.Chat/pull/21091) by [@lolimay](https://github.com/lolimay))

- **APPS:** Warn message while installing app in air-gapped environment ([#20992](https://github.com/RocketChat/Rocket.Chat/pull/20992) by [@lucassartor](https://github.com/lucassartor))

  Change **error** message to a **warn** message when uploading a  `.zip` file app into a air-gapped environment.

  The **error** message was giving the impression for the user that the app wasn't properly being installed , which it wasn't the case:
  ![error](https://user-images.githubusercontent.com/49413772/109855273-d3e4d680-7c36-11eb-824b-ad455d24710c.PNG)

  A more detailed **warn** message can fix that impression for the user:
  ![warn](https://user-images.githubusercontent.com/49413772/109855383-f2e36880-7c36-11eb-8d61-c442980bd8fd.PNG)

- Add missing `unreads` field to `users.info` REST endpoint ([#20905](https://github.com/RocketChat/Rocket.Chat/pull/20905))

- Added hideUnreadStatus check before showing unread messages on roomList ([#20867](https://github.com/RocketChat/Rocket.Chat/pull/20867))

  Added hide unread counter check, if the show unread messages is turned off, now unread messages badge won't be shown to user.

- Broken message fields attachment handling ([#21069](https://github.com/RocketChat/Rocket.Chat/pull/21069))

  Avoids an `undefined` value to break a rendered attachment.

- Correct direction for admin mapview text ([#20897](https://github.com/RocketChat/Rocket.Chat/pull/20897) by [@aKn1ghtOut](https://github.com/aKn1ghtOut))

  ![Screenshot from 2021-02-25 02-49-21](https://user-images.githubusercontent.com/38764067/109068512-f8602080-7715-11eb-8e22-d610f9d046d8.png)
  ![Screenshot from 2021-02-25 02-49-46](https://user-images.githubusercontent.com/38764067/109068516-fa29e400-7715-11eb-9119-1c79abce278f.png)
  ![Screenshot from 2021-02-25 02-49-57](https://user-images.githubusercontent.com/38764067/109068519-fbf3a780-7715-11eb-8b3d-0dc32f898725.png)

  The text says the share button will be on the left of the messagebox once enabled. However, it actually is on the right.

- Correct ignored message CSS ([#20928](https://github.com/RocketChat/Rocket.Chat/pull/20928) by [@aKn1ghtOut](https://github.com/aKn1ghtOut))

  Modified the CSS to not affect the ignored sequential messages exactly like the non-ignored messages, which is what was causing the second and further ignored message o appear weirdly when unhidden one by one.

- Correct Inline reactions behaviour ([#20743](https://github.com/RocketChat/Rocket.Chat/pull/20743) by [@aKn1ghtOut](https://github.com/aKn1ghtOut))

  The $().data function was returning outdated values for re-assigned emoji buttons with new data. Changed that to use the .attr() function. This works perfectly.

- Correct Typo - donwload to download ([#21096](https://github.com/RocketChat/Rocket.Chat/pull/21096) by [@aditya-mitra](https://github.com/aditya-mitra))

  Correct the spelling of _donwload_ to _download_ in `TitleLink` of Attachments.

- Custom emojis to override default ([#20359](https://github.com/RocketChat/Rocket.Chat/pull/20359) by [@aKn1ghtOut](https://github.com/aKn1ghtOut))

  Due to the sequence of the imports and how the emojiRenderer prioritizes lists, the custom emojis could not override the emojione emojis. Making two small changes fixed the issue.

  With the custom emoji for `:facepalm:` added, you can check out the result below:
  ### Before
  ![Screenshot from 2021-01-25 02-20-04](https://user-images.githubusercontent.com/38764067/105643088-dfb0e080-5eb3-11eb-8a00-582c53fbe9a4.png)

  ### After
  ![Screenshot from 2021-01-25 02-18-58](https://user-images.githubusercontent.com/38764067/105643076-cdcf3d80-5eb3-11eb-84b8-5dbc4f1135df.png)

- Empty URL in user avatar doesn't show error and enables save ([#20440](https://github.com/RocketChat/Rocket.Chat/pull/20440) by [@im-adithya](https://github.com/im-adithya))

  Added toast and disabled save.

- Ensure E2E is enabled/disabled on sending message ([#21084](https://github.com/RocketChat/Rocket.Chat/pull/21084))

  Rooms which were encrypted somewhere in the past still could encrypt messages due to a race condition due to a query over `Subscriptions` collection.

- Fix the search list showing the last channel ([#21160](https://github.com/RocketChat/Rocket.Chat/pull/21160) by [@shrinish123](https://github.com/shrinish123))

  The search list now also properly shows the last channel
  Before  :

  ![searchlist](https://user-images.githubusercontent.com/56491104/111471487-f3a7ee80-874e-11eb-9c6e-19bbf0731d60.png)

  After :
  ![search_final](https://user-images.githubusercontent.com/56491104/111471521-fe628380-874e-11eb-8fa3-d1edb57587e1.png)

- Follow thread action on threads list  ([#20881](https://github.com/RocketChat/Rocket.Chat/pull/20881))

  https://user-images.githubusercontent.com/27704687/108925036-a4bcdc80-761a-11eb-83b8-2df8960f74cb.mp4

- Iframe flags for audio and video on the BigBlueButton integration ([#20879](https://github.com/RocketChat/Rocket.Chat/pull/20879) by [@fcecagno](https://github.com/fcecagno))

- Inactivity Time field displaying wrong information ([#21363](https://github.com/RocketChat/Rocket.Chat/pull/21363) by [@rafaelblink](https://github.com/rafaelblink))

- Incorrect time format of the Queue Time field on the room information page ([#21394](https://github.com/RocketChat/Rocket.Chat/pull/21394) by [@rafaelblink](https://github.com/rafaelblink))

- Make custom emoji file required ([#19583](https://github.com/RocketChat/Rocket.Chat/pull/19583) by [@m-shreyansh](https://github.com/m-shreyansh))

- Missing app permissions translation ([#21066](https://github.com/RocketChat/Rocket.Chat/pull/21066))

  Add missing translations for some app permissions

- Missing Keywords in Permissions ([#20354](https://github.com/RocketChat/Rocket.Chat/pull/20354) by [@im-adithya](https://github.com/im-adithya))

  The keywords were added to the i18n folder. (Default only)

- Multi Select isn't working in Export Messages ([#21236](https://github.com/RocketChat/Rocket.Chat/pull/21236) by [@PriyaBihani](https://github.com/PriyaBihani))

  While exporting messages, we were not able to select multiple Users like this:

  https://user-images.githubusercontent.com/69837339/111953057-169a2000-8b0c-11eb-94a4-0e1657683f96.mp4

  Now we can select multiple users:


  https://user-images.githubusercontent.com/69837339/111953097-274a9600-8b0c-11eb-9177-bec388b042bd.mp4

- New Channel popover not closing ([#21080](https://github.com/RocketChat/Rocket.Chat/pull/21080))

  https://user-images.githubusercontent.com/17487063/110828228-92c37680-8275-11eb-9fce-fb40765935a3.mp4

- OEmbedURLWidget - Show Full Embedded Text Description ([#20569](https://github.com/RocketChat/Rocket.Chat/pull/20569) by [@aditya-mitra](https://github.com/aditya-mitra))

  Embeds were cutoff when either _urls had a long description_.
  This was handled by removing `overflow:hidden;text-overflow:ellipsis;` from the inline styles in [`oembedUrlWidget.html`](https://github.com/RocketChat/Rocket.Chat/blob/develop/app/oembed/client/oembedUrlWidget.html#L28).

  ### Earlier

  ![earlier](https://user-images.githubusercontent.com/55396651/107110825-00dcde00-6871-11eb-866e-13cabc5b0d05.png)

  ### Now

  ![now](https://user-images.githubusercontent.com/55396651/107110794-ca06c800-6870-11eb-9b3b-168679936612.png)

- Reactions list showing users in reactions option of message action. ([#20753](https://github.com/RocketChat/Rocket.Chat/pull/20753) by [@Darshilp326](https://github.com/Darshilp326))

  Reactions list shows emojis with respected users who have reacted with that emoji.

  https://user-images.githubusercontent.com/55157259/107857609-5870e000-6e55-11eb-8137-494a9f71b171.mp4

- Removing truncation from profile ([#20352](https://github.com/RocketChat/Rocket.Chat/pull/20352) by [@aKn1ghtOut](https://github.com/aKn1ghtOut))

  Truncating text in profile view was making some information completely inaccessible. Removed it from the user status and the custom fields where if the information is longer, the user would actually want to see all of it.

  ### Before
  ![Screenshot from 2021-01-24 20-54-44](https://user-images.githubusercontent.com/38764067/105634935-7e264d00-5e86-11eb-8a6c-9f2a363e0f6c.png)

  ### After
  ![Screenshot from 2021-01-24 20-54-06](https://user-images.githubusercontent.com/38764067/105634940-82eb0100-5e86-11eb-8b90-e97a43c5e938.png)

- Replace wrong field description on Room Information panel ([#21395](https://github.com/RocketChat/Rocket.Chat/pull/21395) by [@rafaelblink](https://github.com/rafaelblink))

- Reply count of message is decreased after a message from thread is deleted ([#19977](https://github.com/RocketChat/Rocket.Chat/pull/19977))

  The reply count now is decreased if a message from a thread is deleted.

- Set establishing to false if OTR timeouts ([#21183](https://github.com/RocketChat/Rocket.Chat/pull/21183) by [@Darshilp326](https://github.com/Darshilp326))

  Set establishing false if OTR timeouts.

  https://user-images.githubusercontent.com/55157259/111617086-b30cab80-8808-11eb-8740-3b4ffacfc322.mp4

- Sidebar scroll missing full height ([#21071](https://github.com/RocketChat/Rocket.Chat/pull/21071))

  ![image](https://user-images.githubusercontent.com/27704687/110708646-c05ae200-81d9-11eb-86da-1d6a2e99b6e5.png)

- undefined in PruneMessages deleting DM ([#20873](https://github.com/RocketChat/Rocket.Chat/pull/20873) by [@vova-zush](https://github.com/vova-zush))

  Fix undefined in Prune Messages in direct

- Unexpected open or close visitor info ([#21094](https://github.com/RocketChat/Rocket.Chat/pull/21094))

  The VisitorInfo component closes or open every time a new message was sent, this PR fix that.

- Use the correct icons for DMs ([#21125](https://github.com/RocketChat/Rocket.Chat/pull/21125))

- Visitors.info endpoint being called multiple times ([#21350](https://github.com/RocketChat/Rocket.Chat/pull/21350) by [@rafaelblink](https://github.com/rafaelblink))

- Wrong license seats number administration info panel ([#21222](https://github.com/RocketChat/Rocket.Chat/pull/21222))

  The administration info panel was showing the *total of users* as the number counted for the usage of the license seats. Now it's showing the correct number that is *active users*. This was not affecting the license validation on the server-side, only causing confusion for the administrators to check how the usage was being counted.

<details>
<summary>🔍 Minor changes</summary>


- [Fix] Broken useEffect opened new BBB Tab twice ([#20770](https://github.com/RocketChat/Rocket.Chat/pull/20770) by [@Cosnavel](https://github.com/Cosnavel))

- Bump Livechat Widget ([#21264](https://github.com/RocketChat/Rocket.Chat/pull/21264))

  Update Livechat version to 1.9.0

- Change the order of Sort Setup Wizard options  ([#21073](https://github.com/RocketChat/Rocket.Chat/pull/21073))

  Sort options in select fields of settings during Setup Wizard according to browser's locale.

- Chore: Add tests for Meteor methods ([#20901](https://github.com/RocketChat/Rocket.Chat/pull/20901))

  Add end-to-end tests for the following meteor methods


  - [x] public-settings:get

  - [x] rooms:get

  - [x] subscriptions:get

  - [x] permissions:get

  - [x] loadMissedMessages

  - [x] loadHistory

  - [x] listCustomUserStatus

  - [x] getUserRoles

  - [x] getRoomRoles  (called by the API, already covered)

  - [x] getMessages

  - [x] getUsersOfRoom

  - [x] loadNextMessages

  - [x] getThreadMessages

- Chore: Meteor update 2.1 ([#21061](https://github.com/RocketChat/Rocket.Chat/pull/21061))

- Chore: Remove `new Buffer` in favor of `Buffer.from` ([#20918](https://github.com/RocketChat/Rocket.Chat/pull/20918))

  - Changes `new Buffer` to `Buffer.from` since the first one is deprecated.

- EE Team Mentions ([#21418](https://github.com/RocketChat/Rocket.Chat/pull/21418))

- Improve: Increase testing coverage ([#21015](https://github.com/RocketChat/Rocket.Chat/pull/21015))

  Add test for

  - settings/raw

  - minimongo/comparisons

- Improve: NPS survey fetch ([#21263](https://github.com/RocketChat/Rocket.Chat/pull/21263))

- Regression:  New chat forwarding modal is not verifying mandatory values ([#21288](https://github.com/RocketChat/Rocket.Chat/pull/21288) by [@rafaelblink](https://github.com/rafaelblink))

- Regression: Add BreadCrumbs tag into auto-join items ([#21294](https://github.com/RocketChat/Rocket.Chat/pull/21294))

- Regression: Add call to eraseRoom method ([#21392](https://github.com/RocketChat/Rocket.Chat/pull/21392))

  - Replace `removeById` by `eraseRoom` method's call (which not only deletes the room, but also erases its subscriptions and triggers some apps-engine events).

- Regression: Add isLastOwner property on teams.listRoomsOfUser endpoint ([#21323](https://github.com/RocketChat/Rocket.Chat/pull/21323))

- Regression: Add number of team members to teams.list and teams.listAll ([#21361](https://github.com/RocketChat/Rocket.Chat/pull/21361) by [@g-thome](https://github.com/g-thome))

- Regression: Add scope to permission checks in Team's endpoints ([#21369](https://github.com/RocketChat/Rocket.Chat/pull/21369))

  - Include scope (team's main room ID) in the permission checks;
   - Remove the `teamName` parameter from the `members`, `addMembers`, `updateMember` and `removeMembers` methods (since `teamId` will always be defined).

- Regression: Add support to filter on `teams.listRooms` endpoint ([#21327](https://github.com/RocketChat/Rocket.Chat/pull/21327))

  - Add support for queries (within the `query` parameter);

  - Add support to pagination (`offset` and `count`) when an user doesn't have the permission to get all rooms.

- Regression: Add teams support to directory ([#21351](https://github.com/RocketChat/Rocket.Chat/pull/21351))

  - Change `directory.js` to reduce function complexity

  - Add `teams` type of item. Directory will return all public teams & private teams the user is part of.

- Regression: add view room action on Teams Channels ([#21295](https://github.com/RocketChat/Rocket.Chat/pull/21295))

  ![image](https://user-images.githubusercontent.com/27704687/112379914-7e489a80-8cc7-11eb-9b0b-e454bb05755d.png)

- Regression: Change name-error description ([#21385](https://github.com/RocketChat/Rocket.Chat/pull/21385))

- Regression: Channel owner can't convert it into a team. ([#21349](https://github.com/RocketChat/Rocket.Chat/pull/21349))

- Regression: Contact Chat History component not visible ([#21316](https://github.com/RocketChat/Rocket.Chat/pull/21316))

- Regression: Delete team member from related team's rooms ([#21401](https://github.com/RocketChat/Rocket.Chat/pull/21401))

- regression: Directory - teams tab search ([#21419](https://github.com/RocketChat/Rocket.Chat/pull/21419))

- Regression: directory not showing public channels of public teams ([#21400](https://github.com/RocketChat/Rocket.Chat/pull/21400))

- regression: Discussion room crashing if not member of parent channel ([#21310](https://github.com/RocketChat/Rocket.Chat/pull/21310))

- Regression: Error clicking on non joined channels on team channel list ([#21422](https://github.com/RocketChat/Rocket.Chat/pull/21422))

- Regression: Fix channels not being added to team on creation ([#21370](https://github.com/RocketChat/Rocket.Chat/pull/21370))

- Regression: Fix Members List Icon ([#21433](https://github.com/RocketChat/Rocket.Chat/pull/21433))

- Regression: Fix non encrypted rooms failing sending messages ([#21287](https://github.com/RocketChat/Rocket.Chat/pull/21287))

- Regression: Fix reactivity on teamsMembers and roomMembers ([#21366](https://github.com/RocketChat/Rocket.Chat/pull/21366))

- Regression: Fix TeamsChannels reactivity ([#21384](https://github.com/RocketChat/Rocket.Chat/pull/21384))

- Regression: General improvement to Teams ([#21402](https://github.com/RocketChat/Rocket.Chat/pull/21402))

- Regression: header title tag style ([#21415](https://github.com/RocketChat/Rocket.Chat/pull/21415))

  ![image](https://user-images.githubusercontent.com/27704687/113326208-bebf9e00-92ef-11eb-97f7-91ae978fc400.png)

- Regression: Headers icon breaking DMs ([#21412](https://github.com/RocketChat/Rocket.Chat/pull/21412))

- Regression: invalid teams permission check. ([#21374](https://github.com/RocketChat/Rocket.Chat/pull/21374))

- Regression: Modify canAccessRoom to adapt to teams specification ([#21372](https://github.com/RocketChat/Rocket.Chat/pull/21372))

- Regression: New endpoint to list rooms available to be added to any team ([#21373](https://github.com/RocketChat/Rocket.Chat/pull/21373))

- Regression: Omnichannel agents can't access new action buttons ([#21306](https://github.com/RocketChat/Rocket.Chat/pull/21306))

- Regression: Permissions missing on new Room Edit and Contact Edit form ([#21315](https://github.com/RocketChat/Rocket.Chat/pull/21315) by [@rafaelblink](https://github.com/rafaelblink))

- Regression: Quick action button missing for Omnichannel On-Hold queue ([#21285](https://github.com/RocketChat/Rocket.Chat/pull/21285))

  - Move the Manual On Hold button to the new Omnichannel Header
  ![image](https://user-images.githubusercontent.com/34130764/112291749-6ae10380-8cb6-11eb-94cd-e05efc14b1bf.png)
  ![image](https://user-images.githubusercontent.com/34130764/112304146-27d95d00-8cc3-11eb-85db-dde04a110dd1.png)


  - Minor fixes

- regression: Remove Breadcrumbs and update Tag component ([#21399](https://github.com/RocketChat/Rocket.Chat/pull/21399))

- Regression: Remove channel action on add channel's modal don't work ([#21356](https://github.com/RocketChat/Rocket.Chat/pull/21356))

  ![removechannel-on-add-existing-modal](https://user-images.githubusercontent.com/27704687/112911017-eda8fa80-90ca-11eb-9c24-47a70be0c314.gif)

  ![image](https://user-images.githubusercontent.com/27704687/112911052-02858e00-90cb-11eb-85a2-0ef1f5f9ffd9.png)

- Regression: Remove primary color from button in TeamChannels component ([#21293](https://github.com/RocketChat/Rocket.Chat/pull/21293))

- regression: remove user modal not showing up ([#21348](https://github.com/RocketChat/Rocket.Chat/pull/21348))

- Regression: Removing user from team doesn't remove them from the team's room. ([#21291](https://github.com/RocketChat/Rocket.Chat/pull/21291))

  - Remove subscription when calling `teams.removeMembers`

- Regression: Room Edit form not rendering priority and custom fields ([#21309](https://github.com/RocketChat/Rocket.Chat/pull/21309) by [@rafaelblink](https://github.com/rafaelblink))

- Regression: rooms breaking after deleting a room from a team ([#21421](https://github.com/RocketChat/Rocket.Chat/pull/21421))

- regression: Sidebar reactivity ([#21296](https://github.com/RocketChat/Rocket.Chat/pull/21296))

- Regression: Team icons in mention ([#21367](https://github.com/RocketChat/Rocket.Chat/pull/21367))

  ![image](https://user-images.githubusercontent.com/40830821/113044232-cd814600-9173-11eb-8f17-47c2d1438b75.png)

- regression: Team info permissions ([#21387](https://github.com/RocketChat/Rocket.Chat/pull/21387))

- Regression: Teams should not have same name as users ([#21371](https://github.com/RocketChat/Rocket.Chat/pull/21371))

- regression: Unable to add users while creating a team ([#21354](https://github.com/RocketChat/Rocket.Chat/pull/21354))

- Regression: Unify Contact information displayed on the Room header and Room Info ([#21312](https://github.com/RocketChat/Rocket.Chat/pull/21312) by [@rafaelblink](https://github.com/rafaelblink))

  ![image](https://user-images.githubusercontent.com/34130764/112586659-35592900-8e22-11eb-94be-32bdff7ca883.png)

  ![image](https://user-images.githubusercontent.com/2493803/112913130-788bf400-90cf-11eb-84c6-782b203e100a.png)

  ![image](https://user-images.githubusercontent.com/2493803/112913146-817cc580-90cf-11eb-87ad-ef79766be2b3.png)

- Regression: Unify team actions to add a room to a team ([#21386](https://github.com/RocketChat/Rocket.Chat/pull/21386))

- Regression: unused names for team roles ([#21376](https://github.com/RocketChat/Rocket.Chat/pull/21376))

- Regression: Update .invite endpoints to support multiple users at once ([#21328](https://github.com/RocketChat/Rocket.Chat/pull/21328))

  - channels.invite now supports passing an array as a param (either with usernames or userIds) via `usernames` or `userIds` properties.

  - You can still use the endpoint to invite only one user via the old params `userId`, `username` or `user`.

  - Same changes apply to groups.invite

- Regression: user actions in admin ([#21307](https://github.com/RocketChat/Rocket.Chat/pull/21307))

- Regression: View Channels button in Team info ([#21289](https://github.com/RocketChat/Rocket.Chat/pull/21289))

- Regression: When only 'teams' type is provided, show only rooms with teamMain on `rooms.adminRooms` endpoint ([#21322](https://github.com/RocketChat/Rocket.Chat/pull/21322))

- Release 3.13.0 ([#21437](https://github.com/RocketChat/Rocket.Chat/pull/21437) by [@PriyaBihani](https://github.com/PriyaBihani) & [@cuonghuunguyen](https://github.com/cuonghuunguyen) & [@fcecagno](https://github.com/fcecagno) & [@lucassartor](https://github.com/lucassartor) & [@shrinish123](https://github.com/shrinish123))

- Update Apps-Engine version ([#21398](https://github.com/RocketChat/Rocket.Chat/pull/21398))

</details>

### 👩‍💻👨‍💻 Contributors 😍

- [@Cosnavel](https://github.com/Cosnavel)
- [@Darshilp326](https://github.com/Darshilp326)
- [@PriyaBihani](https://github.com/PriyaBihani)
- [@RonLek](https://github.com/RonLek)
- [@Tirieru](https://github.com/Tirieru)
- [@aKn1ghtOut](https://github.com/aKn1ghtOut)
- [@aditya-mitra](https://github.com/aditya-mitra)
- [@cuonghuunguyen](https://github.com/cuonghuunguyen)
- [@cyberShaw](https://github.com/cyberShaw)
- [@fcecagno](https://github.com/fcecagno)
- [@g-thome](https://github.com/g-thome)
- [@im-adithya](https://github.com/im-adithya)
- [@lolimay](https://github.com/lolimay)
- [@lucassartor](https://github.com/lucassartor)
- [@m-shreyansh](https://github.com/m-shreyansh)
- [@rafaelblink](https://github.com/rafaelblink)
- [@reda-alaoui](https://github.com/reda-alaoui)
- [@shrinish123](https://github.com/shrinish123)
- [@sumukhah](https://github.com/sumukhah)
- [@vova-zush](https://github.com/vova-zush)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@MartinSchoeler](https://github.com/MartinSchoeler)
- [@alansikora](https://github.com/alansikora)
- [@d-gubert](https://github.com/d-gubert)
- [@dougfabris](https://github.com/dougfabris)
- [@gabriellsh](https://github.com/gabriellsh)
- [@geekgonecrazy](https://github.com/geekgonecrazy)
- [@ggazzo](https://github.com/ggazzo)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@murtaza98](https://github.com/murtaza98)
- [@pierre-lehnen-rc](https://github.com/pierre-lehnen-rc)
- [@r0zbot](https://github.com/r0zbot)
- [@renatobecker](https://github.com/renatobecker)
- [@rodrigok](https://github.com/rodrigok)
- [@sampaiodiego](https://github.com/sampaiodiego)
- [@tassoevan](https://github.com/tassoevan)
- [@tiagoevanp](https://github.com/tiagoevanp)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 3.12.7
`2021-05-27  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `12.18.4`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.23.0`

### 🐛 Bug fixes


- Discussion names showing a random value ([#22172](https://github.com/RocketChat/Rocket.Chat/pull/22172))

### 👩‍💻👨‍💻 Core Team 🤓

- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.12.5
`2021-04-20  ·  1 🐛  ·  1 👩‍💻👨‍💻`

### Engine versions
- Node: `12.18.4`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.23.0`

### 🐛 Bug fixes


- Livechat not retrieving messages ([#21644](https://github.com/RocketChat/Rocket.Chat/pull/21644) by [@cuonghuunguyen](https://github.com/cuonghuunguyen))

### 👩‍💻👨‍💻 Contributors 😍

- [@cuonghuunguyen](https://github.com/cuonghuunguyen)

# 3.12.2
`2021-03-26  ·  2 🐛  ·  4 👩‍💻👨‍💻`

### Engine versions
- Node: `12.18.4`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.23.0`

### 🐛 Bug fixes


- Bump Livechat widget

- Security Hotfix (https://docs.rocket.chat/guides/security/security-updates)

### 👩‍💻👨‍💻 Contributors 😍

- [@g-thome](https://github.com/g-thome)

### 👩‍💻👨‍💻 Core Team 🤓

- [@KevLehman](https://github.com/KevLehman)
- [@matheusbsilva137](https://github.com/matheusbsilva137)
- [@sampaiodiego](https://github.com/sampaiodiego)

# 3.12.1
`2021-03-08  ·  1 🚀  ·  2 🐛  ·  3 👩‍💻👨‍💻`

### Engine versions
- Node: `12.18.4`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.23.0`

### 🚀 Improvements


- Close Call contextual bar after starting jitsi call. ([#21004](https://github.com/RocketChat/Rocket.Chat/pull/21004))

  After jitsi call is started, if the call is started in a new window then we should close contextual tab bar.
  So, when 'YES' is pressed on modal, we call handleClose function if openNewWindow is true, as call doesn't starts on tab bar, it starts on new window.

### 🐛 Bug fixes


- Missing spaces on attachment  ([#21020](https://github.com/RocketChat/Rocket.Chat/pull/21020))

- Stopping Jitsi reload ([#20973](https://github.com/RocketChat/Rocket.Chat/pull/20973))

  The Function where Jitsi call is started gets called many times due to `room.usernames` dep of useMemo, this dep triggers reloading of this function many times.
  So removing this dep from useMemo dependencies

### 👩‍💻👨‍💻 Core Team 🤓

- [@dougfabris](https://github.com/dougfabris)
- [@tassoevan](https://github.com/tassoevan)
- [@yash-rajpal](https://github.com/yash-rajpal)

# 3.12.0
`2021-02-28  ·  5 🎉  ·  17 🚀  ·  74 🐛  ·  30 🔍  ·  29 👩‍💻👨‍💻`

### Engine versions
- Node: `12.18.4`
- NPM: `6.14.8`
- MongoDB: `3.4, 3.6, 4.0`
- Apps-Engine: `1.23.0`

### 🎉 New features


- Button to unset Slackbridge's importIds ([#20549](https://github.com/RocketChat/Rocket.Chat/pull/20549))

- Cloud Workspace bridge ([#20838](https://github.com/RocketChat/Rocket.Chat/pull/20838))

  Adds the new CloudWorkspace functionality.

  It allows apps to request the access token for the workspace it's installed on, so it can perform actions with other Rocket.Chat services, such as the Omni Gateway.

  https://github.com/RocketChat/Rocket.Chat.Apps-engine/pull/382

- Header with Breadcrumbs ([#20609](https://github.com/RocketChat/Rocket.Chat/pull/20609))

  ![image](https://user-images.githubusercontent.com/27704687/106945019-1386d400-6706-11eb-90db-c12b50f260d5.png)

- Statistics about language usage ([#20832](https://github.com/RocketChat/Rocket.Chat/pull/20832) by [@g-thome](https://github.com/g-thome))

  track what languages get picked the most as preferred ui language.

- useUserData Hook ([#20584](https://github.com/RocketChat/Rocket.Chat/pull/20584))

### 🚀 Improvements


- Add symbol to indicate apps' required settings in the UI ([#20447](https://github.com/RocketChat/Rocket.Chat/pull/20447))

  - Apps are able to define **required** settings. These settings should not be left blank by the user and an error will be thrown and shown in the interface if an user attempts to save changes in the app details page leaving any required fields blank;
  ![prt_screen_required_app_settings_warning](https://user-images.githubusercontent.com/36537004/106032964-e73cd900-60af-11eb-8eab-c11fd651b593.png)

   - A sign (*) is added to the label of app settings' fields that are required so as to highlight the fields which must not be left blank.
  ![prt_screen_required_app_settings](https://user-images.githubusercontent.com/36537004/106014879-ae473900-609c-11eb-9b9e-95de7bbf20a5.png)

- Add visual validation on users admin forms ([#20308](https://github.com/RocketChat/Rocket.Chat/pull/20308))

- Added auto-focus for better user-experience. ([#19954](https://github.com/RocketChat/Rocket.Chat/pull/19954) by [@Darshilp326](https://github.com/Darshilp326))

- Added disable button check for send invite button ([#20337](https://github.com/RocketChat/Rocket.Chat/pull/20337))

  Added Disable check for send invite button. If the text field is empty button would be disabled, and after any valid email is filled, button would get enabled

- Added key prop, removing unwanted warnings ([#20473](https://github.com/RocketChat/Rocket.Chat/pull/20473))

  Removes warnings listed on the issue

- Added Markdown links to custom status. ([#20470](https://github.com/RocketChat/Rocket.Chat/pull/20470))

  Added markdown links to user's custom status.

- Adds tooltip for sidebar header icons ([#19934](https://github.com/RocketChat/Rocket.Chat/pull/19934) by [@RonLek](https://github.com/RonLek))

  Previously the header icons in the sidebar didn't show a tooltip when hovered over. This PR fixes that.

  ![Screenshot from 2020-12-22 15-17-41](https://user-images.githubusercontent.com/28918901/102874804-f2756700-4468-11eb-8324-b7f3194e62fe.png)

- Better Presentation of Blockquotes ([#20750](https://github.com/RocketChat/Rocket.Chat/pull/20750) by [@aditya-mitra](https://github.com/aditya-mitra))

  Changed the va