import type { AtLeast } from '@rocket.chat/core-typings';

import { getAvatarURL } from '../../../../app/utils/client/getAvatarURL';
import type { IRoomTypeClientDirectives } from '../../../../definition/IRoomTypeConfig';
import { getVoipRoomType } from '../../../../lib/rooms/roomTypes/voip';
import { Rooms } from '../../../stores';
import { roomCoordinator } from '../roomCoordinator';

export const VoipRoomType = getVoipRoomType(roomCoordinator);

roomCoordinator.add(
	{
		...VoipRoomType,
		label: 'Voip',
	},
	{
		roomName(room) {
			return room.name || room.fname || (room as any).label;
		},

		getAvatarPath(room) {
			return getAvatarURL({ username: `@${this.roomName(room)}` }) || '';
		},

		findRoom(identifier) {
			return Rooms.state.get(identifier);
		},

		canSendMessage() {
			return false;
		},

		readOnly() {
			return true;
		},

		getIcon() {
			return 'phone';
		},

		extractOpenRoomParams({ id }) {
			return { type: 'v', reference: id };
		},
	} as AtLeast<IRoomTypeClientDirectives, 'roomName'>,
);
