export enum AppMethod {
	_API_EXECUTOR = 'apiExecutor',
	_CONSTRUCTOR = 'constructor',
	_COMMAND_EXECUTOR = 'executor',
	_COMMAND_PREVIEWER = 'previewer',
	_COMMAND_PREVIEW_EXECUTOR = 'executePreviewItem',
	_JOB_PROCESSOR = 'jobProcessor',
	_VIDEOCONF_GENERATE_URL = 'generateUrl',
	_VIDEOCONF_CUSTOMIZE_URL = 'customizeUrl',
	_VIDEOCONF_IS_CONFIGURED = 'isFullyConfigured',
	_VIDEOCONF_NEW = 'onNewVideoConference',
	_VIDEOCONF_CHANGED = 'onVideoConferenceChanged',
	_VIDEOCONF_USER_JOINED = 'onUserJoin',
	_VIDEOCONF_GET_INFO = 'getVideoConferenceInfo',
	// Outbound communication provider methods
	_OUTBOUND_GET_PROVIDER_METADATA = 'getProviderMetadata',
	_OUTBOUND_SEND_MESSAGE = 'sendOutboundMessage',

	INITIALIZE = 'initialize',
	ONENABLE = 'onEnable',
	ONDISABLE = 'onDisable',
	ONINSTALL = 'onInstall',
	ONUNINSTALL = 'onUninstall',
	ONUPDATE = 'onUpdate',
	ON_PRE_SETTING_UPDATE = 'onPreSettingUpdate',
	ONSETTINGUPDATED = 'onSettingUpdated',
	SETSTATUS = 'setStatus',
	// Message handlers
	CHECKPREMESSAGESENTPREVENT = 'checkPreMessageSentPrevent',
	EXECUTEPREMESSAGESENTPREVENT = 'executePreMessageSentPrevent',
	CHECKPREMESSAGESENTEXTEND = 'checkPreMessageSentExtend',
	EXECUTEPREMESSAGESENTEXTEND = 'executePreMessageSentExtend',
	CHECKPREMESSAGESENTMODIFY = 'checkPreMessageSentModify',
	EXECUTEPREMESSAGESENTMODIFY = 'executePreMessageSentModify',
	CHECKPOSTMESSAGESENT = 'checkPostMessageSent',
	EXECUTEPOSTMESSAGESENT = 'executePostMessageSent',
	EXECUTEPOSTSYSTEMMESSAGESENT = 'executePostSystemMessageSent',

	EXECUTEPOSTMESSAGESENTTOBOT = 'executePostMessageSentToBot',

	CHECKPREMESSAGEDELETEPREVENT = 'checkPreMessageDeletePrevent',
	EXECUTEPREMESSAGEDELETEPREVENT = 'executePreMessageDeletePrevent',
	CHECKPOSTMESSAGEDELETED = 'checkPostMessageDeleted',
	EXECUTEPOSTMESSAGEDELETED = 'executePostMessageDeleted',
	CHECKPREMESSAGEUPDATEDPREVENT = 'checkPreMessageUpdatedPrevent',
	EXECUTEPREMESSAGEUPDATEDPREVENT = 'executePreMessageUpdatedPrevent',
	CHECKPREMESSAGEUPDATEDEXTEND = 'checkPreMessageUpdatedExtend',
	EXECUTEPREMESSAGEUPDATEDEXTEND = 'executePreMessageUpdatedExtend',
	CHECKPREMESSAGEUPDATEDMODIFY = 'checkPreMessageUpdatedModify',
	EXECUTEPREMESSAGEUPDATEDMODIFY = 'executePreMessageUpdatedModify',
	CHECKPOSTMESSAGEUPDATED = 'checkPostMessageUpdated',
	EXECUTEPOSTMESSAGEUPDATED = 'executePostMessageUpdated',
	EXECUTE_POST_MESSAGE_REACTED = 'executePostMessageReacted',
	EXECUTE_POST_MESSAGE_FOLLOWED = 'executePostMessageFollowed',
	EXECUTE_POST_MESSAGE_PINNED = 'executePostMessagePinned',
	EXECUTE_POST_MESSAGE_STARRED = 'executePostMessageStarred',
	EXECUTE_POST_MESSAGE_REPORTED = 'executePostMessageReported',
	// Room handlers
	CHECKPREROOMCREATEPREVENT = 'checkPreRoomCreatePrevent',
	EXECUTEPREROOMCREATEPREVENT = 'executePreRoomCreatePrevent',
	CHECKPREROOMCREATEEXTEND = 'checkPreRoomCreateExtend',
	EXECUTEPREROOMCREATEEXTEND = 'executePreRoomCreateExtend',
	CHECKPREROOMCREATEMODIFY = 'checkPreRoomCreateModify',
	EXECUTEPREROOMCREATEMODIFY = 'executePreRoomCreateModify',
	CHECKPOSTROOMCREATE = 'checkPostRoomCreate',
	EXECUTEPOSTROOMCREATE = 'executePostRoomCreate',
	CHECKPREROOMDELETEPREVENT = 'checkPreRoomDeletePrevent',
	EXECUTEPREROOMDELETEPREVENT = 'executePreRoomDeletePrevent',
	CHECKPOSTROOMDELETED = 'checkPostRoomDeleted',
	EXECUTEPOSTROOMDELETED = 'executePostRoomDeleted',
	EXECUTE_PRE_ROOM_USER_JOINED = 'executePreRoomUserJoined',
	EXECUTE_POST_ROOM_USER_JOINED = 'executePostRoomUserJoined',
	EXECUTE_PRE_ROOM_USER_LEAVE = 'executePreRoomUserLeave',
	EXECUTE_POST_ROOM_USER_LEAVE = 'executePostRoomUserLeave',
	// External Component handlers
	EXECUTEPOSTEXTERNALCOMPONENTOPENED = 'executePostExternalComponentOpened',
	EXECUTEPOSTEXTERNALCOMPONENTCLOSED = 'executePostExternalComponentClosed',
	// Blockit handlers
	UIKIT_BLOCK_ACTION = 'executeBlockActionHandler',
	UIKIT_VIEW_SUBMIT = 'executeViewSubmitHandler',
	UIKIT_VIEW_CLOSE = 'executeViewClosedHandler',
	UIKIT_ACTION_BUTTON = 'executeActionButtonHandler',
	UIKIT_LIVECHAT_BLOCK_ACTION = 'executeLivechatBlockActionHandler',
	// Livechat
	EXECUTE_POST_LIVECHAT_ROOM_STARTED = 'executePostLivechatRoomStarted',
	/**
	 * @deprecated please use the AppMethod.EXECUTE_POST_LIVECHAT_ROOM_CLOSED method
	 */
	EXECUTE_LIVECHAT_ROOM_CLOSED_HANDLER = 'executeLivechatRoomClosedHandler',
	EXECUTE_PRE_LIVECHAT_ROOM_CREATE_PREVENT = 'executeLivechatRoomCreatePrevent',
	EXECUTE_POST_LIVECHAT_ROOM_CLOSED = 'executePostLivechatRoomClosed',
	EXECUTE_POST_LIVECHAT_AGENT_ASSIGNED = 'executePostLivechatAgentAssigned',
	EXECUTE_POST_LIVECHAT_AGENT_UNASSIGNED = 'executePostLivechatAgentUnassigned',
	EXECUTE_POST_LIVECHAT_ROOM_TRANSFERRED = 'executePostLivechatRoomTransferred',
	EXECUTE_POST_LIVECHAT_GUEST_SAVED = 'executePostLivechatGuestSaved',
	EXECUTE_POST_LIVECHAT_ROOM_SAVED = 'executePostLivechatRoomSaved',
	EXECUTE_POST_LIVECHAT_DEPARTMENT_DISABLED = 'executePostLivechatDepartmentDisabled',
	EXECUTE_POST_LIVECHAT_DEPARTMENT_REMOVED = 'executePostLivechatDepartmentRemoved',
	// FileUpload
	EXECUTE_PRE_FILE_UPLOAD = 'executePreFileUpload',
	// Email
	EXECUTE_PRE_EMAIL_SENT = 'executePreEmailSent',
	// User
	EXECUTE_POST_USER_CREATED = 'executePostUserCreated',
	EXECUTE_POST_USER_UPDATED = 'executePostUserUpdated',
	EXECUTE_POST_USER_DELETED = 'executePostUserDeleted',
	EXECUTE_POST_USER_LOGGED_IN = 'executePostUserLoggedIn',
	EXECUTE_POST_USER_LOGGED_OUT = 'executePostUserLoggedOut',
	EXECUTE_POST_USER_STATUS_CHANGED = 'executePostUserStatusChanged',
	// Runtime specific methods
	RUNTIME_RESTART = 'runtime:restart',
	RUNTIME_UNCAUGHT_EXCEPTION = 'runtime:uncaughtException',
	RUNTIME_UNHANDLED_REJECTION = 'runtime:unhandledRejection',
}
